/*
 * Decompiled with CFR 0.152.
 */
package zingg.util;

public class ConsoleStringBuilder {
    private String string = "";

    public ConsoleStringBuilder resetHidden() {
        return this.resetHidden("");
    }

    public ConsoleStringBuilder resetHidden(String value) {
        this.ansi(Integer.toString(28));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder resetInvertColors() {
        return this.resetInvertColors("");
    }

    public ConsoleStringBuilder resetInvertColors(String value) {
        this.ansi(Integer.toString(27));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder resetBlink() {
        return this.resetBlink("");
    }

    public ConsoleStringBuilder resetBlink(String value) {
        this.ansi(Integer.toString(25));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder resetUnderline() {
        return this.resetUnderline("");
    }

    public ConsoleStringBuilder resetUnderline(String value) {
        this.ansi(Integer.toString(24));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder resetDim() {
        return this.resetDim("");
    }

    public ConsoleStringBuilder resetDim(String value) {
        this.ansi(Integer.toString(22));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder resetBold() {
        return this.resetBold("");
    }

    public ConsoleStringBuilder resetBold(String value) {
        this.ansi(Integer.toString(21));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder reset() {
        return this.reset("");
    }

    public ConsoleStringBuilder reset(String value) {
        this.ansi(Integer.toString(0));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder hide() {
        return this.hide("");
    }

    public ConsoleStringBuilder hide(String value) {
        this.ansi(Integer.toString(8));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder invertColor() {
        return this.invertColor("");
    }

    public ConsoleStringBuilder invertColor(String value) {
        this.ansi(Integer.toString(7));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder blink() {
        return this.blink("");
    }

    public ConsoleStringBuilder blink(String value) {
        this.ansi(Integer.toString(5));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder underline() {
        return this.underline("");
    }

    public ConsoleStringBuilder underline(String value) {
        this.ansi(Integer.toString(4));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder dim() {
        return this.dim("");
    }

    public ConsoleStringBuilder dim(String value) {
        this.ansi(Integer.toString(2));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder bold() {
        return this.bold("");
    }

    public ConsoleStringBuilder bold(String value) {
        this.ansi(Integer.toString(1));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder color16(Color16 color) {
        return this.color16(color, "");
    }

    public ConsoleStringBuilder color16(Color16 color, String value) {
        this.ansi(Integer.toString(color.getValue()));
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder color256(int color) throws Exception {
        return this.color256(color, "");
    }

    public ConsoleStringBuilder color256(int color, String value) throws Exception {
        if (color < 0 || color > 256) {
            throw new Exception("Valid 256-bit colors must be within the range of 0 and 256.");
        }
        this.ansi("38;5;" + color);
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder backgroundColor256(int color) throws Exception {
        return this.backgroundColor256(color, "");
    }

    public ConsoleStringBuilder backgroundColor256(int color, String value) throws Exception {
        if (color < 0 || color > 256) {
            throw new Exception("Valid 256-bit colors must be within the range of 0 and 256.");
        }
        this.ansi("48;5;" + color);
        this.raw(value);
        return this;
    }

    public ConsoleStringBuilder raw(String value) {
        this.string = this.string + value;
        return this;
    }

    public ConsoleStringBuilder ansi(String value) {
        this.string = this.string + "\u001b[" + value + "m";
        return this;
    }

    public String toString() {
        this.reset();
        return this.string;
    }

    public static enum Color16 {
        FG_RESET(39),
        FG_BLACK(30),
        FG_RED(31),
        FG_GREEN(32),
        FG_YELLOW(33),
        FG_BLUE(34),
        FG_MAGENTA(35),
        FG_CYAN(36),
        FG_LIGHT_GRAY(37),
        FG_DARK_GRAY(90),
        FG_LIGHT_RED(91),
        FG_LIGHT_GREEN(92),
        FG_LIGHT_YELLOW(93),
        FG_LIGHT_BLUE(94),
        FG_LIGHT_MAGENTA(95),
        FG_LIGHT_CYAN(96),
        FG_WHITE(97),
        BG_RESET(49),
        BG_BLACK(40),
        BG_RED(41),
        BG_GREEN(42),
        BG_YELLOW(43),
        BG_BLUE(44),
        BG_MAGENTA(45),
        BG_CYAN(46),
        BG_LIGHT_GRAY(47),
        BG_DARK_GRAY(100),
        BG_LIGHT_RED(101),
        BG_LIGHT_GREEN(102),
        BG_LIGHT_YELLOW(103),
        BG_LIGHT_BLUE(104),
        BG_LIGHT_MAGENTA(105),
        BG_LIGHT_CYAN(106),
        BG_WHITE(107);

        private int value;

        public int getValue() {
            return this.value;
        }

        private Color16(int value) {
            this.value = value;
        }
    }
}

