/*
 * Decompiled with CFR 0.152.
 */
package zingg.stat;

import com.google.common.collect.Ordering;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import zingg.client.MatchType;
import zingg.stat.Stat;

public abstract class BaseStat<E>
implements Stat<E> {
    public static final Log LOG = LogFactory.getLog(BaseStat.class);
    public int numberOfNulls;
    public E min;
    public E max;
    public int length;
    public Ordering<E> comparator;
    public MatchType fieldType;

    public BaseStat(int numberOfNulls, E min, E max, int length, MatchType f, Ordering<E> comp) {
        this.numberOfNulls = numberOfNulls;
        this.min = min;
        this.max = max;
        this.length = length;
        this.fieldType = f;
        this.comparator = comp;
    }

    public int getNumberOfNulls() {
        return this.numberOfNulls;
    }

    public void setNumberOfNulls(int numberOfNulls) {
        this.numberOfNulls = numberOfNulls;
    }

    public E getMin() {
        return this.min;
    }

    public void setMin(E min) {
        this.min = min;
    }

    public E getMax() {
        return this.max;
    }

    public void setMax(E max) {
        this.max = max;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Ordering<E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Ordering<E> comp) {
        this.comparator = comp;
    }

    @Override
    public MatchType getFieldType() {
        return this.fieldType;
    }

    @Override
    public void setFieldType(MatchType f) {
        this.fieldType = f;
    }

    public void statVisit(E a) {
        if (a == null) {
            ++this.numberOfNulls;
        } else {
            this.max = this.comparator.max(a, this.max);
            this.min = this.comparator.min(a, this.min);
        }
    }
}

