/*
 * Decompiled with CFR 0.152.
 */
package zingg.similarity.function;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import zingg.similarity.function.StringSimilarityFunction;

public class ProductCodeFunction
extends StringSimilarityFunction {
    public static final Log LOG = LogFactory.getLog(ProductCodeFunction.class);

    public ProductCodeFunction() {
        this("ProductCodeFunction");
    }

    public ProductCodeFunction(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double call(String first, String second) {
        double score1 = 0.0;
        double score2 = 0.0;
        double score = 0.0;
        try {
            Matcher m;
            if (first != null && !first.equals("")) {
                score1 = 1.0;
            }
            if (second != null && !second.equals("")) {
                score2 = 1.0;
            }
            HashSet<String> num1 = new HashSet<String>();
            HashSet<String> num2 = new HashSet<String>();
            Pattern p = Pattern.compile("\\s[a-zA-Z]{0,4}\\s\\d+\\s([a-zA-Z]{0,4}\\s)?|(\\s?([a-z0-9A-Z]*\\d+(\\.\\d+)?[a-z0-9A-Z]*)\\s?)");
            if (score1 == 1.0) {
                m = p.matcher(first);
                while (m.find()) {
                    num1.add(m.group().toLowerCase().replaceAll(" ", ""));
                    score1 += 1.0;
                }
            }
            if (score2 == 1.0) {
                m = p.matcher(second);
                while (m.find()) {
                    num2.add(m.group().toLowerCase().replaceAll(" ", ""));
                    score2 += 1.0;
                }
            }
            if (num1.size() > 0 && num2.size() > 0) {
                int union = num1.size() + num2.size();
                num1.retainAll(num2);
                int intersection = num1.size();
                score = (double)intersection * 1.0 / (double)(union - intersection);
            }
            if (num1.size() == 0) {
                if (num2.size() == 0) {
                    score = 1.0;
                    return score;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error processing differences for " + first + "," + second);
        }
        finally {
            if (Double.isNaN(score)) {
                score = 0.0;
            }
            return score;
        }
    }
}

