/*
 * Decompiled with CFR 0.152.
 */
package zingg.similarity.function;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import zingg.similarity.function.SJacc;
import zingg.similarity.function.StringSimilarityDistanceFunction;

public class NumbersJaccardFunction
extends StringSimilarityDistanceFunction {
    public static final Log LOG = LogFactory.getLog(NumbersJaccardFunction.class);

    public NumbersJaccardFunction() {
        super("JaccSimFunction");
        this.gap = new SJacc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double call(String first, String second) {
        double score1 = 0.0;
        double score2 = 0.0;
        double score = 0.0;
        try {
            Matcher m;
            if (first != null && !first.equals("")) {
                score1 = 1.0;
            }
            if (second != null && !second.equals("")) {
                score2 = 1.0;
            }
            HashSet<String> num1 = new HashSet<String>();
            HashSet<String> num2 = new HashSet<String>();
            Pattern p = Pattern.compile("\\d+");
            if (score1 == 1.0) {
                m = p.matcher(first);
                while (m.find()) {
                    num1.add(m.group().toLowerCase());
                    score1 += 1.0;
                }
            }
            if (score2 == 1.0) {
                m = p.matcher(second);
                while (m.find()) {
                    num2.add(m.group().toLowerCase());
                    score2 += 1.0;
                }
            }
            if (num1.size() > 0 && num2.size() > 0) {
                LOG.debug("Found codes " + num1 + " in " + first);
                LOG.debug("Found codes " + num2 + " in " + second);
                int union = num1.size() + num2.size();
                num1.retainAll(num2);
                int intersection = num1.size();
                score = (double)intersection * 1.0 / (double)(union - intersection);
                LOG.debug("Score explanation for : " + first + " and :" + second + "is - intersection: " + intersection + " and union: " + union + " and score: " + score);
                LOG.debug("Score for : " + first + " and :" + second + "is - score1: " + score1 + " and score2: " + score2);
            } else {
                LOG.debug("No data found");
            }
        }
        catch (Exception e) {
            LOG.warn("Error processing differences for " + first + "," + second);
        }
        finally {
            if (Double.isNaN(score)) {
                score = 0.0;
            }
            if (score1 > 1.0) {
                score1 = 1.0;
            } else {
                score = 0.0;
            }
            if (score2 > 1.0) {
                score2 = 1.0;
            } else {
                score = 0.0;
            }
            LOG.debug("Now Score for : " + first + " and :" + second + "is - score1: " + score1 + " and score2: " + score2);
        }
        return score;
    }
}

