/*
 * Decompiled with CFR 0.152.
 */
package zingg.similarity.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import zingg.similarity.function.BaseSimilarityFunction;

public class DoubleSimilarityFunction
extends BaseSimilarityFunction<Double> {
    public static final Log LOG = LogFactory.getLog(DoubleSimilarityFunction.class);

    public DoubleSimilarityFunction() {
        super("DoubleSimilarityFunction");
    }

    public Double call(Double first, Double second) {
        if (first == null || first.isNaN()) {
            return 1.0;
        }
        if (second == null || second.isNaN()) {
            return 1.0;
        }
        double score = 1.0 - Math.abs(first - second) / (1.0 + first + second);
        LOG.debug(" DoubleSim bw " + first + " and second " + second + " is " + score);
        return score;
    }
}

