/*
 * Decompiled with CFR 0.152.
 */
package zingg.similarity.function;

import com.wcohen.ss.Jaccard;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.BasicToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BigramJaccard
extends Jaccard
implements Serializable {
    public static final Log LOG = LogFactory.getLog(BigramJaccard.class);

    public BigramJaccard() {
        this(new BigramTokenizer(true, true));
    }

    public BigramJaccard(Tokenizer t) {
        super(t);
    }

    public static class BToken
    implements Token,
    Comparable {
        protected final int index;
        protected final String value;

        BToken(int index, String value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public int compareTo(Object o) {
            Token t = (Token)o;
            return this.index - t.getIndex();
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "[tok " + this.getIndex() + ":" + this.getValue() + "]";
        }
    }

    public static class BigramTokenizer
    implements Tokenizer {
        private boolean ignorePunctuation = true;
        private boolean ignoreCase = true;
        private int nextId = 0;
        private Map tokMap = new TreeMap();

        public BigramTokenizer(boolean ignorePunctuation, boolean ignoreCase) {
            this.ignorePunctuation = ignorePunctuation;
            this.ignoreCase = ignoreCase;
        }

        public void setIgnorePunctuation(boolean flag) {
            this.ignorePunctuation = flag;
        }

        public void setIgnoreCase(boolean flag) {
            this.ignoreCase = flag;
        }

        public String toString() {
            return "[BigramTokenizer " + this.ignorePunctuation + ";" + this.ignoreCase + "]";
        }

        @Override
        public Token[] tokenize(String input) {
            ArrayList<String> tokens = new ArrayList<String>();
            input = input.replaceAll("\\s+", "");
            LOG.debug("Input is " + input);
            for (int cursor = 0; cursor < input.length() - 2; ++cursor) {
                tokens.add(input.substring(cursor, cursor + 1));
            }
            return tokens.toArray(new BasicToken[tokens.size()]);
        }

        private Token internSomething(String s) {
            return this.intern(this.ignoreCase ? s.toLowerCase() : s);
        }

        @Override
        public Token intern(String s) {
            Token tok = (Token)this.tokMap.get(s);
            if (tok == null) {
                tok = new BToken(++this.nextId, s);
                this.tokMap.put(s, tok);
            }
            return tok;
        }

        @Override
        public Iterator tokenIterator() {
            return this.tokMap.values().iterator();
        }

        @Override
        public int maxTokenIndex() {
            return this.nextId;
        }
    }
}

