/*
 * Decompiled with CFR 0.152.
 */
package zingg.similarity.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public abstract class BaseTransformer
extends Transformer
implements HasInputCol,
HasOutputCol {
    Param<String> inputcol = new Param((Identifiable)this, "inputCol", "input column name");
    Param<String> outputcol = new Param((Identifiable)this, "outputCol", "output column name");
    protected String name;
    protected String uid;
    public static final Log LOG = LogFactory.getLog(BaseTransformer.class);

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getInputCol() {
        return (String)this.get(this.inputcol).get();
    }

    public void setInputCol(String inputColumn) {
        this.set(this.inputcol, inputColumn);
    }

    public String getOutputCol() {
        return (String)this.get(this.outputcol).get();
    }

    public void setOutputCol(String outputColumn) {
        this.set(this.outputcol, outputColumn);
    }

    public Dataset<Row> transform(Dataset<?> ds) {
        this.transformSchema(ds.schema());
        return ds.withColumn(this.getOutputCol(), functions.callUDF((String)this.uid, (Column[])new Column[]{ds.col(this.getInputCol()), ds.col("z_" + this.getInputCol())}));
    }

    public StructType transformSchema(StructType structType) {
        return structType.add(this.getOutputCol(), DataTypes.DoubleType, true);
    }

    public BaseTransformer copy(ParamMap paramMap) {
        LOG.debug("Copying params for " + this.uid);
        paramMap.put(this.inputcol, this.get(this.inputcol).get());
        paramMap.put(this.outputcol, this.get(this.outputcol).get());
        return (BaseTransformer)this.defaultCopy(paramMap);
    }

    public String uid() {
        return this.getUid();
    }

    public String getUid() {
        if (this.uid == null) {
            this.uid = Identifiable$.MODULE$.randomUID(this.name);
        }
        return this.uid;
    }

    public Param<String> inputCol() {
        return this.inputcol;
    }

    public Param<String> outputCol() {
        return this.outputcol;
    }

    public void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param param) {
        this.inputcol = param;
    }

    public void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param param) {
        this.outputcol = param;
    }

    public BaseTransformer() {
    }

    public BaseTransformer(String name) {
        this.name = name;
    }

    public void register(SparkSession spark) {
        spark.udf().register(this.uid, (UDF2)this, DataTypes.DoubleType);
    }
}

