/*
 * Decompiled with CFR 0.152.
 */
package zingg.model;

import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import zingg.similarity.function.BaseTransformer;

public class VectorValueExtractor
extends BaseTransformer
implements UDF1<Vector, Double> {
    public Double call(Vector v) {
        return v.toArray()[1];
    }

    @Override
    public void register(SparkSession spark) {
        spark.udf().register(this.uid, (UDF1)this, DataTypes.DoubleType);
    }

    @Override
    public String getUid() {
        if (this.uid == null) {
            this.uid = Identifiable$.MODULE$.randomUID("VectorValueExtractor");
        }
        return this.uid;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> ds) {
        LOG.debug("transforming dataset for " + this.uid);
        this.transformSchema(ds.schema());
        return ds.withColumn(this.getOutputCol(), functions.callUDF((String)this.uid, (Column[])new Column[]{ds.col(this.getInputCol())}));
    }
}

