/*
 * Decompiled with CFR 0.152.
 */
package zingg.hash;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.types.DataTypes;
import zingg.hash.HashFunction;

public class TruncateDouble
extends HashFunction
implements UDF1<Double, Double> {
    int numDecimalPlaces;
    static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000};

    public TruncateDouble(int numDecimalPlaces) {
        super("truncateDoubleTo" + numDecimalPlaces + "Places", DataTypes.DoubleType, DataTypes.DoubleType, true);
        this.numDecimalPlaces = numDecimalPlaces;
    }

    public Double call(Double field) {
        Double r = null;
        r = field == null ? field : Double.valueOf(Math.floor(field * (double)POWERS_OF_10[this.numDecimalPlaces]) / (double)POWERS_OF_10[this.numDecimalPlaces]);
        return r;
    }

    @Override
    public Object apply(Row ds, String column) {
        return this.call((Double)ds.getAs(column));
    }
}

