/*
 * Decompiled with CFR 0.152.
 */
package zingg.hash;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.types.DataTypes;
import zingg.hash.HashFunction;

public class RangeDbl
extends HashFunction
implements UDF1<Double, Integer> {
    int lowerLimit;
    int upperLimit;

    public RangeDbl(int lower, int upper) {
        super("rangeBetween" + lower + "And" + upper + "Dbl", DataTypes.DoubleType, DataTypes.IntegerType, true);
        this.lowerLimit = lower;
        this.upperLimit = upper;
    }

    public Integer call(Double field) {
        int withinRange = 0;
        if (field != null && field >= (double)this.lowerLimit && field < (double)this.upperLimit) {
            withinRange = 1;
        }
        return withinRange;
    }

    @Override
    public Object apply(Row ds, String column) {
        return this.call((Double)ds.getAs(column));
    }
}

