/*
 * Decompiled with CFR 0.152.
 */
package zingg.hash;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.types.DataTypes;
import zingg.hash.HashFunction;

public class LastChars
extends HashFunction
implements UDF1<String, String> {
    int numChars;

    public LastChars(int endIndex) {
        super("last" + endIndex + "Chars", DataTypes.StringType, DataTypes.StringType, true);
        this.numChars = endIndex;
    }

    public String call(String field) {
        String r = null;
        if (field == null) {
            r = field;
        } else {
            field = field.trim().toLowerCase();
            r = field.trim().toLowerCase().substring(Math.max(field.length() - this.numChars, 0));
        }
        return r;
    }

    @Override
    public Object apply(Row ds, String column) {
        return this.call((String)ds.getAs(column));
    }
}

