/*
 * Decompiled with CFR 0.152.
 */
package zingg.hash;

import java.util.HashMap;
import zingg.hash.First1Chars;
import zingg.hash.First2Chars;
import zingg.hash.First2CharsBox;
import zingg.hash.First3Chars;
import zingg.hash.First3CharsBox;
import zingg.hash.First4Chars;
import zingg.hash.HashFunction;
import zingg.hash.IdentityInteger;
import zingg.hash.IdentityString;
import zingg.hash.IsNullOrEmpty;
import zingg.hash.Last1Chars;
import zingg.hash.Last2Chars;
import zingg.hash.Last3Chars;
import zingg.hash.LastWord;
import zingg.hash.LessThanZeroDbl;
import zingg.hash.LessThanZeroInt;
import zingg.hash.RangeBetween0And10Dbl;
import zingg.hash.RangeBetween0And10Int;
import zingg.hash.RangeBetween1000And10000Dbl;
import zingg.hash.RangeBetween1000And10000Int;
import zingg.hash.RangeBetween100And1000Dbl;
import zingg.hash.RangeBetween100And1000Int;
import zingg.hash.RangeBetween10And100Dbl;
import zingg.hash.RangeBetween10And100Int;
import zingg.hash.Round;
import zingg.hash.TrimLast1DigitDbl;
import zingg.hash.TrimLast1DigitInt;
import zingg.hash.TrimLast2DigitsDbl;
import zingg.hash.TrimLast2DigitsInt;
import zingg.hash.TrimLast3DigitsDbl;
import zingg.hash.TrimLast3DigitsInt;
import zingg.hash.TruncateDoubleTo1Place;
import zingg.hash.TruncateDoubleTo2Places;
import zingg.hash.TruncateDoubleTo3Places;

public class HashFunctionRegistry {
    public static HashMap<String, HashFunction> fns = new HashMap();

    public static HashFunction getFunction(String key) {
        return fns.get(key);
    }

    public static void init(HashFunction fn) {
        fns.put(fn.getName(), fn);
    }

    static {
        HashFunctionRegistry.init(new IdentityString());
        HashFunctionRegistry.init(new IdentityInteger());
        HashFunctionRegistry.init(new First1Chars());
        HashFunctionRegistry.init(new First2Chars());
        HashFunctionRegistry.init(new First3Chars());
        HashFunctionRegistry.init(new First4Chars());
        HashFunctionRegistry.init(new Last1Chars());
        HashFunctionRegistry.init(new Last2Chars());
        HashFunctionRegistry.init(new Last3Chars());
        HashFunctionRegistry.init(new Round());
        HashFunctionRegistry.init(new TruncateDoubleTo1Place());
        HashFunctionRegistry.init(new TruncateDoubleTo2Places());
        HashFunctionRegistry.init(new TruncateDoubleTo3Places());
        HashFunctionRegistry.init(new LastWord());
        HashFunctionRegistry.init(new First2CharsBox());
        HashFunctionRegistry.init(new First3CharsBox());
        HashFunctionRegistry.init(new IsNullOrEmpty());
        HashFunctionRegistry.init(new LessThanZeroDbl());
        HashFunctionRegistry.init(new LessThanZeroInt());
        HashFunctionRegistry.init(new TrimLast1DigitDbl());
        HashFunctionRegistry.init(new TrimLast2DigitsDbl());
        HashFunctionRegistry.init(new TrimLast3DigitsDbl());
        HashFunctionRegistry.init(new TrimLast1DigitInt());
        HashFunctionRegistry.init(new TrimLast2DigitsInt());
        HashFunctionRegistry.init(new TrimLast3DigitsInt());
        HashFunctionRegistry.init(new RangeBetween0And10Int());
        HashFunctionRegistry.init(new RangeBetween10And100Int());
        HashFunctionRegistry.init(new RangeBetween100And1000Int());
        HashFunctionRegistry.init(new RangeBetween1000And10000Int());
        HashFunctionRegistry.init(new RangeBetween0And10Dbl());
        HashFunctionRegistry.init(new RangeBetween10And100Dbl());
        HashFunctionRegistry.init(new RangeBetween100And1000Dbl());
        HashFunctionRegistry.init(new RangeBetween1000And10000Dbl());
    }
}

