/*
 * Decompiled with CFR 0.152.
 */
package zingg.feature;

import zingg.client.FieldDefinition;
import zingg.client.MatchType;
import zingg.feature.BaseFeature;
import zingg.similarity.function.AffineGapSimilarityFunction;
import zingg.similarity.function.CheckBlankOrNullFunction;
import zingg.similarity.function.EmailMatchTypeFunction;
import zingg.similarity.function.JaccSimFunction;
import zingg.similarity.function.JaroWinklerFunction;
import zingg.similarity.function.NumbersJaccardFunction;
import zingg.similarity.function.OnlyAlphabetsAffineGapSimilarity;
import zingg.similarity.function.OnlyAlphabetsExactSimilarity;
import zingg.similarity.function.PinCodeMatchTypeFunction;
import zingg.similarity.function.ProductCodeFunction;
import zingg.similarity.function.StringSimilarityFunction;

public class StringFeature
extends BaseFeature<String> {
    @Override
    public void init(FieldDefinition f) {
        this.setFieldDefinition(f);
        if (f.getMatchType().contains(MatchType.FUZZY)) {
            this.addSimFunction(new AffineGapSimilarityFunction());
            this.addSimFunction(new JaroWinklerFunction());
        }
        if (f.getMatchType().contains(MatchType.TEXT)) {
            this.addSimFunction(new JaccSimFunction());
        }
        if (f.getMatchType().contains(MatchType.NUMERIC)) {
            this.addSimFunction(new NumbersJaccardFunction());
        }
        if (f.getMatchType().contains(MatchType.EXACT)) {
            this.addSimFunction(new StringSimilarityFunction());
        }
        if (f.getMatchType().contains(MatchType.PINCODE)) {
            this.addSimFunction(new PinCodeMatchTypeFunction());
        }
        if (f.getMatchType().contains(MatchType.EMAIL)) {
            this.addSimFunction(new EmailMatchTypeFunction());
        }
        if (f.getMatchType().contains(MatchType.NUMERIC_WITH_UNITS)) {
            this.addSimFunction(new ProductCodeFunction());
        }
        if (f.getMatchType().contains(MatchType.NULL_OR_BLANK)) {
            this.addSimFunction(new CheckBlankOrNullFunction());
        }
        if (f.getMatchType().contains(MatchType.ONLY_ALPHABETS_FUZZY)) {
            this.addSimFunction(new OnlyAlphabetsAffineGapSimilarity());
        }
        if (f.getMatchType().contains(MatchType.ONLY_ALPHABETS_EXACT)) {
            this.addSimFunction(new OnlyAlphabetsExactSimilarity());
        }
    }
}

