/*
 * Decompiled with CFR 0.152.
 */
package zingg.documenter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import zingg.client.Arguments;
import zingg.client.ZinggClientException;
import zingg.documenter.DocumenterBase;
import zingg.documenter.ModelColDocumenter;
import zingg.util.PipeUtil;

public class ModelDocumenter
extends DocumenterBase {
    protected static String name = "zingg.ModelDocumenter";
    public static final Log LOG = LogFactory.getLog(ModelDocumenter.class);
    private final String MODEL_TEMPLATE = "model.ftlh";
    ModelColDocumenter modelColDoc;
    protected Dataset<Row> markedRecords;

    public ModelDocumenter(SparkSession spark, Arguments args) {
        super(spark, args);
        this.markedRecords = spark.emptyDataFrame();
        this.modelColDoc = new ModelColDocumenter(spark, args);
    }

    public void process() throws ZinggClientException {
        this.createModelDocument();
        this.modelColDoc.process(this.markedRecords);
    }

    protected void createModelDocument() throws ZinggClientException {
        try {
            LOG.info("Model document generation starts");
            try {
                this.markedRecords = PipeUtil.read(this.spark, false, false, PipeUtil.getTrainingDataMarkedPipe(this.args));
            }
            catch (ZinggClientException e) {
                LOG.warn("No marked record has been found");
            }
            Map<String, Object> root = this.populateTemplateData();
            this.writeModelDocument(root);
            LOG.info("Model document generation finishes");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZinggClientException(e.getMessage());
        }
    }

    private void writeModelDocument(Map<String, Object> root) throws ZinggClientException {
        this.checkAndCreateDir(this.args.getZinggDocDir());
        this.writeDocument("model.ftlh", root, this.args.getZinggModelDocFile());
    }

    protected Map<String, Object> populateTemplateData() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("modelId", this.args.getModelId());
        if (!this.markedRecords.isEmpty()) {
            this.markedRecords = this.markedRecords.cache();
            root.put("clusters", this.markedRecords.collectAsList());
            root.put("numColumns", this.markedRecords.columns().length);
            root.put("columns", this.markedRecords.columns());
            root.put("isMatchColumnIndex", this.markedRecords.schema().fieldIndex("z_isMatch"));
            root.put("clusterColumnIndex", this.markedRecords.schema().fieldIndex("z_cluster"));
        } else {
            List columnList = this.args.getFieldDefinition().stream().map(fd -> fd.getFieldName()).collect(Collectors.toList());
            root.put("numColumns", columnList.size());
            root.put("columns", columnList.toArray());
            root.put("clusters", Collections.emptyList());
            root.put("isMatchColumnIndex", 0);
            root.put("clusterColumnIndex", 1);
        }
        return root;
    }
}

