/*
 * Decompiled with CFR 0.152.
 */
package zingg.documenter;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import zingg.client.Arguments;
import zingg.client.ZinggClientException;
import zingg.documenter.DocumenterBase;

public class ModelColDocumenter
extends DocumenterBase {
    protected static String name = "zingg.ModelColDocumenter";
    public static final Log LOG = LogFactory.getLog(ModelColDocumenter.class);
    private final String COLUMN_DOC_TEMPLATE = "columnDocTemplate.ftlh";
    private final String Z_COLUMN_TEMPLATE = "zColumnTemplate.ftlh";

    public ModelColDocumenter(SparkSession spark, Arguments args) {
        super(spark, args);
    }

    public void process(Dataset<Row> data) throws ZinggClientException {
        this.createColumnDocuments(data);
    }

    private void createColumnDocuments(Dataset<Row> data) throws ZinggClientException {
        LOG.info("Column Documents generation starts");
        if (!data.isEmpty()) {
            String columnsDir = this.args.getZinggDocDir();
            this.checkAndCreateDir(columnsDir);
            for (StructField field : data.schema().fields()) {
                this.prepareAndWriteColumnDocument(field.name(), columnsDir);
            }
        }
        LOG.info("Column Documents generation finishes");
    }

    private void prepareAndWriteColumnDocument(String fieldName, String columnsDir) throws ZinggClientException {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("title", fieldName);
        root.put("modelId", this.args.getModelId());
        String filenameHTML = columnsDir + fieldName + ".html";
        if (this.isZColumn(fieldName)) {
            this.writeDocument("zColumnTemplate.ftlh", root, filenameHTML);
        } else {
            this.writeDocument("columnDocTemplate.ftlh", root, filenameHTML);
        }
    }
}

