/*
 * Decompiled with CFR 0.152.
 */
package zingg.documenter;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.spark.sql.SparkSession;
import zingg.client.Arguments;
import zingg.client.ZinggClientException;
import zingg.util.RowWrapper;

class DocumenterBase {
    protected static Configuration config;
    protected SparkSession spark;
    protected Arguments args;

    public DocumenterBase(SparkSession spark, Arguments args) {
        this.spark = spark;
        this.args = args;
        config = this.createConfigurationObject();
    }

    public Configuration getTemplateConfig() {
        if (config == null) {
            config = this.createConfigurationObject();
        }
        return config;
    }

    private Configuration createConfigurationObject() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);
        cfg.setClassForTemplateLoading(this.getClass(), "/");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setObjectWrapper(new RowWrapper(cfg.getIncompatibleImprovements()));
        return cfg;
    }

    protected void writeDocument(String template, Map<String, Object> root, String fileName) throws ZinggClientException {
        try {
            Configuration cfg = this.getTemplateConfig();
            Template temp = cfg.getTemplate(template);
            FileWriter file = new FileWriter(new File(fileName));
            temp.process(root, file);
            ((Writer)file).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZinggClientException(e.getMessage());
        }
    }

    protected void checkAndCreateDir(String dirName) {
        File directory = new File(dirName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public boolean isZColumn(String colName) {
        return colName.startsWith("z_");
    }
}

