/*
 * Decompiled with CFR 0.152.
 */
package zingg.documenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import zingg.client.Arguments;
import zingg.client.ZinggClientException;
import zingg.documenter.DocumenterBase;
import zingg.util.PipeUtil;

public class DataDocumenter
extends DocumenterBase {
    protected static String name = "zingg.DataDocumenter";
    protected static String TEMPLATE_TITLE = "Data Documentation";
    private final String DATA_DOC_TEMPLATE = "dataDocTemplate.ftlh";
    public static final Log LOG = LogFactory.getLog(DataDocumenter.class);
    protected Dataset<Row> data;

    public DataDocumenter(SparkSession spark, Arguments args) {
        super(spark, args);
        this.data = spark.emptyDataFrame();
    }

    public void process() throws ZinggClientException {
        try {
            LOG.info("Data document generation starts");
            try {
                this.data = PipeUtil.read(this.spark, false, false, this.args.getData());
                LOG.info("Read input data : " + this.data.count());
            }
            catch (ZinggClientException e) {
                LOG.warn("No data has been found");
            }
            if (!this.data.isEmpty()) {
                this.createDataDocument();
            } else {
                LOG.info("No data document generated");
            }
            LOG.info("Data document generation finishes");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZinggClientException(e.getMessage());
        }
    }

    protected void createDataDocument() throws ZinggClientException {
        if (!this.data.isEmpty()) {
            Map<String, Object> root = this.populateTemplateData();
            this.writeMoelDocument(root);
        }
    }

    protected void writeMoelDocument(Map<String, Object> root) throws ZinggClientException {
        this.writeDocument("dataDocTemplate.ftlh", root, this.args.getZinggDataDocFile());
    }

    protected Map<String, Object> populateTemplateData() {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("title", TEMPLATE_TITLE);
        root.put("modelId", this.args.getModelId());
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (StructField field : this.data.schema().fields()) {
            String[] row = new String[]{field.name(), field.dataType().toString(), field.nullable() ? "true" : "false"};
            list.add(row);
        }
        root.put("dataFieldsList", list);
        return root;
    }
}

