/*
 * Decompiled with CFR 0.152.
 */
package zingg.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CliUtils {
    private static boolean leftJustifiedRows = false;
    private static int maxColumnWidth = 50;

    public static void formatIntoTable(List<String[]> table) {
        List<String[]> finalTable = CliUtils.prepareColumnTexts(table, maxColumnWidth);
        Map<Integer, Integer> columnLengths = CliUtils.calculateColumnsLength(finalTable);
        StringBuilder formatString = CliUtils.buildFormatString(columnLengths);
        String line = CliUtils.buildDemarcationLine(columnLengths);
        System.out.print(line);
        table.stream().limit(1L).forEach(a -> System.out.printf(formatString.toString(), a));
        System.out.print(line);
        finalTable.stream().forEach(a -> System.out.printf(formatString.toString(), a));
        System.out.print(line);
    }

    private static List<String[]> prepareColumnTexts(List<String[]> table, int maxColumnWidth) {
        ArrayList<String[]> finalTableList = new ArrayList<String[]>();
        for (String[] row : table) {
            boolean needExtraRow = false;
            int splitRow = 0;
            do {
                needExtraRow = false;
                String[] newRow = new String[row.length];
                for (int i = 0; i < row.length; ++i) {
                    if (row[i] != null) {
                        if (row[i].length() < maxColumnWidth) {
                            newRow[i] = splitRow == 0 ? row[i] : "";
                            continue;
                        }
                        if (row[i].length() > splitRow * maxColumnWidth) {
                            int end = row[i].length() > splitRow * maxColumnWidth + maxColumnWidth ? splitRow * maxColumnWidth + maxColumnWidth : row[i].length();
                            newRow[i] = row[i].substring(splitRow * maxColumnWidth, end);
                            needExtraRow = true;
                            continue;
                        }
                        newRow[i] = "";
                        continue;
                    }
                    newRow[i] = row[i];
                }
                finalTableList.add(newRow);
                if (!needExtraRow) continue;
                ++splitRow;
            } while (needExtraRow);
        }
        String[][] finalTable = new String[finalTableList.size()][((String[])finalTableList.get(0)).length];
        for (int i = 0; i < finalTable.length; ++i) {
            finalTable[i] = (String[])finalTableList.get(i);
        }
        return finalTableList;
    }

    private static String buildDemarcationLine(Map<Integer, Integer> columnLengths) {
        StringBuffer templn = new StringBuffer("+-");
        for (Integer e : columnLengths.keySet()) {
            Integer length = columnLengths.get(e);
            for (int i = 0; i < length; ++i) {
                templn.append("-");
            }
            templn.append("+-");
        }
        templn.append("\n");
        return templn.toString();
    }

    private static Map<Integer, Integer> calculateColumnsLength(List<String[]> table) {
        HashMap<Integer, Integer> columnLengths = new HashMap<Integer, Integer>();
        for (String[] row : table) {
            int i = 0;
            for (String col : row) {
                if (columnLengths.get(i) == null) {
                    columnLengths.put(i, 0);
                }
                if (col != null && (Integer)columnLengths.get(i) < col.length()) {
                    columnLengths.put(i, col.length());
                }
                ++i;
            }
        }
        return columnLengths;
    }

    private static StringBuilder buildFormatString(Map<Integer, Integer> columnLengths) {
        StringBuilder formatString = new StringBuilder("");
        String flag = leftJustifiedRows ? "-" : "";
        columnLengths.entrySet().stream().forEach(e -> formatString.append("| %" + flag + e.getValue() + "s "));
        formatString.append("|\n");
        return formatString;
    }

    public static void testFunc() {
        String[][] table = new String[][]{{"id", "First Name", "Last Name", "Age", "Profile"}, {"1", "John", "Johnson", "45", "My name is John Johnson. My id is 1. My age is 45."}, {"2", "Tom", "", "35", "My name is Tom. My id is 2. My age is 35."}, {"3", "Rose", "Johnson Johnson Johnson Johnson Johnson Johnson Johnson Johnson Johnson Johnson", "22", "My name is Rose Johnson. My id is 3. My age is 22."}, {"4", "Jimmy", "Kimmel", "", "My name is Jimmy Kimmel. My id is 4. My age is not specified. I am the host of the late night show. I am not fan of Matt Damon. "}};
        ArrayList<String[]> tableList = new ArrayList<String[]>(Arrays.asList(table));
        CliUtils.formatIntoTable(tableList);
    }
}

