/*
 * Decompiled with CFR 0.152.
 */
package zingg.client.pipe;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Pipe
implements Serializable {
    public static final String FORMAT_CSV = "csv";
    public static final String FORMAT_PARQUET = "parquet";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_TEXT = "text";
    public static final String FORMAT_XLS = "com.crealytics.spark.excel";
    public static final String FORMAT_AVRO = "avro";
    public static final String FORMAT_JDBC = "jdbc";
    public static final String FORMAT_CASSANDRA = "org.apache.spark.sql.cassandra";
    public static final String FORMAT_SNOWFLAKE = "net.snowflake.spark.snowflake";
    public static final String FORMAT_ELASTIC = "org.elasticsearch.spark.sql";
    public static final String FORMAT_BIGQUERY = "bigquery";
    public static final String FORMAT_INMEMORY = "inMemory";
    String name;
    String format;
    String preprocessors;
    Map<String, String> props = new HashMap<String, String>();
    @JsonSerialize(using=CustomSchemaSerializer.class)
    StructType schema = null;
    SaveMode mode;
    int id;
    Dataset<Row> dataset;

    public SaveMode getMode() {
        return this.mode;
    }

    public void setMode(SaveMode mode) {
        this.mode = mode;
    }

    public String getName() {
        return this.name;
    }

    @JsonValue
    public void setName(String name) {
        this.name = name;
    }

    public String getFormat() {
        return this.format;
    }

    @JsonValue
    public void setFormat(String sinkType) {
        this.format = sinkType;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    @JsonValue
    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void setProp(String k, String v) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(k, v);
    }

    public void clone(Pipe p) {
        this.name = p.name;
        this.format = p.format;
        this.props = p.props;
    }

    @JsonProperty(value="schema")
    public void setSchema(String s) {
        if (s != null) {
            this.schema = (StructType)DataType.fromJson((String)s);
        }
    }

    public StructType getSchema() {
        return this.schema;
    }

    public String get(String key) {
        return this.props.get(key);
    }

    public void setSchemaStruct(StructType s) {
        this.schema = s;
    }

    public String getPreprocessors() {
        return this.preprocessors;
    }

    public void setPreprocessors(String preprocessors) {
        this.preprocessors = preprocessors;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int recId) {
        this.id = recId;
    }

    public Dataset<Row> getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset<Row> ds) {
        this.dataset = ds;
    }

    public String toString() {
        return "Pipe [name=" + this.name + ", format=" + this.format + ", preprocessors=" + this.preprocessors + ", props=" + this.props + ", schema=" + this.schema + "]";
    }

    public void nullifySchema() {
        this.schema = null;
    }

    public Pipe clone() {
        Pipe p = new Pipe();
        p.name = this.name;
        p.format = this.format;
        p.preprocessors = this.preprocessors;
        p.props = this.props;
        p.schema = this.schema;
        p.mode = this.mode;
        p.id = this.id;
        p.dataset = this.dataset;
        return p;
    }

    static class CustomSchemaSerializer
    extends StdSerializer<StructType> {
        public CustomSchemaSerializer() {
            this(null);
        }

        public CustomSchemaSerializer(Class<StructType> t) {
            super(t);
        }

        public void serialize(StructType value, JsonGenerator gen, SerializerProvider arg2) throws IOException, JsonProcessingException {
            gen.writeObject((Object)value.json());
        }
    }
}

