/*
 * Decompiled with CFR 0.152.
 */
package zingg.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import zingg.client.ZinggClientException;

public enum MatchType implements Serializable
{
    FUZZY("FUZZY"),
    EXACT("EXACT"),
    PINCODE("PINCODE"),
    EMAIL("EMAIL"),
    TEXT("TEXT"),
    NUMERIC("NUMERIC"),
    NUMERIC_WITH_UNITS("NUMBER_WITH_UNITS"),
    NULL_OR_BLANK("NULL_OR_BLANK"),
    ONLY_ALPHABETS_EXACT("ONLY_ALPHABETS_EXACT"),
    ONLY_ALPHABETS_FUZZY("ONLY_ALPHABETS_FUZZY"),
    DONT_USE("DONT_USE");

    private String value;
    private static Map<String, MatchType> types;

    private MatchType(String type) {
        this.value = type;
    }

    private static void init() {
        types = new HashMap<String, MatchType>();
        for (MatchType f : MatchType.values()) {
            types.put(f.value, f);
        }
    }

    @JsonCreator
    public static MatchType getMatchType(String t) throws ZinggClientException {
        MatchType type;
        if (types == null) {
            MatchType.init();
        }
        if ((type = types.get(t.trim().toUpperCase())) == null) {
            throw new ZinggClientException("Unsupported Match Type: " + t);
        }
        return type;
    }

    @JsonValue
    public String value() {
        return this.value;
    }
}

