/*
 * Decompiled with CFR 0.152.
 */
package zingg.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.types.DataType;
import zingg.client.MatchType;
import zingg.client.ZinggClientException;

public class FieldDefinition
implements Serializable {
    public static final Log LOG = LogFactory.getLog(FieldDefinition.class);
    @JsonDeserialize(using=MatchTypeDeserializer.class)
    @JsonSerialize(using=MatchTypeSerializer.class)
    public List<MatchType> matchType;
    @JsonSerialize(using=DataTypeSerializer.class)
    public DataType dataType;
    public String fieldName;
    public String fields;
    public String stopWords;
    public String abbreviations;

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public List<MatchType> getMatchType() {
        return this.matchType;
    }

    @JsonDeserialize(using=MatchTypeDeserializer.class)
    public void setMatchType(List<MatchType> type) {
        this.matchType = type;
    }

    public void setMatchTypeInternal(MatchType ... type) {
        this.matchType = Arrays.asList(type);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(String d) {
        if (d != null) {
            this.dataType = DataType.fromJson((String)d);
        }
    }

    public String getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(String stopWords) {
        this.stopWords = stopWords;
    }

    public String getAbbreviations() {
        return this.abbreviations;
    }

    public void setAbbreviations(String abbreviations) {
        this.abbreviations = abbreviations;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result;
        result = 31 * result + (this.matchType == null ? 0 : this.matchType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldDefinition other = (FieldDefinition)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return this.matchType == other.matchType;
    }

    public static class MatchTypeDeserializer
    extends StdDeserializer<List<MatchType>> {
        private static final long serialVersionUID = 1L;

        public MatchTypeDeserializer() {
            this(null);
        }

        public MatchTypeDeserializer(Class<String> t) {
            super(t);
        }

        public List<MatchType> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            try {
                mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
                LOG.debug("Deserializing custom type");
                return MatchTypeDeserializer.getMatchTypeFromString((String)mapper.readValue(parser, String.class));
            }
            catch (ZinggClientException e) {
                throw new IOException(e);
            }
        }

        public static List<MatchType> getMatchTypeFromString(String m) throws ZinggClientException {
            String[] matchTypeFromConfig;
            ArrayList<MatchType> matchTypes = new ArrayList<MatchType>();
            for (String s : matchTypeFromConfig = m.split(",")) {
                MatchType mt = MatchType.getMatchType(s);
                matchTypes.add(mt);
            }
            return matchTypes;
        }
    }

    public static class MatchTypeSerializer
    extends StdSerializer<List<MatchType>> {
        public MatchTypeSerializer() {
            this(null);
        }

        public MatchTypeSerializer(Class<List<MatchType>> t) {
            super(t);
        }

        public void serialize(List<MatchType> matchType, JsonGenerator jsonGen, SerializerProvider provider) throws IOException, JsonProcessingException {
            try {
                jsonGen.writeObject((Object)MatchTypeSerializer.getStringFromMatchType(matchType));
                LOG.debug("Serializing custom type");
            }
            catch (ZinggClientException e) {
                throw new IOException(e);
            }
        }

        public static String getStringFromMatchType(List<MatchType> matchType) throws ZinggClientException {
            return String.join((CharSequence)",", matchType.stream().map(p -> p.value()).collect(Collectors.toList()));
        }
    }

    public static class DataTypeSerializer
    extends JsonSerializer<DataType> {
        public void serialize(DataType dType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeString(dType.json());
        }
    }
}

