/*
 * Decompiled with CFR 0.152.
 */
package zingg.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import zingg.client.ZinggOptions;
import zingg.client.util.Util;

public class ClientOptions {
    public static final String CONF = "--conf";
    public static final String PHASE = "--phase";
    public static final String LICENSE = "--license";
    public static final String PREPROCESS = "--preprocess";
    public static final String JOBID = "--jobId";
    public static final String EMAIL = "--email";
    public static final String FORMAT = "--format";
    public static final String ZINGG_DIR = "--zinggDir";
    public static final String MODEL_ID = "--modelId";
    public static final String COLLECT_METRICS = "--collectMetrics";
    public static final String SHOW_CONCISE = "--showConcise";
    public static final String LOCATION = "--location";
    public static final String COLUMN = "--column";
    public static final String HELP = "--help";
    public static final String HELP1 = "--h";
    public static final String VERBOSE = "--verbose";
    public static final String VERSION = "--version";
    public static final Log LOG = LogFactory.getLog(ClientOptions.class);
    protected String[] commandLineArgs;
    protected static Map<String, Option> optionMaster = new HashMap<String, Option>();
    protected Map<String, OptionWithVal> options = new HashMap<String, OptionWithVal>();

    public ClientOptions(String ... args) {
        this.commandLineArgs = args;
        this.parse(Arrays.asList(args));
    }

    public ClientOptions(List<String> args) {
        this.commandLineArgs = args.toArray(new String[args.size()]);
        this.parse(args);
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public final Option parse(List<String> args) {
        for (String a : args) {
            LOG.info(a);
        }
        Pattern eqSeparatedOpt = Pattern.compile("(--[^=]+)=(.+)");
        int idx = 0;
        for (idx = 0; idx < args.size(); ++idx) {
            Option opt;
            String arg = args.get(idx);
            String value = null;
            Matcher m = eqSeparatedOpt.matcher(arg);
            if (m.matches()) {
                arg = m.group(1);
                value = m.group(2);
            }
            if ((opt = this.findCliOption(arg)) != null) {
                if (opt.isExit) {
                    return opt;
                }
                if (value == null && opt.hasArg) {
                    if (idx == args.size() - 1) {
                        throw new IllegalArgumentException(String.format("Missing argument for option '%s'.", arg));
                    }
                    value = args.get(++idx);
                }
                this.options.put(opt.optionName, new OptionWithVal(opt, value));
                continue;
            }
            if (!this.handleUnknown(arg)) break;
        }
        for (Option o : optionMaster.values()) {
            if (!o.isMandatory || this.options.containsKey(o.optionName)) continue;
            LOG.warn("Missing required option " + o.optionName);
            LOG.warn(ClientOptions.getHelp());
            throw new IllegalArgumentException("Missing mandatory option " + o.optionName);
        }
        return null;
    }

    protected boolean handleUnknown(String opt) {
        LOG.warn("Could not recognize argument " + opt);
        LOG.warn(ClientOptions.getHelp());
        throw new UnsupportedOperationException("Do not recognize option " + opt);
    }

    protected void handleExtraArgs(List<String> extra) {
        LOG.warn(ClientOptions.getHelp());
        throw new UnsupportedOperationException();
    }

    private Option findCliOption(String name) {
        return optionMaster.get(name);
    }

    public static final String getHelp() {
        StringBuffer s = new StringBuffer();
        s.append("zingg.sh [options]\n");
        s.append("zingg.sh --phase train --conf config.json\n");
        s.append("zingg.sh --phase findTrainingData --conf config.json --zinggDir /location \n");
        s.append("zingg.sh --phase label --conf config.json --zinggDir /location \n");
        s.append("zingg.sh --phase trainMatch --conf config.json --email sendMe@email.com\n");
        s.append("zingg.sh --phase findAndLabel --conf config.json --zinggDir /location\n");
        s.append("options\n");
        int maxlo = 0;
        for (Option option : optionMaster.values()) {
            maxlo = Math.max(maxlo, option.optionName.length());
        }
        int maxld = 0;
        for (Option o : optionMaster.values()) {
            maxld = Math.max(maxld, o.desc.length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t").append("%-").append(maxlo + 5).append("s").append(": ").append("%-").append(maxld + 5).append("s").append("\n");
        String format = stringBuilder.toString();
        for (Option o : optionMaster.values()) {
            s.append(String.format(format, o.optionName, o.desc));
        }
        return s.toString();
    }

    public OptionWithVal get(String a) {
        return this.options.get(a);
    }

    public boolean has(String key) {
        return this.options.containsKey(key);
    }

    public String getOptionValue(String a) {
        return this.get(a).getValue();
    }

    static {
        optionMaster.put(CONF, new Option(CONF, true, "JSON configuration with data input output locations and field definitions", false, true));
        optionMaster.put(PHASE, new Option(PHASE, true, Util.join(ZinggOptions.getAllZinggOptions(), "|"), false, true, ZinggOptions.getAllZinggOptions()));
        optionMaster.put(LICENSE, new Option(LICENSE, true, "location of license file", false, true));
        optionMaster.put(JOBID, new Option(JOBID, true, "database job id for logging", false, false));
        optionMaster.put(EMAIL, new Option(EMAIL, true, "notification email id. Can be an alias", false, false));
        optionMaster.put(FORMAT, new Option(FORMAT, true, "format of the data", false, false));
        optionMaster.put(ZINGG_DIR, new Option(ZINGG_DIR, true, "location of Zingg models, defaults to /tmp/zingg", false, false));
        optionMaster.put(MODEL_ID, new Option(MODEL_ID, true, "model identifier, can be a number ", false, false));
        optionMaster.put(COLLECT_METRICS, new Option(COLLECT_METRICS, true, "collect analytics, true/false  ", false, false));
        optionMaster.put(SHOW_CONCISE, new Option(SHOW_CONCISE, true, "Display only fields that are used to make model, true/false  ", false, false));
        optionMaster.put(LOCATION, new Option(LOCATION, true, "location of CSV file for exported data ", false, false));
        optionMaster.put(COLUMN, new Option(COLUMN, true, "name of the column", false, false));
        optionMaster.put(HELP, new Option(HELP, false, "print usage information", true, false));
        optionMaster.put(HELP1, new Option(HELP1, false, "print usage information", true, false));
        optionMaster.put(PREPROCESS, new Option(PREPROCESS, false, "convert files to unix format", false, false));
    }

    public static final class OptionWithVal
    extends Option {
        Option option;
        String value;

        public OptionWithVal(Option o, String v) {
            this.option = o;
            this.value = v;
            if (this.hasArg && v != null && !this.options.contains(this.value.trim())) {
                throw new IllegalArgumentException("Unexpected argument " + this.value + " for " + o);
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Option {
        String optionName;
        boolean hasArg;
        String desc;
        boolean isExit;
        boolean isMandatory;
        Set<String> options;

        protected Option() {
        }

        public Option(String o, boolean isArg, String d, boolean e, boolean m) {
            this.optionName = o;
            this.hasArg = isArg;
            this.desc = d;
            this.isExit = e;
            this.isMandatory = m;
        }

        public Option(String o, boolean isArg, String d, boolean e, boolean m, String ... options) {
            this.optionName = o;
            this.hasArg = isArg;
            this.desc = d;
            this.isExit = e;
            this.isMandatory = m;
            this.options = new TreeSet<String>();
            for (String op : options) {
                this.options.add(op);
            }
        }
    }
}

