/*
 * Decompiled with CFR 0.152.
 */
package zingg.client;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import zingg.client.Arguments;
import zingg.client.ClientOptions;
import zingg.client.IZingg;
import zingg.client.IZinggFactory;
import zingg.client.ZinggClientException;
import zingg.client.ZinggOptions;
import zingg.client.util.Email;
import zingg.client.util.EmailBody;

public class Client
implements Serializable {
    private Arguments arguments;
    private IZingg zingg;
    private ClientOptions options;
    private SparkSession session;
    public static final Log LOG = LogFactory.getLog(Client.class);

    public Client() {
    }

    public Client(Arguments args, ClientOptions options) throws ZinggClientException {
        this.options = options;
        try {
            this.buildAndSetArguments(args, options);
            Client.printAnalyticsBanner(this.arguments.getCollectMetrics());
            this.setZingg(args, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZinggClientException("An error has occured while setting up the client" + e.getMessage());
        }
    }

    public Client(Arguments args, ClientOptions options, SparkSession session) throws ZinggClientException {
        this(args, options);
        this.session = session;
        JavaSparkContext ctx = new JavaSparkContext(session.sparkContext());
        JavaSparkContext.jarOfClass(IZingg.class);
    }

    public void setZingg(Arguments args, ClientOptions options) throws Exception {
        JavaSparkContext.jarOfClass(IZinggFactory.class);
        IZinggFactory zf = (IZinggFactory)Class.forName("zingg.ZFactory").newInstance();
        try {
            this.setZingg(zf.get(ZinggOptions.getByValue(options.get((String)"--phase").value.trim())));
        }
        catch (Exception e) {
            this.setZingg(zf.get(ZinggOptions.getByValue(ZinggOptions.PEEK_MODEL.getValue())));
        }
    }

    public void setZingg(IZingg zingg) {
        this.zingg = zingg;
    }

    public void buildAndSetArguments(Arguments args, ClientOptions options) {
        String j;
        int jobId = new Long(System.currentTimeMillis()).intValue();
        if (options.get("--jobId") != null) {
            LOG.info("Using job id from command line");
            j = options.get((String)"--jobId").value;
            jobId = Integer.parseInt(j);
            args.setJobId(jobId);
        } else if (args.getJobId() != -1) {
            jobId = args.getJobId();
        }
        if (options.get("--zinggDir") != null) {
            LOG.info("Using zingg dir from command line");
            j = options.get((String)"--zinggDir").value;
            args.setZinggDir(j);
        }
        if (options.get("--modelId") != null) {
            LOG.info("Using model id from command line");
            j = options.get((String)"--modelId").value;
            args.setModelId(j);
        }
        if (options.get("--collectMetrics") != null) {
            j = options.get((String)"--collectMetrics").value;
            args.setCollectMetrics(Boolean.valueOf(j));
        }
        if (options.get("--showConcise") != null) {
            j = options.get((String)"--showConcise").value;
            args.setShowConcise(Boolean.valueOf(j));
        }
        if (options.get("--column") != null) {
            j = options.get((String)"--column").value;
            args.setColumn(j);
        }
        this.setArguments(args);
    }

    public static void printBanner() {
        String versionStr = "0.3.4";
        LOG.info("");
        LOG.info("********************************************************");
        LOG.info("*                    Zingg AI                          *");
        LOG.info("*               (C) 2021 Zingg.AI                      *");
        LOG.info("********************************************************");
        LOG.info("");
        LOG.info("using: Zingg v" + versionStr);
        LOG.info("");
    }

    public static void printAnalyticsBanner(boolean collectMetrics) {
        if (collectMetrics) {
            LOG.info("");
            LOG.info("**************************************************************************");
            LOG.info("*            ** Note about analytics collection by Zingg AI **           *");
            LOG.info("*                                                                        *");
            LOG.info("*  Please note that Zingg captures a few metrics about application's     *");
            LOG.info("*  runtime parameters. However, no user's personal data or application   *");
            LOG.info("*  data is captured. If you want to switch off this feature, please      *");
            LOG.info("*  set the flag collectMetrics to false in config. For details, please   *");
            LOG.info("*  refer to the Zingg docs (https://docs.zingg.ai/docs/security.html)    *");
            LOG.info("**************************************************************************");
            LOG.info("");
        } else {
            LOG.info("");
            LOG.info("********************************************************");
            LOG.info("*    Zingg is not collecting any analytics data        *");
            LOG.info("********************************************************");
            LOG.info("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        Client.printBanner();
        Client client = null;
        ClientOptions options = null;
        try {
            block28: {
                block27: {
                    for (String a : args) {
                        LOG.debug("args " + a);
                    }
                    options = new ClientOptions(args);
                    if (options.has("--help")) break block27;
                    if (options.has("--h")) break block27;
                    if (options.get("--phase") != null) break block28;
                }
                LOG.warn(options.getHelp());
                System.exit(0);
            }
            String phase = options.get((String)"--phase").value.trim();
            ZinggOptions.verifyPhase(phase);
            Arguments arguments = null;
            arguments = options.get((String)"--conf").value.endsWith("json") ? Arguments.createArgumentsFromJSON(options.get((String)"--conf").value, phase) : (options.get((String)"--conf").value.endsWith("env") ? Arguments.createArgumentsFromJSONTemplate(options.get((String)"--conf").value, phase) : Arguments.createArgumentsFromJSONString(options.get((String)"--conf").value, phase));
            client = new Client(arguments, options);
            client.init();
            client.execute();
            client.postMetrics();
            LOG.warn("Zingg processing has completed");
        }
        catch (ZinggClientException e) {
            if (options != null && options.get("--email") != null) {
                Email.email(options.get((String)"--email").value, new EmailBody("Error running Zingg job", "Zingg Error ", e.getMessage()));
            }
            LOG.warn("Apologies for this message. Zingg has encountered an error. " + e.getMessage());
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            if (options != null && options.get("--email") != null) {
                Email.email(options.get((String)"--email").value, new EmailBody("Error running Zingg job", "Zingg Error ", e.getMessage()));
            }
            LOG.warn("Apologies for this message. Zingg has encountered an error. " + e.getMessage());
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            block26: {
                try {
                    if (client != null) {
                        client.stop();
                    }
                }
                catch (ZinggClientException e) {
                    if (options == null || options.get("--email") == null) break block26;
                    Email.email(options.get((String)"--email").value, new EmailBody("Error running Zingg job", "Zingg Error ", e.getMessage()));
                }
            }
        }
    }

    public void init() throws ZinggClientException {
        this.zingg.init(this.getArguments(), "");
        if (this.session != null) {
            this.zingg.setSpark(this.session);
        }
        this.zingg.setClientOptions(this.options);
    }

    public void stop() throws ZinggClientException {
        this.zingg.cleanup();
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    public void execute() throws ZinggClientException {
        this.zingg.execute();
    }

    public void postMetrics() throws ZinggClientException {
        this.zingg.postMetrics();
    }

    public void setArguments(Arguments args) {
        this.arguments = args;
    }

    public ClientOptions getOptions() {
        return this.options;
    }

    public void setOptions(ClientOptions options) {
        this.options = options;
    }

    public Long getMarkedRecordsStat(Dataset<Row> markedRecords, long value) {
        return this.zingg.getMarkedRecordsStat(markedRecords, value);
    }

    public Long getMatchedMarkedRecordsStat(Dataset<Row> markedRecords) {
        return this.zingg.getMatchedMarkedRecordsStat(markedRecords);
    }

    public Long getUnmatchedMarkedRecordsStat(Dataset<Row> markedRecords) {
        return this.zingg.getUnmatchedMarkedRecordsStat(markedRecords);
    }

    public Long getUnsureMarkedRecordsStat(Dataset<Row> markedRecords) {
        return this.zingg.getUnsureMarkedRecordsStat(markedRecords);
    }

    public Dataset<Row> getMarkedRecords() {
        return this.zingg.getMarkedRecords();
    }

    public Dataset<Row> getUnmarkedRecords() {
        return this.zingg.getUnmarkedRecords();
    }
}

