/*
 * Decompiled with CFR 0.152.
 */
package zingg.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import zingg.client.FieldDefinition;
import zingg.client.ZinggClientException;
import zingg.client.pipe.Pipe;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Arguments
implements Serializable {
    Pipe[] output;
    Pipe[] data;
    String zinggDir = "/tmp/zingg";
    Pipe[] trainingSamples;
    List<FieldDefinition> fieldDefinition;
    int numPartitions = 10;
    float labelDataSampleSize = 0.01f;
    String modelId = "1";
    double threshold = 0.5;
    int jobId = 1;
    boolean collectMetrics = true;
    boolean showConcise = false;
    float stopWordsCutoff = 0.1f;
    long blockSize = 100L;
    String column;
    private static final String ENV_VAR_MARKER_START = "$";
    private static final String ENV_VAR_MARKER_END = "$";
    private static final String ESC = "\\";
    private static final String PATTERN_ENV_VAR = "\\$(.+?)\\$";
    public static final Log LOG = LogFactory.getLog(Arguments.class);

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public static final Arguments createArgumentsFromJSON(String filePath) throws ZinggClientException {
        return Arguments.createArgumentsFromJSON(filePath, "match");
    }

    public static final Arguments createArgumentsFromJSON(String filePath, String phase) throws ZinggClientException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            LOG.warn("Config Argument is " + filePath);
            Arguments args = (Arguments)mapper.readValue(new File(filePath), Arguments.class);
            LOG.warn("phase is " + phase);
            Arguments.checkValid(args, phase);
            return args;
        }
        catch (Exception e) {
            throw new ZinggClientException("Unable to parse the configuration at " + filePath + ". The error is " + e.getMessage(), e);
        }
    }

    public static final void writeArgumentsToJSON(String filePath, Arguments args) throws ZinggClientException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.getFactory().configure(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature(), true);
            LOG.warn("Arguments are written to file: " + filePath);
            mapper.writeValue(new File(filePath), (Object)args);
        }
        catch (Exception e) {
            throw new ZinggClientException("Unable to write the configuration to " + filePath + ". The error is " + e.getMessage(), e);
        }
    }

    public static void checkValid(Arguments args, String phase) throws ZinggClientException {
        if (phase.equals("train") || phase.equals("match") || phase.equals("trainMatch") || phase.equals("link")) {
            Arguments.checkIsValid(args);
        } else if (phase.equals("seed") || phase.equals("seedDB")) {
            Arguments.checkIsValidForLabelling(args);
        } else if (!phase.equalsIgnoreCase("WEB")) {
            Arguments.checkIsValidForOthers(args);
        }
    }

    public static final Arguments createArgumentsFromJSONString(String data, String phase) throws ZinggClientException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            Arguments args = (Arguments)mapper.readValue(data, Arguments.class);
            LOG.warn("phase is " + phase);
            Arguments.checkValid(args, phase);
            return args;
        }
        catch (Exception e) {
            throw new ZinggClientException("Unable to parse the configuration at " + data + ". The error is " + e.getMessage());
        }
    }

    public static final Arguments createArgumentsFromJSONTemplate(String filePath, String phase) throws ZinggClientException {
        try {
            LOG.warn("Config Argument is " + filePath);
            byte[] encoded = Files.readAllBytes(Paths.get(filePath, new String[0]));
            String template = new String(encoded, StandardCharsets.UTF_8);
            Map<String, String> env = System.getenv();
            String updatedJson = Arguments.substituteVariables(template, env);
            Arguments args = Arguments.createArgumentsFromJSONString(updatedJson, phase);
            return args;
        }
        catch (Exception e) {
            throw new ZinggClientException("Unable to parse the configuration at " + filePath + ". The error is " + e.getMessage());
        }
    }

    public static String substituteVariables(String template, Map<String, String> variables) throws ZinggClientException {
        Pattern pattern = Pattern.compile(PATTERN_ENV_VAR);
        Matcher matcher = pattern.matcher(template);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (variables.containsKey(matcher.group(1))) {
                String replacement = variables.get(matcher.group(1));
                if (replacement == null || replacement.equals("")) {
                    throw new ZinggClientException("The environment variable for $" + matcher.group(1) + "$" + " is not set or is empty string");
                }
                matcher.appendReplacement(buffer, replacement != null ? Matcher.quoteReplacement(replacement) : "null");
                LOG.warn("The variable $" + matcher.group(1) + "$" + " has been substituted");
                continue;
            }
            throw new ZinggClientException("The environment variable for $" + matcher.group(1) + "$" + " is not set");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static final void writeArgumentstoJSON(String filePath, Arguments args) throws ZinggClientException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.registerModule((Module)new DefaultScalaModule());
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(filePath), (Object)args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZinggClientException("Unable to create arguments for the job");
        }
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) throws ZinggClientException {
        if (numPartitions != -1 && numPartitions <= 0) {
            throw new ZinggClientException("Number of partitions can be greater than 0 for user specified partitioning or equal to -1 for system decided partitioning");
        }
        this.numPartitions = numPartitions;
    }

    public float getLabelDataSampleSize() {
        return this.labelDataSampleSize;
    }

    public void setLabelDataSampleSize(float labelDataSampleSize) throws ZinggClientException {
        if (labelDataSampleSize > 1.0f || labelDataSampleSize < 0.0f) {
            throw new ZinggClientException("Label Data Sample Size should be between 0 and 1");
        }
        this.labelDataSampleSize = labelDataSampleSize;
    }

    public List<FieldDefinition> getFieldDefinition() {
        return this.fieldDefinition;
    }

    public void setFieldDefinition(List<FieldDefinition> fieldDefinition) throws ZinggClientException {
        this.fieldDefinition = fieldDefinition;
    }

    public Pipe[] getTrainingSamples() {
        return this.trainingSamples;
    }

    @JsonSetter
    public void setTrainingSamples(Pipe[] trainingSamples) throws ZinggClientException {
        this.trainingSamples = trainingSamples;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public Pipe[] getOutput() {
        return this.output;
    }

    public void setOutput(Pipe[] outputDir) throws ZinggClientException {
        this.output = outputDir;
    }

    public Pipe[] getData() {
        return this.data;
    }

    public void setData(Pipe[] dataFile) throws ZinggClientException {
        Arguments.checkNullBlankEmpty(dataFile, "file to be matched");
        this.data = dataFile;
    }

    public static void checkIsValid(Arguments args) throws ZinggClientException {
        Arguments arg = new Arguments();
        arg.setTrainingSamples(args.getTrainingSamples());
        arg.setData(args.getData());
        arg.setNumPartitions(args.getNumPartitions());
        arg.setFieldDefinition(args.getFieldDefinition());
    }

    public static void checkIsValidForOthers(Arguments args) throws ZinggClientException {
        Arguments arg = new Arguments();
        arg.setData(args.getData());
        arg.setNumPartitions(args.getNumPartitions());
    }

    public static void checkIsValidForLabelling(Arguments args) throws ZinggClientException {
        Arguments arg = new Arguments();
        arg.setData(args.getData());
        arg.setNumPartitions(args.getNumPartitions());
        arg.setFieldDefinition(args.getFieldDefinition());
    }

    public static void checkNullBlankEmpty(String field, String fieldName) throws ZinggClientException {
        if (field == null || field.trim().length() == 0) {
            throw new ZinggClientException("Missing value for " + fieldName + ". Trying to set " + field);
        }
    }

    public static void checkNullBlankEmpty(Pipe[] field, String fieldName) throws ZinggClientException {
        if (field == null || field.length == 0) {
            throw new ZinggClientException("Missing value for " + fieldName + ". Trying to set " + field);
        }
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        try {
            StringWriter writer = new StringWriter();
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getZinggDir() {
        return this.zinggDir;
    }

    public void setZinggDir(String zinggDir) {
        this.zinggDir = zinggDir;
    }

    @JsonIgnore
    public String getZinggBaseModelDir() {
        return this.zinggDir + "/" + this.modelId;
    }

    @JsonIgnore
    public String getZinggModelDir() {
        return this.getZinggBaseModelDir() + "/model";
    }

    @JsonIgnore
    public String getZinggDocDir() {
        return this.getZinggBaseModelDir() + "/docs/";
    }

    @JsonIgnore
    public String getZinggModelDocFile() {
        return this.getZinggDocDir() + "/model.html";
    }

    @JsonIgnore
    public String getZinggDataDocFile() {
        return this.getZinggDocDir() + "/data.html";
    }

    @JsonIgnore
    public String getZinggBaseTrainingDataDir() {
        return this.getZinggBaseModelDir() + "/trainingData/";
    }

    @JsonIgnore
    public String getZinggTrainingDataUnmarkedDir() {
        return this.getZinggBaseTrainingDataDir() + "/unmarked/";
    }

    @JsonIgnore
    public String getZinggTrainingDataMarkedDir() {
        return this.getZinggBaseTrainingDataDir() + "/marked/";
    }

    @JsonIgnore
    public String getZinggPreprocessedDataDir() {
        return this.zinggDir + "/preprocess";
    }

    @JsonIgnore
    public String getBlockFile() {
        return this.getZinggModelDir() + "/block/zingg.block";
    }

    @JsonIgnore
    public String getModel() {
        return this.getZinggModelDir() + "/classifier/best.model";
    }

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    public boolean getCollectMetrics() {
        return this.collectMetrics;
    }

    public void setCollectMetrics(boolean collectMetrics) {
        this.collectMetrics = collectMetrics;
    }

    public float getStopWordsCutoff() {
        return this.stopWordsCutoff;
    }

    public void setStopWordsCutoff(float stopWordsCutoff) throws ZinggClientException {
        if (stopWordsCutoff > 1.0f || stopWordsCutoff < 0.0f) {
            throw new ZinggClientException("Stop words cutoff should be between 0 and 1");
        }
        this.stopWordsCutoff = stopWordsCutoff;
    }

    public boolean getShowConcise() {
        return this.showConcise;
    }

    public void setShowConcise(boolean showConcise) {
        this.showConcise = showConcise;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    @JsonIgnore
    public String[] getPipeNames() {
        Pipe[] input = this.getData();
        String[] sourceNames = new String[input.length];
        int i = 0;
        for (Pipe p : input) {
            sourceNames[i++] = p.getName();
        }
        return sourceNames;
    }

    @JsonIgnore
    public String getStopWordsDir() {
        return this.getZinggBaseModelDir() + "/stopWords/";
    }
}

