/*
 * Decompiled with CFR 0.152.
 */
package zingg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import zingg.client.Arguments;
import zingg.client.ClientOptions;
import zingg.client.FieldDefinition;
import zingg.client.IZingg;
import zingg.client.MatchType;
import zingg.client.ZinggClientException;
import zingg.client.ZinggOptions;
import zingg.client.util.ListMap;
import zingg.feature.Feature;
import zingg.feature.FeatureFactory;
import zingg.hash.HashFunction;
import zingg.util.Analytics;
import zingg.util.DSUtil;
import zingg.util.HashUtil;
import zingg.util.PipeUtil;

public abstract class ZinggBase
implements Serializable,
IZingg {
    protected Arguments args;
    protected JavaSparkContext ctx;
    protected SparkSession spark;
    protected static String name;
    protected ZinggOptions zinggOptions;
    protected ListMap<DataType, HashFunction> hashFunctions;
    protected Map<FieldDefinition, Feature> featurers;
    protected long startTime;
    public static final String hashFunctionFile = "hashFunctions.json";
    protected ClientOptions clientOptions;
    public static final Log LOG;

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    @Override
    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    @Override
    public void init(Arguments args, String license) throws ZinggClientException {
        this.startTime = System.currentTimeMillis();
        this.args = args;
        try {
            this.spark = SparkSession.builder().appName("Zingg" + args.getJobId()).getOrCreate();
            this.ctx = new JavaSparkContext(this.spark.sparkContext());
            JavaSparkContext.jarOfClass(IZingg.class);
            LOG.debug("Context " + this.ctx.toString());
            this.initHashFns();
            this.loadFeatures();
            this.ctx.setCheckpointDir("/tmp/checkpoint");
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new ZinggClientException(e.getMessage());
        }
    }

    @Override
    public void cleanup() throws ZinggClientException {
        if (this.ctx != null) {
            this.ctx.stop();
        }
    }

    void initHashFns() throws ZinggClientException {
        try {
            this.hashFunctions = HashUtil.getHashFunctionList(hashFunctionFile, this.spark);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new ZinggClientException("Unable to initialize base functions");
        }
    }

    public void loadFeatures() throws ZinggClientException {
        try {
            LOG.info("Start reading internal configurations and functions");
            if (this.args.getFieldDefinition() != null) {
                this.featurers = new HashMap<FieldDefinition, Feature>();
                for (FieldDefinition def : this.args.getFieldDefinition()) {
                    if (def.getMatchType() == null || def.getMatchType().contains(MatchType.DONT_USE)) continue;
                    Feature fea = (Feature)FeatureFactory.get(def.getDataType());
                    fea.init(def);
                    this.featurers.put(def, fea);
                }
                LOG.info("Finished reading internal configurations and functions");
            }
        }
        catch (Throwable t) {
            LOG.warn("Unable to initialize internal configurations and functions");
            if (LOG.isDebugEnabled()) {
                t.printStackTrace();
            }
            throw new ZinggClientException("Unable to initialize internal configurations and functions");
        }
    }

    public void copyContext(ZinggBase b) {
        this.args = b.args;
        this.ctx = b.ctx;
        this.spark = b.spark;
        this.featurers = b.featurers;
        this.hashFunctions = b.hashFunctions;
    }

    @Override
    public void postMetrics() {
        boolean collectMetrics = this.args.getCollectMetrics();
        Analytics.track("executionTime", (System.currentTimeMillis() - this.startTime) / 1000L, collectMetrics);
        Analytics.track("numTotalFields", this.args.getFieldDefinition().size(), collectMetrics);
        Analytics.track("numMatchFields", DSUtil.getFieldDefinitionFiltered(this.args, MatchType.DONT_USE).size(), collectMetrics);
        Analytics.track("dataFormat", PipeUtil.getPipesAsString(this.args.getData()), collectMetrics);
        Analytics.track("outputFormat", PipeUtil.getPipesAsString(this.args.getOutput()), collectMetrics);
        Analytics.postEvent(this.zinggOptions.getValue(), collectMetrics);
    }

    public Arguments getArgs() {
        return this.args;
    }

    public void setArgs(Arguments args) {
        this.args = args;
    }

    public ListMap<DataType, HashFunction> getHashFunctions() {
        return this.hashFunctions;
    }

    public void setHashFunctions(ListMap<DataType, HashFunction> hashFunctions) {
        this.hashFunctions = hashFunctions;
    }

    public Map<FieldDefinition, Feature> getFeaturers() {
        return this.featurers;
    }

    public void setFeaturers(Map<FieldDefinition, Feature> featurers) {
        this.featurers = featurers;
    }

    public JavaSparkContext getCtx() {
        return this.ctx;
    }

    public void setCtx(JavaSparkContext ctx) {
        this.ctx = ctx;
    }

    public SparkSession getSpark() {
        return this.spark;
    }

    @Override
    public void setSpark(SparkSession spark) {
        this.spark = spark;
    }

    public void setName(String name) {
        ZinggBase.name = name;
    }

    public void setZinggOptions(ZinggOptions zinggOptions) {
        this.zinggOptions = zinggOptions;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public ZinggOptions getZinggOptions() {
        return this.zinggOptions;
    }

    @Override
    public Dataset<Row> getMarkedRecords() {
        try {
            return PipeUtil.read(this.spark, false, false, PipeUtil.getTrainingDataMarkedPipe(this.args));
        }
        catch (ZinggClientException e) {
            LOG.warn("No record has been marked yet");
            return null;
        }
    }

    @Override
    public Dataset<Row> getUnmarkedRecords() {
        Dataset unmarkedRecords = null;
        Dataset<Row> markedRecords = null;
        try {
            unmarkedRecords = PipeUtil.read(this.spark, false, false, PipeUtil.getTrainingDataUnmarkedPipe(this.args));
            markedRecords = this.getMarkedRecords();
            if (markedRecords != null) {
                unmarkedRecords = unmarkedRecords.join(markedRecords, unmarkedRecords.col("z_cluster").equalTo((Object)markedRecords.col("z_cluster")), "left_anti");
            }
        }
        catch (ZinggClientException e) {
            LOG.warn("No unmarked record");
        }
        return unmarkedRecords;
    }

    @Override
    public Long getMarkedRecordsStat(Dataset<Row> markedRecords, long value) {
        return markedRecords.filter(markedRecords.col("z_isMatch").equalTo((Object)value)).count() / 2L;
    }

    @Override
    public Long getMatchedMarkedRecordsStat(Dataset<Row> markedRecords) {
        return this.getMarkedRecordsStat(markedRecords, 1L);
    }

    @Override
    public Long getUnmatchedMarkedRecordsStat(Dataset<Row> markedRecords) {
        return this.getMarkedRecordsStat(markedRecords, 0L);
    }

    @Override
    public Long getUnsureMarkedRecordsStat(Dataset<Row> markedRecords) {
        return this.getMarkedRecordsStat(markedRecords, 2L);
    }

    static {
        LOG = LogFactory.getLog(ZinggBase.class);
    }
}

