/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.pattern;

import java.io.Serializable;
import org.graphframes.InvalidParseException;
import org.graphframes.pattern.AnonymousEdge;
import org.graphframes.pattern.AnonymousVertex$;
import org.graphframes.pattern.Edge;
import org.graphframes.pattern.NamedEdge;
import org.graphframes.pattern.NamedVertex;
import org.graphframes.pattern.Negation;
import org.graphframes.pattern.Pattern;
import org.graphframes.pattern.PatternParser$;
import org.graphframes.pattern.Vertex;
import scala.Function1;
import scala.MatchError;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.combinator.Parsers;

public final class Pattern$ {
    public static Pattern$ MODULE$;

    static {
        new Pattern$();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Pattern> parse(String s) {
        void var3_6;
        Parsers.ParseResult<List<Pattern>> parseResult = PatternParser$.MODULE$.parseAll(PatternParser$.MODULE$.patterns(), s);
        if (!(parseResult instanceof Parsers.Success)) {
            if (parseResult instanceof Parsers.NoSuccess) {
                Parsers.NoSuccess noSuccess = (Parsers.NoSuccess)parseResult;
                throw new InvalidParseException(new StringBuilder(57).append("Failed to parse bad motif string: '").append(s).append("'.  Returned message: ").append(noSuccess.msg()).toString());
            }
            throw new MatchError(parseResult);
        }
        Parsers.Success success = (Parsers.Success)parseResult;
        Seq seq = (Seq)success.get();
        Seq result = seq;
        this.assertValidPatterns((Seq<Pattern>)result);
        return var3_6;
    }

    private void assertValidPatterns(Seq<Pattern> patterns) {
        HashSet vertexNames = HashSet$.MODULE$.empty();
        HashSet edgeNames = HashSet$.MODULE$.empty();
        patterns.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Pattern$.$anonfun$assertValidPatterns$1(vertexNames, edgeNames, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> findNamedVerticesOnlyInNegatedTerms(Seq<Pattern> patterns) {
        Set vPos = this.findNamedElementsInOrder((Seq<Pattern>)((Seq)patterns.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Pattern$.$anonfun$findNamedVerticesOnlyInNegatedTerms$1(p)))), false).toSet();
        Set vNeg = this.findNamedElementsInOrder((Seq<Pattern>)((Seq)patterns.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Pattern$.$anonfun$findNamedVerticesOnlyInNegatedTerms$2(p)))), false).toSet();
        return (Seq)vNeg.diff((GenSet)vPos).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Seq<String> findNamedElementsInOrder(Seq<Pattern> patterns, boolean includeEdges) {
        LinkedHashSet elementSet = LinkedHashSet$.MODULE$.empty();
        patterns.foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            this.findNamedElementsHelper$1(pattern, elementSet, includeEdges);
            return BoxedUnit.UNIT;
        });
        return elementSet.toSeq();
    }

    private static final void addVertex$1(Vertex v, HashSet edgeNames$1, HashSet vertexNames$1) {
        Vertex vertex = v;
        if (vertex instanceof NamedVertex) {
            NamedVertex namedVertex = (NamedVertex)vertex;
            String name = namedVertex.name();
            if (edgeNames$1.contains((Object)name)) {
                throw new InvalidParseException(new StringBuilder(73).append("Motif reused name '").append(name).append("' for both a vertex and ").append("an edge, which is not allowed.").toString());
            }
            vertexNames$1.$plus$eq((Object)name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (AnonymousVertex$.MODULE$.equals(vertex)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)vertex);
        }
    }

    private static final void addEdge$1(Edge e, HashSet vertexNames$1, HashSet edgeNames$1) {
        Edge edge = e;
        if (edge instanceof NamedEdge) {
            NamedEdge namedEdge = (NamedEdge)edge;
            String name = namedEdge.name();
            Vertex src = namedEdge.src();
            Vertex dst = namedEdge.dst();
            if (vertexNames$1.contains((Object)name)) {
                throw new InvalidParseException(new StringBuilder(73).append("Motif reused name '").append(name).append("' for both a vertex and ").append("an edge, which is not allowed.").toString());
            }
            if (edgeNames$1.contains((Object)name)) {
                throw new InvalidParseException(new StringBuilder(62).append("Motif reused name '").append(name).append("' for multiple edges, ").append("which is not allowed.").toString());
            }
            edgeNames$1.$plus$eq((Object)name);
            Pattern$.addVertex$1(src, edgeNames$1, vertexNames$1);
            Pattern$.addVertex$1(dst, edgeNames$1, vertexNames$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (edge instanceof AnonymousEdge) {
            AnonymousEdge anonymousEdge = (AnonymousEdge)edge;
            Vertex src = anonymousEdge.src();
            Vertex dst = anonymousEdge.dst();
            Pattern$.addVertex$1(src, edgeNames$1, vertexNames$1);
            Pattern$.addVertex$1(dst, edgeNames$1, vertexNames$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)edge);
        }
    }

    public static final /* synthetic */ void $anonfun$assertValidPatterns$1(HashSet vertexNames$1, HashSet edgeNames$1, Pattern x0$1) {
        boolean bl = false;
        AnonymousEdge anonymousEdge = null;
        Pattern pattern = x0$1;
        if (pattern instanceof Negation) {
            Negation negation = (Negation)pattern;
            Edge edge = negation.child();
            boolean bl2 = false;
            AnonymousEdge anonymousEdge2 = null;
            Edge edge2 = edge;
            if (edge2 instanceof NamedEdge) {
                NamedEdge namedEdge = (NamedEdge)edge2;
                String name = namedEdge.name();
                Vertex src = namedEdge.src();
                Vertex dst = namedEdge.dst();
                throw new InvalidParseException(new StringBuilder(95).append("Motif finding does not support negated named ").append("edges, but the given pattern contained: !(").append(src).append(")-[").append(name).append("]->(").append(dst).append(")").toString());
            }
            if (edge2 instanceof AnonymousEdge) {
                bl2 = true;
                anonymousEdge2 = (AnonymousEdge)edge2;
                Vertex vertex = anonymousEdge2.src();
                Vertex vertex2 = anonymousEdge2.dst();
                if (AnonymousVertex$.MODULE$.equals(vertex) && AnonymousVertex$.MODULE$.equals(vertex2)) {
                    throw new InvalidParseException(new StringBuilder(146).append("Motif finding does not support completely ").append("anonymous negated edges !()-[]->().  Users can check for 0 edges in the graph ").append("using the edges DataFrame.").toString());
                }
            }
            if (!bl2) {
                throw new MatchError((Object)edge2);
            }
            Pattern$.addEdge$1(anonymousEdge2, vertexNames$1, edgeNames$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            if (pattern instanceof AnonymousEdge) {
                bl = true;
                anonymousEdge = (AnonymousEdge)pattern;
                Vertex vertex = anonymousEdge.src();
                Vertex vertex3 = anonymousEdge.dst();
                if (AnonymousVertex$.MODULE$.equals(vertex) && AnonymousVertex$.MODULE$.equals(vertex3)) {
                    throw new InvalidParseException(new StringBuilder(152).append("Motif finding does not support completely ").append("anonymous edges ()-[]->().  Users can check for the existence of edges in the ").append("graph using the edges DataFrame.").toString());
                }
            }
            if (bl) {
                Pattern$.addEdge$1(anonymousEdge, vertexNames$1, edgeNames$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (pattern instanceof NamedEdge) {
                NamedEdge namedEdge = (NamedEdge)pattern;
                Pattern$.addEdge$1(namedEdge, vertexNames$1, edgeNames$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (AnonymousVertex$.MODULE$.equals(pattern)) {
                    throw new InvalidParseException("Motif finding does not allow a lone anonymous vertex \"()\" in a motif.  Users can check for the existence of vertices in the graph using the vertices DataFrame.");
                }
                if (pattern instanceof NamedVertex) {
                    NamedVertex namedVertex = (NamedVertex)pattern;
                    Pattern$.addVertex$1(namedVertex, edgeNames$1, vertexNames$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)pattern);
                }
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$findNamedVerticesOnlyInNegatedTerms$1(Pattern p) {
        return !(p instanceof Negation);
    }

    public static final /* synthetic */ boolean $anonfun$findNamedVerticesOnlyInNegatedTerms$2(Pattern p) {
        return p instanceof Negation;
    }

    private final void findNamedElementsHelper$1(Pattern pattern, LinkedHashSet elementSet$1, boolean includeEdges$1) {
        block7: {
            Pattern pattern2;
            while (true) {
                if ((pattern2 = pattern) instanceof Negation) {
                    Negation negation = (Negation)pattern2;
                    Edge child = negation.child();
                    pattern = child;
                    continue;
                }
                if (AnonymousVertex$.MODULE$.equals(pattern2)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (pattern2 instanceof NamedVertex) {
                    BoxedUnit boxedUnit;
                    NamedVertex namedVertex = (NamedVertex)pattern2;
                    String name = namedVertex.name();
                    if (!elementSet$1.contains((Object)name)) {
                        elementSet$1.$plus$eq((Object)name);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block7;
                }
                if (pattern2 instanceof AnonymousEdge) {
                    AnonymousEdge anonymousEdge = (AnonymousEdge)pattern2;
                    Vertex src = anonymousEdge.src();
                    Vertex dst = anonymousEdge.dst();
                    this.findNamedElementsHelper$1(src, elementSet$1, includeEdges$1);
                    pattern = dst;
                    continue;
                }
                if (!(pattern2 instanceof NamedEdge)) break;
                NamedEdge namedEdge = (NamedEdge)pattern2;
                String name = namedEdge.name();
                Vertex src = namedEdge.src();
                Vertex dst = namedEdge.dst();
                this.findNamedElementsHelper$1(src, elementSet$1, includeEdges$1);
                Object object = includeEdges$1 && !elementSet$1.contains((Object)name) ? elementSet$1.$plus$eq((Object)name) : BoxedUnit.UNIT;
                pattern = dst;
            }
            throw new MatchError((Object)pattern2);
        }
    }

    private Pattern$() {
        MODULE$ = this;
    }
}

