/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.MultiStringWrapper;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;

public abstract class MultiStringDistance
implements StringDistance {
    private String delim;

    public MultiStringDistance(String delim) {
        this.delim = delim;
    }

    @Override
    public final double score(StringWrapper s, StringWrapper t) {
        MultiStringWrapper ms = this.asMultiStringWrapper(s);
        MultiStringWrapper mt = this.asMultiStringWrapper(t);
        return this.scoreCombination(this.multiScore(ms, mt));
    }

    protected abstract double scoreCombination(double[] var1);

    private double[] multiScore(MultiStringWrapper ms, MultiStringWrapper mt) {
        if (ms.size() != mt.size()) {
            throw new IllegalArgumentException("inputs have different numbers of fields");
        }
        int n = ms.size();
        double[] scores = new double[n];
        for (int i = 0; i < n; ++i) {
            scores[i] = this.getDistance(i).score(ms.get(i), mt.get(i));
        }
        return scores;
    }

    @Override
    public final String explainScore(StringWrapper s, StringWrapper t) {
        MultiStringWrapper ms = this.asMultiStringWrapper(s);
        MultiStringWrapper mt = this.asMultiStringWrapper(t);
        if (ms.size() != mt.size()) {
            throw new IllegalArgumentException("inputs have different numbers of fields");
        }
        int n = ms.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buf.append("Field " + (i + 1) + ": s='" + ms.get(i) + "' t='" + mt.get(i) + "':\n");
            buf.append(this.getDistance(i).explainScore(ms.get(i), mt.get(i)));
        }
        buf.append("combination:\n");
        buf.append(this.explainScoreCombination(this.multiScore(ms, mt)));
        return buf.toString();
    }

    protected abstract String explainScoreCombination(double[] var1);

    @Override
    public final double score(String s, String t) {
        return this.score(this.prepare(s), this.prepare(t));
    }

    @Override
    public final String explainScore(String s, String t) {
        return this.explainScore(this.prepare(s), this.prepare(t));
    }

    @Override
    public final StringWrapper prepare(String s) {
        MultiStringWrapper ms = new MultiStringWrapper(s, this.delim);
        if (!this.isLegalMultiStringWrapperSize(ms.size())) {
            throw new IllegalArgumentException("string has invalid number of fields");
        }
        for (int i = 0; i < ms.size(); ++i) {
            ms.set(i, this.getDistance(i).prepare(ms.get(i).unwrap()));
        }
        return ms;
    }

    protected MultiStringWrapper asMultiStringWrapper(StringWrapper w) {
        if (w instanceof MultiStringWrapper) {
            return (MultiStringWrapper)w;
        }
        return (MultiStringWrapper)this.prepare(w.unwrap());
    }

    protected abstract StringDistance getDistance(int var1);

    protected boolean isLegalMultiStringWrapperSize(int n) {
        return n != 0;
    }

    protected static final void doMain(StringDistance d, String[] argv) {
        if (argv.length != 2) {
            System.out.println("usage: string1 string2");
        } else {
            System.out.println(d.explainScore(argv[0], argv[1]));
        }
    }
}

