# Dapr SDK for Python

[![PyPI version](https://badge.fury.io/py/dapr.svg)](https://badge.fury.io/py/dapr)
[![PyPI version](https://badge.fury.io/py/dapr-dev.svg)](https://badge.fury.io/py/dapr-dev)
![dapr-python](https://github.com/dapr/python-sdk/workflows/dapr-python/badge.svg?branch=master)
[![codecov](https://codecov.io/gh/dapr/python-sdk/branch/master/graph/badge.svg)](https://codecov.io/gh/dapr/python-sdk)
[![Discord](https://img.shields.io/discord/778680217417809931)](https://discord.com/channels/778680217417809931/778680217417809934)
[![License: Apache](https://img.shields.io/badge/License-Apache-yellow.svg)](http://www.apache.org/licenses/LICENSE-2.0)
[![FOSSA Status](https://app.fossa.com/api/projects/custom%2B162%2Fgithub.com%2Fdapr%2Fpython-sdk.svg?type=shield)](https://app.fossa.com/projects/custom%2B162%2Fgithub.com%2Fdapr%2Fpython-sdk?ref=badge_shield)

[Dapr](https://docs.dapr.io/concepts/overview/) is a portable, event-driven, serverless runtime for building distributed applications across cloud and edge.

Dapr SDK for Python allows you to implement the [Virtual Actor model](https://docs.dapr.io/developing-applications/building-blocks/actors/actors-overview/), based on the actor design pattern. This SDK can run locally, in a container and in any distributed systems environment.

This includes the following packages:

* [dapr.actor](./dapr/actor): Actor Framework
* [dapr.clients](./dapr/clients): Dapr clients for Dapr building blocks
* [dapr.conf](./dapr/conf): Configuration
* [dapr.serializers](./dapr/serializers): serializer/deserializer
* [dapr.proto](./dapr/proto): Dapr gRPC autogenerated gRPC clients
* [dapr.ext.grpc](./ext/dapr-ext-grpc): gRPC extension for Dapr
* [dapr.ext.fastapi](./ext/dapr-ext-fastapi): FastAPI extension (actor) for Dapr
* [flask.dapr](./ext/flask_dapr): Flask extension (actor) for Dapr

## Getting started

### Prerequisites

* [Install Dapr standalone mode](https://github.com/dapr/cli#install-dapr-on-your-local-machine-standalone)
* [Install Python 3.7+](https://www.python.org/downloads/)

### Install Dapr python sdk

* Official package

```sh
# Install Dapr client sdk
pip3 install dapr

# Install Dapr gRPC AppCallback service extension
pip3 install dapr-ext-grpc

# Install Dapr Fast Api extension for Actor
pip3 install dapr-ext-fastapi
```

* Development package

```sh
# Install Dapr client sdk
pip3 install dapr-dev

# Install Dapr gRPC AppCallback service extension
pip3 install dapr-ext-grpc-dev

# Install Dapr Fast Api extension for Actor
pip3 install dapr-ext-fastapi-dev
```

> Note: Do not install both packages.

### Try out examples

Go to [Examples](./examples)

## Developing

### Build and test

1. Clone python-sdk

```bash
git clone https://github.com/dapr/python-sdk.git
cd python-sdk
```

2. Install a project in a editable mode

```bash
pip3 install -e .
pip3 install -e ./ext/dapr-ext-grpc/
pip3 install -e ./ext/dapr-ext-fastapi/
```

3. Install required packages

```bash
pip3 install -r dev-requirements.txt
```

4. Run linter

```bash
tox -e flake8
```

5. Run unit-test

```bash
tox -e py37
```

6. Run type check

```bash
tox -e type
```

7. Run examples

```bash
tox -e examples
```

## Documentation

Documentation is generated using Sphinx. Extensions used are mainly Napoleon (To process the Google Comment Style) and Autodocs (For automatically generating documentation). The `.rst` files are generated using Sphinx-Apidocs.

To generate documentation:

```bash
tox -e doc
```

The generated files will be found in `docs/_build`.

## Generate gRPC Protobuf client

```sh
pip3 install -r dev-requirements.txt

./tools/regen_grpcclient.sh
```

## Help & Feedback

Need help or have feedback on the SDK? Please open a GitHub issue or come chat with us in the `#python-sdk` channel of our Discord server ([click here to join](https://discord.gg/MySdVxrH)).

## Code of Conduct

This project follows the [CNCF Code of Conduct](https://github.com/cncf/foundation/blob/master/code-of-conduct.md).

