# ropy

[![CI](https://github.com/FirefoxMetzger/ropy/actions/workflows/ci.yml/badge.svg)](https://github.com/FirefoxMetzger/ropy/actions/workflows/ci.yml)
[![codecov](https://codecov.io/gh/FirefoxMetzger/ropy/branch/main/graph/badge.svg?token=VNND9WET47)](https://codecov.io/gh/FirefoxMetzger/ropy)
[![Documentation Status](https://readthedocs.org/projects/robotics-python/badge/?version=latest)](https://robotics-python.readthedocs.io/en/latest/?badge=latest)

Ropy is a robotics library that aims to address the large heterogeneity of code
in the robotics community by providing a selection of commonly used algorithms
and functions in an easy access manner. It focusses on begin easy to use and on
enabling rapid prototyping.

- **Curious**? Check out our detailed [API
  documentation](https://robotics-python.readthedocs.io/en/latest/api_reference.html)
  to see if there is anything that meets your need. 
- Got an **idea for a new feature** or spotted something that is missing? Submit
  a [feature request](https://github.com/FirefoxMetzger/ropy/issues).
- Want to **contribute code**? Awesome! We are very happy about PRs. You can
  check open issues (may I suggest a [good first
  issue](https://github.com/FirefoxMetzger/ropy/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22))
  for an overview of what is currently needed. Alternatively, you can submit a
  new [feature request](https://github.com/FirefoxMetzger/ropy/issues) and -
  after we figured out where the feature should go - you can submit a PR for
  exactly this feature.

**Note:** Ropy is currently in v0.0.1 and the API is experimental. Functions may
appear and dissapear without notice or warning. Stability will start with v0.1,
at which point changes to the API will undergo the usual versioning and
depreciation cycle. Depreciations will trigger a warning and will be removed
after two version-minor increments or a version-major increment (which ever
happens later).

If you do find any part of the API particularly useful in its current form, please
leave a note in the issue section (and a comment on what could be improved).
Feedback like this helps maturing the API more quickly. This way, we can keep
the things that are useful and improve the things that aren't.
