/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityFeatureDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayNodeMapper;
import org.springframework.jdbc.core.JdbcTemplate;

public class WayDao
extends EntityDao<Way> {
    private static final String SQL_UPDATE_WAY_BBOX = "UPDATE ways SET bbox = ( SELECT ST_Envelope(ST_Collect(geom)) FROM nodes JOIN way_nodes ON way_nodes.node_id = nodes.id WHERE way_nodes.way_id = ways.id ) WHERE ways.id = ?";
    private static final String SQL_UPDATE_WAY_LINESTRING = "UPDATE ways w SET linestring = ( SELECT ST_MakeLine(c.geom) AS way_line FROM ( SELECT n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id WHERE (wn.way_id = w.id) ORDER BY wn.sequence_id ) c ) WHERE w.id  = ?";
    private JdbcTemplate jdbcTemplate;
    private DatabaseCapabilityChecker capabilityChecker;
    private EntityFeatureDao<WayNode, DbOrderedFeature<WayNode>> wayNodeDao;
    private WayNodeMapper wayNodeMapper;

    public WayDao(DatabaseContext dbCtx, ActionDao actionDao, boolean logging) {
        super(dbCtx.getJdbcTemplate(), new WayMapper(), actionDao, logging);
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
        this.wayNodeMapper = new WayNodeMapper();
        this.wayNodeDao = new EntityFeatureDao(this.jdbcTemplate, this.wayNodeMapper);
    }

    private void addWayNodeList(long entityId, List<WayNode> wayNodeList) {
        ArrayList<DbOrderedFeature> dbList = new ArrayList<DbOrderedFeature>(wayNodeList.size());
        for (int i = 0; i < wayNodeList.size(); ++i) {
            dbList.add(new DbOrderedFeature(entityId, (Storeable)wayNodeList.get(i), i));
        }
        this.wayNodeDao.addAll(dbList);
    }

    private void updateWayGeometries(long wayId) {
        if (this.capabilityChecker.isWayBboxSupported()) {
            this.jdbcTemplate.update(SQL_UPDATE_WAY_BBOX, new Object[]{wayId});
        }
        if (this.capabilityChecker.isWayLinestringSupported()) {
            this.jdbcTemplate.update(SQL_UPDATE_WAY_LINESTRING, new Object[]{wayId});
        }
    }

    @Override
    public void addEntity(Way entity) {
        super.addEntity(entity);
        this.addWayNodeList(entity.getId(), entity.getWayNodes());
        this.updateWayGeometries(entity.getId());
    }

    @Override
    public void modifyEntity(Way entity) {
        super.modifyEntity(entity);
        long wayId = entity.getId();
        this.wayNodeDao.removeList(wayId);
        this.addWayNodeList(entity.getId(), entity.getWayNodes());
        this.updateWayGeometries(entity.getId());
    }

    @Override
    public void removeEntity(long entityId) {
        this.wayNodeDao.removeList(entityId);
        super.removeEntity(entityId);
    }

    @Override
    protected List<FeaturePopulator<Way>> getFeaturePopulators(String tablePrefix) {
        return Collections.emptyList();
    }
}

