/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class StoreReleasingIterator<DataType>
implements ReleasableIterator<DataType> {
    private Closeable store;
    private ReleasableIterator<DataType> iterator;

    public StoreReleasingIterator(ReleasableIterator<DataType> iterator, Closeable store) {
        this.iterator = iterator;
        this.store = store;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            throw new OsmosisRuntimeException("Iterator has been released.");
        }
        return this.iterator.hasNext();
    }

    @Override
    public DataType next() {
        if (this.iterator == null) {
            throw new OsmosisRuntimeException("Iterator has been released.");
        }
        return (DataType)this.iterator.next();
    }

    @Override
    public void remove() {
        if (this.iterator == null) {
            throw new OsmosisRuntimeException("Iterator has been released.");
        }
        this.iterator.remove();
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }
}

