/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.ChangeSinkChangeSourceManager;
import org.openstreetmap.osmosis.core.sort.v0_6.ChangeSorter;

public class ChangeSorterFactory
extends TaskManagerFactory {
    private static final String ARG_COMPARATOR_TYPE = "type";
    private Map<String, Comparator<ChangeContainer>> comparatorMap = new HashMap<String, Comparator<ChangeContainer>>();
    private String defaultComparatorType;

    public void registerComparator(String comparatorType, Comparator<ChangeContainer> comparator, boolean setAsDefault) {
        if (this.comparatorMap.containsKey(comparatorType)) {
            throw new OsmosisRuntimeException("Comparator type \"" + comparatorType + "\" already exists.");
        }
        if (setAsDefault) {
            this.defaultComparatorType = comparatorType;
        }
        this.comparatorMap.put(comparatorType, comparator);
    }

    private Comparator<ChangeContainer> getComparator(String comparatorType) {
        if (!this.comparatorMap.containsKey(comparatorType)) {
            throw new OsmosisRuntimeException("Comparator type " + comparatorType + " doesn't exist.");
        }
        return this.comparatorMap.get(comparatorType);
    }

    @Override
    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        Comparator<ChangeContainer> comparator = this.getComparator(this.getStringArgument(taskConfig, ARG_COMPARATOR_TYPE, this.getDefaultStringArgument(taskConfig, this.defaultComparatorType)));
        return new ChangeSinkChangeSourceManager(taskConfig.getId(), new ChangeSorter(comparator), taskConfig.getPipeArgs());
    }
}

