/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.progress.v0_6.impl;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class ProgressTracker {
    private int interval;
    private boolean initialized;
    private long lastUpdateTimestamp;
    private long objectCount;
    private double objectsPerSecond;

    public ProgressTracker(int interval) {
        this.interval = interval;
        this.initialized = false;
    }

    public void initialize() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.objectCount = 0L;
        this.objectsPerSecond = 0.0;
        this.initialized = true;
    }

    public boolean updateRequired() {
        if (!this.initialized) {
            throw new OsmosisRuntimeException("initialize has not been called");
        }
        long currentTimestamp = System.currentTimeMillis();
        long duration = currentTimestamp - this.lastUpdateTimestamp;
        ++this.objectCount;
        if (duration > (long)this.interval || duration < 0L) {
            this.lastUpdateTimestamp = currentTimestamp;
            this.objectsPerSecond = (double)this.objectCount * 1000.0 / (double)duration;
            this.objectCount = 0L;
            return true;
        }
        return false;
    }

    public double getObjectsPerSecond() {
        return this.objectsPerSecond;
    }
}

