/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.areafilter.common;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class PolygonFileReader {
    private File polygonFile;
    private String myPolygonName;

    public PolygonFileReader(File polygonFile) {
        this.polygonFile = polygonFile;
    }

    public Area loadPolygon() {
        Area area;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.polygonFile));
        try {
            Area resultArea = new Area();
            this.myPolygonName = bufferedReader.readLine();
            if (this.myPolygonName == null || this.myPolygonName.trim().length() == 0) {
                throw new OsmosisRuntimeException("The file must begin with a header naming the polygon file.");
            }
            while (true) {
                String sectionHeader;
                if ((sectionHeader = bufferedReader.readLine()) == null) {
                    throw new OsmosisRuntimeException("File terminated prematurely without a section END record.");
                }
                if ((sectionHeader = sectionHeader.trim()).length() == 0) continue;
                if ("END".equals(sectionHeader)) break;
                boolean positivePolygon = sectionHeader.charAt(0) != '!';
                Area sectionArea = this.loadSectionPolygon(bufferedReader);
                if (positivePolygon) {
                    resultArea.add(sectionArea);
                    continue;
                }
                resultArea.subtract(sectionArea);
            }
            area = resultArea;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to read from polygon file " + this.polygonFile + ".", (Throwable)e);
            }
        }
        bufferedReader.close();
        return area;
    }

    private Area loadSectionPolygon(BufferedReader bufferedReader) throws IOException {
        double[] beginPoint = null;
        Path2D.Double polygonPath = new Path2D.Double();
        while (true) {
            String sectionLine;
            if ((sectionLine = bufferedReader.readLine()) == null) {
                throw new OsmosisRuntimeException("File terminated prematurely without a section END record.");
            }
            if ((sectionLine = sectionLine.trim()).length() == 0) continue;
            if ("END".equals(sectionLine)) break;
            double[] coordinates = this.parseCoordinates(sectionLine);
            if (beginPoint != null) {
                polygonPath.lineTo(coordinates[0], coordinates[1]);
                continue;
            }
            polygonPath.moveTo(coordinates[0], coordinates[1]);
            beginPoint = coordinates;
        }
        if (beginPoint != null) {
            polygonPath.moveTo((double)beginPoint[0], (double)beginPoint[1]);
        }
        return new Area(polygonPath);
    }

    private double[] parseCoordinates(String coordinateLine) {
        String[] rawTokens = coordinateLine.split("\\s");
        int tokenCount = 0;
        double[] results = new double[2];
        for (int i = 0; i < rawTokens.length; ++i) {
            if (rawTokens[i].length() <= 0) continue;
            if (tokenCount >= 2) {
                throw new OsmosisRuntimeException("A polygon coordinate line must contain 2 numbers, not (" + coordinateLine + ").");
            }
            try {
                results[tokenCount++] = Double.parseDouble(rawTokens[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new OsmosisRuntimeException("Unable to parse " + rawTokens[i] + " into a double precision number.");
            }
        }
        if (tokenCount < 2) {
            throw new OsmosisRuntimeException("Could not find two coordinates on line (" + coordinateLine + ").");
        }
        return results;
    }

    public String getPolygonName() {
        return this.myPolygonName;
    }
}

