/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6;

import java.util.Collections;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.Dataset;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.task.v0_6.DatasetSinkSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class DumpDataset
implements DatasetSinkSource {
    private Sink sink;
    private DatasetContext datasetReader;

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void process(Dataset dataset) {
        if (this.datasetReader != null) {
            throw new OsmosisRuntimeException("process may only be invoked once.");
        }
        this.datasetReader = dataset.createReader();
        try (ReleasableIterator bboxData = this.datasetReader.iterate();){
            this.sink.initialize(Collections.emptyMap());
            while (bboxData.hasNext()) {
                this.sink.process((EntityContainer)bboxData.next());
            }
            this.sink.complete();
        }
    }

    public void close() {
        this.sink.close();
        if (this.datasetReader != null) {
            this.datasetReader.close();
        }
    }
}

