/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.core.store.PersistentIterator;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureTableReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityTableReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.TagMapper;

public class EntityReader<T extends Entity>
implements ReleasableIterator<T> {
    private ReleasableIterator<T> entityReader;
    private PeekableIterator<DbFeature<Tag>> entityTagReader;
    private T nextValue;
    private boolean nextValueLoaded;

    public EntityReader(DatabaseContext dbCtx, EntityMapper<T> entityMapper) {
        this.entityReader = new PersistentIterator((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(entityMapper.getEntityClass()), new EntityTableReader<T>(dbCtx, entityMapper), "ent", true);
        this.entityTagReader = new PeekableIterator((ReleasableIterator)new PersistentIterator((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(DbFeature.class), new EntityFeatureTableReader(dbCtx, new TagMapper(entityMapper.getEntityName())), "enttag", true));
    }

    public EntityReader(DatabaseContext dbCtx, EntityMapper<T> entityMapper, String constraintTable) {
        this.entityReader = new PersistentIterator((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(entityMapper.getEntityClass()), new EntityTableReader<T>(dbCtx, entityMapper, constraintTable), "nod", true);
        this.entityTagReader = new PeekableIterator((ReleasableIterator)new PersistentIterator((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(DbFeature.class), new EntityFeatureTableReader(dbCtx, new TagMapper(entityMapper.getEntityName()), constraintTable), "enttag", true));
    }

    protected void populateEntityFeatures(T entity) {
        DbFeature dbTag;
        long entityId = entity.getId();
        while (this.entityTagReader.hasNext() && (dbTag = (DbFeature)this.entityTagReader.peekNext()).getEntityId() < entityId) {
            this.entityTagReader.next();
        }
        while (this.entityTagReader.hasNext() && ((DbFeature)this.entityTagReader.peekNext()).getEntityId() == entityId) {
            entity.getTags().add((Tag)((DbFeature)this.entityTagReader.next()).getFeature());
        }
    }

    public boolean hasNext() {
        if (!this.nextValueLoaded && this.entityReader.hasNext()) {
            Entity entity = (Entity)this.entityReader.next();
            this.populateEntityFeatures(entity);
            this.nextValue = entity;
            this.nextValueLoaded = true;
        }
        return this.nextValueLoaded;
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextValue;
        this.nextValueLoaded = false;
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.entityReader.close();
        this.entityTagReader.close();
    }
}

