import json
import os
import shutil
from collections import defaultdict, Counter

def generate_merged_file(json_path:str) -> dict:
    """function to generate a json file to gather information about other json file with series details.

    Args:
        json_path (str): [directory's path where the series json are]

    Returns:
        [dict]: [dict to gather informations about series json]
    """
    filenames = os.listdir(json_path)
    content_map = defaultdict(dict)

    for filename in filenames:
        with open(os.path.join(json_path, filename)) as json_file:
            data = json.load(json_file)
            patientID = str(data['patient']['PatientID'])
            studyUID = str(data['study']['StudyInstanceUID'])
            studyDetails = data['study']
            seriesDetails = data['series']
            seriesInstanceUID = data['series']['SeriesInstanceUID']

            if(studyUID not in content_map[patientID]) :
                content_map[patientID][studyUID]=studyDetails
            
            if('Series' not in content_map[patientID][studyUID] ):
                content_map[patientID][studyUID]['Series']={}
            content_map[patientID][studyUID]['Series'][seriesInstanceUID]=seriesDetails
            content_map[patientID][studyUID]['Series'][seriesInstanceUID]['path'] = data['path']
            content_map[patientID][studyUID]['Series'][seriesInstanceUID]['files'] = data['files']

    return content_map

def find_non_intersting_series(json_merged_file_path:str) -> list:
    """find non interesting series (not all body PET or all body CT)

    Args:
        json_merged_file_path (str): [merged json file generated by generated_merged_file() function]

    Returns:
        [list]: [Return the list of each serie path which is not interesting]
    """
    paths = []
    data = json.load(open(json_merged_file_path))
    for patientID in data:
        for studyUID in data[patientID]:
            for seriesUID in data[patientID][studyUID]['Series']:
                path = data[patientID][studyUID]["Series"][seriesUID]["path"]
                series_description = data[patientID][studyUID]["Series"][seriesUID]["SeriesDescription"]
                non_interesting_key_word =("CT COUPES FINES", "_WB_NAC", "POUMON", "PARENCHYME", "ORL", "LUNG", "COMPLEMENTAIRE"
                , "EARL", "MEMBRE", "CORO", "SAG")
                for key_word in non_interesting_key_word:
                    if(key_word in series_description.upper() ):
                        paths.append( path )
    return paths

def find_studies_over_two_series(json_merged_file_path:str) -> tuple:
    """find study with more than 2 series

    Args:
        json_merged_file_path (str): [merged json file generated by generated_merged_file() function]

    Returns:
        [tuple]: [Return the list of each serie path which belong to a study with more than 2 series and their path]
    """
    data = json.load(open(json_merged_file_path))
    number = 0
    series_to_check=[]
    series_list = []
    paths = []
    for patientID in data:
        for studyUID in data[patientID]:
            if( len(data[patientID][studyUID]['Series']) >2 ):
                number +=1
                for seriesUID in data[patientID][studyUID]['Series']:
                    path = data[patientID][studyUID]["Series"][seriesUID]["path"]
                    paths.append(path)
                    series_list.append(data[patientID][studyUID]['Series'][seriesUID]['SeriesDescription'])
                    series_to_check.append(data[patientID][studyUID]['Series'])
    #print(series_list)
    return series_list, paths


def find_studies_with_two_series(json_merged_file_path:str) -> tuple:
    """find study with two series

    Args:
        json_merged_file_path (str): [merged json file generated by generated_merged_file() function]

    Returns:
        [tuple]: [Return the list of each serie path which belong to a study with 2 series and their path]
    """
    data = json.load(open(json_merged_file_path))
    matching_series = defaultdict(dict)
    paths = []
    for patientID in data:
        for studyUID in data[patientID]:
            if( len(data[patientID][studyUID]['Series']) == 2 ):
                for seriesUID in data[patientID][studyUID]['Series']:
                    matching_series[seriesUID]['seriesDetails'] = data[patientID][studyUID]['Series'][seriesUID]
                    matching_series[seriesUID]['path'] = data[patientID][studyUID]['Series'][seriesUID]['path']
                    matching_series[seriesUID]['parentStudyUID'] = studyUID
                    matching_series[seriesUID]['parentPatientID'] = patientID
                    paths.append(data[patientID][studyUID]['Series'][seriesUID]['path'])
    return matching_series, paths

def remove_path_from_disk(path:str):
    """remove a serie from disk

    Args:
        path (str): [a serie's path]
    """
    try:
        shutil.rmtree(path)
    except Exception as err:
        print(err)