# coding: utf-8
# author: Gabriel Couture
from datetime import datetime

IDENTIFIER = '118bc493-b3b3172a-082119bd-f6802ec3-81695613'
PARENT_PATIENT_IDENTIFIER = 'e34c28ce-981b0e5c-2a481559-cf0d5fbe-053335f8'
PATIENT_MAIN_INFORMATION = {
    'PatientBirthDate': '',
    'PatientID': '03HDQ000',
    'PatientName': 'MR-R',
    'PatientSex': 'M'
}
DATE = datetime(year=2010, month=2, day=23)
REFERRING_PHYSICIAN_NAME = ''
ID = ''
SERIES = [
    'c4c1fcc9-ae63f793-40cbcf25-fbd3efe5-ad72ff06',
    'e2a7df26-99673e0f-05aa84cd-c89677c0-634a2a96',
    '60108266-ece4d8f7-7b028286-a7b61f25-c6d33f0b'
]
INFORMATION = {
    'ID': IDENTIFIER,
    'IsStable': False,
    'LastUpdate': '20190913T185658',
    'MainDicomTags': {
        'AccessionNumber': '',
        'ReferringPhysicianName': '',
        'StudyDate': '20100223',
        'StudyID': ID,
        'StudyInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128',
        'StudyTime': ''
    },
    'ParentPatient': PARENT_PATIENT_IDENTIFIER,
    'PatientMainDicomTags': PATIENT_MAIN_INFORMATION,
    'Series': SERIES,
    'Type': 'Study'
}
ZIP_FILE_PATH = './tests/data/A_STUDY_DATA.zip'
INSTANCES = [
    {
        'FileSize': 61742,
        'FileUuid': '6b20abc4-67af-4d2b-b537-b0ee3b35b4df',
        'ID': 'da2024f5-606f9e83-41b012bb-9dced1ea-77bcd599',
        'IndexInSeries': None,
        'MainDicomTags': {
            'InstanceCreationDate': '20100301',
            'InstanceCreationTime': '170155',
            'SOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170155.103167'
        },
        'ParentSeries': '60108266-ece4d8f7-7b028286-a7b61f25-c6d33f0b',
        'Type': 'Instance'
    },
    {
        'FileSize': 10373100,
        'FileUuid': '89b19e2c-9bfb-4751-a539-d54ac9a3d912',
        'ID': '348befe7-5be5ff53-70120381-3baa0cc2-e4e04220',
        'IndexInSeries': None,
        'MainDicomTags': {
            'InstanceCreationDate': '20100301',
            'InstanceCreationTime': '170155',
            'SOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170148.768438'
        },
        'ParentSeries': 'e2a7df26-99673e0f-05aa84cd-c89677c0-634a2a96',
        'Type': 'Instance'
    },
    {
        'FileSize': 1506520,
        'FileUuid': '0aa5b638-7531-4863-a23f-7695aa1577ef',
        'ID': '22dcf059-8fd3ade7-efb39ca3-7f46b248-0200abc9',
        'IndexInSeries': 1,
        'MainDicomTags': {
            'ImageOrientationPatient': '1\\0\\0\\0\\1\\0',
            'ImagePositionPatient': '-223.9880065918\\-158.08148193359\\-117.78499603271',
            'InstanceCreationDate': '20100301',
            'InstanceCreationTime': '170155',
            'InstanceNumber': '1',
            'NumberOfFrames': '75',
            'SOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170155.668389'},
        'ParentSeries': 'c4c1fcc9-ae63f793-40cbcf25-fbd3efe5-ad72ff06',
        'Type': 'Instance'
    }
]

INSTANCE_TAGS = {'22dcf059-8fd3ade7-efb39ca3-7f46b248-0200abc9': {'0008,0012': {'Name': 'InstanceCreationDate', 'Type': 'String', 'Value': '20100301'}, '0008,0013': {'Name': 'InstanceCreationTime', 'Type': 'String', 'Value': '170155'}, '0008,0016': {'Name': 'SOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.481.2'}, '0008,0018': {'Name': 'SOPInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170155.668389'}, '0008,0020': {'Name': 'StudyDate', 'Type': 'String', 'Value': '20100223'}, '0008,0023': {'Name': 'ContentDate', 'Type': 'String', 'Value': '20100301'}, '0008,0030': {'Name': 'StudyTime', 'Type': 'String', 'Value': ''}, '0008,0033': {'Name': 'ContentTime', 'Type': 'String', 'Value': '170155'}, '0008,0050': {'Name': 'AccessionNumber', 'Type': 'String', 'Value': ''}, '0008,0060': {'Name': 'Modality', 'Type': 'String', 'Value': 'RTDOSE'}, '0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'ADAC'}, '0008,0090': {'Name': 'ReferringPhysicianName', 'Type': 'String', 'Value': ''}, '0008,1010': {'Name': 'StationName', 'Type': 'String', 'Value': 'pinnc-2'}, '0008,1090': {'Name': 'ManufacturerModelName', 'Type': 'String', 'Value': 'Pinnacle3'}, '0008,1110': {'Name': 'ReferencedStudySequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.3.1.2.3.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}}]}, '0010,0010': {'Name': 'PatientName', 'Type': 'String', 'Value': 'MR-R'}, '0010,0020': {'Name': 'PatientID', 'Type': 'String', 'Value': '03HDQ000'}, '0010,0030': {'Name': 'PatientBirthDate', 'Type': 'String', 'Value': ''}, '0010,0040': {'Name': 'PatientSex', 'Type': 'String', 'Value': 'M'}, '0018,0050': {'Name': 'SliceThickness', 'Type': 'String', 'Value': '4'}, '0018,1020': {'Name': 'SoftwareVersions', 'Type': 'String', 'Value': 'OCP x.x'}, '0020,000d': {'Name': 'StudyInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}, '0020,000e': {'Name': 'SeriesInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170148.767969'}, '0020,0010': {'Name': 'StudyID', 'Type': 'String', 'Value': ''}, '0020,0011': {'Name': 'SeriesNumber', 'Type': 'String', 'Value': ''}, '0020,0013': {'Name': 'InstanceNumber', 'Type': 'String', 'Value': '1'}, '0020,0032': {'Name': 'ImagePositionPatient', 'Type': 'String', 'Value': '-223.9880065918\\-158.08148193359\\-117.78499603271'}, '0020,0037': {'Name': 'ImageOrientationPatient', 'Type': 'String', 'Value': '1\\0\\0\\0\\1\\0'}, '0020,0052': {'Name': 'FrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '0020,1040': {'Name': 'PositionReferenceIndicator', 'Type': 'String', 'Value': ''}, '0028,0002': {'Name': 'SamplesPerPixel', 'Type': 'String', 'Value': '1'}, '0028,0004': {'Name': 'PhotometricInterpretation', 'Type': 'String', 'Value': 'MONOCHROME2'}, '0028,0008': {'Name': 'NumberOfFrames', 'Type': 'String', 'Value': '75'}, '0028,0009': {'Name': 'FrameIncrementPointer', 'Type': 'String', 'Value': '3004,000c'}, '0028,0010': {'Name': 'Rows', 'Type': 'String', 'Value': '88'}, '0028,0011': {'Name': 'Columns', 'Type': 'String', 'Value': '114'}, '0028,0030': {'Name': 'PixelSpacing', 'Type': 'String', 'Value': '4\\4'}, '0028,0100': {'Name': 'BitsAllocated', 'Type': 'String', 'Value': '16'}, '0028,0101': {'Name': 'BitsStored', 'Type': 'String', 'Value': '16'}, '0028,0102': {'Name': 'HighBit', 'Type': 'String', 'Value': '15'}, '0028,0103': {'Name': 'PixelRepresentation', 'Type': 'String', 'Value': '0'}, '3004,0002': {'Name': 'DoseUnits', 'Type': 'String', 'Value': 'GY'}, '3004,0004': {'Name': 'DoseType', 'Type': 'String', 'Value': 'PHYSICAL'}, '3004,000a': {'Name': 'DoseSummationType', 'Type': 'String', 'Value': 'PLAN'}, '3004,000c': {'Name': 'GridFrameOffsetVector', 'Type': 'TooLong', 'Value': None}, '3004,000e': {'Name': 'DoseGridScaling', 'Type': 'String', 'Value': '0.00341018638574'}, '300c,0002': {'Name': 'ReferencedRTPlanSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.481.5'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170155.103167'}}]}, '7fe0,0010': {'Name': 'PixelData', 'Type': 'Null', 'Value': None}}, '348befe7-5be5ff53-70120381-3baa0cc2-e4e04220': {'0008,0012': {'Name': 'InstanceCreationDate', 'Type': 'String', 'Value': '20100301'}, '0008,0013': {'Name': 'InstanceCreationTime', 'Type': 'String', 'Value': '170155'}, '0008,0016': {'Name': 'SOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.481.3'}, '0008,0018': {'Name': 'SOPInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170148.768438'}, '0008,0020': {'Name': 'StudyDate', 'Type': 'String', 'Value': '20100223'}, '0008,0030': {'Name': 'StudyTime', 'Type': 'String', 'Value': ''}, '0008,0050': {'Name': 'AccessionNumber', 'Type': 'String', 'Value': ''}, '0008,0060': {'Name': 'Modality', 'Type': 'String', 'Value': 'RTSTRUCT'}, '0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'ADAC'}, '0008,0090': {'Name': 'ReferringPhysicianName', 'Type': 'String', 'Value': ''}, '0008,1010': {'Name': 'StationName', 'Type': 'String', 'Value': 'pinnc-2'}, '0008,103e': {'Name': 'SeriesDescription', 'Type': 'String', 'Value': 'Pinnacle POI'}, '0008,1090': {'Name': 'ManufacturerModelName', 'Type': 'String', 'Value': 'Pinnacle3'}, '0008,1110': {'Name': 'ReferencedStudySequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.3.1.2.3.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}}]}, '0010,0010': {'Name': 'PatientName', 'Type': 'String', 'Value': 'MR-R'}, '0010,0020': {'Name': 'PatientID', 'Type': 'String', 'Value': '03HDQ000'}, '0010,0030': {'Name': 'PatientBirthDate', 'Type': 'String', 'Value': ''}, '0010,0040': {'Name': 'PatientSex', 'Type': 'String', 'Value': 'M'}, '0018,1020': {'Name': 'SoftwareVersions', 'Type': 'String', 'Value': 'OCP x.x'}, '0020,000d': {'Name': 'StudyInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}, '0020,000e': {'Name': 'SeriesInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170148.767959'}, '0020,0010': {'Name': 'StudyID', 'Type': 'String', 'Value': ''}, '0020,0011': {'Name': 'SeriesNumber', 'Type': 'String', 'Value': ''}, '3006,0002': {'Name': 'StructureSetLabel', 'Type': 'String', 'Value': 'Plan_0'}, '3006,0004': {'Name': 'StructureSetName', 'Type': 'String', 'Value': 'POIandROI'}, '3006,0008': {'Name': 'StructureSetDate', 'Type': 'String', 'Value': '20100301'}, '3006,0009': {'Name': 'StructureSetTime', 'Type': 'String', 'Value': '170148'}, '3006,0010': {'Name': 'ReferencedFrameOfReferenceSequence', 'Type': 'Sequence', 'Value': [{'0020,0052': {'Name': 'FrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0012': {'Name': 'RTReferencedStudySequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.3.1.2.3.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}, '3006,0014': {'Name': 'RTReferencedSeriesSequence', 'Type': 'Sequence', 'Value': [{'0020,000e': {'Name': 'SeriesInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.133'}, '3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.1'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.2'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.3'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.4'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.5'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.6'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.7'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.129'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.130'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.131'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.132'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.133'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.134'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.135'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.136'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.137'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.138'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.139'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.140'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.141'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.142'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.143'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.144'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.145'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.146'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.147'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.148'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.149'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.150'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.151'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.152'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.153'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.154'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.155'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.156'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.157'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.158'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.159'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.160'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.161'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.162'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.163'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.164'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.165'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.166'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.167'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.168'}}, {'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.169'}}]}}]}}]}}]}, '3006,0020': {'Name': 'StructureSetROISequence', 'Type': 'Sequence', 'Value': [{'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '1'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'POI_1'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '2'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'PTV_ESO'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '3'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'R LUNG'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '4'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'L LUNG'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '5'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'SC'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '6'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'TOTAL LUNG'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '7'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'RING'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '8'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'BODY'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}, {'3006,0022': {'Name': 'ROINumber', 'Type': 'String', 'Value': '9'}, '3006,0024': {'Name': 'ReferencedFrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '3006,0026': {'Name': 'ROIName', 'Type': 'String', 'Value': 'ROI_1'}, '3006,0036': {'Name': 'ROIGenerationAlgorithm', 'Type': 'String', 'Value': ''}}]}, '3006,0039': {'Name': 'ROIContourSequence', 'Type': 'Sequence', 'Value': [{'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '255\\0\\0'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'POINT'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1'}, '3006,0050': {'Name': 'ContourData', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '1'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '255\\0\\0'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '113'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '109'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '93'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '110'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '100'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '102'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '109'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '109'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '106'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '106'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '112'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '108'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '99'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '104'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '109'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '99'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '104'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '101'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '103'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '110'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '105'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '97'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '105'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '90'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '92'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '85'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '93'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '87'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '88'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '88'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '108'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '106'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '94'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '107'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '104'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '97'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '87'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '84'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '86'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '114'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '2'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '0\\255\\0'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '70'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '96'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '125'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '162'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '208'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '258'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '203'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '212'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '224'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '235'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '248'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '273'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '310'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '289'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '289'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '298'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '308'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '324'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '352'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '333'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '348'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '362'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '364'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '364'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '384'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '394'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '391'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '403'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '409'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '416'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '415'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '420'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '434'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '428'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '432'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '460'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '456'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '460'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '442'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '443'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '430'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '395'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '382'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '328'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '289'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '227'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '183'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '138'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '349'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '439'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '441'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '447'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '425'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '399'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '402'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '374'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '382'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '3'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '0\\0\\255'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '207'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '256'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '362'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '412'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '382'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '303'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '293'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '271'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '235'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '221'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '214'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '191'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '162'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '123'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '103'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '64'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '384'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '319'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '327'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '339'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '248'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '263'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '172'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '184'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '439'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '420'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '376'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '432'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '433'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '439'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '434'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '9'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '26'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '427'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '24'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '430'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '24'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '450'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '443'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '430'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '426'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '425'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '422'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '420'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '417'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '416'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '410'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '407'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '410'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '410'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '400'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '375'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '360'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '347'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '346'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '4'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '255\\255\\0'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '36'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '39'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '37'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.7'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '84'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '78'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '69'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '55'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '51'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '59'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '61'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '42'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '42'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '51'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '52'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '53'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '53'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '55'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '56'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '55'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '48'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '54'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '51'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '52'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '53'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '51'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '50'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '52'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '49'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '60'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '61'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '59'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '55'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '54'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '53'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '55'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '48'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '54'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '54'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '58'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '61'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '64'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '60'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '52'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '54'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '50'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '42'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '48'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '42'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '51'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '50'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '42'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '38'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '37'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '39'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '46'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '37'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '42'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '44'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '40'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '39'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '48'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '44'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '39'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '39'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '39'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '40'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '50'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '46'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '45'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '63'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '65'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '67'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '57'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '54'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '44'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '47'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '48'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '52'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '43'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '41'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '5'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '255\\0\\255'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '70'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '64'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '96'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '102'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '125'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '123'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '160'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '161'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '206'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '249'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '172'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '184'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '202'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '210'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '191'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '223'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '213'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '235'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '220'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '248'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '233'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '248'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '8'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '263'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '304'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '283'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '288'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '271'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '297'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '288'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '4'}, '3006,0050': {'Name': 'ContourData', 'Type': 'String', 'Value': '32.343799591064\\7.9684829711914\\117.5\\31.406200408936\\7.0315170288086\\117.5\\30.468799591064\\7.9684829711914\\117.5\\31.406200408936\\8.9065170288086\\117.5'}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '307'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '303'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '324'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '319'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '352'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '327'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '333'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '339'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '347'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '346'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '360'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '347'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '363'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '360'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '364'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '375'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '374'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '382'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '400'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '384'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '410'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '391'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '410'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '391'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '407'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '410'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '416'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '399'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '417'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '402'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '420'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '402'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '422'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '409'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '425'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '414'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '426'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '414'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '430'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '419'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '443'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '425'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '450'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '431'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '430'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '24'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '432'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '427'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '24'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '427'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '26'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '432'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '434'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '9'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '439'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '441'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '447'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '460'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '433'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '455'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '435'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '434'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '25'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '432'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '439'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '439'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '438'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '437'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '440'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '443'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '436'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '429'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '420'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '393'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '376'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '379'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '384'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '349'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '380'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '323'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '377'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '25'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '286'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '360'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '225'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '183'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '250'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '138'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '204'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '6'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '255\\0\\0'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '124'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '88'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '126'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '90'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '125'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '89'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '127'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '91'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '128'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '92'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '128'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '92'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '131'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '96'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '130'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '94'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '133'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '97'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '137'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '101'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '141'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '105'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '144'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '108'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '139'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '103'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '145'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '109'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '140'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '104'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '149'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '113'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '150'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '114'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '149'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '114'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '143'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '107'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '133'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '97'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '139'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '103'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '144'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '108'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '149'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '113'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '147'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '111'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '145'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '109'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '144'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '108'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '148'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '112'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '148'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '112'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '154'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '118'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '152'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '116'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '153'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '117'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '149'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '113'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '149'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '113'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '146'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '110'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '146'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '110'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '146'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '110'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '142'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '106'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '137'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '101'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '133'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '98'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '126'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '91'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '7'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '0\\255\\0'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1030'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1034'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1083'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1015'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '969'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '957'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '833'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '761'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '735'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '691'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '982'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1067'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1050'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1028'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1028'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1036'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1018'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '944'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '937'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '933'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '943'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '916'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '916'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '923'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '896'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '944'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '938'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '875'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '874'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '870'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '873'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '860'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '854'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '857'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '859'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '851'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '847'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '844'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '835'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '838'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '842'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '832'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '828'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '820'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '816'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '806'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '809'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '813'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '803'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '801'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '792'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '797'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '798'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '788'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '784'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '778'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '780'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '782'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '776'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '783'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '770'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '769'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '771'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '772'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '766'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '763'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '761'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '763'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '762'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '761'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '789'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '762'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '764'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '776'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '769'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '765'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '786'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '776'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '787'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '782'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '779'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '792'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.129'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '796'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.132'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '806'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.131'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '802'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.133'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '810'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.136'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '907'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.135'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '819'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.134'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '815'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.138'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '826'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.139'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '830'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.142'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '839'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.141'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '836'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.140'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '832'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.143'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '865'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.144'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '854'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.145'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '847'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.148'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '856'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.147'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '867'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.146'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '856'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.149'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '857'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.151'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '862'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.150'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '944'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.153'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '865'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.152'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '863'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.154'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '869'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.156'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '888'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.155'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '870'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.158'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '876'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.159'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '879'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.160'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '881'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.162'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '887'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.161'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '884'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.165'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '892'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.166'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '895'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.169'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '902'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.168'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '900'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.167'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '895'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1067'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1041'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1013'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '974'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '954'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '934'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '924'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '912'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '906'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.163'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '890'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.164'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '891'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.157'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '876'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.137'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '858'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.130'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '802'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '779'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '765'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '765'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '774'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '4'}, '3006,0050': {'Name': 'ContourData', 'Type': 'String', 'Value': '39.843799591064\\116.71848297119\\-178.75\\38.906200408936\\115.78151702881\\-178.75\\37.968799591064\\116.71848297119\\-178.75\\38.906200408936\\117.65651702881\\-178.75'}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '786'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '805'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '825'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '824'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '867'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '865'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '863'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '923'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '917'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '906'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '913'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '913'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '938'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1004'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1077'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1071'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1063'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1068'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '846'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '866'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '881'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1033'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1040'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1052'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1053'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '1026'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '8'}}, {'3006,002a': {'Name': 'ROIDisplayColor', 'Type': 'String', 'Value': '0\\0\\255'}, '3006,0040': {'Name': 'ContourSequence', 'Type': 'Sequence', 'Value': [{'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '192'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '845'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '247'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '186'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '348'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '855'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '238'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '260'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '666'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '195'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '194'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '241'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '215'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '636'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '183'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '193'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '202'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '218'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '686'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '279'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '281'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '271'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '250'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '224'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '733'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '275'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '245'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '244'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '222'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '697'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '262'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '265'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '262'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '608'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '357'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '272'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '255'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '251'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}, {'3006,0016': {'Name': 'ContourImageSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}}]}, '3006,0042': {'Name': 'ContourGeometricType', 'Type': 'String', 'Value': 'CLOSED_PLANAR'}, '3006,0046': {'Name': 'NumberOfContourPoints', 'Type': 'String', 'Value': '645'}, '3006,0050': {'Name': 'ContourData', 'Type': 'TooLong', 'Value': None}}]}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '9'}}]}, '3006,0080': {'Name': 'RTROIObservationsSequence', 'Type': 'Sequence', 'Value': [{'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '1'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '1'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': 'MARKER'}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '2'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '2'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '3'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '3'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '4'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '4'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '5'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '5'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '6'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '6'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '7'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '7'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '8'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '8'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}, {'3006,0082': {'Name': 'ObservationNumber', 'Type': 'String', 'Value': '9'}, '3006,0084': {'Name': 'ReferencedROINumber', 'Type': 'String', 'Value': '9'}, '3006,00a4': {'Name': 'RTROIInterpretedType', 'Type': 'String', 'Value': ''}, '3006,00a6': {'Name': 'ROIInterpreter', 'Type': 'String', 'Value': ''}}]}}, 'da2024f5-606f9e83-41b012bb-9dced1ea-77bcd599': {'0008,0012': {'Name': 'InstanceCreationDate', 'Type': 'String', 'Value': '20100301'}, '0008,0013': {'Name': 'InstanceCreationTime', 'Type': 'String', 'Value': '170155'}, '0008,0016': {'Name': 'SOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.481.5'}, '0008,0018': {'Name': 'SOPInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170155.103167'}, '0008,0020': {'Name': 'StudyDate', 'Type': 'String', 'Value': '20100223'}, '0008,0030': {'Name': 'StudyTime', 'Type': 'String', 'Value': ''}, '0008,0050': {'Name': 'AccessionNumber', 'Type': 'String', 'Value': ''}, '0008,0060': {'Name': 'Modality', 'Type': 'String', 'Value': 'RTPLAN'}, '0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'ADAC'}, '0008,0090': {'Name': 'ReferringPhysicianName', 'Type': 'String', 'Value': ''}, '0008,1010': {'Name': 'StationName', 'Type': 'String', 'Value': 'pinnc-2'}, '0008,1070': {'Name': 'OperatorsName', 'Type': 'String', 'Value': ''}, '0008,1090': {'Name': 'ManufacturerModelName', 'Type': 'String', 'Value': 'Pinnacle3'}, '0008,1110': {'Name': 'ReferencedStudySequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.3.1.2.3.2'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}}]}, '0010,0010': {'Name': 'PatientName', 'Type': 'String', 'Value': 'MR-R'}, '0010,0020': {'Name': 'PatientID', 'Type': 'String', 'Value': '03HDQ000'}, '0010,0030': {'Name': 'PatientBirthDate', 'Type': 'String', 'Value': ''}, '0010,0040': {'Name': 'PatientSex', 'Type': 'String', 'Value': 'M'}, '0018,1020': {'Name': 'SoftwareVersions', 'Type': 'String', 'Value': 'OCP x.x'}, '0020,000d': {'Name': 'StudyInstanceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}, '0020,000e': {'Name': 'SeriesInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170148.767977'}, '0020,0010': {'Name': 'StudyID', 'Type': 'String', 'Value': ''}, '0020,0011': {'Name': 'SeriesNumber', 'Type': 'String', 'Value': ''}, '0020,0052': {'Name': 'FrameOfReferenceUID', 'Type': 'String', 'Value': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, '0020,1040': {'Name': 'PositionReferenceIndicator', 'Type': 'String', 'Value': ''}, '300a,0002': {'Name': 'RTPlanLabel', 'Type': 'String', 'Value': 'Plan_0.0'}, '300a,0003': {'Name': 'RTPlanName', 'Type': 'String', 'Value': 'LIVE'}, '300a,0006': {'Name': 'RTPlanDate', 'Type': 'String', 'Value': '20100301'}, '300a,0007': {'Name': 'RTPlanTime', 'Type': 'String', 'Value': '170155'}, '300a,000b': {'Name': 'TreatmentSites', 'Type': 'String', 'Value': 'prostate'}, '300a,000c': {'Name': 'RTPlanGeometry', 'Type': 'String', 'Value': 'PATIENT'}, '300a,0070': {'Name': 'FractionGroupSequence', 'Type': 'Sequence', 'Value': [{'300a,0071': {'Name': 'FractionGroupNumber', 'Type': 'String', 'Value': '0'}, '300a,0078': {'Name': 'NumberOfFractionsPlanned', 'Type': 'String', 'Value': '28'}, '300a,0080': {'Name': 'NumberOfBeams', 'Type': 'String', 'Value': '8'}, '300a,00a0': {'Name': 'NumberOfBrachyApplicationSetups', 'Type': 'String', 'Value': '0'}, '300c,0004': {'Name': 'ReferencedBeamSequence', 'Type': 'Sequence', 'Value': [{'300a,0082': {'Name': 'BeamDoseSpecificationPoint', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0.41496029496193'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '130'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '1'}}, {'300a,0082': {'Name': 'BeamDoseSpecificationPoint', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0.00661952001974'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '31'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '2'}}, {'300a,0082': {'Name': 'BeamDoseSpecificationPoint', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0.00487405480817'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '50'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '3'}}, {'300a,0082': {'Name': 'BeamDoseSpecificationPoint', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0.01596663147211'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '53'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '4'}}, {'300a,0082': {'Name': 'BeamDoseSpecificationPoint', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0.02598128095269'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '45'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '5'}}, {'300a,0082': {'Name': 'BeamDoseSpecificationPoint', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0.70787841081619'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '177'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '6'}}, {'300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '0'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '7'}}, {'300a,0084': {'Name': 'BeamDose', 'Type': 'String', 'Value': '0'}, '300a,0086': {'Name': 'BeamMeterset', 'Type': 'String', 'Value': '0'}, '300c,0006': {'Name': 'ReferencedBeamNumber', 'Type': 'String', 'Value': '8'}}]}, '300c,000a': {'Name': 'ReferencedBrachyApplicationSetupSequence', 'Type': 'Sequence', 'Value': [{'300a,00a4': {'Name': 'BrachyApplicationSetupDose', 'Type': 'String', 'Value': '12.0'}}]}}]}, '300a,00a4': {'Name': 'BrachyApplicationSetupDose', 'Type': 'String', 'Value': '12.0'}, '300a,00b0': {'Name': 'BeamSequence', 'Type': 'Sequence', 'Value': [{'0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'Elekta'}, '0008,0080': {'Name': 'InstitutionName', 'Type': 'String', 'Value': 'CGMH Kaohsiung Hospital'}, '300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b3': {'Name': 'PrimaryDosimeterUnit', 'Type': 'String', 'Value': 'MU'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '373'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '40'}, '300a,00be': {'Name': 'LeafPositionBoundaries', 'Type': 'String', 'Value': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '1'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'PA'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '26'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\43'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '180.0'}, '300a,011f': {'Name': 'GantryRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '180.0'}, '300a,0121': {'Name': 'BeamLimitingDeviceRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0123': {'Name': 'PatientSupportRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '888.63549804688'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\43'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '8.6215696334839'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '2'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\42'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '8.6215696334839'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '3'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\42'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '17.034879684448'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '4'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-17\\42'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-90\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '17.034879684448'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '5'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-17\\42'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-90\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '23.854928970337'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\42'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '23.854928970337'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '7'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\42'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '31.245409011841'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '8'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\43'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '31.245409011841'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '9'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-19\\43'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '38.581150054932'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-15\\41'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '38.581150054932'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '11'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-15\\41'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '43.647838592529'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '12'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '9\\39'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '43.647838592529'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '13'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '9\\39'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '49.328269958496'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '14'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '12\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-70\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\16.4\\20.2\\11.9\\11.9\\24.6\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\40\\40\\40\\40\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51'}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '49.328269958496'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '15'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '12\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-70\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\16.4\\20.2\\11.9\\11.9\\24.6\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\40\\40\\40\\40\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51'}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '57.453460693359'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '16'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '11\\45'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-40\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '57.453460693359'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '17'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '11\\45'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-40\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '63.340621948242'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '18'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-2\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '63.340621948242'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '19'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-2\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '74.661125183105'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '20'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-10\\36'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '74.661125183105'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '21'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-10\\36'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '89.932022094727'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '22'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-20\\-2'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '89.932022094727'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '23'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-20\\-2'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '94.775718688965'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '24'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-15\\39'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '94.775718688965'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '25'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-15\\39'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}, '300c,006a': {'Name': 'ReferencedPatientSetupNumber', 'Type': 'String', 'Value': '1'}}, {'0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'Elekta'}, '0008,0080': {'Name': 'InstitutionName', 'Type': 'String', 'Value': 'CGMH Kaohsiung Hospital'}, '300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b3': {'Name': 'PrimaryDosimeterUnit', 'Type': 'String', 'Value': 'MU'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '373'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '40'}, '300a,00be': {'Name': 'LeafPositionBoundaries', 'Type': 'String', 'Value': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '2'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'RT'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '6'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '4\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '270.0'}, '300a,011f': {'Name': 'GantryRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '180.0'}, '300a,0121': {'Name': 'BeamLimitingDeviceRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0123': {'Name': 'PatientSupportRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '837.44067382812'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '4\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '30.09580039978'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '2'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '4\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '30.09580039978'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '3'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '4\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '67.22380065918'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '4'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '26\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-20\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '67.22380065918'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '5'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '26\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-20\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}, '300c,006a': {'Name': 'ReferencedPatientSetupNumber', 'Type': 'String', 'Value': '1'}}, {'0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'Elekta'}, '0008,0080': {'Name': 'InstitutionName', 'Type': 'String', 'Value': 'CGMH Kaohsiung Hospital'}, '300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b3': {'Name': 'PrimaryDosimeterUnit', 'Type': 'String', 'Value': 'MU'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '373'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '40'}, '300a,00be': {'Name': 'LeafPositionBoundaries', 'Type': 'String', 'Value': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '3'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'LT'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '12'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-64\\-6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '90.0'}, '300a,011f': {'Name': 'GantryRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '180.0'}, '300a,0121': {'Name': 'BeamLimitingDeviceRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0123': {'Name': 'PatientSupportRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '839.37811279297'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-64\\-6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '12.598000526428'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '2'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-58\\-6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '12.598000526428'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '3'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-58\\-6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '28.755298614502'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '4'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-61\\-28'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-10\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '28.755298614502'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '5'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-61\\-28'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-10\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '41.49649810791'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-64\\-29'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-30\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '41.49649810791'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '7'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-64\\-29'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-30\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '68.055999755859'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '8'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\-25'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '68.055999755859'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '9'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\-25'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '80.653999328613'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\-15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '80.653999328613'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '11'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\-15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}, '300c,006a': {'Name': 'ReferencedPatientSetupNumber', 'Type': 'String', 'Value': '1'}}, {'0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'Elekta'}, '0008,0080': {'Name': 'InstitutionName', 'Type': 'String', 'Value': 'CGMH Kaohsiung Hospital'}, '300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b3': {'Name': 'PrimaryDosimeterUnit', 'Type': 'String', 'Value': 'MU'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '373'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '40'}, '300a,00be': {'Name': 'LeafPositionBoundaries', 'Type': 'String', 'Value': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '4'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'RPO'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '16'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '5\\65'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '230.0'}, '300a,011f': {'Name': 'GantryRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '180.0'}, '300a,0121': {'Name': 'BeamLimitingDeviceRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0123': {'Name': 'PatientSupportRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '840.00268554688'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '5\\65'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '11.659600257874'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '2'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '8\\65'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '11.659600257874'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '3'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '8\\65'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '23.311901092529'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '4'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '8\\64'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '23.311901092529'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '5'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '8\\64'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '35.045303344727'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '11\\64'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-90\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '35.045303344727'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '7'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '11\\64'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-90\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '46.697601318359'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '8'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '12\\49'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-10\\30'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '46.697601318359'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '9'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '12\\49'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-10\\30'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '65.040702819824'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '8\\65'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '65.040702819824'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '11'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '8\\65'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '76.693000793457'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '12'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '32\\67'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '76.693000793457'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '13'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '32\\67'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '88.347801208496'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '14'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '52\\70'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '88.347801208496'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '15'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '52\\70'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}, '300c,006a': {'Name': 'ReferencedPatientSetupNumber', 'Type': 'String', 'Value': '1'}}, {'0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'Elekta'}, '0008,0080': {'Name': 'InstitutionName', 'Type': 'String', 'Value': 'CGMH Kaohsiung Hospital'}, '300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b3': {'Name': 'PrimaryDosimeterUnit', 'Type': 'String', 'Value': 'MU'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '373'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '40'}, '300a,00be': {'Name': 'LeafPositionBoundaries', 'Type': 'String', 'Value': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '5'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'LPO'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '14'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-45\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '130.0'}, '300a,011f': {'Name': 'GantryRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '180.0'}, '300a,0121': {'Name': 'BeamLimitingDeviceRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0123': {'Name': 'PatientSupportRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '842.72644042969'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-45\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '14.15860080719'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '2'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-46\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '14.15860080719'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '3'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-46\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\60'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '29.429500579834'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '4'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-46\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '29.429500579834'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '5'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-46\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-120\\40'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '43.237701416016'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-40\\8'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '43.237701416016'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '7'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-40\\8'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '57.035499572754'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '8'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-27\\-5'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\-22.7\\-27.3\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\-5\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17'}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '57.035499572754'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '9'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-27\\-5'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\-22.7\\-27.3\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\-5\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17'}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '72.397003173828'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-53\\-31'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '72.397003173828'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '11'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-53\\-31'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '86.197105407715'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '12'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '86.197105407715'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '13'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\6'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}, '300c,006a': {'Name': 'ReferencedPatientSetupNumber', 'Type': 'String', 'Value': '1'}}, {'0008,0070': {'Name': 'Manufacturer', 'Type': 'String', 'Value': 'Elekta'}, '0008,0080': {'Name': 'InstitutionName', 'Type': 'String', 'Value': 'CGMH Kaohsiung Hospital'}, '300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b3': {'Name': 'PrimaryDosimeterUnit', 'Type': 'String', 'Value': 'MU'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '373'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '40'}, '300a,00be': {'Name': 'LeafPositionBoundaries', 'Type': 'String', 'Value': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '6'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'Beam_1'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '26'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-41\\19'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '0.0'}, '300a,011f': {'Name': 'GantryRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '180.0'}, '300a,0121': {'Name': 'BeamLimitingDeviceRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0123': {'Name': 'PatientSupportRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '888.38330078125'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-41\\19'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '8.4758701324463'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '2'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '8.4758701324463'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '3'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '17.845390319824'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '4'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-40\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '17.845390319824'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '5'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-40\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '27.089790344238'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '27.089790344238'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '7'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '36.125068664551'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '8'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\19'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '36.125068664551'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '9'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-39\\19'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '42.749420166016'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '10'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-35\\16'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '42.749420166016'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '11'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-35\\16'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\20'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '49.826728820801'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '12'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-36\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-100\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '49.826728820801'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '13'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-36\\17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-100\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '58.011497497559'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '14'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-17\\15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-17.3\\-4.9\\-8.7\\3.3\\2.5\\6.4\\-4.8\\4.7\\7.5\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\3\\3\\3\\3\\3\\3\\3\\3\\3\\9.7\\10\\10.8\\15\\13.4\\13.7\\15\\15\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26'}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '58.011497497559'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '15'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-17\\15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-110\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-17.3\\-4.9\\-8.7\\3.3\\2.5\\6.4\\-4.8\\4.7\\7.5\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\3\\3\\3\\3\\3\\3\\3\\3\\3\\9.7\\10\\10.8\\15\\13.4\\13.7\\15\\15\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26'}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '64.890190124512'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '16'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-17\\15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '64.890190124512'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '17'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-17\\15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '72.930023193359'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '18'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-34\\10'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '72.930023193359'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '19'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-34\\10'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '0\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '82.063690185547'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '20'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-30\\-17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-100\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '82.063690185547'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '21'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-30\\-17'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-100\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '87.765983581543'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '22'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-35\\11'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '87.765983581543'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '23'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-35\\11'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '95.900955200195'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '24'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-35\\15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-80\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '95.900955200195'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '25'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-35\\15'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-80\\0'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'MLCX'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'TooLong', 'Value': None}}]}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}, '300c,006a': {'Name': 'ReferencedPatientSetupNumber', 'Type': 'String', 'Value': '1'}}, {'300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '7'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'Left'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '2'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\50'}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '90'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '0'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '839.37811279297'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}}, {'300a,00b2': {'Name': 'TreatmentMachineName', 'Type': 'String', 'Value': 'L9'}, '300a,00b4': {'Name': 'SourceAxisDistance', 'Type': 'String', 'Value': '1000'}, '300a,00b6': {'Name': 'BeamLimitingDeviceSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '426'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00ba': {'Name': 'SourceToBeamLimitingDeviceDistance', 'Type': 'String', 'Value': '509'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}}]}, '300a,00c0': {'Name': 'BeamNumber', 'Type': 'String', 'Value': '8'}, '300a,00c2': {'Name': 'BeamName', 'Type': 'String', 'Value': 'Anterior'}, '300a,00c4': {'Name': 'BeamType', 'Type': 'String', 'Value': 'STATIC'}, '300a,00c6': {'Name': 'RadiationType', 'Type': 'String', 'Value': 'PHOTON'}, '300a,00ce': {'Name': 'TreatmentDeliveryType', 'Type': 'String', 'Value': 'TREATMENT'}, '300a,00d0': {'Name': 'NumberOfWedges', 'Type': 'String', 'Value': '0'}, '300a,00e0': {'Name': 'NumberOfCompensators', 'Type': 'String', 'Value': '0'}, '300a,00ed': {'Name': 'NumberOfBoli', 'Type': 'String', 'Value': '0'}, '300a,00f0': {'Name': 'NumberOfBlocks', 'Type': 'String', 'Value': '0'}, '300a,010e': {'Name': 'FinalCumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}, '300a,0110': {'Name': 'NumberOfControlPoints', 'Type': 'String', 'Value': '2'}, '300a,0111': {'Name': 'ControlPointSequence', 'Type': 'Sequence', 'Value': [{'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '0'}, '300a,0114': {'Name': 'NominalBeamEnergy', 'Type': 'String', 'Value': '6'}, '300a,011a': {'Name': 'BeamLimitingDevicePositionSequence', 'Type': 'Sequence', 'Value': [{'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMX'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\50'}}, {'300a,00b8': {'Name': 'RTBeamLimitingDeviceType', 'Type': 'String', 'Value': 'ASYMY'}, '300a,00bc': {'Name': 'NumberOfLeafJawPairs', 'Type': 'String', 'Value': '1'}, '300a,011c': {'Name': 'LeafJawPositions', 'Type': 'String', 'Value': '-50\\50'}}]}, '300a,011e': {'Name': 'GantryAngle', 'Type': 'String', 'Value': '0'}, '300a,0120': {'Name': 'BeamLimitingDeviceAngle', 'Type': 'String', 'Value': '0'}, '300a,0122': {'Name': 'PatientSupportAngle', 'Type': 'String', 'Value': '0'}, '300a,0125': {'Name': 'TableTopEccentricAngle', 'Type': 'String', 'Value': '0.0'}, '300a,0126': {'Name': 'TableTopEccentricRotationDirection', 'Type': 'String', 'Value': 'NONE'}, '300a,0128': {'Name': 'TableTopVerticalPosition', 'Type': 'String', 'Value': ''}, '300a,0129': {'Name': 'TableTopLongitudinalPosition', 'Type': 'String', 'Value': ''}, '300a,012a': {'Name': 'TableTopLateralPosition', 'Type': 'String', 'Value': ''}, '300a,012c': {'Name': 'IsocenterPosition', 'Type': 'String', 'Value': '0.46875\\-2.0114898681641\\-2.5'}, '300a,0130': {'Name': 'SourceToSurfaceDistance', 'Type': 'String', 'Value': '888.38330078125'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '0'}}, {'300a,0112': {'Name': 'ControlPointIndex', 'Type': 'String', 'Value': '1'}, '300a,0134': {'Name': 'CumulativeMetersetWeight', 'Type': 'String', 'Value': '100'}}]}}]}, '300a,0180': {'Name': 'PatientSetupSequence', 'Type': 'Sequence', 'Value': [{'0018,5100': {'Name': 'PatientPosition', 'Type': 'String', 'Value': 'HFS'}, '300a,0182': {'Name': 'PatientSetupNumber', 'Type': 'String', 'Value': '1'}}]}, '300a,0202': {'Name': 'BrachyTreatmentType', 'Type': 'String', 'Value': 'HDR'}, '300c,0060': {'Name': 'ReferencedStructureSetSequence', 'Type': 'Sequence', 'Value': [{'0008,1150': {'Name': 'ReferencedSOPClassUID', 'Type': 'String', 'Value': '1.2.840.10008.5.1.4.1.1.481.3'}, '0008,1155': {'Name': 'ReferencedSOPInstanceUID', 'Type': 'String', 'Value': '2.16.840.1.113669.2.931128.981194414.20100301170148.768438'}}]}}}
INSTANCE_TAGS_IN_SIMPLIFIED_VERSION = {'22dcf059-8fd3ade7-efb39ca3-7f46b248-0200abc9': {'AccessionNumber': '', 'BitsAllocated': '16', 'BitsStored': '16', 'Columns': '114', 'ContentDate': '20100301', 'ContentTime': '170155', 'DoseGridScaling': '0.00341018638574', 'DoseSummationType': 'PLAN', 'DoseType': 'PHYSICAL', 'DoseUnits': 'GY', 'FrameIncrementPointer': '3004,000c', 'FrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', 'GridFrameOffsetVector': None, 'HighBit': '15', 'ImageOrientationPatient': '1\\0\\0\\0\\1\\0', 'ImagePositionPatient': '-223.9880065918\\-158.08148193359\\-117.78499603271', 'InstanceCreationDate': '20100301', 'InstanceCreationTime': '170155', 'InstanceNumber': '1', 'Manufacturer': 'ADAC', 'ManufacturerModelName': 'Pinnacle3', 'Modality': 'RTDOSE', 'NumberOfFrames': '75', 'PatientBirthDate': '', 'PatientID': '03HDQ000', 'PatientName': 'MR-R', 'PatientSex': 'M', 'PhotometricInterpretation': 'MONOCHROME2', 'PixelData': None, 'PixelRepresentation': '0', 'PixelSpacing': '4\\4', 'PositionReferenceIndicator': '', 'ReferencedRTPlanSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.481.5', 'ReferencedSOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170155.103167'}], 'ReferencedStudySequence': [{'ReferencedSOPClassUID': '1.2.840.10008.3.1.2.3.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}], 'ReferringPhysicianName': '', 'Rows': '88', 'SOPClassUID': '1.2.840.10008.5.1.4.1.1.481.2', 'SOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170155.668389', 'SamplesPerPixel': '1', 'SeriesInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170148.767969', 'SeriesNumber': '', 'SliceThickness': '4', 'SoftwareVersions': 'OCP x.x', 'StationName': 'pinnc-2', 'StudyDate': '20100223', 'StudyID': '', 'StudyInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128', 'StudyTime': ''}, '348befe7-5be5ff53-70120381-3baa0cc2-e4e04220': {'AccessionNumber': '', 'InstanceCreationDate': '20100301', 'InstanceCreationTime': '170155', 'Manufacturer': 'ADAC', 'ManufacturerModelName': 'Pinnacle3', 'Modality': 'RTSTRUCT', 'PatientBirthDate': '', 'PatientID': '03HDQ000', 'PatientName': 'MR-R', 'PatientSex': 'M', 'ROIContourSequence': [{'ContourSequence': [{'ContourData': '0.46875\\-2.0114898681641\\-2.5', 'ContourGeometricType': 'POINT', 'NumberOfContourPoints': '1'}], 'ROIDisplayColor': '255\\0\\0', 'ReferencedROINumber': '1'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '113'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '109'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '93'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '110'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '100'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '102'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '109'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '109'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '106'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '106'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '112'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '108'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '99'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '104'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '109'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '99'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '104'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '101'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '103'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '110'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '105'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '97'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '105'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '90'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '92'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '85'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '93'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '87'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '88'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '88'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '108'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '106'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '94'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '107'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '104'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '97'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '87'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '84'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '86'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '114'}], 'ROIDisplayColor': '255\\0\\0', 'ReferencedROINumber': '2'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], 'NumberOfContourPoints': '70'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], 'NumberOfContourPoints': '96'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], 'NumberOfContourPoints': '125'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], 'NumberOfContourPoints': '162'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], 'NumberOfContourPoints': '208'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], 'NumberOfContourPoints': '258'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], 'NumberOfContourPoints': '203'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], 'NumberOfContourPoints': '212'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], 'NumberOfContourPoints': '224'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], 'NumberOfContourPoints': '235'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], 'NumberOfContourPoints': '248'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '273'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '310'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '289'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], 'NumberOfContourPoints': '289'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '298'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], 'NumberOfContourPoints': '308'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '324'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '352'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '333'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '348'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '362'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '364'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '364'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '384'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '394'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '391'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '403'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '409'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '416'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '415'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '420'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '434'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '428'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '432'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '460'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '456'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '460'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '442'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '443'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '430'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '395'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '382'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '328'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '289'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], 'NumberOfContourPoints': '227'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], 'NumberOfContourPoints': '183'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], 'NumberOfContourPoints': '138'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '349'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '439'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '441'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '447'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '425'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '399'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '402'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '374'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '382'}], 'ROIDisplayColor': '0\\255\\0', 'ReferencedROINumber': '3'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], 'NumberOfContourPoints': '207'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], 'NumberOfContourPoints': '256'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], 'NumberOfContourPoints': '362'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '412'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '382'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], 'NumberOfContourPoints': '303'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '293'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], 'NumberOfContourPoints': '271'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], 'NumberOfContourPoints': '235'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], 'NumberOfContourPoints': '221'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], 'NumberOfContourPoints': '214'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], 'NumberOfContourPoints': '191'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], 'NumberOfContourPoints': '162'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], 'NumberOfContourPoints': '123'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], 'NumberOfContourPoints': '103'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], 'NumberOfContourPoints': '64'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '384'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '319'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '327'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '339'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '248'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '263'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], 'NumberOfContourPoints': '172'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], 'NumberOfContourPoints': '184'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '439'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '420'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '376'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '432'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '433'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '439'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '434'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '9'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '26'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '427'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '24'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '430'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '24'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '450'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '443'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '430'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '426'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '425'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '422'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '420'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '417'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '416'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '410'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '407'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '410'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '410'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '400'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '375'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '360'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '347'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '346'}], 'ROIDisplayColor': '0\\0\\255', 'ReferencedROINumber': '4'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], 'NumberOfContourPoints': '36'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], 'NumberOfContourPoints': '39'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], 'NumberOfContourPoints': '37'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.7'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}], 'NumberOfContourPoints': '84'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}], 'NumberOfContourPoints': '78'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}], 'NumberOfContourPoints': '69'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}], 'NumberOfContourPoints': '55'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}], 'NumberOfContourPoints': '51'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}], 'NumberOfContourPoints': '59'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}], 'NumberOfContourPoints': '61'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '42'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '42'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '51'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], 'NumberOfContourPoints': '52'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], 'NumberOfContourPoints': '53'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}], 'NumberOfContourPoints': '53'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}], 'NumberOfContourPoints': '55'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}], 'NumberOfContourPoints': '56'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}], 'NumberOfContourPoints': '55'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}], 'NumberOfContourPoints': '48'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}], 'NumberOfContourPoints': '54'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}], 'NumberOfContourPoints': '51'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}], 'NumberOfContourPoints': '52'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}], 'NumberOfContourPoints': '53'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}], 'NumberOfContourPoints': '51'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}], 'NumberOfContourPoints': '50'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}], 'NumberOfContourPoints': '52'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}], 'NumberOfContourPoints': '49'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}], 'NumberOfContourPoints': '60'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}], 'NumberOfContourPoints': '61'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}], 'NumberOfContourPoints': '59'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}], 'NumberOfContourPoints': '55'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}], 'NumberOfContourPoints': '54'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}], 'NumberOfContourPoints': '53'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}], 'NumberOfContourPoints': '55'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}], 'NumberOfContourPoints': '48'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}], 'NumberOfContourPoints': '54'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}], 'NumberOfContourPoints': '54'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}], 'NumberOfContourPoints': '58'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}], 'NumberOfContourPoints': '61'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}], 'NumberOfContourPoints': '64'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}], 'NumberOfContourPoints': '60'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}], 'NumberOfContourPoints': '52'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '54'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '50'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '42'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '48'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '42'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '51'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '50'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '42'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '38'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '37'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '39'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '46'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '37'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '42'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '44'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '40'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '39'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '48'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '44'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '39'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '39'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '39'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], 'NumberOfContourPoints': '40'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '50'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], 'NumberOfContourPoints': '46'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], 'NumberOfContourPoints': '41'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], 'NumberOfContourPoints': '45'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}], 'NumberOfContourPoints': '63'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}], 'NumberOfContourPoints': '65'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}], 'NumberOfContourPoints': '67'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}], 'NumberOfContourPoints': '57'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '54'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '44'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '47'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '48'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '52'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], 'NumberOfContourPoints': '43'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], 'NumberOfContourPoints': '41'}], 'ROIDisplayColor': '255\\255\\0', 'ReferencedROINumber': '5'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], 'NumberOfContourPoints': '70'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], 'NumberOfContourPoints': '64'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], 'NumberOfContourPoints': '96'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], 'NumberOfContourPoints': '102'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], 'NumberOfContourPoints': '125'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], 'NumberOfContourPoints': '123'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], 'NumberOfContourPoints': '160'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], 'NumberOfContourPoints': '161'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], 'NumberOfContourPoints': '206'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], 'NumberOfContourPoints': '249'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], 'NumberOfContourPoints': '172'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], 'NumberOfContourPoints': '184'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], 'NumberOfContourPoints': '202'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], 'NumberOfContourPoints': '210'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], 'NumberOfContourPoints': '191'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], 'NumberOfContourPoints': '223'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], 'NumberOfContourPoints': '213'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], 'NumberOfContourPoints': '235'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], 'NumberOfContourPoints': '220'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], 'NumberOfContourPoints': '248'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], 'NumberOfContourPoints': '233'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '248'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '8'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '263'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '304'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '283'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], 'NumberOfContourPoints': '288'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], 'NumberOfContourPoints': '271'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '297'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '288'}, {'ContourData': '32.343799591064\\7.9684829711914\\117.5\\31.406200408936\\7.0315170288086\\117.5\\30.468799591064\\7.9684829711914\\117.5\\31.406200408936\\8.9065170288086\\117.5', 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '4'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], 'NumberOfContourPoints': '307'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], 'NumberOfContourPoints': '303'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '324'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '319'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '352'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '327'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '333'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '339'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '347'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '346'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '360'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '347'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '363'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '360'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '364'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '375'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '374'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '382'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '400'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '384'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '410'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '391'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '410'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '391'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '407'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '410'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '416'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '399'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '417'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '402'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '420'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '402'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '422'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '409'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '425'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '414'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '426'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '414'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '430'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '419'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '443'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '425'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '450'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '431'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '430'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '24'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '432'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '427'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '24'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '427'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '26'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '432'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '434'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '9'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '439'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '441'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '447'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '460'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '433'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '455'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '435'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '434'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '25'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '432'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '439'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '439'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '438'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '437'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '440'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '443'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '436'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '429'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '420'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '393'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '376'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '379'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '384'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '349'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '380'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '323'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '377'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '25'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '286'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], 'NumberOfContourPoints': '360'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], 'NumberOfContourPoints': '225'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], 'NumberOfContourPoints': '183'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], 'NumberOfContourPoints': '250'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], 'NumberOfContourPoints': '138'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], 'NumberOfContourPoints': '204'}], 'ROIDisplayColor': '255\\0\\255', 'ReferencedROINumber': '6'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '124'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '88'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '126'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '90'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '125'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '89'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '127'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '91'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '128'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '92'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '128'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '92'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '131'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '96'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '130'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '94'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '133'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '97'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '137'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '101'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '141'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '105'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '144'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '108'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '139'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '103'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '145'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '109'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '140'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '104'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '149'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '113'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '150'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '114'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '149'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '114'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '143'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '107'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '133'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '97'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '139'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '103'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '144'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '108'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '149'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '113'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '147'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '111'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '145'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '109'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '144'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '108'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '148'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '112'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '148'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '112'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '154'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '118'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '152'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '116'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '153'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '117'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '149'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '113'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '149'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '113'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '146'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '110'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '146'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '110'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '146'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '110'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '142'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '106'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '137'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '101'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '133'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '98'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '126'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '91'}], 'ROIDisplayColor': '255\\0\\0', 'ReferencedROINumber': '7'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], 'NumberOfContourPoints': '1030'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], 'NumberOfContourPoints': '1034'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], 'NumberOfContourPoints': '1083'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], 'NumberOfContourPoints': '1015'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], 'NumberOfContourPoints': '969'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], 'NumberOfContourPoints': '957'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], 'NumberOfContourPoints': '833'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], 'NumberOfContourPoints': '761'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], 'NumberOfContourPoints': '735'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], 'NumberOfContourPoints': '691'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], 'NumberOfContourPoints': '982'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], 'NumberOfContourPoints': '1067'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], 'NumberOfContourPoints': '1050'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], 'NumberOfContourPoints': '1028'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], 'NumberOfContourPoints': '1028'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], 'NumberOfContourPoints': '1036'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], 'NumberOfContourPoints': '1018'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], 'NumberOfContourPoints': '944'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], 'NumberOfContourPoints': '937'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], 'NumberOfContourPoints': '933'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], 'NumberOfContourPoints': '943'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], 'NumberOfContourPoints': '916'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], 'NumberOfContourPoints': '916'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], 'NumberOfContourPoints': '923'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], 'NumberOfContourPoints': '896'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], 'NumberOfContourPoints': '944'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], 'NumberOfContourPoints': '938'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], 'NumberOfContourPoints': '875'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], 'NumberOfContourPoints': '874'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], 'NumberOfContourPoints': '870'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], 'NumberOfContourPoints': '873'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], 'NumberOfContourPoints': '860'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], 'NumberOfContourPoints': '854'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], 'NumberOfContourPoints': '857'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], 'NumberOfContourPoints': '859'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], 'NumberOfContourPoints': '851'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}], 'NumberOfContourPoints': '847'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}], 'NumberOfContourPoints': '844'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}], 'NumberOfContourPoints': '835'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}], 'NumberOfContourPoints': '838'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}], 'NumberOfContourPoints': '842'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}], 'NumberOfContourPoints': '832'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}], 'NumberOfContourPoints': '828'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}], 'NumberOfContourPoints': '820'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}], 'NumberOfContourPoints': '816'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}], 'NumberOfContourPoints': '806'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}], 'NumberOfContourPoints': '809'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}], 'NumberOfContourPoints': '813'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}], 'NumberOfContourPoints': '803'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}], 'NumberOfContourPoints': '801'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}], 'NumberOfContourPoints': '792'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}], 'NumberOfContourPoints': '797'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}], 'NumberOfContourPoints': '798'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}], 'NumberOfContourPoints': '788'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}], 'NumberOfContourPoints': '784'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}], 'NumberOfContourPoints': '778'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}], 'NumberOfContourPoints': '780'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}], 'NumberOfContourPoints': '782'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}], 'NumberOfContourPoints': '776'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}], 'NumberOfContourPoints': '783'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}], 'NumberOfContourPoints': '770'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}], 'NumberOfContourPoints': '769'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}], 'NumberOfContourPoints': '771'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}], 'NumberOfContourPoints': '772'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}], 'NumberOfContourPoints': '766'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}], 'NumberOfContourPoints': '763'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}], 'NumberOfContourPoints': '761'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}], 'NumberOfContourPoints': '763'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}], 'NumberOfContourPoints': '762'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}], 'NumberOfContourPoints': '761'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}], 'NumberOfContourPoints': '789'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}], 'NumberOfContourPoints': '762'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}], 'NumberOfContourPoints': '764'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}], 'NumberOfContourPoints': '776'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}], 'NumberOfContourPoints': '769'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}], 'NumberOfContourPoints': '765'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}], 'NumberOfContourPoints': '786'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}], 'NumberOfContourPoints': '776'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}], 'NumberOfContourPoints': '787'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}], 'NumberOfContourPoints': '782'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}], 'NumberOfContourPoints': '779'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}], 'NumberOfContourPoints': '792'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.129'}], 'NumberOfContourPoints': '796'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.132'}], 'NumberOfContourPoints': '806'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.131'}], 'NumberOfContourPoints': '802'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.133'}], 'NumberOfContourPoints': '810'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.136'}], 'NumberOfContourPoints': '907'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.135'}], 'NumberOfContourPoints': '819'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.134'}], 'NumberOfContourPoints': '815'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.138'}], 'NumberOfContourPoints': '826'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.139'}], 'NumberOfContourPoints': '830'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.142'}], 'NumberOfContourPoints': '839'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.141'}], 'NumberOfContourPoints': '836'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.140'}], 'NumberOfContourPoints': '832'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.143'}], 'NumberOfContourPoints': '865'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.144'}], 'NumberOfContourPoints': '854'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.145'}], 'NumberOfContourPoints': '847'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.148'}], 'NumberOfContourPoints': '856'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.147'}], 'NumberOfContourPoints': '867'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.146'}], 'NumberOfContourPoints': '856'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.149'}], 'NumberOfContourPoints': '857'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.151'}], 'NumberOfContourPoints': '862'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.150'}], 'NumberOfContourPoints': '944'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.153'}], 'NumberOfContourPoints': '865'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.152'}], 'NumberOfContourPoints': '863'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.154'}], 'NumberOfContourPoints': '869'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.156'}], 'NumberOfContourPoints': '888'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.155'}], 'NumberOfContourPoints': '870'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.158'}], 'NumberOfContourPoints': '876'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.159'}], 'NumberOfContourPoints': '879'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.160'}], 'NumberOfContourPoints': '881'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.162'}], 'NumberOfContourPoints': '887'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.161'}], 'NumberOfContourPoints': '884'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.165'}], 'NumberOfContourPoints': '892'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.166'}], 'NumberOfContourPoints': '895'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.169'}], 'NumberOfContourPoints': '902'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.168'}], 'NumberOfContourPoints': '900'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.167'}], 'NumberOfContourPoints': '895'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '1067'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '1041'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '1013'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '974'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '954'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '934'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '924'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '912'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '906'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.163'}], 'NumberOfContourPoints': '890'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.164'}], 'NumberOfContourPoints': '891'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.157'}], 'NumberOfContourPoints': '876'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.137'}], 'NumberOfContourPoints': '858'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.130'}], 'NumberOfContourPoints': '802'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}], 'NumberOfContourPoints': '779'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}], 'NumberOfContourPoints': '765'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}], 'NumberOfContourPoints': '765'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}], 'NumberOfContourPoints': '774'}, {'ContourData': '39.843799591064\\116.71848297119\\-178.75\\38.906200408936\\115.78151702881\\-178.75\\37.968799591064\\116.71848297119\\-178.75\\38.906200408936\\117.65651702881\\-178.75', 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}], 'NumberOfContourPoints': '4'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}], 'NumberOfContourPoints': '786'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}], 'NumberOfContourPoints': '805'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}], 'NumberOfContourPoints': '825'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}], 'NumberOfContourPoints': '824'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '867'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '865'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '863'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '923'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '917'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '906'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '913'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '913'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '938'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '1004'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '1077'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '1071'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '1063'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '1068'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], 'NumberOfContourPoints': '846'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], 'NumberOfContourPoints': '866'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], 'NumberOfContourPoints': '881'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '1033'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '1040'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '1052'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], 'NumberOfContourPoints': '1053'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '1026'}], 'ROIDisplayColor': '0\\255\\0', 'ReferencedROINumber': '8'}, {'ContourSequence': [{'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], 'NumberOfContourPoints': '192'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], 'NumberOfContourPoints': '845'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '247'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], 'NumberOfContourPoints': '186'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], 'NumberOfContourPoints': '348'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], 'NumberOfContourPoints': '855'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '238'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], 'NumberOfContourPoints': '260'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], 'NumberOfContourPoints': '666'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '195'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], 'NumberOfContourPoints': '194'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '241'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], 'NumberOfContourPoints': '215'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], 'NumberOfContourPoints': '636'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '183'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], 'NumberOfContourPoints': '193'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '202'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], 'NumberOfContourPoints': '218'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], 'NumberOfContourPoints': '686'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], 'NumberOfContourPoints': '279'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '281'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], 'NumberOfContourPoints': '271'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '250'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], 'NumberOfContourPoints': '224'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], 'NumberOfContourPoints': '733'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '275'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], 'NumberOfContourPoints': '245'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '244'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], 'NumberOfContourPoints': '222'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], 'NumberOfContourPoints': '697'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], 'NumberOfContourPoints': '262'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '265'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], 'NumberOfContourPoints': '262'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], 'NumberOfContourPoints': '608'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], 'NumberOfContourPoints': '357'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], 'NumberOfContourPoints': '272'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '255'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], 'NumberOfContourPoints': '251'}, {'ContourData': None, 'ContourGeometricType': 'CLOSED_PLANAR', 'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}], 'NumberOfContourPoints': '645'}], 'ROIDisplayColor': '0\\0\\255', 'ReferencedROINumber': '9'}], 'RTROIObservationsSequence': [{'ObservationNumber': '1', 'ROIInterpreter': '', 'RTROIInterpretedType': 'MARKER', 'ReferencedROINumber': '1'}, {'ObservationNumber': '2', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '2'}, {'ObservationNumber': '3', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '3'}, {'ObservationNumber': '4', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '4'}, {'ObservationNumber': '5', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '5'}, {'ObservationNumber': '6', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '6'}, {'ObservationNumber': '7', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '7'}, {'ObservationNumber': '8', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '8'}, {'ObservationNumber': '9', 'ROIInterpreter': '', 'RTROIInterpretedType': '', 'ReferencedROINumber': '9'}], 'ReferencedFrameOfReferenceSequence': [{'FrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', 'RTReferencedStudySequence': [{'RTReferencedSeriesSequence': [{'ContourImageSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.1'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.2'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.3'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.4'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.5'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.6'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.7'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.129'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.130'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.131'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.132'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.133'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.134'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.135'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.136'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.137'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.138'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.139'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.140'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.141'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.142'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.143'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.144'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.145'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.146'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.147'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.148'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.149'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.150'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.151'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.152'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.153'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.154'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.155'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.156'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.157'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.158'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.159'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.160'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.161'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.162'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.163'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.164'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.165'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.166'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.167'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.168'}, {'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.169'}], 'SeriesInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.133'}], 'ReferencedSOPClassUID': '1.2.840.10008.3.1.2.3.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}]}], 'ReferencedStudySequence': [{'ReferencedSOPClassUID': '1.2.840.10008.3.1.2.3.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}], 'ReferringPhysicianName': '', 'SOPClassUID': '1.2.840.10008.5.1.4.1.1.481.3', 'SOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170148.768438', 'SeriesDescription': 'Pinnacle POI', 'SeriesInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170148.767959', 'SeriesNumber': '', 'SoftwareVersions': 'OCP x.x', 'StationName': 'pinnc-2', 'StructureSetDate': '20100301', 'StructureSetLabel': 'Plan_0', 'StructureSetName': 'POIandROI', 'StructureSetROISequence': [{'ROIGenerationAlgorithm': '', 'ROIName': 'POI_1', 'ROINumber': '1', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'PTV_ESO', 'ROINumber': '2', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'R LUNG', 'ROINumber': '3', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'L LUNG', 'ROINumber': '4', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'SC', 'ROINumber': '5', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'TOTAL LUNG', 'ROINumber': '6', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'RING', 'ROINumber': '7', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'BODY', 'ROINumber': '8', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}, {'ROIGenerationAlgorithm': '', 'ROIName': 'ROI_1', 'ROINumber': '9', 'ReferencedFrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1'}], 'StructureSetTime': '170148', 'StudyDate': '20100223', 'StudyID': '', 'StudyInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128', 'StudyTime': ''}, 'da2024f5-606f9e83-41b012bb-9dced1ea-77bcd599': {'AccessionNumber': '', 'BeamSequence': [{'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}, {'LeafPositionBoundaries': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200', 'NumberOfLeafJawPairs': '40', 'RTBeamLimitingDeviceType': 'MLCX', 'SourceToBeamLimitingDeviceDistance': '373'}], 'BeamName': 'PA', 'BeamNumber': '1', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '180.0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\43', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'BeamLimitingDeviceRotationDirection': 'NONE', 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '180.0', 'GantryRotationDirection': 'NONE', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '6', 'PatientSupportAngle': '0.0', 'PatientSupportRotationDirection': 'NONE', 'SourceToSurfaceDistance': '888.63549804688', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\43', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '1', 'CumulativeMetersetWeight': '8.6215696334839'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\42', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '2', 'CumulativeMetersetWeight': '8.6215696334839'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\42', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '3', 'CumulativeMetersetWeight': '17.034879684448'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-17\\42', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-90\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '4', 'CumulativeMetersetWeight': '17.034879684448'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-17\\42', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-90\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '5', 'CumulativeMetersetWeight': '23.854928970337'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\42', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '6', 'CumulativeMetersetWeight': '23.854928970337'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\42', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '7', 'CumulativeMetersetWeight': '31.245409011841'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\43', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '8', 'CumulativeMetersetWeight': '31.245409011841'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-19\\43', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '9', 'CumulativeMetersetWeight': '38.581150054932'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-15\\41', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '10', 'CumulativeMetersetWeight': '38.581150054932'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-15\\41', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '11', 'CumulativeMetersetWeight': '43.647838592529'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '9\\39', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '12', 'CumulativeMetersetWeight': '43.647838592529'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '9\\39', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '13', 'CumulativeMetersetWeight': '49.328269958496'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '12\\40', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-70\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': '22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\16.4\\20.2\\11.9\\11.9\\24.6\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\40\\40\\40\\40\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51', 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '14', 'CumulativeMetersetWeight': '49.328269958496'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '12\\40', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-70\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': '22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\22\\16.4\\20.2\\11.9\\11.9\\24.6\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\45\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\28\\40\\40\\40\\40\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51\\51', 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '15', 'CumulativeMetersetWeight': '57.453460693359'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '11\\45', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-40\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '16', 'CumulativeMetersetWeight': '57.453460693359'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '11\\45', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-40\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '17', 'CumulativeMetersetWeight': '63.340621948242'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-2\\40', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '18', 'CumulativeMetersetWeight': '63.340621948242'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-2\\40', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '19', 'CumulativeMetersetWeight': '74.661125183105'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-10\\36', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '20', 'CumulativeMetersetWeight': '74.661125183105'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-10\\36', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '21', 'CumulativeMetersetWeight': '89.932022094727'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-20\\-2', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '22', 'CumulativeMetersetWeight': '89.932022094727'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-20\\-2', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '23', 'CumulativeMetersetWeight': '94.775718688965'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-15\\39', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '24', 'CumulativeMetersetWeight': '94.775718688965'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-15\\39', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '25', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'InstitutionName': 'CGMH Kaohsiung Hospital', 'Manufacturer': 'Elekta', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '26', 'NumberOfWedges': '0', 'PrimaryDosimeterUnit': 'MU', 'RadiationType': 'PHOTON', 'ReferencedPatientSetupNumber': '1', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}, {'LeafPositionBoundaries': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200', 'NumberOfLeafJawPairs': '40', 'RTBeamLimitingDeviceType': 'MLCX', 'SourceToBeamLimitingDeviceDistance': '373'}], 'BeamName': 'RT', 'BeamNumber': '2', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '180.0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '4\\60', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'BeamLimitingDeviceRotationDirection': 'NONE', 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '270.0', 'GantryRotationDirection': 'NONE', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '10', 'PatientSupportAngle': '0.0', 'PatientSupportRotationDirection': 'NONE', 'SourceToSurfaceDistance': '837.44067382812', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '4\\60', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '1', 'CumulativeMetersetWeight': '30.09580039978'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '4\\60', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '2', 'CumulativeMetersetWeight': '30.09580039978'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '4\\60', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '3', 'CumulativeMetersetWeight': '67.22380065918'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '26\\60', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-20\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '4', 'CumulativeMetersetWeight': '67.22380065918'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '26\\60', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-20\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '5', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'InstitutionName': 'CGMH Kaohsiung Hospital', 'Manufacturer': 'Elekta', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '6', 'NumberOfWedges': '0', 'PrimaryDosimeterUnit': 'MU', 'RadiationType': 'PHOTON', 'ReferencedPatientSetupNumber': '1', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}, {'LeafPositionBoundaries': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200', 'NumberOfLeafJawPairs': '40', 'RTBeamLimitingDeviceType': 'MLCX', 'SourceToBeamLimitingDeviceDistance': '373'}], 'BeamName': 'LT', 'BeamNumber': '3', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '180.0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-64\\-6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'BeamLimitingDeviceRotationDirection': 'NONE', 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '90.0', 'GantryRotationDirection': 'NONE', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '10', 'PatientSupportAngle': '0.0', 'PatientSupportRotationDirection': 'NONE', 'SourceToSurfaceDistance': '839.37811279297', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-64\\-6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '1', 'CumulativeMetersetWeight': '12.598000526428'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-58\\-6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '2', 'CumulativeMetersetWeight': '12.598000526428'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-58\\-6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '3', 'CumulativeMetersetWeight': '28.755298614502'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-61\\-28', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-10\\40', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '4', 'CumulativeMetersetWeight': '28.755298614502'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-61\\-28', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-10\\40', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '5', 'CumulativeMetersetWeight': '41.49649810791'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-64\\-29', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-30\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '6', 'CumulativeMetersetWeight': '41.49649810791'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-64\\-29', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-30\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '7', 'CumulativeMetersetWeight': '68.055999755859'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-50\\-25', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '8', 'CumulativeMetersetWeight': '68.055999755859'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-50\\-25', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '9', 'CumulativeMetersetWeight': '80.653999328613'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\-15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '10', 'CumulativeMetersetWeight': '80.653999328613'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\-15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '11', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'InstitutionName': 'CGMH Kaohsiung Hospital', 'Manufacturer': 'Elekta', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '12', 'NumberOfWedges': '0', 'PrimaryDosimeterUnit': 'MU', 'RadiationType': 'PHOTON', 'ReferencedPatientSetupNumber': '1', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}, {'LeafPositionBoundaries': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200', 'NumberOfLeafJawPairs': '40', 'RTBeamLimitingDeviceType': 'MLCX', 'SourceToBeamLimitingDeviceDistance': '373'}], 'BeamName': 'RPO', 'BeamNumber': '4', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '180.0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '5\\65', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'BeamLimitingDeviceRotationDirection': 'NONE', 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '230.0', 'GantryRotationDirection': 'NONE', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '6', 'PatientSupportAngle': '0.0', 'PatientSupportRotationDirection': 'NONE', 'SourceToSurfaceDistance': '840.00268554688', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '5\\65', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '1', 'CumulativeMetersetWeight': '11.659600257874'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '8\\65', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '2', 'CumulativeMetersetWeight': '11.659600257874'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '8\\65', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '3', 'CumulativeMetersetWeight': '23.311901092529'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '8\\64', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '4', 'CumulativeMetersetWeight': '23.311901092529'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '8\\64', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '5', 'CumulativeMetersetWeight': '35.045303344727'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '11\\64', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-90\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '6', 'CumulativeMetersetWeight': '35.045303344727'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '11\\64', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-90\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '7', 'CumulativeMetersetWeight': '46.697601318359'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '12\\49', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-10\\30', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '8', 'CumulativeMetersetWeight': '46.697601318359'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '12\\49', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-10\\30', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '9', 'CumulativeMetersetWeight': '65.040702819824'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '8\\65', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '10', 'CumulativeMetersetWeight': '65.040702819824'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '8\\65', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '11', 'CumulativeMetersetWeight': '76.693000793457'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '32\\67', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '12', 'CumulativeMetersetWeight': '76.693000793457'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '32\\67', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '13', 'CumulativeMetersetWeight': '88.347801208496'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '52\\70', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '14', 'CumulativeMetersetWeight': '88.347801208496'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '52\\70', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '15', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'InstitutionName': 'CGMH Kaohsiung Hospital', 'Manufacturer': 'Elekta', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '16', 'NumberOfWedges': '0', 'PrimaryDosimeterUnit': 'MU', 'RadiationType': 'PHOTON', 'ReferencedPatientSetupNumber': '1', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}, {'LeafPositionBoundaries': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200', 'NumberOfLeafJawPairs': '40', 'RTBeamLimitingDeviceType': 'MLCX', 'SourceToBeamLimitingDeviceDistance': '373'}], 'BeamName': 'LPO', 'BeamNumber': '5', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '180.0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-45\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'BeamLimitingDeviceRotationDirection': 'NONE', 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '130.0', 'GantryRotationDirection': 'NONE', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '6', 'PatientSupportAngle': '0.0', 'PatientSupportRotationDirection': 'NONE', 'SourceToSurfaceDistance': '842.72644042969', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-45\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '1', 'CumulativeMetersetWeight': '14.15860080719'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-46\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '2', 'CumulativeMetersetWeight': '14.15860080719'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-46\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\60', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '3', 'CumulativeMetersetWeight': '29.429500579834'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-46\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\40', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '4', 'CumulativeMetersetWeight': '29.429500579834'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-46\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-120\\40', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '5', 'CumulativeMetersetWeight': '43.237701416016'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-40\\8', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '6', 'CumulativeMetersetWeight': '43.237701416016'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-40\\8', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '7', 'CumulativeMetersetWeight': '57.035499572754'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-27\\-5', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': '0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\-22.7\\-27.3\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\-5\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17', 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '8', 'CumulativeMetersetWeight': '57.035499572754'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-27\\-5', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': '0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\0\\-22.7\\-27.3\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\-23\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\6\\-5\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17\\-17', 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '9', 'CumulativeMetersetWeight': '72.397003173828'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-53\\-31', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '10', 'CumulativeMetersetWeight': '72.397003173828'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-53\\-31', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '11', 'CumulativeMetersetWeight': '86.197105407715'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-50\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '12', 'CumulativeMetersetWeight': '86.197105407715'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-50\\6', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '13', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'InstitutionName': 'CGMH Kaohsiung Hospital', 'Manufacturer': 'Elekta', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '14', 'NumberOfWedges': '0', 'PrimaryDosimeterUnit': 'MU', 'RadiationType': 'PHOTON', 'ReferencedPatientSetupNumber': '1', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}, {'LeafPositionBoundaries': '-200\\-190\\-180\\-170\\-160\\-150\\-140\\-130\\-120\\-110\\-100\\-90\\-80\\-70\\-60\\-50\\-40\\-30\\-20\\-10\\0\\10\\20\\30\\40\\50\\60\\70\\80\\90\\100\\110\\120\\130\\140\\150\\160\\170\\180\\190\\200', 'NumberOfLeafJawPairs': '40', 'RTBeamLimitingDeviceType': 'MLCX', 'SourceToBeamLimitingDeviceDistance': '373'}], 'BeamName': 'Beam_1', 'BeamNumber': '6', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '180.0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-41\\19', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'BeamLimitingDeviceRotationDirection': 'NONE', 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '0.0', 'GantryRotationDirection': 'NONE', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '6', 'PatientSupportAngle': '0.0', 'PatientSupportRotationDirection': 'NONE', 'SourceToSurfaceDistance': '888.38330078125', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-41\\19', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '1', 'CumulativeMetersetWeight': '8.4758701324463'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '2', 'CumulativeMetersetWeight': '8.4758701324463'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '3', 'CumulativeMetersetWeight': '17.845390319824'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-40\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '4', 'CumulativeMetersetWeight': '17.845390319824'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-40\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '5', 'CumulativeMetersetWeight': '27.089790344238'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '6', 'CumulativeMetersetWeight': '27.089790344238'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '7', 'CumulativeMetersetWeight': '36.125068664551'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\19', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '8', 'CumulativeMetersetWeight': '36.125068664551'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-39\\19', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '9', 'CumulativeMetersetWeight': '42.749420166016'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-35\\16', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '10', 'CumulativeMetersetWeight': '42.749420166016'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-35\\16', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\20', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '11', 'CumulativeMetersetWeight': '49.826728820801'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-36\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-100\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '12', 'CumulativeMetersetWeight': '49.826728820801'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-36\\17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-100\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '13', 'CumulativeMetersetWeight': '58.011497497559'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-17\\15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': '-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-17.3\\-4.9\\-8.7\\3.3\\2.5\\6.4\\-4.8\\4.7\\7.5\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\3\\3\\3\\3\\3\\3\\3\\3\\3\\9.7\\10\\10.8\\15\\13.4\\13.7\\15\\15\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26', 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '14', 'CumulativeMetersetWeight': '58.011497497559'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-17\\15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-110\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': '-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-3\\-17.3\\-4.9\\-8.7\\3.3\\2.5\\6.4\\-4.8\\4.7\\7.5\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\20\\3\\3\\3\\3\\3\\3\\3\\3\\3\\9.7\\10\\10.8\\15\\13.4\\13.7\\15\\15\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26\\26', 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '15', 'CumulativeMetersetWeight': '64.890190124512'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-17\\15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '16', 'CumulativeMetersetWeight': '64.890190124512'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-17\\15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '17', 'CumulativeMetersetWeight': '72.930023193359'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-34\\10', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '18', 'CumulativeMetersetWeight': '72.930023193359'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-34\\10', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '0\\50', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '19', 'CumulativeMetersetWeight': '82.063690185547'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-30\\-17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-100\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '20', 'CumulativeMetersetWeight': '82.063690185547'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-30\\-17', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-100\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '21', 'CumulativeMetersetWeight': '87.765983581543'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-35\\11', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '22', 'CumulativeMetersetWeight': '87.765983581543'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-35\\11', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '23', 'CumulativeMetersetWeight': '95.900955200195'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-35\\15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-80\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '24', 'CumulativeMetersetWeight': '95.900955200195'}, {'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-35\\15', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-80\\0', 'RTBeamLimitingDeviceType': 'ASYMY'}, {'LeafJawPositions': None, 'RTBeamLimitingDeviceType': 'MLCX'}], 'ControlPointIndex': '25', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'InstitutionName': 'CGMH Kaohsiung Hospital', 'Manufacturer': 'Elekta', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '26', 'NumberOfWedges': '0', 'PrimaryDosimeterUnit': 'MU', 'RadiationType': 'PHOTON', 'ReferencedPatientSetupNumber': '1', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}], 'BeamName': 'Left', 'BeamNumber': '7', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-50\\50', 'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\50', 'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY'}], 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '90', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '6', 'PatientSupportAngle': '0', 'SourceToSurfaceDistance': '839.37811279297', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'ControlPointIndex': '1', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '2', 'NumberOfWedges': '0', 'RadiationType': 'PHOTON', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}, {'BeamLimitingDeviceSequence': [{'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX', 'SourceToBeamLimitingDeviceDistance': '426'}, {'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY', 'SourceToBeamLimitingDeviceDistance': '509'}], 'BeamName': 'Anterior', 'BeamNumber': '8', 'BeamType': 'STATIC', 'ControlPointSequence': [{'BeamLimitingDeviceAngle': '0', 'BeamLimitingDevicePositionSequence': [{'LeafJawPositions': '-50\\50', 'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMX'}, {'LeafJawPositions': '-50\\50', 'NumberOfLeafJawPairs': '1', 'RTBeamLimitingDeviceType': 'ASYMY'}], 'ControlPointIndex': '0', 'CumulativeMetersetWeight': '0', 'GantryAngle': '0', 'IsocenterPosition': '0.46875\\-2.0114898681641\\-2.5', 'NominalBeamEnergy': '6', 'PatientSupportAngle': '0', 'SourceToSurfaceDistance': '888.38330078125', 'TableTopEccentricAngle': '0.0', 'TableTopEccentricRotationDirection': 'NONE', 'TableTopLateralPosition': '', 'TableTopLongitudinalPosition': '', 'TableTopVerticalPosition': ''}, {'ControlPointIndex': '1', 'CumulativeMetersetWeight': '100'}], 'FinalCumulativeMetersetWeight': '100', 'NumberOfBlocks': '0', 'NumberOfBoli': '0', 'NumberOfCompensators': '0', 'NumberOfControlPoints': '2', 'NumberOfWedges': '0', 'RadiationType': 'PHOTON', 'SourceAxisDistance': '1000', 'TreatmentDeliveryType': 'TREATMENT', 'TreatmentMachineName': 'L9'}], 'BrachyApplicationSetupDose': '12.0', 'BrachyTreatmentType': 'HDR', 'FractionGroupSequence': [{'FractionGroupNumber': '0', 'NumberOfBeams': '8', 'NumberOfBrachyApplicationSetups': '0', 'NumberOfFractionsPlanned': '28', 'ReferencedBeamSequence': [{'BeamDose': '0.41496029496193', 'BeamDoseSpecificationPoint': '0.46875\\-2.0114898681641\\-2.5', 'BeamMeterset': '130', 'ReferencedBeamNumber': '1'}, {'BeamDose': '0.00661952001974', 'BeamDoseSpecificationPoint': '0.46875\\-2.0114898681641\\-2.5', 'BeamMeterset': '31', 'ReferencedBeamNumber': '2'}, {'BeamDose': '0.00487405480817', 'BeamDoseSpecificationPoint': '0.46875\\-2.0114898681641\\-2.5', 'BeamMeterset': '50', 'ReferencedBeamNumber': '3'}, {'BeamDose': '0.01596663147211', 'BeamDoseSpecificationPoint': '0.46875\\-2.0114898681641\\-2.5', 'BeamMeterset': '53', 'ReferencedBeamNumber': '4'}, {'BeamDose': '0.02598128095269', 'BeamDoseSpecificationPoint': '0.46875\\-2.0114898681641\\-2.5', 'BeamMeterset': '45', 'ReferencedBeamNumber': '5'}, {'BeamDose': '0.70787841081619', 'BeamDoseSpecificationPoint': '0.46875\\-2.0114898681641\\-2.5', 'BeamMeterset': '177', 'ReferencedBeamNumber': '6'}, {'BeamDose': '0', 'BeamMeterset': '0', 'ReferencedBeamNumber': '7'}, {'BeamDose': '0', 'BeamMeterset': '0', 'ReferencedBeamNumber': '8'}], 'ReferencedBrachyApplicationSetupSequence': [{'BrachyApplicationSetupDose': '12.0'}]}], 'FrameOfReferenceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', 'InstanceCreationDate': '20100301', 'InstanceCreationTime': '170155', 'Manufacturer': 'ADAC', 'ManufacturerModelName': 'Pinnacle3', 'Modality': 'RTPLAN', 'OperatorsName': '', 'PatientBirthDate': '', 'PatientID': '03HDQ000', 'PatientName': 'MR-R', 'PatientSetupSequence': [{'PatientPosition': 'HFS', 'PatientSetupNumber': '1'}], 'PatientSex': 'M', 'PositionReferenceIndicator': '', 'RTPlanDate': '20100301', 'RTPlanGeometry': 'PATIENT', 'RTPlanLabel': 'Plan_0.0', 'RTPlanName': 'LIVE', 'RTPlanTime': '170155', 'ReferencedStructureSetSequence': [{'ReferencedSOPClassUID': '1.2.840.10008.5.1.4.1.1.481.3', 'ReferencedSOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170148.768438'}], 'ReferencedStudySequence': [{'ReferencedSOPClassUID': '1.2.840.10008.3.1.2.3.2', 'ReferencedSOPInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}], 'ReferringPhysicianName': '', 'SOPClassUID': '1.2.840.10008.5.1.4.1.1.481.5', 'SOPInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170155.103167', 'SeriesInstanceUID': '2.16.840.1.113669.2.931128.981194414.20100301170148.767977', 'SeriesNumber': '', 'SoftwareVersions': 'OCP x.x', 'StationName': 'pinnc-2', 'StudyDate': '20100223', 'StudyID': '', 'StudyInstanceUID': '1.2.840.113619.2.55.3.671782272.419.1266452812.128', 'StudyTime': '', 'TreatmentSites': 'prostate'}}
INSTANCE_TAGS_IN_SHORTER_VERSION = {'22dcf059-8fd3ade7-efb39ca3-7f46b248-0200abc9': {'0008,0012': '20100301', '0008,0013': '170155', '0008,0016': '1.2.840.10008.5.1.4.1.1.481.2', '0008,0018': '2.16.840.1.113669.2.931128.981194414.20100301170155.668389', '0008,0020': '20100223', '0008,0023': '20100301', '0008,0030': '', '0008,0033': '170155', '0008,0050': '', '0008,0060': 'RTDOSE', '0008,0070': 'ADAC', '0008,0090': '', '0008,1010': 'pinnc-2', '0008,1090': 'Pinnacle3', '0008,1110': [{'0008,1150': '1.2.840.10008.3.1.2.3.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}], '0010,0010': 'MR-R', '0010,0020': '03HDQ000', '0010,0030': '', '0010,0040': 'M', '0018,0050': '4', '0018,1020': 'OCP x.x', '0020,000d': '1.2.840.113619.2.55.3.671782272.419.1266452812.128', '0020,000e': '2.16.840.1.113669.2.931128.981194414.20100301170148.767969', '0020,0010': '', '0020,0011': '', '0020,0013': '1', '0020,0032': '-223.9880065918\\-158.08148193359\\-117.78499603271', '0020,0037': '1\\0\\0\\0\\1\\0', '0020,0052': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '0020,1040': '', '0028,0002': '1', '0028,0004': 'MONOCHROME2', '0028,0008': '75', '0028,0009': '3004,000c', '0028,0010': '88', '0028,0011': '114', '0028,0030': '4\\4', '0028,0100': '16', '0028,0101': '16', '0028,0102': '15', '0028,0103': '0', '3004,0002': 'GY', '3004,0004': 'PHYSICAL', '3004,000a': 'PLAN', '3004,000c': None, '3004,000e': '0.00341018638574', '300c,0002': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.481.5', '0008,1155': '2.16.840.1.113669.2.931128.981194414.20100301170155.103167'}], '7fe0,0010': None}, '348befe7-5be5ff53-70120381-3baa0cc2-e4e04220': {'0008,0012': '20100301', '0008,0013': '170155', '0008,0016': '1.2.840.10008.5.1.4.1.1.481.3', '0008,0018': '2.16.840.1.113669.2.931128.981194414.20100301170148.768438', '0008,0020': '20100223', '0008,0030': '', '0008,0050': '', '0008,0060': 'RTSTRUCT', '0008,0070': 'ADAC', '0008,0090': '', '0008,1010': 'pinnc-2', '0008,103e': 'Pinnacle POI', '0008,1090': 'Pinnacle3', '0008,1110': [{'0008,1150': '1.2.840.10008.3.1.2.3.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.128'}], '0010,0010': 'MR-R', '0010,0020': '03HDQ000', '0010,0030': '', '0010,0040': 'M', '0018,1020': 'OCP x.x', '0020,000d': '1.2.840.113619.2.55.3.671782272.419.1266452812.128', '0020,000e': '2.16.840.1.113669.2.931128.981194414.20100301170148.767959', '0020,0010': '', '0020,0011': '', '3006,0002': 'Plan_0', '3006,0004': 'POIandROI', '3006,0008': '20100301', '3006,0009': '170148', '3006,0010': [{'0020,0052': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0012': [{'0008,1150': '1.2.840.10008.3.1.2.3.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.128', '3006,0014': [{'0020,000e': '1.2.840.113619.2.55.3.671782272.419.1266452812.133', '3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.1'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.2'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.3'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.4'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.5'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.6'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.7'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.129'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.130'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.131'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.132'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.133'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.134'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.135'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.136'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.137'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.138'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.139'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.140'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.141'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.142'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.143'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.144'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.145'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.146'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.147'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.148'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.149'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.150'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.151'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.152'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.153'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.154'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.155'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.156'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.157'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.158'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.159'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.160'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.161'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.162'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.163'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.164'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.165'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.166'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.167'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.168'}, {'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.169'}]}]}]}], '3006,0020': [{'3006,0022': '1', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'POI_1', '3006,0036': ''}, {'3006,0022': '2', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'PTV_ESO', '3006,0036': ''}, {'3006,0022': '3', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'R LUNG', '3006,0036': ''}, {'3006,0022': '4', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'L LUNG', '3006,0036': ''}, {'3006,0022': '5', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'SC', '3006,0036': ''}, {'3006,0022': '6', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'TOTAL LUNG', '3006,0036': ''}, {'3006,0022': '7', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'RING', '3006,0036': ''}, {'3006,0022': '8', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'BODY', '3006,0036': ''}, {'3006,0022': '9', '3006,0024': '1.2.840.113619.2.55.3.671782272.419.1266452812.130.10825.1', '3006,0026': 'ROI_1', '3006,0036': ''}], '3006,0039': [{'3006,002a': '255\\0\\0', '3006,0040': [{'3006,0042': 'POINT', '3006,0046': '1', '3006,0050': '0.46875\\-2.0114898681641\\-2.5'}], '3006,0084': '1'}, {'3006,002a': '255\\0\\0', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '113', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '109', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '93', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '110', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '100', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '102', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '109', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '109', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '106', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '106', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '112', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '108', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '99', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '104', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '109', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '99', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '104', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '101', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '103', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '110', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '105', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '97', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '105', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '90', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '92', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '85', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '93', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '87', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '88', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '88', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '108', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '106', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '94', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '107', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '104', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '97', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '87', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '84', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '86', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '114', '3006,0050': None}], '3006,0084': '2'}, {'3006,002a': '0\\255\\0', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '70', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '96', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '125', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '162', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '208', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '258', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '203', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '212', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '224', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '235', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '248', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '273', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '310', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '289', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '289', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '298', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '308', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '324', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '352', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '333', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '348', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '362', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '364', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '364', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '384', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '394', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '391', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '403', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '409', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '416', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '415', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '420', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '434', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '428', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '432', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '460', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '456', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '460', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '442', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '443', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '430', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '395', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '382', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '328', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '289', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '227', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '183', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '138', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '349', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '439', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '441', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '447', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '425', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '399', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '402', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '374', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '382', '3006,0050': None}], '3006,0084': '3'}, {'3006,002a': '0\\0\\255', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '207', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '256', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '272', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '362', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '412', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '382', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '303', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '293', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '271', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '272', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '235', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '221', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '214', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '191', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '162', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '123', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '103', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '64', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '384', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '319', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '327', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '339', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '248', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '263', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '172', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '184', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '439', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '420', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '376', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '432', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '433', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '439', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '434', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '9', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '26', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '427', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '24', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '430', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '24', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '450', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '443', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '430', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '426', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '425', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '422', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '420', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '417', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '416', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '410', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '407', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '410', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '410', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '400', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '375', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '360', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '347', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '346', '3006,0050': None}], '3006,0084': '4'}, {'3006,002a': '255\\255\\0', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '36', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '39', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '37', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.7'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '84', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '78', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '69', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '55', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '51', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '59', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '61', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '42', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '42', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '51', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '52', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '53', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '53', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '55', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '56', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.83'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '55', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '48', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '54', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.89'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '51', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '52', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '53', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '51', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '50', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.96'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '52', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '49', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '60', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '61', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.102'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '59', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '55', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '54', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.109'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '53', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.110'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '55', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '48', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '54', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '54', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '58', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '61', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '64', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '60', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.82'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '52', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '54', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '50', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '42', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '48', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '42', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '51', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '50', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '42', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '38', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '37', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '39', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '46', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '37', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '42', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '44', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '40', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '39', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '48', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '44', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '39', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '39', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '39', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '40', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '50', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '46', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '45', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.123'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '63', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '65', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '67', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '57', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '54', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '44', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '47', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '48', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '52', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '43', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '41', '3006,0050': None}], '3006,0084': '5'}, {'3006,002a': '255\\0\\255', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '70', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '64', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '96', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '102', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '125', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '123', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '160', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '161', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.12'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '206', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '249', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.13'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '172', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '184', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.14'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '202', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '210', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '191', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '223', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '213', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '235', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '220', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '248', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '233', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '248', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '272', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.19'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '8', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '263', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.20'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '304', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '272', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.21'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '283', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '288', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '271', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '297', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '288', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '4', '3006,0050': '32.343799591064\\7.9684829711914\\117.5\\31.406200408936\\7.0315170288086\\117.5\\30.468799591064\\7.9684829711914\\117.5\\31.406200408936\\8.9065170288086\\117.5'}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '307', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '303', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '324', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.25'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '319', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '352', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.26'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '327', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '333', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.27'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '339', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '347', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '346', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '360', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '347', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '363', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '360', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '364', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '375', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '374', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '382', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '400', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '384', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '410', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '391', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '410', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '391', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '407', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '410', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '416', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '399', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '417', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '402', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '420', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '402', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '422', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '409', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '425', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '414', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '426', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '414', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '430', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '419', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '443', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '425', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '450', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '431', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '430', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '24', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '432', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '427', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '24', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '427', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '26', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '432', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '434', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '9', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '439', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '441', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '447', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '460', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '433', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '455', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '435', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '434', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '25', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '432', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '439', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '439', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '438', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '437', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '440', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '443', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '436', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '429', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '420', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '393', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '376', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '379', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '384', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.68'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '349', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '380', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.69'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '323', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '377', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '25', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '286', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '360', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '225', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '272', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '183', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '250', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '138', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '204', '3006,0050': None}], '3006,0084': '6'}, {'3006,002a': '255\\0\\0', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '124', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.28'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '88', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '126', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '90', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '125', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '89', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '127', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '91', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '128', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.32'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '92', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '128', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.33'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '92', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '131', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.34'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '96', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '130', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.35'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '94', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '133', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '97', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '137', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '101', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '141', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '105', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '144', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.39'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '108', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '139', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.40'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '103', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '145', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.41'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '109', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '140', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.42'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '104', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '149', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '113', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '150', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '114', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '149', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '114', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '143', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.46'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '107', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '133', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.47'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '97', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '139', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.48'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '103', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '144', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '108', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '149', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '113', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '147', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '111', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '145', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '109', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '144', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.53'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '108', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '148', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.54'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '112', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '148', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.55'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '112', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '154', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.56'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '118', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '152', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '116', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '153', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '117', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '149', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '113', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '149', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.60'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '113', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '146', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.61'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '110', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '146', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.62'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '110', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '146', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '110', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '142', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '106', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '137', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '101', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '133', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '98', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '126', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.67'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '91', '3006,0050': None}], '3006,0084': '7'}, {'3006,002a': '0\\255\\0', '3006,0040': [{'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.23'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1030', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.24'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1034', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.22'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1083', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.18'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1015', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.16'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '969', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.15'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '957', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.11'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '833', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.10'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '761', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.9'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '735', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.8'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '691', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.17'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '982', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.31'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1067', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.30'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1050', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.29'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1028', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.37'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1028', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.36'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1036', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.38'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '1018', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.43'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '944', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.44'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '937', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.45'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '933', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.49'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '943', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.50'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '916', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.51'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '916', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.52'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '923', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.57'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '896', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.58'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '944', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.59'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '938', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.63'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '875', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.64'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '874', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.66'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '870', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.65'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '873', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.70'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '860', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.73'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '854', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.72'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '857', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.71'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '859', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.74'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '851', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.75'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '847', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.76'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '844', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.79'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '835', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.78'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '838', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.77'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '842', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.80'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '832', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.81'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '828', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.84'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '820', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.85'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '816', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.88'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '806', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.87'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '809', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.86'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '813', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.90'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '803', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.91'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '801', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.94'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '792', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.93'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '797', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.92'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '798', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.95'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '788', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.97'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '784', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.100'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '778', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.99'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '780', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.98'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '782', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.101'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '776', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.103'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '783', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.106'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '770', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.105'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '769', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.104'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '771', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.107'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '772', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.108'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '766', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.111'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '763', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.112'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '761', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.115'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '763', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.114'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '762', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.113'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '761', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.116'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '789', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.117'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '762', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.118'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '764', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.121'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '776', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.120'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '769', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.119'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '765', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.122'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '786', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.124'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '776', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.127'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '787', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.126'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '782', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.125'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '779', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.128'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '792', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.129'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '796', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.132'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '806', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.131'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '802', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.133'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '810', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.136'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '907', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.135'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '819', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.134'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '815', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.138'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '826', '3006,0050': None}, {'3006,0016': [{'0008,1150': '1.2.840.10008.5.1.4.1.1.2', '0008,1155': '1.2.840.113619.2.55.3.671782272.419.1266452812.261.139'}], '3006,0042': 'CLOSED_PLANAR', '3006,0046': '830', '3006,0050':