"""
This module provides extra utilities that are not part of core ImGui C++ API
but are useful in Python application.

"""
from . import core

__all__ = (
    "text_ansi",
    "text_ansi_colored",
    "font",
    "styled",
    "istyled",
    "colored",
    "vertex_buffer_vertex_pos_offset",
    "vertex_buffer_vertex_uv_offset",
    "vertex_buffer_vertex_col_offset",
    "vertex_buffer_vertex_size",
    "index_buffer_index_size",
)

text_ansi = core._ansifeed_text_ansi
text_ansi_colored = core._ansifeed_text_ansi_colored

font = core._py_font
styled = core._py_styled
istyled = core._py_istyled
colored = core._py_colored
scoped = core._py_scoped

vertex_buffer_vertex_pos_offset = core._py_vertex_buffer_vertex_pos_offset
vertex_buffer_vertex_uv_offset = core._py_vertex_buffer_vertex_uv_offset
vertex_buffer_vertex_col_offset = core._py_vertex_buffer_vertex_col_offset
vertex_buffer_vertex_size = core._py_vertex_buffer_vertex_size
index_buffer_index_size = core._py_index_buffer_index_size
