import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnAnnotationStore`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html
 */
export interface CfnAnnotationStoreProps {
    /**
     * The name of the Annotation Store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-name
     */
    readonly name: string;
    /**
     * The annotation file format of the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeformat
     */
    readonly storeFormat: string;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-description
     */
    readonly description?: string;
    /**
     * The genome reference for the store's annotations.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-reference
     */
    readonly reference?: CfnAnnotationStore.ReferenceItemProperty | cdk.IResolvable;
    /**
     * The store's server-side encryption (SSE) settings.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-sseconfig
     */
    readonly sseConfig?: CfnAnnotationStore.SseConfigProperty | cdk.IResolvable;
    /**
     * File parsing options for the annotation store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeoptions
     */
    readonly storeOptions?: CfnAnnotationStore.StoreOptionsProperty | cdk.IResolvable;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Omics::AnnotationStore`
 *
 * Creates an annotation store.
 *
 * @cloudformationResource AWS::Omics::AnnotationStore
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html
 */
export declare class CfnAnnotationStore extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Omics::AnnotationStore";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnnotationStore;
    /**
     * When the store was created.
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * The store's ID.
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The store's status.
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * The store's status message.
     * @cloudformationAttribute StatusMessage
     */
    readonly attrStatusMessage: string;
    /**
     * The store's ARN.
     * @cloudformationAttribute StoreArn
     */
    readonly attrStoreArn: string;
    /**
     * The store's size in bytes.
     * @cloudformationAttribute StoreSizeBytes
     */
    readonly attrStoreSizeBytes: cdk.IResolvable;
    /**
     * When the store was updated.
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * The name of the Annotation Store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-name
     */
    name: string;
    /**
     * The annotation file format of the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeformat
     */
    storeFormat: string;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-description
     */
    description: string | undefined;
    /**
     * The genome reference for the store's annotations.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-reference
     */
    reference: CfnAnnotationStore.ReferenceItemProperty | cdk.IResolvable | undefined;
    /**
     * The store's server-side encryption (SSE) settings.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-sseconfig
     */
    sseConfig: CfnAnnotationStore.SseConfigProperty | cdk.IResolvable | undefined;
    /**
     * File parsing options for the annotation store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-storeoptions
     */
    storeOptions: CfnAnnotationStore.StoreOptionsProperty | cdk.IResolvable | undefined;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-annotationstore.html#cfn-omics-annotationstore-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Omics::AnnotationStore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnnotationStoreProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAnnotationStore {
    /**
     * A genome reference.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-referenceitem.html
     */
    interface ReferenceItemProperty {
        /**
         * The reference's ARN.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-referenceitem.html#cfn-omics-annotationstore-referenceitem-referencearn
         */
        readonly referenceArn: string;
    }
}
export declare namespace CfnAnnotationStore {
    /**
     * Server-side encryption (SSE) settings for a store.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-sseconfig.html
     */
    interface SseConfigProperty {
        /**
         * An encryption key ARN.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-sseconfig.html#cfn-omics-annotationstore-sseconfig-keyarn
         */
        readonly keyArn?: string;
        /**
         * The encryption type.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-sseconfig.html#cfn-omics-annotationstore-sseconfig-type
         */
        readonly type: string;
    }
}
export declare namespace CfnAnnotationStore {
    /**
     * The store's file parsing options.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-storeoptions.html
     */
    interface StoreOptionsProperty {
        /**
         * Formatting options for a TSV file.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-storeoptions.html#cfn-omics-annotationstore-storeoptions-tsvstoreoptions
         */
        readonly tsvStoreOptions: CfnAnnotationStore.TsvStoreOptionsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnAnnotationStore {
    /**
     * The store's parsing options.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-tsvstoreoptions.html
     */
    interface TsvStoreOptionsProperty {
        /**
         * The store's annotation type.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-tsvstoreoptions.html#cfn-omics-annotationstore-tsvstoreoptions-annotationtype
         */
        readonly annotationType?: string;
        /**
         * The store's header key to column name mapping.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-tsvstoreoptions.html#cfn-omics-annotationstore-tsvstoreoptions-formattoheader
         */
        readonly formatToHeader?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * The schema of an annotation store.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-annotationstore-tsvstoreoptions.html#cfn-omics-annotationstore-tsvstoreoptions-schema
         */
        readonly schema?: any | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `CfnReferenceStore`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html
 */
export interface CfnReferenceStoreProps {
    /**
     * A name for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-name
     */
    readonly name: string;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-description
     */
    readonly description?: string;
    /**
     * Server-side encryption (SSE) settings for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-sseconfig
     */
    readonly sseConfig?: CfnReferenceStore.SseConfigProperty | cdk.IResolvable;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Omics::ReferenceStore`
 *
 * Creates a reference store.
 *
 * @cloudformationResource AWS::Omics::ReferenceStore
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html
 */
export declare class CfnReferenceStore extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Omics::ReferenceStore";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReferenceStore;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * When the store was created.
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * The store's ID.
     * @cloudformationAttribute ReferenceStoreId
     */
    readonly attrReferenceStoreId: string;
    /**
     * A name for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-name
     */
    name: string;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-description
     */
    description: string | undefined;
    /**
     * Server-side encryption (SSE) settings for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-sseconfig
     */
    sseConfig: CfnReferenceStore.SseConfigProperty | cdk.IResolvable | undefined;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-referencestore.html#cfn-omics-referencestore-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Omics::ReferenceStore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReferenceStoreProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnReferenceStore {
    /**
     * Server-side encryption (SSE) settings for a store.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-referencestore-sseconfig.html
     */
    interface SseConfigProperty {
        /**
         * An encryption key ARN.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-referencestore-sseconfig.html#cfn-omics-referencestore-sseconfig-keyarn
         */
        readonly keyArn?: string;
        /**
         * The encryption type.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-referencestore-sseconfig.html#cfn-omics-referencestore-sseconfig-type
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `CfnRunGroup`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html
 */
export interface CfnRunGroupProps {
    /**
     * The group's maximum CPU count setting.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxcpus
     */
    readonly maxCpus?: number;
    /**
     * The group's maximum duration setting in minutes.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxduration
     */
    readonly maxDuration?: number;
    /**
     * The group's maximum concurrent run setting.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxruns
     */
    readonly maxRuns?: number;
    /**
     * The group's name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-name
     */
    readonly name?: string;
    /**
     * Tags for the group.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Omics::RunGroup`
 *
 * Creates a run group.
 *
 * @cloudformationResource AWS::Omics::RunGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html
 */
export declare class CfnRunGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Omics::RunGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRunGroup;
    /**
     * The run group's ARN.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * When the run group was created.
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * The run group's ID.
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The group's maximum CPU count setting.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxcpus
     */
    maxCpus: number | undefined;
    /**
     * The group's maximum duration setting in minutes.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxduration
     */
    maxDuration: number | undefined;
    /**
     * The group's maximum concurrent run setting.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-maxruns
     */
    maxRuns: number | undefined;
    /**
     * The group's name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-name
     */
    name: string | undefined;
    /**
     * Tags for the group.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-rungroup.html#cfn-omics-rungroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Omics::RunGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRunGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnSequenceStore`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html
 */
export interface CfnSequenceStoreProps {
    /**
     * A name for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-name
     */
    readonly name: string;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-description
     */
    readonly description?: string;
    /**
     * Server-side encryption (SSE) settings for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-sseconfig
     */
    readonly sseConfig?: CfnSequenceStore.SseConfigProperty | cdk.IResolvable;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Omics::SequenceStore`
 *
 * Creates a sequence store.
 *
 * @cloudformationResource AWS::Omics::SequenceStore
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html
 */
export declare class CfnSequenceStore extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Omics::SequenceStore";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSequenceStore;
    /**
     * The store's ARN.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * When the store was created.
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * The store's ID.
     * @cloudformationAttribute SequenceStoreId
     */
    readonly attrSequenceStoreId: string;
    /**
     * A name for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-name
     */
    name: string;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-description
     */
    description: string | undefined;
    /**
     * Server-side encryption (SSE) settings for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-sseconfig
     */
    sseConfig: CfnSequenceStore.SseConfigProperty | cdk.IResolvable | undefined;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-sequencestore.html#cfn-omics-sequencestore-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Omics::SequenceStore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSequenceStoreProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSequenceStore {
    /**
     * Server-side encryption (SSE) settings for a store.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-sequencestore-sseconfig.html
     */
    interface SseConfigProperty {
        /**
         * An encryption key ARN.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-sequencestore-sseconfig.html#cfn-omics-sequencestore-sseconfig-keyarn
         */
        readonly keyArn?: string;
        /**
         * The encryption type.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-sequencestore-sseconfig.html#cfn-omics-sequencestore-sseconfig-type
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `CfnVariantStore`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html
 */
export interface CfnVariantStoreProps {
    /**
     * A name for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-name
     */
    readonly name: string;
    /**
     * The genome reference for the store's variants.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-reference
     */
    readonly reference: CfnVariantStore.ReferenceItemProperty | cdk.IResolvable;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-description
     */
    readonly description?: string;
    /**
     * Server-side encryption (SSE) settings for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-sseconfig
     */
    readonly sseConfig?: CfnVariantStore.SseConfigProperty | cdk.IResolvable;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Omics::VariantStore`
 *
 * Create a store for variant data.
 *
 * @cloudformationResource AWS::Omics::VariantStore
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html
 */
export declare class CfnVariantStore extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Omics::VariantStore";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVariantStore;
    /**
     * When the store was created.
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * The store's ID.
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The store's status.
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * The store's status message.
     * @cloudformationAttribute StatusMessage
     */
    readonly attrStatusMessage: string;
    /**
     * The store's ARN.
     * @cloudformationAttribute StoreArn
     */
    readonly attrStoreArn: string;
    /**
     * The store's size in bytes.
     * @cloudformationAttribute StoreSizeBytes
     */
    readonly attrStoreSizeBytes: cdk.IResolvable;
    /**
     * When the store was updated.
     * @cloudformationAttribute UpdateTime
     */
    readonly attrUpdateTime: string;
    /**
     * A name for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-name
     */
    name: string;
    /**
     * The genome reference for the store's variants.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-reference
     */
    reference: CfnVariantStore.ReferenceItemProperty | cdk.IResolvable;
    /**
     * A description for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-description
     */
    description: string | undefined;
    /**
     * Server-side encryption (SSE) settings for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-sseconfig
     */
    sseConfig: CfnVariantStore.SseConfigProperty | cdk.IResolvable | undefined;
    /**
     * Tags for the store.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-variantstore.html#cfn-omics-variantstore-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Omics::VariantStore`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVariantStoreProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnVariantStore {
    /**
     * The read set's genome reference ARN.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-variantstore-referenceitem.html
     */
    interface ReferenceItemProperty {
        /**
         * The reference's ARN.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-variantstore-referenceitem.html#cfn-omics-variantstore-referenceitem-referencearn
         */
        readonly referenceArn: string;
    }
}
export declare namespace CfnVariantStore {
    /**
     * Server-side encryption (SSE) settings for a store.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-variantstore-sseconfig.html
     */
    interface SseConfigProperty {
        /**
         * An encryption key ARN.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-variantstore-sseconfig.html#cfn-omics-variantstore-sseconfig-keyarn
         */
        readonly keyArn?: string;
        /**
         * The encryption type.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-variantstore-sseconfig.html#cfn-omics-variantstore-sseconfig-type
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `CfnWorkflow`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html
 */
export interface CfnWorkflowProps {
    /**
     * The URI of a definition for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionuri
     */
    readonly definitionUri?: string;
    /**
     * The parameter's description.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-description
     */
    readonly description?: string;
    /**
     * An engine for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-engine
     */
    readonly engine?: string;
    /**
     * The path of the main definition file for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-main
     */
    readonly main?: string;
    /**
     * The workflow's name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-name
     */
    readonly name?: string;
    /**
     * The workflow's parameter template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplate
     */
    readonly parameterTemplate?: {
        [key: string]: (CfnWorkflow.WorkflowParameterProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * A storage capacity for the workflow in gigabytes.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-storagecapacity
     */
    readonly storageCapacity?: number;
    /**
     * Tags for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::Omics::Workflow`
 *
 * Creates a workflow.
 *
 * @cloudformationResource AWS::Omics::Workflow
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html
 */
export declare class CfnWorkflow extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Omics::Workflow";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkflow;
    /**
     * The ARN for the workflow.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * When the workflow was created.
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * The workflow's ID.
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The workflow's status.
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * The workflow's type.
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * The URI of a definition for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-definitionuri
     */
    definitionUri: string | undefined;
    /**
     * The parameter's description.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-description
     */
    description: string | undefined;
    /**
     * An engine for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-engine
     */
    engine: string | undefined;
    /**
     * The path of the main definition file for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-main
     */
    main: string | undefined;
    /**
     * The workflow's name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-name
     */
    name: string | undefined;
    /**
     * The workflow's parameter template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-parametertemplate
     */
    parameterTemplate: {
        [key: string]: (CfnWorkflow.WorkflowParameterProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * A storage capacity for the workflow in gigabytes.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-storagecapacity
     */
    storageCapacity: number | undefined;
    /**
     * Tags for the workflow.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflow.html#cfn-omics-workflow-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Omics::Workflow`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkflowProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnWorkflow {
    /**
     * A workflow parameter.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html
     */
    interface WorkflowParameterProperty {
        /**
         * The parameter's description.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html#cfn-omics-workflow-workflowparameter-description
         */
        readonly description?: string;
        /**
         * Whether the parameter is optional.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflow-workflowparameter.html#cfn-omics-workflow-workflowparameter-optional
         */
        readonly optional?: boolean | cdk.IResolvable;
    }
}
