# Pylint Nautobot

<p align="center">
  <img src="https://raw.githubusercontent.com/nautobot/pylint-nautobot/main/docs/images/icon-pylint-nautobot.png" class="logo" height="200px">
  <br>
  <a href="https://github.com/nautobot/pylint-nautobot/actions"><img src="https://github.com/nautobot/pylint-nautobot/actions/workflows/ci.yml/badge.svg?branch=main"></a>
  <a href="https://docs.nautobot.com/projects/pylint-nautobot/en/latest"><img src="https://readthedocs.org/projects/pylint-nautobot/badge/"></a>
  <a href="https://pypi.org/project/pylint-nautobot/"><img src="https://img.shields.io/pypi/v/pylint-nautobot"></a>
  <a href="https://pypi.org/project/pylint-nautobot/"><img src="https://img.shields.io/pypi/dm/pylint-nautobot"></a>
  <br>
  An collection of code linting rules for <a href="https://nautobot.com/">Nautobot</a>.
</p>

## Overview

This project contains custom [pylint](https://github.com/pylint-dev/pylint) rules for linting [Nautobot](https://github.com/nautobot/nautobot) and its Apps.

## Documentation

Full documentation for this project can be found over on the [Nautobot Docs](https://docs.nautobot.com) website:

- [Getting Started](https://docs.nautobot.com/projects/pylint-nautobot/en/latest/getting_started/).
- [Development](https://docs.nautobot.com/projects/pylint-nautobot/en/latest/development).
- [Release Notes / Changelog](https://docs.nautobot.com/projects/pylint-nautobot/en/latest/release_notes/).
- [Frequently Asked Questions](https://docs.nautobot.com/projects/pylint-nautobot/en/latest/faq/).

### Contributing to the Documentation

You can find all the Markdown source for the project documentation under the [`docs`](https://github.com/nautobot/pylint-nautobot/tree/main/docs) folder in this repository. For simple edits, a Markdown capable editor is sufficient: clone the repository and edit away.

If you need to view the fully-generated documentation site, you can build it with [MkDocs](https://www.mkdocs.org/) by running `invoke docs` in your local development environment. As your changes to the documentation files are saved, they will be automatically rebuilt and any pages currently being viewed will be reloaded in your browser.

Any PRs with fixes or improvements are very welcome!

## Questions

For any questions or comments, please check the [FAQ](https://docs.nautobot.com/projects/pylint-nautobot/en/latest/faq/) first. Feel free to also swing by the [Network to Code Slack](https://networktocode.slack.com/) (channel `#nautobot`), sign up [here](http://slack.networktocode.com/) if you don't have an account.
