# coding: utf-8

"""
    Aspose OCR Cloud 5.0 API

    Aspose OCR Cloud 5.0 API

    The version of the OpenAPI document: 5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from setuptools import setup, find_packages  # noqa: H301

# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools
NAME = "aspose-ocr-cloud"
VERSION = "24.8.0"
PYTHON_REQUIRES = ">=3.7"
REQUIRES = [
    "urllib3 >= 1.25.3, < 2.1.0",
    "python-dateutil",
    "pydantic >= 2",
    "typing-extensions >= 4.7.1",
]

setup(
    name=NAME,
    version=VERSION,
    description="Aspose OCR Cloud 5.0 API",
    author="Aspose",
    author_email="",
    url="https://pypi.org/project/aspose-ocr-cloud/",
    keywords=["OpenAPI", "OpenAPI-Generator", "Aspose OCR Cloud 5.0 API"],
    install_requires=REQUIRES,
    packages=find_packages(exclude=["test", "tests"]),
    include_package_data=True,
    license="License",
    long_description_content_type='text/markdown',
    long_description="""\
    # Aspose.OCR Cloud for Python SDK 24.8.0

![PyPI](https://img.shields.io/pypi/v/aspose-ocr-cloud) ![PyPI - Format](https://img.shields.io/pypi/format/aspose-ocr-cloud) ![PyPI - Downloads](https://img.shields.io/pypi/dm/aspose-ocr-cloud) [![GitHub license](https://img.shields.io/github/license/aspose-ocr-cloud/aspose-ocr-cloud-python)](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-python/blob/master/LICENSE)

[Aspose.OCR Cloud](https://products.aspose.cloud/ocr/) is an optical character recognition as a service. With it, you can easily add OCR functionality to almost any device or platform, including netbooks, mini PCs, or even entry-level smartphones.

Our engine can read text from images, photos, screenshots and scanned PDFs in a wide variety of European, Cyrillic and Oriental fonts, returning results in the most popular document formats. Powerful built-in image processing filters based on neural networks automatically correct skewed and distorted images, automatically remove dirt, smudges, scratches, glare and other image defects that can affect recognition accuracy. To further improve the results, Aspose.OCR Cloud has a built-in spell checker that automatically replaces misspelled words and saves you the trouble of manually correcting the recognition results.

Even the complex recognition tasks can be done with a couple of API calls. To make interacting with Aspose.OCR Cloud services from Python applications even easier, we provide the software development kit (SDK) for Python. It handles all the routine operations such as establishing connections, sending API requests, and parsing responses, wrapping all these tasks into a few simple classes.

Aspose.OCR Cloud SDK for Python is open source under the MIT license. You can freely use it for any projects, including commercial and proprietary applications, as well as modify any part of its code.

## Try Online
[Image to Text](https://products.aspose.app/ocr/scan-image) | [Image to Searchable PDF](https://products.aspose.app/ocr/ocr-to-pdf) | [PDF OCR](https://products.aspose.app/ocr/pdf-ocr)| [Receipt Scanner](https://products.aspose.app/ocr/scan-receipt)
:---: | :---: | :---:| :---:
[![Scan Image](https://products.aspose.app/ocr/scan-image/img/ocr-recognize-48.png)](https://products.aspose.app/ocr/scan-image) | [![Image to Searchable PDF](https://products.aspose.app/ocr/scan-image/img/ocr-to-pdf-4-48.png)](https://products.aspose.app/ocr/ocr-to-pdf) | [![PDF OCR](https://products.aspose.app/ocr/scan-image/img/ocr-to-pdf-2-48.png)](https://products.aspose.app/ocr/pdf-ocr) | [![Receipt Scanner](https://products.aspose.app/ocr/scan-image/img/aspose-scan-receipt-48.png)](https://products.aspose.app/ocr/scan-receipt) 


## What was changed in version 24.8.0

A summary of recent changes, enhancements and bug fixes in **Aspose.OCR Cloud SDK for .NET 24.8.0** release:

Key | Summary | Category
--- | ------- | --------
OCR&#8209;3930 | Added support for 149 recognition languages. | Enhancement

REST API changes: https://releases.aspose.cloud/ocr/release-notes/2024/aspose-ocr-cloud-24-8-0-release-notes/

### Public API changes and backwards compatibility

This section lists all public API changes introduced in **Aspose.OCR Cloud SDK for .NET 24.8.0** that may affect the code of existing applications.

#### Added public APIs:

_No changes._

#### Updated public APIs:

The following public APIs have been updated in this release:

#### JSON result type

{{% alert color="info" %}}
**Compatibility: fully backward compatible.**
{{% /alert %}}

Aspose.OCR Cloud greatly expands the number of languages supported. We have added a total of 149 languages based on Latin, Cyrillic, Chinese and Indic scripts. By default, the text is considered to be in _English_.

Language | Value
-------- | --------
Afrikaans | `Language.Afrikaans`
Albanian | `Language.Albanian`
Arabic | `Language.Arabic`
Awadhi | `Language.Awadhi`
Azerbaijani | `Language.Azerbaijani`
Belorussian | `Language.Belorussian`
Bemba | `Language.Bemba`
Bengali | `Language.Bengali`
Betawi | `Language.Betawi`
Bhojpuri | `Language.Bhojpuri`
Bikol | `Language.Bikol`
Bosnian | `Language.Bosnian`
Bouyei | `Language.Bouyei`
Bulgarian | `Language.Bulgarian`
Cantonese | `Language.Cantonese`
Catalan | `Language.Catalan`
Cebuano | `Language.Cebuano`
Chattisgarhi | `Language.Chattisgarhi`
Chechen | `Language.Chechen`
Chichewa | `Language.Chichewa`
Chinese | `Language.Chinese`
Croatian | `Language.Croatian`
Czech | `Language.Czech`
Danish | `Language.Danish`
Dhundari | `Language.Dhundari`
Dimli | `Language.Dimli`
Dong | `Language.Dong`
Dutch | `Language.Dutch`
English | `Language.English`
_Handwritten English_ | `Language.HWT_ENG`
Estonian | `Language.Estonian`
Finnish | `Language.Finnish`
French | `Language.French`
Galician | `Language.Galician`
Gan | `Language.Gan`
Garhwali | `Language.Garhwali`
Georgian | `Language.Georgian`
German | `Language.German`
Gilaki | `Language.Gilaki`
Greek | `Language.Greek`
Gusii | `Language.Gusii`
Hakka | `Language.Hakka`
Haryanvi | `Language.Haryanvi`
Hausa | `Language.Hausa`
Hebrew | `Language.Hebrew`
Hiligaynon | `Language.Hiligaynon`
Hindi | `Language.Hindi`
Hmong | `Language.Hmong`
Hungarian | `Language.Hungarian`
Ilocano | `Language.Ilocano`
Indonesian | `Language.Indonesian`
Italian | `Language.Italian`
Japanese | `Language.Japanese`
Javanese | `Language.Javanese`
Kabardian | `Language.Kabardian`
Kanauji | `Language.Kanauji`
Kanuri | `Language.Kanuri`
Kapampangan | `Language.Kapampangan`
Kazah | `Language.Kazah`
Kiche | `Language.Kiche`
Kikongo | `Language.Kikongo`
Konkani | `Language.Konkani`
Korean | `Language.Korean`
Kumauni | `Language.Kumauni`
Kurdish | `Language.Kurdish`
Lamani | `Language.Lamani`
Latin | `Language.Latin`
Latvian | `Language.Latvian`
Lithuanian | `Language.Lithuanian`
Low German | `Language.Low_German`
Luguru | `Language.Luguru`
Luo | `Language.Luo`
Macedonian | `Language.Macedonian`
Magahi | `Language.Magahi`
Maithili | `Language.Maithili`
Makassar | `Language.Makassar`
Makua | `Language.Makua`
Malagasy | `Language.Malagasy`
Malay | `Language.Malay`
Malvi | `Language.Malvi`
Marathi | `Language.Marathi`
Marwari | `Language.Marwari`
Meru | `Language.Meru`
Mewari | `Language.Mewari`
Mewati | `Language.Mewati`
Min Bei | `Language.Min_Bei`
Min Dong | `Language.Min_Dong`
Min Nan | `Language.Min_Nan`
Minangkabau | `Language.Minangkabau`
Muong | `Language.Muong`
Musi | `Language.Musi`
Nandi | `Language.Nandi`
Ndebele | `Language.Ndebele`
Nepali | `Language.Nepali`
Netherlands | `Language.Netherlands`
Norwegian | `Language.Norwegian`
Occitan | `Language.Occitan`
Oromo | `Language.Oromo`
Palembang | `Language.Palembang`
Pangasinan | `Language.Pangasinan`
Persian | `Language.Persian`
Polish | `Language.Polish`
Portuguese | `Language.Portuguese`
Pu-Xian | `Language.Pu_Xian`
Quechua | `Language.Quechua`
Rajbanshi | `Language.Rajbanshi`
Romanian | `Language.Romanian`
Russian | `Language.Russian`
Rwanda | `Language.Rwanda`
Sasak | `Language.Sasak`
Serbian | `Language.Serbian`
Serbo-Croatian | `Language.Serbo_Croatian`
Serer-Sine | `Language.Serer_Sine`
Shona | `Language.Shona`
Slovak | `Language.Slovak`
Slovene | `Language.Slovene`
Somali | `Language.Somali`
Sotho (Northern) | `Language.Sotho_Northern`
Sotho (Southern) | `Language.Sotho_Southern`
Spanish | `Language.Spanish`
Sukuma | `Language.Sukuma`
Sundanese | `Language.Sundanese`
Swahili | `Language.Swahili`
Swati | `Language.Swati`
Swedish | `Language.Swedish`
Tagalog | `Language.Tagalog`
Thai | `Language.Thai`
Tibetan | `Language.Tibetan`
Tonga | `Language.Tonga`
Tsonga | `Language.Tsonga`
Tswana | `Language.Tswana`
Tumbuka | `Language.Tumbuka`
Turkish | `Language.Turkish`
Turkmen | `Language.Turkmen`
Ukrainan | `Language.Ukrainan`
Umbundu | `Language.Umbundu`
Urdu | `Language.Urdu`
Uzbek | `Language.Uzbek`
Vietnamese | `Language.Vietnamese`
Wagdi | `Language.Wagdi`
Waray-Waray | `Language.Waray_Waray`
Wolaytta | `Language.Wolaytta`
Wu | `Language.Wu`
Xhosa | `Language.Xhosa`
Xiang | `Language.Xiang`
Yao | `Language.Yao`
Yoruba | `Language.Yoruba`
Zhuang | `Language.Zhuang`
Zulu | `Language.Zulu`

#### Removed public APIs:

_No changes._

## Quickstart

Make your solution using [SDK](#asposeocr-cloud-sdks), follow these steps:

#### 1. Get API keys if you haven't

Make a personal account on [Aspose Cloud Dashboard](https://dashboard.aspose.cloud/#/) and click _Get Keys_. These keys are useful for all Aspose Cloud products. If you have any trouble, look at this [detailed manual](https://docs.aspose.cloud/total/create-new-app-and-get-app-key-and-sid/).

#### 2. Run Demo

  * Checkout the SDK or get from [pip](https://pypi.org/project/aspose-ocr-cloud/) (pip install aspose-ocr-cloud)
  * Set Your AppSid & AppKey
  * Run Python console [Demo](./Example/run.py)


<p align="center">
  <a title="Download ZIP" href="https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-python/archive/master.zip">
     <img src="testdata/download.png" />
  </a>
</p>

---------------------------


## OCR in Python

```python
# Get your ClientId and ClientSecret from https://dashboard.aspose.cloud (free registration required).

	
    with aspose_ocr_cloud.ApiClient(config) as api_client:
        # Create an instance of the API class
        api_instance = recognize_image_api.RecognizeImageApi(api_client)

        # Read image file and conver it into base64 string
        image_file_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), '../samples/latin.png')

        # Create request body
        body = OCRRecognizeImageBody(
            image=utils.file_to_base64(image_file_path),
            settings=OCRSettingsRecognizeImage(
                language=Language("English"),
                makeSkewCorrect=False,
                makeBinarization=False,
                makeSpellCheck=False,
                makeContrastCorrection=False,
                makeUpsampling=False,
                dsrMode=DsrMode("NoDsrNoFilter"),
                dsrConfidence=DsrConfidence("Default"),
                resultType=ResultType("Text")
            ),
        )
        try:
            # Step 1: perform post request
            task_id = api_instance.post_recognize_image(
                body,
            )
            print(f'Your task ID is {task_id}')

            # Step 2: perform get result request
            task_response : OCRResponse = api_instance.get_recognize_image(
                id=task_id
            )
            assert task_response.response_status_code == 'Ok'
            assert task_response.task_status == 'Completed'
            recognized_text_raw = task_response.results[0].data
            recognized_text = bytearray(base64.b64decode(str(recognized_text_raw))).decode('utf-8')
            print (f'Recognized text:\n{recognized_text}')
            print (f'Task completed.Press Enter to continue')
            input()

        except aspose_ocr_cloud.ApiException as e:
            print("Exception when calling RecognizeImageApi: %s\n" % e)

```
_________________________

### Structure

This project includes:   
- Python console demo application - "[./example](./example/run.py)"
- Module "asposeocrcloud" - this is SDK located in "[./asposeocrcloud](asposeocrcloud)". You can integrate it in your application.
- Module "test" - "[./test](./test)" UnitTest. You can take a look at them to see various code examples.
- Folder "docs" - "[./docs](./docs)" Full documentation for Aspose.OCR SDK in HTML format.

### Dependencies
- Python 3.9
- [See requirements.txt](./requirements.txt)
_________________________


## Aspose.OCR Cloud SDKs

||||||
|--------------|----------|-------|---------|---------|
|[.NET & Core](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-dotnet)|[Java](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-java)|[Python](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-python)|[Node.js](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-nodejs)|[Android](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-android)


[Product Page](https://products.aspose.cloud/ocr/) | [Documentation](https://docs.aspose.cloud/display/ocrcloud/Home) | [API Reference](https://apireference.aspose.cloud/ocr/) | [Code Samples](https://github.com/aspose-ocr-cloud/aspose-ocr-cloud-nodejs) | [Blog](https://blog.aspose.cloud/category/ocr/) | [Free Support](https://forum.aspose.cloud/c/ocr) | [Free Trial](https://dashboard.aspose.cloud/#/apps)

    """,  # noqa: E501
    package_data={"aspose_ocr_cloud": ["py.typed"]},
)
