# coding: utf-8

"""
    Aspose OCR Cloud 5.0 API

    Aspose OCR Cloud 5.0 API

    The version of the OpenAPI document: 5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aspose_ocr_cloud.models.ocr_error import OCRError
from aspose_ocr_cloud.models.ocr_result import OCRResult
from aspose_ocr_cloud.models.ocr_task_status import OCRTaskStatus
from aspose_ocr_cloud.models.response_status_code import ResponseStatusCode
from typing import Optional, Set
from typing_extensions import Self

class OCRResponse(BaseModel):
    """
    Response with Recognition result for specific task ID
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The specific Task ID that result was made for")
    response_status_code: Optional[ResponseStatusCode] = Field(default=None, alias="responseStatusCode")
    task_status: Optional[OCRTaskStatus] = Field(default=None, alias="taskStatus")
    results: Optional[List[OCRResult]] = Field(default=None, description="List of results - Especially Text or PDF files")
    error: Optional[OCRError] = None
    __properties: ClassVar[List[str]] = ["id", "responseStatusCode", "taskStatus", "results", "error"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OCRResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "results",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item in self.results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['results'] = _items
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if results (nullable) is None
        # and model_fields_set contains the field
        if self.results is None and "results" in self.model_fields_set:
            _dict['results'] = None

        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OCRResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "responseStatusCode": obj.get("responseStatusCode"),
            "taskStatus": obj.get("taskStatus"),
            "results": [OCRResult.from_dict(_item) for _item in obj["results"]] if obj.get("results") is not None else None,
            "error": OCRError.from_dict(obj["error"]) if obj.get("error") is not None else None
        })
        return _obj


