/**
 * vis-network
 * https://visjs.github.io/vis-network/
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 7.6.3
 * @date    2020-05-06T08:28:31.366Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */

(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = global || self, factory(global.vis = global.vis || {}));
}(this, (function (exports) { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	function getCjsExportFromNamespace (n) {
		return n && n['default'] || n;
	}

	function commonjsRequire () {
		throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
	}

	var check = function (it) {
	  return it && it.Math == Math && it;
	}; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


	var global_1 = // eslint-disable-next-line no-undef
	check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func
	Function('return this')();

	var fails = function (exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};

	var descriptors = !fails(function () {
	  return Object.defineProperty({}, 1, {
	    get: function () {
	      return 7;
	    }
	  })[1] != 7;
	});

	var nativePropertyIsEnumerable = {}.propertyIsEnumerable;
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

	var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({
	  1: 2
	}, 1); // `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.github.io/ecma262/#sec-object.prototype.propertyisenumerable

	var f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : nativePropertyIsEnumerable;
	var objectPropertyIsEnumerable = {
	  f: f
	};

	var createPropertyDescriptor = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	var toString = {}.toString;

	var classofRaw = function (it) {
	  return toString.call(it).slice(8, -1);
	};

	var split = ''.split; // fallback for non-array-like ES3 and non-enumerable old V8 strings

	var indexedObject = fails(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins
	  return !Object('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classofRaw(it) == 'String' ? split.call(it, '') : Object(it);
	} : Object;

	// `RequireObjectCoercible` abstract operation
	// https://tc39.github.io/ecma262/#sec-requireobjectcoercible
	var requireObjectCoercible = function (it) {
	  if (it == undefined) throw TypeError("Can't call method on " + it);
	  return it;
	};

	var toIndexedObject = function (it) {
	  return indexedObject(requireObjectCoercible(it));
	};

	var isObject = function (it) {
	  return typeof it === 'object' ? it !== null : typeof it === 'function';
	};

	// https://tc39.github.io/ecma262/#sec-toprimitive
	// instead of the ES6 spec version, we didn't implement @@toPrimitive case
	// and the second argument - flag - preferred type is a string

	var toPrimitive = function (input, PREFERRED_STRING) {
	  if (!isObject(input)) return input;
	  var fn, val;
	  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
	  if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
	  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
	  throw TypeError("Can't convert object to primitive value");
	};

	var hasOwnProperty = {}.hasOwnProperty;

	var has = function (it, key) {
	  return hasOwnProperty.call(it, key);
	};

	var document$1 = global_1.document; // typeof document.createElement is 'object' in old IE

	var EXISTS = isObject(document$1) && isObject(document$1.createElement);

	var documentCreateElement = function (it) {
	  return EXISTS ? document$1.createElement(it) : {};
	};

	var ie8DomDefine = !descriptors && !fails(function () {
	  return Object.defineProperty(documentCreateElement('div'), 'a', {
	    get: function () {
	      return 7;
	    }
	  }).a != 7;
	});

	var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor

	var f$1 = descriptors ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject(O);
	  P = toPrimitive(P, true);
	  if (ie8DomDefine) try {
	    return nativeGetOwnPropertyDescriptor(O, P);
	  } catch (error) {
	    /* empty */
	  }
	  if (has(O, P)) return createPropertyDescriptor(!objectPropertyIsEnumerable.f.call(O, P), O[P]);
	};
	var objectGetOwnPropertyDescriptor = {
	  f: f$1
	};

	var replacement = /#|\.prototype\./;

	var isForced = function (feature, detection) {
	  var value = data[normalize(feature)];
	  return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
	};

	var normalize = isForced.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};

	var data = isForced.data = {};
	var NATIVE = isForced.NATIVE = 'N';
	var POLYFILL = isForced.POLYFILL = 'P';
	var isForced_1 = isForced;

	var path = {};

	var aFunction = function (it) {
	  if (typeof it != 'function') {
	    throw TypeError(String(it) + ' is not a function');
	  }

	  return it;
	};

	var functionBindContext = function (fn, that, length) {
	  aFunction(fn);
	  if (that === undefined) return fn;

	  switch (length) {
	    case 0:
	      return function () {
	        return fn.call(that);
	      };

	    case 1:
	      return function (a) {
	        return fn.call(that, a);
	      };

	    case 2:
	      return function (a, b) {
	        return fn.call(that, a, b);
	      };

	    case 3:
	      return function (a, b, c) {
	        return fn.call(that, a, b, c);
	      };
	  }

	  return function ()
	  /* ...args */
	  {
	    return fn.apply(that, arguments);
	  };
	};

	var anObject = function (it) {
	  if (!isObject(it)) {
	    throw TypeError(String(it) + ' is not an object');
	  }

	  return it;
	};

	var nativeDefineProperty = Object.defineProperty; // `Object.defineProperty` method
	// https://tc39.github.io/ecma262/#sec-object.defineproperty

	var f$2 = descriptors ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
	  anObject(O);
	  P = toPrimitive(P, true);
	  anObject(Attributes);
	  if (ie8DomDefine) try {
	    return nativeDefineProperty(O, P, Attributes);
	  } catch (error) {
	    /* empty */
	  }
	  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};
	var objectDefineProperty = {
	  f: f$2
	};

	var createNonEnumerableProperty = descriptors ? function (object, key, value) {
	  return objectDefineProperty.f(object, key, createPropertyDescriptor(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;

	var wrapConstructor = function (NativeConstructor) {
	  var Wrapper = function (a, b, c) {
	    if (this instanceof NativeConstructor) {
	      switch (arguments.length) {
	        case 0:
	          return new NativeConstructor();

	        case 1:
	          return new NativeConstructor(a);

	        case 2:
	          return new NativeConstructor(a, b);
	      }

	      return new NativeConstructor(a, b, c);
	    }

	    return NativeConstructor.apply(this, arguments);
	  };

	  Wrapper.prototype = NativeConstructor.prototype;
	  return Wrapper;
	};
	/*
	  options.target      - name of the target object
	  options.global      - target is the global object
	  options.stat        - export as static methods of target
	  options.proto       - export as prototype methods of target
	  options.real        - real prototype method for the `pure` version
	  options.forced      - export even if the native feature is available
	  options.bind        - bind methods to the target, required for the `pure` version
	  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
	  options.sham        - add a flag to not completely full polyfills
	  options.enumerable  - export as enumerable property
	  options.noTargetGet - prevent calling a getter on target
	*/


	var _export = function (options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var PROTO = options.proto;
	  var nativeSource = GLOBAL ? global_1 : STATIC ? global_1[TARGET] : (global_1[TARGET] || {}).prototype;
	  var target = GLOBAL ? path : path[TARGET] || (path[TARGET] = {});
	  var targetPrototype = target.prototype;
	  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
	  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

	  for (key in source) {
	    FORCED = isForced_1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contains in native

	    USE_NATIVE = !FORCED && nativeSource && has(nativeSource, key);
	    targetProperty = target[key];
	    if (USE_NATIVE) if (options.noTargetGet) {
	      descriptor = getOwnPropertyDescriptor$1(nativeSource, key);
	      nativeProperty = descriptor && descriptor.value;
	    } else nativeProperty = nativeSource[key]; // export native or implementation

	    sourceProperty = USE_NATIVE && nativeProperty ? nativeProperty : source[key];
	    if (USE_NATIVE && typeof targetProperty === typeof sourceProperty) continue; // bind timers to global for call from export context

	    if (options.bind && USE_NATIVE) resultProperty = functionBindContext(sourceProperty, global_1); // wrap global constructors for prevent changs in this version
	    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty); // make static versions for prototype methods
	      else if (PROTO && typeof sourceProperty == 'function') resultProperty = functionBindContext(Function.call, sourceProperty); // default case
	        else resultProperty = sourceProperty; // add a flag to not completely full polyfills

	    if (options.sham || sourceProperty && sourceProperty.sham || targetProperty && targetProperty.sham) {
	      createNonEnumerableProperty(resultProperty, 'sham', true);
	    }

	    target[key] = resultProperty;

	    if (PROTO) {
	      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';

	      if (!has(path, VIRTUAL_PROTOTYPE)) {
	        createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
	      } // export virtual prototype methods


	      path[VIRTUAL_PROTOTYPE][key] = sourceProperty; // export real prototype methods

	      if (options.real && targetPrototype && !targetPrototype[key]) {
	        createNonEnumerableProperty(targetPrototype, key, sourceProperty);
	      }
	    }
	  }
	};

	var slice = [].slice;
	var factories = {};

	var construct = function (C, argsLength, args) {
	  if (!(argsLength in factories)) {
	    for (var list = [], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']'; // eslint-disable-next-line no-new-func


	    factories[argsLength] = Function('C,a', 'return new C(' + list.join(',') + ')');
	  }

	  return factories[argsLength](C, args);
	}; // `Function.prototype.bind` method implementation
	// https://tc39.github.io/ecma262/#sec-function.prototype.bind


	var functionBind = Function.bind || function bind(that
	/* , ...args */
	) {
	  var fn = aFunction(this);
	  var partArgs = slice.call(arguments, 1);

	  var boundFunction = function bound()
	  /* args... */
	  {
	    var args = partArgs.concat(slice.call(arguments));
	    return this instanceof boundFunction ? construct(fn, args.length, args) : fn.apply(that, args);
	  };

	  if (isObject(fn.prototype)) boundFunction.prototype = fn.prototype;
	  return boundFunction;
	};

	// https://tc39.github.io/ecma262/#sec-function.prototype.bind

	_export({
	  target: 'Function',
	  proto: true
	}, {
	  bind: functionBind
	});

	var entryVirtual = function (CONSTRUCTOR) {
	  return path[CONSTRUCTOR + 'Prototype'];
	};

	var bind = entryVirtual('Function').bind;

	var FunctionPrototype = Function.prototype;

	var bind_1 = function (it) {
	  var own = it.bind;
	  return it === FunctionPrototype || it instanceof Function && own === FunctionPrototype.bind ? bind : own;
	};

	var bind$1 = bind_1;

	var bind$2 = bind$1;

	/**
	 * Draw a circle.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - The radius of the circle.
	 */
	function drawCircle(ctx, x, y, r) {
	  ctx.beginPath();
	  ctx.arc(x, y, r, 0, 2 * Math.PI, false);
	  ctx.closePath();
	}
	/**
	 * Draw a square.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the width and height of the square.
	 */

	function drawSquare(ctx, x, y, r) {
	  ctx.beginPath();
	  ctx.rect(x - r, y - r, r * 2, r * 2);
	  ctx.closePath();
	}
	/**
	 * Draw an equilateral triangle standing on a side.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the length of the sides.
	 *
	 * @remarks
	 * http://en.wikipedia.org/wiki/Equilateral_triangle
	 */

	function drawTriangle(ctx, x, y, r) {
	  ctx.beginPath(); // the change in radius and the offset is here to center the shape

	  r *= 1.15;
	  y += 0.275 * r;
	  var s = r * 2;
	  var s2 = s / 2;
	  var ir = Math.sqrt(3) / 6 * s; // radius of inner circle

	  var h = Math.sqrt(s * s - s2 * s2); // height

	  ctx.moveTo(x, y - (h - ir));
	  ctx.lineTo(x + s2, y + ir);
	  ctx.lineTo(x - s2, y + ir);
	  ctx.lineTo(x, y - (h - ir));
	  ctx.closePath();
	}
	/**
	 * Draw an equilateral triangle standing on a vertex.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the length of the sides.
	 *
	 * @remarks
	 * http://en.wikipedia.org/wiki/Equilateral_triangle
	 */

	function drawTriangleDown(ctx, x, y, r) {
	  ctx.beginPath(); // the change in radius and the offset is here to center the shape

	  r *= 1.15;
	  y -= 0.275 * r;
	  var s = r * 2;
	  var s2 = s / 2;
	  var ir = Math.sqrt(3) / 6 * s; // radius of inner circle

	  var h = Math.sqrt(s * s - s2 * s2); // height

	  ctx.moveTo(x, y + (h - ir));
	  ctx.lineTo(x + s2, y - ir);
	  ctx.lineTo(x - s2, y - ir);
	  ctx.lineTo(x, y + (h - ir));
	  ctx.closePath();
	}
	/**
	 * Draw a star.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - The outer radius of the star.
	 */

	function drawStar(ctx, x, y, r) {
	  // http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
	  ctx.beginPath(); // the change in radius and the offset is here to center the shape

	  r *= 0.82;
	  y += 0.1 * r;

	  for (var n = 0; n < 10; n++) {
	    var radius = n % 2 === 0 ? r * 1.3 : r * 0.5;
	    ctx.lineTo(x + radius * Math.sin(n * 2 * Math.PI / 10), y - radius * Math.cos(n * 2 * Math.PI / 10));
	  }

	  ctx.closePath();
	}
	/**
	 * Draw a diamond.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - Half of the width and height of the diamond.
	 *
	 * @remarks
	 * http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
	 */

	function drawDiamond(ctx, x, y, r) {
	  ctx.beginPath();
	  ctx.lineTo(x, y + r);
	  ctx.lineTo(x + r, y);
	  ctx.lineTo(x, y - r);
	  ctx.lineTo(x - r, y);
	  ctx.closePath();
	}
	/**
	 * Draw a rectangle with rounded corners.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param w - The width of the rectangle.
	 * @param h - The height of the rectangle.
	 * @param r - The radius of the corners.
	 *
	 * @remarks
	 * http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
	 */

	function drawRoundRect(ctx, x, y, w, h, r) {
	  var r2d = Math.PI / 180;

	  if (w - 2 * r < 0) {
	    r = w / 2;
	  } //ensure that the radius isn't too large for x


	  if (h - 2 * r < 0) {
	    r = h / 2;
	  } //ensure that the radius isn't too large for y


	  ctx.beginPath();
	  ctx.moveTo(x + r, y);
	  ctx.lineTo(x + w - r, y);
	  ctx.arc(x + w - r, y + r, r, r2d * 270, r2d * 360, false);
	  ctx.lineTo(x + w, y + h - r);
	  ctx.arc(x + w - r, y + h - r, r, 0, r2d * 90, false);
	  ctx.lineTo(x + r, y + h);
	  ctx.arc(x + r, y + h - r, r, r2d * 90, r2d * 180, false);
	  ctx.lineTo(x, y + r);
	  ctx.arc(x + r, y + r, r, r2d * 180, r2d * 270, false);
	  ctx.closePath();
	}
	/**
	 * Draw an ellipse.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param w - The width of the ellipse.
	 * @param h - The height of the ellipse.
	 *
	 * @remarks
	 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
	 *
	 * Postfix '_vis' added to discern it from standard method ellipse().
	 */

	function drawEllipse(ctx, x, y, w, h) {
	  var kappa = 0.5522848,
	      ox = w / 2 * kappa,
	      // control point offset horizontal
	  oy = h / 2 * kappa,
	      // control point offset vertical
	  xe = x + w,
	      // x-end
	  ye = y + h,
	      // y-end
	  xm = x + w / 2,
	      // x-middle
	  ym = y + h / 2; // y-middle

	  ctx.beginPath();
	  ctx.moveTo(x, ym);
	  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
	  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
	  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
	  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
	  ctx.closePath();
	}
	/**
	 * Draw an isometric cylinder.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param w - The width of the database.
	 * @param h - The height of the database.
	 *
	 * @remarks
	 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
	 */

	function drawDatabase(ctx, x, y, w, h) {
	  var f = 1 / 3;
	  var wEllipse = w;
	  var hEllipse = h * f;
	  var kappa = 0.5522848,
	      ox = wEllipse / 2 * kappa,
	      // control point offset horizontal
	  oy = hEllipse / 2 * kappa,
	      // control point offset vertical
	  xe = x + wEllipse,
	      // x-end
	  ye = y + hEllipse,
	      // y-end
	  xm = x + wEllipse / 2,
	      // x-middle
	  ym = y + hEllipse / 2,
	      // y-middle
	  ymb = y + (h - hEllipse / 2),
	      // y-midlle, bottom ellipse
	  yeb = y + h; // y-end, bottom ellipse

	  ctx.beginPath();
	  ctx.moveTo(xe, ym);
	  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
	  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
	  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
	  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
	  ctx.lineTo(xe, ymb);
	  ctx.bezierCurveTo(xe, ymb + oy, xm + ox, yeb, xm, yeb);
	  ctx.bezierCurveTo(xm - ox, yeb, x, ymb + oy, x, ymb);
	  ctx.lineTo(x, ym);
	}
	/**
	 * Draw a dashed line.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The start position on the x axis.
	 * @param y - The start position on the y axis.
	 * @param x2 - The end position on the x axis.
	 * @param y2 - The end position on the y axis.
	 * @param pattern - List of lengths starting with line and then alternating between space and line.
	 *
	 * @author David Jordan
	 * @date 2012-08-08
	 * @remarks
	 * http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas
	 */

	function drawDashedLine(ctx, x, y, x2, y2, pattern) {
	  ctx.beginPath();
	  ctx.moveTo(x, y);
	  var patternLength = pattern.length;
	  var dx = x2 - x;
	  var dy = y2 - y;
	  var slope = dy / dx;
	  var distRemaining = Math.sqrt(dx * dx + dy * dy);
	  var patternIndex = 0;
	  var draw = true;
	  var xStep = 0;
	  var dashLength = +pattern[0];

	  while (distRemaining >= 0.1) {
	    dashLength = +pattern[patternIndex++ % patternLength];

	    if (dashLength > distRemaining) {
	      dashLength = distRemaining;
	    }

	    xStep = Math.sqrt(dashLength * dashLength / (1 + slope * slope));
	    xStep = dx < 0 ? -xStep : xStep;
	    x += xStep;
	    y += slope * xStep;

	    if (draw === true) {
	      ctx.lineTo(x, y);
	    } else {
	      ctx.moveTo(x, y);
	    }

	    distRemaining -= dashLength;
	    draw = !draw;
	  }
	}
	/**
	 * Draw a hexagon.
	 *
	 * @param ctx - The context this shape will be rendered to.
	 * @param x - The position of the center on the x axis.
	 * @param y - The position of the center on the y axis.
	 * @param r - The radius of the hexagon.
	 */

	function drawHexagon(ctx, x, y, r) {
	  ctx.beginPath();
	  var sides = 6;
	  var a = Math.PI * 2 / sides;
	  ctx.moveTo(x + r, y);

	  for (var i = 1; i < sides; i++) {
	    ctx.lineTo(x + r * Math.cos(a * i), y + r * Math.sin(a * i));
	  }

	  ctx.closePath();
	}
	var shapeMap = {
	  circle: drawCircle,
	  dashedLine: drawDashedLine,
	  database: drawDatabase,
	  diamond: drawDiamond,
	  ellipse: drawEllipse,
	  ellipse_vis: drawEllipse,
	  hexagon: drawHexagon,
	  roundRect: drawRoundRect,
	  square: drawSquare,
	  star: drawStar,
	  triangle: drawTriangle,
	  triangleDown: drawTriangleDown
	};
	/**
	 * Returns either custom or native drawing function base on supplied name.
	 *
	 * @param name - The name of the function. Either the name of a
	 * CanvasRenderingContext2D property or an export from shapes.ts without the
	 * draw prefix.
	 *
	 * @returns The function that can be used for rendering. In case of native
	 * CanvasRenderingContext2D function the API is normalized to
	 * `(ctx: CanvasRenderingContext2D, ...originalArgs) => void`.
	 */

	function getShape(name) {
	  if (Object.prototype.hasOwnProperty.call(shapeMap, name)) {
	    return shapeMap[name];
	  } else {
	    return function (ctx) {
	      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	        args[_key - 1] = arguments[_key];
	      }

	      CanvasRenderingContext2D.prototype[name].call(ctx, args);
	    };
	  }
	}

	var componentEmitter = createCommonjsModule(function (module) {
	  /**
	   * Expose `Emitter`.
	   */
	  {
	    module.exports = Emitter;
	  }
	  /**
	   * Initialize a new `Emitter`.
	   *
	   * @api public
	   */


	  function Emitter(obj) {
	    if (obj) return mixin(obj);
	  }
	  /**
	   * Mixin the emitter properties.
	   *
	   * @param {Object} obj
	   * @return {Object}
	   * @api private
	   */

	  function mixin(obj) {
	    for (var key in Emitter.prototype) {
	      obj[key] = Emitter.prototype[key];
	    }

	    return obj;
	  }
	  /**
	   * Listen on the given `event` with `fn`.
	   *
	   * @param {String} event
	   * @param {Function} fn
	   * @return {Emitter}
	   * @api public
	   */


	  Emitter.prototype.on = Emitter.prototype.addEventListener = function (event, fn) {
	    this._callbacks = this._callbacks || {};
	    (this._callbacks['$' + event] = this._callbacks['$' + event] || []).push(fn);
	    return this;
	  };
	  /**
	   * Adds an `event` listener that will be invoked a single
	   * time then automatically removed.
	   *
	   * @param {String} event
	   * @param {Function} fn
	   * @return {Emitter}
	   * @api public
	   */


	  Emitter.prototype.once = function (event, fn) {
	    function on() {
	      this.off(event, on);
	      fn.apply(this, arguments);
	    }

	    on.fn = fn;
	    this.on(event, on);
	    return this;
	  };
	  /**
	   * Remove the given callback for `event` or all
	   * registered callbacks.
	   *
	   * @param {String} event
	   * @param {Function} fn
	   * @return {Emitter}
	   * @api public
	   */


	  Emitter.prototype.off = Emitter.prototype.removeListener = Emitter.prototype.removeAllListeners = Emitter.prototype.removeEventListener = function (event, fn) {
	    this._callbacks = this._callbacks || {}; // all

	    if (0 == arguments.length) {
	      this._callbacks = {};
	      return this;
	    } // specific event


	    var callbacks = this._callbacks['$' + event];
	    if (!callbacks) return this; // remove all handlers

	    if (1 == arguments.length) {
	      delete this._callbacks['$' + event];
	      return this;
	    } // remove specific handler


	    var cb;

	    for (var i = 0; i < callbacks.length; i++) {
	      cb = callbacks[i];

	      if (cb === fn || cb.fn === fn) {
	        callbacks.splice(i, 1);
	        break;
	      }
	    } // Remove event specific arrays for event types that no
	    // one is subscribed for to avoid memory leak.


	    if (callbacks.length === 0) {
	      delete this._callbacks['$' + event];
	    }

	    return this;
	  };
	  /**
	   * Emit `event` with the given args.
	   *
	   * @param {String} event
	   * @param {Mixed} ...
	   * @return {Emitter}
	   */


	  Emitter.prototype.emit = function (event) {
	    this._callbacks = this._callbacks || {};
	    var args = new Array(arguments.length - 1),
	        callbacks = this._callbacks['$' + event];

	    for (var i = 1; i < arguments.length; i++) {
	      args[i - 1] = arguments[i];
	    }

	    if (callbacks) {
	      callbacks = callbacks.slice(0);

	      for (var i = 0, len = callbacks.length; i < len; ++i) {
	        callbacks[i].apply(this, args);
	      }
	    }

	    return this;
	  };
	  /**
	   * Return array of callbacks for `event`.
	   *
	   * @param {String} event
	   * @return {Array}
	   * @api public
	   */


	  Emitter.prototype.listeners = function (event) {
	    this._callbacks = this._callbacks || {};
	    return this._callbacks['$' + event] || [];
	  };
	  /**
	   * Check if this emitter has `event` handlers.
	   *
	   * @param {String} event
	   * @return {Boolean}
	   * @api public
	   */


	  Emitter.prototype.hasListeners = function (event) {
	    return !!this.listeners(event).length;
	  };
	});

	var iterators = {};

	var setGlobal = function (key, value) {
	  try {
	    createNonEnumerableProperty(global_1, key, value);
	  } catch (error) {
	    global_1[key] = value;
	  }

	  return value;
	};

	var SHARED = '__core-js_shared__';
	var store = global_1[SHARED] || setGlobal(SHARED, {});
	var sharedStore = store;

	var functionToString = Function.toString; // this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper

	if (typeof sharedStore.inspectSource != 'function') {
	  sharedStore.inspectSource = function (it) {
	    return functionToString.call(it);
	  };
	}

	var inspectSource = sharedStore.inspectSource;

	var WeakMap = global_1.WeakMap;
	var nativeWeakMap = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));

	var shared = createCommonjsModule(function (module) {
	  (module.exports = function (key, value) {
	    return sharedStore[key] || (sharedStore[key] = value !== undefined ? value : {});
	  })('versions', []).push({
	    version: '3.6.4',
	    mode:  'pure' ,
	    copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
	  });
	});

	var id = 0;
	var postfix = Math.random();

	var uid = function (key) {
	  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
	};

	var keys = shared('keys');

	var sharedKey = function (key) {
	  return keys[key] || (keys[key] = uid(key));
	};

	var hiddenKeys = {};

	var WeakMap$1 = global_1.WeakMap;
	var set, get, has$1;

	var enforce = function (it) {
	  return has$1(it) ? get(it) : set(it, {});
	};

	var getterFor = function (TYPE) {
	  return function (it) {
	    var state;

	    if (!isObject(it) || (state = get(it)).type !== TYPE) {
	      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
	    }

	    return state;
	  };
	};

	if (nativeWeakMap) {
	  var store$1 = new WeakMap$1();
	  var wmget = store$1.get;
	  var wmhas = store$1.has;
	  var wmset = store$1.set;

	  set = function (it, metadata) {
	    wmset.call(store$1, it, metadata);
	    return metadata;
	  };

	  get = function (it) {
	    return wmget.call(store$1, it) || {};
	  };

	  has$1 = function (it) {
	    return wmhas.call(store$1, it);
	  };
	} else {
	  var STATE = sharedKey('state');
	  hiddenKeys[STATE] = true;

	  set = function (it, metadata) {
	    createNonEnumerableProperty(it, STATE, metadata);
	    return metadata;
	  };

	  get = function (it) {
	    return has(it, STATE) ? it[STATE] : {};
	  };

	  has$1 = function (it) {
	    return has(it, STATE);
	  };
	}

	var internalState = {
	  set: set,
	  get: get,
	  has: has$1,
	  enforce: enforce,
	  getterFor: getterFor
	};

	// https://tc39.github.io/ecma262/#sec-toobject

	var toObject = function (argument) {
	  return Object(requireObjectCoercible(argument));
	};

	var correctPrototypeGetter = !fails(function () {
	  function F() {
	    /* empty */
	  }

	  F.prototype.constructor = null;
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});

	var IE_PROTO = sharedKey('IE_PROTO');
	var ObjectPrototype = Object.prototype; // `Object.getPrototypeOf` method
	// https://tc39.github.io/ecma262/#sec-object.getprototypeof

	var objectGetPrototypeOf = correctPrototypeGetter ? Object.getPrototypeOf : function (O) {
	  O = toObject(O);
	  if (has(O, IE_PROTO)) return O[IE_PROTO];

	  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
	    return O.constructor.prototype;
	  }

	  return O instanceof Object ? ObjectPrototype : null;
	};

	var nativeSymbol = !!Object.getOwnPropertySymbols && !fails(function () {
	  // Chrome 38 Symbol has incorrect toString conversion
	  // eslint-disable-next-line no-undef
	  return !String(Symbol());
	});

	var useSymbolAsUid = nativeSymbol // eslint-disable-next-line no-undef
	&& !Symbol.sham // eslint-disable-next-line no-undef
	&& typeof Symbol.iterator == 'symbol';

	var WellKnownSymbolsStore = shared('wks');
	var Symbol$1 = global_1.Symbol;
	var createWellKnownSymbol = useSymbolAsUid ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid;

	var wellKnownSymbol = function (name) {
	  if (!has(WellKnownSymbolsStore, name)) {
	    if (nativeSymbol && has(Symbol$1, name)) WellKnownSymbolsStore[name] = Symbol$1[name];else WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
	  }

	  return WellKnownSymbolsStore[name];
	};

	var ITERATOR = wellKnownSymbol('iterator');
	var BUGGY_SAFARI_ITERATORS = false;
	// https://tc39.github.io/ecma262/#sec-%iteratorprototype%-object


	var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

	if ([].keys) {
	  arrayIterator = [].keys(); // Safari 8 has buggy iterators w/o `next`

	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;else {
	    PrototypeOfArrayIteratorPrototype = objectGetPrototypeOf(objectGetPrototypeOf(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
	  }
	}

	if (IteratorPrototype == undefined) IteratorPrototype = {}; // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()

	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
	};

	var ceil = Math.ceil;
	var floor = Math.floor; // `ToInteger` abstract operation
	// https://tc39.github.io/ecma262/#sec-tointeger

	var toInteger = function (argument) {
	  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
	};

	var min = Math.min; // `ToLength` abstract operation
	// https://tc39.github.io/ecma262/#sec-tolength

	var toLength = function (argument) {
	  return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var max = Math.max;
	var min$1 = Math.min; // Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

	var toAbsoluteIndex = function (index, length) {
	  var integer = toInteger(index);
	  return integer < 0 ? max(integer + length, 0) : min$1(integer, length);
	};

	var createMethod = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject($this);
	    var length = toLength(O.length);
	    var index = toAbsoluteIndex(fromIndex, length);
	    var value; // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare

	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++]; // eslint-disable-next-line no-self-compare

	      if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
	    } else for (; length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    }
	    return !IS_INCLUDES && -1;
	  };
	};

	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.includes
	  includes: createMethod(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod(false)
	};

	var indexOf = arrayIncludes.indexOf;

	var objectKeysInternal = function (object, names) {
	  var O = toIndexedObject(object);
	  var i = 0;
	  var result = [];
	  var key;

	  for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key); // Don't enum bug & hidden keys


	  while (names.length > i) if (has(O, key = names[i++])) {
	    ~indexOf(result, key) || result.push(key);
	  }

	  return result;
	};

	// IE8- don't enum bug keys
	var enumBugKeys = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

	// https://tc39.github.io/ecma262/#sec-object.keys

	var objectKeys = Object.keys || function keys(O) {
	  return objectKeysInternal(O, enumBugKeys);
	};

	// https://tc39.github.io/ecma262/#sec-object.defineproperties

	var objectDefineProperties = descriptors ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject(O);
	  var keys = objectKeys(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;

	  while (length > index) objectDefineProperty.f(O, key = keys[index++], Properties[key]);

	  return O;
	};

	var aFunction$1 = function (variable) {
	  return typeof variable == 'function' ? variable : undefined;
	};

	var getBuiltIn = function (namespace, method) {
	  return arguments.length < 2 ? aFunction$1(path[namespace]) || aFunction$1(global_1[namespace]) : path[namespace] && path[namespace][method] || global_1[namespace] && global_1[namespace][method];
	};

	var html = getBuiltIn('document', 'documentElement');

	var GT = '>';
	var LT = '<';
	var PROTOTYPE = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO$1 = sharedKey('IE_PROTO');

	var EmptyConstructor = function () {
	  /* empty */
	};

	var scriptTag = function (content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	}; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


	var NullProtoObjectViaActiveX = function (activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak

	  return temp;
	}; // Create object with fake `null` prototype: use iframe Object with cleared prototype


	var NullProtoObjectViaIFrame = function () {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	}; // Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug


	var activeXDocument;

	var NullProtoObject = function () {
	  try {
	    /* global ActiveXObject */
	    activeXDocument = document.domain && new ActiveXObject('htmlfile');
	  } catch (error) {
	    /* ignore */
	  }

	  NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
	  var length = enumBugKeys.length;

	  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];

	  return NullProtoObject();
	};

	hiddenKeys[IE_PROTO$1] = true; // `Object.create` method
	// https://tc39.github.io/ecma262/#sec-object.create

	var objectCreate = Object.create || function create(O, Properties) {
	  var result;

	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE] = anObject(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE] = null; // add "__proto__" for Object.getPrototypeOf polyfill

	    result[IE_PROTO$1] = O;
	  } else result = NullProtoObject();

	  return Properties === undefined ? result : objectDefineProperties(result, Properties);
	};

	var TO_STRING_TAG = wellKnownSymbol('toStringTag');
	var test = {};
	test[TO_STRING_TAG] = 'z';
	var toStringTagSupport = String(test) === '[object z]';

	var TO_STRING_TAG$1 = wellKnownSymbol('toStringTag'); // ES3 wrong here

	var CORRECT_ARGUMENTS = classofRaw(function () {
	  return arguments;
	}()) == 'Arguments'; // fallback for IE11 Script Access Denied error

	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (error) {
	    /* empty */
	  }
	}; // getting tag from ES6+ `Object.prototype.toString`


	var classof = toStringTagSupport ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
	  : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG$1)) == 'string' ? tag // builtinTag case
	  : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
	  : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
	};

	// https://tc39.github.io/ecma262/#sec-object.prototype.tostring


	var objectToString = toStringTagSupport ? {}.toString : function toString() {
	  return '[object ' + classof(this) + ']';
	};

	var defineProperty = objectDefineProperty.f;
	var TO_STRING_TAG$2 = wellKnownSymbol('toStringTag');

	var setToStringTag = function (it, TAG, STATIC, SET_METHOD) {
	  if (it) {
	    var target = STATIC ? it : it.prototype;

	    if (!has(target, TO_STRING_TAG$2)) {
	      defineProperty(target, TO_STRING_TAG$2, {
	        configurable: true,
	        value: TAG
	      });
	    }

	    if (SET_METHOD && !toStringTagSupport) {
	      createNonEnumerableProperty(target, 'toString', objectToString);
	    }
	  }
	};

	var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;

	var returnThis = function () {
	  return this;
	};

	var createIteratorConstructor = function (IteratorConstructor, NAME, next) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = objectCreate(IteratorPrototype$1, {
	    next: createPropertyDescriptor(1, next)
	  });
	  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
	  iterators[TO_STRING_TAG] = returnThis;
	  return IteratorConstructor;
	};

	var aPossiblePrototype = function (it) {
	  if (!isObject(it) && it !== null) {
	    throw TypeError("Can't set " + String(it) + ' as a prototype');
	  }

	  return it;
	};

	// https://tc39.github.io/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.

	/* eslint-disable no-proto */

	var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;

	  try {
	    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
	    setter.call(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) {
	    /* empty */
	  }

	  return function setPrototypeOf(O, proto) {
	    anObject(O);
	    aPossiblePrototype(proto);
	    if (CORRECT_SETTER) setter.call(O, proto);else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);

	var redefine = function (target, key, value, options) {
	  if (options && options.enumerable) target[key] = value;else createNonEnumerableProperty(target, key, value);
	};

	var IteratorPrototype$2 = iteratorsCore.IteratorPrototype;
	var BUGGY_SAFARI_ITERATORS$1 = iteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$1 = wellKnownSymbol('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';

	var returnThis$1 = function () {
	  return this;
	};

	var defineIterator = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);

	  var getIterationMethod = function (KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS$1 && KIND in IterablePrototype) return IterablePrototype[KIND];

	    switch (KIND) {
	      case KEYS:
	        return function keys() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case VALUES:
	        return function values() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case ENTRIES:
	        return function entries() {
	          return new IteratorConstructor(this, KIND);
	        };
	    }

	    return function () {
	      return new IteratorConstructor(this);
	    };
	  };

	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$1] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS$1 && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY; // fix native

	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = objectGetPrototypeOf(anyNativeIterator.call(new Iterable()));

	    if (IteratorPrototype$2 !== Object.prototype && CurrentIteratorPrototype.next) {


	      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      iterators[TO_STRING_TAG] = returnThis$1;
	    }
	  } // fix Array#{values, @@iterator}.name in V8 / FF


	  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    INCORRECT_VALUES_NAME = true;

	    defaultIterator = function values() {
	      return nativeIterator.call(this);
	    };
	  } // define iterator


	  if (( FORCED) && IterablePrototype[ITERATOR$1] !== defaultIterator) {
	    createNonEnumerableProperty(IterablePrototype, ITERATOR$1, defaultIterator);
	  }

	  iterators[NAME] = defaultIterator; // export additional methods

	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS$1 || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        redefine(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else _export({
	      target: NAME,
	      proto: true,
	      forced: BUGGY_SAFARI_ITERATORS$1 || INCORRECT_VALUES_NAME
	    }, methods);
	  }

	  return methods;
	};

	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState = internalState.set;
	var getInternalState = internalState.getterFor(ARRAY_ITERATOR); // `Array.prototype.entries` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.github.io/ecma262/#sec-createarrayiterator

	var es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
	  setInternalState(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject(iterated),
	    // target
	    index: 0,
	    // next index
	    kind: kind // kind

	  }); // `%ArrayIteratorPrototype%.next` method
	  // https://tc39.github.io/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;

	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return {
	      value: undefined,
	      done: true
	    };
	  }

	  if (kind == 'keys') return {
	    value: index,
	    done: false
	  };
	  if (kind == 'values') return {
	    value: target[index],
	    done: false
	  };
	  return {
	    value: [index, target[index]],
	    done: false
	  };
	}, 'values'); // argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.github.io/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.github.io/ecma262/#sec-createmappedargumentsobject

	iterators.Arguments = iterators.Array; // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	// iterable DOM collections
	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};

	var TO_STRING_TAG$3 = wellKnownSymbol('toStringTag');

	for (var COLLECTION_NAME in domIterables) {
	  var Collection = global_1[COLLECTION_NAME];
	  var CollectionPrototype = Collection && Collection.prototype;

	  if (CollectionPrototype && classof(CollectionPrototype) !== TO_STRING_TAG$3) {
	    createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG$3, COLLECTION_NAME);
	  }

	  iterators[COLLECTION_NAME] = iterators.Array;
	}

	var createMethod$1 = function (CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = String(requireObjectCoercible($this));
	    var position = toInteger(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = S.charCodeAt(position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};

	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod$1(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod$1(true)
	};

	var charAt = stringMultibyte.charAt;
	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$1 = internalState.set;
	var getInternalState$1 = internalState.getterFor(STRING_ITERATOR); // `String.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-string.prototype-@@iterator

	defineIterator(String, 'String', function (iterated) {
	  setInternalState$1(this, {
	    type: STRING_ITERATOR,
	    string: String(iterated),
	    index: 0
	  }); // `%StringIteratorPrototype%.next` method
	  // https://tc39.github.io/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState$1(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return {
	    value: undefined,
	    done: true
	  };
	  point = charAt(string, index);
	  state.index += point.length;
	  return {
	    value: point,
	    done: false
	  };
	});

	var ITERATOR$2 = wellKnownSymbol('iterator');

	var getIteratorMethod = function (it) {
	  if (it != undefined) return it[ITERATOR$2] || it['@@iterator'] || iterators[classof(it)];
	};

	var getIterator = function (it) {
	  var iteratorMethod = getIteratorMethod(it);

	  if (typeof iteratorMethod != 'function') {
	    throw TypeError(String(it) + ' is not iterable');
	  }

	  return anObject(iteratorMethod.call(it));
	};

	var getIterator_1 = getIterator;

	var getIterator$1 = getIterator_1;

	var getIteratorMethod_1 = getIteratorMethod;

	var getIteratorMethod$1 = getIteratorMethod_1;

	// https://tc39.github.io/ecma262/#sec-isarray

	var isArray = Array.isArray || function isArray(arg) {
	  return classofRaw(arg) == 'Array';
	};

	var createProperty = function (object, key, value) {
	  var propertyKey = toPrimitive(key);
	  if (propertyKey in object) objectDefineProperty.f(object, propertyKey, createPropertyDescriptor(0, value));else object[propertyKey] = value;
	};

	var SPECIES = wellKnownSymbol('species'); // `ArraySpeciesCreate` abstract operation
	// https://tc39.github.io/ecma262/#sec-arrayspeciescreate

	var arraySpeciesCreate = function (originalArray, length) {
	  var C;

	  if (isArray(originalArray)) {
	    C = originalArray.constructor; // cross-realm fallback

	    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;else if (isObject(C)) {
	      C = C[SPECIES];
	      if (C === null) C = undefined;
	    }
	  }

	  return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
	};

	var engineUserAgent = getBuiltIn('navigator', 'userAgent') || '';

	var process = global_1.process;
	var versions = process && process.versions;
	var v8 = versions && versions.v8;
	var match, version;

	if (v8) {
	  match = v8.split('.');
	  version = match[0] + match[1];
	} else if (engineUserAgent) {
	  match = engineUserAgent.match(/Edge\/(\d+)/);

	  if (!match || match[1] >= 74) {
	    match = engineUserAgent.match(/Chrome\/(\d+)/);
	    if (match) version = match[1];
	  }
	}

	var engineV8Version = version && +version;

	var SPECIES$1 = wellKnownSymbol('species');

	var arrayMethodHasSpeciesSupport = function (METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return engineV8Version >= 51 || !fails(function () {
	    var array = [];
	    var constructor = array.constructor = {};

	    constructor[SPECIES$1] = function () {
	      return {
	        foo: 1
	      };
	    };

	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};

	var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded'; // We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679

	var IS_CONCAT_SPREADABLE_SUPPORT = engineV8Version >= 51 || !fails(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});
	var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

	var isConcatSpreadable = function (O) {
	  if (!isObject(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray(O);
	};

	var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: FORCED
	}, {
	  concat: function concat(arg) {
	    // eslint-disable-line no-unused-vars
	    var O = toObject(this);
	    var A = arraySpeciesCreate(O, 0);
	    var n = 0;
	    var i, k, length, len, E;

	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];

	      if (isConcatSpreadable(E)) {
	        len = toLength(E.length);
	        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);

	        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
	      } else {
	        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
	        createProperty(A, n++, E);
	      }
	    }

	    A.length = n;
	    return A;
	  }
	});

	var hiddenKeys$1 = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertynames

	var f$3 = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return objectKeysInternal(O, hiddenKeys$1);
	};

	var objectGetOwnPropertyNames = {
	  f: f$3
	};

	var nativeGetOwnPropertyNames = objectGetOwnPropertyNames.f;
	var toString$1 = {}.toString;
	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function (it) {
	  try {
	    return nativeGetOwnPropertyNames(it);
	  } catch (error) {
	    return windowNames.slice();
	  }
	}; // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window


	var f$4 = function getOwnPropertyNames(it) {
	  return windowNames && toString$1.call(it) == '[object Window]' ? getWindowNames(it) : nativeGetOwnPropertyNames(toIndexedObject(it));
	};

	var objectGetOwnPropertyNamesExternal = {
	  f: f$4
	};

	var f$5 = Object.getOwnPropertySymbols;
	var objectGetOwnPropertySymbols = {
	  f: f$5
	};

	var f$6 = wellKnownSymbol;
	var wellKnownSymbolWrapped = {
	  f: f$6
	};

	var defineProperty$1 = objectDefineProperty.f;

	var defineWellKnownSymbol = function (NAME) {
	  var Symbol = path.Symbol || (path.Symbol = {});
	  if (!has(Symbol, NAME)) defineProperty$1(Symbol, NAME, {
	    value: wellKnownSymbolWrapped.f(NAME)
	  });
	};

	var push = [].push; // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex }` methods implementation

	var createMethod$2 = function (TYPE) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject($this);
	    var self = indexedObject(O);
	    var boundFunction = functionBindContext(callbackfn, that, 3);
	    var length = toLength(self.length);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate;
	    var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
	    var value, result;

	    for (; length > index; index++) if (NO_HOLES || index in self) {
	      value = self[index];
	      result = boundFunction(value, index, O);

	      if (TYPE) {
	        if (IS_MAP) target[index] = result; // map
	        else if (result) switch (TYPE) {
	            case 3:
	              return true;
	            // some

	            case 5:
	              return value;
	            // find

	            case 6:
	              return index;
	            // findIndex

	            case 2:
	              push.call(target, value);
	            // filter
	          } else if (IS_EVERY) return false; // every
	      }
	    }

	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};

	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$2(0),
	  // `Array.prototype.map` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.map
	  map: createMethod$2(1),
	  // `Array.prototype.filter` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.filter
	  filter: createMethod$2(2),
	  // `Array.prototype.some` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.some
	  some: createMethod$2(3),
	  // `Array.prototype.every` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.every
	  every: createMethod$2(4),
	  // `Array.prototype.find` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.find
	  find: createMethod$2(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$2(6)
	};

	var $forEach = arrayIteration.forEach;
	var HIDDEN = sharedKey('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE$1 = 'prototype';
	var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
	var setInternalState$2 = internalState.set;
	var getInternalState$2 = internalState.getterFor(SYMBOL);
	var ObjectPrototype$1 = Object[PROTOTYPE$1];
	var $Symbol = global_1.Symbol;
	var $stringify = getBuiltIn('JSON', 'stringify');
	var nativeGetOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	var nativeDefineProperty$1 = objectDefineProperty.f;
	var nativeGetOwnPropertyNames$1 = objectGetOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable$1 = objectPropertyIsEnumerable.f;
	var AllSymbols = shared('symbols');
	var ObjectPrototypeSymbols = shared('op-symbols');
	var StringToSymbolRegistry = shared('string-to-symbol-registry');
	var SymbolToStringRegistry = shared('symbol-to-string-registry');
	var WellKnownSymbolsStore$1 = shared('wks');
	var QObject = global_1.QObject; // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173

	var USE_SETTER = !QObject || !QObject[PROTOTYPE$1] || !QObject[PROTOTYPE$1].findChild; // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687

	var setSymbolDescriptor = descriptors && fails(function () {
	  return objectCreate(nativeDefineProperty$1({}, 'a', {
	    get: function () {
	      return nativeDefineProperty$1(this, 'a', {
	        value: 7
	      }).a;
	    }
	  })).a != 7;
	}) ? function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype$1, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype$1[P];
	  nativeDefineProperty$1(O, P, Attributes);

	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype$1) {
	    nativeDefineProperty$1(ObjectPrototype$1, P, ObjectPrototypeDescriptor);
	  }
	} : nativeDefineProperty$1;

	var wrap = function (tag, description) {
	  var symbol = AllSymbols[tag] = objectCreate($Symbol[PROTOTYPE$1]);
	  setInternalState$2(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!descriptors) symbol.description = description;
	  return symbol;
	};

	var isSymbol = useSymbolAsUid ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  return Object(it) instanceof $Symbol;
	};

	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype$1) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject(O);
	  var key = toPrimitive(P, true);
	  anObject(Attributes);

	  if (has(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!has(O, HIDDEN)) nativeDefineProperty$1(O, HIDDEN, createPropertyDescriptor(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (has(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = objectCreate(Attributes, {
	        enumerable: createPropertyDescriptor(0, false)
	      });
	    }

	    return setSymbolDescriptor(O, key, Attributes);
	  }

	  return nativeDefineProperty$1(O, key, Attributes);
	};

	var $defineProperties = function defineProperties(O, Properties) {
	  anObject(O);
	  var properties = toIndexedObject(Properties);
	  var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
	  $forEach(keys, function (key) {
	    if (!descriptors || $propertyIsEnumerable.call(properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};

	var $create = function create(O, Properties) {
	  return Properties === undefined ? objectCreate(O) : $defineProperties(objectCreate(O), Properties);
	};

	var $propertyIsEnumerable = function propertyIsEnumerable(V) {
	  var P = toPrimitive(V, true);
	  var enumerable = nativePropertyIsEnumerable$1.call(this, P);
	  if (this === ObjectPrototype$1 && has(AllSymbols, P) && !has(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !has(this, P) || !has(AllSymbols, P) || has(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
	};

	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject(O);
	  var key = toPrimitive(P, true);
	  if (it === ObjectPrototype$1 && has(AllSymbols, key) && !has(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);

	  if (descriptor && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }

	  return descriptor;
	};

	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames$1(toIndexedObject(O));
	  var result = [];
	  $forEach(names, function (key) {
	    if (!has(AllSymbols, key) && !has(hiddenKeys, key)) result.push(key);
	  });
	  return result;
	};

	var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype$1;
	  var names = nativeGetOwnPropertyNames$1(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
	  var result = [];
	  $forEach(names, function (key) {
	    if (has(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || has(ObjectPrototype$1, key))) {
	      result.push(AllSymbols[key]);
	    }
	  });
	  return result;
	}; // `Symbol` constructor
	// https://tc39.github.io/ecma262/#sec-symbol-constructor


	if (!nativeSymbol) {
	  $Symbol = function Symbol() {
	    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : String(arguments[0]);
	    var tag = uid(description);

	    var setter = function (value) {
	      if (this === ObjectPrototype$1) setter.call(ObjectPrototypeSymbols, value);
	      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
	    };

	    if (descriptors && USE_SETTER) setSymbolDescriptor(ObjectPrototype$1, tag, {
	      configurable: true,
	      set: setter
	    });
	    return wrap(tag, description);
	  };

	  redefine($Symbol[PROTOTYPE$1], 'toString', function toString() {
	    return getInternalState$2(this).tag;
	  });
	  redefine($Symbol, 'withoutSetter', function (description) {
	    return wrap(uid(description), description);
	  });
	  objectPropertyIsEnumerable.f = $propertyIsEnumerable;
	  objectDefineProperty.f = $defineProperty;
	  objectGetOwnPropertyDescriptor.f = $getOwnPropertyDescriptor;
	  objectGetOwnPropertyNames.f = objectGetOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  objectGetOwnPropertySymbols.f = $getOwnPropertySymbols;

	  wellKnownSymbolWrapped.f = function (name) {
	    return wrap(wellKnownSymbol(name), name);
	  };

	  if (descriptors) {
	    // https://github.com/tc39/proposal-Symbol-description
	    nativeDefineProperty$1($Symbol[PROTOTYPE$1], 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState$2(this).description;
	      }
	    });
	  }
	}

	_export({
	  global: true,
	  wrap: true,
	  forced: !nativeSymbol,
	  sham: !nativeSymbol
	}, {
	  Symbol: $Symbol
	});
	$forEach(objectKeys(WellKnownSymbolsStore$1), function (name) {
	  defineWellKnownSymbol(name);
	});
	_export({
	  target: SYMBOL,
	  stat: true,
	  forced: !nativeSymbol
	}, {
	  // `Symbol.for` method
	  // https://tc39.github.io/ecma262/#sec-symbol.for
	  'for': function (key) {
	    var string = String(key);
	    if (has(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = $Symbol(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry[symbol] = string;
	    return symbol;
	  },
	  // `Symbol.keyFor` method
	  // https://tc39.github.io/ecma262/#sec-symbol.keyfor
	  keyFor: function keyFor(sym) {
	    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol');
	    if (has(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  },
	  useSetter: function () {
	    USE_SETTER = true;
	  },
	  useSimple: function () {
	    USE_SETTER = false;
	  }
	});
	_export({
	  target: 'Object',
	  stat: true,
	  forced: !nativeSymbol,
	  sham: !descriptors
	}, {
	  // `Object.create` method
	  // https://tc39.github.io/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.github.io/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.github.io/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});
	_export({
	  target: 'Object',
	  stat: true,
	  forced: !nativeSymbol
	}, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames,
	  // `Object.getOwnPropertySymbols` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertysymbols
	  getOwnPropertySymbols: $getOwnPropertySymbols
	}); // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443

	_export({
	  target: 'Object',
	  stat: true,
	  forced: fails(function () {
	    objectGetOwnPropertySymbols.f(1);
	  })
	}, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    return objectGetOwnPropertySymbols.f(toObject(it));
	  }
	}); // `JSON.stringify` method behavior with symbols
	// https://tc39.github.io/ecma262/#sec-json.stringify

	if ($stringify) {
	  var FORCED_JSON_STRINGIFY = !nativeSymbol || fails(function () {
	    var symbol = $Symbol(); // MS Edge converts symbol values to JSON as {}

	    return $stringify([symbol]) != '[null]' // WebKit converts symbol values to JSON as null
	    || $stringify({
	      a: symbol
	    }) != '{}' // V8 throws on boxed symbols
	    || $stringify(Object(symbol)) != '{}';
	  });
	  _export({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED_JSON_STRINGIFY
	  }, {
	    // eslint-disable-next-line no-unused-vars
	    stringify: function stringify(it, replacer, space) {
	      var args = [it];
	      var index = 1;
	      var $replacer;

	      while (arguments.length > index) args.push(arguments[index++]);

	      $replacer = replacer;
	      if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined

	      if (!isArray(replacer)) replacer = function (key, value) {
	        if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
	        if (!isSymbol(value)) return value;
	      };
	      args[1] = replacer;
	      return $stringify.apply(null, args);
	    }
	  });
	} // `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.github.io/ecma262/#sec-symbol.prototype-@@toprimitive


	if (!$Symbol[PROTOTYPE$1][TO_PRIMITIVE]) {
	  createNonEnumerableProperty($Symbol[PROTOTYPE$1], TO_PRIMITIVE, $Symbol[PROTOTYPE$1].valueOf);
	} // `Symbol.prototype[@@toStringTag]` property
	// https://tc39.github.io/ecma262/#sec-symbol.prototype-@@tostringtag


	setToStringTag($Symbol, SYMBOL);
	hiddenKeys[HIDDEN] = true;

	// https://tc39.github.io/ecma262/#sec-symbol.asynciterator

	defineWellKnownSymbol('asyncIterator');

	// https://tc39.github.io/ecma262/#sec-symbol.hasinstance

	defineWellKnownSymbol('hasInstance');

	// https://tc39.github.io/ecma262/#sec-symbol.isconcatspreadable

	defineWellKnownSymbol('isConcatSpreadable');

	// https://tc39.github.io/ecma262/#sec-symbol.iterator

	defineWellKnownSymbol('iterator');

	// https://tc39.github.io/ecma262/#sec-symbol.match

	defineWellKnownSymbol('match');

	defineWellKnownSymbol('matchAll');

	// https://tc39.github.io/ecma262/#sec-symbol.replace

	defineWellKnownSymbol('replace');

	// https://tc39.github.io/ecma262/#sec-symbol.search

	defineWellKnownSymbol('search');

	// https://tc39.github.io/ecma262/#sec-symbol.species

	defineWellKnownSymbol('species');

	// https://tc39.github.io/ecma262/#sec-symbol.split

	defineWellKnownSymbol('split');

	// https://tc39.github.io/ecma262/#sec-symbol.toprimitive

	defineWellKnownSymbol('toPrimitive');

	// https://tc39.github.io/ecma262/#sec-symbol.tostringtag

	defineWellKnownSymbol('toStringTag');

	// https://tc39.github.io/ecma262/#sec-symbol.unscopables

	defineWellKnownSymbol('unscopables');

	// https://tc39.github.io/ecma262/#sec-math-@@tostringtag

	setToStringTag(Math, 'Math', true);

	// https://tc39.github.io/ecma262/#sec-json-@@tostringtag

	setToStringTag(global_1.JSON, 'JSON', true);

	var symbol = path.Symbol;

	var symbol$1 = symbol;

	var symbol$2 = symbol$1;

	var callWithSafeIterationClosing = function (iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value); // 7.4.6 IteratorClose(iterator, completion)
	  } catch (error) {
	    var returnMethod = iterator['return'];
	    if (returnMethod !== undefined) anObject(returnMethod.call(iterator));
	    throw error;
	  }
	};

	var ITERATOR$3 = wellKnownSymbol('iterator');
	var ArrayPrototype = Array.prototype; // check on default Array iterator

	var isArrayIteratorMethod = function (it) {
	  return it !== undefined && (iterators.Array === it || ArrayPrototype[ITERATOR$3] === it);
	};

	// https://tc39.github.io/ecma262/#sec-array.from


	var arrayFrom = function from(arrayLike
	/* , mapfn = undefined, thisArg = undefined */
	) {
	  var O = toObject(arrayLike);
	  var C = typeof this == 'function' ? this : Array;
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  var iteratorMethod = getIteratorMethod(O);
	  var index = 0;
	  var length, result, step, iterator, next, value;
	  if (mapping) mapfn = functionBindContext(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2); // if the target is not iterable or it's an array with the default iterator - use a simple case

	  if (iteratorMethod != undefined && !(C == Array && isArrayIteratorMethod(iteratorMethod))) {
	    iterator = iteratorMethod.call(O);
	    next = iterator.next;
	    result = new C();

	    for (; !(step = next.call(iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty(result, index, value);
	    }
	  } else {
	    length = toLength(O.length);
	    result = new C(length);

	    for (; length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty(result, index, value);
	    }
	  }

	  result.length = index;
	  return result;
	};

	var ITERATOR$4 = wellKnownSymbol('iterator');
	var SAFE_CLOSING = false;

	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function () {
	      return {
	        done: !!called++
	      };
	    },
	    'return': function () {
	      SAFE_CLOSING = true;
	    }
	  };

	  iteratorWithReturn[ITERATOR$4] = function () {
	    return this;
	  }; // eslint-disable-next-line no-throw-literal


	  Array.from(iteratorWithReturn, function () {
	    throw 2;
	  });
	} catch (error) {
	  /* empty */
	}

	var checkCorrectnessOfIteration = function (exec, SKIP_CLOSING) {
	  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  var ITERATION_SUPPORT = false;

	  try {
	    var object = {};

	    object[ITERATOR$4] = function () {
	      return {
	        next: function () {
	          return {
	            done: ITERATION_SUPPORT = true
	          };
	        }
	      };
	    };

	    exec(object);
	  } catch (error) {
	    /* empty */
	  }

	  return ITERATION_SUPPORT;
	};

	var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
	  Array.from(iterable);
	}); // `Array.from` method
	// https://tc39.github.io/ecma262/#sec-array.from

	_export({
	  target: 'Array',
	  stat: true,
	  forced: INCORRECT_ITERATION
	}, {
	  from: arrayFrom
	});

	var from_1 = path.Array.from;

	var from_1$1 = from_1;

	var from_1$2 = from_1$1;

	// https://tc39.github.io/ecma262/#sec-object.defineproperty

	_export({
	  target: 'Object',
	  stat: true,
	  forced: !descriptors,
	  sham: !descriptors
	}, {
	  defineProperty: objectDefineProperty.f
	});

	var defineProperty_1 = createCommonjsModule(function (module) {
	  var Object = path.Object;

	  var defineProperty = module.exports = function defineProperty(it, key, desc) {
	    return Object.defineProperty(it, key, desc);
	  };

	  if (Object.defineProperty.sham) defineProperty.sham = true;
	});

	var defineProperty$2 = defineProperty_1;

	var defineProperty$3 = defineProperty$2;

	// https://tc39.github.io/ecma262/#sec-object.defineproperties

	_export({
	  target: 'Object',
	  stat: true,
	  forced: !descriptors,
	  sham: !descriptors
	}, {
	  defineProperties: objectDefineProperties
	});

	var defineProperties_1 = createCommonjsModule(function (module) {
	  var Object = path.Object;

	  var defineProperties = module.exports = function defineProperties(T, D) {
	    return Object.defineProperties(T, D);
	  };

	  if (Object.defineProperties.sham) defineProperties.sham = true;
	});

	var defineProperties = defineProperties_1;

	var defineProperties$1 = defineProperties;

	var ownKeys = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = objectGetOwnPropertyNames.f(anObject(it));
	  var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
	  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
	};

	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors

	_export({
	  target: 'Object',
	  stat: true,
	  sham: !descriptors
	}, {
	  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
	    var O = toIndexedObject(object);
	    var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	    var keys = ownKeys(O);
	    var result = {};
	    var index = 0;
	    var key, descriptor;

	    while (keys.length > index) {
	      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
	      if (descriptor !== undefined) createProperty(result, key, descriptor);
	    }

	    return result;
	  }
	});

	var getOwnPropertyDescriptors = path.Object.getOwnPropertyDescriptors;

	var getOwnPropertyDescriptors$1 = getOwnPropertyDescriptors;

	var getOwnPropertyDescriptors$2 = getOwnPropertyDescriptors$1;

	var nativeGetOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f;
	var FAILS_ON_PRIMITIVES = fails(function () {
	  nativeGetOwnPropertyDescriptor$2(1);
	});
	var FORCED$1 = !descriptors || FAILS_ON_PRIMITIVES; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FORCED$1,
	  sham: !descriptors
	}, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
	    return nativeGetOwnPropertyDescriptor$2(toIndexedObject(it), key);
	  }
	});

	var getOwnPropertyDescriptor_1 = createCommonjsModule(function (module) {
	  var Object = path.Object;

	  var getOwnPropertyDescriptor = module.exports = function getOwnPropertyDescriptor(it, key) {
	    return Object.getOwnPropertyDescriptor(it, key);
	  };

	  if (Object.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor.sham = true;
	});

	var getOwnPropertyDescriptor$2 = getOwnPropertyDescriptor_1;

	var getOwnPropertyDescriptor$3 = getOwnPropertyDescriptor$2;

	var getOwnPropertySymbols = path.Object.getOwnPropertySymbols;

	var getOwnPropertySymbols$1 = getOwnPropertySymbols;

	var getOwnPropertySymbols$2 = getOwnPropertySymbols$1;

	// https://tc39.github.io/ecma262/#sec-object.create

	_export({
	  target: 'Object',
	  stat: true,
	  sham: !descriptors
	}, {
	  create: objectCreate
	});

	var Object$1 = path.Object;

	var create = function create(P, D) {
	  return Object$1.create(P, D);
	};

	var create$1 = create;

	var create$2 = create$1;

	var defineProperty$4 = defineProperty_1;

	var defineProperty$5 = defineProperty$4;

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    defineProperty$5(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	var defineProperty$6 = _defineProperty;

	var FAILS_ON_PRIMITIVES$1 = fails(function () {
	  objectKeys(1);
	}); // `Object.keys` method
	// https://tc39.github.io/ecma262/#sec-object.keys

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$1
	}, {
	  keys: function keys(it) {
	    return objectKeys(toObject(it));
	  }
	});

	var keys$1 = path.Object.keys;

	var keys$2 = keys$1;

	var keys$3 = keys$2;

	// a string of all valid unicode whitespaces
	// eslint-disable-next-line max-len
	var whitespaces = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

	var whitespace = '[' + whitespaces + ']';
	var ltrim = RegExp('^' + whitespace + whitespace + '*');
	var rtrim = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation

	var createMethod$3 = function (TYPE) {
	  return function ($this) {
	    var string = String(requireObjectCoercible($this));
	    if (TYPE & 1) string = string.replace(ltrim, '');
	    if (TYPE & 2) string = string.replace(rtrim, '');
	    return string;
	  };
	};

	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trimstart
	  start: createMethod$3(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trimend
	  end: createMethod$3(2),
	  // `String.prototype.trim` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trim
	  trim: createMethod$3(3)
	};

	var non = '\u200B\u0085\u180E'; // check that a method works with the correct list
	// of whitespaces and has a correct name

	var stringTrimForced = function (METHOD_NAME) {
	  return fails(function () {
	    return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces[METHOD_NAME].name !== METHOD_NAME;
	  });
	};

	var $trim = stringTrim.trim; // `String.prototype.trim` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.trim

	_export({
	  target: 'String',
	  proto: true,
	  forced: stringTrimForced('trim')
	}, {
	  trim: function trim() {
	    return $trim(this);
	  }
	});

	var trim = entryVirtual('String').trim;

	var StringPrototype = String.prototype;

	var trim_1 = function (it) {
	  var own = it.trim;
	  return typeof it === 'string' || it === StringPrototype || it instanceof String && own === StringPrototype.trim ? trim : own;
	};

	var trim$1 = trim_1;

	var trim$2 = trim$1;

	var arrayMethodIsStrict = function (METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails(function () {
	    // eslint-disable-next-line no-useless-call,no-throw-literal
	    method.call(null, argument || function () {
	      throw 1;
	    }, 1);
	  });
	};

	var defineProperty$7 = Object.defineProperty;
	var cache = {};

	var thrower = function (it) {
	  throw it;
	};

	var arrayMethodUsesToLength = function (METHOD_NAME, options) {
	  if (has(cache, METHOD_NAME)) return cache[METHOD_NAME];
	  if (!options) options = {};
	  var method = [][METHOD_NAME];
	  var ACCESSORS = has(options, 'ACCESSORS') ? options.ACCESSORS : false;
	  var argument0 = has(options, 0) ? options[0] : thrower;
	  var argument1 = has(options, 1) ? options[1] : undefined;
	  return cache[METHOD_NAME] = !!method && !fails(function () {
	    if (ACCESSORS && !descriptors) return true;
	    var O = {
	      length: -1
	    };
	    if (ACCESSORS) defineProperty$7(O, 1, {
	      enumerable: true,
	      get: thrower
	    });else O[1] = 1;
	    method.call(O, argument0, argument1);
	  });
	};

	var $forEach$1 = arrayIteration.forEach;
	var STRICT_METHOD = arrayMethodIsStrict('forEach');
	var USES_TO_LENGTH = arrayMethodUsesToLength('forEach'); // `Array.prototype.forEach` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.foreach

	var arrayForEach = !STRICT_METHOD || !USES_TO_LENGTH ? function forEach(callbackfn
	/* , thisArg */
	) {
	  return $forEach$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	} : [].forEach;

	// https://tc39.github.io/ecma262/#sec-array.prototype.foreach


	_export({
	  target: 'Array',
	  proto: true,
	  forced: [].forEach != arrayForEach
	}, {
	  forEach: arrayForEach
	});

	var forEach = entryVirtual('Array').forEach;

	var forEach$1 = forEach;

	var ArrayPrototype$1 = Array.prototype;
	var DOMIterables = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var forEach_1 = function (it) {
	  var own = it.forEach;
	  return it === ArrayPrototype$1 || it instanceof Array && own === ArrayPrototype$1.forEach // eslint-disable-next-line no-prototype-builtins
	  || DOMIterables.hasOwnProperty(classof(it)) ? forEach$1 : own;
	};

	var forEach$2 = forEach_1;

	var $map = arrayIteration.map;
	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map'); // FF49- issue

	var USES_TO_LENGTH$1 = arrayMethodUsesToLength('map'); // `Array.prototype.map` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.map
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH$1
	}, {
	  map: function map(callbackfn
	  /* , thisArg */
	  ) {
	    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var map = entryVirtual('Array').map;

	var ArrayPrototype$2 = Array.prototype;

	var map_1 = function (it) {
	  var own = it.map;
	  return it === ArrayPrototype$2 || it instanceof Array && own === ArrayPrototype$2.map ? map : own;
	};

	var map$1 = map_1;

	var map$2 = map$1;

	var trim$3 = stringTrim.trim;
	var $parseInt = global_1.parseInt;
	var hex = /^[+-]?0[Xx]/;
	var FORCED$2 = $parseInt(whitespaces + '08') !== 8 || $parseInt(whitespaces + '0x16') !== 22; // `parseInt` method
	// https://tc39.github.io/ecma262/#sec-parseint-string-radix

	var numberParseInt = FORCED$2 ? function parseInt(string, radix) {
	  var S = trim$3(String(string));
	  return $parseInt(S, radix >>> 0 || (hex.test(S) ? 16 : 10));
	} : $parseInt;

	// https://tc39.github.io/ecma262/#sec-parseint-string-radix

	_export({
	  global: true,
	  forced: parseInt != numberParseInt
	}, {
	  parseInt: numberParseInt
	});

	var _parseInt = path.parseInt;

	var _parseInt$1 = _parseInt;

	var _parseInt$2 = _parseInt$1;

	var propertyIsEnumerable = objectPropertyIsEnumerable.f; // `Object.{ entries, values }` methods implementation

	var createMethod$4 = function (TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject(it);
	    var keys = objectKeys(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;

	    while (length > i) {
	      key = keys[i++];

	      if (!descriptors || propertyIsEnumerable.call(O, key)) {
	        result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }

	    return result;
	  };
	};

	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.github.io/ecma262/#sec-object.entries
	  entries: createMethod$4(true),
	  // `Object.values` method
	  // https://tc39.github.io/ecma262/#sec-object.values
	  values: createMethod$4(false)
	};

	var $values = objectToArray.values; // `Object.values` method
	// https://tc39.github.io/ecma262/#sec-object.values

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  values: function values(O) {
	    return $values(O);
	  }
	});

	var values = path.Object.values;

	var values$1 = values;

	var values$2 = values$1;

	var $filter = arrayIteration.filter;
	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport('filter'); // Edge 14- issue

	var USES_TO_LENGTH$2 = arrayMethodUsesToLength('filter'); // `Array.prototype.filter` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.filter
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$1 || !USES_TO_LENGTH$2
	}, {
	  filter: function filter(callbackfn
	  /* , thisArg */
	  ) {
	    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var filter = entryVirtual('Array').filter;

	var ArrayPrototype$3 = Array.prototype;

	var filter_1 = function (it) {
	  var own = it.filter;
	  return it === ArrayPrototype$3 || it instanceof Array && own === ArrayPrototype$3.filter ? filter : own;
	};

	var filter$1 = filter_1;

	var filter$2 = filter$1;

	var concat = entryVirtual('Array').concat;

	var ArrayPrototype$4 = Array.prototype;

	var concat_1 = function (it) {
	  var own = it.concat;
	  return it === ArrayPrototype$4 || it instanceof Array && own === ArrayPrototype$4.concat ? concat : own;
	};

	var concat$1 = concat_1;

	var concat$2 = concat$1;

	// https://tc39.github.io/ecma262/#sec-array.isarray

	_export({
	  target: 'Array',
	  stat: true
	}, {
	  isArray: isArray
	});

	var isArray$1 = path.Array.isArray;

	var isArray$2 = isArray$1;

	var isArray$3 = isArray$2;

	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;

	  for (var i = 0, arr2 = new Array(len); i < len; i++) {
	    arr2[i] = arr[i];
	  }

	  return arr2;
	}

	var arrayLikeToArray = _arrayLikeToArray;

	function _arrayWithoutHoles(arr) {
	  if (isArray$3(arr)) return arrayLikeToArray(arr);
	}

	var arrayWithoutHoles = _arrayWithoutHoles;

	var from_1$3 = from_1;

	var from_1$4 = from_1$3;

	var ITERATOR$5 = wellKnownSymbol('iterator');

	var isIterable = function (it) {
	  var O = Object(it);
	  return O[ITERATOR$5] !== undefined || '@@iterator' in O // eslint-disable-next-line no-prototype-builtins
	  || iterators.hasOwnProperty(classof(O));
	};

	var isIterable_1 = isIterable;

	var isIterable$1 = isIterable_1;

	// https://github.com/tc39/proposal-using-statement

	defineWellKnownSymbol('asyncDispose');

	// https://github.com/tc39/proposal-using-statement

	defineWellKnownSymbol('dispose');

	// https://github.com/tc39/proposal-observable

	defineWellKnownSymbol('observable');

	// https://github.com/tc39/proposal-pattern-matching

	defineWellKnownSymbol('patternMatch');

	defineWellKnownSymbol('replaceAll');

	var symbol$3 = symbol;

	var symbol$4 = symbol$3;

	function _iterableToArray(iter) {
	  if (typeof symbol$4 !== "undefined" && isIterable$1(Object(iter))) return from_1$4(iter);
	}

	var iterableToArray = _iterableToArray;

	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport('slice');
	var USES_TO_LENGTH$3 = arrayMethodUsesToLength('slice', {
	  ACCESSORS: true,
	  0: 0,
	  1: 2
	});
	var SPECIES$2 = wellKnownSymbol('species');
	var nativeSlice = [].slice;
	var max$1 = Math.max; // `Array.prototype.slice` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$2 || !USES_TO_LENGTH$3
	}, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject(this);
	    var length = toLength(O.length);
	    var k = toAbsoluteIndex(start, length);
	    var fin = toAbsoluteIndex(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible

	    var Constructor, result, n;

	    if (isArray(O)) {
	      Constructor = O.constructor; // cross-realm fallback

	      if (typeof Constructor == 'function' && (Constructor === Array || isArray(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject(Constructor)) {
	        Constructor = Constructor[SPECIES$2];
	        if (Constructor === null) Constructor = undefined;
	      }

	      if (Constructor === Array || Constructor === undefined) {
	        return nativeSlice.call(O, k, fin);
	      }
	    }

	    result = new (Constructor === undefined ? Array : Constructor)(max$1(fin - k, 0));

	    for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);

	    result.length = n;
	    return result;
	  }
	});

	var slice$1 = entryVirtual('Array').slice;

	var ArrayPrototype$5 = Array.prototype;

	var slice_1 = function (it) {
	  var own = it.slice;
	  return it === ArrayPrototype$5 || it instanceof Array && own === ArrayPrototype$5.slice ? slice$1 : own;
	};

	var slice$2 = slice_1;

	var slice$3 = slice$2;

	function _unsupportedIterableToArray(o, minLen) {
	  var _context;

	  if (!o) return;
	  if (typeof o === "string") return arrayLikeToArray(o, minLen);

	  var n = slice$3(_context = Object.prototype.toString.call(o)).call(_context, 8, -1);

	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return from_1$4(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
	}

	var unsupportedIterableToArray = _unsupportedIterableToArray;

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	var nonIterableSpread = _nonIterableSpread;

	function _toConsumableArray(arr) {
	  return arrayWithoutHoles(arr) || iterableToArray(arr) || unsupportedIterableToArray(arr) || nonIterableSpread();
	}

	var toConsumableArray = _toConsumableArray;

	var slice$4 = slice_1;

	var slice$5 = slice$4;

	var FAILS_ON_PRIMITIVES$2 = fails(function () {
	  objectGetPrototypeOf(1);
	}); // `Object.getPrototypeOf` method
	// https://tc39.github.io/ecma262/#sec-object.getprototypeof

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$2,
	  sham: !correctPrototypeGetter
	}, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return objectGetPrototypeOf(toObject(it));
	  }
	});

	var getPrototypeOf = path.Object.getPrototypeOf;

	var getPrototypeOf$1 = getPrototypeOf;

	var getPrototypeOf$2 = getPrototypeOf$1;

	var $indexOf = arrayIncludes.indexOf;
	var nativeIndexOf = [].indexOf;
	var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
	var STRICT_METHOD$1 = arrayMethodIsStrict('indexOf');
	var USES_TO_LENGTH$4 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	}); // `Array.prototype.indexOf` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.indexof

	_export({
	  target: 'Array',
	  proto: true,
	  forced: NEGATIVE_ZERO || !STRICT_METHOD$1 || !USES_TO_LENGTH$4
	}, {
	  indexOf: function indexOf(searchElement
	  /* , fromIndex = 0 */
	  ) {
	    return NEGATIVE_ZERO // convert -0 to +0
	    ? nativeIndexOf.apply(this, arguments) || 0 : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var indexOf$1 = entryVirtual('Array').indexOf;

	var ArrayPrototype$6 = Array.prototype;

	var indexOf_1 = function (it) {
	  var own = it.indexOf;
	  return it === ArrayPrototype$6 || it instanceof Array && own === ArrayPrototype$6.indexOf ? indexOf$1 : own;
	};

	var indexOf$2 = indexOf_1;

	var indexOf$3 = indexOf$2;

	var isArray$4 = isArray$1;

	var isArray$5 = isArray$4;

	var nativeAssign = Object.assign;
	var defineProperty$8 = Object.defineProperty; // `Object.assign` method
	// https://tc39.github.io/ecma262/#sec-object.assign

	var objectAssign = !nativeAssign || fails(function () {
	  // should have correct order of operations (Edge bug)
	  if (descriptors && nativeAssign({
	    b: 1
	  }, nativeAssign(defineProperty$8({}, 'a', {
	    enumerable: true,
	    get: function () {
	      defineProperty$8(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), {
	    b: 2
	  })).b !== 1) return true; // should work with symbols and should have deterministic property order (V8 bug)

	  var A = {};
	  var B = {}; // eslint-disable-next-line no-undef

	  var symbol = Symbol();
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) {
	    B[chr] = chr;
	  });
	  return nativeAssign({}, A)[symbol] != 7 || objectKeys(nativeAssign({}, B)).join('') != alphabet;
	}) ? function assign(target, source) {
	  // eslint-disable-line no-unused-vars
	  var T = toObject(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
	  var propertyIsEnumerable = objectPropertyIsEnumerable.f;

	  while (argumentsLength > index) {
	    var S = indexedObject(arguments[index++]);
	    var keys = getOwnPropertySymbols ? objectKeys(S).concat(getOwnPropertySymbols(S)) : objectKeys(S);
	    var length = keys.length;
	    var j = 0;
	    var key;

	    while (length > j) {
	      key = keys[j++];
	      if (!descriptors || propertyIsEnumerable.call(S, key)) T[key] = S[key];
	    }
	  }

	  return T;
	} : nativeAssign;

	// https://tc39.github.io/ecma262/#sec-object.assign

	_export({
	  target: 'Object',
	  stat: true,
	  forced: Object.assign !== objectAssign
	}, {
	  assign: objectAssign
	});

	var assign = path.Object.assign;

	var assign$1 = assign;

	var assign$2 = assign$1;

	var iterator = wellKnownSymbolWrapped.f('iterator');

	var iterator$1 = iterator;

	var iterator$2 = iterator$1;

	var _typeof_1 = createCommonjsModule(function (module) {
	  function _typeof(obj) {
	    "@babel/helpers - typeof";

	    if (typeof symbol$4 === "function" && typeof iterator$2 === "symbol") {
	      module.exports = _typeof = function _typeof(obj) {
	        return typeof obj;
	      };
	    } else {
	      module.exports = _typeof = function _typeof(obj) {
	        return obj && typeof symbol$4 === "function" && obj.constructor === symbol$4 && obj !== symbol$4.prototype ? "symbol" : typeof obj;
	      };
	    }

	    return _typeof(obj);
	  }

	  module.exports = _typeof;
	});

	function _arrayWithHoles(arr) {
	  if (isArray$3(arr)) return arr;
	}

	var arrayWithHoles = _arrayWithHoles;

	function _iterableToArrayLimit(arr, i) {
	  if (typeof symbol$4 === "undefined" || !isIterable$1(Object(arr))) return;
	  var _arr = [];
	  var _n = true;
	  var _d = false;
	  var _e = undefined;

	  try {
	    for (var _i = getIterator$1(arr), _s; !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	var iterableToArrayLimit = _iterableToArrayLimit;

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	var nonIterableRest = _nonIterableRest;

	function _slicedToArray(arr, i) {
	  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || unsupportedIterableToArray(arr, i) || nonIterableRest();
	}

	var slicedToArray = _slicedToArray;

	// https://tc39.github.io/ecma262/#sec-date.now

	_export({
	  target: 'Date',
	  stat: true
	}, {
	  now: function now() {
	    return new Date().getTime();
	  }
	});

	var now = path.Date.now;

	var now$1 = now;

	var now$2 = now$1;

	function _createForOfIteratorHelper(o) { if (typeof symbol$2 === "undefined" || getIteratorMethod$1(o) == null) { if (isArray$5(o) || (o = _unsupportedIterableToArray$1(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = getIterator$1(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$1(o, minLen) { var _context13; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$1(o, minLen); var n = slice$5(_context13 = Object.prototype.toString.call(o)).call(_context13, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from_1$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$1(o, minLen); }

	function _arrayLikeToArray$1(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

	function ownKeys$1(object, enumerableOnly) { var keys = keys$3(object); if (getOwnPropertySymbols$2) { var symbols = getOwnPropertySymbols$2(object); if (enumerableOnly) symbols = filter$2(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$3(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context11; forEach$2(_context11 = ownKeys$1(Object(source), true)).call(_context11, function (key) { defineProperty$6(target, key, source[key]); }); } else if (getOwnPropertyDescriptors$2) { defineProperties$1(target, getOwnPropertyDescriptors$2(source)); } else { var _context12; forEach$2(_context12 = ownKeys$1(Object(source))).call(_context12, function (key) { defineProperty$3(target, key, getOwnPropertyDescriptor$3(source, key)); }); } } return target; }

	/**
	 * vis-util
	 * https://github.com/visjs/vis-util
	 *
	 * utilitie collection for visjs
	 *
	 * @version 4.0.0
	 * @date    2020-02-29T15:35:13.178Z
	 *
	 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
	 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
	 *
	 * @license
	 * vis.js is dual licensed under both
	 *
	 *   1. The Apache 2.0 License
	 *      http://www.apache.org/licenses/LICENSE-2.0
	 *
	 *   and
	 *
	 *   2. The MIT License
	 *      http://opensource.org/licenses/MIT
	 *
	 * vis.js may be distributed under either license.
	 */

	/**
	 * Seedable, fast and reasonably good (not crypto but more than okay for our
	 * needs) random number generator.
	 *
	 * @remarks
	 * Adapted from {@link https://web.archive.org/web/20110429100736/http://baagoe.com:80/en/RandomMusings/javascript}.
	 * Original algorithm created by Johannes Baagøe \<baagoe\@baagoe.com\> in 2010.
	 */

	/**
	 * Create a seeded pseudo random generator based on Alea by Johannes Baagøe.
	 *
	 * @param seed - All supplied arguments will be used as a seed. In case nothing
	 * is supplied the current time will be used to seed the generator.
	 *
	 * @returns A ready to use seeded generator.
	 */
	function Alea() {
	  for (var _len = arguments.length, seed = new Array(_len), _key = 0; _key < _len; _key++) {
	    seed[_key] = arguments[_key];
	  }

	  return AleaImplementation(seed.length ? seed : [now$2()]);
	}
	/**
	 * An implementation of [[Alea]] without user input validation.
	 *
	 * @param seed - The data that will be used to seed the generator.
	 *
	 * @returns A ready to use seeded generator.
	 */


	function AleaImplementation(seed) {
	  var _mashSeed = mashSeed(seed),
	      _mashSeed2 = slicedToArray(_mashSeed, 3),
	      s0 = _mashSeed2[0],
	      s1 = _mashSeed2[1],
	      s2 = _mashSeed2[2];

	  var c = 1;

	  var random = function random() {
	    var t = 2091639 * s0 + c * 2.3283064365386963e-10; // 2^-32

	    s0 = s1;
	    s1 = s2;
	    return s2 = t - (c = t | 0);
	  };

	  random.uint32 = function () {
	    return random() * 0x100000000;
	  }; // 2^32


	  random.fract53 = function () {
	    return random() + (random() * 0x200000 | 0) * 1.1102230246251565e-16;
	  }; // 2^-53


	  random.algorithm = "Alea";
	  random.seed = seed;
	  random.version = "0.9";
	  return random;
	}
	/**
	 * Turn arbitrary data into values [[AleaImplementation]] can use to generate
	 * random numbers.
	 *
	 * @param seed - Arbitrary data that will be used as the seed.
	 *
	 * @returns Three numbers to use as initial values for [[AleaImplementation]].
	 */


	function mashSeed() {
	  var mash = Mash();
	  var s0 = mash(" ");
	  var s1 = mash(" ");
	  var s2 = mash(" ");

	  for (var i = 0; i < arguments.length; i++) {
	    s0 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

	    if (s0 < 0) {
	      s0 += 1;
	    }

	    s1 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

	    if (s1 < 0) {
	      s1 += 1;
	    }

	    s2 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);

	    if (s2 < 0) {
	      s2 += 1;
	    }
	  }

	  return [s0, s1, s2];
	}
	/**
	 * Create a new mash function.
	 *
	 * @returns A nonpure function that takes arbitrary [[Mashable]] data and turns
	 * them into numbers.
	 */


	function Mash() {
	  var n = 0xefc8249d;
	  return function (data) {
	    var string = data.toString();

	    for (var i = 0; i < string.length; i++) {
	      n += string.charCodeAt(i);
	      var h = 0.02519603282416938 * n;
	      n = h >>> 0;
	      h -= n;
	      h *= n;
	      n = h >>> 0;
	      h -= n;
	      n += h * 0x100000000; // 2^32
	    }

	    return (n >>> 0) * 2.3283064365386963e-10; // 2^-32
	  };
	} // utility functions
	// parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/


	var ASPDateRegex = /^\/?Date\((-?\d+)/i; // Color REs

	var fullHexRE = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
	var shortHexRE = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
	var rgbRE = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i;
	var rgbaRE = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;
	/**
	 * Test whether given object is a number.
	 *
	 * @param value - Input value of unknown type.
	 *
	 * @returns True if number, false otherwise.
	 */

	function isNumber(value) {
	  return value instanceof Number || typeof value === "number";
	}
	/**
	 * Remove everything in the DOM object.
	 *
	 * @param DOMobject - Node whose child nodes will be recursively deleted.
	 */


	function recursiveDOMDelete(DOMobject) {
	  if (DOMobject) {
	    while (DOMobject.hasChildNodes() === true) {
	      var child = DOMobject.firstChild;

	      if (child) {
	        recursiveDOMDelete(child);
	        DOMobject.removeChild(child);
	      }
	    }
	  }
	}
	/**
	 * Test whether given object is a string.
	 *
	 * @param value - Input value of unknown type.
	 *
	 * @returns True if string, false otherwise.
	 */


	function isString(value) {
	  return value instanceof String || typeof value === "string";
	}
	/**
	 * Test whether given object is a object (not primitive or null).
	 *
	 * @param value - Input value of unknown type.
	 *
	 * @returns True if not null object, false otherwise.
	 */


	function isObject$1(value) {
	  return _typeof_1(value) === "object" && value !== null;
	}
	/**
	 * Test whether given object is a Date, or a String containing a Date.
	 *
	 * @param value - Input value of unknown type.
	 *
	 * @returns True if Date instance or string date representation, false otherwise.
	 */


	function isDate(value) {
	  if (value instanceof Date) {
	    return true;
	  } else if (isString(value)) {
	    // test whether this string contains a date
	    var match = ASPDateRegex.exec(value);

	    if (match) {
	      return true;
	    } else if (!isNaN(Date.parse(value))) {
	      return true;
	    }
	  }

	  return false;
	}
	/**
	 * Copy property from b to a if property present in a.
	 * If property in b explicitly set to null, delete it if `allowDeletion` set.
	 *
	 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param prop - Name of property to copy from b to a.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 */


	function copyOrDelete(a, b, prop, allowDeletion) {
	  var doDeletion = false;

	  if (allowDeletion === true) {
	    doDeletion = b[prop] === null && a[prop] !== undefined;
	  }

	  if (doDeletion) {
	    delete a[prop];
	  } else {
	    a[prop] = b[prop]; // Remember, this is a reference copy!
	  }
	}
	/**
	 * Fill an object with a possibly partially defined other object.
	 *
	 * Only copies values for the properties already present in a.
	 * That means an object is not created on a property if only the b object has it.
	 *
	 * @param a - The object that will have it's properties updated.
	 * @param b - The object with property updates.
	 * @param allowDeletion - If true, delete properties in a that are explicitly set to null in b.
	 */


	function fillIfDefined(a, b) {
	  var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	  // NOTE: iteration of properties of a
	  // NOTE: prototype properties iterated over as well
	  for (var prop in a) {
	    if (b[prop] !== undefined) {
	      if (b[prop] === null || _typeof_1(b[prop]) !== "object") {
	        // Note: typeof null === 'object'
	        copyOrDelete(a, b, prop, allowDeletion);
	      } else {
	        var aProp = a[prop];
	        var bProp = b[prop];

	        if (isObject$1(aProp) && isObject$1(bProp)) {
	          fillIfDefined(aProp, bProp, allowDeletion);
	        }
	      }
	    }
	  }
	}
	/**
	 * Copy the values of all of the enumerable own properties from one or more source objects to a
	 * target object. Returns the target object.
	 *
	 * @param target - The target object to copy to.
	 * @param source - The source object from which to copy properties.
	 *
	 * @returns The target object.
	 */


	var extend = assign$2;
	/**
	 * Extend object a with selected properties of object b or a series of objects.
	 *
	 * @remarks
	 * Only properties with defined values are copied.
	 *
	 * @param props - Properties to be copied to a.
	 * @param a - The target.
	 * @param others - The sources.
	 *
	 * @returns Argument a.
	 */

	function selectiveExtend(props, a) {
	  if (!isArray$5(props)) {
	    throw new Error("Array with property names expected as first argument");
	  }

	  for (var _len2 = arguments.length, others = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
	    others[_key2 - 2] = arguments[_key2];
	  }

	  for (var _i = 0, _others = others; _i < _others.length; _i++) {
	    var other = _others[_i];

	    for (var p = 0; p < props.length; p++) {
	      var prop = props[p];

	      if (other && Object.prototype.hasOwnProperty.call(other, prop)) {
	        a[prop] = other[prop];
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Extend object a with selected properties of object b.
	 * Only properties with defined values are copied.
	 *
	 * @remarks
	 * Previous version of this routine implied that multiple source objects could
	 * be used; however, the implementation was **wrong**. Since multiple (\>1)
	 * sources weren't used anywhere in the `vis.js` code, this has been removed
	 *
	 * @param props - Names of first-level properties to copy over.
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
	 *
	 * @returns Argument a.
	 */


	function selectiveDeepExtend(props, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	  // TODO: add support for Arrays to deepExtend
	  if (isArray$5(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }

	  for (var p = 0; p < props.length; p++) {
	    var prop = props[p];

	    if (Object.prototype.hasOwnProperty.call(b, prop)) {
	      if (b[prop] && b[prop].constructor === Object) {
	        if (a[prop] === undefined) {
	          a[prop] = {};
	        }

	        if (a[prop].constructor === Object) {
	          deepExtend(a[prop], b[prop], false, allowDeletion);
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (isArray$5(b[prop])) {
	        throw new TypeError("Arrays are not supported by deepExtend");
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Extend object `a` with properties of object `b`, ignoring properties which
	 * are explicitly specified to be excluded.
	 *
	 * @remarks
	 * The properties of `b` are considered for copying. Properties which are
	 * themselves objects are are also extended. Only properties with defined
	 * values are copied.
	 *
	 * @param propsToExclude - Names of properties which should *not* be copied.
	 * @param a - Object to extend.
	 * @param b - Object to take properties from for extension.
	 * @param allowDeletion - If true, delete properties in a that are explicitly
	 * set to null in b.
	 *
	 * @returns Argument a.
	 */


	function selectiveNotDeepExtend(propsToExclude, a, b) {
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	  // TODO: add support for Arrays to deepExtend
	  // NOTE: array properties have an else-below; apparently, there is a problem here.
	  if (isArray$5(b)) {
	    throw new TypeError("Arrays are not supported by deepExtend");
	  }

	  for (var prop in b) {
	    if (!Object.prototype.hasOwnProperty.call(b, prop)) {
	      continue;
	    } // Handle local properties only


	    if (indexOf$3(propsToExclude).call(propsToExclude, prop) !== -1) {
	      continue;
	    } // In exclusion list, skip


	    if (b[prop] && b[prop].constructor === Object) {
	      if (a[prop] === undefined) {
	        a[prop] = {};
	      }

	      if (a[prop].constructor === Object) {
	        deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    } else if (isArray$5(b[prop])) {
	      a[prop] = [];

	      for (var i = 0; i < b[prop].length; i++) {
	        a[prop].push(b[prop][i]);
	      }
	    } else {
	      copyOrDelete(a, b, prop, allowDeletion);
	    }
	  }

	  return a;
	}
	/**
	 * Deep extend an object a with the properties of object b.
	 *
	 * @param a - Target object.
	 * @param b - Source object.
	 * @param protoExtend - If true, the prototype values will also be extended.
	 * (That is the options objects that inherit from others will also get the
	 * inherited options).
	 * @param allowDeletion - If true, the values of fields that are null will be deleted.
	 *
	 * @returns Argument a.
	 */


	function deepExtend(a, b) {
	  var protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	  for (var prop in b) {
	    if (Object.prototype.hasOwnProperty.call(b, prop) || protoExtend === true) {
	      if (_typeof_1(b[prop]) === "object" && b[prop] !== null && getPrototypeOf$2(b[prop]) === Object.prototype) {
	        if (a[prop] === undefined) {
	          a[prop] = deepExtend({}, b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else if (_typeof_1(a[prop]) === "object" && a[prop] !== null && getPrototypeOf$2(a[prop]) === Object.prototype) {
	          deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
	        } else {
	          copyOrDelete(a, b, prop, allowDeletion);
	        }
	      } else if (isArray$5(b[prop])) {
	        var _context;

	        a[prop] = slice$5(_context = b[prop]).call(_context);
	      } else {
	        copyOrDelete(a, b, prop, allowDeletion);
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Test whether all elements in two arrays are equal.
	 *
	 * @param a - First array.
	 * @param b - Second array.
	 *
	 * @returns True if both arrays have the same length and same elements (1 = '1').
	 */


	function equalArray(a, b) {
	  if (a.length !== b.length) {
	    return false;
	  }

	  for (var i = 0, len = a.length; i < len; i++) {
	    if (a[i] != b[i]) {
	      return false;
	    }
	  }

	  return true;
	}
	/**
	 * Get the type of an object, for example exports.getType([]) returns 'Array'.
	 *
	 * @param object - Input value of unknown type.
	 *
	 * @returns Detected type.
	 */


	function getType(object) {
	  var type = _typeof_1(object);

	  if (type === "object") {
	    if (object === null) {
	      return "null";
	    }

	    if (object instanceof Boolean) {
	      return "Boolean";
	    }

	    if (object instanceof Number) {
	      return "Number";
	    }

	    if (object instanceof String) {
	      return "String";
	    }

	    if (isArray$5(object)) {
	      return "Array";
	    }

	    if (object instanceof Date) {
	      return "Date";
	    }

	    return "Object";
	  }

	  if (type === "number") {
	    return "Number";
	  }

	  if (type === "boolean") {
	    return "Boolean";
	  }

	  if (type === "string") {
	    return "String";
	  }

	  if (type === undefined) {
	    return "undefined";
	  }

	  return type;
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - First part.
	 * @param newValue - The value to be aadded into the array.
	 *
	 * @returns A new array with all items from arr and newValue (which is last).
	 */


	function copyAndExtendArray(arr, newValue) {
	  var _context2;

	  return concat$2(_context2 = []).call(_context2, toConsumableArray(arr), [newValue]);
	}
	/**
	 * Used to extend an array and copy it. This is used to propagate paths recursively.
	 *
	 * @param arr - The array to be copied.
	 *
	 * @returns Shallow copy of arr.
	 */


	function copyArray(arr) {
	  return slice$5(arr).call(arr);
	}
	/**
	 * Retrieve the absolute left value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 *
	 * @returns The absolute left position of this element in the browser page.
	 */


	function getAbsoluteLeft(elem) {
	  return elem.getBoundingClientRect().left;
	}
	/**
	 * Retrieve the absolute right value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 *
	 * @returns The absolute right position of this element in the browser page.
	 */


	function getAbsoluteRight(elem) {
	  return elem.getBoundingClientRect().right;
	}
	/**
	 * Retrieve the absolute top value of a DOM element.
	 *
	 * @param elem - A dom element, for example a div.
	 *
	 * @returns The absolute top position of this element in the browser page.
	 */


	function getAbsoluteTop(elem) {
	  return elem.getBoundingClientRect().top;
	}
	/**
	 * Add a className to the given elements style.
	 *
	 * @param elem - The element to which the classes will be added.
	 * @param classNames - Space separated list of classes.
	 */


	function addClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var newClasses = classNames.split(" ");
	  classes = concat$2(classes).call(classes, filter$2(newClasses).call(newClasses, function (className) {
	    return indexOf$3(classes).call(classes, className) < 0;
	  }));
	  elem.className = classes.join(" ");
	}
	/**
	 * Remove a className from the given elements style.
	 *
	 * @param elem - The element from which the classes will be removed.
	 * @param classNames - Space separated list of classes.
	 */


	function removeClassName(elem, classNames) {
	  var classes = elem.className.split(" ");
	  var oldClasses = classNames.split(" ");
	  classes = filter$2(classes).call(classes, function (className) {
	    return indexOf$3(oldClasses).call(oldClasses, className) < 0;
	  });
	  elem.className = classes.join(" ");
	}
	/**
	 * For each method for both arrays and objects.
	 * In case of an array, the built-in Array.forEach() is applied (**No, it's not!**).
	 * In case of an Object, the method loops over all properties of the object.
	 *
	 * @param object - An Object or Array to be iterated over.
	 * @param callback - Array.forEach-like callback.
	 */


	function forEach$3(object, callback) {
	  if (isArray$5(object)) {
	    // array
	    var len = object.length;

	    for (var i = 0; i < len; i++) {
	      callback(object[i], i, object);
	    }
	  } else {
	    // object
	    for (var key in object) {
	      if (Object.prototype.hasOwnProperty.call(object, key)) {
	        callback(object[key], key, object);
	      }
	    }
	  }
	}
	/**
	 * Convert an object into an array: all objects properties are put into the array. The resulting array is unordered.
	 *
	 * @param o - Object that contains the properties and methods.
	 *
	 * @returns An array of unordered values.
	 */


	var toArray = values$2;
	/**
	 * Update a property in an object.
	 *
	 * @param object - The object whose property will be updated.
	 * @param key - Name of the property to be updated.
	 * @param value - The new value to be assigned.
	 *
	 * @returns Whether the value was updated (true) or already strictly the same in the original object (false).
	 */

	function updateProperty(object, key, value) {
	  if (object[key] !== value) {
	    object[key] = value;
	    return true;
	  } else {
	    return false;
	  }
	}
	/**
	 * Throttle the given function to be only executed once per animation frame.
	 *
	 * @param fn - The original function.
	 *
	 * @returns The throttled function.
	 */


	function throttle(fn) {
	  var scheduled = false;
	  return function () {
	    if (!scheduled) {
	      scheduled = true;
	      requestAnimationFrame(function () {
	        scheduled = false;
	        fn();
	      });
	    }
	  };
	}
	/**
	 * Add and event listener. Works for all browsers.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.addEventListener(action, —, —).
	 * @param listener - Same as Element.addEventListener(—, listener, —).
	 * @param useCapture - Same as Element.addEventListener(—, —, useCapture).
	 */


	function addEventListener(element, action, listener, useCapture) {
	  if (element.addEventListener) {
	    var _context3;

	    if (useCapture === undefined) {
	      useCapture = false;
	    }

	    if (action === "mousewheel" && indexOf$3(_context3 = navigator.userAgent).call(_context3, "Firefox") >= 0) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.addEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.attachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Remove an event listener from an element.
	 *
	 * @param element - The element to bind the event listener to.
	 * @param action - Same as Element.removeEventListener(action, —, —).
	 * @param listener - Same as Element.removeEventListener(—, listener, —).
	 * @param useCapture - Same as Element.removeEventListener(—, —, useCapture).
	 */


	function removeEventListener(element, action, listener, useCapture) {
	  if (element.removeEventListener) {
	    var _context4;

	    // non-IE browsers
	    if (useCapture === undefined) {
	      useCapture = false;
	    }

	    if (action === "mousewheel" && indexOf$3(_context4 = navigator.userAgent).call(_context4, "Firefox") >= 0) {
	      action = "DOMMouseScroll"; // For Firefox
	    }

	    element.removeEventListener(action, listener, useCapture);
	  } else {
	    // @TODO: IE types? Does anyone care?
	    element.detachEvent("on" + action, listener); // IE browsers
	  }
	}
	/**
	 * Cancels the event's default action if it is cancelable, without stopping further propagation of the event.
	 *
	 * @param event - The event whose default action should be prevented.
	 */


	function preventDefault(event) {
	  if (!event) {
	    event = window.event;
	  }

	  if (!event) ;else if (event.preventDefault) {
	    event.preventDefault(); // non-IE browsers
	  } else {
	    // @TODO: IE types? Does anyone care?
	    event.returnValue = false; // IE browsers
	  }
	}
	/**
	 * Get HTML element which is the target of the event.
	 *
	 * @param event - The event.
	 *
	 * @returns The element or null if not obtainable.
	 */


	function getTarget() {
	  var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.event;
	  // code from http://www.quirksmode.org/js/events_properties.html
	  // @TODO: EventTarget can be almost anything, is it okay to return only Elements?
	  var target = null;
	  if (!event) ;else if (event.target) {
	    target = event.target;
	  } else if (event.srcElement) {
	    target = event.srcElement;
	  }

	  if (!(target instanceof Element)) {
	    return null;
	  }

	  if (target.nodeType != null && target.nodeType == 3) {
	    // defeat Safari bug
	    target = target.parentNode;

	    if (!(target instanceof Element)) {
	      return null;
	    }
	  }

	  return target;
	}
	/**
	 * Check if given element contains given parent somewhere in the DOM tree.
	 *
	 * @param element - The element to be tested.
	 * @param parent - The ancestor (not necessarily parent) of the element.
	 *
	 * @returns True if parent is an ancestor of the element, false otherwise.
	 */


	function hasParent(element, parent) {
	  var elem = element;

	  while (elem) {
	    if (elem === parent) {
	      return true;
	    } else if (elem.parentNode) {
	      elem = elem.parentNode;
	    } else {
	      return false;
	    }
	  }

	  return false;
	}

	var option = {
	  /**
	   * Convert a value into a boolean.
	   *
	   * @param value - Value to be converted intoboolean, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   *
	   * @returns Corresponding boolean value, if none then the default value, if none then null.
	   */
	  asBoolean: function asBoolean(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (value != null) {
	      return value != false;
	    }

	    return defaultValue || null;
	  },

	  /**
	   * Convert a value into a number.
	   *
	   * @param value - Value to be converted intonumber, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   *
	   * @returns Corresponding **boxed** number value, if none then the default value, if none then null.
	   */
	  asNumber: function asNumber(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (value != null) {
	      return Number(value) || defaultValue || null;
	    }

	    return defaultValue || null;
	  },

	  /**
	   * Convert a value into a string.
	   *
	   * @param value - Value to be converted intostring, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   *
	   * @returns Corresponding **boxed** string value, if none then the default value, if none then null.
	   */
	  asString: function asString(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (value != null) {
	      return String(value);
	    }

	    return defaultValue || null;
	  },

	  /**
	   * Convert a value into a size.
	   *
	   * @param value - Value to be converted intosize, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   *
	   * @returns Corresponding string value (number + 'px'), if none then the default value, if none then null.
	   */
	  asSize: function asSize(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    if (isString(value)) {
	      return value;
	    } else if (isNumber(value)) {
	      return value + "px";
	    } else {
	      return defaultValue || null;
	    }
	  },

	  /**
	   * Convert a value into a DOM Element.
	   *
	   * @param value - Value to be converted into DOM Element, a function will be executed as `(() => unknown)`.
	   * @param defaultValue - If the value or the return value of the function == null then this will be returned.
	   *
	   * @returns The DOM Element, if none then the default value, if none then null.
	   */
	  asElement: function asElement(value, defaultValue) {
	    if (typeof value == "function") {
	      value = value();
	    }

	    return value || defaultValue || null;
	  }
	};
	/**
	 * Convert hex color string into RGB color object.
	 *
	 * @remarks
	 * {@link http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb}
	 *
	 * @param hex - Hex color string (3 or 6 digits, with or without #).
	 *
	 * @returns RGB color object.
	 */

	function hexToRGB(hex) {
	  var result;

	  switch (hex.length) {
	    case 3:
	    case 4:
	      result = shortHexRE.exec(hex);
	      return result ? {
	        r: _parseInt$2(result[1] + result[1], 16),
	        g: _parseInt$2(result[2] + result[2], 16),
	        b: _parseInt$2(result[3] + result[3], 16)
	      } : null;

	    case 6:
	    case 7:
	      result = fullHexRE.exec(hex);
	      return result ? {
	        r: _parseInt$2(result[1], 16),
	        g: _parseInt$2(result[2], 16),
	        b: _parseInt$2(result[3], 16)
	      } : null;

	    default:
	      return null;
	  }
	}
	/**
	 * This function takes string color in hex or RGB format and adds the opacity, RGBA is passed through unchanged.
	 *
	 * @param color - The color string (hex, RGB, RGBA).
	 * @param opacity - The new opacity.
	 *
	 * @returns RGBA string, for example 'rgba(255, 0, 127, 0.3)'.
	 */


	function overrideOpacity(color, opacity) {
	  if (indexOf$3(color).call(color, "rgba") !== -1) {
	    return color;
	  } else if (indexOf$3(color).call(color, "rgb") !== -1) {
	    var rgb = color.substr(indexOf$3(color).call(color, "(") + 1).replace(")", "").split(",");
	    return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
	  } else {
	    var _rgb = hexToRGB(color);

	    if (_rgb == null) {
	      return color;
	    } else {
	      return "rgba(" + _rgb.r + "," + _rgb.g + "," + _rgb.b + "," + opacity + ")";
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into hex color string.
	 *
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 *
	 * @returns Hex color string (for example: '#0acdc0').
	 */


	function RGBToHex(red, green, blue) {
	  var _context5;

	  return "#" + slice$5(_context5 = ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16)).call(_context5, 1);
	}
	/**
	 * Parse a color property into an object with border, background, and highlight colors.
	 *
	 * @param inputColor - Shorthand color string or input color object.
	 * @param defaultColor - Full color object to fill in missing values in inputColor.
	 *
	 * @returns Color object.
	 */


	function parseColor(inputColor, defaultColor) {
	  if (isString(inputColor)) {
	    var colorStr = inputColor;

	    if (isValidRGB(colorStr)) {
	      var _context6;

	      var rgb = map$2(_context6 = colorStr.substr(4).substr(0, colorStr.length - 5).split(",")).call(_context6, function (value) {
	        return _parseInt$2(value);
	      });

	      colorStr = RGBToHex(rgb[0], rgb[1], rgb[2]);
	    }

	    if (isValidHex(colorStr) === true) {
	      var hsv = hexToHSV(colorStr);
	      var lighterColorHSV = {
	        h: hsv.h,
	        s: hsv.s * 0.8,
	        v: Math.min(1, hsv.v * 1.02)
	      };
	      var darkerColorHSV = {
	        h: hsv.h,
	        s: Math.min(1, hsv.s * 1.25),
	        v: hsv.v * 0.8
	      };
	      var darkerColorHex = HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
	      var lighterColorHex = HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
	      return {
	        background: colorStr,
	        border: darkerColorHex,
	        highlight: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        },
	        hover: {
	          background: lighterColorHex,
	          border: darkerColorHex
	        }
	      };
	    } else {
	      return {
	        background: colorStr,
	        border: colorStr,
	        highlight: {
	          background: colorStr,
	          border: colorStr
	        },
	        hover: {
	          background: colorStr,
	          border: colorStr
	        }
	      };
	    }
	  } else {
	    if (defaultColor) {
	      var color = {
	        background: inputColor.background || defaultColor.background,
	        border: inputColor.border || defaultColor.border,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || defaultColor.highlight.background,
	          border: inputColor.highlight && inputColor.highlight.border || defaultColor.highlight.border
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || defaultColor.hover.border,
	          background: inputColor.hover && inputColor.hover.background || defaultColor.hover.background
	        }
	      };
	      return color;
	    } else {
	      var _color = {
	        background: inputColor.background || undefined,
	        border: inputColor.border || undefined,
	        highlight: isString(inputColor.highlight) ? {
	          border: inputColor.highlight,
	          background: inputColor.highlight
	        } : {
	          background: inputColor.highlight && inputColor.highlight.background || undefined,
	          border: inputColor.highlight && inputColor.highlight.border || undefined
	        },
	        hover: isString(inputColor.hover) ? {
	          border: inputColor.hover,
	          background: inputColor.hover
	        } : {
	          border: inputColor.hover && inputColor.hover.border || undefined,
	          background: inputColor.hover && inputColor.hover.background || undefined
	        }
	      };
	      return _color;
	    }
	  }
	}
	/**
	 * Convert RGB \<0, 255\> into HSV object.
	 *
	 * @remarks
	 * {@link http://www.javascripter.net/faq/rgb2hsv.htm}
	 *
	 * @param red - Red channel.
	 * @param green - Green channel.
	 * @param blue - Blue channel.
	 *
	 * @returns HSV color object.
	 */


	function RGBToHSV(red, green, blue) {
	  red = red / 255;
	  green = green / 255;
	  blue = blue / 255;
	  var minRGB = Math.min(red, Math.min(green, blue));
	  var maxRGB = Math.max(red, Math.max(green, blue)); // Black-gray-white

	  if (minRGB === maxRGB) {
	    return {
	      h: 0,
	      s: 0,
	      v: minRGB
	    };
	  } // Colors other than black-gray-white:


	  var d = red === minRGB ? green - blue : blue === minRGB ? red - green : blue - red;
	  var h = red === minRGB ? 3 : blue === minRGB ? 1 : 5;
	  var hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
	  var saturation = (maxRGB - minRGB) / maxRGB;
	  var value = maxRGB;
	  return {
	    h: hue,
	    s: saturation,
	    v: value
	  };
	}

	var cssUtil = {
	  // split a string with css styles into an object with key/values
	  split: function split(cssText) {
	    var _context7;

	    var styles = {};

	    forEach$2(_context7 = cssText.split(";")).call(_context7, function (style) {
	      if (trim$2(style).call(style) != "") {
	        var _context8, _context9;

	        var parts = style.split(":");

	        var key = trim$2(_context8 = parts[0]).call(_context8);

	        var value = trim$2(_context9 = parts[1]).call(_context9);

	        styles[key] = value;
	      }
	    });

	    return styles;
	  },
	  // build a css text string from an object with key/values
	  join: function join(styles) {
	    var _context10;

	    return map$2(_context10 = keys$3(styles)).call(_context10, function (key) {
	      return key + ": " + styles[key];
	    }).join("; ");
	  }
	};
	/**
	 * Append a string with css styles to an element.
	 *
	 * @param element - The element that will receive new styles.
	 * @param cssText - The styles to be appended.
	 */

	function addCssText(element, cssText) {
	  var currentStyles = cssUtil.split(element.style.cssText);
	  var newStyles = cssUtil.split(cssText);

	  var styles = _objectSpread(_objectSpread({}, currentStyles), newStyles);

	  element.style.cssText = cssUtil.join(styles);
	}
	/**
	 * Remove a string with css styles from an element.
	 *
	 * @param element - The element from which styles should be removed.
	 * @param cssText - The styles to be removed.
	 */


	function removeCssText(element, cssText) {
	  var styles = cssUtil.split(element.style.cssText);
	  var removeStyles = cssUtil.split(cssText);

	  for (var key in removeStyles) {
	    if (Object.prototype.hasOwnProperty.call(removeStyles, key)) {
	      delete styles[key];
	    }
	  }

	  element.style.cssText = cssUtil.join(styles);
	}
	/**
	 * Convert HSV \<0, 1\> into RGB color object.
	 *
	 * @remarks
	 * {@link https://gist.github.com/mjijackson/5311256}
	 *
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 *
	 * @returns RGB color object.
	 */


	function HSVToRGB(h, s, v) {
	  var r;
	  var g;
	  var b;
	  var i = Math.floor(h * 6);
	  var f = h * 6 - i;
	  var p = v * (1 - s);
	  var q = v * (1 - f * s);
	  var t = v * (1 - (1 - f) * s);

	  switch (i % 6) {
	    case 0:
	      r = v, g = t, b = p;
	      break;

	    case 1:
	      r = q, g = v, b = p;
	      break;

	    case 2:
	      r = p, g = v, b = t;
	      break;

	    case 3:
	      r = p, g = q, b = v;
	      break;

	    case 4:
	      r = t, g = p, b = v;
	      break;

	    case 5:
	      r = v, g = p, b = q;
	      break;
	  }

	  return {
	    r: Math.floor(r * 255),
	    g: Math.floor(g * 255),
	    b: Math.floor(b * 255)
	  };
	}
	/**
	 * Convert HSV \<0, 1\> into hex color string.
	 *
	 * @param h - Hue.
	 * @param s - Saturation.
	 * @param v - Value.
	 *
	 * @returns Hex color string.
	 */


	function HSVToHex(h, s, v) {
	  var rgb = HSVToRGB(h, s, v);
	  return RGBToHex(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Convert hex color string into HSV \<0, 1\>.
	 *
	 * @param hex - Hex color string.
	 *
	 * @returns HSV color object.
	 */


	function hexToHSV(hex) {
	  var rgb = hexToRGB(hex);

	  if (!rgb) {
	    throw new TypeError("'".concat(hex, "' is not a valid color."));
	  }

	  return RGBToHSV(rgb.r, rgb.g, rgb.b);
	}
	/**
	 * Validate hex color string.
	 *
	 * @param hex - Unknown string that may contain a color.
	 *
	 * @returns True if the string is valid, false otherwise.
	 */


	function isValidHex(hex) {
	  var isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
	  return isOk;
	}
	/**
	 * Validate RGB color string.
	 *
	 * @param rgb - Unknown string that may contain a color.
	 *
	 * @returns True if the string is valid, false otherwise.
	 */


	function isValidRGB(rgb) {
	  return rgbRE.test(rgb);
	}
	/**
	 * Validate RGBA color string.
	 *
	 * @param rgba - Unknown string that may contain a color.
	 *
	 * @returns True if the string is valid, false otherwise.
	 */


	function isValidRGBA(rgba) {
	  return rgbaRE.test(rgba);
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param fields - Names of properties to be bridged.
	 * @param referenceObject - The original object.
	 *
	 * @returns A new object inheriting from the referenceObject.
	 */


	function selectiveBridgeObject(fields, referenceObject) {
	  if (referenceObject !== null && _typeof_1(referenceObject) === "object") {
	    // !!! typeof null === 'object'
	    var objectTo = create$2(referenceObject);

	    for (var i = 0; i < fields.length; i++) {
	      if (Object.prototype.hasOwnProperty.call(referenceObject, fields[i])) {
	        if (_typeof_1(referenceObject[fields[i]]) == "object") {
	          objectTo[fields[i]] = bridgeObject(referenceObject[fields[i]]);
	        }
	      }
	    }

	    return objectTo;
	  } else {
	    return null;
	  }
	}
	/**
	 * This recursively redirects the prototype of JSON objects to the referenceObject.
	 * This is used for default options.
	 *
	 * @param referenceObject - The original object.
	 *
	 * @returns The Element if the referenceObject is an Element, or a new object inheriting from the referenceObject.
	 */


	function bridgeObject(referenceObject) {
	  if (referenceObject === null || _typeof_1(referenceObject) !== "object") {
	    return null;
	  }

	  if (referenceObject instanceof Element) {
	    // Avoid bridging DOM objects
	    return referenceObject;
	  }

	  var objectTo = create$2(referenceObject);

	  for (var i in referenceObject) {
	    if (Object.prototype.hasOwnProperty.call(referenceObject, i)) {
	      if (_typeof_1(referenceObject[i]) == "object") {
	        objectTo[i] = bridgeObject(referenceObject[i]);
	      }
	    }
	  }

	  return objectTo;
	}
	/**
	 * This method provides a stable sort implementation, very fast for presorted data.
	 *
	 * @param a - The array to be sorted (in-place).
	 * @param compare - An order comparator.
	 *
	 * @returns The argument a.
	 */


	function insertSort(a, compare) {
	  for (var i = 0; i < a.length; i++) {
	    var k = a[i];
	    var j = void 0;

	    for (j = i; j > 0 && compare(k, a[j - 1]) < 0; j--) {
	      a[j] = a[j - 1];
	    }

	    a[j] = k;
	  }

	  return a;
	}
	/**
	 * This is used to set the options of subobjects in the options object.
	 *
	 * A requirement of these subobjects is that they have an 'enabled' element
	 * which is optional for the user but mandatory for the program.
	 *
	 * The added value here of the merge is that option 'enabled' is set as required.
	 *
	 * @param mergeTarget - Either this.options or the options used for the groups.
	 * @param options - Options.
	 * @param option - Option key in the options argument.
	 * @param globalOptions - Global options, passed in to determine value of option 'enabled'.
	 */


	function mergeOptions(mergeTarget, options, option) {
	  var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

	  // Local helpers
	  var isPresent = function isPresent(obj) {
	    return obj !== null && obj !== undefined;
	  };

	  var isObject = function isObject(obj) {
	    return obj !== null && _typeof_1(obj) === "object";
	  }; // https://stackoverflow.com/a/34491287/1223531


	  var isEmpty = function isEmpty(obj) {
	    for (var x in obj) {
	      if (Object.prototype.hasOwnProperty.call(obj, x)) {
	        return false;
	      }
	    }

	    return true;
	  }; // Guards


	  if (!isObject(mergeTarget)) {
	    throw new Error("Parameter mergeTarget must be an object");
	  }

	  if (!isObject(options)) {
	    throw new Error("Parameter options must be an object");
	  }

	  if (!isPresent(option)) {
	    throw new Error("Parameter option must have a value");
	  }

	  if (!isObject(globalOptions)) {
	    throw new Error("Parameter globalOptions must be an object");
	  } //
	  // Actual merge routine, separated from main logic
	  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
	  //


	  var doMerge = function doMerge(target, options, option) {
	    if (!isObject(target[option])) {
	      target[option] = {};
	    }

	    var src = options[option];
	    var dst = target[option];

	    for (var prop in src) {
	      if (Object.prototype.hasOwnProperty.call(src, prop)) {
	        dst[prop] = src[prop];
	      }
	    }
	  }; // Local initialization


	  var srcOption = options[option];
	  var globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
	  var globalOption = globalPassed ? globalOptions[option] : undefined;
	  var globalEnabled = globalOption ? globalOption.enabled : undefined; /////////////////////////////////////////
	  // Main routine
	  /////////////////////////////////////////

	  if (srcOption === undefined) {
	    return; // Nothing to do
	  }

	  if (typeof srcOption === "boolean") {
	    if (!isObject(mergeTarget[option])) {
	      mergeTarget[option] = {};
	    }

	    mergeTarget[option].enabled = srcOption;
	    return;
	  }

	  if (srcOption === null && !isObject(mergeTarget[option])) {
	    // If possible, explicit copy from globals
	    if (isPresent(globalOption)) {
	      mergeTarget[option] = create$2(globalOption);
	    } else {
	      return; // Nothing to do
	    }
	  }

	  if (!isObject(srcOption)) {
	    return;
	  } //
	  // Ensure that 'enabled' is properly set. It is required internally
	  // Note that the value from options will always overwrite the existing value
	  //


	  var enabled = true; // default value

	  if (srcOption.enabled !== undefined) {
	    enabled = srcOption.enabled;
	  } else {
	    // Take from globals, if present
	    if (globalEnabled !== undefined) {
	      enabled = globalOption.enabled;
	    }
	  }

	  doMerge(mergeTarget, options, option);
	  mergeTarget[option].enabled = enabled;
	}
	/**
	 * This function does a binary search for a visible item in a sorted list. If we find a visible item, the code that uses
	 * this function will then iterate in both directions over this sorted list to find all visible items.
	 *
	 * @param orderedItems - Items ordered by start.
	 * @param comparator - -1 is lower, 0 is equal, 1 is higher.
	 * @param field - Property name on an item (That is item[field]).
	 * @param field2 - Second property name on an item (That is item[field][field2]).
	 *
	 * @returns Index of the found item or -1 if nothing was found.
	 */


	function binarySearchCustom(orderedItems, comparator, field, field2) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;

	  while (low <= high && iteration < maxIterations) {
	    var middle = Math.floor((low + high) / 2);
	    var item = orderedItems[middle];
	    var value = field2 === undefined ? item[field] : item[field][field2];
	    var searchResult = comparator(value);

	    if (searchResult == 0) {
	      // jihaa, found a visible item!
	      return middle;
	    } else if (searchResult == -1) {
	      // it is too small --> increase low
	      low = middle + 1;
	    } else {
	      // it is too big --> decrease high
	      high = middle - 1;
	    }

	    iteration++;
	  }

	  return -1;
	}
	/**
	 * This function does a binary search for a specific value in a sorted array.
	 * If it does not exist but is in between of two values, we return either the
	 * one before or the one after, depending on user input If it is found, we
	 * return the index, else -1.
	 *
	 * @param orderedItems - Sorted array.
	 * @param target - The searched value.
	 * @param field - Name of the property in items to be searched.
	 * @param sidePreference - If the target is between two values, should the index of the before or the after be returned?
	 * @param comparator - An optional comparator, returning -1, 0, 1 for \<, ===, \>.
	 *
	 * @returns The index of found value or -1 if nothing was found.
	 */


	function binarySearchValue(orderedItems, target, field, sidePreference, comparator) {
	  var maxIterations = 10000;
	  var iteration = 0;
	  var low = 0;
	  var high = orderedItems.length - 1;
	  var prevValue;
	  var value;
	  var nextValue;
	  var middle;
	  comparator = comparator != undefined ? comparator : function (a, b) {
	    return a == b ? 0 : a < b ? -1 : 1;
	  };

	  while (low <= high && iteration < maxIterations) {
	    // get a new guess
	    middle = Math.floor(0.5 * (high + low));
	    prevValue = orderedItems[Math.max(0, middle - 1)][field];
	    value = orderedItems[middle][field];
	    nextValue = orderedItems[Math.min(orderedItems.length - 1, middle + 1)][field];

	    if (comparator(value, target) == 0) {
	      // we found the target
	      return middle;
	    } else if (comparator(prevValue, target) < 0 && comparator(value, target) > 0) {
	      // target is in between of the previous and the current
	      return sidePreference == "before" ? Math.max(0, middle - 1) : middle;
	    } else if (comparator(value, target) < 0 && comparator(nextValue, target) > 0) {
	      // target is in between of the current and the next
	      return sidePreference == "before" ? middle : Math.min(orderedItems.length - 1, middle + 1);
	    } else {
	      // didnt find the target, we need to change our boundaries.
	      if (comparator(value, target) < 0) {
	        // it is too small --> increase low
	        low = middle + 1;
	      } else {
	        // it is too big --> decrease high
	        high = middle - 1;
	      }
	    }

	    iteration++;
	  } // didnt find anything. Return -1.


	  return -1;
	}
	/*
	 * Easing Functions.
	 * Only considering the t value for the range [0, 1] => [0, 1].
	 *
	 * Inspiration: from http://gizma.com/easing/
	 * https://gist.github.com/gre/1650294
	 */


	var easingFunctions = {
	  /**
	   * Provides no easing and no acceleration.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  linear: function linear(t) {
	    return t;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInQuad: function easeInQuad(t) {
	    return t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeOutQuad: function easeOutQuad(t) {
	    return t * (2 - t);
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInOutQuad: function easeInOutQuad(t) {
	    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInCubic: function easeInCubic(t) {
	    return t * t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeOutCubic: function easeOutCubic(t) {
	    return --t * t * t + 1;
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInOutCubic: function easeInOutCubic(t) {
	    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInQuart: function easeInQuart(t) {
	    return t * t * t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeOutQuart: function easeOutQuart(t) {
	    return 1 - --t * t * t * t;
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInOutQuart: function easeInOutQuart(t) {
	    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
	  },

	  /**
	   * Accelerate from zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInQuint: function easeInQuint(t) {
	    return t * t * t * t * t;
	  },

	  /**
	   * Decelerate to zero velocity.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeOutQuint: function easeOutQuint(t) {
	    return 1 + --t * t * t * t * t;
	  },

	  /**
	   * Accelerate until halfway, then decelerate.
	   *
	   * @param t - Time.
	   *
	   * @returns Value at time t.
	   */
	  easeInOutQuint: function easeInOutQuint(t) {
	    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
	  }
	};
	/**
	 * Experimentaly compute the width of the scrollbar for this browser.
	 *
	 * @returns The width in pixels.
	 */

	function getScrollBarWidth() {
	  var inner = document.createElement("p");
	  inner.style.width = "100%";
	  inner.style.height = "200px";
	  var outer = document.createElement("div");
	  outer.style.position = "absolute";
	  outer.style.top = "0px";
	  outer.style.left = "0px";
	  outer.style.visibility = "hidden";
	  outer.style.width = "200px";
	  outer.style.height = "150px";
	  outer.style.overflow = "hidden";
	  outer.appendChild(inner);
	  document.body.appendChild(outer);
	  var w1 = inner.offsetWidth;
	  outer.style.overflow = "scroll";
	  var w2 = inner.offsetWidth;

	  if (w1 == w2) {
	    w2 = outer.clientWidth;
	  }

	  document.body.removeChild(outer);
	  return w1 - w2;
	} // @TODO: This doesn't work properly.
	// It works only for single property objects,
	// otherwise it combines all of the types in a union.
	// export function topMost<K1 extends string, V1> (
	//   pile: Record<K1, undefined | V1>[],
	//   accessors: K1 | [K1]
	// ): undefined | V1
	// export function topMost<K1 extends string, K2 extends string, V1, V2> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2>>[],
	//   accessors: [K1, K2]
	// ): undefined | V1 | V2
	// export function topMost<K1 extends string, K2 extends string, K3 extends string, V1, V2, V3> (
	//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2 | Record<K3, undefined | V3>>>[],
	//   accessors: [K1, K2, K3]
	// ): undefined | V1 | V2 | V3

	/**
	 * Get the top most property value from a pile of objects.
	 *
	 * @param pile - Array of objects, no required format.
	 * @param accessors - Array of property names.
	 * For example `object['foo']['bar']` → `['foo', 'bar']`.
	 *
	 * @returns Value of the property with given accessors path from the first pile item where it's not undefined.
	 */


	function topMost(pile, accessors) {
	  var candidate;

	  if (!isArray$5(accessors)) {
	    accessors = [accessors];
	  }

	  var _iterator = _createForOfIteratorHelper(pile),
	      _step;

	  try {
	    for (_iterator.s(); !(_step = _iterator.n()).done;) {
	      var member = _step.value;

	      if (member) {
	        candidate = member[accessors[0]];

	        for (var i = 1; i < accessors.length; i++) {
	          if (candidate) {
	            candidate = candidate[accessors[i]];
	          }
	        }

	        if (typeof candidate !== "undefined") {
	          break;
	        }
	      }
	    }
	  } catch (err) {
	    _iterator.e(err);
	  } finally {
	    _iterator.f();
	  }

	  return candidate;
	}

	var index = /*#__PURE__*/Object.freeze({
		__proto__: null,
		Alea: Alea,
		HSVToHex: HSVToHex,
		HSVToRGB: HSVToRGB,
		RGBToHSV: RGBToHSV,
		RGBToHex: RGBToHex,
		addClassName: addClassName,
		addCssText: addCssText,
		addEventListener: addEventListener,
		binarySearchCustom: binarySearchCustom,
		binarySearchValue: binarySearchValue,
		bridgeObject: bridgeObject,
		copyAndExtendArray: copyAndExtendArray,
		copyArray: copyArray,
		deepExtend: deepExtend,
		easingFunctions: easingFunctions,
		equalArray: equalArray,
		extend: extend,
		fillIfDefined: fillIfDefined,
		forEach: forEach$3,
		getAbsoluteLeft: getAbsoluteLeft,
		getAbsoluteRight: getAbsoluteRight,
		getAbsoluteTop: getAbsoluteTop,
		getScrollBarWidth: getScrollBarWidth,
		getTarget: getTarget,
		getType: getType,
		hasParent: hasParent,
		hexToHSV: hexToHSV,
		hexToRGB: hexToRGB,
		insertSort: insertSort,
		isDate: isDate,
		isNumber: isNumber,
		isObject: isObject$1,
		isString: isString,
		isValidHex: isValidHex,
		isValidRGB: isValidRGB,
		isValidRGBA: isValidRGBA,
		mergeOptions: mergeOptions,
		option: option,
		overrideOpacity: overrideOpacity,
		parseColor: parseColor,
		preventDefault: preventDefault,
		recursiveDOMDelete: recursiveDOMDelete,
		removeClassName: removeClassName,
		removeCssText: removeCssText,
		removeEventListener: removeEventListener,
		selectiveBridgeObject: selectiveBridgeObject,
		selectiveDeepExtend: selectiveDeepExtend,
		selectiveExtend: selectiveExtend,
		selectiveNotDeepExtend: selectiveNotDeepExtend,
		throttle: throttle,
		toArray: toArray,
		topMost: topMost,
		updateProperty: updateProperty
	});

	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport('splice');
	var USES_TO_LENGTH$5 = arrayMethodUsesToLength('splice', {
	  ACCESSORS: true,
	  0: 0,
	  1: 2
	});
	var max$2 = Math.max;
	var min$2 = Math.min;
	var MAX_SAFE_INTEGER$1 = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded'; // `Array.prototype.splice` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.splice
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$3 || !USES_TO_LENGTH$5
	}, {
	  splice: function splice(start, deleteCount
	  /* , ...items */
	  ) {
	    var O = toObject(this);
	    var len = toLength(O.length);
	    var actualStart = toAbsoluteIndex(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;

	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min$2(max$2(toInteger(deleteCount), 0), len - actualStart);
	    }

	    if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER$1) {
	      throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
	    }

	    A = arraySpeciesCreate(O, actualDeleteCount);

	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty(A, k, O[from]);
	    }

	    A.length = actualDeleteCount;

	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }

	      for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }
	    }

	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }

	    O.length = len - actualDeleteCount + insertCount;
	    return A;
	  }
	});

	var splice = entryVirtual('Array').splice;

	var ArrayPrototype$7 = Array.prototype;

	var splice_1 = function (it) {
	  var own = it.splice;
	  return it === ArrayPrototype$7 || it instanceof Array && own === ArrayPrototype$7.splice ? splice : own;
	};

	var splice$1 = splice_1;

	var splice$2 = splice$1;

	var $includes = arrayIncludes.includes;
	var USES_TO_LENGTH$6 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	}); // `Array.prototype.includes` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.includes

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !USES_TO_LENGTH$6
	}, {
	  includes: function includes(el
	  /* , fromIndex = 0 */
	  ) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	var includes = entryVirtual('Array').includes;

	var MATCH = wellKnownSymbol('match'); // `IsRegExp` abstract operation
	// https://tc39.github.io/ecma262/#sec-isregexp

	var isRegexp = function (it) {
	  var isRegExp;
	  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classofRaw(it) == 'RegExp');
	};

	var notARegexp = function (it) {
	  if (isRegexp(it)) {
	    throw TypeError("The method doesn't accept regular expressions");
	  }

	  return it;
	};

	var MATCH$1 = wellKnownSymbol('match');

	var correctIsRegexpLogic = function (METHOD_NAME) {
	  var regexp = /./;

	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (e) {
	    try {
	      regexp[MATCH$1] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (f) {
	      /* empty */
	    }
	  }

	  return false;
	};

	// https://tc39.github.io/ecma262/#sec-string.prototype.includes


	_export({
	  target: 'String',
	  proto: true,
	  forced: !correctIsRegexpLogic('includes')
	}, {
	  includes: function includes(searchString
	  /* , position = 0 */
	  ) {
	    return !!~String(requireObjectCoercible(this)).indexOf(notARegexp(searchString), arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var includes$1 = entryVirtual('String').includes;

	var ArrayPrototype$8 = Array.prototype;
	var StringPrototype$1 = String.prototype;

	var includes$2 = function (it) {
	  var own = it.includes;
	  if (it === ArrayPrototype$8 || it instanceof Array && own === ArrayPrototype$8.includes) return includes;

	  if (typeof it === 'string' || it === StringPrototype$1 || it instanceof String && own === StringPrototype$1.includes) {
	    return includes$1;
	  }

	  return own;
	};

	var includes$3 = includes$2;

	var includes$4 = includes$3;

	/**
	 * Parse a text source containing data in DOT language into a JSON object.
	 * The object contains two lists: one with nodes and one with edges.
	 *
	 * DOT language reference: http://www.graphviz.org/doc/info/lang.html
	 *
	 * DOT language attributes: http://graphviz.org/content/attrs
	 *
	 * @param {string} data     Text containing a graph in DOT-notation
	 * @return {Object} graph   An object containing two parameters:
	 *                          {Object[]} nodes
	 *                          {Object[]} edges
	 *
	 * -------------------------------------------
	 * TODO
	 * ====
	 *
	 * For label handling, this is an incomplete implementation. From docs (quote #3015):
	 * 
	 * > the escape sequences "\n", "\l" and "\r" divide the label into lines, centered, 
	 * > left-justified, and right-justified, respectively.
	 *
	 * Source: http://www.graphviz.org/content/attrs#kescString
	 *
	 * > As another aid for readability, dot allows double-quoted strings to span multiple physical
	 * > lines using the standard C convention of a backslash immediately preceding a newline
	 * > character
	 * > In addition, double-quoted strings can be concatenated using a '+' operator.
	 * > As HTML strings can contain newline characters, which are used solely for formatting,
	 * > the language does not allow escaped newlines or concatenation operators to be used
	 * > within them.
	 *
	 * - Currently, only '\\n' is handled
	 * - Note that text explicitly says 'labels'; the dot parser currently handles escape
	 *   sequences in **all** strings.
	 */
	function parseDOT(data) {
	  dot = data;
	  return parseGraph();
	} // mapping of attributes from DOT (the keys) to vis.js (the values)


	var NODE_ATTR_MAPPING = {
	  'fontsize': 'font.size',
	  'fontcolor': 'font.color',
	  'labelfontcolor': 'font.color',
	  'fontname': 'font.face',
	  'color': ['color.border', 'color.background'],
	  'fillcolor': 'color.background',
	  'tooltip': 'title',
	  'labeltooltip': 'title'
	};

	var EDGE_ATTR_MAPPING = create$2(NODE_ATTR_MAPPING);

	EDGE_ATTR_MAPPING.color = 'color.color';
	EDGE_ATTR_MAPPING.style = 'dashes'; // token types enumeration

	var TOKENTYPE = {
	  NULL: 0,
	  DELIMITER: 1,
	  IDENTIFIER: 2,
	  UNKNOWN: 3
	}; // map with all delimiters

	var DELIMITERS = {
	  '{': true,
	  '}': true,
	  '[': true,
	  ']': true,
	  ';': true,
	  '=': true,
	  ',': true,
	  '->': true,
	  '--': true
	};
	var dot = ''; // current dot file

	var index$1 = 0; // current index in dot file

	var c = ''; // current token character in expr

	var token = ''; // current token

	var tokenType = TOKENTYPE.NULL; // type of the token

	/**
	 * Get the first character from the dot file.
	 * The character is stored into the char c. If the end of the dot file is
	 * reached, the function puts an empty string in c.
	 */

	function first() {
	  index$1 = 0;
	  c = dot.charAt(0);
	}
	/**
	 * Get the next character from the dot file.
	 * The character is stored into the char c. If the end of the dot file is
	 * reached, the function puts an empty string in c.
	 */


	function next() {
	  index$1++;
	  c = dot.charAt(index$1);
	}
	/**
	 * Preview the next character from the dot file.
	 * @return {string} cNext
	 */


	function nextPreview() {
	  return dot.charAt(index$1 + 1);
	}

	var regexAlphaNumeric = /[a-zA-Z_0-9.:#]/;
	/**
	 * Test whether given character is alphabetic or numeric
	 * @param {string} c
	 * @return {Boolean} isAlphaNumeric
	 */

	function isAlphaNumeric(c) {
	  return regexAlphaNumeric.test(c);
	}
	/**
	 * Merge all options of object b into object b
	 * @param {Object} a
	 * @param {Object} b
	 * @return {Object} a
	 */


	function merge(a, b) {
	  if (!a) {
	    a = {};
	  }

	  if (b) {
	    for (var name in b) {
	      if (b.hasOwnProperty(name)) {
	        a[name] = b[name];
	      }
	    }
	  }

	  return a;
	}
	/**
	 * Set a value in an object, where the provided parameter name can be a
	 * path with nested parameters. For example:
	 *
	 *     var obj = {a: 2};
	 *     setValue(obj, 'b.c', 3);     // obj = {a: 2, b: {c: 3}}
	 *
	 * @param {Object} obj
	 * @param {string} path  A parameter name or dot-separated parameter path,
	 *                      like "color.highlight.border".
	 * @param {*} value
	 */


	function setValue(obj, path, value) {
	  var keys = path.split('.');
	  var o = obj;

	  while (keys.length) {
	    var key = keys.shift();

	    if (keys.length) {
	      // this isn't the end point
	      if (!o[key]) {
	        o[key] = {};
	      }

	      o = o[key];
	    } else {
	      // this is the end point
	      o[key] = value;
	    }
	  }
	}
	/**
	 * Add a node to a graph object. If there is already a node with
	 * the same id, their attributes will be merged.
	 * @param {Object} graph
	 * @param {Object} node
	 */


	function addNode(graph, node) {
	  var i, len;
	  var current = null; // find root graph (in case of subgraph)

	  var graphs = [graph]; // list with all graphs from current graph to root graph

	  var root = graph;

	  while (root.parent) {
	    graphs.push(root.parent);
	    root = root.parent;
	  } // find existing node (at root level) by its id


	  if (root.nodes) {
	    for (i = 0, len = root.nodes.length; i < len; i++) {
	      if (node.id === root.nodes[i].id) {
	        current = root.nodes[i];
	        break;
	      }
	    }
	  }

	  if (!current) {
	    // this is a new node
	    current = {
	      id: node.id
	    };

	    if (graph.node) {
	      // clone default attributes
	      current.attr = merge(current.attr, graph.node);
	    }
	  } // add node to this (sub)graph and all its parent graphs


	  for (i = graphs.length - 1; i >= 0; i--) {
	    var _context;

	    var g = graphs[i];

	    if (!g.nodes) {
	      g.nodes = [];
	    }

	    if (indexOf$3(_context = g.nodes).call(_context, current) === -1) {
	      g.nodes.push(current);
	    }
	  } // merge attributes


	  if (node.attr) {
	    current.attr = merge(current.attr, node.attr);
	  }
	}
	/**
	 * Add an edge to a graph object
	 * @param {Object} graph
	 * @param {Object} edge
	 */


	function addEdge(graph, edge) {
	  if (!graph.edges) {
	    graph.edges = [];
	  }

	  graph.edges.push(edge);

	  if (graph.edge) {
	    var attr = merge({}, graph.edge); // clone default attributes

	    edge.attr = merge(attr, edge.attr); // merge attributes
	  }
	}
	/**
	 * Create an edge to a graph object
	 * @param {Object} graph
	 * @param {string | number | Object} from
	 * @param {string | number | Object} to
	 * @param {string} type
	 * @param {Object | null} attr
	 * @return {Object} edge
	 */


	function createEdge(graph, from, to, type, attr) {
	  var edge = {
	    from: from,
	    to: to,
	    type: type
	  };

	  if (graph.edge) {
	    edge.attr = merge({}, graph.edge); // clone default attributes
	  }

	  edge.attr = merge(edge.attr || {}, attr); // merge attributes
	  // Move arrows attribute from attr to edge temporally created in
	  // parseAttributeList().

	  if (attr != null) {
	    if (attr.hasOwnProperty('arrows') && attr['arrows'] != null) {
	      edge['arrows'] = {
	        to: {
	          enabled: true,
	          type: attr.arrows.type
	        }
	      };
	      attr['arrows'] = null;
	    }
	  }

	  return edge;
	}
	/**
	 * Get next token in the current dot file.
	 * The token and token type are available as token and tokenType
	 */


	function getToken() {
	  tokenType = TOKENTYPE.NULL;
	  token = ''; // skip over whitespaces

	  while (c === ' ' || c === '\t' || c === '\n' || c === '\r') {
	    // space, tab, enter
	    next();
	  }

	  do {
	    var isComment = false; // skip comment

	    if (c === '#') {
	      // find the previous non-space character
	      var i = index$1 - 1;

	      while (dot.charAt(i) === ' ' || dot.charAt(i) === '\t') {
	        i--;
	      }

	      if (dot.charAt(i) === '\n' || dot.charAt(i) === '') {
	        // the # is at the start of a line, this is indeed a line comment
	        while (c != '' && c != '\n') {
	          next();
	        }

	        isComment = true;
	      }
	    }

	    if (c === '/' && nextPreview() === '/') {
	      // skip line comment
	      while (c != '' && c != '\n') {
	        next();
	      }

	      isComment = true;
	    }

	    if (c === '/' && nextPreview() === '*') {
	      // skip block comment
	      while (c != '') {
	        if (c === '*' && nextPreview() === '/') {
	          // end of block comment found. skip these last two characters
	          next();
	          next();
	          break;
	        } else {
	          next();
	        }
	      }

	      isComment = true;
	    } // skip over whitespaces


	    while (c === ' ' || c === '\t' || c === '\n' || c === '\r') {
	      // space, tab, enter
	      next();
	    }
	  } while (isComment); // check for end of dot file


	  if (c === '') {
	    // token is still empty
	    tokenType = TOKENTYPE.DELIMITER;
	    return;
	  } // check for delimiters consisting of 2 characters


	  var c2 = c + nextPreview();

	  if (DELIMITERS[c2]) {
	    tokenType = TOKENTYPE.DELIMITER;
	    token = c2;
	    next();
	    next();
	    return;
	  } // check for delimiters consisting of 1 character


	  if (DELIMITERS[c]) {
	    tokenType = TOKENTYPE.DELIMITER;
	    token = c;
	    next();
	    return;
	  } // check for an identifier (number or string)
	  // TODO: more precise parsing of numbers/strings (and the port separator ':')


	  if (isAlphaNumeric(c) || c === '-') {
	    token += c;
	    next();

	    while (isAlphaNumeric(c)) {
	      token += c;
	      next();
	    }

	    if (token === 'false') {
	      token = false; // convert to boolean
	    } else if (token === 'true') {
	      token = true; // convert to boolean
	    } else if (!isNaN(Number(token))) {
	      token = Number(token); // convert to number
	    }

	    tokenType = TOKENTYPE.IDENTIFIER;
	    return;
	  } // check for a string enclosed by double quotes


	  if (c === '"') {
	    next();

	    while (c != '' && (c != '"' || c === '"' && nextPreview() === '"')) {
	      if (c === '"') {
	        // skip the escape character
	        token += c;
	        next();
	      } else if (c === '\\' && nextPreview() === 'n') {
	        // Honor a newline escape sequence
	        token += '\n';
	        next();
	      } else {
	        token += c;
	      }

	      next();
	    }

	    if (c != '"') {
	      throw newSyntaxError('End of string " expected');
	    }

	    next();
	    tokenType = TOKENTYPE.IDENTIFIER;
	    return;
	  } // something unknown is found, wrong characters, a syntax error


	  tokenType = TOKENTYPE.UNKNOWN;

	  while (c != '') {
	    token += c;
	    next();
	  }

	  throw new SyntaxError('Syntax error in part "' + chop(token, 30) + '"');
	}
	/**
	 * Parse a graph.
	 * @returns {Object} graph
	 */


	function parseGraph() {
	  var graph = {};
	  first();
	  getToken(); // optional strict keyword

	  if (token === 'strict') {
	    graph.strict = true;
	    getToken();
	  } // graph or digraph keyword


	  if (token === 'graph' || token === 'digraph') {
	    graph.type = token;
	    getToken();
	  } // optional graph id


	  if (tokenType === TOKENTYPE.IDENTIFIER) {
	    graph.id = token;
	    getToken();
	  } // open angle bracket


	  if (token != '{') {
	    throw newSyntaxError('Angle bracket { expected');
	  }

	  getToken(); // statements

	  parseStatements(graph); // close angle bracket

	  if (token != '}') {
	    throw newSyntaxError('Angle bracket } expected');
	  }

	  getToken(); // end of file

	  if (token !== '') {
	    throw newSyntaxError('End of file expected');
	  }

	  getToken(); // remove temporary default options

	  delete graph.node;
	  delete graph.edge;
	  delete graph.graph;
	  return graph;
	}
	/**
	 * Parse a list with statements.
	 * @param {Object} graph
	 */


	function parseStatements(graph) {
	  while (token !== '' && token != '}') {
	    parseStatement(graph);

	    if (token === ';') {
	      getToken();
	    }
	  }
	}
	/**
	 * Parse a single statement. Can be a an attribute statement, node
	 * statement, a series of node statements and edge statements, or a
	 * parameter.
	 * @param {Object} graph
	 */


	function parseStatement(graph) {
	  // parse subgraph
	  var subgraph = parseSubgraph(graph);

	  if (subgraph) {
	    // edge statements
	    parseEdge(graph, subgraph);
	    return;
	  } // parse an attribute statement


	  var attr = parseAttributeStatement(graph);

	  if (attr) {
	    return;
	  } // parse node


	  if (tokenType != TOKENTYPE.IDENTIFIER) {
	    throw newSyntaxError('Identifier expected');
	  }

	  var id = token; // id can be a string or a number

	  getToken();

	  if (token === '=') {
	    // id statement
	    getToken();

	    if (tokenType != TOKENTYPE.IDENTIFIER) {
	      throw newSyntaxError('Identifier expected');
	    }

	    graph[id] = token;
	    getToken(); // TODO: implement comma separated list with "a_list: ID=ID [','] [a_list] "
	  } else {
	    parseNodeStatement(graph, id);
	  }
	}
	/**
	 * Parse a subgraph
	 * @param {Object} graph    parent graph object
	 * @return {Object | null} subgraph
	 */


	function parseSubgraph(graph) {
	  var subgraph = null; // optional subgraph keyword

	  if (token === 'subgraph') {
	    subgraph = {};
	    subgraph.type = 'subgraph';
	    getToken(); // optional graph id

	    if (tokenType === TOKENTYPE.IDENTIFIER) {
	      subgraph.id = token;
	      getToken();
	    }
	  } // open angle bracket


	  if (token === '{') {
	    getToken();

	    if (!subgraph) {
	      subgraph = {};
	    }

	    subgraph.parent = graph;
	    subgraph.node = graph.node;
	    subgraph.edge = graph.edge;
	    subgraph.graph = graph.graph; // statements

	    parseStatements(subgraph); // close angle bracket

	    if (token != '}') {
	      throw newSyntaxError('Angle bracket } expected');
	    }

	    getToken(); // remove temporary default options

	    delete subgraph.node;
	    delete subgraph.edge;
	    delete subgraph.graph;
	    delete subgraph.parent; // register at the parent graph

	    if (!graph.subgraphs) {
	      graph.subgraphs = [];
	    }

	    graph.subgraphs.push(subgraph);
	  }

	  return subgraph;
	}
	/**
	 * parse an attribute statement like "node [shape=circle fontSize=16]".
	 * Available keywords are 'node', 'edge', 'graph'.
	 * The previous list with default attributes will be replaced
	 * @param {Object} graph
	 * @returns {String | null} keyword Returns the name of the parsed attribute
	 *                                  (node, edge, graph), or null if nothing
	 *                                  is parsed.
	 */


	function parseAttributeStatement(graph) {
	  // attribute statements
	  if (token === 'node') {
	    getToken(); // node attributes

	    graph.node = parseAttributeList();
	    return 'node';
	  } else if (token === 'edge') {
	    getToken(); // edge attributes

	    graph.edge = parseAttributeList();
	    return 'edge';
	  } else if (token === 'graph') {
	    getToken(); // graph attributes

	    graph.graph = parseAttributeList();
	    return 'graph';
	  }

	  return null;
	}
	/**
	 * parse a node statement
	 * @param {Object} graph
	 * @param {string | number} id
	 */


	function parseNodeStatement(graph, id) {
	  // node statement
	  var node = {
	    id: id
	  };
	  var attr = parseAttributeList();

	  if (attr) {
	    node.attr = attr;
	  }

	  addNode(graph, node); // edge statements

	  parseEdge(graph, id);
	}
	/**
	 * Parse an edge or a series of edges
	 * @param {Object} graph
	 * @param {string | number} from        Id of the from node
	 */


	function parseEdge(graph, from) {
	  while (token === '->' || token === '--') {
	    var to;
	    var type = token;
	    getToken();
	    var subgraph = parseSubgraph(graph);

	    if (subgraph) {
	      to = subgraph;
	    } else {
	      if (tokenType != TOKENTYPE.IDENTIFIER) {
	        throw newSyntaxError('Identifier or subgraph expected');
	      }

	      to = token;
	      addNode(graph, {
	        id: to
	      });
	      getToken();
	    } // parse edge attributes


	    var attr = parseAttributeList(); // create edge

	    var edge = createEdge(graph, from, to, type, attr);
	    addEdge(graph, edge);
	    from = to;
	  }
	}
	/**
	 * Parse a set with attributes,
	 * for example [label="1.000", shape=solid]
	 * @return {Object | null} attr
	 */


	function parseAttributeList() {
	  var i;
	  var attr = null; // edge styles of dot and vis

	  var edgeStyles = {
	    'dashed': true,
	    'solid': false,
	    'dotted': [1, 5]
	  };
	  /**
	   * Define arrow types.
	   * vis currently supports types defined in 'arrowTypes'.
	   * Details of arrow shapes are described in
	   * http://www.graphviz.org/content/arrow-shapes
	   */

	  var arrowTypes = {
	    dot: 'circle',
	    box: 'box',
	    crow: 'crow',
	    curve: 'curve',
	    icurve: 'inv_curve',
	    normal: 'triangle',
	    inv: 'inv_triangle',
	    diamond: 'diamond',
	    tee: 'bar',
	    vee: 'vee'
	  };
	  /**
	   * 'attr_list' contains attributes for checking if some of them are affected
	   * later. For instance, both of 'arrowhead' and 'dir' (edge style defined
	   * in DOT) make changes to 'arrows' attribute in vis.
	   */

	  var attr_list = new Array();
	  var attr_names = new Array(); // used for checking the case.
	  // parse attributes

	  while (token === '[') {
	    getToken();
	    attr = {};

	    while (token !== '' && token != ']') {
	      if (tokenType != TOKENTYPE.IDENTIFIER) {
	        throw newSyntaxError('Attribute name expected');
	      }

	      var name = token;
	      getToken();

	      if (token != '=') {
	        throw newSyntaxError('Equal sign = expected');
	      }

	      getToken();

	      if (tokenType != TOKENTYPE.IDENTIFIER) {
	        throw newSyntaxError('Attribute value expected');
	      }

	      var value = token; // convert from dot style to vis

	      if (name === 'style') {
	        value = edgeStyles[value];
	      }

	      var arrowType;

	      if (name === 'arrowhead') {
	        arrowType = arrowTypes[value];
	        name = 'arrows';
	        value = {
	          'to': {
	            'enabled': true,
	            'type': arrowType
	          }
	        };
	      }

	      if (name === 'arrowtail') {
	        arrowType = arrowTypes[value];
	        name = 'arrows';
	        value = {
	          'from': {
	            'enabled': true,
	            'type': arrowType
	          }
	        };
	      }

	      attr_list.push({
	        'attr': attr,
	        'name': name,
	        'value': value
	      });
	      attr_names.push(name);
	      getToken();

	      if (token == ',') {
	        getToken();
	      }
	    }

	    if (token != ']') {
	      throw newSyntaxError('Bracket ] expected');
	    }

	    getToken();
	  }
	  /**
	   * As explained in [1], graphviz has limitations for combination of
	   * arrow[head|tail] and dir. If attribute list includes 'dir',
	   * following cases just be supported.
	   *   1. both or none + arrowhead, arrowtail
	   *   2. forward + arrowhead (arrowtail is not affedted)
	   *   3. back + arrowtail (arrowhead is not affected)
	   * [1] https://www.graphviz.org/doc/info/attrs.html#h:undir_note
	   */


	  if (includes$4(attr_names).call(attr_names, 'dir')) {
	    var idx = {}; // get index of 'arrows' and 'dir'

	    idx.arrows = {};

	    for (i = 0; i < attr_list.length; i++) {
	      if (attr_list[i].name === 'arrows') {
	        if (attr_list[i].value.to != null) {
	          idx.arrows.to = i;
	        } else if (attr_list[i].value.from != null) {
	          idx.arrows.from = i;
	        } else {
	          throw newSyntaxError('Invalid value of arrows');
	        }
	      } else if (attr_list[i].name === 'dir') {
	        idx.dir = i;
	      }
	    } // first, add default arrow shape if it is not assigned to avoid error


	    var dir_type = attr_list[idx.dir].value;

	    if (!includes$4(attr_names).call(attr_names, 'arrows')) {
	      if (dir_type === 'both') {
	        attr_list.push({
	          'attr': attr_list[idx.dir].attr,
	          'name': 'arrows',
	          'value': {
	            to: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.to = attr_list.length - 1;
	        attr_list.push({
	          'attr': attr_list[idx.dir].attr,
	          'name': 'arrows',
	          'value': {
	            from: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.from = attr_list.length - 1;
	      } else if (dir_type === 'forward') {
	        attr_list.push({
	          'attr': attr_list[idx.dir].attr,
	          'name': 'arrows',
	          'value': {
	            to: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.to = attr_list.length - 1;
	      } else if (dir_type === 'back') {
	        attr_list.push({
	          'attr': attr_list[idx.dir].attr,
	          'name': 'arrows',
	          'value': {
	            from: {
	              enabled: true
	            }
	          }
	        });
	        idx.arrows.from = attr_list.length - 1;
	      } else if (dir_type === 'none') {
	        attr_list.push({
	          'attr': attr_list[idx.dir].attr,
	          'name': 'arrows',
	          'value': ''
	        });
	        idx.arrows.to = attr_list.length - 1;
	      } else {
	        throw newSyntaxError('Invalid dir type "' + dir_type + '"');
	      }
	    }

	    var from_type;
	    var to_type; // update 'arrows' attribute from 'dir'.

	    if (dir_type === 'both') {
	      // both of shapes of 'from' and 'to' are given
	      if (idx.arrows.to && idx.arrows.from) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.to] = {
	          'attr': attr_list[idx.arrows.to].attr,
	          'name': attr_list[idx.arrows.to].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };

	        splice$2(attr_list).call(attr_list, idx.arrows.from, 1); // shape of 'to' is assigned and use default to 'from'

	      } else if (idx.arrows.to) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = 'arrow';
	        attr_list[idx.arrows.to] = {
	          'attr': attr_list[idx.arrows.to].attr,
	          'name': attr_list[idx.arrows.to].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        }; // only shape of 'from' is assigned and use default for 'to'
	      } else if (idx.arrows.from) {
	        to_type = 'arrow';
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.from] = {
	          'attr': attr_list[idx.arrows.from].attr,
	          'name': attr_list[idx.arrows.from].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	      }
	    } else if (dir_type === 'back') {
	      // given both of shapes, but use only 'from'
	      if (idx.arrows.to && idx.arrows.from) {
	        to_type = '';
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.from] = {
	          'attr': attr_list[idx.arrows.from].attr,
	          'name': attr_list[idx.arrows.from].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        }; // given shape of 'to', but does not use it
	      } else if (idx.arrows.to) {
	        to_type = '';
	        from_type = 'arrow';
	        idx.arrows.from = idx.arrows.to;
	        attr_list[idx.arrows.from] = {
	          'attr': attr_list[idx.arrows.from].attr,
	          'name': attr_list[idx.arrows.from].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        }; // assign given 'from' shape
	      } else if (idx.arrows.from) {
	        to_type = '';
	        from_type = attr_list[idx.arrows.from].value.from.type;
	        attr_list[idx.arrows.to] = {
	          'attr': attr_list[idx.arrows.from].attr,
	          'name': attr_list[idx.arrows.from].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	      }

	      attr_list[idx.arrows.from] = {
	        'attr': attr_list[idx.arrows.from].attr,
	        'name': attr_list[idx.arrows.from].name,
	        'value': {
	          from: {
	            enabled: true,
	            type: attr_list[idx.arrows.from].value.from.type
	          }
	        }
	      };
	    } else if (dir_type === 'none') {
	      var idx_arrow;

	      if (idx.arrows.to) {
	        idx_arrow = idx.arrows.to;
	      } else {
	        idx_arrow = idx.arrows.from;
	      }

	      attr_list[idx_arrow] = {
	        'attr': attr_list[idx_arrow].attr,
	        'name': attr_list[idx_arrow].name,
	        'value': ''
	      };
	    } else if (dir_type === 'forward') {
	      // given both of shapes, but use only 'to'
	      if (idx.arrows.to && idx.arrows.from) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = '';
	        attr_list[idx.arrows.to] = {
	          'attr': attr_list[idx.arrows.to].attr,
	          'name': attr_list[idx.arrows.to].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        }; // assign given 'to' shape
	      } else if (idx.arrows.to) {
	        to_type = attr_list[idx.arrows.to].value.to.type;
	        from_type = '';
	        attr_list[idx.arrows.to] = {
	          'attr': attr_list[idx.arrows.to].attr,
	          'name': attr_list[idx.arrows.to].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        }; // given shape of 'from', but does not use it
	      } else if (idx.arrows.from) {
	        to_type = 'arrow';
	        from_type = '';
	        idx.arrows.to = idx.arrows.from;
	        attr_list[idx.arrows.to] = {
	          'attr': attr_list[idx.arrows.to].attr,
	          'name': attr_list[idx.arrows.to].name,
	          'value': {
	            to: {
	              enabled: true,
	              type: to_type
	            },
	            from: {
	              enabled: true,
	              type: from_type
	            }
	          }
	        };
	      }

	      attr_list[idx.arrows.to] = {
	        'attr': attr_list[idx.arrows.to].attr,
	        'name': attr_list[idx.arrows.to].name,
	        'value': {
	          to: {
	            enabled: true,
	            type: attr_list[idx.arrows.to].value.to.type
	          }
	        }
	      };
	    } else {
	      throw newSyntaxError('Invalid dir type "' + dir_type + '"');
	    } // remove 'dir' attribute no need anymore


	    splice$2(attr_list).call(attr_list, idx.dir, 1);
	  } // parse 'penwidth'


	  var nof_attr_list;

	  if (includes$4(attr_names).call(attr_names, 'penwidth')) {
	    var tmp_attr_list = [];
	    nof_attr_list = attr_list.length;

	    for (i = 0; i < nof_attr_list; i++) {
	      // exclude 'width' from attr_list if 'penwidth' exists
	      if (attr_list[i].name !== 'width') {
	        if (attr_list[i].name === 'penwidth') {
	          attr_list[i].name = 'width';
	        }

	        tmp_attr_list.push(attr_list[i]);
	      }
	    }

	    attr_list = tmp_attr_list;
	  }

	  nof_attr_list = attr_list.length;

	  for (i = 0; i < nof_attr_list; i++) {
	    setValue(attr_list[i].attr, attr_list[i].name, attr_list[i].value);
	  }

	  return attr;
	}
	/**
	 * Create a syntax error with extra information on current token and index.
	 * @param {string} message
	 * @returns {SyntaxError} err
	 */


	function newSyntaxError(message) {
	  return new SyntaxError(message + ', got "' + chop(token, 30) + '" (char ' + index$1 + ')');
	}
	/**
	 * Chop off text after a maximum length
	 * @param {string} text
	 * @param {number} maxLength
	 * @returns {String}
	 */


	function chop(text, maxLength) {
	  return text.length <= maxLength ? text : text.substr(0, 27) + '...';
	}
	/**
	 * Execute a function fn for each pair of elements in two arrays
	 * @param {Array | *} array1
	 * @param {Array | *} array2
	 * @param {function} fn
	 */


	function forEach2(array1, array2, fn) {
	  if (isArray$5(array1)) {
	    forEach$2(array1).call(array1, function (elem1) {
	      if (isArray$5(array2)) {
	        forEach$2(array2).call(array2, function (elem2) {
	          fn(elem1, elem2);
	        });
	      } else {
	        fn(elem1, array2);
	      }
	    });
	  } else {
	    if (isArray$5(array2)) {
	      forEach$2(array2).call(array2, function (elem2) {
	        fn(array1, elem2);
	      });
	    } else {
	      fn(array1, array2);
	    }
	  }
	}
	/**
	 * Set a nested property on an object
	 * When nested objects are missing, they will be created.
	 * For example setProp({}, 'font.color', 'red') will return {font: {color: 'red'}}
	 * @param {Object} object
	 * @param {string} path   A dot separated string like 'font.color'
	 * @param {*} value       Value for the property
	 * @return {Object} Returns the original object, allows for chaining.
	 */


	function setProp(object, path, value) {
	  var names = path.split('.');
	  var prop = names.pop(); // traverse over the nested objects

	  var obj = object;

	  for (var i = 0; i < names.length; i++) {
	    var name = names[i];

	    if (!(name in obj)) {
	      obj[name] = {};
	    }

	    obj = obj[name];
	  } // set the property value


	  obj[prop] = value;
	  return object;
	}
	/**
	 * Convert an object with DOT attributes to their vis.js equivalents.
	 * @param {Object} attr     Object with DOT attributes
	 * @param {Object} mapping
	 * @return {Object}         Returns an object with vis.js attributes
	 */


	function convertAttr(attr, mapping) {
	  var converted = {};

	  for (var prop in attr) {
	    if (attr.hasOwnProperty(prop)) {
	      var visProp = mapping[prop];

	      if (isArray$5(visProp)) {
	        forEach$2(visProp).call(visProp, function (visPropI) {
	          setProp(converted, visPropI, attr[prop]);
	        });
	      } else if (typeof visProp === 'string') {
	        setProp(converted, visProp, attr[prop]);
	      } else {
	        setProp(converted, prop, attr[prop]);
	      }
	    }
	  }

	  return converted;
	}
	/**
	 * Convert a string containing a graph in DOT language into a map containing
	 * with nodes and edges in the format of graph.
	 * @param {string} data         Text containing a graph in DOT-notation
	 * @return {Object} graphData
	 */


	function DOTToGraph(data) {
	  // parse the DOT file
	  var dotData = parseDOT(data);
	  var graphData = {
	    nodes: [],
	    edges: [],
	    options: {}
	  }; // copy the nodes

	  if (dotData.nodes) {
	    var _context2;

	    forEach$2(_context2 = dotData.nodes).call(_context2, function (dotNode) {
	      var graphNode = {
	        id: dotNode.id,
	        label: String(dotNode.label || dotNode.id)
	      };
	      merge(graphNode, convertAttr(dotNode.attr, NODE_ATTR_MAPPING));

	      if (graphNode.image) {
	        graphNode.shape = 'image';
	      }

	      graphData.nodes.push(graphNode);
	    });
	  } // copy the edges


	  if (dotData.edges) {
	    var _context3;

	    /**
	     * Convert an edge in DOT format to an edge with VisGraph format
	     * @param {Object} dotEdge
	     * @returns {Object} graphEdge
	     */
	    var convertEdge = function convertEdge(dotEdge) {
	      var graphEdge = {
	        from: dotEdge.from,
	        to: dotEdge.to
	      };
	      merge(graphEdge, convertAttr(dotEdge.attr, EDGE_ATTR_MAPPING)); // Add arrows attribute to default styled arrow.
	      // The reason why default style is not added in parseAttributeList() is
	      // because only default is cleared before here.

	      if (graphEdge.arrows == null && dotEdge.type === '->') {
	        graphEdge.arrows = 'to';
	      }

	      return graphEdge;
	    };

	    forEach$2(_context3 = dotData.edges).call(_context3, function (dotEdge) {
	      var from, to;

	      if (dotEdge.from instanceof Object) {
	        from = dotEdge.from.nodes;
	      } else {
	        from = {
	          id: dotEdge.from
	        };
	      }

	      if (dotEdge.to instanceof Object) {
	        to = dotEdge.to.nodes;
	      } else {
	        to = {
	          id: dotEdge.to
	        };
	      }

	      if (dotEdge.from instanceof Object && dotEdge.from.edges) {
	        var _context4;

	        forEach$2(_context4 = dotEdge.from.edges).call(_context4, function (subEdge) {
	          var graphEdge = convertEdge(subEdge);
	          graphData.edges.push(graphEdge);
	        });
	      }

	      forEach2(from, to, function (from, to) {
	        var subEdge = createEdge(graphData, from.id, to.id, dotEdge.type, dotEdge.attr);
	        var graphEdge = convertEdge(subEdge);
	        graphData.edges.push(graphEdge);
	      });

	      if (dotEdge.to instanceof Object && dotEdge.to.edges) {
	        var _context5;

	        forEach$2(_context5 = dotEdge.to.edges).call(_context5, function (subEdge) {
	          var graphEdge = convertEdge(subEdge);
	          graphData.edges.push(graphEdge);
	        });
	      }
	    });
	  } // copy the options


	  if (dotData.attr) {
	    graphData.options = dotData.attr;
	  }

	  return graphData;
	} // exports


	var parseDOT_1 = parseDOT;
	var DOTToGraph_1 = DOTToGraph;
	var dotparser = {
	  parseDOT: parseDOT_1,
	  DOTToGraph: DOTToGraph_1
	};

	var dotparser$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': dotparser,
		__moduleExports: dotparser,
		parseDOT: parseDOT_1,
		DOTToGraph: DOTToGraph_1
	});

	/**
	 * Convert Gephi to Vis.
	 *
	 * @param gephiJSON - The parsed JSON data in Gephi format.
	 * @param optionsObj - Additional options.
	 *
	 * @returns The converted data ready to be used in Vis.
	 */
	function parseGephi(gephiJSON, optionsObj) {
	  var _context;

	  var options = {
	    edges: {
	      inheritColor: false
	    },
	    nodes: {
	      fixed: false,
	      parseColor: false
	    }
	  };

	  if (optionsObj != null) {
	    if (optionsObj.fixed != null) {
	      options.nodes.fixed = optionsObj.fixed;
	    }

	    if (optionsObj.parseColor != null) {
	      options.nodes.parseColor = optionsObj.parseColor;
	    }

	    if (optionsObj.inheritColor != null) {
	      options.edges.inheritColor = optionsObj.inheritColor;
	    }
	  }

	  var gEdges = gephiJSON.edges;

	  var vEdges = map$2(gEdges).call(gEdges, function (gEdge) {
	    var vEdge = {
	      from: gEdge.source,
	      id: gEdge.id,
	      to: gEdge.target
	    };

	    if (gEdge.attributes != null) {
	      vEdge.attributes = gEdge.attributes;
	    }

	    if (gEdge.label != null) {
	      vEdge.label = gEdge.label;
	    }

	    if (gEdge.attributes != null && gEdge.attributes.title != null) {
	      vEdge.title = gEdge.attributes.title;
	    }

	    if (gEdge.type === 'Directed') {
	      vEdge.arrows = 'to';
	    } // edge['value'] = gEdge.attributes != null ? gEdge.attributes.Weight : undefined;
	    // edge['width'] = edge['value'] != null ? undefined : edgegEdge.size;


	    if (gEdge.color && options.edges.inheritColor === false) {
	      vEdge.color = gEdge.color;
	    }

	    return vEdge;
	  });

	  var vNodes = map$2(_context = gephiJSON.nodes).call(_context, function (gNode) {
	    var vNode = {
	      id: gNode.id,
	      fixed: options.nodes.fixed && gNode.x != null && gNode.y != null
	    };

	    if (gNode.attributes != null) {
	      vNode.attributes = gNode.attributes;
	    }

	    if (gNode.label != null) {
	      vNode.label = gNode.label;
	    }

	    if (gNode.size != null) {
	      vNode.size = gNode.size;
	    }

	    if (gNode.attributes != null && gNode.attributes.title != null) {
	      vNode.title = gNode.attributes.title;
	    }

	    if (gNode.title != null) {
	      vNode.title = gNode.title;
	    }

	    if (gNode.x != null) {
	      vNode.x = gNode.x;
	    }

	    if (gNode.y != null) {
	      vNode.y = gNode.y;
	    }

	    if (gNode.color != null) {
	      if (options.nodes.parseColor === true) {
	        vNode.color = gNode.color;
	      } else {
	        vNode.color = {
	          background: gNode.color,
	          border: gNode.color,
	          highlight: {
	            background: gNode.color,
	            border: gNode.color
	          },
	          hover: {
	            background: gNode.color,
	            border: gNode.color
	          }
	        };
	      }
	    }

	    return vNode;
	  });

	  return {
	    nodes: vNodes,
	    edges: vEdges
	  };
	}

	var gephiParser = /*#__PURE__*/Object.freeze({
		__proto__: null,
		parseGephi: parseGephi
	});

	function styleInject(css, ref) {
	  if (ref === void 0) ref = {};
	  var insertAt = ref.insertAt;

	  if (!css || typeof document === 'undefined') {
	    return;
	  }

	  var head = document.head || document.getElementsByTagName('head')[0];
	  var style = document.createElement('style');
	  style.type = 'text/css';

	  if (insertAt === 'top') {
	    if (head.firstChild) {
	      head.insertBefore(style, head.firstChild);
	    } else {
	      head.appendChild(style);
	    }
	  } else {
	    head.appendChild(style);
	  }

	  if (style.styleSheet) {
	    style.styleSheet.cssText = css;
	  } else {
	    style.appendChild(document.createTextNode(css));
	  }
	}

	var css_248z = ".vis-overlay {\n  position: absolute;\n  top: 0px;\n  right: 0px;\n  bottom: 0px;\n  left: 0px;\n\n  /* Must be displayed above for example selected Timeline items */\n  z-index: 10;\n}\n\n.vis-active {\n  box-shadow: 0 0 10px #86d5f8;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkFjdGl2YXRvci5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxrQkFBa0I7RUFDbEIsUUFBUTtFQUNSLFVBQVU7RUFDVixXQUFXO0VBQ1gsU0FBUzs7RUFFVCxnRUFBZ0U7RUFDaEUsV0FBVztBQUNiOztBQUVBO0VBQ0UsNEJBQTRCO0FBQzlCIiwiZmlsZSI6IkFjdGl2YXRvci5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyIudmlzLW92ZXJsYXkge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHRvcDogMHB4O1xuICByaWdodDogMHB4O1xuICBib3R0b206IDBweDtcbiAgbGVmdDogMHB4O1xuXG4gIC8qIE11c3QgYmUgZGlzcGxheWVkIGFib3ZlIGZvciBleGFtcGxlIHNlbGVjdGVkIFRpbWVsaW5lIGl0ZW1zICovXG4gIHotaW5kZXg6IDEwO1xufVxuXG4udmlzLWFjdGl2ZSB7XG4gIGJveC1zaGFkb3c6IDAgMCAxMHB4ICM4NmQ1Zjg7XG59XG4iXX0= */";
	const stylesheet=".vis-overlay {\n  position: absolute;\n  top: 0px;\n  right: 0px;\n  bottom: 0px;\n  left: 0px;\n\n  /* Must be displayed above for example selected Timeline items */\n  z-index: 10;\n}\n\n.vis-active {\n  box-shadow: 0 0 10px #86d5f8;\n}\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkFjdGl2YXRvci5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxrQkFBa0I7RUFDbEIsUUFBUTtFQUNSLFVBQVU7RUFDVixXQUFXO0VBQ1gsU0FBUzs7RUFFVCxnRUFBZ0U7RUFDaEUsV0FBVztBQUNiOztBQUVBO0VBQ0UsNEJBQTRCO0FBQzlCIiwiZmlsZSI6IkFjdGl2YXRvci5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyIudmlzLW92ZXJsYXkge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHRvcDogMHB4O1xuICByaWdodDogMHB4O1xuICBib3R0b206IDBweDtcbiAgbGVmdDogMHB4O1xuXG4gIC8qIE11c3QgYmUgZGlzcGxheWVkIGFib3ZlIGZvciBleGFtcGxlIHNlbGVjdGVkIFRpbWVsaW5lIGl0ZW1zICovXG4gIHotaW5kZXg6IDEwO1xufVxuXG4udmlzLWFjdGl2ZSB7XG4gIGJveC1zaGFkb3c6IDAgMCAxMHB4ICM4NmQ1Zjg7XG59XG4iXX0= */";
	styleInject(css_248z);

	var Activator = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': css_248z,
		stylesheet: stylesheet
	});

	var keycharm = createCommonjsModule(function (module, exports) {
	  /**
	   * Created by Alex on 11/6/2014.
	   */
	  // https://github.com/umdjs/umd/blob/master/returnExports.js#L40-L60
	  // if the module has no dependencies, the above pattern can be simplified to

	  (function (root, factory) {
	    {
	      // Node. Does not work with strict CommonJS, but
	      // only CommonJS-like environments that support module.exports,
	      // like Node.
	      module.exports = factory();
	    }
	  })(commonjsGlobal, function () {
	    function keycharm(options) {
	      var preventDefault = options && options.preventDefault || false;
	      var container = options && options.container || window;
	      var _exportFunctions = {};
	      var _bound = {
	        keydown: {},
	        keyup: {}
	      };
	      var _keys = {};
	      var i; // a - z

	      for (i = 97; i <= 122; i++) {
	        _keys[String.fromCharCode(i)] = {
	          code: 65 + (i - 97),
	          shift: false
	        };
	      } // A - Z


	      for (i = 65; i <= 90; i++) {
	        _keys[String.fromCharCode(i)] = {
	          code: i,
	          shift: true
	        };
	      } // 0 - 9


	      for (i = 0; i <= 9; i++) {
	        _keys['' + i] = {
	          code: 48 + i,
	          shift: false
	        };
	      } // F1 - F12


	      for (i = 1; i <= 12; i++) {
	        _keys['F' + i] = {
	          code: 111 + i,
	          shift: false
	        };
	      } // num0 - num9


	      for (i = 0; i <= 9; i++) {
	        _keys['num' + i] = {
	          code: 96 + i,
	          shift: false
	        };
	      } // numpad misc


	      _keys['num*'] = {
	        code: 106,
	        shift: false
	      };
	      _keys['num+'] = {
	        code: 107,
	        shift: false
	      };
	      _keys['num-'] = {
	        code: 109,
	        shift: false
	      };
	      _keys['num/'] = {
	        code: 111,
	        shift: false
	      };
	      _keys['num.'] = {
	        code: 110,
	        shift: false
	      }; // arrows

	      _keys['left'] = {
	        code: 37,
	        shift: false
	      };
	      _keys['up'] = {
	        code: 38,
	        shift: false
	      };
	      _keys['right'] = {
	        code: 39,
	        shift: false
	      };
	      _keys['down'] = {
	        code: 40,
	        shift: false
	      }; // extra keys

	      _keys['space'] = {
	        code: 32,
	        shift: false
	      };
	      _keys['enter'] = {
	        code: 13,
	        shift: false
	      };
	      _keys['shift'] = {
	        code: 16,
	        shift: undefined
	      };
	      _keys['esc'] = {
	        code: 27,
	        shift: false
	      };
	      _keys['backspace'] = {
	        code: 8,
	        shift: false
	      };
	      _keys['tab'] = {
	        code: 9,
	        shift: false
	      };
	      _keys['ctrl'] = {
	        code: 17,
	        shift: false
	      };
	      _keys['alt'] = {
	        code: 18,
	        shift: false
	      };
	      _keys['delete'] = {
	        code: 46,
	        shift: false
	      };
	      _keys['pageup'] = {
	        code: 33,
	        shift: false
	      };
	      _keys['pagedown'] = {
	        code: 34,
	        shift: false
	      }; // symbols

	      _keys['='] = {
	        code: 187,
	        shift: false
	      };
	      _keys['-'] = {
	        code: 189,
	        shift: false
	      };
	      _keys[']'] = {
	        code: 221,
	        shift: false
	      };
	      _keys['['] = {
	        code: 219,
	        shift: false
	      };

	      var down = function (event) {
	        handleEvent(event, 'keydown');
	      };

	      var up = function (event) {
	        handleEvent(event, 'keyup');
	      }; // handle the actualy bound key with the event


	      var handleEvent = function (event, type) {
	        if (_bound[type][event.keyCode] !== undefined) {
	          var bound = _bound[type][event.keyCode];

	          for (var i = 0; i < bound.length; i++) {
	            if (bound[i].shift === undefined) {
	              bound[i].fn(event);
	            } else if (bound[i].shift == true && event.shiftKey == true) {
	              bound[i].fn(event);
	            } else if (bound[i].shift == false && event.shiftKey == false) {
	              bound[i].fn(event);
	            }
	          }

	          if (preventDefault == true) {
	            event.preventDefault();
	          }
	        }
	      }; // bind a key to a callback


	      _exportFunctions.bind = function (key, callback, type) {
	        if (type === undefined) {
	          type = 'keydown';
	        }

	        if (_keys[key] === undefined) {
	          throw new Error("unsupported key: " + key);
	        }

	        if (_bound[type][_keys[key].code] === undefined) {
	          _bound[type][_keys[key].code] = [];
	        }

	        _bound[type][_keys[key].code].push({
	          fn: callback,
	          shift: _keys[key].shift
	        });
	      }; // bind all keys to a call back (demo purposes)


	      _exportFunctions.bindAll = function (callback, type) {
	        if (type === undefined) {
	          type = 'keydown';
	        }

	        for (var key in _keys) {
	          if (_keys.hasOwnProperty(key)) {
	            _exportFunctions.bind(key, callback, type);
	          }
	        }
	      }; // get the key label from an event


	      _exportFunctions.getKey = function (event) {
	        for (var key in _keys) {
	          if (_keys.hasOwnProperty(key)) {
	            if (event.shiftKey == true && _keys[key].shift == true && event.keyCode == _keys[key].code) {
	              return key;
	            } else if (event.shiftKey == false && _keys[key].shift == false && event.keyCode == _keys[key].code) {
	              return key;
	            } else if (event.keyCode == _keys[key].code && key == 'shift') {
	              return key;
	            }
	          }
	        }

	        return "unknown key, currently not supported";
	      }; // unbind either a specific callback from a key or all of them (by leaving callback undefined)


	      _exportFunctions.unbind = function (key, callback, type) {
	        if (type === undefined) {
	          type = 'keydown';
	        }

	        if (_keys[key] === undefined) {
	          throw new Error("unsupported key: " + key);
	        }

	        if (callback !== undefined) {
	          var newBindings = [];
	          var bound = _bound[type][_keys[key].code];

	          if (bound !== undefined) {
	            for (var i = 0; i < bound.length; i++) {
	              if (!(bound[i].fn == callback && bound[i].shift == _keys[key].shift)) {
	                newBindings.push(_bound[type][_keys[key].code][i]);
	              }
	            }
	          }

	          _bound[type][_keys[key].code] = newBindings;
	        } else {
	          _bound[type][_keys[key].code] = [];
	        }
	      }; // reset all bound variables.


	      _exportFunctions.reset = function () {
	        _bound = {
	          keydown: {},
	          keyup: {}
	        };
	      }; // unbind all listeners and reset all variables.


	      _exportFunctions.destroy = function () {
	        _bound = {
	          keydown: {},
	          keyup: {}
	        };
	        container.removeEventListener('keydown', down, true);
	        container.removeEventListener('keyup', up, true);
	      }; // create listeners.


	      container.addEventListener('keydown', down, true);
	      container.addEventListener('keyup', up, true); // return the public functions.

	      return _exportFunctions;
	    }

	    return keycharm;
	  });
	});

	/*! Hammer.JS - v2.0.17-rc - 2019-12-16
	 * http://naver.github.io/egjs
	 *
	 * Forked By Naver egjs
	 * Copyright (c) hammerjs
	 * Licensed under the MIT license */
	function _extends() {
	  _extends = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends.apply(this, arguments);
	}

	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}
	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} target
	 * @param {...Object} objects_to_assign
	 * @returns {Object} target
	 */


	var assign$3;

	if (typeof Object.assign !== 'function') {
	  assign$3 = function assign(target) {
	    if (target === undefined || target === null) {
	      throw new TypeError('Cannot convert undefined or null to object');
	    }

	    var output = Object(target);

	    for (var index = 1; index < arguments.length; index++) {
	      var source = arguments[index];

	      if (source !== undefined && source !== null) {
	        for (var nextKey in source) {
	          if (source.hasOwnProperty(nextKey)) {
	            output[nextKey] = source[nextKey];
	          }
	        }
	      }
	    }

	    return output;
	  };
	} else {
	  assign$3 = Object.assign;
	}

	var assign$1$1 = assign$3;
	var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
	var TEST_ELEMENT = typeof document === "undefined" ? {
	  style: {}
	} : document.createElement('div');
	var TYPE_FUNCTION = 'function';
	var round = Math.round,
	    abs = Math.abs;
	var now$3 = Date.now;
	/**
	 * @private
	 * get the prefixed property
	 * @param {Object} obj
	 * @param {String} property
	 * @returns {String|Undefined} prefixed
	 */

	function prefixed(obj, property) {
	  var prefix;
	  var prop;
	  var camelProp = property[0].toUpperCase() + property.slice(1);
	  var i = 0;

	  while (i < VENDOR_PREFIXES.length) {
	    prefix = VENDOR_PREFIXES[i];
	    prop = prefix ? prefix + camelProp : property;

	    if (prop in obj) {
	      return prop;
	    }

	    i++;
	  }

	  return undefined;
	}
	/* eslint-disable no-new-func, no-nested-ternary */


	var win;

	if (typeof window === "undefined") {
	  // window is undefined in node.js
	  win = {};
	} else {
	  win = window;
	}

	var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
	var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;

	function getTouchActionProps() {
	  if (!NATIVE_TOUCH_ACTION) {
	    return false;
	  }

	  var touchMap = {};
	  var cssSupports = win.CSS && win.CSS.supports;
	  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
	    // If css.supports is not supported but there is native touch-action assume it supports
	    // all values. This is the case for IE 10 and 11.
	    return touchMap[val] = cssSupports ? win.CSS.supports('touch-action', val) : true;
	  });
	  return touchMap;
	}

	var TOUCH_ACTION_COMPUTE = 'compute';
	var TOUCH_ACTION_AUTO = 'auto';
	var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

	var TOUCH_ACTION_NONE = 'none';
	var TOUCH_ACTION_PAN_X = 'pan-x';
	var TOUCH_ACTION_PAN_Y = 'pan-y';
	var TOUCH_ACTION_MAP = getTouchActionProps();
	var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
	var SUPPORT_TOUCH = ('ontouchstart' in win);
	var SUPPORT_POINTER_EVENTS = prefixed(win, 'PointerEvent') !== undefined;
	var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
	var INPUT_TYPE_TOUCH = 'touch';
	var INPUT_TYPE_PEN = 'pen';
	var INPUT_TYPE_MOUSE = 'mouse';
	var INPUT_TYPE_KINECT = 'kinect';
	var COMPUTE_INTERVAL = 25;
	var INPUT_START = 1;
	var INPUT_MOVE = 2;
	var INPUT_END = 4;
	var INPUT_CANCEL = 8;
	var DIRECTION_NONE = 1;
	var DIRECTION_LEFT = 2;
	var DIRECTION_RIGHT = 4;
	var DIRECTION_UP = 8;
	var DIRECTION_DOWN = 16;
	var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
	var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
	var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
	var PROPS_XY = ['x', 'y'];
	var PROPS_CLIENT_XY = ['clientX', 'clientY'];
	/**
	 * @private
	 * walk objects and arrays
	 * @param {Object} obj
	 * @param {Function} iterator
	 * @param {Object} context
	 */

	function each(obj, iterator, context) {
	  var i;

	  if (!obj) {
	    return;
	  }

	  if (obj.forEach) {
	    obj.forEach(iterator, context);
	  } else if (obj.length !== undefined) {
	    i = 0;

	    while (i < obj.length) {
	      iterator.call(context, obj[i], i, obj);
	      i++;
	    }
	  } else {
	    for (i in obj) {
	      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
	    }
	  }
	}
	/**
	 * @private
	 * let a boolean value also be a function that must return a boolean
	 * this first item in args will be used as the context
	 * @param {Boolean|Function} val
	 * @param {Array} [args]
	 * @returns {Boolean}
	 */


	function boolOrFn(val, args) {
	  if (typeof val === TYPE_FUNCTION) {
	    return val.apply(args ? args[0] || undefined : undefined, args);
	  }

	  return val;
	}
	/**
	 * @private
	 * small indexOf wrapper
	 * @param {String} str
	 * @param {String} find
	 * @returns {Boolean} found
	 */


	function inStr(str, find) {
	  return str.indexOf(find) > -1;
	}
	/**
	 * @private
	 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
	 * @param {String} actions
	 * @returns {*}
	 */


	function cleanTouchActions(actions) {
	  // none
	  if (inStr(actions, TOUCH_ACTION_NONE)) {
	    return TOUCH_ACTION_NONE;
	  }

	  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
	  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
	  // for different directions, e.g. horizontal pan but vertical swipe?)
	  // we need none (as otherwise with pan-x pan-y combined none of these
	  // recognizers will work, since the browser would handle all panning

	  if (hasPanX && hasPanY) {
	    return TOUCH_ACTION_NONE;
	  } // pan-x OR pan-y


	  if (hasPanX || hasPanY) {
	    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
	  } // manipulation


	  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
	    return TOUCH_ACTION_MANIPULATION;
	  }

	  return TOUCH_ACTION_AUTO;
	}
	/**
	 * @private
	 * Touch Action
	 * sets the touchAction property or uses the js alternative
	 * @param {Manager} manager
	 * @param {String} value
	 * @constructor
	 */


	var TouchAction = /*#__PURE__*/function () {
	  function TouchAction(manager, value) {
	    this.manager = manager;
	    this.set(value);
	  }
	  /**
	   * @private
	   * set the touchAction value on the element or enable the polyfill
	   * @param {String} value
	   */


	  var _proto = TouchAction.prototype;

	  _proto.set = function set(value) {
	    // find out the touch-action by the event handlers
	    if (value === TOUCH_ACTION_COMPUTE) {
	      value = this.compute();
	    }

	    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
	      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
	    }

	    this.actions = value.toLowerCase().trim();
	  };
	  /**
	   * @private
	   * just re-set the touchAction value
	   */


	  _proto.update = function update() {
	    this.set(this.manager.options.touchAction);
	  };
	  /**
	   * @private
	   * compute the value for the touchAction property based on the recognizer's settings
	   * @returns {String} value
	   */


	  _proto.compute = function compute() {
	    var actions = [];
	    each(this.manager.recognizers, function (recognizer) {
	      if (boolOrFn(recognizer.options.enable, [recognizer])) {
	        actions = actions.concat(recognizer.getTouchAction());
	      }
	    });
	    return cleanTouchActions(actions.join(' '));
	  };
	  /**
	   * @private
	   * this method is called on each input cycle and provides the preventing of the browser behavior
	   * @param {Object} input
	   */


	  _proto.preventDefaults = function preventDefaults(input) {
	    var srcEvent = input.srcEvent;
	    var direction = input.offsetDirection; // if the touch action did prevented once this session

	    if (this.manager.session.prevented) {
	      srcEvent.preventDefault();
	      return;
	    }

	    var actions = this.actions;
	    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
	    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
	    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

	    if (hasNone) {
	      // do not prevent defaults if this is a tap gesture
	      var isTapPointer = input.pointers.length === 1;
	      var isTapMovement = input.distance < 2;
	      var isTapTouchTime = input.deltaTime < 250;

	      if (isTapPointer && isTapMovement && isTapTouchTime) {
	        return;
	      }
	    }

	    if (hasPanX && hasPanY) {
	      // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
	      return;
	    }

	    if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
	      return this.preventSrc(srcEvent);
	    }
	  };
	  /**
	   * @private
	   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
	   * @param {Object} srcEvent
	   */


	  _proto.preventSrc = function preventSrc(srcEvent) {
	    this.manager.session.prevented = true;
	    srcEvent.preventDefault();
	  };

	  return TouchAction;
	}();
	/**
	 * @private
	 * find if a node is in the given parent
	 * @method hasParent
	 * @param {HTMLElement} node
	 * @param {HTMLElement} parent
	 * @return {Boolean} found
	 */


	function hasParent$1(node, parent) {
	  while (node) {
	    if (node === parent) {
	      return true;
	    }

	    node = node.parentNode;
	  }

	  return false;
	}
	/**
	 * @private
	 * get the center of all the pointers
	 * @param {Array} pointers
	 * @return {Object} center contains `x` and `y` properties
	 */


	function getCenter(pointers) {
	  var pointersLength = pointers.length; // no need to loop when only one touch

	  if (pointersLength === 1) {
	    return {
	      x: round(pointers[0].clientX),
	      y: round(pointers[0].clientY)
	    };
	  }

	  var x = 0;
	  var y = 0;
	  var i = 0;

	  while (i < pointersLength) {
	    x += pointers[i].clientX;
	    y += pointers[i].clientY;
	    i++;
	  }

	  return {
	    x: round(x / pointersLength),
	    y: round(y / pointersLength)
	  };
	}
	/**
	 * @private
	 * create a simple clone from the input used for storage of firstInput and firstMultiple
	 * @param {Object} input
	 * @returns {Object} clonedInputData
	 */


	function simpleCloneInputData(input) {
	  // make a simple copy of the pointers because we will get a reference if we don't
	  // we only need clientXY for the calculations
	  var pointers = [];
	  var i = 0;

	  while (i < input.pointers.length) {
	    pointers[i] = {
	      clientX: round(input.pointers[i].clientX),
	      clientY: round(input.pointers[i].clientY)
	    };
	    i++;
	  }

	  return {
	    timeStamp: now$3(),
	    pointers: pointers,
	    center: getCenter(pointers),
	    deltaX: input.deltaX,
	    deltaY: input.deltaY
	  };
	}
	/**
	 * @private
	 * calculate the absolute distance between two points
	 * @param {Object} p1 {x, y}
	 * @param {Object} p2 {x, y}
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} distance
	 */


	function getDistance(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.sqrt(x * x + y * y);
	}
	/**
	 * @private
	 * calculate the angle between two coordinates
	 * @param {Object} p1
	 * @param {Object} p2
	 * @param {Array} [props] containing x and y keys
	 * @return {Number} angle
	 */


	function getAngle(p1, p2, props) {
	  if (!props) {
	    props = PROPS_XY;
	  }

	  var x = p2[props[0]] - p1[props[0]];
	  var y = p2[props[1]] - p1[props[1]];
	  return Math.atan2(y, x) * 180 / Math.PI;
	}
	/**
	 * @private
	 * get the direction between two points
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Number} direction
	 */


	function getDirection(x, y) {
	  if (x === y) {
	    return DIRECTION_NONE;
	  }

	  if (abs(x) >= abs(y)) {
	    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	  }

	  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	}

	function computeDeltaXY(session, input) {
	  var center = input.center; // let { offsetDelta:offset = {}, prevDelta = {}, prevInput = {} } = session;
	  // jscs throwing error on defalut destructured values and without defaults tests fail

	  var offset = session.offsetDelta || {};
	  var prevDelta = session.prevDelta || {};
	  var prevInput = session.prevInput || {};

	  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
	    prevDelta = session.prevDelta = {
	      x: prevInput.deltaX || 0,
	      y: prevInput.deltaY || 0
	    };
	    offset = session.offsetDelta = {
	      x: center.x,
	      y: center.y
	    };
	  }

	  input.deltaX = prevDelta.x + (center.x - offset.x);
	  input.deltaY = prevDelta.y + (center.y - offset.y);
	}
	/**
	 * @private
	 * calculate the velocity between two points. unit is in px per ms.
	 * @param {Number} deltaTime
	 * @param {Number} x
	 * @param {Number} y
	 * @return {Object} velocity `x` and `y`
	 */


	function getVelocity(deltaTime, x, y) {
	  return {
	    x: x / deltaTime || 0,
	    y: y / deltaTime || 0
	  };
	}
	/**
	 * @private
	 * calculate the scale factor between two pointersets
	 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} scale
	 */


	function getScale(start, end) {
	  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
	}
	/**
	 * @private
	 * calculate the rotation degrees between two pointersets
	 * @param {Array} start array of pointers
	 * @param {Array} end array of pointers
	 * @return {Number} rotation
	 */


	function getRotation(start, end) {
	  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
	}
	/**
	 * @private
	 * velocity is calculated every x ms
	 * @param {Object} session
	 * @param {Object} input
	 */


	function computeIntervalInputData(session, input) {
	  var last = session.lastInterval || input;
	  var deltaTime = input.timeStamp - last.timeStamp;
	  var velocity;
	  var velocityX;
	  var velocityY;
	  var direction;

	  if (input.eventType !== INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
	    var deltaX = input.deltaX - last.deltaX;
	    var deltaY = input.deltaY - last.deltaY;
	    var v = getVelocity(deltaTime, deltaX, deltaY);
	    velocityX = v.x;
	    velocityY = v.y;
	    velocity = abs(v.x) > abs(v.y) ? v.x : v.y;
	    direction = getDirection(deltaX, deltaY);
	    session.lastInterval = input;
	  } else {
	    // use latest velocity info if it doesn't overtake a minimum period
	    velocity = last.velocity;
	    velocityX = last.velocityX;
	    velocityY = last.velocityY;
	    direction = last.direction;
	  }

	  input.velocity = velocity;
	  input.velocityX = velocityX;
	  input.velocityY = velocityY;
	  input.direction = direction;
	}
	/**
	* @private
	 * extend the data with some usable properties like scale, rotate, velocity etc
	 * @param {Object} manager
	 * @param {Object} input
	 */


	function computeInputData(manager, input) {
	  var session = manager.session;
	  var pointers = input.pointers;
	  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

	  if (!session.firstInput) {
	    session.firstInput = simpleCloneInputData(input);
	  } // to compute scale and rotation we need to store the multiple touches


	  if (pointersLength > 1 && !session.firstMultiple) {
	    session.firstMultiple = simpleCloneInputData(input);
	  } else if (pointersLength === 1) {
	    session.firstMultiple = false;
	  }

	  var firstInput = session.firstInput,
	      firstMultiple = session.firstMultiple;
	  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
	  var center = input.center = getCenter(pointers);
	  input.timeStamp = now$3();
	  input.deltaTime = input.timeStamp - firstInput.timeStamp;
	  input.angle = getAngle(offsetCenter, center);
	  input.distance = getDistance(offsetCenter, center);
	  computeDeltaXY(session, input);
	  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
	  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
	  input.overallVelocityX = overallVelocity.x;
	  input.overallVelocityY = overallVelocity.y;
	  input.overallVelocity = abs(overallVelocity.x) > abs(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
	  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
	  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
	  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
	  computeIntervalInputData(session, input); // find the correct target

	  var target = manager.element;
	  var srcEvent = input.srcEvent;
	  var srcEventTarget;

	  if (srcEvent.composedPath) {
	    srcEventTarget = srcEvent.composedPath()[0];
	  } else if (srcEvent.path) {
	    srcEventTarget = srcEvent.path[0];
	  } else {
	    srcEventTarget = srcEvent.target;
	  }

	  if (hasParent$1(srcEventTarget, target)) {
	    target = srcEventTarget;
	  }

	  input.target = target;
	}
	/**
	 * @private
	 * handle input events
	 * @param {Manager} manager
	 * @param {String} eventType
	 * @param {Object} input
	 */


	function inputHandler(manager, eventType, input) {
	  var pointersLen = input.pointers.length;
	  var changedPointersLen = input.changedPointers.length;
	  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
	  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
	  input.isFirst = !!isFirst;
	  input.isFinal = !!isFinal;

	  if (isFirst) {
	    manager.session = {};
	  } // source event is the normalized value of the domEvents
	  // like 'touchstart, mouseup, pointerdown'


	  input.eventType = eventType; // compute scale, rotation etc

	  computeInputData(manager, input); // emit secret event

	  manager.emit('hammer.input', input);
	  manager.recognize(input);
	  manager.session.prevInput = input;
	}
	/**
	 * @private
	 * split string on whitespace
	 * @param {String} str
	 * @returns {Array} words
	 */


	function splitStr(str) {
	  return str.trim().split(/\s+/g);
	}
	/**
	 * @private
	 * addEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */


	function addEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.addEventListener(type, handler, false);
	  });
	}
	/**
	 * @private
	 * removeEventListener with multiple events at once
	 * @param {EventTarget} target
	 * @param {String} types
	 * @param {Function} handler
	 */


	function removeEventListeners(target, types, handler) {
	  each(splitStr(types), function (type) {
	    target.removeEventListener(type, handler, false);
	  });
	}
	/**
	 * @private
	 * get the window object of an element
	 * @param {HTMLElement} element
	 * @returns {DocumentView|Window}
	 */


	function getWindowForElement(element) {
	  var doc = element.ownerDocument || element;
	  return doc.defaultView || doc.parentWindow || window;
	}
	/**
	 * @private
	 * create new input type manager
	 * @param {Manager} manager
	 * @param {Function} callback
	 * @returns {Input}
	 * @constructor
	 */


	var Input = /*#__PURE__*/function () {
	  function Input(manager, callback) {
	    var self = this;
	    this.manager = manager;
	    this.callback = callback;
	    this.element = manager.element;
	    this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
	    // so when disabled the input events are completely bypassed.

	    this.domHandler = function (ev) {
	      if (boolOrFn(manager.options.enable, [manager])) {
	        self.handler(ev);
	      }
	    };

	    this.init();
	  }
	  /**
	   * @private
	   * should handle the inputEvent data and trigger the callback
	   * @virtual
	   */


	  var _proto = Input.prototype;

	  _proto.handler = function handler() {};
	  /**
	   * @private
	   * bind the events
	   */


	  _proto.init = function init() {
	    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };
	  /**
	   * @private
	   * unbind the events
	   */


	  _proto.destroy = function destroy() {
	    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
	    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
	    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
	  };

	  return Input;
	}();
	/**
	 * @private
	 * find if a array contains the object using indexOf or a simple polyFill
	 * @param {Array} src
	 * @param {String} find
	 * @param {String} [findByKey]
	 * @return {Boolean|Number} false when not found, or the index
	 */


	function inArray(src, find, findByKey) {
	  if (src.indexOf && !findByKey) {
	    return src.indexOf(find);
	  } else {
	    var i = 0;

	    while (i < src.length) {
	      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
	        // do not use === here, test fails
	        return i;
	      }

	      i++;
	    }

	    return -1;
	  }
	}

	var POINTER_INPUT_MAP = {
	  pointerdown: INPUT_START,
	  pointermove: INPUT_MOVE,
	  pointerup: INPUT_END,
	  pointercancel: INPUT_CANCEL,
	  pointerout: INPUT_CANCEL
	}; // in IE10 the pointer types is defined as an enum

	var IE10_POINTER_TYPE_ENUM = {
	  2: INPUT_TYPE_TOUCH,
	  3: INPUT_TYPE_PEN,
	  4: INPUT_TYPE_MOUSE,
	  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

	};
	var POINTER_ELEMENT_EVENTS = 'pointerdown';
	var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

	if (win.MSPointerEvent && !win.PointerEvent) {
	  POINTER_ELEMENT_EVENTS = 'MSPointerDown';
	  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
	}
	/**
	 * @private
	 * Pointer events input
	 * @constructor
	 * @extends Input
	 */


	var PointerEventInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(PointerEventInput, _Input);

	  function PointerEventInput() {
	    var _this;

	    var proto = PointerEventInput.prototype;
	    proto.evEl = POINTER_ELEMENT_EVENTS;
	    proto.evWin = POINTER_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.store = _this.manager.session.pointerEvents = [];
	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = PointerEventInput.prototype;

	  _proto.handler = function handler(ev) {
	    var store = this.store;
	    var removePointer = false;
	    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
	    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
	    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
	    var isTouch = pointerType === INPUT_TYPE_TOUCH; // get index of the event in the store

	    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

	    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
	      if (storeIndex < 0) {
	        store.push(ev);
	        storeIndex = store.length - 1;
	      }
	    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	      removePointer = true;
	    } // it not found, so the pointer hasn't been down (so it's probably a hover)


	    if (storeIndex < 0) {
	      return;
	    } // update the event in the store


	    store[storeIndex] = ev;
	    this.callback(this.manager, eventType, {
	      pointers: store,
	      changedPointers: [ev],
	      pointerType: pointerType,
	      srcEvent: ev
	    });

	    if (removePointer) {
	      // remove from the store
	      store.splice(storeIndex, 1);
	    }
	  };

	  return PointerEventInput;
	}(Input);
	/**
	 * @private
	 * convert array-like objects to real arrays
	 * @param {Object} obj
	 * @returns {Array}
	 */


	function toArray$1(obj) {
	  return Array.prototype.slice.call(obj, 0);
	}
	/**
	 * @private
	 * unique array with objects based on a key (like 'id') or just by the array's value
	 * @param {Array} src [{id:1},{id:2},{id:1}]
	 * @param {String} [key]
	 * @param {Boolean} [sort=False]
	 * @returns {Array} [{id:1},{id:2}]
	 */


	function uniqueArray(src, key, sort) {
	  var results = [];
	  var values = [];
	  var i = 0;

	  while (i < src.length) {
	    var val = key ? src[i][key] : src[i];

	    if (inArray(values, val) < 0) {
	      results.push(src[i]);
	    }

	    values[i] = val;
	    i++;
	  }

	  if (sort) {
	    if (!key) {
	      results = results.sort();
	    } else {
	      results = results.sort(function (a, b) {
	        return a[key] > b[key];
	      });
	    }
	  }

	  return results;
	}

	var TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Multi-user touch events input
	 * @constructor
	 * @extends Input
	 */

	var TouchInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(TouchInput, _Input);

	  function TouchInput() {
	    var _this;

	    TouchInput.prototype.evTarget = TOUCH_TARGET_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.targetIds = {}; // this.evTarget = TOUCH_TARGET_EVENTS;

	    return _this;
	  }

	  var _proto = TouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = TOUCH_INPUT_MAP[ev.type];
	    var touches = getTouches.call(this, ev, type);

	    if (!touches) {
	      return;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return TouchInput;
	}(Input);

	function getTouches(ev, type) {
	  var allTouches = toArray$1(ev.touches);
	  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

	  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
	    targetIds[allTouches[0].identifier] = true;
	    return [allTouches, allTouches];
	  }

	  var i;
	  var targetTouches;
	  var changedTouches = toArray$1(ev.changedTouches);
	  var changedTargetTouches = [];
	  var target = this.target; // get target touches from touches

	  targetTouches = allTouches.filter(function (touch) {
	    return hasParent$1(touch.target, target);
	  }); // collect touches

	  if (type === INPUT_START) {
	    i = 0;

	    while (i < targetTouches.length) {
	      targetIds[targetTouches[i].identifier] = true;
	      i++;
	    }
	  } // filter changed touches to only contain touches that exist in the collected target ids


	  i = 0;

	  while (i < changedTouches.length) {
	    if (targetIds[changedTouches[i].identifier]) {
	      changedTargetTouches.push(changedTouches[i]);
	    } // cleanup removed touches


	    if (type & (INPUT_END | INPUT_CANCEL)) {
	      delete targetIds[changedTouches[i].identifier];
	    }

	    i++;
	  }

	  if (!changedTargetTouches.length) {
	    return;
	  }

	  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
	  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
	}

	var MOUSE_INPUT_MAP = {
	  mousedown: INPUT_START,
	  mousemove: INPUT_MOVE,
	  mouseup: INPUT_END
	};
	var MOUSE_ELEMENT_EVENTS = 'mousedown';
	var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
	/**
	 * @private
	 * Mouse events input
	 * @constructor
	 * @extends Input
	 */

	var MouseInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(MouseInput, _Input);

	  function MouseInput() {
	    var _this;

	    var proto = MouseInput.prototype;
	    proto.evEl = MOUSE_ELEMENT_EVENTS;
	    proto.evWin = MOUSE_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.pressed = false; // mousedown state

	    return _this;
	  }
	  /**
	   * @private
	   * handle mouse events
	   * @param {Object} ev
	   */


	  var _proto = MouseInput.prototype;

	  _proto.handler = function handler(ev) {
	    var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

	    if (eventType & INPUT_START && ev.button === 0) {
	      this.pressed = true;
	    }

	    if (eventType & INPUT_MOVE && ev.which !== 1) {
	      eventType = INPUT_END;
	    } // mouse must be down


	    if (!this.pressed) {
	      return;
	    }

	    if (eventType & INPUT_END) {
	      this.pressed = false;
	    }

	    this.callback(this.manager, eventType, {
	      pointers: [ev],
	      changedPointers: [ev],
	      pointerType: INPUT_TYPE_MOUSE,
	      srcEvent: ev
	    });
	  };

	  return MouseInput;
	}(Input);
	/**
	 * @private
	 * Combined touch and mouse input
	 *
	 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
	 * This because touch devices also emit mouse events while doing a touch.
	 *
	 * @constructor
	 * @extends Input
	 */


	var DEDUP_TIMEOUT = 2500;
	var DEDUP_DISTANCE = 25;

	function setLastTouch(eventData) {
	  var _eventData$changedPoi = eventData.changedPointers,
	      touch = _eventData$changedPoi[0];

	  if (touch.identifier === this.primaryTouch) {
	    var lastTouch = {
	      x: touch.clientX,
	      y: touch.clientY
	    };
	    var lts = this.lastTouches;
	    this.lastTouches.push(lastTouch);

	    var removeLastTouch = function removeLastTouch() {
	      var i = lts.indexOf(lastTouch);

	      if (i > -1) {
	        lts.splice(i, 1);
	      }
	    };

	    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
	  }
	}

	function recordTouches(eventType, eventData) {
	  if (eventType & INPUT_START) {
	    this.primaryTouch = eventData.changedPointers[0].identifier;
	    setLastTouch.call(this, eventData);
	  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
	    setLastTouch.call(this, eventData);
	  }
	}

	function isSyntheticEvent(eventData) {
	  var x = eventData.srcEvent.clientX;
	  var y = eventData.srcEvent.clientY;

	  for (var i = 0; i < this.lastTouches.length; i++) {
	    var t = this.lastTouches[i];
	    var dx = Math.abs(x - t.x);
	    var dy = Math.abs(y - t.y);

	    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
	      return true;
	    }
	  }

	  return false;
	}

	var TouchMouseInput = /*#__PURE__*/function () {
	  var TouchMouseInput = /*#__PURE__*/function (_Input) {
	    _inheritsLoose(TouchMouseInput, _Input);

	    function TouchMouseInput(_manager, callback) {
	      var _this;

	      _this = _Input.call(this, _manager, callback) || this;

	      _this.handler = function (manager, inputEvent, inputData) {
	        var isTouch = inputData.pointerType === INPUT_TYPE_TOUCH;
	        var isMouse = inputData.pointerType === INPUT_TYPE_MOUSE;

	        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
	          return;
	        } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


	        if (isTouch) {
	          recordTouches.call(_assertThisInitialized(_assertThisInitialized(_this)), inputEvent, inputData);
	        } else if (isMouse && isSyntheticEvent.call(_assertThisInitialized(_assertThisInitialized(_this)), inputData)) {
	          return;
	        }

	        _this.callback(manager, inputEvent, inputData);
	      };

	      _this.touch = new TouchInput(_this.manager, _this.handler);
	      _this.mouse = new MouseInput(_this.manager, _this.handler);
	      _this.primaryTouch = null;
	      _this.lastTouches = [];
	      return _this;
	    }
	    /**
	     * @private
	     * handle mouse and touch events
	     * @param {Hammer} manager
	     * @param {String} inputEvent
	     * @param {Object} inputData
	     */


	    var _proto = TouchMouseInput.prototype;
	    /**
	     * @private
	     * remove the event listeners
	     */

	    _proto.destroy = function destroy() {
	      this.touch.destroy();
	      this.mouse.destroy();
	    };

	    return TouchMouseInput;
	  }(Input);

	  return TouchMouseInput;
	}();
	/**
	 * @private
	 * create new input type manager
	 * called by the Manager constructor
	 * @param {Hammer} manager
	 * @returns {Input}
	 */


	function createInputInstance(manager) {
	  var Type; // let inputClass = manager.options.inputClass;

	  var inputClass = manager.options.inputClass;

	  if (inputClass) {
	    Type = inputClass;
	  } else if (SUPPORT_POINTER_EVENTS) {
	    Type = PointerEventInput;
	  } else if (SUPPORT_ONLY_TOUCH) {
	    Type = TouchInput;
	  } else if (!SUPPORT_TOUCH) {
	    Type = MouseInput;
	  } else {
	    Type = TouchMouseInput;
	  }

	  return new Type(manager, inputHandler);
	}
	/**
	 * @private
	 * if the argument is an array, we want to execute the fn on each entry
	 * if it aint an array we don't want to do a thing.
	 * this is used by all the methods that accept a single and array argument.
	 * @param {*|Array} arg
	 * @param {String} fn
	 * @param {Object} [context]
	 * @returns {Boolean}
	 */


	function invokeArrayArg(arg, fn, context) {
	  if (Array.isArray(arg)) {
	    each(arg, context[fn], context);
	    return true;
	  }

	  return false;
	}

	var STATE_POSSIBLE = 1;
	var STATE_BEGAN = 2;
	var STATE_CHANGED = 4;
	var STATE_ENDED = 8;
	var STATE_RECOGNIZED = STATE_ENDED;
	var STATE_CANCELLED = 16;
	var STATE_FAILED = 32;
	/**
	 * @private
	 * get a unique id
	 * @returns {number} uniqueId
	 */

	var _uniqueId = 1;

	function uniqueId() {
	  return _uniqueId++;
	}
	/**
	 * @private
	 * get a recognizer by name if it is bound to a manager
	 * @param {Recognizer|String} otherRecognizer
	 * @param {Recognizer} recognizer
	 * @returns {Recognizer}
	 */


	function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
	  var manager = recognizer.manager;

	  if (manager) {
	    return manager.get(otherRecognizer);
	  }

	  return otherRecognizer;
	}
	/**
	 * @private
	 * get a usable string, used as event postfix
	 * @param {constant} state
	 * @returns {String} state
	 */


	function stateStr(state) {
	  if (state & STATE_CANCELLED) {
	    return 'cancel';
	  } else if (state & STATE_ENDED) {
	    return 'end';
	  } else if (state & STATE_CHANGED) {
	    return 'move';
	  } else if (state & STATE_BEGAN) {
	    return 'start';
	  }

	  return '';
	}
	/**
	 * @private
	 * Recognizer flow explained; *
	 * All recognizers have the initial state of POSSIBLE when a input session starts.
	 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
	 * Example session for mouse-input: mousedown -> mousemove -> mouseup
	 *
	 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
	 * which determines with state it should be.
	 *
	 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
	 * POSSIBLE to give it another change on the next cycle.
	 *
	 *               Possible
	 *                  |
	 *            +-----+---------------+
	 *            |                     |
	 *      +-----+-----+               |
	 *      |           |               |
	 *   Failed      Cancelled          |
	 *                          +-------+------+
	 *                          |              |
	 *                      Recognized       Began
	 *                                         |
	 *                                      Changed
	 *                                         |
	 *                                  Ended/Recognized
	 */

	/**
	 * @private
	 * Recognizer
	 * Every recognizer needs to extend from this class.
	 * @constructor
	 * @param {Object} options
	 */


	var Recognizer = /*#__PURE__*/function () {
	  function Recognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    this.options = _extends({
	      enable: true
	    }, options);
	    this.id = uniqueId();
	    this.manager = null; // default is enable true

	    this.state = STATE_POSSIBLE;
	    this.simultaneous = {};
	    this.requireFail = [];
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @return {Recognizer}
	   */


	  var _proto = Recognizer.prototype;

	  _proto.set = function set(options) {
	    assign$1$1(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

	    this.manager && this.manager.touchAction.update();
	    return this;
	  };
	  /**
	   * @private
	   * recognize simultaneous with an other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.recognizeWith = function recognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
	      return this;
	    }

	    var simultaneous = this.simultaneous;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (!simultaneous[otherRecognizer.id]) {
	      simultaneous[otherRecognizer.id] = otherRecognizer;
	      otherRecognizer.recognizeWith(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRecognizeWith = function dropRecognizeWith(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    delete this.simultaneous[otherRecognizer.id];
	    return this;
	  };
	  /**
	   * @private
	   * recognizer can only run when an other is failing
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.requireFailure = function requireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
	      return this;
	    }

	    var requireFail = this.requireFail;
	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

	    if (inArray(requireFail, otherRecognizer) === -1) {
	      requireFail.push(otherRecognizer);
	      otherRecognizer.requireFailure(this);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * drop the requireFailure link. it does not remove the link on the other recognizer.
	   * @param {Recognizer} otherRecognizer
	   * @returns {Recognizer} this
	   */


	  _proto.dropRequireFailure = function dropRequireFailure(otherRecognizer) {
	    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
	      return this;
	    }

	    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
	    var index = inArray(this.requireFail, otherRecognizer);

	    if (index > -1) {
	      this.requireFail.splice(index, 1);
	    }

	    return this;
	  };
	  /**
	   * @private
	   * has require failures boolean
	   * @returns {boolean}
	   */


	  _proto.hasRequireFailures = function hasRequireFailures() {
	    return this.requireFail.length > 0;
	  };
	  /**
	   * @private
	   * if the recognizer can recognize simultaneous with an other recognizer
	   * @param {Recognizer} otherRecognizer
	   * @returns {Boolean}
	   */


	  _proto.canRecognizeWith = function canRecognizeWith(otherRecognizer) {
	    return !!this.simultaneous[otherRecognizer.id];
	  };
	  /**
	   * @private
	   * You should use `tryEmit` instead of `emit` directly to check
	   * that all the needed recognizers has failed before emitting.
	   * @param {Object} input
	   */


	  _proto.emit = function emit(input) {
	    var self = this;
	    var state = this.state;

	    function emit(event) {
	      self.manager.emit(event, input);
	    } // 'panstart' and 'panmove'


	    if (state < STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }

	    emit(self.options.event); // simple 'eventName' events

	    if (input.additionalEvent) {
	      // additional event(panleft, panright, pinchin, pinchout...)
	      emit(input.additionalEvent);
	    } // panend and pancancel


	    if (state >= STATE_ENDED) {
	      emit(self.options.event + stateStr(state));
	    }
	  };
	  /**
	   * @private
	   * Check that all the require failure recognizers has failed,
	   * if true, it emits a gesture event,
	   * otherwise, setup the state to FAILED.
	   * @param {Object} input
	   */


	  _proto.tryEmit = function tryEmit(input) {
	    if (this.canEmit()) {
	      return this.emit(input);
	    } // it's failing anyway


	    this.state = STATE_FAILED;
	  };
	  /**
	   * @private
	   * can we emit?
	   * @returns {boolean}
	   */


	  _proto.canEmit = function canEmit() {
	    var i = 0;

	    while (i < this.requireFail.length) {
	      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
	        return false;
	      }

	      i++;
	    }

	    return true;
	  };
	  /**
	   * @private
	   * update the recognizer
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    // make a new copy of the inputData
	    // so we can change the inputData without messing up the other recognizers
	    var inputDataClone = assign$1$1({}, inputData); // is is enabled and allow recognizing?

	    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
	      this.reset();
	      this.state = STATE_FAILED;
	      return;
	    } // reset when we've reached the end


	    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
	      this.state = STATE_POSSIBLE;
	    }

	    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
	    // so trigger an event

	    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
	      this.tryEmit(inputDataClone);
	    }
	  };
	  /**
	   * @private
	   * return the state of the recognizer
	   * the actual recognizing happens in this method
	   * @virtual
	   * @param {Object} inputData
	   * @returns {constant} STATE
	   */

	  /* jshint ignore:start */


	  _proto.process = function process(inputData) {};
	  /* jshint ignore:end */

	  /**
	   * @private
	   * return the preferred touch-action
	   * @virtual
	   * @returns {Array}
	   */


	  _proto.getTouchAction = function getTouchAction() {};
	  /**
	   * @private
	   * called when the gesture isn't allowed to recognize
	   * like when another is being recognized or it is disabled
	   * @virtual
	   */


	  _proto.reset = function reset() {};

	  return Recognizer;
	}();
	/**
	 * @private
	 * A tap is recognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
	 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
	 * a single tap.
	 *
	 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
	 * multi-taps being recognized.
	 * @constructor
	 * @extends Recognizer
	 */


	var TapRecognizer = /*#__PURE__*/function (_Recognizer) {
	  _inheritsLoose(TapRecognizer, _Recognizer);

	  function TapRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'tap',
	      pointers: 1,
	      taps: 1,
	      interval: 300,
	      // max time between the multi-tap taps
	      time: 250,
	      // max time of the pointer to be down (like finger on the screen)
	      threshold: 9,
	      // a minimal movement is ok, but keep it low
	      posThreshold: 10
	    }, options)) || this; // previous time and center,
	    // used for tap counting

	    _this.pTime = false;
	    _this.pCenter = false;
	    _this._timer = null;
	    _this._input = null;
	    _this.count = 0;
	    return _this;
	  }

	  var _proto = TapRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_MANIPULATION];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTouchTime = input.deltaTime < options.time;
	    this.reset();

	    if (input.eventType & INPUT_START && this.count === 0) {
	      return this.failTimeout();
	    } // we only allow little movement
	    // and we've reached an end event, so a tap is possible


	    if (validMovement && validTouchTime && validPointers) {
	      if (input.eventType !== INPUT_END) {
	        return this.failTimeout();
	      }

	      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
	      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
	      this.pTime = input.timeStamp;
	      this.pCenter = input.center;

	      if (!validMultiTap || !validInterval) {
	        this.count = 1;
	      } else {
	        this.count += 1;
	      }

	      this._input = input; // if tap count matches we have recognized it,
	      // else it has began recognizing...

	      var tapCount = this.count % options.taps;

	      if (tapCount === 0) {
	        // no failing requirements, immediately trigger the tap event
	        // or wait as long as the multitap interval to trigger
	        if (!this.hasRequireFailures()) {
	          return STATE_RECOGNIZED;
	        } else {
	          this._timer = setTimeout(function () {
	            _this2.state = STATE_RECOGNIZED;

	            _this2.tryEmit();
	          }, options.interval);
	          return STATE_BEGAN;
	        }
	      }
	    }

	    return STATE_FAILED;
	  };

	  _proto.failTimeout = function failTimeout() {
	    var _this3 = this;

	    this._timer = setTimeout(function () {
	      _this3.state = STATE_FAILED;
	    }, this.options.interval);
	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit() {
	    if (this.state === STATE_RECOGNIZED) {
	      this._input.tapCount = this.count;
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return TapRecognizer;
	}(Recognizer);
	/**
	 * @private
	 * This recognizer is just used as a base for the simple attribute recognizers.
	 * @constructor
	 * @extends Recognizer
	 */


	var AttrRecognizer = /*#__PURE__*/function (_Recognizer) {
	  _inheritsLoose(AttrRecognizer, _Recognizer);

	  function AttrRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _Recognizer.call(this, _extends({
	      pointers: 1
	    }, options)) || this;
	  }
	  /**
	   * @private
	   * Used to check if it the recognizer receives valid input, like input.distance > 10.
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {Boolean} recognized
	   */


	  var _proto = AttrRecognizer.prototype;

	  _proto.attrTest = function attrTest(input) {
	    var optionPointers = this.options.pointers;
	    return optionPointers === 0 || input.pointers.length === optionPointers;
	  };
	  /**
	   * @private
	   * Process the input and return the state for the recognizer
	   * @memberof AttrRecognizer
	   * @param {Object} input
	   * @returns {*} State
	   */


	  _proto.process = function process(input) {
	    var state = this.state;
	    var eventType = input.eventType;
	    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
	    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

	    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
	      return state | STATE_CANCELLED;
	    } else if (isRecognized || isValid) {
	      if (eventType & INPUT_END) {
	        return state | STATE_ENDED;
	      } else if (!(state & STATE_BEGAN)) {
	        return STATE_BEGAN;
	      }

	      return state | STATE_CHANGED;
	    }

	    return STATE_FAILED;
	  };

	  return AttrRecognizer;
	}(Recognizer);
	/**
	 * @private
	 * direction cons to string
	 * @param {constant} direction
	 * @returns {String}
	 */


	function directionStr(direction) {
	  if (direction === DIRECTION_DOWN) {
	    return 'down';
	  } else if (direction === DIRECTION_UP) {
	    return 'up';
	  } else if (direction === DIRECTION_LEFT) {
	    return 'left';
	  } else if (direction === DIRECTION_RIGHT) {
	    return 'right';
	  }

	  return '';
	}
	/**
	 * @private
	 * Pan
	 * Recognized when the pointer is down and moved in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var PanRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(PanRecognizer, _AttrRecognizer);

	  function PanRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _AttrRecognizer.call(this, _extends({
	      event: 'pan',
	      threshold: 10,
	      pointers: 1,
	      direction: DIRECTION_ALL
	    }, options)) || this;
	    _this.pX = null;
	    _this.pY = null;
	    return _this;
	  }

	  var _proto = PanRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    var direction = this.options.direction;
	    var actions = [];

	    if (direction & DIRECTION_HORIZONTAL) {
	      actions.push(TOUCH_ACTION_PAN_Y);
	    }

	    if (direction & DIRECTION_VERTICAL) {
	      actions.push(TOUCH_ACTION_PAN_X);
	    }

	    return actions;
	  };

	  _proto.directionTest = function directionTest(input) {
	    var options = this.options;
	    var hasMoved = true;
	    var distance = input.distance;
	    var direction = input.direction;
	    var x = input.deltaX;
	    var y = input.deltaY; // lock to axis?

	    if (!(direction & options.direction)) {
	      if (options.direction & DIRECTION_HORIZONTAL) {
	        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
	        hasMoved = x !== this.pX;
	        distance = Math.abs(input.deltaX);
	      } else {
	        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
	        hasMoved = y !== this.pY;
	        distance = Math.abs(input.deltaY);
	      }
	    }

	    input.direction = direction;
	    return hasMoved && distance > options.threshold && direction & options.direction;
	  };

	  _proto.attrTest = function attrTest(input) {
	    return AttrRecognizer.prototype.attrTest.call(this, input) && ( // replace with a super call
	    this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
	  };

	  _proto.emit = function emit(input) {
	    this.pX = input.deltaX;
	    this.pY = input.deltaY;
	    var direction = directionStr(input.direction);

	    if (direction) {
	      input.additionalEvent = this.options.event + direction;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PanRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Swipe
	 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var SwipeRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(SwipeRecognizer, _AttrRecognizer);

	  function SwipeRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'swipe',
	      threshold: 10,
	      velocity: 0.3,
	      direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
	      pointers: 1
	    }, options)) || this;
	  }

	  var _proto = SwipeRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return PanRecognizer.prototype.getTouchAction.call(this);
	  };

	  _proto.attrTest = function attrTest(input) {
	    var direction = this.options.direction;
	    var velocity;

	    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
	      velocity = input.overallVelocity;
	    } else if (direction & DIRECTION_HORIZONTAL) {
	      velocity = input.overallVelocityX;
	    } else if (direction & DIRECTION_VERTICAL) {
	      velocity = input.overallVelocityY;
	    }

	    return _AttrRecognizer.prototype.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers === this.options.pointers && abs(velocity) > this.options.velocity && input.eventType & INPUT_END;
	  };

	  _proto.emit = function emit(input) {
	    var direction = directionStr(input.offsetDirection);

	    if (direction) {
	      this.manager.emit(this.options.event + direction, input);
	    }

	    this.manager.emit(this.options.event, input);
	  };

	  return SwipeRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Pinch
	 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var PinchRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(PinchRecognizer, _AttrRecognizer);

	  function PinchRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'pinch',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = PinchRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  _proto.emit = function emit(input) {
	    if (input.scale !== 1) {
	      var inOut = input.scale < 1 ? 'in' : 'out';
	      input.additionalEvent = this.options.event + inOut;
	    }

	    _AttrRecognizer.prototype.emit.call(this, input);
	  };

	  return PinchRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Rotate
	 * Recognized when two or more pointer are moving in a circular motion.
	 * @constructor
	 * @extends AttrRecognizer
	 */


	var RotateRecognizer = /*#__PURE__*/function (_AttrRecognizer) {
	  _inheritsLoose(RotateRecognizer, _AttrRecognizer);

	  function RotateRecognizer(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return _AttrRecognizer.call(this, _extends({
	      event: 'rotate',
	      threshold: 0,
	      pointers: 2
	    }, options)) || this;
	  }

	  var _proto = RotateRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_NONE];
	  };

	  _proto.attrTest = function attrTest(input) {
	    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
	  };

	  return RotateRecognizer;
	}(AttrRecognizer);
	/**
	 * @private
	 * Press
	 * Recognized when the pointer is down for x ms without any movement.
	 * @constructor
	 * @extends Recognizer
	 */


	var PressRecognizer = /*#__PURE__*/function (_Recognizer) {
	  _inheritsLoose(PressRecognizer, _Recognizer);

	  function PressRecognizer(options) {
	    var _this;

	    if (options === void 0) {
	      options = {};
	    }

	    _this = _Recognizer.call(this, _extends({
	      event: 'press',
	      pointers: 1,
	      time: 251,
	      // minimal time of the pointer to be pressed
	      threshold: 9
	    }, options)) || this;
	    _this._timer = null;
	    _this._input = null;
	    return _this;
	  }

	  var _proto = PressRecognizer.prototype;

	  _proto.getTouchAction = function getTouchAction() {
	    return [TOUCH_ACTION_AUTO];
	  };

	  _proto.process = function process(input) {
	    var _this2 = this;

	    var options = this.options;
	    var validPointers = input.pointers.length === options.pointers;
	    var validMovement = input.distance < options.threshold;
	    var validTime = input.deltaTime > options.time;
	    this._input = input; // we only allow little movement
	    // and we've reached an end event, so a tap is possible

	    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
	      this.reset();
	    } else if (input.eventType & INPUT_START) {
	      this.reset();
	      this._timer = setTimeout(function () {
	        _this2.state = STATE_RECOGNIZED;

	        _this2.tryEmit();
	      }, options.time);
	    } else if (input.eventType & INPUT_END) {
	      return STATE_RECOGNIZED;
	    }

	    return STATE_FAILED;
	  };

	  _proto.reset = function reset() {
	    clearTimeout(this._timer);
	  };

	  _proto.emit = function emit(input) {
	    if (this.state !== STATE_RECOGNIZED) {
	      return;
	    }

	    if (input && input.eventType & INPUT_END) {
	      this.manager.emit(this.options.event + "up", input);
	    } else {
	      this._input.timeStamp = now$3();
	      this.manager.emit(this.options.event, this._input);
	    }
	  };

	  return PressRecognizer;
	}(Recognizer);

	var defaults = {
	  /**
	   * @private
	   * set if DOM events are being triggered.
	   * But this is slower and unused by simple implementations, so disabled by default.
	   * @type {Boolean}
	   * @default false
	   */
	  domEvents: false,

	  /**
	   * @private
	   * The value for the touchAction property/fallback.
	   * When set to `compute` it will magically set the correct value based on the added recognizers.
	   * @type {String}
	   * @default compute
	   */
	  touchAction: TOUCH_ACTION_COMPUTE,

	  /**
	   * @private
	   * @type {Boolean}
	   * @default true
	   */
	  enable: true,

	  /**
	   * @private
	   * EXPERIMENTAL FEATURE -- can be removed/changed
	   * Change the parent input target element.
	   * If Null, then it is being set the to main element.
	   * @type {Null|EventTarget}
	   * @default null
	   */
	  inputTarget: null,

	  /**
	   * @private
	   * force an input class
	   * @type {Null|Function}
	   * @default null
	   */
	  inputClass: null,

	  /**
	   * @private
	   * Some CSS properties can be used to improve the working of Hammer.
	   * Add them to this method and they will be set when creating a new Manager.
	   * @namespace
	   */
	  cssProps: {
	    /**
	     * @private
	     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userSelect: "none",

	    /**
	     * @private
	     * Disable the Windows Phone grippers when pressing an element.
	     * @type {String}
	     * @default 'none'
	     */
	    touchSelect: "none",

	    /**
	     * @private
	     * Disables the default callout shown when you touch and hold a touch target.
	     * On iOS, when you touch and hold a touch target such as a link, Safari displays
	     * a callout containing information about the link. This property allows you to disable that callout.
	     * @type {String}
	     * @default 'none'
	     */
	    touchCallout: "none",

	    /**
	     * @private
	     * Specifies whether zooming is enabled. Used by IE10>
	     * @type {String}
	     * @default 'none'
	     */
	    contentZooming: "none",

	    /**
	     * @private
	     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
	     * @type {String}
	     * @default 'none'
	     */
	    userDrag: "none",

	    /**
	     * @private
	     * Overrides the highlight color shown when the user taps a link or a JavaScript
	     * clickable element in iOS. This property obeys the alpha value, if specified.
	     * @type {String}
	     * @default 'rgba(0,0,0,0)'
	     */
	    tapHighlightColor: "rgba(0,0,0,0)"
	  }
	};
	/**
	 * @private
	 * Default recognizer setup when calling `Hammer()`
	 * When creating a new Manager these will be skipped.
	 * This is separated with other defaults because of tree-shaking.
	 * @type {Array}
	 */

	var preset = [[RotateRecognizer, {
	  enable: false
	}], [PinchRecognizer, {
	  enable: false
	}, ['rotate']], [SwipeRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}], [PanRecognizer, {
	  direction: DIRECTION_HORIZONTAL
	}, ['swipe']], [TapRecognizer], [TapRecognizer, {
	  event: 'doubletap',
	  taps: 2
	}, ['tap']], [PressRecognizer]];
	var STOP = 1;
	var FORCED_STOP = 2;
	/**
	 * @private
	 * add/remove the css properties as defined in manager.options.cssProps
	 * @param {Manager} manager
	 * @param {Boolean} add
	 */

	function toggleCssProps(manager, add) {
	  var element = manager.element;

	  if (!element.style) {
	    return;
	  }

	  var prop;
	  each(manager.options.cssProps, function (value, name) {
	    prop = prefixed(element.style, name);

	    if (add) {
	      manager.oldCssProps[prop] = element.style[prop];
	      element.style[prop] = value;
	    } else {
	      element.style[prop] = manager.oldCssProps[prop] || "";
	    }
	  });

	  if (!add) {
	    manager.oldCssProps = {};
	  }
	}
	/**
	 * @private
	 * trigger dom event
	 * @param {String} event
	 * @param {Object} data
	 */


	function triggerDomEvent(event, data) {
	  var gestureEvent = document.createEvent("Event");
	  gestureEvent.initEvent(event, true, true);
	  gestureEvent.gesture = data;
	  data.target.dispatchEvent(gestureEvent);
	}
	/**
	* @private
	 * Manager
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */


	var Manager = /*#__PURE__*/function () {
	  function Manager(element, options) {
	    var _this = this;

	    this.options = assign$1$1({}, defaults, options || {});
	    this.options.inputTarget = this.options.inputTarget || element;
	    this.handlers = {};
	    this.session = {};
	    this.recognizers = [];
	    this.oldCssProps = {};
	    this.element = element;
	    this.input = createInputInstance(this);
	    this.touchAction = new TouchAction(this, this.options.touchAction);
	    toggleCssProps(this, true);
	    each(this.options.recognizers, function (item) {
	      var recognizer = _this.add(new item[0](item[1]));

	      item[2] && recognizer.recognizeWith(item[2]);
	      item[3] && recognizer.requireFailure(item[3]);
	    }, this);
	  }
	  /**
	   * @private
	   * set options
	   * @param {Object} options
	   * @returns {Manager}
	   */


	  var _proto = Manager.prototype;

	  _proto.set = function set(options) {
	    assign$1$1(this.options, options); // Options that need a little more setup

	    if (options.touchAction) {
	      this.touchAction.update();
	    }

	    if (options.inputTarget) {
	      // Clean up existing event listeners and reinitialize
	      this.input.destroy();
	      this.input.target = options.inputTarget;
	      this.input.init();
	    }

	    return this;
	  };
	  /**
	   * @private
	   * stop recognizing for this session.
	   * This session will be discarded, when a new [input]start event is fired.
	   * When forced, the recognizer cycle is stopped immediately.
	   * @param {Boolean} [force]
	   */


	  _proto.stop = function stop(force) {
	    this.session.stopped = force ? FORCED_STOP : STOP;
	  };
	  /**
	   * @private
	   * run the recognizers!
	   * called by the inputHandler function on every movement of the pointers (touches)
	   * it walks through all the recognizers and tries to detect the gesture that is being made
	   * @param {Object} inputData
	   */


	  _proto.recognize = function recognize(inputData) {
	    var session = this.session;

	    if (session.stopped) {
	      return;
	    } // run the touch-action polyfill


	    this.touchAction.preventDefaults(inputData);
	    var recognizer;
	    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
	    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
	    // if no recognizer is detecting a thing, it is set to `null`

	    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
	    // or when we're in a new session

	    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
	      session.curRecognizer = null;
	      curRecognizer = null;
	    }

	    var i = 0;

	    while (i < recognizers.length) {
	      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
	      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
	      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
	      //      that is being recognized.
	      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
	      //      this can be setup with the `recognizeWith()` method on the recognizer.

	      if (session.stopped !== FORCED_STOP && ( // 1
	      !curRecognizer || recognizer === curRecognizer || // 2
	      recognizer.canRecognizeWith(curRecognizer))) {
	        // 3
	        recognizer.recognize(inputData);
	      } else {
	        recognizer.reset();
	      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
	      // current active recognizer. but only if we don't already have an active recognizer


	      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
	        session.curRecognizer = recognizer;
	        curRecognizer = recognizer;
	      }

	      i++;
	    }
	  };
	  /**
	   * @private
	   * get a recognizer by its event name.
	   * @param {Recognizer|String} recognizer
	   * @returns {Recognizer|Null}
	   */


	  _proto.get = function get(recognizer) {
	    if (recognizer instanceof Recognizer) {
	      return recognizer;
	    }

	    var recognizers = this.recognizers;

	    for (var i = 0; i < recognizers.length; i++) {
	      if (recognizers[i].options.event === recognizer) {
	        return recognizers[i];
	      }
	    }

	    return null;
	  };
	  /**
	   * @private add a recognizer to the manager
	   * existing recognizers with the same event name will be removed
	   * @param {Recognizer} recognizer
	   * @returns {Recognizer|Manager}
	   */


	  _proto.add = function add(recognizer) {
	    if (invokeArrayArg(recognizer, "add", this)) {
	      return this;
	    } // remove existing


	    var existing = this.get(recognizer.options.event);

	    if (existing) {
	      this.remove(existing);
	    }

	    this.recognizers.push(recognizer);
	    recognizer.manager = this;
	    this.touchAction.update();
	    return recognizer;
	  };
	  /**
	   * @private
	   * remove a recognizer by name or instance
	   * @param {Recognizer|String} recognizer
	   * @returns {Manager}
	   */


	  _proto.remove = function remove(recognizer) {
	    if (invokeArrayArg(recognizer, "remove", this)) {
	      return this;
	    }

	    var targetRecognizer = this.get(recognizer); // let's make sure this recognizer exists

	    if (recognizer) {
	      var recognizers = this.recognizers;
	      var index = inArray(recognizers, targetRecognizer);

	      if (index !== -1) {
	        recognizers.splice(index, 1);
	        this.touchAction.update();
	      }
	    }

	    return this;
	  };
	  /**
	   * @private
	   * bind event
	   * @param {String} events
	   * @param {Function} handler
	   * @returns {EventEmitter} this
	   */


	  _proto.on = function on(events, handler) {
	    if (events === undefined || handler === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      handlers[event] = handlers[event] || [];
	      handlers[event].push(handler);
	    });
	    return this;
	  };
	  /**
	   * @private unbind event, leave emit blank to remove all handlers
	   * @param {String} events
	   * @param {Function} [handler]
	   * @returns {EventEmitter} this
	   */


	  _proto.off = function off(events, handler) {
	    if (events === undefined) {
	      return this;
	    }

	    var handlers = this.handlers;
	    each(splitStr(events), function (event) {
	      if (!handler) {
	        delete handlers[event];
	      } else {
	        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
	      }
	    });
	    return this;
	  };
	  /**
	   * @private emit event to the listeners
	   * @param {String} event
	   * @param {Object} data
	   */


	  _proto.emit = function emit(event, data) {
	    // we also want to trigger dom events
	    if (this.options.domEvents) {
	      triggerDomEvent(event, data);
	    } // no handlers, so skip it all


	    var handlers = this.handlers[event] && this.handlers[event].slice();

	    if (!handlers || !handlers.length) {
	      return;
	    }

	    data.type = event;

	    data.preventDefault = function () {
	      data.srcEvent.preventDefault();
	    };

	    var i = 0;

	    while (i < handlers.length) {
	      handlers[i](data);
	      i++;
	    }
	  };
	  /**
	   * @private
	   * destroy the manager and unbinds all events
	   * it doesn't unbind dom events, that is the user own responsibility
	   */


	  _proto.destroy = function destroy() {
	    this.element && toggleCssProps(this, false);
	    this.handlers = {};
	    this.session = {};
	    this.input.destroy();
	    this.element = null;
	  };

	  return Manager;
	}();

	var SINGLE_TOUCH_INPUT_MAP = {
	  touchstart: INPUT_START,
	  touchmove: INPUT_MOVE,
	  touchend: INPUT_END,
	  touchcancel: INPUT_CANCEL
	};
	var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
	var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
	/**
	 * @private
	 * Touch events input
	 * @constructor
	 * @extends Input
	 */

	var SingleTouchInput = /*#__PURE__*/function (_Input) {
	  _inheritsLoose(SingleTouchInput, _Input);

	  function SingleTouchInput() {
	    var _this;

	    var proto = SingleTouchInput.prototype;
	    proto.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
	    proto.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
	    _this = _Input.apply(this, arguments) || this;
	    _this.started = false;
	    return _this;
	  }

	  var _proto = SingleTouchInput.prototype;

	  _proto.handler = function handler(ev) {
	    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

	    if (type === INPUT_START) {
	      this.started = true;
	    }

	    if (!this.started) {
	      return;
	    }

	    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

	    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
	      this.started = false;
	    }

	    this.callback(this.manager, type, {
	      pointers: touches[0],
	      changedPointers: touches[1],
	      pointerType: INPUT_TYPE_TOUCH,
	      srcEvent: ev
	    });
	  };

	  return SingleTouchInput;
	}(Input);

	function normalizeSingleTouches(ev, type) {
	  var all = toArray$1(ev.touches);
	  var changed = toArray$1(ev.changedTouches);

	  if (type & (INPUT_END | INPUT_CANCEL)) {
	    all = uniqueArray(all.concat(changed), 'identifier', true);
	  }

	  return [all, changed];
	}
	/**
	 * @private
	 * wrap a method with a deprecation warning and stack trace
	 * @param {Function} method
	 * @param {String} name
	 * @param {String} message
	 * @returns {Function} A new function wrapping the supplied method.
	 */


	function deprecate(method, name, message) {
	  var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
	  return function () {
	    var e = new Error('get-stack-trace');
	    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
	    var log = window.console && (window.console.warn || window.console.log);

	    if (log) {
	      log.call(window.console, deprecationMessage, stack);
	    }

	    return method.apply(this, arguments);
	  };
	}
	/**
	 * @private
	 * extend object.
	 * means that properties in dest will be overwritten by the ones in src.
	 * @param {Object} dest
	 * @param {Object} src
	 * @param {Boolean} [merge=false]
	 * @returns {Object} dest
	 */


	var extend$1 = deprecate(function (dest, src, merge) {
	  var keys = Object.keys(src);
	  var i = 0;

	  while (i < keys.length) {
	    if (!merge || merge && dest[keys[i]] === undefined) {
	      dest[keys[i]] = src[keys[i]];
	    }

	    i++;
	  }

	  return dest;
	}, 'extend', 'Use `assign`.');
	/**
	 * @private
	 * merge the values from src in the dest.
	 * means that properties that exist in dest will not be overwritten by src
	 * @param {Object} dest
	 * @param {Object} src
	 * @returns {Object} dest
	 */

	var merge$1 = deprecate(function (dest, src) {
	  return extend$1(dest, src, true);
	}, 'merge', 'Use `assign`.');
	/**
	 * @private
	 * simple class inheritance
	 * @param {Function} child
	 * @param {Function} base
	 * @param {Object} [properties]
	 */

	function inherit(child, base, properties) {
	  var baseP = base.prototype;
	  var childP;
	  childP = child.prototype = Object.create(baseP);
	  childP.constructor = child;
	  childP._super = baseP;

	  if (properties) {
	    assign$1$1(childP, properties);
	  }
	}
	/**
	 * @private
	 * simple function bind
	 * @param {Function} fn
	 * @param {Object} context
	 * @returns {Function}
	 */


	function bindFn(fn, context) {
	  return function boundFn() {
	    return fn.apply(context, arguments);
	  };
	}
	/**
	 * @private
	 * Simple way to create a manager with a default set of recognizers.
	 * @param {HTMLElement} element
	 * @param {Object} [options]
	 * @constructor
	 */


	var Hammer = /*#__PURE__*/function () {
	  var Hammer =
	  /**
	    * @private
	    * @const {string}
	    */
	  function Hammer(element, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    return new Manager(element, _extends({
	      recognizers: preset.concat()
	    }, options));
	  };

	  Hammer.VERSION = "2.0.17-rc";
	  Hammer.DIRECTION_ALL = DIRECTION_ALL;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.DIRECTION_LEFT = DIRECTION_LEFT;
	  Hammer.DIRECTION_RIGHT = DIRECTION_RIGHT;
	  Hammer.DIRECTION_UP = DIRECTION_UP;
	  Hammer.DIRECTION_HORIZONTAL = DIRECTION_HORIZONTAL;
	  Hammer.DIRECTION_VERTICAL = DIRECTION_VERTICAL;
	  Hammer.DIRECTION_NONE = DIRECTION_NONE;
	  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
	  Hammer.INPUT_START = INPUT_START;
	  Hammer.INPUT_MOVE = INPUT_MOVE;
	  Hammer.INPUT_END = INPUT_END;
	  Hammer.INPUT_CANCEL = INPUT_CANCEL;
	  Hammer.STATE_POSSIBLE = STATE_POSSIBLE;
	  Hammer.STATE_BEGAN = STATE_BEGAN;
	  Hammer.STATE_CHANGED = STATE_CHANGED;
	  Hammer.STATE_ENDED = STATE_ENDED;
	  Hammer.STATE_RECOGNIZED = STATE_RECOGNIZED;
	  Hammer.STATE_CANCELLED = STATE_CANCELLED;
	  Hammer.STATE_FAILED = STATE_FAILED;
	  Hammer.Manager = Manager;
	  Hammer.Input = Input;
	  Hammer.TouchAction = TouchAction;
	  Hammer.TouchInput = TouchInput;
	  Hammer.MouseInput = MouseInput;
	  Hammer.PointerEventInput = PointerEventInput;
	  Hammer.TouchMouseInput = TouchMouseInput;
	  Hammer.SingleTouchInput = SingleTouchInput;
	  Hammer.Recognizer = Recognizer;
	  Hammer.AttrRecognizer = AttrRecognizer;
	  Hammer.Tap = TapRecognizer;
	  Hammer.Pan = PanRecognizer;
	  Hammer.Swipe = SwipeRecognizer;
	  Hammer.Pinch = PinchRecognizer;
	  Hammer.Rotate = RotateRecognizer;
	  Hammer.Press = PressRecognizer;
	  Hammer.on = addEventListeners;
	  Hammer.off = removeEventListeners;
	  Hammer.each = each;
	  Hammer.merge = merge$1;
	  Hammer.extend = extend$1;
	  Hammer.bindFn = bindFn;
	  Hammer.assign = assign$1$1;
	  Hammer.inherit = inherit;
	  Hammer.bindFn = bindFn;
	  Hammer.prefixed = prefixed;
	  Hammer.toArray = toArray$1;
	  Hammer.inArray = inArray;
	  Hammer.uniqueArray = uniqueArray;
	  Hammer.splitStr = splitStr;
	  Hammer.boolOrFn = boolOrFn;
	  Hammer.hasParent = hasParent$1;
	  Hammer.addEventListeners = addEventListeners;
	  Hammer.removeEventListeners = removeEventListeners;
	  Hammer.defaults = assign$1$1({}, defaults, {
	    preset: preset
	  });
	  return Hammer;
	}(); //  style loader but by script tag, not by the loader.

	var hammer = createCommonjsModule(function (module) {
	  /**
	   * Setup a mock hammer.js object, for unit testing.
	   *
	   * Inspiration: https://github.com/uber/deck.gl/pull/658
	   *
	   * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
	   */
	  function hammerMock() {
	    var noop = function noop() {};

	    return {
	      on: noop,
	      off: noop,
	      destroy: noop,
	      emit: noop,
	      get: function get(m) {
	        //eslint-disable-line no-unused-vars
	        return {
	          set: noop
	        };
	      }
	    };
	  }

	  if (typeof window !== 'undefined') {
	    var Hammer$1 = window['Hammer'] || Hammer;
	    module.exports = Hammer$1;
	  } else {
	    module.exports = function () {
	      // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
	      return hammerMock();
	    };
	  }
	});

	var visUtil_min = createCommonjsModule(function (module, exports) {
	  /**
	   * vis-util
	   * https://github.com/visjs/vis-util
	   *
	   * utilitie collection for visjs
	   *
	   * @version 4.0.0
	   * @date    2020-02-29T15:35:13.178Z
	   *
	   * @copyright (c) 2011-2017 Almende B.V, http://almende.com
	   * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
	   *
	   * @license
	   * vis.js is dual licensed under both
	   *
	   *   1. The Apache 2.0 License
	   *      http://www.apache.org/licenses/LICENSE-2.0
	   *
	   *   and
	   *
	   *   2. The MIT License
	   *      http://opensource.org/licenses/MIT
	   *
	   * vis.js may be distributed under either license.
	   */
	  !function (t, r) {
	     r(exports) ;
	  }(commonjsGlobal, function (t) {

	    var r = "undefined" != typeof globalThis ? globalThis : "undefined" != typeof window ? window : "undefined" != typeof commonjsGlobal ? commonjsGlobal : "undefined" != typeof self ? self : {};

	    function e(t, r) {
	      return t(r = {
	        exports: {}
	      }, r.exports), r.exports;
	    }

	    function n(t) {
	      return t && t.default || t;
	    }

	    var o = function (t) {
	      return t && t.Math == Math && t;
	    },
	        i = o("object" == typeof globalThis && globalThis) || o("object" == typeof window && window) || o("object" == typeof self && self) || o("object" == typeof r && r) || Function("return this")(),
	        a = function (t) {
	      try {
	        return !!t();
	      } catch (t) {
	        return !0;
	      }
	    },
	        u = !a(function () {
	      return 7 != Object.defineProperty({}, 1, {
	        get: function () {
	          return 7;
	        }
	      })[1];
	    }),
	        c = {}.propertyIsEnumerable,
	        f = Object.getOwnPropertyDescriptor,
	        l = {
	      f: f && !c.call({
	        1: 2
	      }, 1) ? function (t) {
	        var r = f(this, t);
	        return !!r && r.enumerable;
	      } : c
	    },
	        s = function (t, r) {
	      return {
	        enumerable: !(1 & t),
	        configurable: !(2 & t),
	        writable: !(4 & t),
	        value: r
	      };
	    },
	        p = {}.toString,
	        v = function (t) {
	      return p.call(t).slice(8, -1);
	    },
	        h = "".split,
	        d = a(function () {
	      return !Object("z").propertyIsEnumerable(0);
	    }) ? function (t) {
	      return "String" == v(t) ? h.call(t, "") : Object(t);
	    } : Object,
	        y = function (t) {
	      if (null == t) throw TypeError("Can't call method on " + t);
	      return t;
	    },
	        g = function (t) {
	      return d(y(t));
	    },
	        b = function (t) {
	      return "object" == typeof t ? null !== t : "function" == typeof t;
	    },
	        m = function (t, r) {
	      if (!b(t)) return t;
	      var e, n;
	      if (r && "function" == typeof (e = t.toString) && !b(n = e.call(t))) return n;
	      if ("function" == typeof (e = t.valueOf) && !b(n = e.call(t))) return n;
	      if (!r && "function" == typeof (e = t.toString) && !b(n = e.call(t))) return n;
	      throw TypeError("Can't convert object to primitive value");
	    },
	        O = {}.hasOwnProperty,
	        w = function (t, r) {
	      return O.call(t, r);
	    },
	        S = i.document,
	        j = b(S) && b(S.createElement),
	        A = function (t) {
	      return j ? S.createElement(t) : {};
	    },
	        x = !u && !a(function () {
	      return 7 != Object.defineProperty(A("div"), "a", {
	        get: function () {
	          return 7;
	        }
	      }).a;
	    }),
	        E = Object.getOwnPropertyDescriptor,
	        P = {
	      f: u ? E : function (t, r) {
	        if (t = g(t), r = m(r, !0), x) try {
	          return E(t, r);
	        } catch (t) {}
	        if (w(t, r)) return s(!l.f.call(t, r), t[r]);
	      }
	    },
	        T = /#|\.prototype\./,
	        k = function (t, r) {
	      var e = C[M(t)];
	      return e == I || e != L && ("function" == typeof r ? a(r) : !!r);
	    },
	        M = k.normalize = function (t) {
	      return String(t).replace(T, ".").toLowerCase();
	    },
	        C = k.data = {},
	        L = k.NATIVE = "N",
	        I = k.POLYFILL = "P",
	        N = k,
	        D = {},
	        _ = function (t, r, e) {
	      if (function (t) {
	        if ("function" != typeof t) throw TypeError(String(t) + " is not a function");
	      }(t), void 0 === r) return t;

	      switch (e) {
	        case 0:
	          return function () {
	            return t.call(r);
	          };

	        case 1:
	          return function (e) {
	            return t.call(r, e);
	          };

	        case 2:
	          return function (e, n) {
	            return t.call(r, e, n);
	          };

	        case 3:
	          return function (e, n, o) {
	            return t.call(r, e, n, o);
	          };
	      }

	      return function () {
	        return t.apply(r, arguments);
	      };
	    },
	        R = function (t) {
	      if (!b(t)) throw TypeError(String(t) + " is not an object");
	      return t;
	    },
	        F = Object.defineProperty,
	        B = {
	      f: u ? F : function (t, r, e) {
	        if (R(t), r = m(r, !0), R(e), x) try {
	          return F(t, r, e);
	        } catch (t) {}
	        if ("get" in e || "set" in e) throw TypeError("Accessors not supported");
	        return "value" in e && (t[r] = e.value), t;
	      }
	    },
	        G = u ? function (t, r, e) {
	      return B.f(t, r, s(1, e));
	    } : function (t, r, e) {
	      return t[r] = e, t;
	    },
	        V = P.f,
	        H = function (t) {
	      var r = function (r, e, n) {
	        if (this instanceof t) {
	          switch (arguments.length) {
	            case 0:
	              return new t();

	            case 1:
	              return new t(r);

	            case 2:
	              return new t(r, e);
	          }

	          return new t(r, e, n);
	        }

	        return t.apply(this, arguments);
	      };

	      return r.prototype = t.prototype, r;
	    },
	        Q = function (t, r) {
	      var e,
	          n,
	          o,
	          a,
	          u,
	          c,
	          f,
	          l,
	          s = t.target,
	          p = t.global,
	          v = t.stat,
	          h = t.proto,
	          d = p ? i : v ? i[s] : (i[s] || {}).prototype,
	          y = p ? D : D[s] || (D[s] = {}),
	          g = y.prototype;

	      for (o in r) e = !N(p ? o : s + (v ? "." : "#") + o, t.forced) && d && w(d, o), u = y[o], e && (c = t.noTargetGet ? (l = V(d, o)) && l.value : d[o]), a = e && c ? c : r[o], e && typeof u == typeof a || (f = t.bind && e ? _(a, i) : t.wrap && e ? H(a) : h && "function" == typeof a ? _(Function.call, a) : a, (t.sham || a && a.sham || u && u.sham) && G(f, "sham", !0), y[o] = f, h && (w(D, n = s + "Prototype") || G(D, n, {}), D[n][o] = a, t.real && g && !g[o] && G(g, o, a)));
	    },
	        W = Array.isArray || function (t) {
	      return "Array" == v(t);
	    };

	    Q({
	      target: "Array",
	      stat: !0
	    }, {
	      isArray: W
	    });
	    var z = D.Array.isArray,
	        $ = z;

	    var q = function (t) {
	      if ($(t)) return t;
	    },
	        J = {},
	        U = i["__core-js_shared__"] || function (t, r) {
	      try {
	        G(i, t, r);
	      } catch (e) {
	        i[t] = r;
	      }

	      return r;
	    }("__core-js_shared__", {}),
	        Y = Function.toString;

	    "function" != typeof U.inspectSource && (U.inspectSource = function (t) {
	      return Y.call(t);
	    });

	    var X,
	        K,
	        Z,
	        tt = U.inspectSource,
	        rt = i.WeakMap,
	        et = "function" == typeof rt && /native code/.test(tt(rt)),
	        nt = e(function (t) {
	      (t.exports = function (t, r) {
	        return U[t] || (U[t] = void 0 !== r ? r : {});
	      })("versions", []).push({
	        version: "3.6.4",
	        mode: "pure",
	        copyright: "© 2020 Denis Pushkarev (zloirock.ru)"
	      });
	    }),
	        ot = 0,
	        it = Math.random(),
	        at = function (t) {
	      return "Symbol(" + String(void 0 === t ? "" : t) + ")_" + (++ot + it).toString(36);
	    },
	        ut = nt("keys"),
	        ct = function (t) {
	      return ut[t] || (ut[t] = at(t));
	    },
	        ft = {},
	        lt = i.WeakMap;

	    if (et) {
	      var st = new lt(),
	          pt = st.get,
	          vt = st.has,
	          ht = st.set;
	      X = function (t, r) {
	        return ht.call(st, t, r), r;
	      }, K = function (t) {
	        return pt.call(st, t) || {};
	      }, Z = function (t) {
	        return vt.call(st, t);
	      };
	    } else {
	      var dt = ct("state");
	      ft[dt] = !0, X = function (t, r) {
	        return G(t, dt, r), r;
	      }, K = function (t) {
	        return w(t, dt) ? t[dt] : {};
	      }, Z = function (t) {
	        return w(t, dt);
	      };
	    }

	    var yt,
	        gt,
	        bt,
	        mt = {
	      set: X,
	      get: K,
	      has: Z,
	      enforce: function (t) {
	        return Z(t) ? K(t) : X(t, {});
	      },
	      getterFor: function (t) {
	        return function (r) {
	          var e;
	          if (!b(r) || (e = K(r)).type !== t) throw TypeError("Incompatible receiver, " + t + " required");
	          return e;
	        };
	      }
	    },
	        Ot = function (t) {
	      return Object(y(t));
	    },
	        wt = !a(function () {
	      function t() {}

	      return t.prototype.constructor = null, Object.getPrototypeOf(new t()) !== t.prototype;
	    }),
	        St = ct("IE_PROTO"),
	        jt = Object.prototype,
	        At = wt ? Object.getPrototypeOf : function (t) {
	      return t = Ot(t), w(t, St) ? t[St] : "function" == typeof t.constructor && t instanceof t.constructor ? t.constructor.prototype : t instanceof Object ? jt : null;
	    },
	        xt = !!Object.getOwnPropertySymbols && !a(function () {
	      return !String(Symbol());
	    }),
	        Et = xt && !Symbol.sham && "symbol" == typeof Symbol.iterator,
	        Pt = nt("wks"),
	        Tt = i.Symbol,
	        kt = Et ? Tt : Tt && Tt.withoutSetter || at,
	        Mt = function (t) {
	      return w(Pt, t) || (xt && w(Tt, t) ? Pt[t] = Tt[t] : Pt[t] = kt("Symbol." + t)), Pt[t];
	    },
	        Ct = (Mt("iterator"), !1);

	    [].keys && ("next" in (bt = [].keys()) ? (gt = At(At(bt))) !== Object.prototype && (yt = gt) : Ct = !0), null == yt && (yt = {});

	    var Lt,
	        It = {
	      IteratorPrototype: yt,
	      BUGGY_SAFARI_ITERATORS: Ct
	    },
	        Nt = Math.ceil,
	        Dt = Math.floor,
	        _t = function (t) {
	      return isNaN(t = +t) ? 0 : (t > 0 ? Dt : Nt)(t);
	    },
	        Rt = Math.min,
	        Ft = function (t) {
	      return t > 0 ? Rt(_t(t), 9007199254740991) : 0;
	    },
	        Bt = Math.max,
	        Gt = Math.min,
	        Vt = function (t, r) {
	      var e = _t(t);

	      return e < 0 ? Bt(e + r, 0) : Gt(e, r);
	    },
	        Ht = function (t) {
	      return function (r, e, n) {
	        var o,
	            i = g(r),
	            a = Ft(i.length),
	            u = Vt(n, a);

	        if (t && e != e) {
	          for (; a > u;) if ((o = i[u++]) != o) return !0;
	        } else for (; a > u; u++) if ((t || u in i) && i[u] === e) return t || u || 0;

	        return !t && -1;
	      };
	    },
	        Qt = {
	      includes: Ht(!0),
	      indexOf: Ht(!1)
	    },
	        Wt = Qt.indexOf,
	        zt = function (t, r) {
	      var e,
	          n = g(t),
	          o = 0,
	          i = [];

	      for (e in n) !w(ft, e) && w(n, e) && i.push(e);

	      for (; r.length > o;) w(n, e = r[o++]) && (~Wt(i, e) || i.push(e));

	      return i;
	    },
	        $t = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"],
	        qt = Object.keys || function (t) {
	      return zt(t, $t);
	    },
	        Jt = u ? Object.defineProperties : function (t, r) {
	      R(t);

	      for (var e, n = qt(r), o = n.length, i = 0; o > i;) B.f(t, e = n[i++], r[e]);

	      return t;
	    },
	        Ut = function (t) {
	      return "function" == typeof t ? t : void 0;
	    },
	        Yt = function (t, r) {
	      return arguments.length < 2 ? Ut(D[t]) || Ut(i[t]) : D[t] && D[t][r] || i[t] && i[t][r];
	    },
	        Xt = Yt("document", "documentElement"),
	        Kt = ct("IE_PROTO"),
	        Zt = function () {},
	        tr = function (t) {
	      return "<script>" + t + "<\/script>";
	    },
	        rr = function () {
	      try {
	        Lt = document.domain && new ActiveXObject("htmlfile");
	      } catch (t) {}

	      var t, r;
	      rr = Lt ? function (t) {
	        t.write(tr("")), t.close();
	        var r = t.parentWindow.Object;
	        return t = null, r;
	      }(Lt) : ((r = A("iframe")).style.display = "none", Xt.appendChild(r), r.src = String("javascript:"), (t = r.contentWindow.document).open(), t.write(tr("document.F=Object")), t.close(), t.F);

	      for (var e = $t.length; e--;) delete rr.prototype[$t[e]];

	      return rr();
	    };

	    ft[Kt] = !0;

	    var er = Object.create || function (t, r) {
	      var e;
	      return null !== t ? (Zt.prototype = R(t), e = new Zt(), Zt.prototype = null, e[Kt] = t) : e = rr(), void 0 === r ? e : Jt(e, r);
	    },
	        nr = {};

	    nr[Mt("toStringTag")] = "z";

	    var or = "[object z]" === String(nr),
	        ir = Mt("toStringTag"),
	        ar = "Arguments" == v(function () {
	      return arguments;
	    }()),
	        ur = or ? v : function (t) {
	      var r, e, n;
	      return void 0 === t ? "Undefined" : null === t ? "Null" : "string" == typeof (e = function (t, r) {
	        try {
	          return t[r];
	        } catch (t) {}
	      }(r = Object(t), ir)) ? e : ar ? v(r) : "Object" == (n = v(r)) && "function" == typeof r.callee ? "Arguments" : n;
	    },
	        cr = or ? {}.toString : function () {
	      return "[object " + ur(this) + "]";
	    },
	        fr = B.f,
	        lr = Mt("toStringTag"),
	        sr = function (t, r, e, n) {
	      if (t) {
	        var o = e ? t : t.prototype;
	        w(o, lr) || fr(o, lr, {
	          configurable: !0,
	          value: r
	        }), n && !or && G(o, "toString", cr);
	      }
	    },
	        pr = It.IteratorPrototype,
	        vr = function () {
	      return this;
	    },
	        hr = (Object.setPrototypeOf || "__proto__" in {} && function () {
	      var t,
	          r = !1,
	          e = {};

	      try {
	        (t = Object.getOwnPropertyDescriptor(Object.prototype, "__proto__").set).call(e, []), r = e instanceof Array;
	      } catch (t) {}
	    }(), function (t, r, e, n) {
	      n && n.enumerable ? t[r] = e : G(t, r, e);
	    }),
	        dr = It.IteratorPrototype,
	        yr = It.BUGGY_SAFARI_ITERATORS,
	        gr = Mt("iterator"),
	        br = function () {
	      return this;
	    },
	        mr = function (t, r, e, n, o, i, a) {
	      !function (t, r, e) {
	        var n = r + " Iterator";
	        t.prototype = er(pr, {
	          next: s(1, e)
	        }), sr(t, n, !1, !0), J[n] = vr;
	      }(e, r, n);

	      var u,
	          c,
	          f,
	          l = function (t) {
	        if (t === o && y) return y;
	        if (!yr && t in h) return h[t];

	        switch (t) {
	          case "keys":
	          case "values":
	          case "entries":
	            return function () {
	              return new e(this, t);
	            };
	        }

	        return function () {
	          return new e(this);
	        };
	      },
	          p = r + " Iterator",
	          v = !1,
	          h = t.prototype,
	          d = h[gr] || h["@@iterator"] || o && h[o],
	          y = !yr && d || l(o),
	          g = "Array" == r && h.entries || d;

	      if (g && (u = At(g.call(new t())), dr !== Object.prototype && u.next && (sr(u, p, !0, !0), J[p] = br)), "values" == o && d && "values" !== d.name && (v = !0, y = function () {
	        return d.call(this);
	      }), a && h[gr] !== y && G(h, gr, y), J[r] = y, o) if (c = {
	        values: l("values"),
	        keys: i ? y : l("keys"),
	        entries: l("entries")
	      }, a) for (f in c) !yr && !v && f in h || hr(h, f, c[f]);else Q({
	        target: r,
	        proto: !0,
	        forced: yr || v
	      }, c);
	      return c;
	    },
	        Or = mt.set,
	        wr = mt.getterFor("Array Iterator");

	    mr(Array, "Array", function (t, r) {
	      Or(this, {
	        type: "Array Iterator",
	        target: g(t),
	        index: 0,
	        kind: r
	      });
	    }, function () {
	      var t = wr(this),
	          r = t.target,
	          e = t.kind,
	          n = t.index++;
	      return !r || n >= r.length ? (t.target = void 0, {
	        value: void 0,
	        done: !0
	      }) : "keys" == e ? {
	        value: n,
	        done: !1
	      } : "values" == e ? {
	        value: r[n],
	        done: !1
	      } : {
	        value: [n, r[n]],
	        done: !1
	      };
	    }, "values");
	    J.Arguments = J.Array;
	    var Sr = Mt("toStringTag");

	    for (var jr in {
	      CSSRuleList: 0,
	      CSSStyleDeclaration: 0,
	      CSSValueList: 0,
	      ClientRectList: 0,
	      DOMRectList: 0,
	      DOMStringList: 0,
	      DOMTokenList: 1,
	      DataTransferItemList: 0,
	      FileList: 0,
	      HTMLAllCollection: 0,
	      HTMLCollection: 0,
	      HTMLFormElement: 0,
	      HTMLSelectElement: 0,
	      MediaList: 0,
	      MimeTypeArray: 0,
	      NamedNodeMap: 0,
	      NodeList: 1,
	      PaintRequestList: 0,
	      Plugin: 0,
	      PluginArray: 0,
	      SVGLengthList: 0,
	      SVGNumberList: 0,
	      SVGPathSegList: 0,
	      SVGPointList: 0,
	      SVGStringList: 0,
	      SVGTransformList: 0,
	      SourceBufferList: 0,
	      StyleSheetList: 0,
	      TextTrackCueList: 0,
	      TextTrackList: 0,
	      TouchList: 0
	    }) {
	      var Ar = i[jr],
	          xr = Ar && Ar.prototype;
	      xr && ur(xr) !== Sr && G(xr, Sr, jr), J[jr] = J.Array;
	    }

	    var Er = function (t) {
	      return function (r, e) {
	        var n,
	            o,
	            i = String(y(r)),
	            a = _t(e),
	            u = i.length;

	        return a < 0 || a >= u ? t ? "" : void 0 : (n = i.charCodeAt(a)) < 55296 || n > 56319 || a + 1 === u || (o = i.charCodeAt(a + 1)) < 56320 || o > 57343 ? t ? i.charAt(a) : n : t ? i.slice(a, a + 2) : o - 56320 + (n - 55296 << 10) + 65536;
	      };
	    },
	        Pr = {
	      codeAt: Er(!1),
	      charAt: Er(!0)
	    }.charAt,
	        Tr = mt.set,
	        kr = mt.getterFor("String Iterator");

	    mr(String, "String", function (t) {
	      Tr(this, {
	        type: "String Iterator",
	        string: String(t),
	        index: 0
	      });
	    }, function () {
	      var t,
	          r = kr(this),
	          e = r.string,
	          n = r.index;
	      return n >= e.length ? {
	        value: void 0,
	        done: !0
	      } : (t = Pr(e, n), r.index += t.length, {
	        value: t,
	        done: !1
	      });
	    });

	    var Mr = Mt("iterator"),
	        Cr = function (t) {
	      if (null != t) return t[Mr] || t["@@iterator"] || J[ur(t)];
	    },
	        Lr = function (t) {
	      var r = Cr(t);
	      if ("function" != typeof r) throw TypeError(String(t) + " is not iterable");
	      return R(r.call(t));
	    },
	        Ir = Mt("iterator"),
	        Nr = function (t) {
	      var r = Object(t);
	      return void 0 !== r[Ir] || "@@iterator" in r || J.hasOwnProperty(ur(r));
	    };

	    var Dr = function (t, r) {
	      if (Nr(Object(t)) || "[object Arguments]" === Object.prototype.toString.call(t)) {
	        var e = [],
	            n = !0,
	            o = !1,
	            i = void 0;

	        try {
	          for (var a, u = Lr(t); !(n = (a = u.next()).done) && (e.push(a.value), !r || e.length !== r); n = !0);
	        } catch (t) {
	          o = !0, i = t;
	        } finally {
	          try {
	            n || null == u.return || u.return();
	          } finally {
	            if (o) throw i;
	          }
	        }

	        return e;
	      }
	    };

	    var _r = function () {
	      throw new TypeError("Invalid attempt to destructure non-iterable instance");
	    };

	    var Rr = function (t, r) {
	      return q(t) || Dr(t, r) || _r();
	    };

	    Q({
	      target: "Date",
	      stat: !0
	    }, {
	      now: function () {
	        return new Date().getTime();
	      }
	    });
	    var Fr = D.Date.now;

	    function Br(t) {
	      var r = function () {
	        for (var t = Gr(), r = t(" "), e = t(" "), n = t(" "), o = 0; o < arguments.length; o++) (r -= t(o < 0 || arguments.length <= o ? void 0 : arguments[o])) < 0 && (r += 1), (e -= t(o < 0 || arguments.length <= o ? void 0 : arguments[o])) < 0 && (e += 1), (n -= t(o < 0 || arguments.length <= o ? void 0 : arguments[o])) < 0 && (n += 1);

	        return [r, e, n];
	      }(t),
	          e = Rr(r, 3),
	          n = e[0],
	          o = e[1],
	          i = e[2],
	          a = 1,
	          u = function () {
	        var t = 2091639 * n + 2.3283064365386963e-10 * a;
	        return n = o, o = i, i = t - (a = 0 | t);
	      };

	      return u.uint32 = function () {
	        return 4294967296 * u();
	      }, u.fract53 = function () {
	        return u() + 11102230246251565e-32 * (2097152 * u() | 0);
	      }, u.algorithm = "Alea", u.seed = t, u.version = "0.9", u;
	    }

	    function Gr() {
	      var t = 4022871197;
	      return function (r) {
	        for (var e = r.toString(), n = 0; n < e.length; n++) {
	          var o = .02519603282416938 * (t += e.charCodeAt(n));
	          o -= t = o >>> 0, t = (o *= t) >>> 0, t += 4294967296 * (o -= t);
	        }

	        return 2.3283064365386963e-10 * (t >>> 0);
	      };
	    }

	    Q({
	      target: "Object",
	      stat: !0,
	      forced: !u,
	      sham: !u
	    }, {
	      defineProperty: B.f
	    });
	    var Vr = e(function (t) {
	      var r = D.Object,
	          e = t.exports = function (t, e, n) {
	        return r.defineProperty(t, e, n);
	      };

	      r.defineProperty.sham && (e.sham = !0);
	    }),
	        Hr = Vr;
	    Q({
	      target: "Object",
	      stat: !0,
	      forced: !u,
	      sham: !u
	    }, {
	      defineProperties: Jt
	    });

	    var Qr = e(function (t) {
	      var r = D.Object,
	          e = t.exports = function (t, e) {
	        return r.defineProperties(t, e);
	      };

	      r.defineProperties.sham && (e.sham = !0);
	    }),
	        Wr = $t.concat("length", "prototype"),
	        zr = {
	      f: Object.getOwnPropertyNames || function (t) {
	        return zt(t, Wr);
	      }
	    },
	        $r = {
	      f: Object.getOwnPropertySymbols
	    },
	        qr = Yt("Reflect", "ownKeys") || function (t) {
	      var r = zr.f(R(t)),
	          e = $r.f;
	      return e ? r.concat(e(t)) : r;
	    },
	        Jr = function (t, r, e) {
	      var n = m(r);
	      n in t ? B.f(t, n, s(0, e)) : t[n] = e;
	    };

	    Q({
	      target: "Object",
	      stat: !0,
	      sham: !u
	    }, {
	      getOwnPropertyDescriptors: function (t) {
	        for (var r, e, n = g(t), o = P.f, i = qr(n), a = {}, u = 0; i.length > u;) void 0 !== (e = o(n, r = i[u++])) && Jr(a, r, e);

	        return a;
	      }
	    });
	    var Ur = D.Object.getOwnPropertyDescriptors,
	        Yr = P.f,
	        Xr = a(function () {
	      Yr(1);
	    });
	    Q({
	      target: "Object",
	      stat: !0,
	      forced: !u || Xr,
	      sham: !u
	    }, {
	      getOwnPropertyDescriptor: function (t, r) {
	        return Yr(g(t), r);
	      }
	    });

	    var Kr = e(function (t) {
	      var r = D.Object,
	          e = t.exports = function (t, e) {
	        return r.getOwnPropertyDescriptor(t, e);
	      };

	      r.getOwnPropertyDescriptor.sham && (e.sham = !0);
	    }),
	        Zr = zr.f,
	        te = {}.toString,
	        re = "object" == typeof window && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [],
	        ee = {
	      f: function (t) {
	        return re && "[object Window]" == te.call(t) ? function (t) {
	          try {
	            return Zr(t);
	          } catch (t) {
	            return re.slice();
	          }
	        }(t) : Zr(g(t));
	      }
	    },
	        ne = {
	      f: Mt
	    },
	        oe = B.f,
	        ie = function (t) {
	      var r = D.Symbol || (D.Symbol = {});
	      w(r, t) || oe(r, t, {
	        value: ne.f(t)
	      });
	    },
	        ae = Mt("species"),
	        ue = function (t, r) {
	      var e;
	      return W(t) && ("function" != typeof (e = t.constructor) || e !== Array && !W(e.prototype) ? b(e) && null === (e = e[ae]) && (e = void 0) : e = void 0), new (void 0 === e ? Array : e)(0 === r ? 0 : r);
	    },
	        ce = [].push,
	        fe = function (t) {
	      var r = 1 == t,
	          e = 2 == t,
	          n = 3 == t,
	          o = 4 == t,
	          i = 6 == t,
	          a = 5 == t || i;
	      return function (u, c, f, l) {
	        for (var s, p, v = Ot(u), h = d(v), y = _(c, f, 3), g = Ft(h.length), b = 0, m = l || ue, O = r ? m(u, g) : e ? m(u, 0) : void 0; g > b; b++) if ((a || b in h) && (p = y(s = h[b], b, v), t)) if (r) O[b] = p;else if (p) switch (t) {
	          case 3:
	            return !0;

	          case 5:
	            return s;

	          case 6:
	            return b;

	          case 2:
	            ce.call(O, s);
	        } else if (o) return !1;

	        return i ? -1 : n || o ? o : O;
	      };
	    },
	        le = {
	      forEach: fe(0),
	      map: fe(1),
	      filter: fe(2),
	      some: fe(3),
	      every: fe(4),
	      find: fe(5),
	      findIndex: fe(6)
	    },
	        se = le.forEach,
	        pe = ct("hidden"),
	        ve = Mt("toPrimitive"),
	        he = mt.set,
	        de = mt.getterFor("Symbol"),
	        ye = Object.prototype,
	        ge = i.Symbol,
	        be = Yt("JSON", "stringify"),
	        me = P.f,
	        Oe = B.f,
	        we = ee.f,
	        Se = l.f,
	        je = nt("symbols"),
	        Ae = nt("op-symbols"),
	        xe = nt("string-to-symbol-registry"),
	        Ee = nt("symbol-to-string-registry"),
	        Pe = nt("wks"),
	        Te = i.QObject,
	        ke = !Te || !Te.prototype || !Te.prototype.findChild,
	        Me = u && a(function () {
	      return 7 != er(Oe({}, "a", {
	        get: function () {
	          return Oe(this, "a", {
	            value: 7
	          }).a;
	        }
	      })).a;
	    }) ? function (t, r, e) {
	      var n = me(ye, r);
	      n && delete ye[r], Oe(t, r, e), n && t !== ye && Oe(ye, r, n);
	    } : Oe,
	        Ce = function (t, r) {
	      var e = je[t] = er(ge.prototype);
	      return he(e, {
	        type: "Symbol",
	        tag: t,
	        description: r
	      }), u || (e.description = r), e;
	    },
	        Le = Et ? function (t) {
	      return "symbol" == typeof t;
	    } : function (t) {
	      return Object(t) instanceof ge;
	    },
	        Ie = function (t, r, e) {
	      t === ye && Ie(Ae, r, e), R(t);
	      var n = m(r, !0);
	      return R(e), w(je, n) ? (e.enumerable ? (w(t, pe) && t[pe][n] && (t[pe][n] = !1), e = er(e, {
	        enumerable: s(0, !1)
	      })) : (w(t, pe) || Oe(t, pe, s(1, {})), t[pe][n] = !0), Me(t, n, e)) : Oe(t, n, e);
	    },
	        Ne = function (t, r) {
	      R(t);
	      var e = g(r),
	          n = qt(e).concat(Fe(e));
	      return se(n, function (r) {
	        u && !De.call(e, r) || Ie(t, r, e[r]);
	      }), t;
	    },
	        De = function (t) {
	      var r = m(t, !0),
	          e = Se.call(this, r);
	      return !(this === ye && w(je, r) && !w(Ae, r)) && (!(e || !w(this, r) || !w(je, r) || w(this, pe) && this[pe][r]) || e);
	    },
	        _e = function (t, r) {
	      var e = g(t),
	          n = m(r, !0);

	      if (e !== ye || !w(je, n) || w(Ae, n)) {
	        var o = me(e, n);
	        return !o || !w(je, n) || w(e, pe) && e[pe][n] || (o.enumerable = !0), o;
	      }
	    },
	        Re = function (t) {
	      var r = we(g(t)),
	          e = [];
	      return se(r, function (t) {
	        w(je, t) || w(ft, t) || e.push(t);
	      }), e;
	    },
	        Fe = function (t) {
	      var r = t === ye,
	          e = we(r ? Ae : g(t)),
	          n = [];
	      return se(e, function (t) {
	        !w(je, t) || r && !w(ye, t) || n.push(je[t]);
	      }), n;
	    };

	    if (xt || (hr((ge = function () {
	      if (this instanceof ge) throw TypeError("Symbol is not a constructor");

	      var t = arguments.length && void 0 !== arguments[0] ? String(arguments[0]) : void 0,
	          r = at(t),
	          e = function (t) {
	        this === ye && e.call(Ae, t), w(this, pe) && w(this[pe], r) && (this[pe][r] = !1), Me(this, r, s(1, t));
	      };

	      return u && ke && Me(ye, r, {
	        configurable: !0,
	        set: e
	      }), Ce(r, t);
	    }).prototype, "toString", function () {
	      return de(this).tag;
	    }), hr(ge, "withoutSetter", function (t) {
	      return Ce(at(t), t);
	    }), l.f = De, B.f = Ie, P.f = _e, zr.f = ee.f = Re, $r.f = Fe, ne.f = function (t) {
	      return Ce(Mt(t), t);
	    }, u && Oe(ge.prototype, "description", {
	      configurable: !0,
	      get: function () {
	        return de(this).description;
	      }
	    })), Q({
	      global: !0,
	      wrap: !0,
	      forced: !xt,
	      sham: !xt
	    }, {
	      Symbol: ge
	    }), se(qt(Pe), function (t) {
	      ie(t);
	    }), Q({
	      target: "Symbol",
	      stat: !0,
	      forced: !xt
	    }, {
	      for: function (t) {
	        var r = String(t);
	        if (w(xe, r)) return xe[r];
	        var e = ge(r);
	        return xe[r] = e, Ee[e] = r, e;
	      },
	      keyFor: function (t) {
	        if (!Le(t)) throw TypeError(t + " is not a symbol");
	        if (w(Ee, t)) return Ee[t];
	      },
	      useSetter: function () {
	        ke = !0;
	      },
	      useSimple: function () {
	        ke = !1;
	      }
	    }), Q({
	      target: "Object",
	      stat: !0,
	      forced: !xt,
	      sham: !u
	    }, {
	      create: function (t, r) {
	        return void 0 === r ? er(t) : Ne(er(t), r);
	      },
	      defineProperty: Ie,
	      defineProperties: Ne,
	      getOwnPropertyDescriptor: _e
	    }), Q({
	      target: "Object",
	      stat: !0,
	      forced: !xt
	    }, {
	      getOwnPropertyNames: Re,
	      getOwnPropertySymbols: Fe
	    }), Q({
	      target: "Object",
	      stat: !0,
	      forced: a(function () {
	        $r.f(1);
	      })
	    }, {
	      getOwnPropertySymbols: function (t) {
	        return $r.f(Ot(t));
	      }
	    }), be) {
	      var Be = !xt || a(function () {
	        var t = ge();
	        return "[null]" != be([t]) || "{}" != be({
	          a: t
	        }) || "{}" != be(Object(t));
	      });
	      Q({
	        target: "JSON",
	        stat: !0,
	        forced: Be
	      }, {
	        stringify: function (t, r, e) {
	          for (var n, o = [t], i = 1; arguments.length > i;) o.push(arguments[i++]);

	          if (n = r, (b(r) || void 0 !== t) && !Le(t)) return W(r) || (r = function (t, r) {
	            if ("function" == typeof n && (r = n.call(this, t, r)), !Le(r)) return r;
	          }), o[1] = r, be.apply(null, o);
	        }
	      });
	    }

	    ge.prototype[ve] || G(ge.prototype, ve, ge.prototype.valueOf), sr(ge, "Symbol"), ft[pe] = !0;
	    var Ge = D.Object.getOwnPropertySymbols;
	    Q({
	      target: "Object",
	      stat: !0,
	      sham: !u
	    }, {
	      create: er
	    });

	    var Ve = D.Object,
	        He = function (t, r) {
	      return Ve.create(t, r);
	    },
	        Qe = Vr;

	    var We = function (t, r, e) {
	      return r in t ? Qe(t, r, {
	        value: e,
	        enumerable: !0,
	        configurable: !0,
	        writable: !0
	      }) : t[r] = e, t;
	    },
	        ze = a(function () {
	      qt(1);
	    });

	    Q({
	      target: "Object",
	      stat: !0,
	      forced: ze
	    }, {
	      keys: function (t) {
	        return qt(Ot(t));
	      }
	    });

	    var $e,
	        qe = D.Object.keys,
	        Je = "\t\n\v\f\r                　\u2028\u2029\ufeff",
	        Ue = "[" + Je + "]",
	        Ye = RegExp("^" + Ue + Ue + "*"),
	        Xe = RegExp(Ue + Ue + "*$"),
	        Ke = function (t) {
	      return function (r) {
	        var e = String(y(r));
	        return 1 & t && (e = e.replace(Ye, "")), 2 & t && (e = e.replace(Xe, "")), e;
	      };
	    },
	        Ze = {
	      start: Ke(1),
	      end: Ke(2),
	      trim: Ke(3)
	    },
	        tn = Ze.trim;

	    Q({
	      target: "String",
	      proto: !0,
	      forced: ($e = "trim", a(function () {
	        return !!Je[$e]() || "​᠎" != "​᠎"[$e]() || Je[$e].name !== $e;
	      }))
	    }, {
	      trim: function () {
	        return tn(this);
	      }
	    });

	    var rn = function (t) {
	      return D[t + "Prototype"];
	    },
	        en = rn("String").trim,
	        nn = String.prototype,
	        on = function (t) {
	      var r = t.trim;
	      return "string" == typeof t || t === nn || t instanceof String && r === nn.trim ? en : r;
	    },
	        an = function (t, r) {
	      var e = [][t];
	      return !!e && a(function () {
	        e.call(null, r || function () {
	          throw 1;
	        }, 1);
	      });
	    },
	        un = Object.defineProperty,
	        cn = {},
	        fn = function (t) {
	      throw t;
	    },
	        ln = function (t, r) {
	      if (w(cn, t)) return cn[t];
	      r || (r = {});
	      var e = [][t],
	          n = !!w(r, "ACCESSORS") && r.ACCESSORS,
	          o = w(r, 0) ? r[0] : fn,
	          i = w(r, 1) ? r[1] : void 0;
	      return cn[t] = !!e && !a(function () {
	        if (n && !u) return !0;
	        var t = {
	          length: -1
	        };
	        n ? un(t, 1, {
	          enumerable: !0,
	          get: fn
	        }) : t[1] = 1, e.call(t, o, i);
	      });
	    },
	        sn = le.forEach,
	        pn = an("forEach"),
	        vn = ln("forEach"),
	        hn = pn && vn ? [].forEach : function (t) {
	      return sn(this, t, arguments.length > 1 ? arguments[1] : void 0);
	    };

	    Q({
	      target: "Array",
	      proto: !0,
	      forced: [].forEach != hn
	    }, {
	      forEach: hn
	    });

	    var dn,
	        yn,
	        gn = rn("Array").forEach,
	        bn = Array.prototype,
	        mn = {
	      DOMTokenList: !0,
	      NodeList: !0
	    },
	        On = function (t) {
	      var r = t.forEach;
	      return t === bn || t instanceof Array && r === bn.forEach || mn.hasOwnProperty(ur(t)) ? gn : r;
	    },
	        wn = Yt("navigator", "userAgent") || "",
	        Sn = i.process,
	        jn = Sn && Sn.versions,
	        An = jn && jn.v8;

	    An ? yn = (dn = An.split("."))[0] + dn[1] : wn && (!(dn = wn.match(/Edge\/(\d+)/)) || dn[1] >= 74) && (dn = wn.match(/Chrome\/(\d+)/)) && (yn = dn[1]);

	    var xn = yn && +yn,
	        En = Mt("species"),
	        Pn = function (t) {
	      return xn >= 51 || !a(function () {
	        var r = [];
	        return (r.constructor = {})[En] = function () {
	          return {
	            foo: 1
	          };
	        }, 1 !== r[t](Boolean).foo;
	      });
	    },
	        Tn = le.map,
	        kn = Pn("map"),
	        Mn = ln("map");

	    Q({
	      target: "Array",
	      proto: !0,
	      forced: !kn || !Mn
	    }, {
	      map: function (t) {
	        return Tn(this, t, arguments.length > 1 ? arguments[1] : void 0);
	      }
	    });

	    var Cn = rn("Array").map,
	        Ln = Array.prototype,
	        In = function (t) {
	      var r = t.map;
	      return t === Ln || t instanceof Array && r === Ln.map ? Cn : r;
	    },
	        Nn = Ze.trim,
	        Dn = i.parseInt,
	        _n = /^[+-]?0[Xx]/,
	        Rn = 8 !== Dn(Je + "08") || 22 !== Dn(Je + "0x16") ? function (t, r) {
	      var e = Nn(String(t));
	      return Dn(e, r >>> 0 || (_n.test(e) ? 16 : 10));
	    } : Dn;

	    Q({
	      global: !0,
	      forced: parseInt != Rn
	    }, {
	      parseInt: Rn
	    });

	    var Fn = D.parseInt,
	        Bn = l.f,
	        Gn = function (t) {
	      return function (r) {
	        for (var e, n = g(r), o = qt(n), i = o.length, a = 0, c = []; i > a;) e = o[a++], u && !Bn.call(n, e) || c.push(t ? [e, n[e]] : n[e]);

	        return c;
	      };
	    },
	        Vn = {
	      entries: Gn(!0),
	      values: Gn(!1)
	    }.values;

	    Q({
	      target: "Object",
	      stat: !0
	    }, {
	      values: function (t) {
	        return Vn(t);
	      }
	    });
	    var Hn = D.Object.values,
	        Qn = le.filter,
	        Wn = Pn("filter"),
	        zn = ln("filter");
	    Q({
	      target: "Array",
	      proto: !0,
	      forced: !Wn || !zn
	    }, {
	      filter: function (t) {
	        return Qn(this, t, arguments.length > 1 ? arguments[1] : void 0);
	      }
	    });

	    var $n = rn("Array").filter,
	        qn = Array.prototype,
	        Jn = function (t) {
	      var r = t.filter;
	      return t === qn || t instanceof Array && r === qn.filter ? $n : r;
	    },
	        Un = Mt("isConcatSpreadable"),
	        Yn = xn >= 51 || !a(function () {
	      var t = [];
	      return t[Un] = !1, t.concat()[0] !== t;
	    }),
	        Xn = Pn("concat"),
	        Kn = function (t) {
	      if (!b(t)) return !1;
	      var r = t[Un];
	      return void 0 !== r ? !!r : W(t);
	    };

	    Q({
	      target: "Array",
	      proto: !0,
	      forced: !Yn || !Xn
	    }, {
	      concat: function (t) {
	        var r,
	            e,
	            n,
	            o,
	            i,
	            a = Ot(this),
	            u = ue(a, 0),
	            c = 0;

	        for (r = -1, n = arguments.length; r < n; r++) if (i = -1 === r ? a : arguments[r], Kn(i)) {
	          if (c + (o = Ft(i.length)) > 9007199254740991) throw TypeError("Maximum allowed index exceeded");

	          for (e = 0; e < o; e++, c++) e in i && Jr(u, c, i[e]);
	        } else {
	          if (c >= 9007199254740991) throw TypeError("Maximum allowed index exceeded");
	          Jr(u, c++, i);
	        }

	        return u.length = c, u;
	      }
	    });

	    var Zn = rn("Array").concat,
	        to = Array.prototype,
	        ro = function (t) {
	      var r = t.concat;
	      return t === to || t instanceof Array && r === to.concat ? Zn : r;
	    };

	    var eo = function (t) {
	      if ($(t)) {
	        for (var r = 0, e = new Array(t.length); r < t.length; r++) e[r] = t[r];

	        return e;
	      }
	    },
	        no = function (t, r, e, n) {
	      try {
	        return n ? r(R(e)[0], e[1]) : r(e);
	      } catch (r) {
	        var o = t.return;
	        throw void 0 !== o && R(o.call(t)), r;
	      }
	    },
	        oo = Mt("iterator"),
	        io = Array.prototype,
	        ao = function (t) {
	      return void 0 !== t && (J.Array === t || io[oo] === t);
	    },
	        uo = Mt("iterator"),
	        co = !1;

	    try {
	      var fo = 0,
	          lo = {
	        next: function () {
	          return {
	            done: !!fo++
	          };
	        },
	        return: function () {
	          co = !0;
	        }
	      };
	      lo[uo] = function () {
	        return this;
	      }, Array.from(lo, function () {
	        throw 2;
	      });
	    } catch (t) {}

	    var so = !function (t, r) {
	      if (!r && !co) return !1;
	      var e = !1;

	      try {
	        var n = {};
	        n[uo] = function () {
	          return {
	            next: function () {
	              return {
	                done: e = !0
	              };
	            }
	          };
	        }, t(n);
	      } catch (t) {}

	      return e;
	    }(function (t) {
	      Array.from(t);
	    });
	    Q({
	      target: "Array",
	      stat: !0,
	      forced: so
	    }, {
	      from: function (t) {
	        var r,
	            e,
	            n,
	            o,
	            i,
	            a,
	            u = Ot(t),
	            c = "function" == typeof this ? this : Array,
	            f = arguments.length,
	            l = f > 1 ? arguments[1] : void 0,
	            s = void 0 !== l,
	            p = Cr(u),
	            v = 0;
	        if (s && (l = _(l, f > 2 ? arguments[2] : void 0, 2)), null == p || c == Array && ao(p)) for (e = new c(r = Ft(u.length)); r > v; v++) a = s ? l(u[v], v) : u[v], Jr(e, v, a);else for (i = (o = p.call(u)).next, e = new c(); !(n = i.call(o)).done; v++) a = s ? no(o, l, [n.value, v], !0) : n.value, Jr(e, v, a);
	        return e.length = v, e;
	      }
	    });
	    var po = D.Array.from;

	    var vo = function (t) {
	      if (Nr(Object(t)) || "[object Arguments]" === Object.prototype.toString.call(t)) return po(t);
	    };

	    var ho = function () {
	      throw new TypeError("Invalid attempt to spread non-iterable instance");
	    };

	    var yo = function (t) {
	      return eo(t) || vo(t) || ho();
	    },
	        go = Pn("slice"),
	        bo = ln("slice", {
	      ACCESSORS: !0,
	      0: 0,
	      1: 2
	    }),
	        mo = Mt("species"),
	        Oo = [].slice,
	        wo = Math.max;

	    Q({
	      target: "Array",
	      proto: !0,
	      forced: !go || !bo
	    }, {
	      slice: function (t, r) {
	        var e,
	            n,
	            o,
	            i = g(this),
	            a = Ft(i.length),
	            u = Vt(t, a),
	            c = Vt(void 0 === r ? a : r, a);
	        if (W(i) && ("function" != typeof (e = i.constructor) || e !== Array && !W(e.prototype) ? b(e) && null === (e = e[mo]) && (e = void 0) : e = void 0, e === Array || void 0 === e)) return Oo.call(i, u, c);

	        for (n = new (void 0 === e ? Array : e)(wo(c - u, 0)), o = 0; u < c; u++, o++) u in i && Jr(n, o, i[u]);

	        return n.length = o, n;
	      }
	    });

	    var So = rn("Array").slice,
	        jo = Array.prototype,
	        Ao = function (t) {
	      var r = t.slice;
	      return t === jo || t instanceof Array && r === jo.slice ? So : r;
	    },
	        xo = a(function () {
	      At(1);
	    });

	    Q({
	      target: "Object",
	      stat: !0,
	      forced: xo,
	      sham: !wt
	    }, {
	      getPrototypeOf: function (t) {
	        return At(Ot(t));
	      }
	    });
	    var Eo = D.Object.getPrototypeOf,
	        Po = Qt.indexOf,
	        To = [].indexOf,
	        ko = !!To && 1 / [1].indexOf(1, -0) < 0,
	        Mo = an("indexOf"),
	        Co = ln("indexOf", {
	      ACCESSORS: !0,
	      1: 0
	    });
	    Q({
	      target: "Array",
	      proto: !0,
	      forced: ko || !Mo || !Co
	    }, {
	      indexOf: function (t) {
	        return ko ? To.apply(this, arguments) || 0 : Po(this, t, arguments.length > 1 ? arguments[1] : void 0);
	      }
	    });

	    var Lo = rn("Array").indexOf,
	        Io = Array.prototype,
	        No = function (t) {
	      var r = t.indexOf;
	      return t === Io || t instanceof Array && r === Io.indexOf ? Lo : r;
	    },
	        Do = z,
	        _o = Object.assign,
	        Ro = Object.defineProperty,
	        Fo = !_o || a(function () {
	      if (u && 1 !== _o({
	        b: 1
	      }, _o(Ro({}, "a", {
	        enumerable: !0,
	        get: function () {
	          Ro(this, "b", {
	            value: 3,
	            enumerable: !1
	          });
	        }
	      }), {
	        b: 2
	      })).b) return !0;
	      var t = {},
	          r = {},
	          e = Symbol();
	      return t[e] = 7, "abcdefghijklmnopqrst".split("").forEach(function (t) {
	        r[t] = t;
	      }), 7 != _o({}, t)[e] || "abcdefghijklmnopqrst" != qt(_o({}, r)).join("");
	    }) ? function (t, r) {
	      for (var e = Ot(t), n = arguments.length, o = 1, i = $r.f, a = l.f; n > o;) for (var c, f = d(arguments[o++]), s = i ? qt(f).concat(i(f)) : qt(f), p = s.length, v = 0; p > v;) c = s[v++], u && !a.call(f, c) || (e[c] = f[c]);

	      return e;
	    } : _o;

	    Q({
	      target: "Object",
	      stat: !0,
	      forced: Object.assign !== Fo
	    }, {
	      assign: Fo
	    });
	    var Bo = D.Object.assign;
	    ie("iterator");
	    var Go = ne.f("iterator"),
	        Vo = Object.freeze({
	      __proto__: null
	    });
	    ie("asyncIterator");
	    var Ho = Object.freeze({
	      __proto__: null
	    });
	    ie("hasInstance"), ie("isConcatSpreadable"), ie("match"), ie("matchAll"), ie("replace"), ie("search"), ie("species"), ie("split"), ie("toPrimitive"), ie("toStringTag"), ie("unscopables"), sr(Math, "Math", !0), sr(i.JSON, "JSON", !0), n(Vo), n(Ho);
	    var Qo = D.Symbol;
	    ie("asyncDispose"), ie("dispose"), ie("observable"), ie("patternMatch"), ie("replaceAll");
	    var Wo = Qo,
	        zo = e(function (t) {
	      function r(e) {
	        return t.exports = r = "function" == typeof Wo && "symbol" == typeof Go ? function (t) {
	          return typeof t;
	        } : function (t) {
	          return t && "function" == typeof Wo && t.constructor === Wo && t !== Wo.prototype ? "symbol" : typeof t;
	        }, r(e);
	      }

	      t.exports = r;
	    });

	    function $o(t, r) {
	      var e = qe(t);

	      if (Ge) {
	        var n = Ge(t);
	        r && (n = Jn(n).call(n, function (r) {
	          return Kr(t, r).enumerable;
	        })), e.push.apply(e, n);
	      }

	      return e;
	    }

	    var qo = /^\/?Date\((-?\d+)/i,
	        Jo = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i,
	        Uo = /^#?([a-f\d])([a-f\d])([a-f\d])$/i,
	        Yo = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i,
	        Xo = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;

	    function Ko(t) {
	      return t instanceof Number || "number" == typeof t;
	    }

	    function Zo(t) {
	      return t instanceof String || "string" == typeof t;
	    }

	    function ti(t) {
	      return "object" === zo(t) && null !== t;
	    }

	    function ri(t, r, e, n) {
	      var o = !1;
	      !0 === n && (o = null === r[e] && void 0 !== t[e]), o ? delete t[e] : t[e] = r[e];
	    }

	    var ei = Bo;

	    function ni(t, r) {
	      var e = arguments.length > 2 && void 0 !== arguments[2] && arguments[2],
	          n = arguments.length > 3 && void 0 !== arguments[3] && arguments[3];

	      for (var o in r) if (Object.prototype.hasOwnProperty.call(r, o) || !0 === e) if ("object" === zo(r[o]) && null !== r[o] && Eo(r[o]) === Object.prototype) void 0 === t[o] ? t[o] = ni({}, r[o], e) : "object" === zo(t[o]) && null !== t[o] && Eo(t[o]) === Object.prototype ? ni(t[o], r[o], e) : ri(t, r, o, n);else if (Do(r[o])) {
	        var i;
	        t[o] = Ao(i = r[o]).call(i);
	      } else ri(t, r, o, n);

	      return t;
	    }

	    var oi = Hn;
	    var ii = {
	      asBoolean: function (t, r) {
	        return "function" == typeof t && (t = t()), null != t ? 0 != t : r || null;
	      },
	      asNumber: function (t, r) {
	        return "function" == typeof t && (t = t()), null != t ? Number(t) || r || null : r || null;
	      },
	      asString: function (t, r) {
	        return "function" == typeof t && (t = t()), null != t ? String(t) : r || null;
	      },
	      asSize: function (t, r) {
	        return "function" == typeof t && (t = t()), Zo(t) ? t : Ko(t) ? t + "px" : r || null;
	      },
	      asElement: function (t, r) {
	        return "function" == typeof t && (t = t()), t || r || null;
	      }
	    };

	    function ai(t) {
	      var r;

	      switch (t.length) {
	        case 3:
	        case 4:
	          return (r = Uo.exec(t)) ? {
	            r: Fn(r[1] + r[1], 16),
	            g: Fn(r[2] + r[2], 16),
	            b: Fn(r[3] + r[3], 16)
	          } : null;

	        case 6:
	        case 7:
	          return (r = Jo.exec(t)) ? {
	            r: Fn(r[1], 16),
	            g: Fn(r[2], 16),
	            b: Fn(r[3], 16)
	          } : null;

	        default:
	          return null;
	      }
	    }

	    function ui(t, r, e) {
	      var n;
	      return "#" + Ao(n = ((1 << 24) + (t << 16) + (r << 8) + e).toString(16)).call(n, 1);
	    }

	    function ci(t, r, e) {
	      t /= 255, r /= 255, e /= 255;
	      var n = Math.min(t, Math.min(r, e)),
	          o = Math.max(t, Math.max(r, e));
	      return n === o ? {
	        h: 0,
	        s: 0,
	        v: n
	      } : {
	        h: 60 * ((t === n ? 3 : e === n ? 1 : 5) - (t === n ? r - e : e === n ? t - r : e - t) / (o - n)) / 360,
	        s: (o - n) / o,
	        v: o
	      };
	    }

	    var fi = function (t) {
	      var r,
	          e = {};
	      return On(r = t.split(";")).call(r, function (t) {
	        if ("" != on(t).call(t)) {
	          var r,
	              n,
	              o = t.split(":"),
	              i = on(r = o[0]).call(r),
	              a = on(n = o[1]).call(n);
	          e[i] = a;
	        }
	      }), e;
	    },
	        li = function (t) {
	      var r;
	      return In(r = qe(t)).call(r, function (r) {
	        return r + ": " + t[r];
	      }).join("; ");
	    };

	    function si(t, r, e) {
	      var n,
	          o,
	          i,
	          a = Math.floor(6 * t),
	          u = 6 * t - a,
	          c = e * (1 - r),
	          f = e * (1 - u * r),
	          l = e * (1 - (1 - u) * r);

	      switch (a % 6) {
	        case 0:
	          n = e, o = l, i = c;
	          break;

	        case 1:
	          n = f, o = e, i = c;
	          break;

	        case 2:
	          n = c, o = e, i = l;
	          break;

	        case 3:
	          n = c, o = f, i = e;
	          break;

	        case 4:
	          n = l, o = c, i = e;
	          break;

	        case 5:
	          n = e, o = c, i = f;
	      }

	      return {
	        r: Math.floor(255 * n),
	        g: Math.floor(255 * o),
	        b: Math.floor(255 * i)
	      };
	    }

	    function pi(t, r, e) {
	      var n = si(t, r, e);
	      return ui(n.r, n.g, n.b);
	    }

	    function vi(t) {
	      var r = ai(t);
	      if (!r) throw new TypeError("'".concat(t, "' is not a valid color."));
	      return ci(r.r, r.g, r.b);
	    }

	    function hi(t) {
	      return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t);
	    }

	    function di(t) {
	      return Yo.test(t);
	    }

	    function yi(t) {
	      if (null === t || "object" !== zo(t)) return null;
	      if (t instanceof Element) return t;
	      var r = He(t);

	      for (var e in t) Object.prototype.hasOwnProperty.call(t, e) && "object" == zo(t[e]) && (r[e] = yi(t[e]));

	      return r;
	    }

	    t.Alea = function () {
	      for (var t = arguments.length, r = new Array(t), e = 0; e < t; e++) r[e] = arguments[e];

	      return Br(r.length ? r : [Fr()]);
	    }, t.HSVToHex = pi, t.HSVToRGB = si, t.RGBToHSV = ci, t.RGBToHex = ui, t.addClassName = function (t, r) {
	      var e = t.className.split(" "),
	          n = r.split(" ");
	      e = ro(e).call(e, Jn(n).call(n, function (t) {
	        return No(e).call(e, t) < 0;
	      })), t.className = e.join(" ");
	    }, t.addCssText = function (t, r) {
	      var e = function (t) {
	        for (var r = 1; r < arguments.length; r++) {
	          var e,
	              n = null != arguments[r] ? arguments[r] : {};
	          if (r % 2) On(e = $o(Object(n), !0)).call(e, function (r) {
	            We(t, r, n[r]);
	          });else if (Ur) Qr(t, Ur(n));else {
	            var o;
	            On(o = $o(Object(n))).call(o, function (r) {
	              Hr(t, r, Kr(n, r));
	            });
	          }
	        }

	        return t;
	      }({}, fi(t.style.cssText), {}, fi(r));

	      t.style.cssText = li(e);
	    }, t.addEventListener = function (t, r, e, n) {
	      var o;
	      t.addEventListener ? (void 0 === n && (n = !1), "mousewheel" === r && No(o = navigator.userAgent).call(o, "Firefox") >= 0 && (r = "DOMMouseScroll"), t.addEventListener(r, e, n)) : t.attachEvent("on" + r, e);
	    }, t.binarySearchCustom = function (t, r, e, n) {
	      for (var o = 0, i = 0, a = t.length - 1; i <= a && o < 1e4;) {
	        var u = Math.floor((i + a) / 2),
	            c = t[u],
	            f = r(void 0 === n ? c[e] : c[e][n]);
	        if (0 == f) return u;
	        -1 == f ? i = u + 1 : a = u - 1, o++;
	      }

	      return -1;
	    }, t.binarySearchValue = function (t, r, e, n, o) {
	      var i,
	          a,
	          u,
	          c,
	          f = 0,
	          l = 0,
	          s = t.length - 1;

	      for (o = null != o ? o : function (t, r) {
	        return t == r ? 0 : t < r ? -1 : 1;
	      }; l <= s && f < 1e4;) {
	        if (c = Math.floor(.5 * (s + l)), i = t[Math.max(0, c - 1)][e], a = t[c][e], u = t[Math.min(t.length - 1, c + 1)][e], 0 == o(a, r)) return c;
	        if (o(i, r) < 0 && o(a, r) > 0) return "before" == n ? Math.max(0, c - 1) : c;
	        if (o(a, r) < 0 && o(u, r) > 0) return "before" == n ? c : Math.min(t.length - 1, c + 1);
	        o(a, r) < 0 ? l = c + 1 : s = c - 1, f++;
	      }

	      return -1;
	    }, t.bridgeObject = yi, t.copyAndExtendArray = function (t, r) {
	      var e;
	      return ro(e = []).call(e, yo(t), [r]);
	    }, t.copyArray = function (t) {
	      return Ao(t).call(t);
	    }, t.deepExtend = ni, t.easingFunctions = {
	      linear: function (t) {
	        return t;
	      },
	      easeInQuad: function (t) {
	        return t * t;
	      },
	      easeOutQuad: function (t) {
	        return t * (2 - t);
	      },
	      easeInOutQuad: function (t) {
	        return t < .5 ? 2 * t * t : (4 - 2 * t) * t - 1;
	      },
	      easeInCubic: function (t) {
	        return t * t * t;
	      },
	      easeOutCubic: function (t) {
	        return --t * t * t + 1;
	      },
	      easeInOutCubic: function (t) {
	        return t < .5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
	      },
	      easeInQuart: function (t) {
	        return t * t * t * t;
	      },
	      easeOutQuart: function (t) {
	        return 1 - --t * t * t * t;
	      },
	      easeInOutQuart: function (t) {
	        return t < .5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
	      },
	      easeInQuint: function (t) {
	        return t * t * t * t * t;
	      },
	      easeOutQuint: function (t) {
	        return 1 + --t * t * t * t * t;
	      },
	      easeInOutQuint: function (t) {
	        return t < .5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
	      }
	    }, t.equalArray = function (t, r) {
	      if (t.length !== r.length) return !1;

	      for (var e = 0, n = t.length; e < n; e++) if (t[e] != r[e]) return !1;

	      return !0;
	    }, t.extend = ei, t.fillIfDefined = function t(r, e) {
	      var n = arguments.length > 2 && void 0 !== arguments[2] && arguments[2];

	      for (var o in r) if (void 0 !== e[o]) if (null === e[o] || "object" !== zo(e[o])) ri(r, e, o, n);else {
	        var i = r[o],
	            a = e[o];
	        ti(i) && ti(a) && t(i, a, n);
	      }
	    }, t.forEach = function (t, r) {
	      if (Do(t)) for (var e = t.length, n = 0; n < e; n++) r(t[n], n, t);else for (var o in t) Object.prototype.hasOwnProperty.call(t, o) && r(t[o], o, t);
	    }, t.getAbsoluteLeft = function (t) {
	      return t.getBoundingClientRect().left;
	    }, t.getAbsoluteRight = function (t) {
	      return t.getBoundingClientRect().right;
	    }, t.getAbsoluteTop = function (t) {
	      return t.getBoundingClientRect().top;
	    }, t.getScrollBarWidth = function () {
	      var t = document.createElement("p");
	      t.style.width = "100%", t.style.height = "200px";
	      var r = document.createElement("div");
	      r.style.position = "absolute", r.style.top = "0px", r.style.left = "0px", r.style.visibility = "hidden", r.style.width = "200px", r.style.height = "150px", r.style.overflow = "hidden", r.appendChild(t), document.body.appendChild(r);
	      var e = t.offsetWidth;
	      r.style.overflow = "scroll";
	      var n = t.offsetWidth;
	      return e == n && (n = r.clientWidth), document.body.removeChild(r), e - n;
	    }, t.getTarget = function () {
	      var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : window.event,
	          r = null;
	      return t && (t.target ? r = t.target : t.srcElement && (r = t.srcElement)), r instanceof Element && (null == r.nodeType || 3 != r.nodeType || (r = r.parentNode) instanceof Element) ? r : null;
	    }, t.getType = function (t) {
	      var r = zo(t);
	      return "object" === r ? null === t ? "null" : t instanceof Boolean ? "Boolean" : t instanceof Number ? "Number" : t instanceof String ? "String" : Do(t) ? "Array" : t instanceof Date ? "Date" : "Object" : "number" === r ? "Number" : "boolean" === r ? "Boolean" : "string" === r ? "String" : void 0 === r ? "undefined" : r;
	    }, t.hasParent = function (t, r) {
	      for (var e = t; e;) {
	        if (e === r) return !0;
	        if (!e.parentNode) return !1;
	        e = e.parentNode;
	      }

	      return !1;
	    }, t.hexToHSV = vi, t.hexToRGB = ai, t.insertSort = function (t, r) {
	      for (var e = 0; e < t.length; e++) {
	        var n = t[e],
	            o = void 0;

	        for (o = e; o > 0 && r(n, t[o - 1]) < 0; o--) t[o] = t[o - 1];

	        t[o] = n;
	      }

	      return t;
	    }, t.isDate = function (t) {
	      if (t instanceof Date) return !0;

	      if (Zo(t)) {
	        if (qo.exec(t)) return !0;
	        if (!isNaN(Date.parse(t))) return !0;
	      }

	      return !1;
	    }, t.isNumber = Ko, t.isObject = ti, t.isString = Zo, t.isValidHex = hi, t.isValidRGB = di, t.isValidRGBA = function (t) {
	      return Xo.test(t);
	    }, t.mergeOptions = function (t, r, e) {
	      var n = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {},
	          o = function (t) {
	        return null != t;
	      },
	          i = function (t) {
	        return null !== t && "object" === zo(t);
	      },
	          a = function (t) {
	        for (var r in t) if (Object.prototype.hasOwnProperty.call(t, r)) return !1;

	        return !0;
	      };

	      if (!i(t)) throw new Error("Parameter mergeTarget must be an object");
	      if (!i(r)) throw new Error("Parameter options must be an object");
	      if (!o(e)) throw new Error("Parameter option must have a value");
	      if (!i(n)) throw new Error("Parameter globalOptions must be an object");

	      var u = function (t, r, e) {
	        i(t[e]) || (t[e] = {});
	        var n = r[e],
	            o = t[e];

	        for (var a in n) Object.prototype.hasOwnProperty.call(n, a) && (o[a] = n[a]);
	      },
	          c = r[e],
	          f = i(n) && !a(n),
	          l = f ? n[e] : void 0,
	          s = l ? l.enabled : void 0;

	      if (void 0 !== c) {
	        if ("boolean" == typeof c) return i(t[e]) || (t[e] = {}), void (t[e].enabled = c);

	        if (null === c && !i(t[e])) {
	          if (!o(l)) return;
	          t[e] = He(l);
	        }

	        if (i(c)) {
	          var p = !0;
	          void 0 !== c.enabled ? p = c.enabled : void 0 !== s && (p = l.enabled), u(t, r, e), t[e].enabled = p;
	        }
	      }
	    }, t.option = ii, t.overrideOpacity = function (t, r) {
	      if (-1 !== No(t).call(t, "rgba")) return t;

	      if (-1 !== No(t).call(t, "rgb")) {
	        var e = t.substr(No(t).call(t, "(") + 1).replace(")", "").split(",");
	        return "rgba(" + e[0] + "," + e[1] + "," + e[2] + "," + r + ")";
	      }

	      var n = ai(t);
	      return null == n ? t : "rgba(" + n.r + "," + n.g + "," + n.b + "," + r + ")";
	    }, t.parseColor = function (t, r) {
	      if (Zo(t)) {
	        var e = t;

	        if (di(e)) {
	          var n,
	              o = In(n = e.substr(4).substr(0, e.length - 5).split(",")).call(n, function (t) {
	            return Fn(t);
	          });
	          e = ui(o[0], o[1], o[2]);
	        }

	        if (!0 === hi(e)) {
	          var i = vi(e),
	              a = {
	            h: i.h,
	            s: .8 * i.s,
	            v: Math.min(1, 1.02 * i.v)
	          },
	              u = {
	            h: i.h,
	            s: Math.min(1, 1.25 * i.s),
	            v: .8 * i.v
	          },
	              c = pi(u.h, u.s, u.v),
	              f = pi(a.h, a.s, a.v);
	          return {
	            background: e,
	            border: c,
	            highlight: {
	              background: f,
	              border: c
	            },
	            hover: {
	              background: f,
	              border: c
	            }
	          };
	        }

	        return {
	          background: e,
	          border: e,
	          highlight: {
	            background: e,
	            border: e
	          },
	          hover: {
	            background: e,
	            border: e
	          }
	        };
	      }

	      return r ? {
	        background: t.background || r.background,
	        border: t.border || r.border,
	        highlight: Zo(t.highlight) ? {
	          border: t.highlight,
	          background: t.highlight
	        } : {
	          background: t.highlight && t.highlight.background || r.highlight.background,
	          border: t.highlight && t.highlight.border || r.highlight.border
	        },
	        hover: Zo(t.hover) ? {
	          border: t.hover,
	          background: t.hover
	        } : {
	          border: t.hover && t.hover.border || r.hover.border,
	          background: t.hover && t.hover.background || r.hover.background
	        }
	      } : {
	        background: t.background || void 0,
	        border: t.border || void 0,
	        highlight: Zo(t.highlight) ? {
	          border: t.highlight,
	          background: t.highlight
	        } : {
	          background: t.highlight && t.highlight.background || void 0,
	          border: t.highlight && t.highlight.border || void 0
	        },
	        hover: Zo(t.hover) ? {
	          border: t.hover,
	          background: t.hover
	        } : {
	          border: t.hover && t.hover.border || void 0,
	          background: t.hover && t.hover.background || void 0
	        }
	      };
	    }, t.preventDefault = function (t) {
	      t || (t = window.event), t && (t.preventDefault ? t.preventDefault() : t.returnValue = !1);
	    }, t.recursiveDOMDelete = function t(r) {
	      if (r) for (; !0 === r.hasChildNodes();) {
	        var e = r.firstChild;
	        e && (t(e), r.removeChild(e));
	      }
	    }, t.removeClassName = function (t, r) {
	      var e = t.className.split(" "),
	          n = r.split(" ");
	      e = Jn(e).call(e, function (t) {
	        return No(n).call(n, t) < 0;
	      }), t.className = e.join(" ");
	    }, t.removeCssText = function (t, r) {
	      var e = fi(t.style.cssText),
	          n = fi(r);

	      for (var o in n) Object.prototype.hasOwnProperty.call(n, o) && delete e[o];

	      t.style.cssText = li(e);
	    }, t.removeEventListener = function (t, r, e, n) {
	      var o;
	      t.removeEventListener ? (void 0 === n && (n = !1), "mousewheel" === r && No(o = navigator.userAgent).call(o, "Firefox") >= 0 && (r = "DOMMouseScroll"), t.removeEventListener(r, e, n)) : t.detachEvent("on" + r, e);
	    }, t.selectiveBridgeObject = function (t, r) {
	      if (null !== r && "object" === zo(r)) {
	        for (var e = He(r), n = 0; n < t.length; n++) Object.prototype.hasOwnProperty.call(r, t[n]) && "object" == zo(r[t[n]]) && (e[t[n]] = yi(r[t[n]]));

	        return e;
	      }

	      return null;
	    }, t.selectiveDeepExtend = function (t, r, e) {
	      var n = arguments.length > 3 && void 0 !== arguments[3] && arguments[3];
	      if (Do(e)) throw new TypeError("Arrays are not supported by deepExtend");

	      for (var o = 0; o < t.length; o++) {
	        var i = t[o];
	        if (Object.prototype.hasOwnProperty.call(e, i)) if (e[i] && e[i].constructor === Object) void 0 === r[i] && (r[i] = {}), r[i].constructor === Object ? ni(r[i], e[i], !1, n) : ri(r, e, i, n);else {
	          if (Do(e[i])) throw new TypeError("Arrays are not supported by deepExtend");
	          ri(r, e, i, n);
	        }
	      }

	      return r;
	    }, t.selectiveExtend = function (t, r) {
	      if (!Do(t)) throw new Error("Array with property names expected as first argument");

	      for (var e = arguments.length, n = new Array(e > 2 ? e - 2 : 0), o = 2; o < e; o++) n[o - 2] = arguments[o];

	      for (var i = 0, a = n; i < a.length; i++) for (var u = a[i], c = 0; c < t.length; c++) {
	        var f = t[c];
	        u && Object.prototype.hasOwnProperty.call(u, f) && (r[f] = u[f]);
	      }

	      return r;
	    }, t.selectiveNotDeepExtend = function (t, r, e) {
	      var n = arguments.length > 3 && void 0 !== arguments[3] && arguments[3];
	      if (Do(e)) throw new TypeError("Arrays are not supported by deepExtend");

	      for (var o in e) if (Object.prototype.hasOwnProperty.call(e, o) && -1 === No(t).call(t, o)) if (e[o] && e[o].constructor === Object) void 0 === r[o] && (r[o] = {}), r[o].constructor === Object ? ni(r[o], e[o]) : ri(r, e, o, n);else if (Do(e[o])) {
	        r[o] = [];

	        for (var i = 0; i < e[o].length; i++) r[o].push(e[o][i]);
	      } else ri(r, e, o, n);

	      return r;
	    }, t.throttle = function (t) {
	      var r = !1;
	      return function () {
	        r || (r = !0, requestAnimationFrame(function () {
	          r = !1, t();
	        }));
	      };
	    }, t.toArray = oi, t.topMost = function (t, r) {
	      var e;
	      Do(r) || (r = [r]);
	      var n = !0,
	          o = !1,
	          i = void 0;

	      try {
	        for (var a, u = Lr(t); !(n = (a = u.next()).done); n = !0) {
	          var c = a.value;

	          if (c) {
	            e = c[r[0]];

	            for (var f = 1; f < r.length; f++) e && (e = e[r[f]]);

	            if (void 0 !== e) break;
	          }
	        }
	      } catch (t) {
	        o = !0, i = t;
	      } finally {
	        try {
	          n || null == u.return || u.return();
	        } finally {
	          if (o) throw i;
	        }
	      }

	      return e;
	    }, t.updateProperty = function (t, r, e) {
	      return t[r] !== e && (t[r] = e, !0);
	    }, Object.defineProperty(t, "__esModule", {
	      value: !0
	    });
	  });
	});
	unwrapExports(visUtil_min);

	getCjsExportFromNamespace(Activator);

	/**
	 * Turn an element into an clickToUse element.
	 * When not active, the element has a transparent overlay. When the overlay is
	 * clicked, the mode is changed to active.
	 * When active, the element is displayed with a blue border around it, and
	 * the interactive contents of the element can be used. When clicked outside
	 * the element, the elements mode is changed to inactive.
	 * @param {Element} container
	 * @constructor Activator
	 */

	function Activator$1(container) {
	  var _context,
	      _this = this,
	      _context2;

	  this.active = false;
	  this.dom = {
	    container: container
	  };
	  this.dom.overlay = document.createElement('div');
	  this.dom.overlay.className = 'vis-overlay';
	  this.dom.container.appendChild(this.dom.overlay);
	  this.hammer = hammer(this.dom.overlay);
	  this.hammer.on('tap', bind$2(_context = this._onTapOverlay).call(_context, this)); // block all touch events (except tap)

	  var events = ['tap', 'doubletap', 'press', 'pinch', 'pan', 'panstart', 'panmove', 'panend'];

	  forEach$2(events).call(events, function (event) {
	    _this.hammer.on(event, function (event) {
	      event.srcEvent.stopPropagation();
	    });
	  }); // attach a click event to the window, in order to deactivate when clicking outside the timeline


	  if (document && document.body) {
	    this.onClick = function (event) {
	      if (!_hasParent(event.target, container)) {
	        _this.deactivate();
	      }
	    };

	    document.body.addEventListener('click', this.onClick);
	  }

	  if (this.keycharm !== undefined) {
	    this.keycharm.destroy();
	  }

	  this.keycharm = keycharm(); // keycharm listener only bounded when active)

	  this.escListener = bind$2(_context2 = this.deactivate).call(_context2, this);
	} // turn into an event emitter


	componentEmitter(Activator$1.prototype); // The currently active activator

	Activator$1.current = null;
	/**
	 * Destroy the activator. Cleans up all created DOM and event listeners
	 */

	Activator$1.prototype.destroy = function () {
	  this.deactivate(); // remove dom

	  this.dom.overlay.parentNode.removeChild(this.dom.overlay); // remove global event listener

	  if (this.onClick) {
	    document.body.removeEventListener('click', this.onClick);
	  } // remove keycharm


	  if (this.keycharm !== undefined) {
	    this.keycharm.destroy();
	  }

	  this.keycharm = null; // cleanup hammer instances

	  this.hammer.destroy();
	  this.hammer = null; // FIXME: cleaning up hammer instances doesn't work (Timeline not removed from memory)
	};
	/**
	 * Activate the element
	 * Overlay is hidden, element is decorated with a blue shadow border
	 */


	Activator$1.prototype.activate = function () {
	  var _context3;

	  // we allow only one active activator at a time
	  if (Activator$1.current) {
	    Activator$1.current.deactivate();
	  }

	  Activator$1.current = this;
	  this.active = true;
	  this.dom.overlay.style.display = 'none';
	  visUtil_min.addClassName(this.dom.container, 'vis-active');
	  this.emit('change');
	  this.emit('activate'); // ugly hack: bind ESC after emitting the events, as the Network rebinds all
	  // keyboard events on a 'change' event

	  bind$2(_context3 = this.keycharm).call(_context3, 'esc', this.escListener);
	};
	/**
	 * Deactivate the element
	 * Overlay is displayed on top of the element
	 */


	Activator$1.prototype.deactivate = function () {
	  this.active = false;
	  this.dom.overlay.style.display = 'block';
	  visUtil_min.removeClassName(this.dom.container, 'vis-active');
	  this.keycharm.unbind('esc', this.escListener);
	  this.emit('change');
	  this.emit('deactivate');
	};
	/**
	 * Handle a tap event: activate the container
	 * @param {Event}  event   The event
	 * @private
	 */


	Activator$1.prototype._onTapOverlay = function (event) {
	  // activate the container
	  this.activate();
	  event.srcEvent.stopPropagation();
	};
	/**
	 * Test whether the element has the requested parent element somewhere in
	 * its chain of parent nodes.
	 * @param {HTMLElement} element
	 * @param {HTMLElement} parent
	 * @returns {boolean} Returns true when the parent is found somewhere in the
	 *                    chain of parent nodes.
	 * @private
	 */


	function _hasParent(element, parent) {
	  while (element) {
	    if (element === parent) {
	      return true;
	    }

	    element = element.parentNode;
	  }

	  return false;
	}

	var Activator_1 = Activator$1;

	var locales = createCommonjsModule(function (module, exports) {
	  // English
	  exports['en'] = {
	    edit: 'Edit',
	    del: 'Delete selected',
	    back: 'Back',
	    addNode: 'Add Node',
	    addEdge: 'Add Edge',
	    editNode: 'Edit Node',
	    editEdge: 'Edit Edge',
	    addDescription: 'Click in an empty space to place a new node.',
	    edgeDescription: 'Click on a node and drag the edge to another node to connect them.',
	    editEdgeDescription: 'Click on the control points and drag them to a node to connect to it.',
	    createEdgeError: 'Cannot link edges to a cluster.',
	    deleteClusterError: 'Clusters cannot be deleted.',
	    editClusterError: 'Clusters cannot be edited.'
	  };
	  exports['en_EN'] = exports['en'];
	  exports['en_US'] = exports['en']; // German

	  exports['de'] = {
	    edit: 'Editieren',
	    del: "L\xF6sche Auswahl",
	    back: "Zur\xFCck",
	    addNode: "Knoten hinzuf\xFCgen",
	    addEdge: "Kante hinzuf\xFCgen",
	    editNode: 'Knoten editieren',
	    editEdge: 'Kante editieren',
	    addDescription: 'Klicke auf eine freie Stelle, um einen neuen Knoten zu plazieren.',
	    edgeDescription: 'Klicke auf einen Knoten und ziehe die Kante zu einem anderen Knoten, um diese zu verbinden.',
	    editEdgeDescription: 'Klicke auf die Verbindungspunkte und ziehe diese auf einen Knoten, um sie zu verbinden.',
	    createEdgeError: "Es ist nicht m\xF6glich, Kanten mit Clustern zu verbinden.",
	    deleteClusterError: "Cluster k\xF6nnen nicht gel\xF6scht werden.",
	    editClusterError: "Cluster k\xF6nnen nicht editiert werden."
	  };
	  exports['de_DE'] = exports['de']; // Spanish

	  exports['es'] = {
	    edit: 'Editar',
	    del: "Eliminar selecci\xF3n",
	    back: "Atr\xE1s",
	    addNode: "A\xF1adir nodo",
	    addEdge: "A\xF1adir arista",
	    editNode: 'Editar nodo',
	    editEdge: 'Editar arista',
	    addDescription: "Haga clic en un lugar vac\xEDo para colocar un nuevo nodo.",
	    edgeDescription: 'Haga clic en un nodo y arrastre la arista hacia otro nodo para conectarlos.',
	    editEdgeDescription: 'Haga clic en un punto de control y arrastrelo a un nodo para conectarlo.',
	    createEdgeError: 'No se puede conectar una arista a un grupo.',
	    deleteClusterError: 'No es posible eliminar grupos.',
	    editClusterError: 'No es posible editar grupos.'
	  };
	  exports['es_ES'] = exports['es']; //Italiano

	  exports['it'] = {
	    edit: 'Modifica',
	    del: 'Cancella la selezione',
	    back: 'Indietro',
	    addNode: 'Aggiungi un nodo',
	    addEdge: 'Aggiungi un vertice',
	    editNode: 'Modifica il nodo',
	    editEdge: 'Modifica il vertice',
	    addDescription: 'Clicca per aggiungere un nuovo nodo',
	    edgeDescription: 'Clicca su un nodo e trascinalo ad un altro nodo per connetterli.',
	    editEdgeDescription: 'Clicca sui Punti di controllo e trascinali ad un nodo per connetterli.',
	    createEdgeError: 'Non si possono collegare vertici ad un cluster',
	    deleteClusterError: 'I cluster non possono essere cancellati',
	    editClusterError: 'I clusters non possono essere modificati.'
	  };
	  exports['it_IT'] = exports['it']; // Dutch

	  exports['nl'] = {
	    edit: 'Wijzigen',
	    del: 'Selectie verwijderen',
	    back: 'Terug',
	    addNode: 'Node toevoegen',
	    addEdge: 'Link toevoegen',
	    editNode: 'Node wijzigen',
	    editEdge: 'Link wijzigen',
	    addDescription: 'Klik op een leeg gebied om een nieuwe node te maken.',
	    edgeDescription: 'Klik op een node en sleep de link naar een andere node om ze te verbinden.',
	    editEdgeDescription: 'Klik op de verbindingspunten en sleep ze naar een node om daarmee te verbinden.',
	    createEdgeError: 'Kan geen link maken naar een cluster.',
	    deleteClusterError: 'Clusters kunnen niet worden verwijderd.',
	    editClusterError: 'Clusters kunnen niet worden aangepast.'
	  };
	  exports['nl_NL'] = exports['nl'];
	  exports['nl_BE'] = exports['nl']; // Portuguese Brazil

	  exports['pt-br'] = {
	    edit: 'Editar',
	    del: 'Remover selecionado',
	    back: 'Voltar',
	    addNode: 'Adicionar nó',
	    addEdge: 'Adicionar aresta',
	    editNode: 'Editar nó',
	    editEdge: 'Editar aresta',
	    addDescription: 'Clique em um espaço em branco para adicionar um novo nó',
	    edgeDescription: 'Clique em um nó e arraste a aresta até outro nó para conectá-los',
	    editEdgeDescription: 'Clique nos pontos de controle e os arraste para um nó para conectá-los',
	    createEdgeError: 'Não foi possível linkar arestas a um cluster.',
	    deleteClusterError: 'Clusters não puderam ser removidos.',
	    editClusterError: 'Clusters não puderam ser editados.'
	  };
	  exports['pt-BR'] = exports['pt-br'];
	  exports['pt_BR'] = exports['pt-br'];
	  exports['pt_br'] = exports['pt-br']; // Russian

	  exports['ru'] = {
	    edit: 'Редактировать',
	    del: 'Удалить выбранное',
	    back: 'Назад',
	    addNode: 'Добавить узел',
	    addEdge: 'Добавить ребро',
	    editNode: 'Редактировать узел',
	    editEdge: 'Редактировать ребро',
	    addDescription: 'Кликните в свободное место, чтобы добавить новый узел.',
	    edgeDescription: 'Кликните на узел и протяните ребро к другому узлу, чтобы соединить их.',
	    editEdgeDescription: 'Кликните на контрольные точки и перетащите их в узел, чтобы подключиться к нему.',
	    createEdgeError: 'Невозможно соединить ребра в кластер.',
	    deleteClusterError: 'Кластеры не могут быть удалены',
	    editClusterError: 'Кластеры недоступны для редактирования.'
	  };
	  exports['ru_RU'] = exports['ru']; // Chinese

	  exports['cn'] = {
	    edit: '编辑',
	    del: '删除选定',
	    back: '返回',
	    addNode: '添加节点',
	    addEdge: '添加连接线',
	    editNode: '编辑节点',
	    editEdge: '编辑连接线',
	    addDescription: '单击空白处放置新节点。',
	    edgeDescription: '单击某个节点并将该连接线拖动到另一个节点以连接它们。',
	    editEdgeDescription: '单击控制节点并将它们拖到节点上连接。',
	    createEdgeError: '无法将连接线连接到群集。',
	    deleteClusterError: '无法删除群集。',
	    editClusterError: '无法编辑群集。'
	  };
	  exports['zh_CN'] = exports['cn']; // Ukrainian

	  exports['uk'] = {
	    edit: 'Редагувати',
	    del: 'Видалити обране',
	    back: 'Назад',
	    addNode: 'Додати вузол',
	    addEdge: 'Додати край',
	    editNode: 'Редагувати вузол',
	    editEdge: 'Редагувати край',
	    addDescription: 'Kлікніть на вільне місце, щоб додати новий вузол.',
	    edgeDescription: 'Клікніть на вузол і перетягніть край до іншого вузла, щоб їх з\'єднати.',
	    editEdgeDescription: 'Клікніть на контрольні точки і перетягніть їх у вузол, щоб підключитися до нього.',
	    createEdgeError: 'Не можливо об\'єднати краї в групу.',
	    deleteClusterError: 'Групи не можуть бути видалені.',
	    editClusterError: 'Групи недоступні для редагування.'
	  };
	  exports['uk_UA'] = exports['uk']; // French

	  exports['fr'] = {
	    edit: 'Éditer',
	    del: 'Effacer la sélection',
	    back: 'Retour',
	    addNode: 'Ajouter un nœud',
	    addEdge: 'Ajouter un lien',
	    editNode: 'Éditer le nœud',
	    editEdge: 'Éditer le lien',
	    addDescription: 'Cliquez dans un endroit vide pour placer un nœud.',
	    edgeDescription: 'Cliquez sur un nœud et glissez le lien vers un autre nœud pour les connecter.',
	    editEdgeDescription: 'Cliquez sur les points de contrôle et glissez-les pour connecter un nœud.',
	    createEdgeError: 'Impossible de créer un lien vers un cluster.',
	    deleteClusterError: 'Les clusters ne peuvent pas être effacés.',
	    editClusterError: 'Les clusters ne peuvent pas être édités.'
	  };
	  exports['fr_FR'] = exports['fr']; // Czech

	  exports['cs'] = {
	    edit: 'Upravit',
	    del: 'Smazat výběr',
	    back: 'Zpět',
	    addNode: 'Přidat vrchol',
	    addEdge: 'Přidat hranu',
	    editNode: 'Upravit vrchol',
	    editEdge: 'Upravit hranu',
	    addDescription: 'Kluknutím do prázdného prostoru můžete přidat nový vrchol.',
	    edgeDescription: 'Přetažením z jednoho vrcholu do druhého můžete spojit tyto vrcholy novou hranou.',
	    editEdgeDescription: 'Přetažením kontrolního vrcholu hrany ji můžete připojit k jinému vrcholu.',
	    createEdgeError: 'Nelze připojit hranu ke shluku.',
	    deleteClusterError: 'Nelze mazat shluky.',
	    editClusterError: 'Nelze upravovat shluky.'
	  };
	  exports['cs_CZ'] = exports['cs'];
	});

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	var classCallCheck = _classCallCheck;

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;

	    defineProperty$5(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	var createClass = _createClass;

	/**
	 * Associates a canvas to a given image, containing a number of renderings
	 * of the image at various sizes.
	 *
	 * This technique is known as 'mipmapping'.
	 *
	 * NOTE: Images can also be of type 'data:svg+xml`. This code also works
	 *       for svg, but the mipmapping may not be necessary.
	 *
	 * @param {Image} image
	 */
	var CachedImage = /*#__PURE__*/function () {
	  /**
	   * @ignore
	   */
	  function CachedImage() {
	    classCallCheck(this, CachedImage);

	    // eslint-disable-line no-unused-vars
	    this.NUM_ITERATIONS = 4; // Number of items in the coordinates array

	    this.image = new Image();
	    this.canvas = document.createElement('canvas');
	  }
	  /**
	   * Called when the image has been successfully loaded.
	   */


	  createClass(CachedImage, [{
	    key: "init",
	    value: function init() {
	      if (this.initialized()) return;
	      this.src = this.image.src; // For same interface with Image

	      var w = this.image.width;
	      var h = this.image.height; // Ease external access

	      this.width = w;
	      this.height = h;
	      var h2 = Math.floor(h / 2);
	      var h4 = Math.floor(h / 4);
	      var h8 = Math.floor(h / 8);
	      var h16 = Math.floor(h / 16);
	      var w2 = Math.floor(w / 2);
	      var w4 = Math.floor(w / 4);
	      var w8 = Math.floor(w / 8);
	      var w16 = Math.floor(w / 16); // Make canvas as small as possible

	      this.canvas.width = 3 * w4;
	      this.canvas.height = h2; // Coordinates and sizes of images contained in the canvas
	      // Values per row:  [top x, left y, width, height]

	      this.coordinates = [[0, 0, w2, h2], [w2, 0, w4, h4], [w2, h4, w8, h8], [5 * w8, h4, w16, h16]];

	      this._fillMipMap();
	    }
	    /**
	     * @return {Boolean} true if init() has been called, false otherwise.
	     */

	  }, {
	    key: "initialized",
	    value: function initialized() {
	      return this.coordinates !== undefined;
	    }
	    /**
	     * Redraw main image in various sizes to the context.
	     *
	     * The rationale behind this is to reduce artefacts due to interpolation
	     * at differing zoom levels.
	     *
	     * Source: http://stackoverflow.com/q/18761404/1223531
	     *
	     * This methods takes the resizing out of the drawing loop, in order to
	     * reduce performance overhead.
	     *
	     * TODO: The code assumes that a 2D context can always be gotten. This is
	     *       not necessarily true! OTOH, if not true then usage of this class
	     *       is senseless.
	     *
	     * @private
	     */

	  }, {
	    key: "_fillMipMap",
	    value: function _fillMipMap() {
	      var ctx = this.canvas.getContext('2d'); // First zoom-level comes from the image

	      var to = this.coordinates[0];
	      ctx.drawImage(this.image, to[0], to[1], to[2], to[3]); // The rest are copy actions internal to the canvas/context

	      for (var iterations = 1; iterations < this.NUM_ITERATIONS; iterations++) {
	        var from = this.coordinates[iterations - 1];
	        var _to = this.coordinates[iterations];
	        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], _to[0], _to[1], _to[2], _to[3]);
	      }
	    }
	    /**
	     * Draw the image, using the mipmap if necessary.
	     *
	     * MipMap is only used if param factor > 2; otherwise, original bitmap
	     * is resized. This is also used to skip mipmap usage, e.g. by setting factor = 1
	     *
	     * Credits to 'Alex de Mulder' for original implementation.
	     *
	     * @param {CanvasRenderingContext2D} ctx  context on which to draw zoomed image
	     * @param {Float} factor scale factor at which to draw
	     * @param {number} left
	     * @param {number} top
	     * @param {number} width
	     * @param {number} height
	     */

	  }, {
	    key: "drawImageAtPosition",
	    value: function drawImageAtPosition(ctx, factor, left, top, width, height) {
	      if (!this.initialized()) return; //can't draw image yet not intialized

	      if (factor > 2) {
	        // Determine which zoomed image to use
	        factor *= 0.5;
	        var iterations = 0;

	        while (factor > 2 && iterations < this.NUM_ITERATIONS) {
	          factor *= 0.5;
	          iterations += 1;
	        }

	        if (iterations >= this.NUM_ITERATIONS) {
	          iterations = this.NUM_ITERATIONS - 1;
	        } //console.log("iterations: " + iterations);


	        var from = this.coordinates[iterations];
	        ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], left, top, width, height);
	      } else {
	        // Draw image directly
	        ctx.drawImage(this.image, left, top, width, height);
	      }
	    }
	  }]);

	  return CachedImage;
	}();

	/**
	 * This callback is a callback that accepts an Image.
	 * @callback ImageCallback
	 * @param {Image} image
	 */

	/**
	 * This class loads images and keeps them stored.
	 *
	 * @param {ImageCallback} callback
	 */

	var Images = /*#__PURE__*/function () {
	  /**
	   * @param {ImageCallback} callback
	   */
	  function Images(callback) {
	    classCallCheck(this, Images);

	    this.images = {};
	    this.imageBroken = {};
	    this.callback = callback;
	  }
	  /**
	   * @param {string} url                      The original Url that failed to load, if the broken image is successfully loaded it will be added to the cache using this Url as the key so that subsequent requests for this Url will return the broken image
	   * @param {string} brokenUrl                Url the broken image to try and load
	   * @param {Image} imageToLoadBrokenUrlOn   The image object
	   */


	  createClass(Images, [{
	    key: "_tryloadBrokenUrl",
	    value: function _tryloadBrokenUrl(url, brokenUrl, imageToLoadBrokenUrlOn) {
	      //If these parameters aren't specified then exit the function because nothing constructive can be done
	      if (url === undefined || imageToLoadBrokenUrlOn === undefined) return;

	      if (brokenUrl === undefined) {
	        console.warn("No broken url image defined");
	        return;
	      } //Clear the old subscription to the error event and put a new in place that only handle errors in loading the brokenImageUrl


	      imageToLoadBrokenUrlOn.image.onerror = function () {
	        console.error("Could not load brokenImage:", brokenUrl); // cache item will contain empty image, this should be OK for default
	      }; //Set the source of the image to the brokenUrl, this is actually what kicks off the loading of the broken image


	      imageToLoadBrokenUrlOn.image.src = brokenUrl;
	    }
	    /**
	     *
	     * @param {vis.Image} imageToRedrawWith
	     * @private
	     */

	  }, {
	    key: "_redrawWithImage",
	    value: function _redrawWithImage(imageToRedrawWith) {
	      if (this.callback) {
	        this.callback(imageToRedrawWith);
	      }
	    }
	    /**
	     * @param {string} url          Url of the image
	     * @param {string} brokenUrl    Url of an image to use if the url image is not found
	     * @return {Image} img          The image object
	     */

	  }, {
	    key: "load",
	    value: function load(url, brokenUrl) {
	      var _this = this;

	      //Try and get the image from the cache, if successful then return the cached image   
	      var cachedImage = this.images[url];
	      if (cachedImage) return cachedImage; //Create a new image

	      var img = new CachedImage(); // Need to add to cache here, otherwise final return will spawn different copies of the same image,
	      // Also, there will be multiple loads of the same image.

	      this.images[url] = img; //Subscribe to the event that is raised if the image loads successfully 

	      img.image.onload = function () {
	        // Properly init the cached item and then request a redraw
	        _this._fixImageCoordinates(img.image);

	        img.init();

	        _this._redrawWithImage(img);
	      }; //Subscribe to the event that is raised if the image fails to load


	      img.image.onerror = function () {
	        console.error("Could not load image:", url); //Try and load the image specified by the brokenUrl using

	        _this._tryloadBrokenUrl(url, brokenUrl, img);
	      }; //Set the source of the image to the url, this is what actually kicks off the loading of the image


	      img.image.src = url; //Return the new image

	      return img;
	    }
	    /**
	     * IE11 fix -- thanks dponch!
	     *
	     * Local helper function
	     * @param {vis.Image} imageToCache
	     * @private
	     */

	  }, {
	    key: "_fixImageCoordinates",
	    value: function _fixImageCoordinates(imageToCache) {
	      if (imageToCache.width === 0) {
	        document.body.appendChild(imageToCache);
	        imageToCache.width = imageToCache.offsetWidth;
	        imageToCache.height = imageToCache.offsetHeight;
	        document.body.removeChild(imageToCache);
	      }
	    }
	  }]);

	  return Images;
	}();

	/**
	 * This class can store groups and options specific for groups.
	 */

	var Groups = /*#__PURE__*/function () {
	  /**
	   * @ignore
	   */
	  function Groups() {
	    classCallCheck(this, Groups);

	    this.clear();
	    this.defaultIndex = 0;
	    this.groupsArray = [];
	    this.groupIndex = 0;
	    this.defaultGroups = [{
	      border: "#2B7CE9",
	      background: "#97C2FC",
	      highlight: {
	        border: "#2B7CE9",
	        background: "#D2E5FF"
	      },
	      hover: {
	        border: "#2B7CE9",
	        background: "#D2E5FF"
	      }
	    }, // 0: blue
	    {
	      border: "#FFA500",
	      background: "#FFFF00",
	      highlight: {
	        border: "#FFA500",
	        background: "#FFFFA3"
	      },
	      hover: {
	        border: "#FFA500",
	        background: "#FFFFA3"
	      }
	    }, // 1: yellow
	    {
	      border: "#FA0A10",
	      background: "#FB7E81",
	      highlight: {
	        border: "#FA0A10",
	        background: "#FFAFB1"
	      },
	      hover: {
	        border: "#FA0A10",
	        background: "#FFAFB1"
	      }
	    }, // 2: red
	    {
	      border: "#41A906",
	      background: "#7BE141",
	      highlight: {
	        border: "#41A906",
	        background: "#A1EC76"
	      },
	      hover: {
	        border: "#41A906",
	        background: "#A1EC76"
	      }
	    }, // 3: green
	    {
	      border: "#E129F0",
	      background: "#EB7DF4",
	      highlight: {
	        border: "#E129F0",
	        background: "#F0B3F5"
	      },
	      hover: {
	        border: "#E129F0",
	        background: "#F0B3F5"
	      }
	    }, // 4: magenta
	    {
	      border: "#7C29F0",
	      background: "#AD85E4",
	      highlight: {
	        border: "#7C29F0",
	        background: "#D3BDF0"
	      },
	      hover: {
	        border: "#7C29F0",
	        background: "#D3BDF0"
	      }
	    }, // 5: purple
	    {
	      border: "#C37F00",
	      background: "#FFA807",
	      highlight: {
	        border: "#C37F00",
	        background: "#FFCA66"
	      },
	      hover: {
	        border: "#C37F00",
	        background: "#FFCA66"
	      }
	    }, // 6: orange
	    {
	      border: "#4220FB",
	      background: "#6E6EFD",
	      highlight: {
	        border: "#4220FB",
	        background: "#9B9BFD"
	      },
	      hover: {
	        border: "#4220FB",
	        background: "#9B9BFD"
	      }
	    }, // 7: darkblue
	    {
	      border: "#FD5A77",
	      background: "#FFC0CB",
	      highlight: {
	        border: "#FD5A77",
	        background: "#FFD1D9"
	      },
	      hover: {
	        border: "#FD5A77",
	        background: "#FFD1D9"
	      }
	    }, // 8: pink
	    {
	      border: "#4AD63A",
	      background: "#C2FABC",
	      highlight: {
	        border: "#4AD63A",
	        background: "#E6FFE3"
	      },
	      hover: {
	        border: "#4AD63A",
	        background: "#E6FFE3"
	      }
	    }, // 9: mint
	    {
	      border: "#990000",
	      background: "#EE0000",
	      highlight: {
	        border: "#BB0000",
	        background: "#FF3333"
	      },
	      hover: {
	        border: "#BB0000",
	        background: "#FF3333"
	      }
	    }, // 10:bright red
	    {
	      border: "#FF6000",
	      background: "#FF6000",
	      highlight: {
	        border: "#FF6000",
	        background: "#FF6000"
	      },
	      hover: {
	        border: "#FF6000",
	        background: "#FF6000"
	      }
	    }, // 12: real orange
	    {
	      border: "#97C2FC",
	      background: "#2B7CE9",
	      highlight: {
	        border: "#D2E5FF",
	        background: "#2B7CE9"
	      },
	      hover: {
	        border: "#D2E5FF",
	        background: "#2B7CE9"
	      }
	    }, // 13: blue
	    {
	      border: "#399605",
	      background: "#255C03",
	      highlight: {
	        border: "#399605",
	        background: "#255C03"
	      },
	      hover: {
	        border: "#399605",
	        background: "#255C03"
	      }
	    }, // 14: green
	    {
	      border: "#B70054",
	      background: "#FF007E",
	      highlight: {
	        border: "#B70054",
	        background: "#FF007E"
	      },
	      hover: {
	        border: "#B70054",
	        background: "#FF007E"
	      }
	    }, // 15: magenta
	    {
	      border: "#AD85E4",
	      background: "#7C29F0",
	      highlight: {
	        border: "#D3BDF0",
	        background: "#7C29F0"
	      },
	      hover: {
	        border: "#D3BDF0",
	        background: "#7C29F0"
	      }
	    }, // 16: purple
	    {
	      border: "#4557FA",
	      background: "#000EA1",
	      highlight: {
	        border: "#6E6EFD",
	        background: "#000EA1"
	      },
	      hover: {
	        border: "#6E6EFD",
	        background: "#000EA1"
	      }
	    }, // 17: darkblue
	    {
	      border: "#FFC0CB",
	      background: "#FD5A77",
	      highlight: {
	        border: "#FFD1D9",
	        background: "#FD5A77"
	      },
	      hover: {
	        border: "#FFD1D9",
	        background: "#FD5A77"
	      }
	    }, // 18: pink
	    {
	      border: "#C2FABC",
	      background: "#74D66A",
	      highlight: {
	        border: "#E6FFE3",
	        background: "#74D66A"
	      },
	      hover: {
	        border: "#E6FFE3",
	        background: "#74D66A"
	      }
	    }, // 19: mint
	    {
	      border: "#EE0000",
	      background: "#990000",
	      highlight: {
	        border: "#FF3333",
	        background: "#BB0000"
	      },
	      hover: {
	        border: "#FF3333",
	        background: "#BB0000"
	      }
	    } // 20:bright red
	    ];
	    this.options = {};
	    this.defaultOptions = {
	      useDefaultGroups: true
	    };
	    extend(this.options, this.defaultOptions);
	  }
	  /**
	   *
	   * @param {Object} options
	   */


	  createClass(Groups, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      var optionFields = ['useDefaultGroups'];

	      if (options !== undefined) {
	        for (var groupName in options) {
	          if (options.hasOwnProperty(groupName)) {
	            if (indexOf$3(optionFields).call(optionFields, groupName) === -1) {
	              var group = options[groupName];
	              this.add(groupName, group);
	            }
	          }
	        }
	      }
	    }
	    /**
	     * Clear all groups
	     */

	  }, {
	    key: "clear",
	    value: function clear() {
	      this.groups = {};
	      this.groupsArray = [];
	    }
	    /**
	     * Get group options of a groupname.
	     * If groupname is not found, a new group may be created.
	     *
	     * @param {*}       groupname     Can be a number, string, Date, etc.
	     * @param {boolean} [shouldCreate=true] If true, create a new group
	     * @return {Object} The found or created group
	     */

	  }, {
	    key: "get",
	    value: function get(groupname) {
	      var shouldCreate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      var group = this.groups[groupname];

	      if (group === undefined && shouldCreate) {
	        if (this.options.useDefaultGroups === false && this.groupsArray.length > 0) {
	          // create new group
	          var index = this.groupIndex % this.groupsArray.length;
	          this.groupIndex++;
	          group = {};
	          group.color = this.groups[this.groupsArray[index]];
	          this.groups[groupname] = group;
	        } else {
	          // create new group
	          var _index = this.defaultIndex % this.defaultGroups.length;

	          this.defaultIndex++;
	          group = {};
	          group.color = this.defaultGroups[_index];
	          this.groups[groupname] = group;
	        }
	      }

	      return group;
	    }
	    /**
	     * Add a custom group style
	     * @param {string} groupName
	     * @param {Object} style       An object containing borderColor,
	     *                             backgroundColor, etc.
	     * @return {Object} group      The created group object
	     */

	  }, {
	    key: "add",
	    value: function add(groupName, style) {
	      this.groups[groupName] = style;
	      this.groupsArray.push(groupName);
	      return style;
	    }
	  }]);

	  return Groups;
	}();

	var slice$6 = [].slice;
	var MSIE = /MSIE .\./.test(engineUserAgent); // <- dirty ie9- check

	var wrap$1 = function (scheduler) {
	  return function (handler, timeout
	  /* , ...arguments */
	  ) {
	    var boundArgs = arguments.length > 2;
	    var args = boundArgs ? slice$6.call(arguments, 2) : undefined;
	    return scheduler(boundArgs ? function () {
	      // eslint-disable-next-line no-new-func
	      (typeof handler == 'function' ? handler : Function(handler)).apply(this, args);
	    } : handler, timeout);
	  };
	}; // ie9- setTimeout & setInterval additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers


	_export({
	  global: true,
	  bind: true,
	  forced: MSIE
	}, {
	  // `setTimeout` method
	  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
	  setTimeout: wrap$1(global_1.setTimeout),
	  // `setInterval` method
	  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
	  setInterval: wrap$1(global_1.setInterval)
	});

	var setTimeout$1 = path.setTimeout;

	var setTimeout$2 = setTimeout$1;

	var $some = arrayIteration.some;
	var STRICT_METHOD$2 = arrayMethodIsStrict('some');
	var USES_TO_LENGTH$7 = arrayMethodUsesToLength('some'); // `Array.prototype.some` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.some

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$2 || !USES_TO_LENGTH$7
	}, {
	  some: function some(callbackfn
	  /* , thisArg */
	  ) {
	    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var some = entryVirtual('Array').some;

	var ArrayPrototype$9 = Array.prototype;

	var some_1 = function (it) {
	  var own = it.some;
	  return it === ArrayPrototype$9 || it instanceof Array && own === ArrayPrototype$9.some ? some : own;
	};

	var some$1 = some_1;

	var some$2 = some$1;

	var globalIsFinite = global_1.isFinite; // `Number.isFinite` method
	// https://tc39.github.io/ecma262/#sec-number.isfinite

	var numberIsFinite = Number.isFinite || function isFinite(it) {
	  return typeof it == 'number' && globalIsFinite(it);
	};

	// https://tc39.github.io/ecma262/#sec-number.isfinite

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isFinite: numberIsFinite
	});

	var _isFinite = path.Number.isFinite;

	var _isFinite$1 = _isFinite;

	var _isFinite$2 = _isFinite$1;

	// https://tc39.github.io/ecma262/#sec-number.isnan

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isNaN: function isNaN(number) {
	    // eslint-disable-next-line no-self-compare
	    return number != number;
	  }
	});

	var isNan = path.Number.isNaN;

	var isNan$1 = isNan;

	var isNan$2 = isNan$1;

	function _assertThisInitialized$1(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	var assertThisInitialized = _assertThisInitialized$1;

	var nativeConstruct = getBuiltIn('Reflect', 'construct'); // `Reflect.construct` method
	// https://tc39.github.io/ecma262/#sec-reflect.construct
	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it

	var NEW_TARGET_BUG = fails(function () {
	  function F() {
	    /* empty */
	  }

	  return !(nativeConstruct(function () {
	    /* empty */
	  }, [], F) instanceof F);
	});
	var ARGS_BUG = !fails(function () {
	  nativeConstruct(function () {
	    /* empty */
	  });
	});
	var FORCED$3 = NEW_TARGET_BUG || ARGS_BUG;
	_export({
	  target: 'Reflect',
	  stat: true,
	  forced: FORCED$3,
	  sham: FORCED$3
	}, {
	  construct: function construct(Target, args
	  /* , newTarget */
	  ) {
	    aFunction(Target);
	    anObject(args);
	    var newTarget = arguments.length < 3 ? Target : aFunction(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);

	    if (Target == newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0:
	          return new Target();

	        case 1:
	          return new Target(args[0]);

	        case 2:
	          return new Target(args[0], args[1]);

	        case 3:
	          return new Target(args[0], args[1], args[2]);

	        case 4:
	          return new Target(args[0], args[1], args[2], args[3]);
	      } // w/o altered newTarget, lot of arguments case


	      var $args = [null];
	      $args.push.apply($args, args);
	      return new (functionBind.apply(Target, $args))();
	    } // with altered newTarget, not support built-in constructors


	    var proto = newTarget.prototype;
	    var instance = objectCreate(isObject(proto) ? proto : Object.prototype);
	    var result = Function.apply.call(Target, instance, args);
	    return isObject(result) ? result : instance;
	  }
	});

	var construct$1 = path.Reflect.construct;

	var construct$2 = construct$1;

	var construct$3 = construct$2;

	var entries = entryVirtual('Array').entries;

	var entries$1 = entries;

	var ArrayPrototype$a = Array.prototype;
	var DOMIterables$1 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var entries_1 = function (it) {
	  var own = it.entries;
	  return it === ArrayPrototype$a || it instanceof Array && own === ArrayPrototype$a.entries // eslint-disable-next-line no-prototype-builtins
	  || DOMIterables$1.hasOwnProperty(classof(it)) ? entries$1 : own;
	};

	var entries$2 = entries_1;

	var $stringify$1 = getBuiltIn('JSON', 'stringify');
	var re = /[\uD800-\uDFFF]/g;
	var low = /^[\uD800-\uDBFF]$/;
	var hi = /^[\uDC00-\uDFFF]$/;

	var fix = function (match, offset, string) {
	  var prev = string.charAt(offset - 1);
	  var next = string.charAt(offset + 1);

	  if (low.test(match) && !hi.test(next) || hi.test(match) && !low.test(prev)) {
	    return '\\u' + match.charCodeAt(0).toString(16);
	  }

	  return match;
	};

	var FORCED$4 = fails(function () {
	  return $stringify$1('\uDF06\uD834') !== '"\\udf06\\ud834"' || $stringify$1('\uDEAD') !== '"\\udead"';
	});

	if ($stringify$1) {
	  // https://github.com/tc39/proposal-well-formed-stringify
	  _export({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED$4
	  }, {
	    // eslint-disable-next-line no-unused-vars
	    stringify: function stringify(it, replacer, space) {
	      var result = $stringify$1.apply(null, arguments);
	      return typeof result == 'string' ? result.replace(re, fix) : result;
	    }
	  });
	}

	if (!path.JSON) path.JSON = {
	  stringify: JSON.stringify
	}; // eslint-disable-next-line no-unused-vars

	var stringify = function stringify(it, replacer, space) {
	  return path.JSON.stringify.apply(null, arguments);
	};

	var stringify$1 = stringify;

	var stringify$2 = stringify$1;

	var values$3 = entryVirtual('Array').values;

	var values$4 = values$3;

	var ArrayPrototype$b = Array.prototype;
	var DOMIterables$2 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var values_1 = function (it) {
	  var own = it.values;
	  return it === ArrayPrototype$b || it instanceof Array && own === ArrayPrototype$b.values // eslint-disable-next-line no-prototype-builtins
	  || DOMIterables$2.hasOwnProperty(classof(it)) ? values$4 : own;
	};

	var values$5 = values_1;

	var keys$4 = entryVirtual('Array').keys;

	var keys$5 = keys$4;

	var ArrayPrototype$c = Array.prototype;
	var DOMIterables$3 = {
	  DOMTokenList: true,
	  NodeList: true
	};

	var keys_1 = function (it) {
	  var own = it.keys;
	  return it === ArrayPrototype$c || it instanceof Array && own === ArrayPrototype$c.keys // eslint-disable-next-line no-prototype-builtins
	  || DOMIterables$3.hasOwnProperty(classof(it)) ? keys$5 : own;
	};

	var keys$6 = keys_1;

	var create$3 = create;

	var create$4 = create$3;

	// https://tc39.github.io/ecma262/#sec-object.setprototypeof

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  setPrototypeOf: objectSetPrototypeOf
	});

	var setPrototypeOf = path.Object.setPrototypeOf;

	var setPrototypeOf$1 = setPrototypeOf;

	var setPrototypeOf$2 = setPrototypeOf$1;

	var setPrototypeOf$3 = createCommonjsModule(function (module) {
	  function _setPrototypeOf(o, p) {
	    module.exports = _setPrototypeOf = setPrototypeOf$2 || function _setPrototypeOf(o, p) {
	      o.__proto__ = p;
	      return o;
	    };

	    return _setPrototypeOf(o, p);
	  }

	  module.exports = _setPrototypeOf;
	});

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }

	  subClass.prototype = create$4(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  if (superClass) setPrototypeOf$3(subClass, superClass);
	}

	var inherits = _inherits;

	function _possibleConstructorReturn(self, call) {
	  if (call && (_typeof_1(call) === "object" || typeof call === "function")) {
	    return call;
	  }

	  return assertThisInitialized(self);
	}

	var possibleConstructorReturn = _possibleConstructorReturn;

	var getPrototypeOf$3 = getPrototypeOf;

	var getPrototypeOf$4 = getPrototypeOf$3;

	var getPrototypeOf$5 = createCommonjsModule(function (module) {
	  function _getPrototypeOf(o) {
	    module.exports = _getPrototypeOf = setPrototypeOf$2 ? getPrototypeOf$4 : function _getPrototypeOf(o) {
	      return o.__proto__ || getPrototypeOf$4(o);
	    };
	    return _getPrototypeOf(o);
	  }

	  module.exports = _getPrototypeOf;
	});

	var test$1 = [];
	var nativeSort = test$1.sort; // IE8-

	var FAILS_ON_UNDEFINED = fails(function () {
	  test$1.sort(undefined);
	}); // V8 bug

	var FAILS_ON_NULL = fails(function () {
	  test$1.sort(null);
	}); // Old WebKit

	var STRICT_METHOD$3 = arrayMethodIsStrict('sort');
	var FORCED$5 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$3; // `Array.prototype.sort` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.sort

	_export({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$5
	}, {
	  sort: function sort(comparefn) {
	    return comparefn === undefined ? nativeSort.call(toObject(this)) : nativeSort.call(toObject(this), aFunction(comparefn));
	  }
	});

	var sort = entryVirtual('Array').sort;

	var ArrayPrototype$d = Array.prototype;

	var sort_1 = function (it) {
	  var own = it.sort;
	  return it === ArrayPrototype$d || it instanceof Array && own === ArrayPrototype$d.sort ? sort : own;
	};

	var sort$1 = sort_1;

	var sort$2 = sort$1;

	var freezing = !fails(function () {
	  return Object.isExtensible(Object.preventExtensions({}));
	});

	var internalMetadata = createCommonjsModule(function (module) {
	  var defineProperty = objectDefineProperty.f;
	  var METADATA = uid('meta');
	  var id = 0;

	  var isExtensible = Object.isExtensible || function () {
	    return true;
	  };

	  var setMetadata = function (it) {
	    defineProperty(it, METADATA, {
	      value: {
	        objectID: 'O' + ++id,
	        // object ID
	        weakData: {} // weak collections IDs

	      }
	    });
	  };

	  var fastKey = function (it, create) {
	    // return a primitive with prefix
	    if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;

	    if (!has(it, METADATA)) {
	      // can't set metadata to uncaught frozen object
	      if (!isExtensible(it)) return 'F'; // not necessary to add metadata

	      if (!create) return 'E'; // add missing metadata

	      setMetadata(it); // return object ID
	    }

	    return it[METADATA].objectID;
	  };

	  var getWeakData = function (it, create) {
	    if (!has(it, METADATA)) {
	      // can't set metadata to uncaught frozen object
	      if (!isExtensible(it)) return true; // not necessary to add metadata

	      if (!create) return false; // add missing metadata

	      setMetadata(it); // return the store of weak collections IDs
	    }

	    return it[METADATA].weakData;
	  }; // add metadata on freeze-family methods calling


	  var onFreeze = function (it) {
	    if (freezing && meta.REQUIRED && isExtensible(it) && !has(it, METADATA)) setMetadata(it);
	    return it;
	  };

	  var meta = module.exports = {
	    REQUIRED: false,
	    fastKey: fastKey,
	    getWeakData: getWeakData,
	    onFreeze: onFreeze
	  };
	  hiddenKeys[METADATA] = true;
	});
	var internalMetadata_1 = internalMetadata.REQUIRED;
	var internalMetadata_2 = internalMetadata.fastKey;
	var internalMetadata_3 = internalMetadata.getWeakData;
	var internalMetadata_4 = internalMetadata.onFreeze;

	var iterate_1 = createCommonjsModule(function (module) {
	  var Result = function (stopped, result) {
	    this.stopped = stopped;
	    this.result = result;
	  };

	  var iterate = module.exports = function (iterable, fn, that, AS_ENTRIES, IS_ITERATOR) {
	    var boundFunction = functionBindContext(fn, that, AS_ENTRIES ? 2 : 1);
	    var iterator, iterFn, index, length, result, next, step;

	    if (IS_ITERATOR) {
	      iterator = iterable;
	    } else {
	      iterFn = getIteratorMethod(iterable);
	      if (typeof iterFn != 'function') throw TypeError('Target is not iterable'); // optimisation for array iterators

	      if (isArrayIteratorMethod(iterFn)) {
	        for (index = 0, length = toLength(iterable.length); length > index; index++) {
	          result = AS_ENTRIES ? boundFunction(anObject(step = iterable[index])[0], step[1]) : boundFunction(iterable[index]);
	          if (result && result instanceof Result) return result;
	        }

	        return new Result(false);
	      }

	      iterator = iterFn.call(iterable);
	    }

	    next = iterator.next;

	    while (!(step = next.call(iterator)).done) {
	      result = callWithSafeIterationClosing(iterator, boundFunction, step.value, AS_ENTRIES);
	      if (typeof result == 'object' && result && result instanceof Result) return result;
	    }

	    return new Result(false);
	  };

	  iterate.stop = function (result) {
	    return new Result(true, result);
	  };
	});

	var anInstance = function (it, Constructor, name) {
	  if (!(it instanceof Constructor)) {
	    throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
	  }

	  return it;
	};

	var defineProperty$9 = objectDefineProperty.f;
	var forEach$4 = arrayIteration.forEach;
	var setInternalState$3 = internalState.set;
	var internalStateGetterFor = internalState.getterFor;

	var collection = function (CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global_1[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var exported = {};
	  var Constructor;

	  if (!descriptors || typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
	    new NativeConstructor().entries().next();
	  }))) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    internalMetadata.REQUIRED = true;
	  } else {
	    Constructor = wrapper(function (target, iterable) {
	      setInternalState$3(anInstance(target, Constructor, CONSTRUCTOR_NAME), {
	        type: CONSTRUCTOR_NAME,
	        collection: new NativeConstructor()
	      });
	      if (iterable != undefined) iterate_1(iterable, target[ADDER], target, IS_MAP);
	    });
	    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);
	    forEach$4(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
	      var IS_ADDER = KEY == 'add' || KEY == 'set';

	      if (KEY in NativePrototype && !(IS_WEAK && KEY == 'clear')) {
	        createNonEnumerableProperty(Constructor.prototype, KEY, function (a, b) {
	          var collection = getInternalState(this).collection;
	          if (!IS_ADDER && IS_WEAK && !isObject(a)) return KEY == 'get' ? undefined : false;
	          var result = collection[KEY](a === 0 ? 0 : a, b);
	          return IS_ADDER ? this : result;
	        });
	      }
	    });
	    IS_WEAK || defineProperty$9(Constructor.prototype, 'size', {
	      configurable: true,
	      get: function () {
	        return getInternalState(this).collection.size;
	      }
	    });
	  }

	  setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);
	  exported[CONSTRUCTOR_NAME] = Constructor;
	  _export({
	    global: true,
	    forced: true
	  }, exported);
	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
	  return Constructor;
	};

	var redefineAll = function (target, src, options) {
	  for (var key in src) {
	    if (options && options.unsafe && target[key]) target[key] = src[key];else redefine(target, key, src[key], options);
	  }

	  return target;
	};

	var SPECIES$3 = wellKnownSymbol('species');

	var setSpecies = function (CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
	  var defineProperty = objectDefineProperty.f;

	  if (descriptors && Constructor && !Constructor[SPECIES$3]) {
	    defineProperty(Constructor, SPECIES$3, {
	      configurable: true,
	      get: function () {
	        return this;
	      }
	    });
	  }
	};

	var defineProperty$a = objectDefineProperty.f;
	var fastKey = internalMetadata.fastKey;
	var setInternalState$4 = internalState.set;
	var internalStateGetterFor$1 = internalState.getterFor;
	var collectionStrong = {
	  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var C = wrapper(function (that, iterable) {
	      anInstance(that, C, CONSTRUCTOR_NAME);
	      setInternalState$4(that, {
	        type: CONSTRUCTOR_NAME,
	        index: objectCreate(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!descriptors) that.size = 0;
	      if (iterable != undefined) iterate_1(iterable, that[ADDER], that, IS_MAP);
	    });
	    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);

	    var define = function (that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index; // change existing entry

	      if (entry) {
	        entry.value = value; // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (descriptors) state.size++;else that.size++; // add to index

	        if (index !== 'F') state.index[index] = entry;
	      }

	      return that;
	    };

	    var getEntry = function (that, key) {
	      var state = getInternalState(that); // fast case

	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index]; // frozen object case

	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key == key) return entry;
	      }
	    };

	    redefineAll(C.prototype, {
	      // 23.1.3.1 Map.prototype.clear()
	      // 23.2.3.2 Set.prototype.clear()
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;

	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }

	        state.first = state.last = undefined;
	        if (descriptors) state.size = 0;else that.size = 0;
	      },
	      // 23.1.3.3 Map.prototype.delete(key)
	      // 23.2.3.4 Set.prototype.delete(value)
	      'delete': function (key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);

	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first == entry) state.first = next;
	          if (state.last == entry) state.last = prev;
	          if (descriptors) state.size--;else that.size--;
	        }

	        return !!entry;
	      },
	      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
	      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
	      forEach: function forEach(callbackfn
	      /* , that = undefined */
	      ) {
	        var state = getInternalState(this);
	        var boundFunction = functionBindContext(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
	        var entry;

	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this); // revert to the last existing entry

	          while (entry && entry.removed) entry = entry.previous;
	        }
	      },
	      // 23.1.3.7 Map.prototype.has(key)
	      // 23.2.3.7 Set.prototype.has(value)
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });
	    redefineAll(C.prototype, IS_MAP ? {
	      // 23.1.3.6 Map.prototype.get(key)
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // 23.1.3.9 Map.prototype.set(key, value)
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // 23.2.3.1 Set.prototype.add(value)
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (descriptors) defineProperty$a(C.prototype, 'size', {
	      get: function () {
	        return getInternalState(this).size;
	      }
	    });
	    return C;
	  },
	  setStrong: function (C, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor$1(ITERATOR_NAME); // add .keys, .values, .entries, [@@iterator]
	    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11

	    defineIterator(C, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState$4(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last; // revert to the last existing entry

	      while (entry && entry.removed) entry = entry.previous; // get next entry


	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return {
	          value: undefined,
	          done: true
	        };
	      } // return step by kind


	      if (kind == 'keys') return {
	        value: entry.key,
	        done: false
	      };
	      if (kind == 'values') return {
	        value: entry.value,
	        done: false
	      };
	      return {
	        value: [entry.key, entry.value],
	        done: false
	      };
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true); // add [@@species], 23.1.2.2, 23.2.2.2

	    setSpecies(CONSTRUCTOR_NAME);
	  }
	};

	// https://tc39.github.io/ecma262/#sec-set-objects


	var es_set = collection('Set', function (init) {
	  return function Set() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	var set$1 = path.Set;

	var set$2 = set$1;

	var set$3 = set$2;

	// https://tc39.github.io/ecma262/#sec-map-objects


	var es_map = collection('Map', function (init) {
	  return function Map() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	var map$3 = path.Map;

	var map$4 = map$3;

	var map$5 = map$4;

	var runtime_1 = createCommonjsModule(function (module) {
	  /**
	   * Copyright (c) 2014-present, Facebook, Inc.
	   *
	   * This source code is licensed under the MIT license found in the
	   * LICENSE file in the root directory of this source tree.
	   */
	  var runtime = function (exports) {

	    var Op = Object.prototype;
	    var hasOwn = Op.hasOwnProperty;
	    var undefined$1; // More compressible than void 0.

	    var $Symbol = typeof Symbol === "function" ? Symbol : {};
	    var iteratorSymbol = $Symbol.iterator || "@@iterator";
	    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	    function wrap(innerFn, outerFn, self, tryLocsList) {
	      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	      var generator = Object.create(protoGenerator.prototype);
	      var context = new Context(tryLocsList || []); // The ._invoke method unifies the implementations of the .next,
	      // .throw, and .return methods.

	      generator._invoke = makeInvokeMethod(innerFn, self, context);
	      return generator;
	    }

	    exports.wrap = wrap; // Try/catch helper to minimize deoptimizations. Returns a completion
	    // record like context.tryEntries[i].completion. This interface could
	    // have been (and was previously) designed to take a closure to be
	    // invoked without arguments, but in all the cases we care about we
	    // already have an existing method we want to call, so there's no need
	    // to create a new function object. We can even get away with assuming
	    // the method takes exactly one argument, since that happens to be true
	    // in every case, so we don't have to touch the arguments object. The
	    // only additional allocation required is the completion record, which
	    // has a stable shape and so hopefully should be cheap to allocate.

	    function tryCatch(fn, obj, arg) {
	      try {
	        return {
	          type: "normal",
	          arg: fn.call(obj, arg)
	        };
	      } catch (err) {
	        return {
	          type: "throw",
	          arg: err
	        };
	      }
	    }

	    var GenStateSuspendedStart = "suspendedStart";
	    var GenStateSuspendedYield = "suspendedYield";
	    var GenStateExecuting = "executing";
	    var GenStateCompleted = "completed"; // Returning this object from the innerFn has the same effect as
	    // breaking out of the dispatch switch statement.

	    var ContinueSentinel = {}; // Dummy constructor functions that we use as the .constructor and
	    // .constructor.prototype properties for functions that return Generator
	    // objects. For full spec compliance, you may wish to configure your
	    // minifier not to mangle the names of these two functions.

	    function Generator() {}

	    function GeneratorFunction() {}

	    function GeneratorFunctionPrototype() {} // This is a polyfill for %IteratorPrototype% for environments that
	    // don't natively support it.


	    var IteratorPrototype = {};

	    IteratorPrototype[iteratorSymbol] = function () {
	      return this;
	    };

	    var getProto = Object.getPrototypeOf;
	    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

	    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	      // This environment has a native %IteratorPrototype%; use it instead
	      // of the polyfill.
	      IteratorPrototype = NativeIteratorPrototype;
	    }

	    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
	    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	    GeneratorFunctionPrototype.constructor = GeneratorFunction;
	    GeneratorFunctionPrototype[toStringTagSymbol] = GeneratorFunction.displayName = "GeneratorFunction"; // Helper for defining the .next, .throw, and .return methods of the
	    // Iterator interface in terms of a single ._invoke method.

	    function defineIteratorMethods(prototype) {
	      ["next", "throw", "return"].forEach(function (method) {
	        prototype[method] = function (arg) {
	          return this._invoke(method, arg);
	        };
	      });
	    }

	    exports.isGeneratorFunction = function (genFun) {
	      var ctor = typeof genFun === "function" && genFun.constructor;
	      return ctor ? ctor === GeneratorFunction || // For the native GeneratorFunction constructor, the best we can
	      // do is to check its .name property.
	      (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
	    };

	    exports.mark = function (genFun) {
	      if (Object.setPrototypeOf) {
	        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	      } else {
	        genFun.__proto__ = GeneratorFunctionPrototype;

	        if (!(toStringTagSymbol in genFun)) {
	          genFun[toStringTagSymbol] = "GeneratorFunction";
	        }
	      }

	      genFun.prototype = Object.create(Gp);
	      return genFun;
	    }; // Within the body of any async function, `await x` is transformed to
	    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	    // `hasOwn.call(value, "__await")` to determine if the yielded value is
	    // meant to be awaited.


	    exports.awrap = function (arg) {
	      return {
	        __await: arg
	      };
	    };

	    function AsyncIterator(generator, PromiseImpl) {
	      function invoke(method, arg, resolve, reject) {
	        var record = tryCatch(generator[method], generator, arg);

	        if (record.type === "throw") {
	          reject(record.arg);
	        } else {
	          var result = record.arg;
	          var value = result.value;

	          if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
	            return PromiseImpl.resolve(value.__await).then(function (value) {
	              invoke("next", value, resolve, reject);
	            }, function (err) {
	              invoke("throw", err, resolve, reject);
	            });
	          }

	          return PromiseImpl.resolve(value).then(function (unwrapped) {
	            // When a yielded Promise is resolved, its final value becomes
	            // the .value of the Promise<{value,done}> result for the
	            // current iteration.
	            result.value = unwrapped;
	            resolve(result);
	          }, function (error) {
	            // If a rejected Promise was yielded, throw the rejection back
	            // into the async generator function so it can be handled there.
	            return invoke("throw", error, resolve, reject);
	          });
	        }
	      }

	      var previousPromise;

	      function enqueue(method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }

	        return previousPromise = // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, // Avoid propagating failures to Promises returned by later
	        // invocations of the iterator.
	        callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      } // Define the unified helper method that is used to implement .next,
	      // .throw, and .return (see defineIteratorMethods).


	      this._invoke = enqueue;
	    }

	    defineIteratorMethods(AsyncIterator.prototype);

	    AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	      return this;
	    };

	    exports.AsyncIterator = AsyncIterator; // Note that simple async functions are implemented on top of
	    // AsyncIterator objects; they just return a Promise for the value of
	    // the final result produced by the iterator.

	    exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	      if (PromiseImpl === void 0) PromiseImpl = Promise;
	      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	      return exports.isGeneratorFunction(outerFn) ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function (result) {
	        return result.done ? result.value : iter.next();
	      });
	    };

	    function makeInvokeMethod(innerFn, self, context) {
	      var state = GenStateSuspendedStart;
	      return function invoke(method, arg) {
	        if (state === GenStateExecuting) {
	          throw new Error("Generator is already running");
	        }

	        if (state === GenStateCompleted) {
	          if (method === "throw") {
	            throw arg;
	          } // Be forgiving, per 25.3.3.3.3 of the spec:
	          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume


	          return doneResult();
	        }

	        context.method = method;
	        context.arg = arg;

	        while (true) {
	          var delegate = context.delegate;

	          if (delegate) {
	            var delegateResult = maybeInvokeDelegate(delegate, context);

	            if (delegateResult) {
	              if (delegateResult === ContinueSentinel) continue;
	              return delegateResult;
	            }
	          }

	          if (context.method === "next") {
	            // Setting context._sent for legacy support of Babel's
	            // function.sent implementation.
	            context.sent = context._sent = context.arg;
	          } else if (context.method === "throw") {
	            if (state === GenStateSuspendedStart) {
	              state = GenStateCompleted;
	              throw context.arg;
	            }

	            context.dispatchException(context.arg);
	          } else if (context.method === "return") {
	            context.abrupt("return", context.arg);
	          }

	          state = GenStateExecuting;
	          var record = tryCatch(innerFn, self, context);

	          if (record.type === "normal") {
	            // If an exception is thrown from innerFn, we leave state ===
	            // GenStateExecuting and loop back for another invocation.
	            state = context.done ? GenStateCompleted : GenStateSuspendedYield;

	            if (record.arg === ContinueSentinel) {
	              continue;
	            }

	            return {
	              value: record.arg,
	              done: context.done
	            };
	          } else if (record.type === "throw") {
	            state = GenStateCompleted; // Dispatch the exception by looping back around to the
	            // context.dispatchException(context.arg) call above.

	            context.method = "throw";
	            context.arg = record.arg;
	          }
	        }
	      };
	    } // Call delegate.iterator[context.method](context.arg) and handle the
	    // result, either by returning a { value, done } result from the
	    // delegate iterator, or by modifying context.method and context.arg,
	    // setting context.delegate to null, and returning the ContinueSentinel.


	    function maybeInvokeDelegate(delegate, context) {
	      var method = delegate.iterator[context.method];

	      if (method === undefined$1) {
	        // A .throw or .return when the delegate iterator has no .throw
	        // method always terminates the yield* loop.
	        context.delegate = null;

	        if (context.method === "throw") {
	          // Note: ["return"] must be used for ES3 parsing compatibility.
	          if (delegate.iterator["return"]) {
	            // If the delegate iterator has a return method, give it a
	            // chance to clean up.
	            context.method = "return";
	            context.arg = undefined$1;
	            maybeInvokeDelegate(delegate, context);

	            if (context.method === "throw") {
	              // If maybeInvokeDelegate(context) changed context.method from
	              // "return" to "throw", let that override the TypeError below.
	              return ContinueSentinel;
	            }
	          }

	          context.method = "throw";
	          context.arg = new TypeError("The iterator does not provide a 'throw' method");
	        }

	        return ContinueSentinel;
	      }

	      var record = tryCatch(method, delegate.iterator, context.arg);

	      if (record.type === "throw") {
	        context.method = "throw";
	        context.arg = record.arg;
	        context.delegate = null;
	        return ContinueSentinel;
	      }

	      var info = record.arg;

	      if (!info) {
	        context.method = "throw";
	        context.arg = new TypeError("iterator result is not an object");
	        context.delegate = null;
	        return ContinueSentinel;
	      }

	      if (info.done) {
	        // Assign the result of the finished delegate to the temporary
	        // variable specified by delegate.resultName (see delegateYield).
	        context[delegate.resultName] = info.value; // Resume execution at the desired location (see delegateYield).

	        context.next = delegate.nextLoc; // If context.method was "throw" but the delegate handled the
	        // exception, let the outer generator proceed normally. If
	        // context.method was "next", forget context.arg since it has been
	        // "consumed" by the delegate iterator. If context.method was
	        // "return", allow the original .return call to continue in the
	        // outer generator.

	        if (context.method !== "return") {
	          context.method = "next";
	          context.arg = undefined$1;
	        }
	      } else {
	        // Re-yield the result returned by the delegate method.
	        return info;
	      } // The delegate iterator is finished, so forget it and continue with
	      // the outer generator.


	      context.delegate = null;
	      return ContinueSentinel;
	    } // Define Generator.prototype.{next,throw,return} in terms of the
	    // unified ._invoke helper method.


	    defineIteratorMethods(Gp);
	    Gp[toStringTagSymbol] = "Generator"; // A Generator should always return itself as the iterator object when the
	    // @@iterator function is called on it. Some browsers' implementations of the
	    // iterator prototype chain incorrectly implement this, causing the Generator
	    // object to not be returned from this call. This ensures that doesn't happen.
	    // See https://github.com/facebook/regenerator/issues/274 for more details.

	    Gp[iteratorSymbol] = function () {
	      return this;
	    };

	    Gp.toString = function () {
	      return "[object Generator]";
	    };

	    function pushTryEntry(locs) {
	      var entry = {
	        tryLoc: locs[0]
	      };

	      if (1 in locs) {
	        entry.catchLoc = locs[1];
	      }

	      if (2 in locs) {
	        entry.finallyLoc = locs[2];
	        entry.afterLoc = locs[3];
	      }

	      this.tryEntries.push(entry);
	    }

	    function resetTryEntry(entry) {
	      var record = entry.completion || {};
	      record.type = "normal";
	      delete record.arg;
	      entry.completion = record;
	    }

	    function Context(tryLocsList) {
	      // The root entry object (effectively a try statement without a catch
	      // or a finally block) gives us a place to store values thrown from
	      // locations where there is no enclosing try statement.
	      this.tryEntries = [{
	        tryLoc: "root"
	      }];
	      tryLocsList.forEach(pushTryEntry, this);
	      this.reset(true);
	    }

	    exports.keys = function (object) {
	      var keys = [];

	      for (var key in object) {
	        keys.push(key);
	      }

	      keys.reverse(); // Rather than returning an object with a next method, we keep
	      // things simple and return the next function itself.

	      return function next() {
	        while (keys.length) {
	          var key = keys.pop();

	          if (key in object) {
	            next.value = key;
	            next.done = false;
	            return next;
	          }
	        } // To avoid creating an additional object, we just hang the .value
	        // and .done properties off the next function object itself. This
	        // also ensures that the minifier will not anonymize the function.


	        next.done = true;
	        return next;
	      };
	    };

	    function values(iterable) {
	      if (iterable) {
	        var iteratorMethod = iterable[iteratorSymbol];

	        if (iteratorMethod) {
	          return iteratorMethod.call(iterable);
	        }

	        if (typeof iterable.next === "function") {
	          return iterable;
	        }

	        if (!isNaN(iterable.length)) {
	          var i = -1,
	              next = function next() {
	            while (++i < iterable.length) {
	              if (hasOwn.call(iterable, i)) {
	                next.value = iterable[i];
	                next.done = false;
	                return next;
	              }
	            }

	            next.value = undefined$1;
	            next.done = true;
	            return next;
	          };

	          return next.next = next;
	        }
	      } // Return an iterator with no values.


	      return {
	        next: doneResult
	      };
	    }

	    exports.values = values;

	    function doneResult() {
	      return {
	        value: undefined$1,
	        done: true
	      };
	    }

	    Context.prototype = {
	      constructor: Context,
	      reset: function (skipTempReset) {
	        this.prev = 0;
	        this.next = 0; // Resetting context._sent for legacy support of Babel's
	        // function.sent implementation.

	        this.sent = this._sent = undefined$1;
	        this.done = false;
	        this.delegate = null;
	        this.method = "next";
	        this.arg = undefined$1;
	        this.tryEntries.forEach(resetTryEntry);

	        if (!skipTempReset) {
	          for (var name in this) {
	            // Not sure about the optimal order of these conditions:
	            if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
	              this[name] = undefined$1;
	            }
	          }
	        }
	      },
	      stop: function () {
	        this.done = true;
	        var rootEntry = this.tryEntries[0];
	        var rootRecord = rootEntry.completion;

	        if (rootRecord.type === "throw") {
	          throw rootRecord.arg;
	        }

	        return this.rval;
	      },
	      dispatchException: function (exception) {
	        if (this.done) {
	          throw exception;
	        }

	        var context = this;

	        function handle(loc, caught) {
	          record.type = "throw";
	          record.arg = exception;
	          context.next = loc;

	          if (caught) {
	            // If the dispatched exception was caught by a catch block,
	            // then let that catch block handle the exception normally.
	            context.method = "next";
	            context.arg = undefined$1;
	          }

	          return !!caught;
	        }

	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          var record = entry.completion;

	          if (entry.tryLoc === "root") {
	            // Exception thrown outside of any try block that could handle
	            // it, so set the completion value of the entire function to
	            // throw the exception.
	            return handle("end");
	          }

	          if (entry.tryLoc <= this.prev) {
	            var hasCatch = hasOwn.call(entry, "catchLoc");
	            var hasFinally = hasOwn.call(entry, "finallyLoc");

	            if (hasCatch && hasFinally) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              } else if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else if (hasCatch) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              }
	            } else if (hasFinally) {
	              if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else {
	              throw new Error("try statement without catch or finally");
	            }
	          }
	        }
	      },
	      abrupt: function (type, arg) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	            var finallyEntry = entry;
	            break;
	          }
	        }

	        if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
	          // Ignore the finally entry if control is not jumping to a
	          // location outside the try/catch block.
	          finallyEntry = null;
	        }

	        var record = finallyEntry ? finallyEntry.completion : {};
	        record.type = type;
	        record.arg = arg;

	        if (finallyEntry) {
	          this.method = "next";
	          this.next = finallyEntry.finallyLoc;
	          return ContinueSentinel;
	        }

	        return this.complete(record);
	      },
	      complete: function (record, afterLoc) {
	        if (record.type === "throw") {
	          throw record.arg;
	        }

	        if (record.type === "break" || record.type === "continue") {
	          this.next = record.arg;
	        } else if (record.type === "return") {
	          this.rval = this.arg = record.arg;
	          this.method = "return";
	          this.next = "end";
	        } else if (record.type === "normal" && afterLoc) {
	          this.next = afterLoc;
	        }

	        return ContinueSentinel;
	      },
	      finish: function (finallyLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.finallyLoc === finallyLoc) {
	            this.complete(entry.completion, entry.afterLoc);
	            resetTryEntry(entry);
	            return ContinueSentinel;
	          }
	        }
	      },
	      "catch": function (tryLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc === tryLoc) {
	            var record = entry.completion;

	            if (record.type === "throw") {
	              var thrown = record.arg;
	              resetTryEntry(entry);
	            }

	            return thrown;
	          }
	        } // The context.catch method must only be called with a location
	        // argument that corresponds to a known catch block.


	        throw new Error("illegal catch attempt");
	      },
	      delegateYield: function (iterable, resultName, nextLoc) {
	        this.delegate = {
	          iterator: values(iterable),
	          resultName: resultName,
	          nextLoc: nextLoc
	        };

	        if (this.method === "next") {
	          // Deliberately forget the last sent value so that we don't
	          // accidentally pass it on to the delegate.
	          this.arg = undefined$1;
	        }

	        return ContinueSentinel;
	      }
	    }; // Regardless of whether this script is executing as a CommonJS module
	    // or not, return the runtime object so that we can declare the variable
	    // regeneratorRuntime in the outer scope, which allows this module to be
	    // injected easily by `bin/regenerator --include-runtime script.js`.

	    return exports;
	  }( // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	   module.exports );

	  try {
	    regeneratorRuntime = runtime;
	  } catch (accidentalStrictMode) {
	    // This module should not be running in strict mode, so the above
	    // assignment should always work unless something is misconfigured. Just
	    // in case runtime.js accidentally runs in strict mode, we can escape
	    // strict mode using a global Function call. This could conceivably fail
	    // if a Content Security Policy forbids using Function, but in that case
	    // the proper solution is to fix the accidental strict mode problem. If
	    // you've misconfigured your bundler to force strict mode and applied a
	    // CSP to forbid Function, and you're not willing to fix either of those
	    // problems, please detail your unique predicament in a GitHub issue.
	    Function("r", "regeneratorRuntime = r")(runtime);
	  }
	});

	var regenerator = runtime_1;

	var iterator$3 = iterator;

	var iterator$4 = iterator$3;

	// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray


	var flattenIntoArray = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
	  var targetIndex = start;
	  var sourceIndex = 0;
	  var mapFn = mapper ? functionBindContext(mapper, thisArg, 3) : false;
	  var element;

	  while (sourceIndex < sourceLen) {
	    if (sourceIndex in source) {
	      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

	      if (depth > 0 && isArray(element)) {
	        targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;
	      } else {
	        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError('Exceed the acceptable array length');
	        target[targetIndex] = element;
	      }

	      targetIndex++;
	    }

	    sourceIndex++;
	  }

	  return targetIndex;
	};

	var flattenIntoArray_1 = flattenIntoArray;

	// https://github.com/tc39/proposal-flatMap


	_export({
	  target: 'Array',
	  proto: true
	}, {
	  flatMap: function flatMap(callbackfn
	  /* , thisArg */
	  ) {
	    var O = toObject(this);
	    var sourceLen = toLength(O.length);
	    var A;
	    aFunction(callbackfn);
	    A = arraySpeciesCreate(O, 0);
	    A.length = flattenIntoArray_1(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    return A;
	  }
	});

	var flatMap = entryVirtual('Array').flatMap;

	var ArrayPrototype$e = Array.prototype;

	var flatMap_1 = function (it) {
	  var own = it.flatMap;
	  return it === ArrayPrototype$e || it instanceof Array && own === ArrayPrototype$e.flatMap ? flatMap : own;
	};

	var flatMap$1 = flatMap_1;

	var flatMap$2 = flatMap$1;

	var createMethod$5 = function (IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aFunction(callbackfn);
	    var O = toObject(that);
	    var self = indexedObject(O);
	    var length = toLength(O.length);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }

	      index += i;

	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw TypeError('Reduce of empty array with no initial value');
	      }
	    }

	    for (; IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
	      memo = callbackfn(memo, self[index], index, O);
	    }

	    return memo;
	  };
	};

	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.reduce
	  left: createMethod$5(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
	  right: createMethod$5(true)
	};

	var $reduce = arrayReduce.left;
	var STRICT_METHOD$4 = arrayMethodIsStrict('reduce');
	var USES_TO_LENGTH$8 = arrayMethodUsesToLength('reduce', {
	  1: 0
	}); // `Array.prototype.reduce` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.reduce

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$4 || !USES_TO_LENGTH$8
	}, {
	  reduce: function reduce(callbackfn
	  /* , initialValue */
	  ) {
	    return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});

	var reduce = entryVirtual('Array').reduce;

	var ArrayPrototype$f = Array.prototype;

	var reduce_1 = function (it) {
	  var own = it.reduce;
	  return it === ArrayPrototype$f || it instanceof Array && own === ArrayPrototype$f.reduce ? reduce : own;
	};

	var reduce$1 = reduce_1;

	var reduce$2 = reduce$1;

	// Unique ID creation requires a high quality random # generator. In the browser we therefore
	// require the crypto API and do not support built-in fallback to lower quality random number
	// generators (like Math.random()).
	// getRandomValues needs to be invoked in a context where "this" is a Crypto implementation. Also,
	// find the complete implementation of crypto (msCrypto) on IE11.
	var getRandomValues = typeof crypto != 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto != 'undefined' && typeof msCrypto.getRandomValues == 'function' && msCrypto.getRandomValues.bind(msCrypto);
	var rnds8 = new Uint8Array(16); // eslint-disable-line no-undef

	function rng() {
	  if (!getRandomValues) {
	    throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
	  }

	  return getRandomValues(rnds8);
	}

	/**
	 * Convert array of 16 byte values to UUID string format of the form:
	 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
	 */
	var byteToHex = [];

	for (var i = 0; i < 256; ++i) {
	  byteToHex[i] = (i + 0x100).toString(16).substr(1);
	}

	function bytesToUuid(buf, offset) {
	  var i = offset || 0;
	  var bth = byteToHex; // join used to fix memory issue caused by concatenation: https://bugs.chromium.org/p/v8/issues/detail?id=3175#c4

	  return [bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], '-', bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]], bth[buf[i++]]].join('');
	}

	function v4(options, buf, offset) {
	  var i = buf && offset || 0;

	  if (typeof options == 'string') {
	    buf = options === 'binary' ? new Array(16) : null;
	    options = null;
	  }

	  options = options || {};
	  var rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

	  rnds[6] = rnds[6] & 0x0f | 0x40;
	  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

	  if (buf) {
	    for (var ii = 0; ii < 16; ++ii) {
	      buf[i + ii] = rnds[ii];
	    }
	  }

	  return buf || bytesToUuid(rnds);
	}

	var moment = createCommonjsModule(function (module, exports) {

	  (function (global, factory) {
	     module.exports = factory() ;
	  })(commonjsGlobal, function () {

	    var hookCallback;

	    function hooks() {
	      return hookCallback.apply(null, arguments);
	    } // This is done to register the method called with moment()
	    // without creating circular dependencies.


	    function setHookCallback(callback) {
	      hookCallback = callback;
	    }

	    function isArray(input) {
	      return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
	    }

	    function isObject(input) {
	      // IE8 will treat undefined and null as object if it wasn't for
	      // input != null
	      return input != null && Object.prototype.toString.call(input) === '[object Object]';
	    }

	    function isObjectEmpty(obj) {
	      if (Object.getOwnPropertyNames) {
	        return Object.getOwnPropertyNames(obj).length === 0;
	      } else {
	        var k;

	        for (k in obj) {
	          if (obj.hasOwnProperty(k)) {
	            return false;
	          }
	        }

	        return true;
	      }
	    }

	    function isUndefined(input) {
	      return input === void 0;
	    }

	    function isNumber(input) {
	      return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
	    }

	    function isDate(input) {
	      return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
	    }

	    function map(arr, fn) {
	      var res = [],
	          i;

	      for (i = 0; i < arr.length; ++i) {
	        res.push(fn(arr[i], i));
	      }

	      return res;
	    }

	    function hasOwnProp(a, b) {
	      return Object.prototype.hasOwnProperty.call(a, b);
	    }

	    function extend(a, b) {
	      for (var i in b) {
	        if (hasOwnProp(b, i)) {
	          a[i] = b[i];
	        }
	      }

	      if (hasOwnProp(b, 'toString')) {
	        a.toString = b.toString;
	      }

	      if (hasOwnProp(b, 'valueOf')) {
	        a.valueOf = b.valueOf;
	      }

	      return a;
	    }

	    function createUTC(input, format, locale, strict) {
	      return createLocalOrUTC(input, format, locale, strict, true).utc();
	    }

	    function defaultParsingFlags() {
	      // We need to deep clone this object.
	      return {
	        empty: false,
	        unusedTokens: [],
	        unusedInput: [],
	        overflow: -2,
	        charsLeftOver: 0,
	        nullInput: false,
	        invalidMonth: null,
	        invalidFormat: false,
	        userInvalidated: false,
	        iso: false,
	        parsedDateParts: [],
	        meridiem: null,
	        rfc2822: false,
	        weekdayMismatch: false
	      };
	    }

	    function getParsingFlags(m) {
	      if (m._pf == null) {
	        m._pf = defaultParsingFlags();
	      }

	      return m._pf;
	    }

	    var some;

	    if (Array.prototype.some) {
	      some = Array.prototype.some;
	    } else {
	      some = function (fun) {
	        var t = Object(this);
	        var len = t.length >>> 0;

	        for (var i = 0; i < len; i++) {
	          if (i in t && fun.call(this, t[i], i, t)) {
	            return true;
	          }
	        }

	        return false;
	      };
	    }

	    function isValid(m) {
	      if (m._isValid == null) {
	        var flags = getParsingFlags(m);
	        var parsedParts = some.call(flags.parsedDateParts, function (i) {
	          return i != null;
	        });
	        var isNowValid = !isNaN(m._d.getTime()) && flags.overflow < 0 && !flags.empty && !flags.invalidMonth && !flags.invalidWeekday && !flags.weekdayMismatch && !flags.nullInput && !flags.invalidFormat && !flags.userInvalidated && (!flags.meridiem || flags.meridiem && parsedParts);

	        if (m._strict) {
	          isNowValid = isNowValid && flags.charsLeftOver === 0 && flags.unusedTokens.length === 0 && flags.bigHour === undefined;
	        }

	        if (Object.isFrozen == null || !Object.isFrozen(m)) {
	          m._isValid = isNowValid;
	        } else {
	          return isNowValid;
	        }
	      }

	      return m._isValid;
	    }

	    function createInvalid(flags) {
	      var m = createUTC(NaN);

	      if (flags != null) {
	        extend(getParsingFlags(m), flags);
	      } else {
	        getParsingFlags(m).userInvalidated = true;
	      }

	      return m;
	    } // Plugins that add properties should also add the key here (null value),
	    // so we can properly clone ourselves.


	    var momentProperties = hooks.momentProperties = [];

	    function copyConfig(to, from) {
	      var i, prop, val;

	      if (!isUndefined(from._isAMomentObject)) {
	        to._isAMomentObject = from._isAMomentObject;
	      }

	      if (!isUndefined(from._i)) {
	        to._i = from._i;
	      }

	      if (!isUndefined(from._f)) {
	        to._f = from._f;
	      }

	      if (!isUndefined(from._l)) {
	        to._l = from._l;
	      }

	      if (!isUndefined(from._strict)) {
	        to._strict = from._strict;
	      }

	      if (!isUndefined(from._tzm)) {
	        to._tzm = from._tzm;
	      }

	      if (!isUndefined(from._isUTC)) {
	        to._isUTC = from._isUTC;
	      }

	      if (!isUndefined(from._offset)) {
	        to._offset = from._offset;
	      }

	      if (!isUndefined(from._pf)) {
	        to._pf = getParsingFlags(from);
	      }

	      if (!isUndefined(from._locale)) {
	        to._locale = from._locale;
	      }

	      if (momentProperties.length > 0) {
	        for (i = 0; i < momentProperties.length; i++) {
	          prop = momentProperties[i];
	          val = from[prop];

	          if (!isUndefined(val)) {
	            to[prop] = val;
	          }
	        }
	      }

	      return to;
	    }

	    var updateInProgress = false; // Moment prototype object

	    function Moment(config) {
	      copyConfig(this, config);
	      this._d = new Date(config._d != null ? config._d.getTime() : NaN);

	      if (!this.isValid()) {
	        this._d = new Date(NaN);
	      } // Prevent infinite loop in case updateOffset creates new moment
	      // objects.


	      if (updateInProgress === false) {
	        updateInProgress = true;
	        hooks.updateOffset(this);
	        updateInProgress = false;
	      }
	    }

	    function isMoment(obj) {
	      return obj instanceof Moment || obj != null && obj._isAMomentObject != null;
	    }

	    function absFloor(number) {
	      if (number < 0) {
	        // -0 -> 0
	        return Math.ceil(number) || 0;
	      } else {
	        return Math.floor(number);
	      }
	    }

	    function toInt(argumentForCoercion) {
	      var coercedNumber = +argumentForCoercion,
	          value = 0;

	      if (coercedNumber !== 0 && isFinite(coercedNumber)) {
	        value = absFloor(coercedNumber);
	      }

	      return value;
	    } // compare two arrays, return the number of differences


	    function compareArrays(array1, array2, dontConvert) {
	      var len = Math.min(array1.length, array2.length),
	          lengthDiff = Math.abs(array1.length - array2.length),
	          diffs = 0,
	          i;

	      for (i = 0; i < len; i++) {
	        if (dontConvert && array1[i] !== array2[i] || !dontConvert && toInt(array1[i]) !== toInt(array2[i])) {
	          diffs++;
	        }
	      }

	      return diffs + lengthDiff;
	    }

	    function warn(msg) {
	      if (hooks.suppressDeprecationWarnings === false && typeof console !== 'undefined' && console.warn) {
	        console.warn('Deprecation warning: ' + msg);
	      }
	    }

	    function deprecate(msg, fn) {
	      var firstTime = true;
	      return extend(function () {
	        if (hooks.deprecationHandler != null) {
	          hooks.deprecationHandler(null, msg);
	        }

	        if (firstTime) {
	          var args = [];
	          var arg;

	          for (var i = 0; i < arguments.length; i++) {
	            arg = '';

	            if (typeof arguments[i] === 'object') {
	              arg += '\n[' + i + '] ';

	              for (var key in arguments[0]) {
	                arg += key + ': ' + arguments[0][key] + ', ';
	              }

	              arg = arg.slice(0, -2); // Remove trailing comma and space
	            } else {
	              arg = arguments[i];
	            }

	            args.push(arg);
	          }

	          warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + new Error().stack);
	          firstTime = false;
	        }

	        return fn.apply(this, arguments);
	      }, fn);
	    }

	    var deprecations = {};

	    function deprecateSimple(name, msg) {
	      if (hooks.deprecationHandler != null) {
	        hooks.deprecationHandler(name, msg);
	      }

	      if (!deprecations[name]) {
	        warn(msg);
	        deprecations[name] = true;
	      }
	    }

	    hooks.suppressDeprecationWarnings = false;
	    hooks.deprecationHandler = null;

	    function isFunction(input) {
	      return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
	    }

	    function set(config) {
	      var prop, i;

	      for (i in config) {
	        prop = config[i];

	        if (isFunction(prop)) {
	          this[i] = prop;
	        } else {
	          this['_' + i] = prop;
	        }
	      }

	      this._config = config; // Lenient ordinal parsing accepts just a number in addition to
	      // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
	      // TODO: Remove "ordinalParse" fallback in next major release.

	      this._dayOfMonthOrdinalParseLenient = new RegExp((this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) + '|' + /\d{1,2}/.source);
	    }

	    function mergeConfigs(parentConfig, childConfig) {
	      var res = extend({}, parentConfig),
	          prop;

	      for (prop in childConfig) {
	        if (hasOwnProp(childConfig, prop)) {
	          if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
	            res[prop] = {};
	            extend(res[prop], parentConfig[prop]);
	            extend(res[prop], childConfig[prop]);
	          } else if (childConfig[prop] != null) {
	            res[prop] = childConfig[prop];
	          } else {
	            delete res[prop];
	          }
	        }
	      }

	      for (prop in parentConfig) {
	        if (hasOwnProp(parentConfig, prop) && !hasOwnProp(childConfig, prop) && isObject(parentConfig[prop])) {
	          // make sure changes to properties don't modify parent config
	          res[prop] = extend({}, res[prop]);
	        }
	      }

	      return res;
	    }

	    function Locale(config) {
	      if (config != null) {
	        this.set(config);
	      }
	    }

	    var keys;

	    if (Object.keys) {
	      keys = Object.keys;
	    } else {
	      keys = function (obj) {
	        var i,
	            res = [];

	        for (i in obj) {
	          if (hasOwnProp(obj, i)) {
	            res.push(i);
	          }
	        }

	        return res;
	      };
	    }

	    var defaultCalendar = {
	      sameDay: '[Today at] LT',
	      nextDay: '[Tomorrow at] LT',
	      nextWeek: 'dddd [at] LT',
	      lastDay: '[Yesterday at] LT',
	      lastWeek: '[Last] dddd [at] LT',
	      sameElse: 'L'
	    };

	    function calendar(key, mom, now) {
	      var output = this._calendar[key] || this._calendar['sameElse'];
	      return isFunction(output) ? output.call(mom, now) : output;
	    }

	    var defaultLongDateFormat = {
	      LTS: 'h:mm:ss A',
	      LT: 'h:mm A',
	      L: 'MM/DD/YYYY',
	      LL: 'MMMM D, YYYY',
	      LLL: 'MMMM D, YYYY h:mm A',
	      LLLL: 'dddd, MMMM D, YYYY h:mm A'
	    };

	    function longDateFormat(key) {
	      var format = this._longDateFormat[key],
	          formatUpper = this._longDateFormat[key.toUpperCase()];

	      if (format || !formatUpper) {
	        return format;
	      }

	      this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
	        return val.slice(1);
	      });
	      return this._longDateFormat[key];
	    }

	    var defaultInvalidDate = 'Invalid date';

	    function invalidDate() {
	      return this._invalidDate;
	    }

	    var defaultOrdinal = '%d';
	    var defaultDayOfMonthOrdinalParse = /\d{1,2}/;

	    function ordinal(number) {
	      return this._ordinal.replace('%d', number);
	    }

	    var defaultRelativeTime = {
	      future: 'in %s',
	      past: '%s ago',
	      s: 'a few seconds',
	      ss: '%d seconds',
	      m: 'a minute',
	      mm: '%d minutes',
	      h: 'an hour',
	      hh: '%d hours',
	      d: 'a day',
	      dd: '%d days',
	      M: 'a month',
	      MM: '%d months',
	      y: 'a year',
	      yy: '%d years'
	    };

	    function relativeTime(number, withoutSuffix, string, isFuture) {
	      var output = this._relativeTime[string];
	      return isFunction(output) ? output(number, withoutSuffix, string, isFuture) : output.replace(/%d/i, number);
	    }

	    function pastFuture(diff, output) {
	      var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
	      return isFunction(format) ? format(output) : format.replace(/%s/i, output);
	    }

	    var aliases = {};

	    function addUnitAlias(unit, shorthand) {
	      var lowerCase = unit.toLowerCase();
	      aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
	    }

	    function normalizeUnits(units) {
	      return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
	    }

	    function normalizeObjectUnits(inputObject) {
	      var normalizedInput = {},
	          normalizedProp,
	          prop;

	      for (prop in inputObject) {
	        if (hasOwnProp(inputObject, prop)) {
	          normalizedProp = normalizeUnits(prop);

	          if (normalizedProp) {
	            normalizedInput[normalizedProp] = inputObject[prop];
	          }
	        }
	      }

	      return normalizedInput;
	    }

	    var priorities = {};

	    function addUnitPriority(unit, priority) {
	      priorities[unit] = priority;
	    }

	    function getPrioritizedUnits(unitsObj) {
	      var units = [];

	      for (var u in unitsObj) {
	        units.push({
	          unit: u,
	          priority: priorities[u]
	        });
	      }

	      units.sort(function (a, b) {
	        return a.priority - b.priority;
	      });
	      return units;
	    }

	    function zeroFill(number, targetLength, forceSign) {
	      var absNumber = '' + Math.abs(number),
	          zerosToFill = targetLength - absNumber.length,
	          sign = number >= 0;
	      return (sign ? forceSign ? '+' : '' : '-') + Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
	    }

	    var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;
	    var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;
	    var formatFunctions = {};
	    var formatTokenFunctions = {}; // token:    'M'
	    // padded:   ['MM', 2]
	    // ordinal:  'Mo'
	    // callback: function () { this.month() + 1 }

	    function addFormatToken(token, padded, ordinal, callback) {
	      var func = callback;

	      if (typeof callback === 'string') {
	        func = function () {
	          return this[callback]();
	        };
	      }

	      if (token) {
	        formatTokenFunctions[token] = func;
	      }

	      if (padded) {
	        formatTokenFunctions[padded[0]] = function () {
	          return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
	        };
	      }

	      if (ordinal) {
	        formatTokenFunctions[ordinal] = function () {
	          return this.localeData().ordinal(func.apply(this, arguments), token);
	        };
	      }
	    }

	    function removeFormattingTokens(input) {
	      if (input.match(/\[[\s\S]/)) {
	        return input.replace(/^\[|\]$/g, '');
	      }

	      return input.replace(/\\/g, '');
	    }

	    function makeFormatFunction(format) {
	      var array = format.match(formattingTokens),
	          i,
	          length;

	      for (i = 0, length = array.length; i < length; i++) {
	        if (formatTokenFunctions[array[i]]) {
	          array[i] = formatTokenFunctions[array[i]];
	        } else {
	          array[i] = removeFormattingTokens(array[i]);
	        }
	      }

	      return function (mom) {
	        var output = '',
	            i;

	        for (i = 0; i < length; i++) {
	          output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
	        }

	        return output;
	      };
	    } // format date using native date object


	    function formatMoment(m, format) {
	      if (!m.isValid()) {
	        return m.localeData().invalidDate();
	      }

	      format = expandFormat(format, m.localeData());
	      formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);
	      return formatFunctions[format](m);
	    }

	    function expandFormat(format, locale) {
	      var i = 5;

	      function replaceLongDateFormatTokens(input) {
	        return locale.longDateFormat(input) || input;
	      }

	      localFormattingTokens.lastIndex = 0;

	      while (i >= 0 && localFormattingTokens.test(format)) {
	        format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
	        localFormattingTokens.lastIndex = 0;
	        i -= 1;
	      }

	      return format;
	    }

	    var match1 = /\d/; //       0 - 9

	    var match2 = /\d\d/; //      00 - 99

	    var match3 = /\d{3}/; //     000 - 999

	    var match4 = /\d{4}/; //    0000 - 9999

	    var match6 = /[+-]?\d{6}/; // -999999 - 999999

	    var match1to2 = /\d\d?/; //       0 - 99

	    var match3to4 = /\d\d\d\d?/; //     999 - 9999

	    var match5to6 = /\d\d\d\d\d\d?/; //   99999 - 999999

	    var match1to3 = /\d{1,3}/; //       0 - 999

	    var match1to4 = /\d{1,4}/; //       0 - 9999

	    var match1to6 = /[+-]?\d{1,6}/; // -999999 - 999999

	    var matchUnsigned = /\d+/; //       0 - inf

	    var matchSigned = /[+-]?\d+/; //    -inf - inf

	    var matchOffset = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z

	    var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z

	    var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123
	    // any word (or two) characters or numbers including two/three word month in arabic.
	    // includes scottish gaelic two word and hyphenated months

	    var matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;
	    var regexes = {};

	    function addRegexToken(token, regex, strictRegex) {
	      regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
	        return isStrict && strictRegex ? strictRegex : regex;
	      };
	    }

	    function getParseRegexForToken(token, config) {
	      if (!hasOwnProp(regexes, token)) {
	        return new RegExp(unescapeFormat(token));
	      }

	      return regexes[token](config._strict, config._locale);
	    } // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript


	    function unescapeFormat(s) {
	      return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
	        return p1 || p2 || p3 || p4;
	      }));
	    }

	    function regexEscape(s) {
	      return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	    }

	    var tokens = {};

	    function addParseToken(token, callback) {
	      var i,
	          func = callback;

	      if (typeof token === 'string') {
	        token = [token];
	      }

	      if (isNumber(callback)) {
	        func = function (input, array) {
	          array[callback] = toInt(input);
	        };
	      }

	      for (i = 0; i < token.length; i++) {
	        tokens[token[i]] = func;
	      }
	    }

	    function addWeekParseToken(token, callback) {
	      addParseToken(token, function (input, array, config, token) {
	        config._w = config._w || {};
	        callback(input, config._w, config, token);
	      });
	    }

	    function addTimeToArrayFromToken(token, input, config) {
	      if (input != null && hasOwnProp(tokens, token)) {
	        tokens[token](input, config._a, config, token);
	      }
	    }

	    var YEAR = 0;
	    var MONTH = 1;
	    var DATE = 2;
	    var HOUR = 3;
	    var MINUTE = 4;
	    var SECOND = 5;
	    var MILLISECOND = 6;
	    var WEEK = 7;
	    var WEEKDAY = 8; // FORMATTING

	    addFormatToken('Y', 0, 0, function () {
	      var y = this.year();
	      return y <= 9999 ? '' + y : '+' + y;
	    });
	    addFormatToken(0, ['YY', 2], 0, function () {
	      return this.year() % 100;
	    });
	    addFormatToken(0, ['YYYY', 4], 0, 'year');
	    addFormatToken(0, ['YYYYY', 5], 0, 'year');
	    addFormatToken(0, ['YYYYYY', 6, true], 0, 'year'); // ALIASES

	    addUnitAlias('year', 'y'); // PRIORITIES

	    addUnitPriority('year', 1); // PARSING

	    addRegexToken('Y', matchSigned);
	    addRegexToken('YY', match1to2, match2);
	    addRegexToken('YYYY', match1to4, match4);
	    addRegexToken('YYYYY', match1to6, match6);
	    addRegexToken('YYYYYY', match1to6, match6);
	    addParseToken(['YYYYY', 'YYYYYY'], YEAR);
	    addParseToken('YYYY', function (input, array) {
	      array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
	    });
	    addParseToken('YY', function (input, array) {
	      array[YEAR] = hooks.parseTwoDigitYear(input);
	    });
	    addParseToken('Y', function (input, array) {
	      array[YEAR] = parseInt(input, 10);
	    }); // HELPERS

	    function daysInYear(year) {
	      return isLeapYear(year) ? 366 : 365;
	    }

	    function isLeapYear(year) {
	      return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
	    } // HOOKS


	    hooks.parseTwoDigitYear = function (input) {
	      return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
	    }; // MOMENTS


	    var getSetYear = makeGetSet('FullYear', true);

	    function getIsLeapYear() {
	      return isLeapYear(this.year());
	    }

	    function makeGetSet(unit, keepTime) {
	      return function (value) {
	        if (value != null) {
	          set$1(this, unit, value);
	          hooks.updateOffset(this, keepTime);
	          return this;
	        } else {
	          return get(this, unit);
	        }
	      };
	    }

	    function get(mom, unit) {
	      return mom.isValid() ? mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
	    }

	    function set$1(mom, unit, value) {
	      if (mom.isValid() && !isNaN(value)) {
	        if (unit === 'FullYear' && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
	          mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value, mom.month(), daysInMonth(value, mom.month()));
	        } else {
	          mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
	        }
	      }
	    } // MOMENTS


	    function stringGet(units) {
	      units = normalizeUnits(units);

	      if (isFunction(this[units])) {
	        return this[units]();
	      }

	      return this;
	    }

	    function stringSet(units, value) {
	      if (typeof units === 'object') {
	        units = normalizeObjectUnits(units);
	        var prioritized = getPrioritizedUnits(units);

	        for (var i = 0; i < prioritized.length; i++) {
	          this[prioritized[i].unit](units[prioritized[i].unit]);
	        }
	      } else {
	        units = normalizeUnits(units);

	        if (isFunction(this[units])) {
	          return this[units](value);
	        }
	      }

	      return this;
	    }

	    function mod(n, x) {
	      return (n % x + x) % x;
	    }

	    var indexOf;

	    if (Array.prototype.indexOf) {
	      indexOf = Array.prototype.indexOf;
	    } else {
	      indexOf = function (o) {
	        // I know
	        var i;

	        for (i = 0; i < this.length; ++i) {
	          if (this[i] === o) {
	            return i;
	          }
	        }

	        return -1;
	      };
	    }

	    function daysInMonth(year, month) {
	      if (isNaN(year) || isNaN(month)) {
	        return NaN;
	      }

	      var modMonth = mod(month, 12);
	      year += (month - modMonth) / 12;
	      return modMonth === 1 ? isLeapYear(year) ? 29 : 28 : 31 - modMonth % 7 % 2;
	    } // FORMATTING


	    addFormatToken('M', ['MM', 2], 'Mo', function () {
	      return this.month() + 1;
	    });
	    addFormatToken('MMM', 0, 0, function (format) {
	      return this.localeData().monthsShort(this, format);
	    });
	    addFormatToken('MMMM', 0, 0, function (format) {
	      return this.localeData().months(this, format);
	    }); // ALIASES

	    addUnitAlias('month', 'M'); // PRIORITY

	    addUnitPriority('month', 8); // PARSING

	    addRegexToken('M', match1to2);
	    addRegexToken('MM', match1to2, match2);
	    addRegexToken('MMM', function (isStrict, locale) {
	      return locale.monthsShortRegex(isStrict);
	    });
	    addRegexToken('MMMM', function (isStrict, locale) {
	      return locale.monthsRegex(isStrict);
	    });
	    addParseToken(['M', 'MM'], function (input, array) {
	      array[MONTH] = toInt(input) - 1;
	    });
	    addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
	      var month = config._locale.monthsParse(input, token, config._strict); // if we didn't find a month name, mark the date as invalid.


	      if (month != null) {
	        array[MONTH] = month;
	      } else {
	        getParsingFlags(config).invalidMonth = input;
	      }
	    }); // LOCALES

	    var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
	    var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');

	    function localeMonths(m, format) {
	      if (!m) {
	        return isArray(this._months) ? this._months : this._months['standalone'];
	      }

	      return isArray(this._months) ? this._months[m.month()] : this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
	    }

	    var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');

	    function localeMonthsShort(m, format) {
	      if (!m) {
	        return isArray(this._monthsShort) ? this._monthsShort : this._monthsShort['standalone'];
	      }

	      return isArray(this._monthsShort) ? this._monthsShort[m.month()] : this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
	    }

	    function handleStrictParse(monthName, format, strict) {
	      var i,
	          ii,
	          mom,
	          llc = monthName.toLocaleLowerCase();

	      if (!this._monthsParse) {
	        // this is not used
	        this._monthsParse = [];
	        this._longMonthsParse = [];
	        this._shortMonthsParse = [];

	        for (i = 0; i < 12; ++i) {
	          mom = createUTC([2000, i]);
	          this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
	          this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
	        }
	      }

	      if (strict) {
	        if (format === 'MMM') {
	          ii = indexOf.call(this._shortMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._longMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      } else {
	        if (format === 'MMM') {
	          ii = indexOf.call(this._shortMonthsParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._longMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._longMonthsParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._shortMonthsParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      }
	    }

	    function localeMonthsParse(monthName, format, strict) {
	      var i, mom, regex;

	      if (this._monthsParseExact) {
	        return handleStrictParse.call(this, monthName, format, strict);
	      }

	      if (!this._monthsParse) {
	        this._monthsParse = [];
	        this._longMonthsParse = [];
	        this._shortMonthsParse = [];
	      } // TODO: add sorting
	      // Sorting makes sure if one month (or abbr) is a prefix of another
	      // see sorting in computeMonthsParse


	      for (i = 0; i < 12; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, i]);

	        if (strict && !this._longMonthsParse[i]) {
	          this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
	          this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
	        }

	        if (!strict && !this._monthsParse[i]) {
	          regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
	          this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
	        } // test the regex


	        if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
	          return i;
	        } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
	          return i;
	        } else if (!strict && this._monthsParse[i].test(monthName)) {
	          return i;
	        }
	      }
	    } // MOMENTS


	    function setMonth(mom, value) {
	      var dayOfMonth;

	      if (!mom.isValid()) {
	        // No op
	        return mom;
	      }

	      if (typeof value === 'string') {
	        if (/^\d+$/.test(value)) {
	          value = toInt(value);
	        } else {
	          value = mom.localeData().monthsParse(value); // TODO: Another silent failure?

	          if (!isNumber(value)) {
	            return mom;
	          }
	        }
	      }

	      dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));

	      mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);

	      return mom;
	    }

	    function getSetMonth(value) {
	      if (value != null) {
	        setMonth(this, value);
	        hooks.updateOffset(this, true);
	        return this;
	      } else {
	        return get(this, 'Month');
	      }
	    }

	    function getDaysInMonth() {
	      return daysInMonth(this.year(), this.month());
	    }

	    var defaultMonthsShortRegex = matchWord;

	    function monthsShortRegex(isStrict) {
	      if (this._monthsParseExact) {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	          computeMonthsParse.call(this);
	        }

	        if (isStrict) {
	          return this._monthsShortStrictRegex;
	        } else {
	          return this._monthsShortRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_monthsShortRegex')) {
	          this._monthsShortRegex = defaultMonthsShortRegex;
	        }

	        return this._monthsShortStrictRegex && isStrict ? this._monthsShortStrictRegex : this._monthsShortRegex;
	      }
	    }

	    var defaultMonthsRegex = matchWord;

	    function monthsRegex(isStrict) {
	      if (this._monthsParseExact) {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	          computeMonthsParse.call(this);
	        }

	        if (isStrict) {
	          return this._monthsStrictRegex;
	        } else {
	          return this._monthsRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	          this._monthsRegex = defaultMonthsRegex;
	        }

	        return this._monthsStrictRegex && isStrict ? this._monthsStrictRegex : this._monthsRegex;
	      }
	    }

	    function computeMonthsParse() {
	      function cmpLenRev(a, b) {
	        return b.length - a.length;
	      }

	      var shortPieces = [],
	          longPieces = [],
	          mixedPieces = [],
	          i,
	          mom;

	      for (i = 0; i < 12; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, i]);
	        shortPieces.push(this.monthsShort(mom, ''));
	        longPieces.push(this.months(mom, ''));
	        mixedPieces.push(this.months(mom, ''));
	        mixedPieces.push(this.monthsShort(mom, ''));
	      } // Sorting makes sure if one month (or abbr) is a prefix of another it
	      // will match the longer piece.


	      shortPieces.sort(cmpLenRev);
	      longPieces.sort(cmpLenRev);
	      mixedPieces.sort(cmpLenRev);

	      for (i = 0; i < 12; i++) {
	        shortPieces[i] = regexEscape(shortPieces[i]);
	        longPieces[i] = regexEscape(longPieces[i]);
	      }

	      for (i = 0; i < 24; i++) {
	        mixedPieces[i] = regexEscape(mixedPieces[i]);
	      }

	      this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	      this._monthsShortRegex = this._monthsRegex;
	      this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	      this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	    }

	    function createDate(y, m, d, h, M, s, ms) {
	      // can't just apply() to create a date:
	      // https://stackoverflow.com/q/181348
	      var date; // the date constructor remaps years 0-99 to 1900-1999

	      if (y < 100 && y >= 0) {
	        // preserve leap years using a full 400 year cycle, then reset
	        date = new Date(y + 400, m, d, h, M, s, ms);

	        if (isFinite(date.getFullYear())) {
	          date.setFullYear(y);
	        }
	      } else {
	        date = new Date(y, m, d, h, M, s, ms);
	      }

	      return date;
	    }

	    function createUTCDate(y) {
	      var date; // the Date.UTC function remaps years 0-99 to 1900-1999

	      if (y < 100 && y >= 0) {
	        var args = Array.prototype.slice.call(arguments); // preserve leap years using a full 400 year cycle, then reset

	        args[0] = y + 400;
	        date = new Date(Date.UTC.apply(null, args));

	        if (isFinite(date.getUTCFullYear())) {
	          date.setUTCFullYear(y);
	        }
	      } else {
	        date = new Date(Date.UTC.apply(null, arguments));
	      }

	      return date;
	    } // start-of-first-week - start-of-year


	    function firstWeekOffset(year, dow, doy) {
	      var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
	      fwd = 7 + dow - doy,
	          // first-week day local weekday -- which local weekday is fwd
	      fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;
	      return -fwdlw + fwd - 1;
	    } // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday


	    function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
	      var localWeekday = (7 + weekday - dow) % 7,
	          weekOffset = firstWeekOffset(year, dow, doy),
	          dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
	          resYear,
	          resDayOfYear;

	      if (dayOfYear <= 0) {
	        resYear = year - 1;
	        resDayOfYear = daysInYear(resYear) + dayOfYear;
	      } else if (dayOfYear > daysInYear(year)) {
	        resYear = year + 1;
	        resDayOfYear = dayOfYear - daysInYear(year);
	      } else {
	        resYear = year;
	        resDayOfYear = dayOfYear;
	      }

	      return {
	        year: resYear,
	        dayOfYear: resDayOfYear
	      };
	    }

	    function weekOfYear(mom, dow, doy) {
	      var weekOffset = firstWeekOffset(mom.year(), dow, doy),
	          week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
	          resWeek,
	          resYear;

	      if (week < 1) {
	        resYear = mom.year() - 1;
	        resWeek = week + weeksInYear(resYear, dow, doy);
	      } else if (week > weeksInYear(mom.year(), dow, doy)) {
	        resWeek = week - weeksInYear(mom.year(), dow, doy);
	        resYear = mom.year() + 1;
	      } else {
	        resYear = mom.year();
	        resWeek = week;
	      }

	      return {
	        week: resWeek,
	        year: resYear
	      };
	    }

	    function weeksInYear(year, dow, doy) {
	      var weekOffset = firstWeekOffset(year, dow, doy),
	          weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
	      return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
	    } // FORMATTING


	    addFormatToken('w', ['ww', 2], 'wo', 'week');
	    addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek'); // ALIASES

	    addUnitAlias('week', 'w');
	    addUnitAlias('isoWeek', 'W'); // PRIORITIES

	    addUnitPriority('week', 5);
	    addUnitPriority('isoWeek', 5); // PARSING

	    addRegexToken('w', match1to2);
	    addRegexToken('ww', match1to2, match2);
	    addRegexToken('W', match1to2);
	    addRegexToken('WW', match1to2, match2);
	    addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
	      week[token.substr(0, 1)] = toInt(input);
	    }); // HELPERS
	    // LOCALES

	    function localeWeek(mom) {
	      return weekOfYear(mom, this._week.dow, this._week.doy).week;
	    }

	    var defaultLocaleWeek = {
	      dow: 0,
	      // Sunday is the first day of the week.
	      doy: 6 // The week that contains Jan 6th is the first week of the year.

	    };

	    function localeFirstDayOfWeek() {
	      return this._week.dow;
	    }

	    function localeFirstDayOfYear() {
	      return this._week.doy;
	    } // MOMENTS


	    function getSetWeek(input) {
	      var week = this.localeData().week(this);
	      return input == null ? week : this.add((input - week) * 7, 'd');
	    }

	    function getSetISOWeek(input) {
	      var week = weekOfYear(this, 1, 4).week;
	      return input == null ? week : this.add((input - week) * 7, 'd');
	    } // FORMATTING


	    addFormatToken('d', 0, 'do', 'day');
	    addFormatToken('dd', 0, 0, function (format) {
	      return this.localeData().weekdaysMin(this, format);
	    });
	    addFormatToken('ddd', 0, 0, function (format) {
	      return this.localeData().weekdaysShort(this, format);
	    });
	    addFormatToken('dddd', 0, 0, function (format) {
	      return this.localeData().weekdays(this, format);
	    });
	    addFormatToken('e', 0, 0, 'weekday');
	    addFormatToken('E', 0, 0, 'isoWeekday'); // ALIASES

	    addUnitAlias('day', 'd');
	    addUnitAlias('weekday', 'e');
	    addUnitAlias('isoWeekday', 'E'); // PRIORITY

	    addUnitPriority('day', 11);
	    addUnitPriority('weekday', 11);
	    addUnitPriority('isoWeekday', 11); // PARSING

	    addRegexToken('d', match1to2);
	    addRegexToken('e', match1to2);
	    addRegexToken('E', match1to2);
	    addRegexToken('dd', function (isStrict, locale) {
	      return locale.weekdaysMinRegex(isStrict);
	    });
	    addRegexToken('ddd', function (isStrict, locale) {
	      return locale.weekdaysShortRegex(isStrict);
	    });
	    addRegexToken('dddd', function (isStrict, locale) {
	      return locale.weekdaysRegex(isStrict);
	    });
	    addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
	      var weekday = config._locale.weekdaysParse(input, token, config._strict); // if we didn't get a weekday name, mark the date as invalid


	      if (weekday != null) {
	        week.d = weekday;
	      } else {
	        getParsingFlags(config).invalidWeekday = input;
	      }
	    });
	    addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
	      week[token] = toInt(input);
	    }); // HELPERS

	    function parseWeekday(input, locale) {
	      if (typeof input !== 'string') {
	        return input;
	      }

	      if (!isNaN(input)) {
	        return parseInt(input, 10);
	      }

	      input = locale.weekdaysParse(input);

	      if (typeof input === 'number') {
	        return input;
	      }

	      return null;
	    }

	    function parseIsoWeekday(input, locale) {
	      if (typeof input === 'string') {
	        return locale.weekdaysParse(input) % 7 || 7;
	      }

	      return isNaN(input) ? null : input;
	    } // LOCALES


	    function shiftWeekdays(ws, n) {
	      return ws.slice(n, 7).concat(ws.slice(0, n));
	    }

	    var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');

	    function localeWeekdays(m, format) {
	      var weekdays = isArray(this._weekdays) ? this._weekdays : this._weekdays[m && m !== true && this._weekdays.isFormat.test(format) ? 'format' : 'standalone'];
	      return m === true ? shiftWeekdays(weekdays, this._week.dow) : m ? weekdays[m.day()] : weekdays;
	    }

	    var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');

	    function localeWeekdaysShort(m) {
	      return m === true ? shiftWeekdays(this._weekdaysShort, this._week.dow) : m ? this._weekdaysShort[m.day()] : this._weekdaysShort;
	    }

	    var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');

	    function localeWeekdaysMin(m) {
	      return m === true ? shiftWeekdays(this._weekdaysMin, this._week.dow) : m ? this._weekdaysMin[m.day()] : this._weekdaysMin;
	    }

	    function handleStrictParse$1(weekdayName, format, strict) {
	      var i,
	          ii,
	          mom,
	          llc = weekdayName.toLocaleLowerCase();

	      if (!this._weekdaysParse) {
	        this._weekdaysParse = [];
	        this._shortWeekdaysParse = [];
	        this._minWeekdaysParse = [];

	        for (i = 0; i < 7; ++i) {
	          mom = createUTC([2000, 1]).day(i);
	          this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
	          this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
	          this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
	        }
	      }

	      if (strict) {
	        if (format === 'dddd') {
	          ii = indexOf.call(this._weekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else if (format === 'ddd') {
	          ii = indexOf.call(this._shortWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      } else {
	        if (format === 'dddd') {
	          ii = indexOf.call(this._weekdaysParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._shortWeekdaysParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else if (format === 'ddd') {
	          ii = indexOf.call(this._shortWeekdaysParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._weekdaysParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._minWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        } else {
	          ii = indexOf.call(this._minWeekdaysParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._weekdaysParse, llc);

	          if (ii !== -1) {
	            return ii;
	          }

	          ii = indexOf.call(this._shortWeekdaysParse, llc);
	          return ii !== -1 ? ii : null;
	        }
	      }
	    }

	    function localeWeekdaysParse(weekdayName, format, strict) {
	      var i, mom, regex;

	      if (this._weekdaysParseExact) {
	        return handleStrictParse$1.call(this, weekdayName, format, strict);
	      }

	      if (!this._weekdaysParse) {
	        this._weekdaysParse = [];
	        this._minWeekdaysParse = [];
	        this._shortWeekdaysParse = [];
	        this._fullWeekdaysParse = [];
	      }

	      for (i = 0; i < 7; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, 1]).day(i);

	        if (strict && !this._fullWeekdaysParse[i]) {
	          this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');
	          this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');
	          this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');
	        }

	        if (!this._weekdaysParse[i]) {
	          regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
	          this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
	        } // test the regex


	        if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
	          return i;
	        } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
	          return i;
	        } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
	          return i;
	        } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
	          return i;
	        }
	      }
	    } // MOMENTS


	    function getSetDayOfWeek(input) {
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }

	      var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();

	      if (input != null) {
	        input = parseWeekday(input, this.localeData());
	        return this.add(input - day, 'd');
	      } else {
	        return day;
	      }
	    }

	    function getSetLocaleDayOfWeek(input) {
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }

	      var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
	      return input == null ? weekday : this.add(input - weekday, 'd');
	    }

	    function getSetISODayOfWeek(input) {
	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      } // behaves the same as moment#day except
	      // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
	      // as a setter, sunday should belong to the previous week.


	      if (input != null) {
	        var weekday = parseIsoWeekday(input, this.localeData());
	        return this.day(this.day() % 7 ? weekday : weekday - 7);
	      } else {
	        return this.day() || 7;
	      }
	    }

	    var defaultWeekdaysRegex = matchWord;

	    function weekdaysRegex(isStrict) {
	      if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          computeWeekdaysParse.call(this);
	        }

	        if (isStrict) {
	          return this._weekdaysStrictRegex;
	        } else {
	          return this._weekdaysRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          this._weekdaysRegex = defaultWeekdaysRegex;
	        }

	        return this._weekdaysStrictRegex && isStrict ? this._weekdaysStrictRegex : this._weekdaysRegex;
	      }
	    }

	    var defaultWeekdaysShortRegex = matchWord;

	    function weekdaysShortRegex(isStrict) {
	      if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          computeWeekdaysParse.call(this);
	        }

	        if (isStrict) {
	          return this._weekdaysShortStrictRegex;
	        } else {
	          return this._weekdaysShortRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_weekdaysShortRegex')) {
	          this._weekdaysShortRegex = defaultWeekdaysShortRegex;
	        }

	        return this._weekdaysShortStrictRegex && isStrict ? this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
	      }
	    }

	    var defaultWeekdaysMinRegex = matchWord;

	    function weekdaysMinRegex(isStrict) {
	      if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	          computeWeekdaysParse.call(this);
	        }

	        if (isStrict) {
	          return this._weekdaysMinStrictRegex;
	        } else {
	          return this._weekdaysMinRegex;
	        }
	      } else {
	        if (!hasOwnProp(this, '_weekdaysMinRegex')) {
	          this._weekdaysMinRegex = defaultWeekdaysMinRegex;
	        }

	        return this._weekdaysMinStrictRegex && isStrict ? this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
	      }
	    }

	    function computeWeekdaysParse() {
	      function cmpLenRev(a, b) {
	        return b.length - a.length;
	      }

	      var minPieces = [],
	          shortPieces = [],
	          longPieces = [],
	          mixedPieces = [],
	          i,
	          mom,
	          minp,
	          shortp,
	          longp;

	      for (i = 0; i < 7; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, 1]).day(i);
	        minp = this.weekdaysMin(mom, '');
	        shortp = this.weekdaysShort(mom, '');
	        longp = this.weekdays(mom, '');
	        minPieces.push(minp);
	        shortPieces.push(shortp);
	        longPieces.push(longp);
	        mixedPieces.push(minp);
	        mixedPieces.push(shortp);
	        mixedPieces.push(longp);
	      } // Sorting makes sure if one weekday (or abbr) is a prefix of another it
	      // will match the longer piece.


	      minPieces.sort(cmpLenRev);
	      shortPieces.sort(cmpLenRev);
	      longPieces.sort(cmpLenRev);
	      mixedPieces.sort(cmpLenRev);

	      for (i = 0; i < 7; i++) {
	        shortPieces[i] = regexEscape(shortPieces[i]);
	        longPieces[i] = regexEscape(longPieces[i]);
	        mixedPieces[i] = regexEscape(mixedPieces[i]);
	      }

	      this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	      this._weekdaysShortRegex = this._weekdaysRegex;
	      this._weekdaysMinRegex = this._weekdaysRegex;
	      this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	      this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	      this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
	    } // FORMATTING


	    function hFormat() {
	      return this.hours() % 12 || 12;
	    }

	    function kFormat() {
	      return this.hours() || 24;
	    }

	    addFormatToken('H', ['HH', 2], 0, 'hour');
	    addFormatToken('h', ['hh', 2], 0, hFormat);
	    addFormatToken('k', ['kk', 2], 0, kFormat);
	    addFormatToken('hmm', 0, 0, function () {
	      return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
	    });
	    addFormatToken('hmmss', 0, 0, function () {
	      return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
	    });
	    addFormatToken('Hmm', 0, 0, function () {
	      return '' + this.hours() + zeroFill(this.minutes(), 2);
	    });
	    addFormatToken('Hmmss', 0, 0, function () {
	      return '' + this.hours() + zeroFill(this.minutes(), 2) + zeroFill(this.seconds(), 2);
	    });

	    function meridiem(token, lowercase) {
	      addFormatToken(token, 0, 0, function () {
	        return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
	      });
	    }

	    meridiem('a', true);
	    meridiem('A', false); // ALIASES

	    addUnitAlias('hour', 'h'); // PRIORITY

	    addUnitPriority('hour', 13); // PARSING

	    function matchMeridiem(isStrict, locale) {
	      return locale._meridiemParse;
	    }

	    addRegexToken('a', matchMeridiem);
	    addRegexToken('A', matchMeridiem);
	    addRegexToken('H', match1to2);
	    addRegexToken('h', match1to2);
	    addRegexToken('k', match1to2);
	    addRegexToken('HH', match1to2, match2);
	    addRegexToken('hh', match1to2, match2);
	    addRegexToken('kk', match1to2, match2);
	    addRegexToken('hmm', match3to4);
	    addRegexToken('hmmss', match5to6);
	    addRegexToken('Hmm', match3to4);
	    addRegexToken('Hmmss', match5to6);
	    addParseToken(['H', 'HH'], HOUR);
	    addParseToken(['k', 'kk'], function (input, array, config) {
	      var kInput = toInt(input);
	      array[HOUR] = kInput === 24 ? 0 : kInput;
	    });
	    addParseToken(['a', 'A'], function (input, array, config) {
	      config._isPm = config._locale.isPM(input);
	      config._meridiem = input;
	    });
	    addParseToken(['h', 'hh'], function (input, array, config) {
	      array[HOUR] = toInt(input);
	      getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('hmm', function (input, array, config) {
	      var pos = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos));
	      array[MINUTE] = toInt(input.substr(pos));
	      getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('hmmss', function (input, array, config) {
	      var pos1 = input.length - 4;
	      var pos2 = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos1));
	      array[MINUTE] = toInt(input.substr(pos1, 2));
	      array[SECOND] = toInt(input.substr(pos2));
	      getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('Hmm', function (input, array, config) {
	      var pos = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos));
	      array[MINUTE] = toInt(input.substr(pos));
	    });
	    addParseToken('Hmmss', function (input, array, config) {
	      var pos1 = input.length - 4;
	      var pos2 = input.length - 2;
	      array[HOUR] = toInt(input.substr(0, pos1));
	      array[MINUTE] = toInt(input.substr(pos1, 2));
	      array[SECOND] = toInt(input.substr(pos2));
	    }); // LOCALES

	    function localeIsPM(input) {
	      // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
	      // Using charAt should be more compatible.
	      return (input + '').toLowerCase().charAt(0) === 'p';
	    }

	    var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;

	    function localeMeridiem(hours, minutes, isLower) {
	      if (hours > 11) {
	        return isLower ? 'pm' : 'PM';
	      } else {
	        return isLower ? 'am' : 'AM';
	      }
	    } // MOMENTS
	    // Setting the hour should keep the time, because the user explicitly
	    // specified which hour they want. So trying to maintain the same hour (in
	    // a new timezone) makes sense. Adding/subtracting hours does not follow
	    // this rule.


	    var getSetHour = makeGetSet('Hours', true);
	    var baseConfig = {
	      calendar: defaultCalendar,
	      longDateFormat: defaultLongDateFormat,
	      invalidDate: defaultInvalidDate,
	      ordinal: defaultOrdinal,
	      dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
	      relativeTime: defaultRelativeTime,
	      months: defaultLocaleMonths,
	      monthsShort: defaultLocaleMonthsShort,
	      week: defaultLocaleWeek,
	      weekdays: defaultLocaleWeekdays,
	      weekdaysMin: defaultLocaleWeekdaysMin,
	      weekdaysShort: defaultLocaleWeekdaysShort,
	      meridiemParse: defaultLocaleMeridiemParse
	    }; // internal storage for locale config files

	    var locales = {};
	    var localeFamilies = {};
	    var globalLocale;

	    function normalizeLocale(key) {
	      return key ? key.toLowerCase().replace('_', '-') : key;
	    } // pick the locale from the array
	    // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
	    // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root


	    function chooseLocale(names) {
	      var i = 0,
	          j,
	          next,
	          locale,
	          split;

	      while (i < names.length) {
	        split = normalizeLocale(names[i]).split('-');
	        j = split.length;
	        next = normalizeLocale(names[i + 1]);
	        next = next ? next.split('-') : null;

	        while (j > 0) {
	          locale = loadLocale(split.slice(0, j).join('-'));

	          if (locale) {
	            return locale;
	          }

	          if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
	            //the next array item is better than a shallower substring of this one
	            break;
	          }

	          j--;
	        }

	        i++;
	      }

	      return globalLocale;
	    }

	    function loadLocale(name) {
	      var oldLocale = null; // TODO: Find a better way to register and load all the locales in Node

	      if (!locales[name] && 'object' !== 'undefined' && module && module.exports) {
	        try {
	          oldLocale = globalLocale._abbr;
	          var aliasedRequire = commonjsRequire;
	          aliasedRequire('./locale/' + name);
	          getSetGlobalLocale(oldLocale);
	        } catch (e) {}
	      }

	      return locales[name];
	    } // This function will load locale and then set the global locale.  If
	    // no arguments are passed in, it will simply return the current global
	    // locale key.


	    function getSetGlobalLocale(key, values) {
	      var data;

	      if (key) {
	        if (isUndefined(values)) {
	          data = getLocale(key);
	        } else {
	          data = defineLocale(key, values);
	        }

	        if (data) {
	          // moment.duration._locale = moment._locale = data;
	          globalLocale = data;
	        } else {
	          if (typeof console !== 'undefined' && console.warn) {
	            //warn user if arguments are passed but the locale could not be set
	            console.warn('Locale ' + key + ' not found. Did you forget to load it?');
	          }
	        }
	      }

	      return globalLocale._abbr;
	    }

	    function defineLocale(name, config) {
	      if (config !== null) {
	        var locale,
	            parentConfig = baseConfig;
	        config.abbr = name;

	        if (locales[name] != null) {
	          deprecateSimple('defineLocaleOverride', 'use moment.updateLocale(localeName, config) to change ' + 'an existing locale. moment.defineLocale(localeName, ' + 'config) should only be used for creating a new locale ' + 'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
	          parentConfig = locales[name]._config;
	        } else if (config.parentLocale != null) {
	          if (locales[config.parentLocale] != null) {
	            parentConfig = locales[config.parentLocale]._config;
	          } else {
	            locale = loadLocale(config.parentLocale);

	            if (locale != null) {
	              parentConfig = locale._config;
	            } else {
	              if (!localeFamilies[config.parentLocale]) {
	                localeFamilies[config.parentLocale] = [];
	              }

	              localeFamilies[config.parentLocale].push({
	                name: name,
	                config: config
	              });
	              return null;
	            }
	          }
	        }

	        locales[name] = new Locale(mergeConfigs(parentConfig, config));

	        if (localeFamilies[name]) {
	          localeFamilies[name].forEach(function (x) {
	            defineLocale(x.name, x.config);
	          });
	        } // backwards compat for now: also set the locale
	        // make sure we set the locale AFTER all child locales have been
	        // created, so we won't end up with the child locale set.


	        getSetGlobalLocale(name);
	        return locales[name];
	      } else {
	        // useful for testing
	        delete locales[name];
	        return null;
	      }
	    }

	    function updateLocale(name, config) {
	      if (config != null) {
	        var locale,
	            tmpLocale,
	            parentConfig = baseConfig; // MERGE

	        tmpLocale = loadLocale(name);

	        if (tmpLocale != null) {
	          parentConfig = tmpLocale._config;
	        }

	        config = mergeConfigs(parentConfig, config);
	        locale = new Locale(config);
	        locale.parentLocale = locales[name];
	        locales[name] = locale; // backwards compat for now: also set the locale

	        getSetGlobalLocale(name);
	      } else {
	        // pass null for config to unupdate, useful for tests
	        if (locales[name] != null) {
	          if (locales[name].parentLocale != null) {
	            locales[name] = locales[name].parentLocale;
	          } else if (locales[name] != null) {
	            delete locales[name];
	          }
	        }
	      }

	      return locales[name];
	    } // returns locale data


	    function getLocale(key) {
	      var locale;

	      if (key && key._locale && key._locale._abbr) {
	        key = key._locale._abbr;
	      }

	      if (!key) {
	        return globalLocale;
	      }

	      if (!isArray(key)) {
	        //short-circuit everything else
	        locale = loadLocale(key);

	        if (locale) {
	          return locale;
	        }

	        key = [key];
	      }

	      return chooseLocale(key);
	    }

	    function listLocales() {
	      return keys(locales);
	    }

	    function checkOverflow(m) {
	      var overflow;
	      var a = m._a;

	      if (a && getParsingFlags(m).overflow === -2) {
	        overflow = a[MONTH] < 0 || a[MONTH] > 11 ? MONTH : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH]) ? DATE : a[HOUR] < 0 || a[HOUR] > 24 || a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0) ? HOUR : a[MINUTE] < 0 || a[MINUTE] > 59 ? MINUTE : a[SECOND] < 0 || a[SECOND] > 59 ? SECOND : a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND : -1;

	        if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
	          overflow = DATE;
	        }

	        if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
	          overflow = WEEK;
	        }

	        if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
	          overflow = WEEKDAY;
	        }

	        getParsingFlags(m).overflow = overflow;
	      }

	      return m;
	    } // Pick the first defined of two or three arguments.


	    function defaults(a, b, c) {
	      if (a != null) {
	        return a;
	      }

	      if (b != null) {
	        return b;
	      }

	      return c;
	    }

	    function currentDateArray(config) {
	      // hooks is actually the exported moment object
	      var nowValue = new Date(hooks.now());

	      if (config._useUTC) {
	        return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
	      }

	      return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
	    } // convert an array to a date.
	    // the array should mirror the parameters below
	    // note: all values past the year are optional and will default to the lowest possible value.
	    // [year, month, day , hour, minute, second, millisecond]


	    function configFromArray(config) {
	      var i,
	          date,
	          input = [],
	          currentDate,
	          expectedWeekday,
	          yearToUse;

	      if (config._d) {
	        return;
	      }

	      currentDate = currentDateArray(config); //compute day of the year from weeks and weekdays

	      if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
	        dayOfYearFromWeekInfo(config);
	      } //if the day of the year is set, figure out what it is


	      if (config._dayOfYear != null) {
	        yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

	        if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
	          getParsingFlags(config)._overflowDayOfYear = true;
	        }

	        date = createUTCDate(yearToUse, 0, config._dayOfYear);
	        config._a[MONTH] = date.getUTCMonth();
	        config._a[DATE] = date.getUTCDate();
	      } // Default to current date.
	      // * if no year, month, day of month are given, default to today
	      // * if day of month is given, default month and year
	      // * if month is given, default only year
	      // * if year is given, don't default anything


	      for (i = 0; i < 3 && config._a[i] == null; ++i) {
	        config._a[i] = input[i] = currentDate[i];
	      } // Zero out whatever was not defaulted, including time


	      for (; i < 7; i++) {
	        config._a[i] = input[i] = config._a[i] == null ? i === 2 ? 1 : 0 : config._a[i];
	      } // Check for 24:00:00.000


	      if (config._a[HOUR] === 24 && config._a[MINUTE] === 0 && config._a[SECOND] === 0 && config._a[MILLISECOND] === 0) {
	        config._nextDay = true;
	        config._a[HOUR] = 0;
	      }

	      config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
	      expectedWeekday = config._useUTC ? config._d.getUTCDay() : config._d.getDay(); // Apply timezone offset from input. The actual utcOffset can be changed
	      // with parseZone.

	      if (config._tzm != null) {
	        config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
	      }

	      if (config._nextDay) {
	        config._a[HOUR] = 24;
	      } // check for mismatching day of week


	      if (config._w && typeof config._w.d !== 'undefined' && config._w.d !== expectedWeekday) {
	        getParsingFlags(config).weekdayMismatch = true;
	      }
	    }

	    function dayOfYearFromWeekInfo(config) {
	      var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;
	      w = config._w;

	      if (w.GG != null || w.W != null || w.E != null) {
	        dow = 1;
	        doy = 4; // TODO: We need to take the current isoWeekYear, but that depends on
	        // how we interpret now (local, utc, fixed offset). So create
	        // a now version of current config (take local/utc/offset flags, and
	        // create now).

	        weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
	        week = defaults(w.W, 1);
	        weekday = defaults(w.E, 1);

	        if (weekday < 1 || weekday > 7) {
	          weekdayOverflow = true;
	        }
	      } else {
	        dow = config._locale._week.dow;
	        doy = config._locale._week.doy;
	        var curWeek = weekOfYear(createLocal(), dow, doy);
	        weekYear = defaults(w.gg, config._a[YEAR], curWeek.year); // Default to current week.

	        week = defaults(w.w, curWeek.week);

	        if (w.d != null) {
	          // weekday -- low day numbers are considered next week
	          weekday = w.d;

	          if (weekday < 0 || weekday > 6) {
	            weekdayOverflow = true;
	          }
	        } else if (w.e != null) {
	          // local weekday -- counting starts from beginning of week
	          weekday = w.e + dow;

	          if (w.e < 0 || w.e > 6) {
	            weekdayOverflow = true;
	          }
	        } else {
	          // default to beginning of week
	          weekday = dow;
	        }
	      }

	      if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
	        getParsingFlags(config)._overflowWeeks = true;
	      } else if (weekdayOverflow != null) {
	        getParsingFlags(config)._overflowWeekday = true;
	      } else {
	        temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
	        config._a[YEAR] = temp.year;
	        config._dayOfYear = temp.dayOfYear;
	      }
	    } // iso 8601 regex
	    // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)


	    var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
	    var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
	    var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;
	    var isoDates = [['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/], ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/], ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/], ['GGGG-[W]WW', /\d{4}-W\d\d/, false], ['YYYY-DDD', /\d{4}-\d{3}/], ['YYYY-MM', /\d{4}-\d\d/, false], ['YYYYYYMMDD', /[+-]\d{10}/], ['YYYYMMDD', /\d{8}/], // YYYYMM is NOT allowed by the standard
	    ['GGGG[W]WWE', /\d{4}W\d{3}/], ['GGGG[W]WW', /\d{4}W\d{2}/, false], ['YYYYDDD', /\d{7}/]]; // iso time formats and regexes

	    var isoTimes = [['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/], ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/], ['HH:mm:ss', /\d\d:\d\d:\d\d/], ['HH:mm', /\d\d:\d\d/], ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/], ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/], ['HHmmss', /\d\d\d\d\d\d/], ['HHmm', /\d\d\d\d/], ['HH', /\d\d/]];
	    var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i; // date from iso format

	    function configFromISO(config) {
	      var i,
	          l,
	          string = config._i,
	          match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
	          allowTime,
	          dateFormat,
	          timeFormat,
	          tzFormat;

	      if (match) {
	        getParsingFlags(config).iso = true;

	        for (i = 0, l = isoDates.length; i < l; i++) {
	          if (isoDates[i][1].exec(match[1])) {
	            dateFormat = isoDates[i][0];
	            allowTime = isoDates[i][2] !== false;
	            break;
	          }
	        }

	        if (dateFormat == null) {
	          config._isValid = false;
	          return;
	        }

	        if (match[3]) {
	          for (i = 0, l = isoTimes.length; i < l; i++) {
	            if (isoTimes[i][1].exec(match[3])) {
	              // match[2] should be 'T' or space
	              timeFormat = (match[2] || ' ') + isoTimes[i][0];
	              break;
	            }
	          }

	          if (timeFormat == null) {
	            config._isValid = false;
	            return;
	          }
	        }

	        if (!allowTime && timeFormat != null) {
	          config._isValid = false;
	          return;
	        }

	        if (match[4]) {
	          if (tzRegex.exec(match[4])) {
	            tzFormat = 'Z';
	          } else {
	            config._isValid = false;
	            return;
	          }
	        }

	        config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
	        configFromStringAndFormat(config);
	      } else {
	        config._isValid = false;
	      }
	    } // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3


	    var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;

	    function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
	      var result = [untruncateYear(yearStr), defaultLocaleMonthsShort.indexOf(monthStr), parseInt(dayStr, 10), parseInt(hourStr, 10), parseInt(minuteStr, 10)];

	      if (secondStr) {
	        result.push(parseInt(secondStr, 10));
	      }

	      return result;
	    }

	    function untruncateYear(yearStr) {
	      var year = parseInt(yearStr, 10);

	      if (year <= 49) {
	        return 2000 + year;
	      } else if (year <= 999) {
	        return 1900 + year;
	      }

	      return year;
	    }

	    function preprocessRFC2822(s) {
	      // Remove comments and folding whitespace and replace multiple-spaces with a single space
	      return s.replace(/\([^)]*\)|[\n\t]/g, ' ').replace(/(\s\s+)/g, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	    }

	    function checkWeekday(weekdayStr, parsedInput, config) {
	      if (weekdayStr) {
	        // TODO: Replace the vanilla JS Date object with an indepentent day-of-week check.
	        var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
	            weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();

	        if (weekdayProvided !== weekdayActual) {
	          getParsingFlags(config).weekdayMismatch = true;
	          config._isValid = false;
	          return false;
	        }
	      }

	      return true;
	    }

	    var obsOffsets = {
	      UT: 0,
	      GMT: 0,
	      EDT: -4 * 60,
	      EST: -5 * 60,
	      CDT: -5 * 60,
	      CST: -6 * 60,
	      MDT: -6 * 60,
	      MST: -7 * 60,
	      PDT: -7 * 60,
	      PST: -8 * 60
	    };

	    function calculateOffset(obsOffset, militaryOffset, numOffset) {
	      if (obsOffset) {
	        return obsOffsets[obsOffset];
	      } else if (militaryOffset) {
	        // the only allowed military tz is Z
	        return 0;
	      } else {
	        var hm = parseInt(numOffset, 10);
	        var m = hm % 100,
	            h = (hm - m) / 100;
	        return h * 60 + m;
	      }
	    } // date and time from ref 2822 format


	    function configFromRFC2822(config) {
	      var match = rfc2822.exec(preprocessRFC2822(config._i));

	      if (match) {
	        var parsedArray = extractFromRFC2822Strings(match[4], match[3], match[2], match[5], match[6], match[7]);

	        if (!checkWeekday(match[1], parsedArray, config)) {
	          return;
	        }

	        config._a = parsedArray;
	        config._tzm = calculateOffset(match[8], match[9], match[10]);
	        config._d = createUTCDate.apply(null, config._a);

	        config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

	        getParsingFlags(config).rfc2822 = true;
	      } else {
	        config._isValid = false;
	      }
	    } // date from iso format or fallback


	    function configFromString(config) {
	      var matched = aspNetJsonRegex.exec(config._i);

	      if (matched !== null) {
	        config._d = new Date(+matched[1]);
	        return;
	      }

	      configFromISO(config);

	      if (config._isValid === false) {
	        delete config._isValid;
	      } else {
	        return;
	      }

	      configFromRFC2822(config);

	      if (config._isValid === false) {
	        delete config._isValid;
	      } else {
	        return;
	      } // Final attempt, use Input Fallback


	      hooks.createFromInputFallback(config);
	    }

	    hooks.createFromInputFallback = deprecate('value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' + 'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' + 'discouraged and will be removed in an upcoming major release. Please refer to ' + 'http://momentjs.com/guides/#/warnings/js-date/ for more info.', function (config) {
	      config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
	    }); // constant that refers to the ISO standard

	    hooks.ISO_8601 = function () {}; // constant that refers to the RFC 2822 form


	    hooks.RFC_2822 = function () {}; // date from string and format string


	    function configFromStringAndFormat(config) {
	      // TODO: Move this to another part of the creation flow to prevent circular deps
	      if (config._f === hooks.ISO_8601) {
	        configFromISO(config);
	        return;
	      }

	      if (config._f === hooks.RFC_2822) {
	        configFromRFC2822(config);
	        return;
	      }

	      config._a = [];
	      getParsingFlags(config).empty = true; // This array is used to make a Date, either with `new Date` or `Date.UTC`

	      var string = '' + config._i,
	          i,
	          parsedInput,
	          tokens,
	          token,
	          skipped,
	          stringLength = string.length,
	          totalParsedInputLength = 0;
	      tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];

	      for (i = 0; i < tokens.length; i++) {
	        token = tokens[i];
	        parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0]; // console.log('token', token, 'parsedInput', parsedInput,
	        //         'regex', getParseRegexForToken(token, config));

	        if (parsedInput) {
	          skipped = string.substr(0, string.indexOf(parsedInput));

	          if (skipped.length > 0) {
	            getParsingFlags(config).unusedInput.push(skipped);
	          }

	          string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
	          totalParsedInputLength += parsedInput.length;
	        } // don't parse if it's not a known token


	        if (formatTokenFunctions[token]) {
	          if (parsedInput) {
	            getParsingFlags(config).empty = false;
	          } else {
	            getParsingFlags(config).unusedTokens.push(token);
	          }

	          addTimeToArrayFromToken(token, parsedInput, config);
	        } else if (config._strict && !parsedInput) {
	          getParsingFlags(config).unusedTokens.push(token);
	        }
	      } // add remaining unparsed input length to the string


	      getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;

	      if (string.length > 0) {
	        getParsingFlags(config).unusedInput.push(string);
	      } // clear _12h flag if hour is <= 12


	      if (config._a[HOUR] <= 12 && getParsingFlags(config).bigHour === true && config._a[HOUR] > 0) {
	        getParsingFlags(config).bigHour = undefined;
	      }

	      getParsingFlags(config).parsedDateParts = config._a.slice(0);
	      getParsingFlags(config).meridiem = config._meridiem; // handle meridiem

	      config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);
	      configFromArray(config);
	      checkOverflow(config);
	    }

	    function meridiemFixWrap(locale, hour, meridiem) {
	      var isPm;

	      if (meridiem == null) {
	        // nothing to do
	        return hour;
	      }

	      if (locale.meridiemHour != null) {
	        return locale.meridiemHour(hour, meridiem);
	      } else if (locale.isPM != null) {
	        // Fallback
	        isPm = locale.isPM(meridiem);

	        if (isPm && hour < 12) {
	          hour += 12;
	        }

	        if (!isPm && hour === 12) {
	          hour = 0;
	        }

	        return hour;
	      } else {
	        // this is not supposed to happen
	        return hour;
	      }
	    } // date from string and array of format strings


	    function configFromStringAndArray(config) {
	      var tempConfig, bestMoment, scoreToBeat, i, currentScore;

	      if (config._f.length === 0) {
	        getParsingFlags(config).invalidFormat = true;
	        config._d = new Date(NaN);
	        return;
	      }

	      for (i = 0; i < config._f.length; i++) {
	        currentScore = 0;
	        tempConfig = copyConfig({}, config);

	        if (config._useUTC != null) {
	          tempConfig._useUTC = config._useUTC;
	        }

	        tempConfig._f = config._f[i];
	        configFromStringAndFormat(tempConfig);

	        if (!isValid(tempConfig)) {
	          continue;
	        } // if there is any input that was not parsed add a penalty for that format


	        currentScore += getParsingFlags(tempConfig).charsLeftOver; //or tokens

	        currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
	        getParsingFlags(tempConfig).score = currentScore;

	        if (scoreToBeat == null || currentScore < scoreToBeat) {
	          scoreToBeat = currentScore;
	          bestMoment = tempConfig;
	        }
	      }

	      extend(config, bestMoment || tempConfig);
	    }

	    function configFromObject(config) {
	      if (config._d) {
	        return;
	      }

	      var i = normalizeObjectUnits(config._i);
	      config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
	        return obj && parseInt(obj, 10);
	      });
	      configFromArray(config);
	    }

	    function createFromConfig(config) {
	      var res = new Moment(checkOverflow(prepareConfig(config)));

	      if (res._nextDay) {
	        // Adding is smart enough around DST
	        res.add(1, 'd');
	        res._nextDay = undefined;
	      }

	      return res;
	    }

	    function prepareConfig(config) {
	      var input = config._i,
	          format = config._f;
	      config._locale = config._locale || getLocale(config._l);

	      if (input === null || format === undefined && input === '') {
	        return createInvalid({
	          nullInput: true
	        });
	      }

	      if (typeof input === 'string') {
	        config._i = input = config._locale.preparse(input);
	      }

	      if (isMoment(input)) {
	        return new Moment(checkOverflow(input));
	      } else if (isDate(input)) {
	        config._d = input;
	      } else if (isArray(format)) {
	        configFromStringAndArray(config);
	      } else if (format) {
	        configFromStringAndFormat(config);
	      } else {
	        configFromInput(config);
	      }

	      if (!isValid(config)) {
	        config._d = null;
	      }

	      return config;
	    }

	    function configFromInput(config) {
	      var input = config._i;

	      if (isUndefined(input)) {
	        config._d = new Date(hooks.now());
	      } else if (isDate(input)) {
	        config._d = new Date(input.valueOf());
	      } else if (typeof input === 'string') {
	        configFromString(config);
	      } else if (isArray(input)) {
	        config._a = map(input.slice(0), function (obj) {
	          return parseInt(obj, 10);
	        });
	        configFromArray(config);
	      } else if (isObject(input)) {
	        configFromObject(config);
	      } else if (isNumber(input)) {
	        // from milliseconds
	        config._d = new Date(input);
	      } else {
	        hooks.createFromInputFallback(config);
	      }
	    }

	    function createLocalOrUTC(input, format, locale, strict, isUTC) {
	      var c = {};

	      if (locale === true || locale === false) {
	        strict = locale;
	        locale = undefined;
	      }

	      if (isObject(input) && isObjectEmpty(input) || isArray(input) && input.length === 0) {
	        input = undefined;
	      } // object construction must be done this way.
	      // https://github.com/moment/moment/issues/1423


	      c._isAMomentObject = true;
	      c._useUTC = c._isUTC = isUTC;
	      c._l = locale;
	      c._i = input;
	      c._f = format;
	      c._strict = strict;
	      return createFromConfig(c);
	    }

	    function createLocal(input, format, locale, strict) {
	      return createLocalOrUTC(input, format, locale, strict, false);
	    }

	    var prototypeMin = deprecate('moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/', function () {
	      var other = createLocal.apply(null, arguments);

	      if (this.isValid() && other.isValid()) {
	        return other < this ? this : other;
	      } else {
	        return createInvalid();
	      }
	    });
	    var prototypeMax = deprecate('moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/', function () {
	      var other = createLocal.apply(null, arguments);

	      if (this.isValid() && other.isValid()) {
	        return other > this ? this : other;
	      } else {
	        return createInvalid();
	      }
	    }); // Pick a moment m from moments so that m[fn](other) is true for all
	    // other. This relies on the function fn to be transitive.
	    //
	    // moments should either be an array of moment objects or an array, whose
	    // first element is an array of moment objects.

	    function pickBy(fn, moments) {
	      var res, i;

	      if (moments.length === 1 && isArray(moments[0])) {
	        moments = moments[0];
	      }

	      if (!moments.length) {
	        return createLocal();
	      }

	      res = moments[0];

	      for (i = 1; i < moments.length; ++i) {
	        if (!moments[i].isValid() || moments[i][fn](res)) {
	          res = moments[i];
	        }
	      }

	      return res;
	    } // TODO: Use [].sort instead?


	    function min() {
	      var args = [].slice.call(arguments, 0);
	      return pickBy('isBefore', args);
	    }

	    function max() {
	      var args = [].slice.call(arguments, 0);
	      return pickBy('isAfter', args);
	    }

	    var now = function () {
	      return Date.now ? Date.now() : +new Date();
	    };

	    var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];

	    function isDurationValid(m) {
	      for (var key in m) {
	        if (!(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
	          return false;
	        }
	      }

	      var unitHasDecimal = false;

	      for (var i = 0; i < ordering.length; ++i) {
	        if (m[ordering[i]]) {
	          if (unitHasDecimal) {
	            return false; // only allow non-integers for smallest unit
	          }

	          if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
	            unitHasDecimal = true;
	          }
	        }
	      }

	      return true;
	    }

	    function isValid$1() {
	      return this._isValid;
	    }

	    function createInvalid$1() {
	      return createDuration(NaN);
	    }

	    function Duration(duration) {
	      var normalizedInput = normalizeObjectUnits(duration),
	          years = normalizedInput.year || 0,
	          quarters = normalizedInput.quarter || 0,
	          months = normalizedInput.month || 0,
	          weeks = normalizedInput.week || normalizedInput.isoWeek || 0,
	          days = normalizedInput.day || 0,
	          hours = normalizedInput.hour || 0,
	          minutes = normalizedInput.minute || 0,
	          seconds = normalizedInput.second || 0,
	          milliseconds = normalizedInput.millisecond || 0;
	      this._isValid = isDurationValid(normalizedInput); // representation for dateAddRemove

	      this._milliseconds = +milliseconds + seconds * 1e3 + // 1000
	      minutes * 6e4 + // 1000 * 60
	      hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
	      // Because of dateAddRemove treats 24 hours as different from a
	      // day when working around DST, we need to store them separately

	      this._days = +days + weeks * 7; // It is impossible to translate months into days without knowing
	      // which months you are are talking about, so we have to store
	      // it separately.

	      this._months = +months + quarters * 3 + years * 12;
	      this._data = {};
	      this._locale = getLocale();

	      this._bubble();
	    }

	    function isDuration(obj) {
	      return obj instanceof Duration;
	    }

	    function absRound(number) {
	      if (number < 0) {
	        return Math.round(-1 * number) * -1;
	      } else {
	        return Math.round(number);
	      }
	    } // FORMATTING


	    function offset(token, separator) {
	      addFormatToken(token, 0, 0, function () {
	        var offset = this.utcOffset();
	        var sign = '+';

	        if (offset < 0) {
	          offset = -offset;
	          sign = '-';
	        }

	        return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~offset % 60, 2);
	      });
	    }

	    offset('Z', ':');
	    offset('ZZ', ''); // PARSING

	    addRegexToken('Z', matchShortOffset);
	    addRegexToken('ZZ', matchShortOffset);
	    addParseToken(['Z', 'ZZ'], function (input, array, config) {
	      config._useUTC = true;
	      config._tzm = offsetFromString(matchShortOffset, input);
	    }); // HELPERS
	    // timezone chunker
	    // '+10:00' > ['10',  '00']
	    // '-1530'  > ['-15', '30']

	    var chunkOffset = /([\+\-]|\d\d)/gi;

	    function offsetFromString(matcher, string) {
	      var matches = (string || '').match(matcher);

	      if (matches === null) {
	        return null;
	      }

	      var chunk = matches[matches.length - 1] || [];
	      var parts = (chunk + '').match(chunkOffset) || ['-', 0, 0];
	      var minutes = +(parts[1] * 60) + toInt(parts[2]);
	      return minutes === 0 ? 0 : parts[0] === '+' ? minutes : -minutes;
	    } // Return a moment from input, that is local/utc/zone equivalent to model.


	    function cloneWithOffset(input, model) {
	      var res, diff;

	      if (model._isUTC) {
	        res = model.clone();
	        diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf(); // Use low-level api, because this fn is low-level api.

	        res._d.setTime(res._d.valueOf() + diff);

	        hooks.updateOffset(res, false);
	        return res;
	      } else {
	        return createLocal(input).local();
	      }
	    }

	    function getDateOffset(m) {
	      // On Firefox.24 Date#getTimezoneOffset returns a floating point.
	      // https://github.com/moment/moment/pull/1871
	      return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
	    } // HOOKS
	    // This function will be called whenever a moment is mutated.
	    // It is intended to keep the offset in sync with the timezone.


	    hooks.updateOffset = function () {}; // MOMENTS
	    // keepLocalTime = true means only change the timezone, without
	    // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
	    // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
	    // +0200, so we adjust the time as needed, to be valid.
	    //
	    // Keeping the time actually adds/subtracts (one hour)
	    // from the actual represented time. That is why we call updateOffset
	    // a second time. In case it wants us to change the offset again
	    // _changeInProgress == true case, then we have to adjust, because
	    // there is no such time in the given timezone.


	    function getSetOffset(input, keepLocalTime, keepMinutes) {
	      var offset = this._offset || 0,
	          localAdjust;

	      if (!this.isValid()) {
	        return input != null ? this : NaN;
	      }

	      if (input != null) {
	        if (typeof input === 'string') {
	          input = offsetFromString(matchShortOffset, input);

	          if (input === null) {
	            return this;
	          }
	        } else if (Math.abs(input) < 16 && !keepMinutes) {
	          input = input * 60;
	        }

	        if (!this._isUTC && keepLocalTime) {
	          localAdjust = getDateOffset(this);
	        }

	        this._offset = input;
	        this._isUTC = true;

	        if (localAdjust != null) {
	          this.add(localAdjust, 'm');
	        }

	        if (offset !== input) {
	          if (!keepLocalTime || this._changeInProgress) {
	            addSubtract(this, createDuration(input - offset, 'm'), 1, false);
	          } else if (!this._changeInProgress) {
	            this._changeInProgress = true;
	            hooks.updateOffset(this, true);
	            this._changeInProgress = null;
	          }
	        }

	        return this;
	      } else {
	        return this._isUTC ? offset : getDateOffset(this);
	      }
	    }

	    function getSetZone(input, keepLocalTime) {
	      if (input != null) {
	        if (typeof input !== 'string') {
	          input = -input;
	        }

	        this.utcOffset(input, keepLocalTime);
	        return this;
	      } else {
	        return -this.utcOffset();
	      }
	    }

	    function setOffsetToUTC(keepLocalTime) {
	      return this.utcOffset(0, keepLocalTime);
	    }

	    function setOffsetToLocal(keepLocalTime) {
	      if (this._isUTC) {
	        this.utcOffset(0, keepLocalTime);
	        this._isUTC = false;

	        if (keepLocalTime) {
	          this.subtract(getDateOffset(this), 'm');
	        }
	      }

	      return this;
	    }

	    function setOffsetToParsedOffset() {
	      if (this._tzm != null) {
	        this.utcOffset(this._tzm, false, true);
	      } else if (typeof this._i === 'string') {
	        var tZone = offsetFromString(matchOffset, this._i);

	        if (tZone != null) {
	          this.utcOffset(tZone);
	        } else {
	          this.utcOffset(0, true);
	        }
	      }

	      return this;
	    }

	    function hasAlignedHourOffset(input) {
	      if (!this.isValid()) {
	        return false;
	      }

	      input = input ? createLocal(input).utcOffset() : 0;
	      return (this.utcOffset() - input) % 60 === 0;
	    }

	    function isDaylightSavingTime() {
	      return this.utcOffset() > this.clone().month(0).utcOffset() || this.utcOffset() > this.clone().month(5).utcOffset();
	    }

	    function isDaylightSavingTimeShifted() {
	      if (!isUndefined(this._isDSTShifted)) {
	        return this._isDSTShifted;
	      }

	      var c = {};
	      copyConfig(c, this);
	      c = prepareConfig(c);

	      if (c._a) {
	        var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
	        this._isDSTShifted = this.isValid() && compareArrays(c._a, other.toArray()) > 0;
	      } else {
	        this._isDSTShifted = false;
	      }

	      return this._isDSTShifted;
	    }

	    function isLocal() {
	      return this.isValid() ? !this._isUTC : false;
	    }

	    function isUtcOffset() {
	      return this.isValid() ? this._isUTC : false;
	    }

	    function isUtc() {
	      return this.isValid() ? this._isUTC && this._offset === 0 : false;
	    } // ASP.NET json date format regex


	    var aspNetRegex = /^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/; // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
	    // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
	    // and further modified to allow for strings containing both week and day

	    var isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

	    function createDuration(input, key) {
	      var duration = input,
	          // matching against regexp is expensive, do it on demand
	      match = null,
	          sign,
	          ret,
	          diffRes;

	      if (isDuration(input)) {
	        duration = {
	          ms: input._milliseconds,
	          d: input._days,
	          M: input._months
	        };
	      } else if (isNumber(input)) {
	        duration = {};

	        if (key) {
	          duration[key] = input;
	        } else {
	          duration.milliseconds = input;
	        }
	      } else if (!!(match = aspNetRegex.exec(input))) {
	        sign = match[1] === '-' ? -1 : 1;
	        duration = {
	          y: 0,
	          d: toInt(match[DATE]) * sign,
	          h: toInt(match[HOUR]) * sign,
	          m: toInt(match[MINUTE]) * sign,
	          s: toInt(match[SECOND]) * sign,
	          ms: toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match

	        };
	      } else if (!!(match = isoRegex.exec(input))) {
	        sign = match[1] === '-' ? -1 : 1;
	        duration = {
	          y: parseIso(match[2], sign),
	          M: parseIso(match[3], sign),
	          w: parseIso(match[4], sign),
	          d: parseIso(match[5], sign),
	          h: parseIso(match[6], sign),
	          m: parseIso(match[7], sign),
	          s: parseIso(match[8], sign)
	        };
	      } else if (duration == null) {
	        // checks for null or undefined
	        duration = {};
	      } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
	        diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));
	        duration = {};
	        duration.ms = diffRes.milliseconds;
	        duration.M = diffRes.months;
	      }

	      ret = new Duration(duration);

	      if (isDuration(input) && hasOwnProp(input, '_locale')) {
	        ret._locale = input._locale;
	      }

	      return ret;
	    }

	    createDuration.fn = Duration.prototype;
	    createDuration.invalid = createInvalid$1;

	    function parseIso(inp, sign) {
	      // We'd normally use ~~inp for this, but unfortunately it also
	      // converts floats to ints.
	      // inp may be undefined, so careful calling replace on it.
	      var res = inp && parseFloat(inp.replace(',', '.')); // apply sign while we're at it

	      return (isNaN(res) ? 0 : res) * sign;
	    }

	    function positiveMomentsDifference(base, other) {
	      var res = {};
	      res.months = other.month() - base.month() + (other.year() - base.year()) * 12;

	      if (base.clone().add(res.months, 'M').isAfter(other)) {
	        --res.months;
	      }

	      res.milliseconds = +other - +base.clone().add(res.months, 'M');
	      return res;
	    }

	    function momentsDifference(base, other) {
	      var res;

	      if (!(base.isValid() && other.isValid())) {
	        return {
	          milliseconds: 0,
	          months: 0
	        };
	      }

	      other = cloneWithOffset(other, base);

	      if (base.isBefore(other)) {
	        res = positiveMomentsDifference(base, other);
	      } else {
	        res = positiveMomentsDifference(other, base);
	        res.milliseconds = -res.milliseconds;
	        res.months = -res.months;
	      }

	      return res;
	    } // TODO: remove 'name' arg after deprecation is removed


	    function createAdder(direction, name) {
	      return function (val, period) {
	        var dur, tmp; //invert the arguments, but complain about it

	        if (period !== null && !isNaN(+period)) {
	          deprecateSimple(name, 'moment().' + name + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' + 'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
	          tmp = val;
	          val = period;
	          period = tmp;
	        }

	        val = typeof val === 'string' ? +val : val;
	        dur = createDuration(val, period);
	        addSubtract(this, dur, direction);
	        return this;
	      };
	    }

	    function addSubtract(mom, duration, isAdding, updateOffset) {
	      var milliseconds = duration._milliseconds,
	          days = absRound(duration._days),
	          months = absRound(duration._months);

	      if (!mom.isValid()) {
	        // No op
	        return;
	      }

	      updateOffset = updateOffset == null ? true : updateOffset;

	      if (months) {
	        setMonth(mom, get(mom, 'Month') + months * isAdding);
	      }

	      if (days) {
	        set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
	      }

	      if (milliseconds) {
	        mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
	      }

	      if (updateOffset) {
	        hooks.updateOffset(mom, days || months);
	      }
	    }

	    var add = createAdder(1, 'add');
	    var subtract = createAdder(-1, 'subtract');

	    function getCalendarFormat(myMoment, now) {
	      var diff = myMoment.diff(now, 'days', true);
	      return diff < -6 ? 'sameElse' : diff < -1 ? 'lastWeek' : diff < 0 ? 'lastDay' : diff < 1 ? 'sameDay' : diff < 2 ? 'nextDay' : diff < 7 ? 'nextWeek' : 'sameElse';
	    }

	    function calendar$1(time, formats) {
	      // We want to compare the start of today, vs this.
	      // Getting start-of-today depends on whether we're local/utc/offset or not.
	      var now = time || createLocal(),
	          sod = cloneWithOffset(now, this).startOf('day'),
	          format = hooks.calendarFormat(this, sod) || 'sameElse';
	      var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);
	      return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
	    }

	    function clone() {
	      return new Moment(this);
	    }

	    function isAfter(input, units) {
	      var localInput = isMoment(input) ? input : createLocal(input);

	      if (!(this.isValid() && localInput.isValid())) {
	        return false;
	      }

	      units = normalizeUnits(units) || 'millisecond';

	      if (units === 'millisecond') {
	        return this.valueOf() > localInput.valueOf();
	      } else {
	        return localInput.valueOf() < this.clone().startOf(units).valueOf();
	      }
	    }

	    function isBefore(input, units) {
	      var localInput = isMoment(input) ? input : createLocal(input);

	      if (!(this.isValid() && localInput.isValid())) {
	        return false;
	      }

	      units = normalizeUnits(units) || 'millisecond';

	      if (units === 'millisecond') {
	        return this.valueOf() < localInput.valueOf();
	      } else {
	        return this.clone().endOf(units).valueOf() < localInput.valueOf();
	      }
	    }

	    function isBetween(from, to, units, inclusivity) {
	      var localFrom = isMoment(from) ? from : createLocal(from),
	          localTo = isMoment(to) ? to : createLocal(to);

	      if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
	        return false;
	      }

	      inclusivity = inclusivity || '()';
	      return (inclusivity[0] === '(' ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) && (inclusivity[1] === ')' ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
	    }

	    function isSame(input, units) {
	      var localInput = isMoment(input) ? input : createLocal(input),
	          inputMs;

	      if (!(this.isValid() && localInput.isValid())) {
	        return false;
	      }

	      units = normalizeUnits(units) || 'millisecond';

	      if (units === 'millisecond') {
	        return this.valueOf() === localInput.valueOf();
	      } else {
	        inputMs = localInput.valueOf();
	        return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
	      }
	    }

	    function isSameOrAfter(input, units) {
	      return this.isSame(input, units) || this.isAfter(input, units);
	    }

	    function isSameOrBefore(input, units) {
	      return this.isSame(input, units) || this.isBefore(input, units);
	    }

	    function diff(input, units, asFloat) {
	      var that, zoneDelta, output;

	      if (!this.isValid()) {
	        return NaN;
	      }

	      that = cloneWithOffset(input, this);

	      if (!that.isValid()) {
	        return NaN;
	      }

	      zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
	      units = normalizeUnits(units);

	      switch (units) {
	        case 'year':
	          output = monthDiff(this, that) / 12;
	          break;

	        case 'month':
	          output = monthDiff(this, that);
	          break;

	        case 'quarter':
	          output = monthDiff(this, that) / 3;
	          break;

	        case 'second':
	          output = (this - that) / 1e3;
	          break;
	        // 1000

	        case 'minute':
	          output = (this - that) / 6e4;
	          break;
	        // 1000 * 60

	        case 'hour':
	          output = (this - that) / 36e5;
	          break;
	        // 1000 * 60 * 60

	        case 'day':
	          output = (this - that - zoneDelta) / 864e5;
	          break;
	        // 1000 * 60 * 60 * 24, negate dst

	        case 'week':
	          output = (this - that - zoneDelta) / 6048e5;
	          break;
	        // 1000 * 60 * 60 * 24 * 7, negate dst

	        default:
	          output = this - that;
	      }

	      return asFloat ? output : absFloor(output);
	    }

	    function monthDiff(a, b) {
	      // difference in months
	      var wholeMonthDiff = (b.year() - a.year()) * 12 + (b.month() - a.month()),
	          // b is in (anchor - 1 month, anchor + 1 month)
	      anchor = a.clone().add(wholeMonthDiff, 'months'),
	          anchor2,
	          adjust;

	      if (b - anchor < 0) {
	        anchor2 = a.clone().add(wholeMonthDiff - 1, 'months'); // linear across the month

	        adjust = (b - anchor) / (anchor - anchor2);
	      } else {
	        anchor2 = a.clone().add(wholeMonthDiff + 1, 'months'); // linear across the month

	        adjust = (b - anchor) / (anchor2 - anchor);
	      } //check for negative zero, return zero if negative zero


	      return -(wholeMonthDiff + adjust) || 0;
	    }

	    hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
	    hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

	    function toString() {
	      return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
	    }

	    function toISOString(keepOffset) {
	      if (!this.isValid()) {
	        return null;
	      }

	      var utc = keepOffset !== true;
	      var m = utc ? this.clone().utc() : this;

	      if (m.year() < 0 || m.year() > 9999) {
	        return formatMoment(m, utc ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');
	      }

	      if (isFunction(Date.prototype.toISOString)) {
	        // native implementation is ~50x faster, use it when we can
	        if (utc) {
	          return this.toDate().toISOString();
	        } else {
	          return new Date(this.valueOf() + this.utcOffset() * 60 * 1000).toISOString().replace('Z', formatMoment(m, 'Z'));
	        }
	      }

	      return formatMoment(m, utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ');
	    }
	    /**
	     * Return a human readable representation of a moment that can
	     * also be evaluated to get a new moment which is the same
	     *
	     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
	     */


	    function inspect() {
	      if (!this.isValid()) {
	        return 'moment.invalid(/* ' + this._i + ' */)';
	      }

	      var func = 'moment';
	      var zone = '';

	      if (!this.isLocal()) {
	        func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
	        zone = 'Z';
	      }

	      var prefix = '[' + func + '("]';
	      var year = 0 <= this.year() && this.year() <= 9999 ? 'YYYY' : 'YYYYYY';
	      var datetime = '-MM-DD[T]HH:mm:ss.SSS';
	      var suffix = zone + '[")]';
	      return this.format(prefix + year + datetime + suffix);
	    }

	    function format(inputString) {
	      if (!inputString) {
	        inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
	      }

	      var output = formatMoment(this, inputString);
	      return this.localeData().postformat(output);
	    }

	    function from(time, withoutSuffix) {
	      if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
	        return createDuration({
	          to: this,
	          from: time
	        }).locale(this.locale()).humanize(!withoutSuffix);
	      } else {
	        return this.localeData().invalidDate();
	      }
	    }

	    function fromNow(withoutSuffix) {
	      return this.from(createLocal(), withoutSuffix);
	    }

	    function to(time, withoutSuffix) {
	      if (this.isValid() && (isMoment(time) && time.isValid() || createLocal(time).isValid())) {
	        return createDuration({
	          from: this,
	          to: time
	        }).locale(this.locale()).humanize(!withoutSuffix);
	      } else {
	        return this.localeData().invalidDate();
	      }
	    }

	    function toNow(withoutSuffix) {
	      return this.to(createLocal(), withoutSuffix);
	    } // If passed a locale key, it will set the locale for this
	    // instance.  Otherwise, it will return the locale configuration
	    // variables for this instance.


	    function locale(key) {
	      var newLocaleData;

	      if (key === undefined) {
	        return this._locale._abbr;
	      } else {
	        newLocaleData = getLocale(key);

	        if (newLocaleData != null) {
	          this._locale = newLocaleData;
	        }

	        return this;
	      }
	    }

	    var lang = deprecate('moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.', function (key) {
	      if (key === undefined) {
	        return this.localeData();
	      } else {
	        return this.locale(key);
	      }
	    });

	    function localeData() {
	      return this._locale;
	    }

	    var MS_PER_SECOND = 1000;
	    var MS_PER_MINUTE = 60 * MS_PER_SECOND;
	    var MS_PER_HOUR = 60 * MS_PER_MINUTE;
	    var MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR; // actual modulo - handles negative numbers (for dates before 1970):

	    function mod$1(dividend, divisor) {
	      return (dividend % divisor + divisor) % divisor;
	    }

	    function localStartOfDate(y, m, d) {
	      // the date constructor remaps years 0-99 to 1900-1999
	      if (y < 100 && y >= 0) {
	        // preserve leap years using a full 400 year cycle, then reset
	        return new Date(y + 400, m, d) - MS_PER_400_YEARS;
	      } else {
	        return new Date(y, m, d).valueOf();
	      }
	    }

	    function utcStartOfDate(y, m, d) {
	      // Date.UTC remaps years 0-99 to 1900-1999
	      if (y < 100 && y >= 0) {
	        // preserve leap years using a full 400 year cycle, then reset
	        return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
	      } else {
	        return Date.UTC(y, m, d);
	      }
	    }

	    function startOf(units) {
	      var time;
	      units = normalizeUnits(units);

	      if (units === undefined || units === 'millisecond' || !this.isValid()) {
	        return this;
	      }

	      var startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

	      switch (units) {
	        case 'year':
	          time = startOfDate(this.year(), 0, 1);
	          break;

	        case 'quarter':
	          time = startOfDate(this.year(), this.month() - this.month() % 3, 1);
	          break;

	        case 'month':
	          time = startOfDate(this.year(), this.month(), 1);
	          break;

	        case 'week':
	          time = startOfDate(this.year(), this.month(), this.date() - this.weekday());
	          break;

	        case 'isoWeek':
	          time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1));
	          break;

	        case 'day':
	        case 'date':
	          time = startOfDate(this.year(), this.month(), this.date());
	          break;

	        case 'hour':
	          time = this._d.valueOf();
	          time -= mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR);
	          break;

	        case 'minute':
	          time = this._d.valueOf();
	          time -= mod$1(time, MS_PER_MINUTE);
	          break;

	        case 'second':
	          time = this._d.valueOf();
	          time -= mod$1(time, MS_PER_SECOND);
	          break;
	      }

	      this._d.setTime(time);

	      hooks.updateOffset(this, true);
	      return this;
	    }

	    function endOf(units) {
	      var time;
	      units = normalizeUnits(units);

	      if (units === undefined || units === 'millisecond' || !this.isValid()) {
	        return this;
	      }

	      var startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

	      switch (units) {
	        case 'year':
	          time = startOfDate(this.year() + 1, 0, 1) - 1;
	          break;

	        case 'quarter':
	          time = startOfDate(this.year(), this.month() - this.month() % 3 + 3, 1) - 1;
	          break;

	        case 'month':
	          time = startOfDate(this.year(), this.month() + 1, 1) - 1;
	          break;

	        case 'week':
	          time = startOfDate(this.year(), this.month(), this.date() - this.weekday() + 7) - 1;
	          break;

	        case 'isoWeek':
	          time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1) + 7) - 1;
	          break;

	        case 'day':
	        case 'date':
	          time = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
	          break;

	        case 'hour':
	          time = this._d.valueOf();
	          time += MS_PER_HOUR - mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR) - 1;
	          break;

	        case 'minute':
	          time = this._d.valueOf();
	          time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
	          break;

	        case 'second':
	          time = this._d.valueOf();
	          time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
	          break;
	      }

	      this._d.setTime(time);

	      hooks.updateOffset(this, true);
	      return this;
	    }

	    function valueOf() {
	      return this._d.valueOf() - (this._offset || 0) * 60000;
	    }

	    function unix() {
	      return Math.floor(this.valueOf() / 1000);
	    }

	    function toDate() {
	      return new Date(this.valueOf());
	    }

	    function toArray() {
	      var m = this;
	      return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
	    }

	    function toObject() {
	      var m = this;
	      return {
	        years: m.year(),
	        months: m.month(),
	        date: m.date(),
	        hours: m.hours(),
	        minutes: m.minutes(),
	        seconds: m.seconds(),
	        milliseconds: m.milliseconds()
	      };
	    }

	    function toJSON() {
	      // new Date(NaN).toJSON() === null
	      return this.isValid() ? this.toISOString() : null;
	    }

	    function isValid$2() {
	      return isValid(this);
	    }

	    function parsingFlags() {
	      return extend({}, getParsingFlags(this));
	    }

	    function invalidAt() {
	      return getParsingFlags(this).overflow;
	    }

	    function creationData() {
	      return {
	        input: this._i,
	        format: this._f,
	        locale: this._locale,
	        isUTC: this._isUTC,
	        strict: this._strict
	      };
	    } // FORMATTING


	    addFormatToken(0, ['gg', 2], 0, function () {
	      return this.weekYear() % 100;
	    });
	    addFormatToken(0, ['GG', 2], 0, function () {
	      return this.isoWeekYear() % 100;
	    });

	    function addWeekYearFormatToken(token, getter) {
	      addFormatToken(0, [token, token.length], 0, getter);
	    }

	    addWeekYearFormatToken('gggg', 'weekYear');
	    addWeekYearFormatToken('ggggg', 'weekYear');
	    addWeekYearFormatToken('GGGG', 'isoWeekYear');
	    addWeekYearFormatToken('GGGGG', 'isoWeekYear'); // ALIASES

	    addUnitAlias('weekYear', 'gg');
	    addUnitAlias('isoWeekYear', 'GG'); // PRIORITY

	    addUnitPriority('weekYear', 1);
	    addUnitPriority('isoWeekYear', 1); // PARSING

	    addRegexToken('G', matchSigned);
	    addRegexToken('g', matchSigned);
	    addRegexToken('GG', match1to2, match2);
	    addRegexToken('gg', match1to2, match2);
	    addRegexToken('GGGG', match1to4, match4);
	    addRegexToken('gggg', match1to4, match4);
	    addRegexToken('GGGGG', match1to6, match6);
	    addRegexToken('ggggg', match1to6, match6);
	    addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
	      week[token.substr(0, 2)] = toInt(input);
	    });
	    addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
	      week[token] = hooks.parseTwoDigitYear(input);
	    }); // MOMENTS

	    function getSetWeekYear(input) {
	      return getSetWeekYearHelper.call(this, input, this.week(), this.weekday(), this.localeData()._week.dow, this.localeData()._week.doy);
	    }

	    function getSetISOWeekYear(input) {
	      return getSetWeekYearHelper.call(this, input, this.isoWeek(), this.isoWeekday(), 1, 4);
	    }

	    function getISOWeeksInYear() {
	      return weeksInYear(this.year(), 1, 4);
	    }

	    function getWeeksInYear() {
	      var weekInfo = this.localeData()._week;

	      return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
	    }

	    function getSetWeekYearHelper(input, week, weekday, dow, doy) {
	      var weeksTarget;

	      if (input == null) {
	        return weekOfYear(this, dow, doy).year;
	      } else {
	        weeksTarget = weeksInYear(input, dow, doy);

	        if (week > weeksTarget) {
	          week = weeksTarget;
	        }

	        return setWeekAll.call(this, input, week, weekday, dow, doy);
	      }
	    }

	    function setWeekAll(weekYear, week, weekday, dow, doy) {
	      var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
	          date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
	      this.year(date.getUTCFullYear());
	      this.month(date.getUTCMonth());
	      this.date(date.getUTCDate());
	      return this;
	    } // FORMATTING


	    addFormatToken('Q', 0, 'Qo', 'quarter'); // ALIASES

	    addUnitAlias('quarter', 'Q'); // PRIORITY

	    addUnitPriority('quarter', 7); // PARSING

	    addRegexToken('Q', match1);
	    addParseToken('Q', function (input, array) {
	      array[MONTH] = (toInt(input) - 1) * 3;
	    }); // MOMENTS

	    function getSetQuarter(input) {
	      return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
	    } // FORMATTING


	    addFormatToken('D', ['DD', 2], 'Do', 'date'); // ALIASES

	    addUnitAlias('date', 'D'); // PRIORITY

	    addUnitPriority('date', 9); // PARSING

	    addRegexToken('D', match1to2);
	    addRegexToken('DD', match1to2, match2);
	    addRegexToken('Do', function (isStrict, locale) {
	      // TODO: Remove "ordinalParse" fallback in next major release.
	      return isStrict ? locale._dayOfMonthOrdinalParse || locale._ordinalParse : locale._dayOfMonthOrdinalParseLenient;
	    });
	    addParseToken(['D', 'DD'], DATE);
	    addParseToken('Do', function (input, array) {
	      array[DATE] = toInt(input.match(match1to2)[0]);
	    }); // MOMENTS

	    var getSetDayOfMonth = makeGetSet('Date', true); // FORMATTING

	    addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear'); // ALIASES

	    addUnitAlias('dayOfYear', 'DDD'); // PRIORITY

	    addUnitPriority('dayOfYear', 4); // PARSING

	    addRegexToken('DDD', match1to3);
	    addRegexToken('DDDD', match3);
	    addParseToken(['DDD', 'DDDD'], function (input, array, config) {
	      config._dayOfYear = toInt(input);
	    }); // HELPERS
	    // MOMENTS

	    function getSetDayOfYear(input) {
	      var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
	      return input == null ? dayOfYear : this.add(input - dayOfYear, 'd');
	    } // FORMATTING


	    addFormatToken('m', ['mm', 2], 0, 'minute'); // ALIASES

	    addUnitAlias('minute', 'm'); // PRIORITY

	    addUnitPriority('minute', 14); // PARSING

	    addRegexToken('m', match1to2);
	    addRegexToken('mm', match1to2, match2);
	    addParseToken(['m', 'mm'], MINUTE); // MOMENTS

	    var getSetMinute = makeGetSet('Minutes', false); // FORMATTING

	    addFormatToken('s', ['ss', 2], 0, 'second'); // ALIASES

	    addUnitAlias('second', 's'); // PRIORITY

	    addUnitPriority('second', 15); // PARSING

	    addRegexToken('s', match1to2);
	    addRegexToken('ss', match1to2, match2);
	    addParseToken(['s', 'ss'], SECOND); // MOMENTS

	    var getSetSecond = makeGetSet('Seconds', false); // FORMATTING

	    addFormatToken('S', 0, 0, function () {
	      return ~~(this.millisecond() / 100);
	    });
	    addFormatToken(0, ['SS', 2], 0, function () {
	      return ~~(this.millisecond() / 10);
	    });
	    addFormatToken(0, ['SSS', 3], 0, 'millisecond');
	    addFormatToken(0, ['SSSS', 4], 0, function () {
	      return this.millisecond() * 10;
	    });
	    addFormatToken(0, ['SSSSS', 5], 0, function () {
	      return this.millisecond() * 100;
	    });
	    addFormatToken(0, ['SSSSSS', 6], 0, function () {
	      return this.millisecond() * 1000;
	    });
	    addFormatToken(0, ['SSSSSSS', 7], 0, function () {
	      return this.millisecond() * 10000;
	    });
	    addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
	      return this.millisecond() * 100000;
	    });
	    addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
	      return this.millisecond() * 1000000;
	    }); // ALIASES

	    addUnitAlias('millisecond', 'ms'); // PRIORITY

	    addUnitPriority('millisecond', 16); // PARSING

	    addRegexToken('S', match1to3, match1);
	    addRegexToken('SS', match1to3, match2);
	    addRegexToken('SSS', match1to3, match3);
	    var token;

	    for (token = 'SSSS'; token.length <= 9; token += 'S') {
	      addRegexToken(token, matchUnsigned);
	    }

	    function parseMs(input, array) {
	      array[MILLISECOND] = toInt(('0.' + input) * 1000);
	    }

	    for (token = 'S'; token.length <= 9; token += 'S') {
	      addParseToken(token, parseMs);
	    } // MOMENTS


	    var getSetMillisecond = makeGetSet('Milliseconds', false); // FORMATTING

	    addFormatToken('z', 0, 0, 'zoneAbbr');
	    addFormatToken('zz', 0, 0, 'zoneName'); // MOMENTS

	    function getZoneAbbr() {
	      return this._isUTC ? 'UTC' : '';
	    }

	    function getZoneName() {
	      return this._isUTC ? 'Coordinated Universal Time' : '';
	    }

	    var proto = Moment.prototype;
	    proto.add = add;
	    proto.calendar = calendar$1;
	    proto.clone = clone;
	    proto.diff = diff;
	    proto.endOf = endOf;
	    proto.format = format;
	    proto.from = from;
	    proto.fromNow = fromNow;
	    proto.to = to;
	    proto.toNow = toNow;
	    proto.get = stringGet;
	    proto.invalidAt = invalidAt;
	    proto.isAfter = isAfter;
	    proto.isBefore = isBefore;
	    proto.isBetween = isBetween;
	    proto.isSame = isSame;
	    proto.isSameOrAfter = isSameOrAfter;
	    proto.isSameOrBefore = isSameOrBefore;
	    proto.isValid = isValid$2;
	    proto.lang = lang;
	    proto.locale = locale;
	    proto.localeData = localeData;
	    proto.max = prototypeMax;
	    proto.min = prototypeMin;
	    proto.parsingFlags = parsingFlags;
	    proto.set = stringSet;
	    proto.startOf = startOf;
	    proto.subtract = subtract;
	    proto.toArray = toArray;
	    proto.toObject = toObject;
	    proto.toDate = toDate;
	    proto.toISOString = toISOString;
	    proto.inspect = inspect;
	    proto.toJSON = toJSON;
	    proto.toString = toString;
	    proto.unix = unix;
	    proto.valueOf = valueOf;
	    proto.creationData = creationData;
	    proto.year = getSetYear;
	    proto.isLeapYear = getIsLeapYear;
	    proto.weekYear = getSetWeekYear;
	    proto.isoWeekYear = getSetISOWeekYear;
	    proto.quarter = proto.quarters = getSetQuarter;
	    proto.month = getSetMonth;
	    proto.daysInMonth = getDaysInMonth;
	    proto.week = proto.weeks = getSetWeek;
	    proto.isoWeek = proto.isoWeeks = getSetISOWeek;
	    proto.weeksInYear = getWeeksInYear;
	    proto.isoWeeksInYear = getISOWeeksInYear;
	    proto.date = getSetDayOfMonth;
	    proto.day = proto.days = getSetDayOfWeek;
	    proto.weekday = getSetLocaleDayOfWeek;
	    proto.isoWeekday = getSetISODayOfWeek;
	    proto.dayOfYear = getSetDayOfYear;
	    proto.hour = proto.hours = getSetHour;
	    proto.minute = proto.minutes = getSetMinute;
	    proto.second = proto.seconds = getSetSecond;
	    proto.millisecond = proto.milliseconds = getSetMillisecond;
	    proto.utcOffset = getSetOffset;
	    proto.utc = setOffsetToUTC;
	    proto.local = setOffsetToLocal;
	    proto.parseZone = setOffsetToParsedOffset;
	    proto.hasAlignedHourOffset = hasAlignedHourOffset;
	    proto.isDST = isDaylightSavingTime;
	    proto.isLocal = isLocal;
	    proto.isUtcOffset = isUtcOffset;
	    proto.isUtc = isUtc;
	    proto.isUTC = isUtc;
	    proto.zoneAbbr = getZoneAbbr;
	    proto.zoneName = getZoneName;
	    proto.dates = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
	    proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
	    proto.years = deprecate('years accessor is deprecated. Use year instead', getSetYear);
	    proto.zone = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
	    proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

	    function createUnix(input) {
	      return createLocal(input * 1000);
	    }

	    function createInZone() {
	      return createLocal.apply(null, arguments).parseZone();
	    }

	    function preParsePostFormat(string) {
	      return string;
	    }

	    var proto$1 = Locale.prototype;
	    proto$1.calendar = calendar;
	    proto$1.longDateFormat = longDateFormat;
	    proto$1.invalidDate = invalidDate;
	    proto$1.ordinal = ordinal;
	    proto$1.preparse = preParsePostFormat;
	    proto$1.postformat = preParsePostFormat;
	    proto$1.relativeTime = relativeTime;
	    proto$1.pastFuture = pastFuture;
	    proto$1.set = set;
	    proto$1.months = localeMonths;
	    proto$1.monthsShort = localeMonthsShort;
	    proto$1.monthsParse = localeMonthsParse;
	    proto$1.monthsRegex = monthsRegex;
	    proto$1.monthsShortRegex = monthsShortRegex;
	    proto$1.week = localeWeek;
	    proto$1.firstDayOfYear = localeFirstDayOfYear;
	    proto$1.firstDayOfWeek = localeFirstDayOfWeek;
	    proto$1.weekdays = localeWeekdays;
	    proto$1.weekdaysMin = localeWeekdaysMin;
	    proto$1.weekdaysShort = localeWeekdaysShort;
	    proto$1.weekdaysParse = localeWeekdaysParse;
	    proto$1.weekdaysRegex = weekdaysRegex;
	    proto$1.weekdaysShortRegex = weekdaysShortRegex;
	    proto$1.weekdaysMinRegex = weekdaysMinRegex;
	    proto$1.isPM = localeIsPM;
	    proto$1.meridiem = localeMeridiem;

	    function get$1(format, index, field, setter) {
	      var locale = getLocale();
	      var utc = createUTC().set(setter, index);
	      return locale[field](utc, format);
	    }

	    function listMonthsImpl(format, index, field) {
	      if (isNumber(format)) {
	        index = format;
	        format = undefined;
	      }

	      format = format || '';

	      if (index != null) {
	        return get$1(format, index, field, 'month');
	      }

	      var i;
	      var out = [];

	      for (i = 0; i < 12; i++) {
	        out[i] = get$1(format, i, field, 'month');
	      }

	      return out;
	    } // ()
	    // (5)
	    // (fmt, 5)
	    // (fmt)
	    // (true)
	    // (true, 5)
	    // (true, fmt, 5)
	    // (true, fmt)


	    function listWeekdaysImpl(localeSorted, format, index, field) {
	      if (typeof localeSorted === 'boolean') {
	        if (isNumber(format)) {
	          index = format;
	          format = undefined;
	        }

	        format = format || '';
	      } else {
	        format = localeSorted;
	        index = format;
	        localeSorted = false;

	        if (isNumber(format)) {
	          index = format;
	          format = undefined;
	        }

	        format = format || '';
	      }

	      var locale = getLocale(),
	          shift = localeSorted ? locale._week.dow : 0;

	      if (index != null) {
	        return get$1(format, (index + shift) % 7, field, 'day');
	      }

	      var i;
	      var out = [];

	      for (i = 0; i < 7; i++) {
	        out[i] = get$1(format, (i + shift) % 7, field, 'day');
	      }

	      return out;
	    }

	    function listMonths(format, index) {
	      return listMonthsImpl(format, index, 'months');
	    }

	    function listMonthsShort(format, index) {
	      return listMonthsImpl(format, index, 'monthsShort');
	    }

	    function listWeekdays(localeSorted, format, index) {
	      return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
	    }

	    function listWeekdaysShort(localeSorted, format, index) {
	      return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
	    }

	    function listWeekdaysMin(localeSorted, format, index) {
	      return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
	    }

	    getSetGlobalLocale('en', {
	      dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
	      ordinal: function (number) {
	        var b = number % 10,
	            output = toInt(number % 100 / 10) === 1 ? 'th' : b === 1 ? 'st' : b === 2 ? 'nd' : b === 3 ? 'rd' : 'th';
	        return number + output;
	      }
	    }); // Side effect imports

	    hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
	    hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);
	    var mathAbs = Math.abs;

	    function abs() {
	      var data = this._data;
	      this._milliseconds = mathAbs(this._milliseconds);
	      this._days = mathAbs(this._days);
	      this._months = mathAbs(this._months);
	      data.milliseconds = mathAbs(data.milliseconds);
	      data.seconds = mathAbs(data.seconds);
	      data.minutes = mathAbs(data.minutes);
	      data.hours = mathAbs(data.hours);
	      data.months = mathAbs(data.months);
	      data.years = mathAbs(data.years);
	      return this;
	    }

	    function addSubtract$1(duration, input, value, direction) {
	      var other = createDuration(input, value);
	      duration._milliseconds += direction * other._milliseconds;
	      duration._days += direction * other._days;
	      duration._months += direction * other._months;
	      return duration._bubble();
	    } // supports only 2.0-style add(1, 's') or add(duration)


	    function add$1(input, value) {
	      return addSubtract$1(this, input, value, 1);
	    } // supports only 2.0-style subtract(1, 's') or subtract(duration)


	    function subtract$1(input, value) {
	      return addSubtract$1(this, input, value, -1);
	    }

	    function absCeil(number) {
	      if (number < 0) {
	        return Math.floor(number);
	      } else {
	        return Math.ceil(number);
	      }
	    }

	    function bubble() {
	      var milliseconds = this._milliseconds;
	      var days = this._days;
	      var months = this._months;
	      var data = this._data;
	      var seconds, minutes, hours, years, monthsFromDays; // if we have a mix of positive and negative values, bubble down first
	      // check: https://github.com/moment/moment/issues/2166

	      if (!(milliseconds >= 0 && days >= 0 && months >= 0 || milliseconds <= 0 && days <= 0 && months <= 0)) {
	        milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
	        days = 0;
	        months = 0;
	      } // The following code bubbles up values, see the tests for
	      // examples of what that means.


	      data.milliseconds = milliseconds % 1000;
	      seconds = absFloor(milliseconds / 1000);
	      data.seconds = seconds % 60;
	      minutes = absFloor(seconds / 60);
	      data.minutes = minutes % 60;
	      hours = absFloor(minutes / 60);
	      data.hours = hours % 24;
	      days += absFloor(hours / 24); // convert days to months

	      monthsFromDays = absFloor(daysToMonths(days));
	      months += monthsFromDays;
	      days -= absCeil(monthsToDays(monthsFromDays)); // 12 months -> 1 year

	      years = absFloor(months / 12);
	      months %= 12;
	      data.days = days;
	      data.months = months;
	      data.years = years;
	      return this;
	    }

	    function daysToMonths(days) {
	      // 400 years have 146097 days (taking into account leap year rules)
	      // 400 years have 12 months === 4800
	      return days * 4800 / 146097;
	    }

	    function monthsToDays(months) {
	      // the reverse of daysToMonths
	      return months * 146097 / 4800;
	    }

	    function as(units) {
	      if (!this.isValid()) {
	        return NaN;
	      }

	      var days;
	      var months;
	      var milliseconds = this._milliseconds;
	      units = normalizeUnits(units);

	      if (units === 'month' || units === 'quarter' || units === 'year') {
	        days = this._days + milliseconds / 864e5;
	        months = this._months + daysToMonths(days);

	        switch (units) {
	          case 'month':
	            return months;

	          case 'quarter':
	            return months / 3;

	          case 'year':
	            return months / 12;
	        }
	      } else {
	        // handle milliseconds separately because of floating point math errors (issue #1867)
	        days = this._days + Math.round(monthsToDays(this._months));

	        switch (units) {
	          case 'week':
	            return days / 7 + milliseconds / 6048e5;

	          case 'day':
	            return days + milliseconds / 864e5;

	          case 'hour':
	            return days * 24 + milliseconds / 36e5;

	          case 'minute':
	            return days * 1440 + milliseconds / 6e4;

	          case 'second':
	            return days * 86400 + milliseconds / 1000;
	          // Math.floor prevents floating point math errors here

	          case 'millisecond':
	            return Math.floor(days * 864e5) + milliseconds;

	          default:
	            throw new Error('Unknown unit ' + units);
	        }
	      }
	    } // TODO: Use this.as('ms')?


	    function valueOf$1() {
	      if (!this.isValid()) {
	        return NaN;
	      }

	      return this._milliseconds + this._days * 864e5 + this._months % 12 * 2592e6 + toInt(this._months / 12) * 31536e6;
	    }

	    function makeAs(alias) {
	      return function () {
	        return this.as(alias);
	      };
	    }

	    var asMilliseconds = makeAs('ms');
	    var asSeconds = makeAs('s');
	    var asMinutes = makeAs('m');
	    var asHours = makeAs('h');
	    var asDays = makeAs('d');
	    var asWeeks = makeAs('w');
	    var asMonths = makeAs('M');
	    var asQuarters = makeAs('Q');
	    var asYears = makeAs('y');

	    function clone$1() {
	      return createDuration(this);
	    }

	    function get$2(units) {
	      units = normalizeUnits(units);
	      return this.isValid() ? this[units + 's']() : NaN;
	    }

	    function makeGetter(name) {
	      return function () {
	        return this.isValid() ? this._data[name] : NaN;
	      };
	    }

	    var milliseconds = makeGetter('milliseconds');
	    var seconds = makeGetter('seconds');
	    var minutes = makeGetter('minutes');
	    var hours = makeGetter('hours');
	    var days = makeGetter('days');
	    var months = makeGetter('months');
	    var years = makeGetter('years');

	    function weeks() {
	      return absFloor(this.days() / 7);
	    }

	    var round = Math.round;
	    var thresholds = {
	      ss: 44,
	      // a few seconds to seconds
	      s: 45,
	      // seconds to minute
	      m: 45,
	      // minutes to hour
	      h: 22,
	      // hours to day
	      d: 26,
	      // days to month
	      M: 11 // months to year

	    }; // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize

	    function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
	      return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
	    }

	    function relativeTime$1(posNegDuration, withoutSuffix, locale) {
	      var duration = createDuration(posNegDuration).abs();
	      var seconds = round(duration.as('s'));
	      var minutes = round(duration.as('m'));
	      var hours = round(duration.as('h'));
	      var days = round(duration.as('d'));
	      var months = round(duration.as('M'));
	      var years = round(duration.as('y'));
	      var a = seconds <= thresholds.ss && ['s', seconds] || seconds < thresholds.s && ['ss', seconds] || minutes <= 1 && ['m'] || minutes < thresholds.m && ['mm', minutes] || hours <= 1 && ['h'] || hours < thresholds.h && ['hh', hours] || days <= 1 && ['d'] || days < thresholds.d && ['dd', days] || months <= 1 && ['M'] || months < thresholds.M && ['MM', months] || years <= 1 && ['y'] || ['yy', years];
	      a[2] = withoutSuffix;
	      a[3] = +posNegDuration > 0;
	      a[4] = locale;
	      return substituteTimeAgo.apply(null, a);
	    } // This function allows you to set the rounding function for relative time strings


	    function getSetRelativeTimeRounding(roundingFunction) {
	      if (roundingFunction === undefined) {
	        return round;
	      }

	      if (typeof roundingFunction === 'function') {
	        round = roundingFunction;
	        return true;
	      }

	      return false;
	    } // This function allows you to set a threshold for relative time strings


	    function getSetRelativeTimeThreshold(threshold, limit) {
	      if (thresholds[threshold] === undefined) {
	        return false;
	      }

	      if (limit === undefined) {
	        return thresholds[threshold];
	      }

	      thresholds[threshold] = limit;

	      if (threshold === 's') {
	        thresholds.ss = limit - 1;
	      }

	      return true;
	    }

	    function humanize(withSuffix) {
	      if (!this.isValid()) {
	        return this.localeData().invalidDate();
	      }

	      var locale = this.localeData();
	      var output = relativeTime$1(this, !withSuffix, locale);

	      if (withSuffix) {
	        output = locale.pastFuture(+this, output);
	      }

	      return locale.postformat(output);
	    }

	    var abs$1 = Math.abs;

	    function sign(x) {
	      return (x > 0) - (x < 0) || +x;
	    }

	    function toISOString$1() {
	      // for ISO strings we do not use the normal bubbling rules:
	      //  * milliseconds bubble up until they become hours
	      //  * days do not bubble at all
	      //  * months bubble up until they become years
	      // This is because there is no context-free conversion between hours and days
	      // (think of clock changes)
	      // and also not between days and months (28-31 days per month)
	      if (!this.isValid()) {
	        return this.localeData().invalidDate();
	      }

	      var seconds = abs$1(this._milliseconds) / 1000;
	      var days = abs$1(this._days);
	      var months = abs$1(this._months);
	      var minutes, hours, years; // 3600 seconds -> 60 minutes -> 1 hour

	      minutes = absFloor(seconds / 60);
	      hours = absFloor(minutes / 60);
	      seconds %= 60;
	      minutes %= 60; // 12 months -> 1 year

	      years = absFloor(months / 12);
	      months %= 12; // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js

	      var Y = years;
	      var M = months;
	      var D = days;
	      var h = hours;
	      var m = minutes;
	      var s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';
	      var total = this.asSeconds();

	      if (!total) {
	        // this is the same as C#'s (Noda) and python (isodate)...
	        // but not other JS (goog.date)
	        return 'P0D';
	      }

	      var totalSign = total < 0 ? '-' : '';
	      var ymSign = sign(this._months) !== sign(total) ? '-' : '';
	      var daysSign = sign(this._days) !== sign(total) ? '-' : '';
	      var hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';
	      return totalSign + 'P' + (Y ? ymSign + Y + 'Y' : '') + (M ? ymSign + M + 'M' : '') + (D ? daysSign + D + 'D' : '') + (h || m || s ? 'T' : '') + (h ? hmsSign + h + 'H' : '') + (m ? hmsSign + m + 'M' : '') + (s ? hmsSign + s + 'S' : '');
	    }

	    var proto$2 = Duration.prototype;
	    proto$2.isValid = isValid$1;
	    proto$2.abs = abs;
	    proto$2.add = add$1;
	    proto$2.subtract = subtract$1;
	    proto$2.as = as;
	    proto$2.asMilliseconds = asMilliseconds;
	    proto$2.asSeconds = asSeconds;
	    proto$2.asMinutes = asMinutes;
	    proto$2.asHours = asHours;
	    proto$2.asDays = asDays;
	    proto$2.asWeeks = asWeeks;
	    proto$2.asMonths = asMonths;
	    proto$2.asQuarters = asQuarters;
	    proto$2.asYears = asYears;
	    proto$2.valueOf = valueOf$1;
	    proto$2._bubble = bubble;
	    proto$2.clone = clone$1;
	    proto$2.get = get$2;
	    proto$2.milliseconds = milliseconds;
	    proto$2.seconds = seconds;
	    proto$2.minutes = minutes;
	    proto$2.hours = hours;
	    proto$2.days = days;
	    proto$2.weeks = weeks;
	    proto$2.months = months;
	    proto$2.years = years;
	    proto$2.humanize = humanize;
	    proto$2.toISOString = toISOString$1;
	    proto$2.toString = toISOString$1;
	    proto$2.toJSON = toISOString$1;
	    proto$2.locale = locale;
	    proto$2.localeData = localeData;
	    proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
	    proto$2.lang = lang; // Side effect imports
	    // FORMATTING

	    addFormatToken('X', 0, 0, 'unix');
	    addFormatToken('x', 0, 0, 'valueOf'); // PARSING

	    addRegexToken('x', matchSigned);
	    addRegexToken('X', matchTimestamp);
	    addParseToken('X', function (input, array, config) {
	      config._d = new Date(parseFloat(input, 10) * 1000);
	    });
	    addParseToken('x', function (input, array, config) {
	      config._d = new Date(toInt(input));
	    }); // Side effect imports

	    hooks.version = '2.24.0';
	    setHookCallback(createLocal);
	    hooks.fn = proto;
	    hooks.min = min;
	    hooks.max = max;
	    hooks.now = now;
	    hooks.utc = createUTC;
	    hooks.unix = createUnix;
	    hooks.months = listMonths;
	    hooks.isDate = isDate;
	    hooks.locale = getSetGlobalLocale;
	    hooks.invalid = createInvalid;
	    hooks.duration = createDuration;
	    hooks.isMoment = isMoment;
	    hooks.weekdays = listWeekdays;
	    hooks.parseZone = createInZone;
	    hooks.localeData = getLocale;
	    hooks.isDuration = isDuration;
	    hooks.monthsShort = listMonthsShort;
	    hooks.weekdaysMin = listWeekdaysMin;
	    hooks.defineLocale = defineLocale;
	    hooks.updateLocale = updateLocale;
	    hooks.locales = listLocales;
	    hooks.weekdaysShort = listWeekdaysShort;
	    hooks.normalizeUnits = normalizeUnits;
	    hooks.relativeTimeRounding = getSetRelativeTimeRounding;
	    hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
	    hooks.calendarFormat = getCalendarFormat;
	    hooks.prototype = proto; // currently HTML5 input type only supports 24-hour formats

	    hooks.HTML5_FMT = {
	      DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm',
	      // <input type="datetime-local" />
	      DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss',
	      // <input type="datetime-local" step="1" />
	      DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS',
	      // <input type="datetime-local" step="0.001" />
	      DATE: 'YYYY-MM-DD',
	      // <input type="date" />
	      TIME: 'HH:mm',
	      // <input type="time" />
	      TIME_SECONDS: 'HH:mm:ss',
	      // <input type="time" step="1" />
	      TIME_MS: 'HH:mm:ss.SSS',
	      // <input type="time" step="0.001" />
	      WEEK: 'GGGG-[W]WW',
	      // <input type="week" />
	      MONTH: 'YYYY-MM' // <input type="month" />

	    };
	    return hooks;
	  });
	});

	function ownKeys$2(object, enumerableOnly) { var keys = keys$3(object); if (getOwnPropertySymbols$2) { var symbols = getOwnPropertySymbols$2(object); if (enumerableOnly) symbols = filter$2(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$3(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context28; forEach$2(_context28 = ownKeys$2(Object(source), true)).call(_context28, function (key) { defineProperty$6(target, key, source[key]); }); } else if (getOwnPropertyDescriptors$2) { defineProperties$1(target, getOwnPropertyDescriptors$2(source)); } else { var _context29; forEach$2(_context29 = ownKeys$2(Object(source))).call(_context29, function (key) { defineProperty$3(target, key, getOwnPropertyDescriptor$3(source, key)); }); } } return target; }

	function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }

	function _createForOfIteratorHelper$1(o) { if (typeof symbol$2 === "undefined" || getIteratorMethod$1(o) == null) { if (isArray$5(o) || (o = _unsupportedIterableToArray$2(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = getIterator$1(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$2(o, minLen) { var _context19; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$2(o, minLen); var n = slice$5(_context19 = Object.prototype.toString.call(o)).call(_context19, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from_1$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$2(o, minLen); }

	function _arrayLikeToArray$2(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
	/* eslint @typescript-eslint/member-ordering: ["error", { "classes": ["field", "constructor", "method"] }] */

	/**
	 * Create new data pipe.
	 *
	 * @param from - The source data set or data view.
	 *
	 * @remarks
	 * Example usage:
	 * ```typescript
	 * interface AppItem {
	 *   whoami: string;
	 *   appData: unknown;
	 *   visData: VisItem;
	 * }
	 * interface VisItem {
	 *   id: number;
	 *   label: string;
	 *   color: string;
	 *   x: number;
	 *   y: number;
	 * }
	 *
	 * const ds1 = new DataSet<AppItem, "whoami">([], { fieldId: "whoami" });
	 * const ds2 = new DataSet<VisItem, "id">();
	 *
	 * const pipe = createNewDataPipeFrom(ds1)
	 *   .filter((item): boolean => item.enabled === true)
	 *   .map<VisItem, "id">((item): VisItem => item.visData)
	 *   .to(ds2);
	 *
	 * pipe.start();
	 * ```
	 *
	 * @returns A factory whose methods can be used to configure the pipe.
	 */

	function createNewDataPipeFrom(from) {
	  return new DataPipeUnderConstruction(from);
	}
	/**
	 * Internal implementation of the pipe. This should be accessible only through
	 * `createNewDataPipeFrom` from the outside.
	 *
	 * @typeparam SI - Source item type.
	 * @typeparam SP - Source item type's id property name.
	 * @typeparam TI - Target item type.
	 * @typeparam TP - Target item type's id property name.
	 */


	var SimpleDataPipe = /*#__PURE__*/function () {
	  /**
	   * Create a new data pipe.
	   *
	   * @param _source - The data set or data view that will be observed.
	   * @param _transformers - An array of transforming functions to be used to
	   * filter or transform the items in the pipe.
	   * @param _target - The data set or data view that will receive the items.
	   */
	  function SimpleDataPipe(_source, _transformers, _target) {
	    var _context, _context2, _context3;

	    classCallCheck(this, SimpleDataPipe);

	    this._source = _source;
	    this._transformers = _transformers;
	    this._target = _target;
	    /**
	     * Bound listeners for use with `DataInterface['on' | 'off']`.
	     */

	    this._listeners = {
	      add: bind$2(_context = this._add).call(_context, this),
	      remove: bind$2(_context2 = this._remove).call(_context2, this),
	      update: bind$2(_context3 = this._update).call(_context3, this)
	    };
	  }
	  /** @inheritdoc */


	  createClass(SimpleDataPipe, [{
	    key: "all",
	    value: function all() {
	      this._target.update(this._transformItems(this._source.get()));

	      return this;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "start",
	    value: function start() {
	      this._source.on("add", this._listeners.add);

	      this._source.on("remove", this._listeners.remove);

	      this._source.on("update", this._listeners.update);

	      return this;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "stop",
	    value: function stop() {
	      this._source.off("add", this._listeners.add);

	      this._source.off("remove", this._listeners.remove);

	      this._source.off("update", this._listeners.update);

	      return this;
	    }
	    /**
	     * Apply the transformers to the items.
	     *
	     * @param items - The items to be transformed.
	     *
	     * @returns The transformed items.
	     */

	  }, {
	    key: "_transformItems",
	    value: function _transformItems(items) {
	      var _context4;

	      return reduce$2(_context4 = this._transformers).call(_context4, function (items, transform) {
	        return transform(items);
	      }, items);
	    }
	    /**
	     * Handle an add event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the ids of the added items.
	     */

	  }, {
	    key: "_add",
	    value: function _add(_name, payload) {
	      if (payload == null) {
	        return;
	      }

	      this._target.add(this._transformItems(this._source.get(payload.items)));
	    }
	    /**
	     * Handle an update event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the ids of the updated items.
	     */

	  }, {
	    key: "_update",
	    value: function _update(_name, payload) {
	      if (payload == null) {
	        return;
	      }

	      this._target.update(this._transformItems(this._source.get(payload.items)));
	    }
	    /**
	     * Handle a remove event.
	     *
	     * @param _name - Ignored.
	     * @param payload - The payload containing the data of the removed items.
	     */

	  }, {
	    key: "_remove",
	    value: function _remove(_name, payload) {
	      if (payload == null) {
	        return;
	      }

	      this._target.remove(this._transformItems(payload.oldData));
	    }
	  }]);

	  return SimpleDataPipe;
	}();
	/**
	 * Internal implementation of the pipe factory. This should be accessible
	 * only through `createNewDataPipeFrom` from the outside.
	 *
	 * @typeparam TI - Target item type.
	 * @typeparam TP - Target item type's id property name.
	 */


	var DataPipeUnderConstruction = /*#__PURE__*/function () {
	  /**
	   * Create a new data pipe factory. This is an internal constructor that
	   * should never be called from outside of this file.
	   *
	   * @param _source - The source data set or data view for this pipe.
	   */
	  function DataPipeUnderConstruction(_source) {
	    classCallCheck(this, DataPipeUnderConstruction);

	    this._source = _source;
	    /**
	     * Array transformers used to transform items within the pipe. This is typed
	     * as any for the sake of simplicity.
	     */

	    this._transformers = [];
	  }
	  /**
	   * Filter the items.
	   *
	   * @param callback - A filtering function that returns true if given item
	   * should be piped and false if not.
	   *
	   * @returns This factory for further configuration.
	   */


	  createClass(DataPipeUnderConstruction, [{
	    key: "filter",
	    value: function filter(callback) {
	      this._transformers.push(function (input) {
	        return filter$2(input).call(input, callback);
	      });

	      return this;
	    }
	    /**
	     * Map each source item to a new type.
	     *
	     * @param callback - A mapping function that takes a source item and returns
	     * corresponding mapped item.
	     *
	     * @typeparam TI - Target item type.
	     * @typeparam TP - Target item type's id property name.
	     *
	     * @returns This factory for further configuration.
	     */

	  }, {
	    key: "map",
	    value: function map(callback) {
	      this._transformers.push(function (input) {
	        return map$2(input).call(input, callback);
	      });

	      return this;
	    }
	    /**
	     * Map each source item to zero or more items of a new type.
	     *
	     * @param callback - A mapping function that takes a source item and returns
	     * an array of corresponding mapped items.
	     *
	     * @typeparam TI - Target item type.
	     * @typeparam TP - Target item type's id property name.
	     *
	     * @returns This factory for further configuration.
	     */

	  }, {
	    key: "flatMap",
	    value: function flatMap(callback) {
	      this._transformers.push(function (input) {
	        return flatMap$2(input).call(input, callback);
	      });

	      return this;
	    }
	    /**
	     * Connect this pipe to given data set.
	     *
	     * @param target - The data set that will receive the items from this pipe.
	     *
	     * @returns The pipe connected between given data sets and performing
	     * configured transformation on the processed items.
	     */

	  }, {
	    key: "to",
	    value: function to(target) {
	      return new SimpleDataPipe(this._source, this._transformers, target);
	    }
	  }]);

	  return DataPipeUnderConstruction;
	}(); // utility functions
	// parse ASP.Net Date pattern,
	// for example '/Date(1198908717056)/' or '/Date(1198908717056-0700)/'
	// code from http://momentjs.com/


	var ASPDateRegex$1 = /^\/?Date\((-?\d+)/i;
	/**
	 * Test whether given object is a Moment date.
	 *
	 * @param value - Input value of unknown type.
	 *
	 * @returns True if Moment instance, false otherwise.
	 */

	function isMoment(value) {
	  return moment.isMoment(value);
	}
	/**
	 * Convert an object into another type
	 *
	 * @param object - Value of unknown type.
	 * @param type - Name of the desired type.
	 *
	 * @returns Object in the desired type.
	 * @throws Error
	 */


	function convert(object, type) {
	  var match;

	  if (object === undefined) {
	    return undefined;
	  }

	  if (object === null) {
	    return null;
	  }

	  if (!type) {
	    return object;
	  }

	  if (!(typeof type === "string") && !(type instanceof String)) {
	    throw new Error("Type must be a string");
	  } //noinspection FallthroughInSwitchStatementJS


	  switch (type) {
	    case "boolean":
	    case "Boolean":
	      return Boolean(object);

	    case "number":
	    case "Number":
	      if (isString(object) && !isNaN(Date.parse(object))) {
	        return moment(object).valueOf();
	      } else {
	        // @TODO: I don't think that Number and String constructors are a good idea.
	        // This could also fail if the object doesn't have valueOf method or if it's redefined.
	        // For example: Object.create(null) or { valueOf: 7 }.
	        return Number(object.valueOf());
	      }

	    case "string":
	    case "String":
	      return String(object);

	    case "Date":
	      if (isNumber(object)) {
	        return new Date(object);
	      }

	      if (object instanceof Date) {
	        return new Date(object.valueOf());
	      } else if (isMoment(object)) {
	        return new Date(object.valueOf());
	      }

	      if (isString(object)) {
	        match = ASPDateRegex$1.exec(object);

	        if (match) {
	          // object is an ASP date
	          return new Date(Number(match[1])); // parse number
	        } else {
	          return moment(new Date(object)).toDate(); // parse string
	        }
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type Date");
	      }

	    case "Moment":
	      if (isNumber(object)) {
	        return moment(object);
	      }

	      if (object instanceof Date) {
	        return moment(object.valueOf());
	      } else if (isMoment(object)) {
	        return moment(object);
	      }

	      if (isString(object)) {
	        match = ASPDateRegex$1.exec(object);

	        if (match) {
	          // object is an ASP date
	          return moment(Number(match[1])); // parse number
	        } else {
	          return moment(object); // parse string
	        }
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type Date");
	      }

	    case "ISODate":
	      if (isNumber(object)) {
	        return new Date(object);
	      } else if (object instanceof Date) {
	        return object.toISOString();
	      } else if (isMoment(object)) {
	        return object.toDate().toISOString();
	      } else if (isString(object)) {
	        match = ASPDateRegex$1.exec(object);

	        if (match) {
	          // object is an ASP date
	          return new Date(Number(match[1])).toISOString(); // parse number
	        } else {
	          return moment(object).format(); // ISO 8601
	        }
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type ISODate");
	      }

	    case "ASPDate":
	      if (isNumber(object)) {
	        return "/Date(" + object + ")/";
	      } else if (object instanceof Date || isMoment(object)) {
	        return "/Date(" + object.valueOf() + ")/";
	      } else if (isString(object)) {
	        match = ASPDateRegex$1.exec(object);
	        var value;

	        if (match) {
	          // object is an ASP date
	          value = new Date(Number(match[1])).valueOf(); // parse number
	        } else {
	          value = new Date(object).valueOf(); // parse string
	        }

	        return "/Date(" + value + ")/";
	      } else {
	        throw new Error("Cannot convert object of type " + getType(object) + " to type ASPDate");
	      }

	    default:
	      var never = type;
	      throw new Error("Unknown type ".concat(never));
	  }
	}
	/**
	 * Determine whether a value can be used as an id.
	 *
	 * @param value - Input value of unknown type.
	 *
	 * @returns True if the value is valid id, false otherwise.
	 */


	function isId(value) {
	  return typeof value === "string" || typeof value === "number";
	}
	/* eslint @typescript-eslint/member-ordering: ["error", { "classes": ["field", "constructor", "method"] }] */

	/**
	 * A queue.
	 *
	 * @typeParam T - The type of method names to be replaced by queued versions.
	 */


	var Queue = /*#__PURE__*/function () {
	  /**
	   * Construct a new Queue.
	   *
	   * @param options - Queue configuration.
	   */
	  function Queue(options) {
	    classCallCheck(this, Queue);

	    this._queue = [];
	    this._timeout = null;
	    this._extended = null; // options

	    this.delay = null;
	    this.max = Infinity;
	    this.setOptions(options);
	  }
	  /**
	   * Update the configuration of the queue.
	   *
	   * @param options - Queue configuration.
	   */


	  createClass(Queue, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options && typeof options.delay !== "undefined") {
	        this.delay = options.delay;
	      }

	      if (options && typeof options.max !== "undefined") {
	        this.max = options.max;
	      }

	      this._flushIfNeeded();
	    }
	    /**
	     * Extend an object with queuing functionality.
	     * The object will be extended with a function flush, and the methods provided in options.replace will be replaced with queued ones.
	     *
	     * @param object - The object to be extended.
	     * @param options - Additional options.
	     *
	     * @returns The created queue.
	     */

	  }, {
	    key: "destroy",

	    /**
	     * Destroy the queue. The queue will first flush all queued actions, and in case it has extended an object, will restore the original object.
	     */
	    value: function destroy() {
	      this.flush();

	      if (this._extended) {
	        var object = this._extended.object;
	        var methods = this._extended.methods;

	        for (var i = 0; i < methods.length; i++) {
	          var method = methods[i];

	          if (method.original) {
	            // @TODO: better solution?
	            object[method.name] = method.original;
	          } else {
	            // @TODO: better solution?
	            delete object[method.name];
	          }
	        }

	        this._extended = null;
	      }
	    }
	    /**
	     * Replace a method on an object with a queued version.
	     *
	     * @param object - Object having the method.
	     * @param method - The method name.
	     */

	  }, {
	    key: "replace",
	    value: function replace(object, method) {
	      /* eslint-disable-next-line @typescript-eslint/no-this-alias */
	      var me = this;
	      var original = object[method];

	      if (!original) {
	        throw new Error("Method " + method + " undefined");
	      }

	      object[method] = function () {
	        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	          args[_key] = arguments[_key];
	        }

	        // add this call to the queue
	        me.queue({
	          args: args,
	          fn: original,
	          context: this
	        });
	      };
	    }
	    /**
	     * Queue a call.
	     *
	     * @param entry - The function or entry to be queued.
	     */

	  }, {
	    key: "queue",
	    value: function queue(entry) {
	      if (typeof entry === "function") {
	        this._queue.push({
	          fn: entry
	        });
	      } else {
	        this._queue.push(entry);
	      }

	      this._flushIfNeeded();
	    }
	    /**
	     * Check whether the queue needs to be flushed.
	     */

	  }, {
	    key: "_flushIfNeeded",
	    value: function _flushIfNeeded() {
	      var _this = this;

	      // flush when the maximum is exceeded.
	      if (this._queue.length > this.max) {
	        this.flush();
	      } // flush after a period of inactivity when a delay is configured


	      if (this._timeout != null) {
	        clearTimeout(this._timeout);
	        this._timeout = null;
	      }

	      if (this.queue.length > 0 && typeof this.delay === "number") {
	        this._timeout = setTimeout$2(function () {
	          _this.flush();
	        }, this.delay);
	      }
	    }
	    /**
	     * Flush all queued calls
	     */

	  }, {
	    key: "flush",
	    value: function flush() {
	      var _context5, _context6;

	      forEach$2(_context5 = splice$2(_context6 = this._queue).call(_context6, 0)).call(_context5, function (entry) {
	        entry.fn.apply(entry.context || entry.fn, entry.args || []);
	      });
	    }
	  }], [{
	    key: "extend",
	    value: function extend(object, options) {
	      var queue = new Queue(options);

	      if (object.flush !== undefined) {
	        throw new Error("Target object already has a property flush");
	      }

	      object.flush = function () {
	        queue.flush();
	      };

	      var methods = [{
	        name: "flush",
	        original: undefined
	      }];

	      if (options && options.replace) {
	        for (var i = 0; i < options.replace.length; i++) {
	          var name = options.replace[i];
	          methods.push({
	            name: name,
	            // @TODO: better solution?
	            original: object[name]
	          }); // @TODO: better solution?

	          queue.replace(object, name);
	        }
	      }

	      queue._extended = {
	        object: object,
	        methods: methods
	      };
	      return queue;
	    }
	  }]);

	  return Queue;
	}();
	/* eslint-disable @typescript-eslint/member-ordering */

	/**
	 * [[DataSet]] code that can be reused in [[DataView]] or other similar implementations of [[DataInterface]].
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */


	var DataSetPart = /*#__PURE__*/function () {
	  function DataSetPart() {
	    classCallCheck(this, DataSetPart);

	    this._subscribers = {
	      "*": [],
	      add: [],
	      remove: [],
	      update: []
	    };
	    /**
	     * @deprecated Use on instead (PS: DataView.subscribe === DataView.on).
	     */

	    this.subscribe = DataSetPart.prototype.on;
	    /**
	     * @deprecated Use off instead (PS: DataView.unsubscribe === DataView.off).
	     */

	    this.unsubscribe = DataSetPart.prototype.off;
	  }
	  /**
	   * Trigger an event
	   *
	   * @param event - Event name.
	   * @param payload - Event payload.
	   * @param senderId - Id of the sender.
	   */


	  createClass(DataSetPart, [{
	    key: "_trigger",
	    value: function _trigger(event, payload, senderId) {
	      var _context7, _context8;

	      if (event === "*") {
	        throw new Error("Cannot trigger event *");
	      }

	      forEach$2(_context7 = concat$2(_context8 = []).call(_context8, toConsumableArray(this._subscribers[event]), toConsumableArray(this._subscribers["*"]))).call(_context7, function (subscriber) {
	        subscriber(event, payload, senderId != null ? senderId : null);
	      });
	    }
	    /**
	     * Subscribe to an event, add an event listener.
	     *
	     * @remarks Non-function callbacks are ignored.
	     *
	     * @param event - Event name.
	     * @param callback - Callback method.
	     */

	  }, {
	    key: "on",
	    value: function on(event, callback) {
	      if (typeof callback === "function") {
	        this._subscribers[event].push(callback);
	      } // @TODO: Maybe throw for invalid callbacks?

	    }
	    /**
	     * Unsubscribe from an event, remove an event listener.
	     *
	     * @remarks If the same callback was subscribed more than once **all** occurences will be removed.
	     *
	     * @param event - Event name.
	     * @param callback - Callback method.
	     */

	  }, {
	    key: "off",
	    value: function off(event, callback) {
	      var _context9;

	      this._subscribers[event] = filter$2(_context9 = this._subscribers[event]).call(_context9, function (subscriber) {
	        return subscriber !== callback;
	      });
	    }
	  }]);

	  return DataSetPart;
	}();
	/**
	 * Data stream
	 *
	 * @remarks
	 * [[DataStream]] offers an always up to date stream of items from a [[DataSet]] or [[DataView]].
	 * That means that the stream is evaluated at the time of iteration, conversion to another data type or when [[cache]] is called, not when the [[DataStream]] was created.
	 * Multiple invocations of for example [[toItemArray]] may yield different results (if the data source like for example [[DataSet]] gets modified).
	 *
	 * @typeparam Item - The item type this stream is going to work with.
	 */


	var DataStream = /*#__PURE__*/function () {
	  /**
	   * Create a new data stream.
	   *
	   * @param _pairs - The id, item pairs.
	   */
	  function DataStream(_pairs) {
	    classCallCheck(this, DataStream);

	    this._pairs = _pairs;
	  }
	  /**
	   * Return an iterable of key, value pairs for every entry in the stream.
	   */


	  createClass(DataStream, [{
	    key: iterator$4,
	    value: /*#__PURE__*/regenerator.mark(function value() {
	      var _iterator, _step, _step$value, id, item;

	      return regenerator.wrap(function value$(_context10) {
	        while (1) {
	          switch (_context10.prev = _context10.next) {
	            case 0:
	              _iterator = _createForOfIteratorHelper$1(this._pairs);
	              _context10.prev = 1;

	              _iterator.s();

	            case 3:
	              if ((_step = _iterator.n()).done) {
	                _context10.next = 9;
	                break;
	              }

	              _step$value = slicedToArray(_step.value, 2), id = _step$value[0], item = _step$value[1];
	              _context10.next = 7;
	              return [id, item];

	            case 7:
	              _context10.next = 3;
	              break;

	            case 9:
	              _context10.next = 14;
	              break;

	            case 11:
	              _context10.prev = 11;
	              _context10.t0 = _context10["catch"](1);

	              _iterator.e(_context10.t0);

	            case 14:
	              _context10.prev = 14;

	              _iterator.f();

	              return _context10.finish(14);

	            case 17:
	            case "end":
	              return _context10.stop();
	          }
	        }
	      }, value, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of key, value pairs for every entry in the stream.
	     */

	  }, {
	    key: "entries",
	    value: /*#__PURE__*/regenerator.mark(function entries() {
	      var _iterator2, _step2, _step2$value, id, item;

	      return regenerator.wrap(function entries$(_context11) {
	        while (1) {
	          switch (_context11.prev = _context11.next) {
	            case 0:
	              _iterator2 = _createForOfIteratorHelper$1(this._pairs);
	              _context11.prev = 1;

	              _iterator2.s();

	            case 3:
	              if ((_step2 = _iterator2.n()).done) {
	                _context11.next = 9;
	                break;
	              }

	              _step2$value = slicedToArray(_step2.value, 2), id = _step2$value[0], item = _step2$value[1];
	              _context11.next = 7;
	              return [id, item];

	            case 7:
	              _context11.next = 3;
	              break;

	            case 9:
	              _context11.next = 14;
	              break;

	            case 11:
	              _context11.prev = 11;
	              _context11.t0 = _context11["catch"](1);

	              _iterator2.e(_context11.t0);

	            case 14:
	              _context11.prev = 14;

	              _iterator2.f();

	              return _context11.finish(14);

	            case 17:
	            case "end":
	              return _context11.stop();
	          }
	        }
	      }, entries, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of keys in the stream.
	     */

	  }, {
	    key: "keys",
	    value: /*#__PURE__*/regenerator.mark(function keys() {
	      var _iterator3, _step3, _step3$value, id;

	      return regenerator.wrap(function keys$(_context12) {
	        while (1) {
	          switch (_context12.prev = _context12.next) {
	            case 0:
	              _iterator3 = _createForOfIteratorHelper$1(this._pairs);
	              _context12.prev = 1;

	              _iterator3.s();

	            case 3:
	              if ((_step3 = _iterator3.n()).done) {
	                _context12.next = 9;
	                break;
	              }

	              _step3$value = slicedToArray(_step3.value, 1), id = _step3$value[0];
	              _context12.next = 7;
	              return id;

	            case 7:
	              _context12.next = 3;
	              break;

	            case 9:
	              _context12.next = 14;
	              break;

	            case 11:
	              _context12.prev = 11;
	              _context12.t0 = _context12["catch"](1);

	              _iterator3.e(_context12.t0);

	            case 14:
	              _context12.prev = 14;

	              _iterator3.f();

	              return _context12.finish(14);

	            case 17:
	            case "end":
	              return _context12.stop();
	          }
	        }
	      }, keys, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an iterable of values in the stream.
	     */

	  }, {
	    key: "values",
	    value: /*#__PURE__*/regenerator.mark(function values() {
	      var _iterator4, _step4, _step4$value, item;

	      return regenerator.wrap(function values$(_context13) {
	        while (1) {
	          switch (_context13.prev = _context13.next) {
	            case 0:
	              _iterator4 = _createForOfIteratorHelper$1(this._pairs);
	              _context13.prev = 1;

	              _iterator4.s();

	            case 3:
	              if ((_step4 = _iterator4.n()).done) {
	                _context13.next = 9;
	                break;
	              }

	              _step4$value = slicedToArray(_step4.value, 2), item = _step4$value[1];
	              _context13.next = 7;
	              return item;

	            case 7:
	              _context13.next = 3;
	              break;

	            case 9:
	              _context13.next = 14;
	              break;

	            case 11:
	              _context13.prev = 11;
	              _context13.t0 = _context13["catch"](1);

	              _iterator4.e(_context13.t0);

	            case 14:
	              _context13.prev = 14;

	              _iterator4.f();

	              return _context13.finish(14);

	            case 17:
	            case "end":
	              return _context13.stop();
	          }
	        }
	      }, values, this, [[1, 11, 14, 17]]);
	    })
	    /**
	     * Return an array containing all the ids in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     *
	     * @returns The array with all ids from this stream.
	     */

	  }, {
	    key: "toIdArray",
	    value: function toIdArray() {
	      var _context14;

	      return map$2(_context14 = toConsumableArray(this._pairs)).call(_context14, function (pair) {
	        return pair[0];
	      });
	    }
	    /**
	     * Return an array containing all the items in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     *
	     * @returns The array with all items from this stream.
	     */

	  }, {
	    key: "toItemArray",
	    value: function toItemArray() {
	      var _context15;

	      return map$2(_context15 = toConsumableArray(this._pairs)).call(_context15, function (pair) {
	        return pair[1];
	      });
	    }
	    /**
	     * Return an array containing all the entries in this stream.
	     *
	     * @remarks
	     * The array may contain duplicities.
	     *
	     * @returns The array with all entries from this stream.
	     */

	  }, {
	    key: "toEntryArray",
	    value: function toEntryArray() {
	      return toConsumableArray(this._pairs);
	    }
	    /**
	     * Return an object map containing all the items in this stream accessible by ids.
	     *
	     * @remarks
	     * In case of duplicate ids (coerced to string so `7 == '7'`) the last encoutered appears in the returned object.
	     *
	     * @returns The object map of all id → item pairs from this stream.
	     */

	  }, {
	    key: "toObjectMap",
	    value: function toObjectMap() {
	      var map = create$2(null);

	      var _iterator5 = _createForOfIteratorHelper$1(this._pairs),
	          _step5;

	      try {
	        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
	          var _step5$value = slicedToArray(_step5.value, 2),
	              id = _step5$value[0],
	              item = _step5$value[1];

	          map[id] = item;
	        }
	      } catch (err) {
	        _iterator5.e(err);
	      } finally {
	        _iterator5.f();
	      }

	      return map;
	    }
	    /**
	     * Return a map containing all the items in this stream accessible by ids.
	     *
	     * @returns The map of all id → item pairs from this stream.
	     */

	  }, {
	    key: "toMap",
	    value: function toMap() {
	      return new map$5(this._pairs);
	    }
	    /**
	     * Return a set containing all the (unique) ids in this stream.
	     *
	     * @returns The set of all ids from this stream.
	     */

	  }, {
	    key: "toIdSet",
	    value: function toIdSet() {
	      return new set$3(this.toIdArray());
	    }
	    /**
	     * Return a set containing all the (unique) items in this stream.
	     *
	     * @returns The set of all items from this stream.
	     */

	  }, {
	    key: "toItemSet",
	    value: function toItemSet() {
	      return new set$3(this.toItemArray());
	    }
	    /**
	     * Cache the items from this stream.
	     *
	     * @remarks
	     * This method allows for items to be fetched immediatelly and used (possibly multiple times) later.
	     * It can also be used to optimize performance as [[DataStream]] would otherwise reevaluate everything upon each iteration.
	     *
	     * ## Example
	     * ```javascript
	     * const ds = new DataSet([…])
	     *
	     * const cachedStream = ds.stream()
	     *   .filter(…)
	     *   .sort(…)
	     *   .map(…)
	     *   .cached(…) // Data are fetched, processed and cached here.
	     *
	     * ds.clear()
	     * chachedStream // Still has all the items.
	     * ```
	     *
	     * @returns A new [[DataStream]] with cached items (detached from the original [[DataSet]]).
	     */

	  }, {
	    key: "cache",
	    value: function cache() {
	      return new DataStream(toConsumableArray(this._pairs));
	    }
	    /**
	     * Get the distinct values of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     *
	     * @typeparam T - The type of the distinct value.
	     *
	     * @returns A set of all distinct properties.
	     */

	  }, {
	    key: "distinct",
	    value: function distinct(callback) {
	      var set = new set$3();

	      var _iterator6 = _createForOfIteratorHelper$1(this._pairs),
	          _step6;

	      try {
	        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
	          var _step6$value = slicedToArray(_step6.value, 2),
	              id = _step6$value[0],
	              item = _step6$value[1];

	          set.add(callback(item, id));
	        }
	      } catch (err) {
	        _iterator6.e(err);
	      } finally {
	        _iterator6.f();
	      }

	      return set;
	    }
	    /**
	     * Filter the items of the stream.
	     *
	     * @param callback - The function that decides whether an item will be included.
	     *
	     * @returns A new data stream with the filtered items.
	     */

	  }, {
	    key: "filter",
	    value: function filter(callback) {
	      var pairs = this._pairs;
	      return new DataStream(defineProperty$6({}, iterator$4, /*#__PURE__*/regenerator.mark(function _callee() {
	        var _iterator7, _step7, _step7$value, id, item;

	        return regenerator.wrap(function _callee$(_context16) {
	          while (1) {
	            switch (_context16.prev = _context16.next) {
	              case 0:
	                _iterator7 = _createForOfIteratorHelper$1(pairs);
	                _context16.prev = 1;

	                _iterator7.s();

	              case 3:
	                if ((_step7 = _iterator7.n()).done) {
	                  _context16.next = 10;
	                  break;
	                }

	                _step7$value = slicedToArray(_step7.value, 2), id = _step7$value[0], item = _step7$value[1];

	                if (!callback(item, id)) {
	                  _context16.next = 8;
	                  break;
	                }

	                _context16.next = 8;
	                return [id, item];

	              case 8:
	                _context16.next = 3;
	                break;

	              case 10:
	                _context16.next = 15;
	                break;

	              case 12:
	                _context16.prev = 12;
	                _context16.t0 = _context16["catch"](1);

	                _iterator7.e(_context16.t0);

	              case 15:
	                _context16.prev = 15;

	                _iterator7.f();

	                return _context16.finish(15);

	              case 18:
	              case "end":
	                return _context16.stop();
	            }
	          }
	        }, _callee, null, [[1, 12, 15, 18]]);
	      })));
	    }
	    /**
	     * Execute a callback for each item of the stream.
	     *
	     * @param callback - The function that will be invoked for each item.
	     */

	  }, {
	    key: "forEach",
	    value: function forEach(callback) {
	      var _iterator8 = _createForOfIteratorHelper$1(this._pairs),
	          _step8;

	      try {
	        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
	          var _step8$value = slicedToArray(_step8.value, 2),
	              id = _step8$value[0],
	              item = _step8$value[1];

	          callback(item, id);
	        }
	      } catch (err) {
	        _iterator8.e(err);
	      } finally {
	        _iterator8.f();
	      }
	    }
	    /**
	     * Map the items into a different type.
	     *
	     * @param callback - The function that does the conversion.
	     *
	     * @typeparam Mapped - The type of the item after mapping.
	     *
	     * @returns A new data stream with the mapped items.
	     */

	  }, {
	    key: "map",
	    value: function map(callback) {
	      var pairs = this._pairs;
	      return new DataStream(defineProperty$6({}, iterator$4, /*#__PURE__*/regenerator.mark(function _callee2() {
	        var _iterator9, _step9, _step9$value, id, item;

	        return regenerator.wrap(function _callee2$(_context17) {
	          while (1) {
	            switch (_context17.prev = _context17.next) {
	              case 0:
	                _iterator9 = _createForOfIteratorHelper$1(pairs);
	                _context17.prev = 1;

	                _iterator9.s();

	              case 3:
	                if ((_step9 = _iterator9.n()).done) {
	                  _context17.next = 9;
	                  break;
	                }

	                _step9$value = slicedToArray(_step9.value, 2), id = _step9$value[0], item = _step9$value[1];
	                _context17.next = 7;
	                return [id, callback(item, id)];

	              case 7:
	                _context17.next = 3;
	                break;

	              case 9:
	                _context17.next = 14;
	                break;

	              case 11:
	                _context17.prev = 11;
	                _context17.t0 = _context17["catch"](1);

	                _iterator9.e(_context17.t0);

	              case 14:
	                _context17.prev = 14;

	                _iterator9.f();

	                return _context17.finish(14);

	              case 17:
	              case "end":
	                return _context17.stop();
	            }
	          }
	        }, _callee2, null, [[1, 11, 14, 17]]);
	      })));
	    }
	    /**
	     * Get the item with the maximum value of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     *
	     * @returns The item with the maximum if found otherwise null.
	     */

	  }, {
	    key: "max",
	    value: function max(callback) {
	      var iter = getIterator$1(this._pairs);

	      var curr = iter.next();

	      if (curr.done) {
	        return null;
	      }

	      var maxItem = curr.value[1];
	      var maxValue = callback(curr.value[1], curr.value[0]);

	      while (!(curr = iter.next()).done) {
	        var _curr$value = slicedToArray(curr.value, 2),
	            id = _curr$value[0],
	            item = _curr$value[1];

	        var _value = callback(item, id);

	        if (_value > maxValue) {
	          maxValue = _value;
	          maxItem = item;
	        }
	      }

	      return maxItem;
	    }
	    /**
	     * Get the item with the minimum value of given property.
	     *
	     * @param callback - The function that picks and possibly converts the property.
	     *
	     * @returns The item with the minimum if found otherwise null.
	     */

	  }, {
	    key: "min",
	    value: function min(callback) {
	      var iter = getIterator$1(this._pairs);

	      var curr = iter.next();

	      if (curr.done) {
	        return null;
	      }

	      var minItem = curr.value[1];
	      var minValue = callback(curr.value[1], curr.value[0]);

	      while (!(curr = iter.next()).done) {
	        var _curr$value2 = slicedToArray(curr.value, 2),
	            id = _curr$value2[0],
	            item = _curr$value2[1];

	        var _value2 = callback(item, id);

	        if (_value2 < minValue) {
	          minValue = _value2;
	          minItem = item;
	        }
	      }

	      return minItem;
	    }
	    /**
	     * Reduce the items into a single value.
	     *
	     * @param callback - The function that does the reduction.
	     * @param accumulator - The initial value of the accumulator.
	     *
	     * @typeparam T - The type of the accumulated value.
	     *
	     * @returns The reduced value.
	     */

	  }, {
	    key: "reduce",
	    value: function reduce(callback, accumulator) {
	      var _iterator10 = _createForOfIteratorHelper$1(this._pairs),
	          _step10;

	      try {
	        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
	          var _step10$value = slicedToArray(_step10.value, 2),
	              id = _step10$value[0],
	              item = _step10$value[1];

	          accumulator = callback(accumulator, item, id);
	        }
	      } catch (err) {
	        _iterator10.e(err);
	      } finally {
	        _iterator10.f();
	      }

	      return accumulator;
	    }
	    /**
	     * Sort the items.
	     *
	     * @param callback - Item comparator.
	     *
	     * @returns A new stream with sorted items.
	     */

	  }, {
	    key: "sort",
	    value: function sort(callback) {
	      var _this2 = this;

	      return new DataStream(defineProperty$6({}, iterator$4, function () {
	        var _context18;

	        return getIterator$1(sort$2(_context18 = toConsumableArray(_this2._pairs)).call(_context18, function (_ref, _ref2) {
	          var _ref3 = slicedToArray(_ref, 2),
	              idA = _ref3[0],
	              itemA = _ref3[1];

	          var _ref4 = slicedToArray(_ref2, 2),
	              idB = _ref4[0],
	              itemB = _ref4[1];

	          return callback(itemA, itemB, idA, idB);
	        }));
	      }));
	    }
	  }]);

	  return DataStream;
	}();
	/* eslint @typescript-eslint/member-ordering: ["error", { "classes": ["field", "constructor", "method"] }] */


	var warnTypeCorectionDeprecation = function warnTypeCorectionDeprecation() {
	  console.warn("Type coercion has been deprecated. " + "Please, use data pipes instead. " + "See https://visjs.github.io/vis-data/data/datapipe.html#TypeCoercion for more details with working migration example.");
	};
	/**
	 * # DataSet
	 *
	 * Vis.js comes with a flexible DataSet, which can be used to hold and manipulate unstructured data and listen for changes in the data. The DataSet is key/value based. Data items can be added, updated and removed from the DataSet, and one can subscribe to changes in the DataSet. The data in the DataSet can be filtered and ordered, and fields (like dates) can be converted to a specific type. Data can be normalized when appending it to the DataSet as well.
	 *
	 * ## Example
	 *
	 * The following example shows how to use a DataSet.
	 *
	 * ```javascript
	 * // create a DataSet
	 * var options = {};
	 * var data = new vis.DataSet(options);
	 *
	 * // add items
	 * // note that the data items can contain different properties and data formats
	 * data.add([
	 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
	 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
	 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
	 *   {id: 4, text: 'item 4'}
	 * ]);
	 *
	 * // subscribe to any change in the DataSet
	 * data.on('*', function (event, properties, senderId) {
	 *   console.log('event', event, properties);
	 * });
	 *
	 * // update an existing item
	 * data.update({id: 2, group: 1});
	 *
	 * // remove an item
	 * data.remove(4);
	 *
	 * // get all ids
	 * var ids = data.getIds();
	 * console.log('ids', ids);
	 *
	 * // get a specific item
	 * var item1 = data.get(1);
	 * console.log('item1', item1);
	 *
	 * // retrieve a filtered subset of the data
	 * var items = data.get({
	 *   filter: function (item) {
	 *     return item.group == 1;
	 *   }
	 * });
	 * console.log('filtered items', items);
	 * ```
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */


	var DataSet = /*#__PURE__*/function (_DataSetPart) {
	  inherits(DataSet, _DataSetPart);

	  var _super = _createSuper(DataSet);

	  /**
	   * Construct a new DataSet.
	   *
	   * @param data - Initial data or options.
	   * @param options - Options (type error if data is also options).
	   */
	  function DataSet(data, options) {
	    var _this3;

	    classCallCheck(this, DataSet);

	    _this3 = _super.call(this); // correctly read optional arguments

	    if (data && !isArray$5(data)) {
	      options = data;
	      data = [];
	    }

	    _this3._options = options || {};
	    _this3._data = new map$5(); // map with data indexed by id

	    _this3.length = 0; // number of items in the DataSet

	    _this3._idProp = _this3._options.fieldId || "id"; // name of the field containing id

	    _this3._type = {}; // internal field types (NOTE: this can differ from this._options.type)
	    // all variants of a Date are internally stored as Date, so we can convert
	    // from everything to everything (also from ISODate to Number for example)

	    if (_this3._options.type) {
	      warnTypeCorectionDeprecation();

	      var fields = keys$3(_this3._options.type);

	      for (var i = 0, len = fields.length; i < len; i++) {
	        var field = fields[i];
	        var _value3 = _this3._options.type[field];

	        if (_value3 == "Date" || _value3 == "ISODate" || _value3 == "ASPDate") {
	          _this3._type[field] = "Date";
	        } else {
	          _this3._type[field] = _value3;
	        }
	      }
	    } // add initial data when provided


	    if (data && data.length) {
	      _this3.add(data);
	    }

	    _this3.setOptions(options);

	    return _this3;
	  }
	  /**
	   * Set new options.
	   *
	   * @param options - The new options.
	   */


	  createClass(DataSet, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options && options.queue !== undefined) {
	        if (options.queue === false) {
	          // delete queue if loaded
	          if (this._queue) {
	            this._queue.destroy();

	            delete this._queue;
	          }
	        } else {
	          // create queue and update its options
	          if (!this._queue) {
	            this._queue = Queue.extend(this, {
	              replace: ["add", "update", "remove"]
	            });
	          }

	          if (options.queue && _typeof_1(options.queue) === "object") {
	            this._queue.setOptions(options.queue);
	          }
	        }
	      }
	    }
	    /**
	     * Add a data item or an array with items.
	     *
	     * After the items are added to the DataSet, the DataSet will trigger an event `add`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet()
	     *
	     * // add items
	     * const ids = data.add([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { text: 'item without an id' }
	     * ])
	     *
	     * console.log(ids) // [1, 2, '<UUIDv4>']
	     * ```
	     *
	     * @param data - Items to be added (ids will be generated if missing).
	     * @param senderId - Sender id.
	     *
	     * @returns addedIds - Array with the ids (generated if not present) of the added items.
	     *
	     * @throws When an item with the same id as any of the added items already exists.
	     */

	  }, {
	    key: "add",
	    value: function add(data, senderId) {
	      var _this4 = this;

	      var addedIds = [];
	      var id;

	      if (isArray$5(data)) {
	        // Array
	        var idsToAdd = map$2(data).call(data, function (d) {
	          return d[_this4._idProp];
	        });

	        if (some$2(idsToAdd).call(idsToAdd, function (id) {
	          return _this4._data.has(id);
	        })) {
	          throw new Error("A duplicate id was found in the parameter array.");
	        }

	        for (var i = 0, len = data.length; i < len; i++) {
	          id = this._addItem(data[i]);
	          addedIds.push(id);
	        }
	      } else if (data && _typeof_1(data) === "object") {
	        // Single item
	        id = this._addItem(data);
	        addedIds.push(id);
	      } else {
	        throw new Error("Unknown dataType");
	      }

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }

	      return addedIds;
	    }
	    /**
	     * Update existing items. When an item does not exist, it will be created.
	     *
	     * @remarks
	     * The provided properties will be merged in the existing item. When an item does not exist, it will be created.
	     *
	     * After the items are updated, the DataSet will trigger an event `add` for the added items, and an event `update`. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' }
	     * ])
	     *
	     * // update items
	     * const ids = data.update([
	     *   { id: 2, text: 'item 2 (updated)' },
	     *   { id: 4, text: 'item 4 (new)' }
	     * ])
	     *
	     * console.log(ids) // [2, 4]
	     * ```
	     *
	     * ## Warning for TypeScript users
	     * This method may introduce partial items into the data set. Use add or updateOnly instead for better type safety.
	     *
	     * @param data - Items to be updated (if the id is already present) or added (if the id is missing).
	     * @param senderId - Sender id.
	     *
	     * @returns updatedIds - The ids of the added (these may be newly generated if there was no id in the item from the data) or updated items.
	     *
	     * @throws When the supplied data is neither an item nor an array of items.
	     */

	  }, {
	    key: "update",
	    value: function update(data, senderId) {
	      var _this5 = this;

	      var addedIds = [];
	      var updatedIds = [];
	      var oldData = [];
	      var updatedData = [];
	      var idProp = this._idProp;

	      var addOrUpdate = function addOrUpdate(item) {
	        var origId = item[idProp];

	        if (origId != null && _this5._data.has(origId)) {
	          var fullItem = item; // it has an id, therefore it is a fullitem

	          var oldItem = assign$2({}, _this5._data.get(origId)); // update item


	          var id = _this5._updateItem(fullItem);

	          updatedIds.push(id);
	          updatedData.push(fullItem);
	          oldData.push(oldItem);
	        } else {
	          // add new item
	          var _id = _this5._addItem(item);

	          addedIds.push(_id);
	        }
	      };

	      if (isArray$5(data)) {
	        // Array
	        for (var i = 0, len = data.length; i < len; i++) {
	          if (data[i] && _typeof_1(data[i]) === "object") {
	            addOrUpdate(data[i]);
	          } else {
	            console.warn("Ignoring input item, which is not an object at index " + i);
	          }
	        }
	      } else if (data && _typeof_1(data) === "object") {
	        // Single item
	        addOrUpdate(data);
	      } else {
	        throw new Error("Unknown dataType");
	      }

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }

	      if (updatedIds.length) {
	        var props = {
	          items: updatedIds,
	          oldData: oldData,
	          data: updatedData
	        }; // TODO: remove deprecated property 'data' some day
	        //Object.defineProperty(props, 'data', {
	        //  'get': (function() {
	        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
	        //    return updatedData;
	        //  }).bind(this)
	        //});

	        this._trigger("update", props, senderId);
	      }

	      return concat$2(addedIds).call(addedIds, updatedIds);
	    }
	    /**
	     * Update existing items. When an item does not exist, an error will be thrown.
	     *
	     * @remarks
	     * The provided properties will be deeply merged into the existing item.
	     * When an item does not exist (id not present in the data set or absent), an error will be thrown and nothing will be changed.
	     *
	     * After the items are updated, the DataSet will trigger an event `update`.
	     * When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     *
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' },
	     * ])
	     *
	     * // update items
	     * const ids = data.update([
	     *   { id: 2, text: 'item 2 (updated)' }, // works
	     *   // { id: 4, text: 'item 4 (new)' }, // would throw
	     *   // { text: 'item 4 (new)' }, // would also throw
	     * ])
	     *
	     * console.log(ids) // [2]
	     * ```
	     *
	     * @param data - Updates (the id and optionally other props) to the items in this data set.
	     * @param senderId - Sender id.
	     *
	     * @returns updatedIds - The ids of the updated items.
	     *
	     * @throws When the supplied data is neither an item nor an array of items, when the ids are missing.
	     */

	  }, {
	    key: "updateOnly",
	    value: function updateOnly(data, senderId) {
	      var _context20,
	          _this6 = this;

	      if (!isArray$5(data)) {
	        data = [data];
	      }

	      var updateEventData = map$2(_context20 = map$2(data).call(data, function (update) {
	        var oldData = _this6._data.get(update[_this6._idProp]);

	        if (oldData == null) {
	          throw new Error("Updating non-existent items is not allowed.");
	        }

	        return {
	          oldData: oldData,
	          update: update
	        };
	      })).call(_context20, function (_ref5) {
	        var oldData = _ref5.oldData,
	            update = _ref5.update;
	        var id = oldData[_this6._idProp];
	        var updatedData = deepExtend(deepExtend({}, oldData), update);

	        _this6._data.set(id, updatedData);

	        return {
	          id: id,
	          oldData: oldData,
	          updatedData: updatedData
	        };
	      });

	      if (updateEventData.length) {
	        var props = {
	          items: map$2(updateEventData).call(updateEventData, function (value) {
	            return value.id;
	          }),
	          oldData: map$2(updateEventData).call(updateEventData, function (value) {
	            return value.oldData;
	          }),
	          data: map$2(updateEventData).call(updateEventData, function (value) {
	            return value.updatedData;
	          })
	        }; // TODO: remove deprecated property 'data' some day
	        //Object.defineProperty(props, 'data', {
	        //  'get': (function() {
	        //    console.warn('Property data is deprecated. Use DataSet.get(ids) to retrieve the new data, use the oldData property on this object to get the old data');
	        //    return updatedData;
	        //  }).bind(this)
	        //});

	        this._trigger("update", props, senderId);

	        return props.items;
	      } else {
	        return [];
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "get",
	    value: function get(first, second) {
	      // @TODO: Woudn't it be better to split this into multiple methods?
	      // parse the arguments
	      var id = undefined;
	      var ids = undefined;
	      var options = undefined;

	      if (isId(first)) {
	        // get(id [, options])
	        id = first;
	        options = second;
	      } else if (isArray$5(first)) {
	        // get(ids [, options])
	        ids = first;
	        options = second;
	      } else {
	        // get([, options])
	        options = first;
	      } // determine the return type


	      var returnType = options && options.returnType === "Object" ? "Object" : "Array"; // @TODO: WTF is this? Or am I missing something?
	      // var returnType
	      // if (options && options.returnType) {
	      //   var allowedValues = ['Array', 'Object']
	      //   returnType =
	      //     allowedValues.indexOf(options.returnType) == -1
	      //       ? 'Array'
	      //       : options.returnType
	      // } else {
	      //   returnType = 'Array'
	      // }
	      // build options

	      var type = options && options.type || this._options.type;

	      var filter = options && filter$2(options);

	      var items = [];
	      var item = null;
	      var itemIds = null;
	      var itemId = null; // convert items

	      if (id != null) {
	        // return a single item
	        item = this._getItem(id, type);

	        if (item && filter && !filter(item)) {
	          item = null;
	        }
	      } else if (ids != null) {
	        // return a subset of items
	        for (var i = 0, len = ids.length; i < len; i++) {
	          item = this._getItem(ids[i], type);

	          if (item != null && (!filter || filter(item))) {
	            items.push(item);
	          }
	        }
	      } else {
	        var _context21;

	        // return all items
	        itemIds = toConsumableArray(keys$6(_context21 = this._data).call(_context21));

	        for (var _i = 0, _len2 = itemIds.length; _i < _len2; _i++) {
	          itemId = itemIds[_i];
	          item = this._getItem(itemId, type);

	          if (item != null && (!filter || filter(item))) {
	            items.push(item);
	          }
	        }
	      } // order the results


	      if (options && options.order && id == undefined) {
	        this._sort(items, options.order);
	      } // filter fields of the items


	      if (options && options.fields) {
	        var fields = options.fields;

	        if (id != undefined && item != null) {
	          item = this._filterFields(item, fields);
	        } else {
	          for (var _i2 = 0, _len3 = items.length; _i2 < _len3; _i2++) {
	            items[_i2] = this._filterFields(items[_i2], fields);
	          }
	        }
	      } // return the results


	      if (returnType == "Object") {
	        var result = {};

	        for (var _i3 = 0, _len4 = items.length; _i3 < _len4; _i3++) {
	          var resultant = items[_i3]; // @TODO: Shoudn't this be this._fieldId?
	          // result[resultant.id] = resultant

	          var _id2 = resultant[this._idProp];
	          result[_id2] = resultant;
	        }

	        return result;
	      } else {
	        if (id != null) {
	          // a single item
	          return item;
	        } else {
	          // just return our array
	          return items;
	        }
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getIds",
	    value: function getIds(options) {
	      var data = this._data;

	      var filter = options && filter$2(options);

	      var order = options && options.order;
	      var type = options && options.type || this._options.type;

	      var itemIds = toConsumableArray(keys$6(data).call(data));

	      var ids = [];
	      var item;
	      var items;

	      if (filter) {
	        // get filtered items
	        if (order) {
	          // create ordered list
	          items = [];

	          for (var i = 0, len = itemIds.length; i < len; i++) {
	            var id = itemIds[i];
	            item = this._getItem(id, type);

	            if (filter(item)) {
	              items.push(item);
	            }
	          }

	          this._sort(items, order);

	          for (var _i4 = 0, _len5 = items.length; _i4 < _len5; _i4++) {
	            ids.push(items[_i4][this._idProp]);
	          }
	        } else {
	          // create unordered list
	          for (var _i5 = 0, _len6 = itemIds.length; _i5 < _len6; _i5++) {
	            var _id3 = itemIds[_i5];
	            item = this._getItem(_id3, type);

	            if (filter(item)) {
	              ids.push(item[this._idProp]);
	            }
	          }
	        }
	      } else {
	        // get all items
	        if (order) {
	          // create an ordered list
	          items = [];

	          for (var _i6 = 0, _len7 = itemIds.length; _i6 < _len7; _i6++) {
	            var _id4 = itemIds[_i6];
	            items.push(data.get(_id4));
	          }

	          this._sort(items, order);

	          for (var _i7 = 0, _len8 = items.length; _i7 < _len8; _i7++) {
	            ids.push(items[_i7][this._idProp]);
	          }
	        } else {
	          // create unordered list
	          for (var _i8 = 0, _len9 = itemIds.length; _i8 < _len9; _i8++) {
	            var _id5 = itemIds[_i8];
	            item = data.get(_id5);
	            ids.push(item[this._idProp]);
	          }
	        }
	      }

	      return ids;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getDataSet",
	    value: function getDataSet() {
	      return this;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "forEach",
	    value: function forEach(callback, options) {
	      var filter = options && filter$2(options);

	      var type = options && options.type || this._options.type;
	      var data = this._data;

	      var itemIds = toConsumableArray(keys$6(data).call(data));

	      if (options && options.order) {
	        // execute forEach on ordered list
	        var items = this.get(options);

	        for (var i = 0, len = items.length; i < len; i++) {
	          var item = items[i];
	          var id = item[this._idProp];
	          callback(item, id);
	        }
	      } else {
	        // unordered
	        for (var _i9 = 0, _len10 = itemIds.length; _i9 < _len10; _i9++) {
	          var _id6 = itemIds[_i9];

	          var _item = this._getItem(_id6, type);

	          if (!filter || filter(_item)) {
	            callback(_item, _id6);
	          }
	        }
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "map",
	    value: function map(callback, options) {
	      var filter = options && filter$2(options);

	      var type = options && options.type || this._options.type;
	      var mappedItems = [];
	      var data = this._data;

	      var itemIds = toConsumableArray(keys$6(data).call(data)); // convert and filter items


	      for (var i = 0, len = itemIds.length; i < len; i++) {
	        var id = itemIds[i];

	        var item = this._getItem(id, type);

	        if (!filter || filter(item)) {
	          mappedItems.push(callback(item, id));
	        }
	      } // order items


	      if (options && options.order) {
	        this._sort(mappedItems, options.order);
	      }

	      return mappedItems;
	    }
	    /**
	     * Filter the fields of an item.
	     *
	     * @param item - The item whose fields should be filtered.
	     * @param fields - The names of the fields that will be kept.
	     *
	     * @typeParam K - Field name type.
	     *
	     * @returns The item without any additional fields.
	     */

	  }, {
	    key: "_filterFields",
	    value: function _filterFields(item, fields) {
	      var _context22;

	      if (!item) {
	        // item is null
	        return item;
	      }

	      return reduce$2(_context22 = isArray$5(fields) ? // Use the supplied array
	      fields : // Use the keys of the supplied object
	      keys$3(fields)).call(_context22, function (filteredItem, field) {
	        filteredItem[field] = item[field];
	        return filteredItem;
	      }, {});
	    }
	    /**
	     * Sort the provided array with items.
	     *
	     * @param items - Items to be sorted in place.
	     * @param order - A field name or custom sort function.
	     *
	     * @typeParam T - The type of the items in the items array.
	     */

	  }, {
	    key: "_sort",
	    value: function _sort(items, order) {
	      if (typeof order === "string") {
	        // order by provided field name
	        var name = order; // field name

	        sort$2(items).call(items, function (a, b) {
	          // @TODO: How to treat missing properties?
	          var av = a[name];
	          var bv = b[name];
	          return av > bv ? 1 : av < bv ? -1 : 0;
	        });
	      } else if (typeof order === "function") {
	        // order by sort function
	        sort$2(items).call(items, order);
	      } else {
	        // TODO: extend order by an Object {field:string, direction:string}
	        //       where direction can be 'asc' or 'desc'
	        throw new TypeError("Order must be a function or a string");
	      }
	    }
	    /**
	     * Remove an item or multiple items by “reference” (only the id is used) or by id.
	     *
	     * The method ignores removal of non-existing items, and returns an array containing the ids of the items which are actually removed from the DataSet.
	     *
	     * After the items are removed, the DataSet will trigger an event `remove` for the removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * ## Example
	     * ```javascript
	     * // create a DataSet
	     * const data = new vis.DataSet([
	     *   { id: 1, text: 'item 1' },
	     *   { id: 2, text: 'item 2' },
	     *   { id: 3, text: 'item 3' }
	     * ])
	     *
	     * // remove items
	     * const ids = data.remove([2, { id: 3 }, 4])
	     *
	     * console.log(ids) // [2, 3]
	     * ```
	     *
	     * @param id - One or more items or ids of items to be removed.
	     * @param senderId - Sender id.
	     *
	     * @returns The ids of the removed items.
	     */

	  }, {
	    key: "remove",
	    value: function remove(id, senderId) {
	      var removedIds = [];
	      var removedItems = []; // force everything to be an array for simplicity

	      var ids = isArray$5(id) ? id : [id];

	      for (var i = 0, len = ids.length; i < len; i++) {
	        var item = this._remove(ids[i]);

	        if (item) {
	          var itemId = item[this._idProp];

	          if (itemId != null) {
	            removedIds.push(itemId);
	            removedItems.push(item);
	          }
	        }
	      }

	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        }, senderId);
	      }

	      return removedIds;
	    }
	    /**
	     * Remove an item by its id or reference.
	     *
	     * @param id - Id of an item or the item itself.
	     *
	     * @returns The removed item if removed, null otherwise.
	     */

	  }, {
	    key: "_remove",
	    value: function _remove(id) {
	      // @TODO: It origianlly returned the item although the docs say id.
	      // The code expects the item, so probably an error in the docs.
	      var ident; // confirm the id to use based on the args type

	      if (isId(id)) {
	        ident = id;
	      } else if (id && _typeof_1(id) === "object") {
	        ident = id[this._idProp]; // look for the identifier field using ._idProp
	      } // do the removing if the item is found


	      if (ident != null && this._data.has(ident)) {
	        var item = this._data.get(ident) || null;

	        this._data.delete(ident);

	        --this.length;
	        return item;
	      }

	      return null;
	    }
	    /**
	     * Clear the entire data set.
	     *
	     * After the items are removed, the [[DataSet]] will trigger an event `remove` for all removed items. When a `senderId` is provided, this id will be passed with the triggered event to all subscribers.
	     *
	     * @param senderId - Sender id.
	     *
	     * @returns removedIds - The ids of all removed items.
	     */

	  }, {
	    key: "clear",
	    value: function clear(senderId) {
	      var _context23;

	      var ids = toConsumableArray(keys$6(_context23 = this._data).call(_context23));

	      var items = [];

	      for (var i = 0, len = ids.length; i < len; i++) {
	        items.push(this._data.get(ids[i]));
	      }

	      this._data.clear();

	      this.length = 0;

	      this._trigger("remove", {
	        items: ids,
	        oldData: items
	      }, senderId);

	      return ids;
	    }
	    /**
	     * Find the item with maximum value of a specified field.
	     *
	     * @param field - Name of the property that should be searched for max value.
	     *
	     * @returns Item containing max value, or null if no items.
	     */

	  }, {
	    key: "max",
	    value: function max(field) {
	      var _context24;

	      var max = null;
	      var maxField = null;

	      var _iterator11 = _createForOfIteratorHelper$1(values$5(_context24 = this._data).call(_context24)),
	          _step11;

	      try {
	        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
	          var item = _step11.value;
	          var itemField = item[field];

	          if (typeof itemField === "number" && (maxField == null || itemField > maxField)) {
	            max = item;
	            maxField = itemField;
	          }
	        }
	      } catch (err) {
	        _iterator11.e(err);
	      } finally {
	        _iterator11.f();
	      }

	      return max || null;
	    }
	    /**
	     * Find the item with minimum value of a specified field.
	     *
	     * @param field - Name of the property that should be searched for min value.
	     *
	     * @returns Item containing min value, or null if no items.
	     */

	  }, {
	    key: "min",
	    value: function min(field) {
	      var _context25;

	      var min = null;
	      var minField = null;

	      var _iterator12 = _createForOfIteratorHelper$1(values$5(_context25 = this._data).call(_context25)),
	          _step12;

	      try {
	        for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
	          var item = _step12.value;
	          var itemField = item[field];

	          if (typeof itemField === "number" && (minField == null || itemField < minField)) {
	            min = item;
	            minField = itemField;
	          }
	        }
	      } catch (err) {
	        _iterator12.e(err);
	      } finally {
	        _iterator12.f();
	      }

	      return min || null;
	    }
	    /**
	     * Find all distinct values of a specified field
	     *
	     * @param prop - The property name whose distinct values should be returned.
	     *
	     * @returns Unordered array containing all distinct values. Items without specified property are ignored.
	     */

	  }, {
	    key: "distinct",
	    value: function distinct(prop) {
	      var data = this._data;

	      var itemIds = toConsumableArray(keys$6(data).call(data));

	      var values = [];
	      var fieldType = this._options.type && this._options.type[prop] || null;
	      var count = 0;

	      for (var i = 0, len = itemIds.length; i < len; i++) {
	        var id = itemIds[i];
	        var item = data.get(id);
	        var _value4 = item[prop];
	        var exists = false;

	        for (var j = 0; j < count; j++) {
	          if (values[j] == _value4) {
	            exists = true;
	            break;
	          }
	        }

	        if (!exists && _value4 !== undefined) {
	          values[count] = _value4;
	          count++;
	        }
	      }

	      if (fieldType) {
	        for (var _i10 = 0, _len11 = values.length; _i10 < _len11; _i10++) {
	          values[_i10] = convert(values[_i10], fieldType);
	        }
	      }

	      return values;
	    }
	    /**
	     * Add a single item. Will fail when an item with the same id already exists.
	     *
	     * @param item - A new item to be added.
	     *
	     * @returns Added item's id. An id is generated when it is not present in the item.
	     */

	  }, {
	    key: "_addItem",
	    value: function _addItem(item) {
	      var id = item[this._idProp];

	      if (id != null) {
	        // check whether this id is already taken
	        if (this._data.has(id)) {
	          // item already exists
	          throw new Error("Cannot add item: item with id " + id + " already exists");
	        }
	      } else {
	        // generate an id
	        id = v4();
	        item[this._idProp] = id;
	      }

	      var d = {};

	      var fields = keys$3(item);

	      for (var i = 0, len = fields.length; i < len; i++) {
	        var field = fields[i];
	        var fieldType = this._type[field]; // type may be undefined

	        d[field] = convert(item[field], fieldType);
	      }

	      this._data.set(id, d);

	      ++this.length;
	      return id;
	    }
	    /**
	     * Get an item. Fields can be converted to a specific type
	     *
	     * @param id - Id of the requested item.
	     * @param types - Property name to type name object map of type converstions.
	     *
	     * @returns The item, optionally after type conversion.
	     */

	  }, {
	    key: "_getItem",
	    value: function _getItem(id, types) {
	      // @TODO: I have no idea how to type this.
	      // get the item from the dataset
	      var raw = this._data.get(id);

	      if (!raw) {
	        return null;
	      } // convert the items field types


	      var converted;

	      var fields = keys$3(raw);

	      if (types) {
	        warnTypeCorectionDeprecation();
	        converted = {};

	        for (var i = 0, len = fields.length; i < len; i++) {
	          var field = fields[i];
	          var _value5 = raw[field];
	          converted[field] = convert(_value5, types[field]);
	        }
	      } else {
	        // no field types specified, no converting needed
	        converted = _objectSpread$1({}, raw);
	      }

	      if (converted[this._idProp] == null) {
	        converted[this._idProp] = raw.id;
	      }

	      return converted;
	    }
	    /**
	     * Update a single item: merge with existing item.
	     * Will fail when the item has no id, or when there does not exist an item with the same id.
	     *
	     * @param item - The new item
	     *
	     * @returns The id of the updated item.
	     */

	  }, {
	    key: "_updateItem",
	    value: function _updateItem(item) {
	      var id = item[this._idProp];

	      if (id == null) {
	        throw new Error("Cannot update item: item has no id (item: " + stringify$2(item) + ")");
	      }

	      var d = this._data.get(id);

	      if (!d) {
	        // item doesn't exist
	        throw new Error("Cannot update item: no item with id " + id + " found");
	      } // merge with current item


	      var fields = keys$3(item);

	      for (var i = 0, len = fields.length; i < len; i++) {
	        var field = fields[i];
	        var fieldType = this._type[field]; // type may be undefined

	        d[field] = convert(item[field], fieldType);
	      }

	      return id;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "stream",
	    value: function stream(ids) {
	      if (ids) {
	        var data = this._data;
	        return new DataStream(defineProperty$6({}, iterator$4, /*#__PURE__*/regenerator.mark(function _callee3() {
	          var _iterator13, _step13, id, item;

	          return regenerator.wrap(function _callee3$(_context26) {
	            while (1) {
	              switch (_context26.prev = _context26.next) {
	                case 0:
	                  _iterator13 = _createForOfIteratorHelper$1(ids);
	                  _context26.prev = 1;

	                  _iterator13.s();

	                case 3:
	                  if ((_step13 = _iterator13.n()).done) {
	                    _context26.next = 11;
	                    break;
	                  }

	                  id = _step13.value;
	                  item = data.get(id);

	                  if (!(item != null)) {
	                    _context26.next = 9;
	                    break;
	                  }

	                  _context26.next = 9;
	                  return [id, item];

	                case 9:
	                  _context26.next = 3;
	                  break;

	                case 11:
	                  _context26.next = 16;
	                  break;

	                case 13:
	                  _context26.prev = 13;
	                  _context26.t0 = _context26["catch"](1);

	                  _iterator13.e(_context26.t0);

	                case 16:
	                  _context26.prev = 16;

	                  _iterator13.f();

	                  return _context26.finish(16);

	                case 19:
	                case "end":
	                  return _context26.stop();
	              }
	            }
	          }, _callee3, null, [[1, 13, 16, 19]]);
	        })));
	      } else {
	        var _context27;

	        return new DataStream(defineProperty$6({}, iterator$4, bind$2(_context27 = entries$2(this._data)).call(_context27, this._data)));
	      }
	    }
	  }]);

	  return DataSet;
	}(DataSetPart);
	/**
	 * DataView
	 *
	 * A DataView offers a filtered and/or formatted view on a DataSet. One can subscribe to changes in a DataView, and easily get filtered or formatted data without having to specify filters and field types all the time.
	 *
	 * ## Example
	 * ```javascript
	 * // create a DataSet
	 * var data = new vis.DataSet();
	 * data.add([
	 *   {id: 1, text: 'item 1', date: new Date(2013, 6, 20), group: 1, first: true},
	 *   {id: 2, text: 'item 2', date: '2013-06-23', group: 2},
	 *   {id: 3, text: 'item 3', date: '2013-06-25', group: 2},
	 *   {id: 4, text: 'item 4'}
	 * ]);
	 *
	 * // create a DataView
	 * // the view will only contain items having a property group with value 1,
	 * // and will only output fields id, text, and date.
	 * var view = new vis.DataView(data, {
	 *   filter: function (item) {
	 *     return (item.group == 1);
	 *   },
	 *   fields: ['id', 'text', 'date']
	 * });
	 *
	 * // subscribe to any change in the DataView
	 * view.on('*', function (event, properties, senderId) {
	 *   console.log('event', event, properties);
	 * });
	 *
	 * // update an item in the data set
	 * data.update({id: 2, group: 1});
	 *
	 * // get all ids in the view
	 * var ids = view.getIds();
	 * console.log('ids', ids); // will output [1, 2]
	 *
	 * // get all items in the view
	 * var items = view.get();
	 * ```
	 *
	 * @typeParam Item - Item type that may or may not have an id.
	 * @typeParam IdProp - Name of the property that contains the id.
	 */


	var DataView = /*#__PURE__*/function (_DataSetPart2) {
	  inherits(DataView, _DataSetPart2);

	  var _super2 = _createSuper(DataView);

	  /**
	   * Create a DataView.
	   *
	   * @param data - The instance containing data (directly or indirectly).
	   * @param options - Options to configure this data view.
	   */
	  function DataView(data, options) {
	    var _context30;

	    var _this7;

	    classCallCheck(this, DataView);

	    _this7 = _super2.call(this);
	    /** @inheritdoc */

	    _this7.length = 0;
	    _this7._ids = new set$3(); // ids of the items currently in memory (just contains a boolean true)

	    _this7._options = options || {};
	    _this7._listener = bind$2(_context30 = _this7._onEvent).call(_context30, assertThisInitialized(_this7));

	    _this7.setData(data);

	    return _this7;
	  } // TODO: implement a function .config() to dynamically update things like configured filter
	  // and trigger changes accordingly

	  /**
	   * Set a data source for the view.
	   *
	   * @param data - The instance containing data (directly or indirectly).
	   *
	   * @remarks
	   * Note that when the data view is bound to a data set it won't be garbage
	   * collected unless the data set is too. Use `dataView.setData(null)` or
	   * `dataView.dispose()` to enable garbage collection before you lose the last
	   * reference.
	   */


	  createClass(DataView, [{
	    key: "setData",
	    value: function setData(data) {
	      if (this._data) {
	        // unsubscribe from current dataset
	        if (this._data.off) {
	          this._data.off("*", this._listener);
	        } // trigger a remove of all items in memory


	        var ids = this._data.getIds({
	          filter: filter$2(this._options)
	        });

	        var items = this._data.get(ids);

	        this._ids.clear();

	        this.length = 0;

	        this._trigger("remove", {
	          items: ids,
	          oldData: items
	        });
	      }

	      if (data != null) {
	        this._data = data; // trigger an add of all added items

	        var _ids = this._data.getIds({
	          filter: filter$2(this._options)
	        });

	        for (var i = 0, len = _ids.length; i < len; i++) {
	          var id = _ids[i];

	          this._ids.add(id);
	        }

	        this.length = _ids.length;

	        this._trigger("add", {
	          items: _ids
	        });
	      } else {
	        this._data = new DataSet();
	      } // subscribe to new dataset


	      if (this._data.on) {
	        this._data.on("*", this._listener);
	      }
	    }
	    /**
	     * Refresh the DataView.
	     * Useful when the DataView has a filter function containing a variable parameter.
	     */

	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var ids = this._data.getIds({
	        filter: filter$2(this._options)
	      });

	      var oldIds = toConsumableArray(this._ids);

	      var newIds = {};
	      var addedIds = [];
	      var removedIds = [];
	      var removedItems = []; // check for additions

	      for (var i = 0, len = ids.length; i < len; i++) {
	        var id = ids[i];
	        newIds[id] = true;

	        if (!this._ids.has(id)) {
	          addedIds.push(id);

	          this._ids.add(id);
	        }
	      } // check for removals


	      for (var _i11 = 0, _len12 = oldIds.length; _i11 < _len12; _i11++) {
	        var _id7 = oldIds[_i11];

	        var item = this._data.get(_id7);

	        if (item == null) {
	          // @TODO: Investigate.
	          // Doesn't happen during tests or examples.
	          // Is it really impossible or could it eventually happen?
	          // How to handle it if it does? The types guarantee non-nullable items.
	          console.error("If you see this, report it please.");
	        } else if (!newIds[_id7]) {
	          removedIds.push(_id7);
	          removedItems.push(item);

	          this._ids.delete(_id7);
	        }
	      }

	      this.length += addedIds.length - removedIds.length; // trigger events

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        });
	      }

	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        });
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "get",
	    value: function get(first, second) {
	      if (this._data == null) {
	        return null;
	      } // parse the arguments


	      var ids = null;
	      var options;

	      if (isId(first) || isArray$5(first)) {
	        ids = first;
	        options = second;
	      } else {
	        options = first;
	      } // extend the options with the default options and provided options


	      var viewOptions = assign$2({}, this._options, options); // create a combined filter method when needed


	      var thisFilter = filter$2(this._options);

	      var optionsFilter = options && filter$2(options);

	      if (thisFilter && optionsFilter) {
	        viewOptions.filter = function (item) {
	          return thisFilter(item) && optionsFilter(item);
	        };
	      }

	      if (ids == null) {
	        return this._data.get(viewOptions);
	      } else {
	        return this._data.get(ids, viewOptions);
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getIds",
	    value: function getIds(options) {
	      if (this._data.length) {
	        var defaultFilter = filter$2(this._options);

	        var optionsFilter = options != null ? filter$2(options) : null;
	        var filter;

	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }

	        return this._data.getIds({
	          filter: filter,
	          order: options && options.order
	        });
	      } else {
	        return [];
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "forEach",
	    value: function forEach(callback, options) {
	      if (this._data) {
	        var _context31;

	        var defaultFilter = filter$2(this._options);

	        var optionsFilter = options && filter$2(options);

	        var filter;

	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }

	        forEach$2(_context31 = this._data).call(_context31, callback, {
	          filter: filter,
	          order: options && options.order
	        });
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "map",
	    value: function map(callback, options) {
	      if (this._data) {
	        var _context32;

	        var defaultFilter = filter$2(this._options);

	        var optionsFilter = options && filter$2(options);

	        var filter;

	        if (optionsFilter) {
	          if (defaultFilter) {
	            filter = function filter(item) {
	              return defaultFilter(item) && optionsFilter(item);
	            };
	          } else {
	            filter = optionsFilter;
	          }
	        } else {
	          filter = defaultFilter;
	        }

	        return map$2(_context32 = this._data).call(_context32, callback, {
	          filter: filter,
	          order: options && options.order
	        });
	      } else {
	        return [];
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getDataSet",
	    value: function getDataSet() {
	      return this._data.getDataSet();
	    }
	    /** @inheritdoc */

	  }, {
	    key: "stream",
	    value: function stream(ids) {
	      var _context33;

	      return this._data.stream(ids || defineProperty$6({}, iterator$4, bind$2(_context33 = keys$6(this._ids)).call(_context33, this._ids)));
	    }
	    /**
	     * Render the instance unusable prior to garbage collection.
	     *
	     * @remarks
	     * The intention of this method is to help discover scenarios where the data
	     * view is being used when the programmer thinks it has been garbage collected
	     * already. It's stricter version of `dataView.setData(null)`.
	     */

	  }, {
	    key: "dispose",
	    value: function dispose() {
	      var _a;

	      if ((_a = this._data) === null || _a === void 0 ? void 0 : _a.off) {
	        this._data.off("*", this._listener);
	      }

	      var message = "This data view has already been disposed of.";

	      defineProperty$3(this, "_data", {
	        get: function get() {
	          throw new Error(message);
	        },
	        set: function set() {
	          throw new Error(message);
	        },
	        configurable: false
	      });
	    }
	    /**
	     * Event listener. Will propagate all events from the connected data set to the subscribers of the DataView, but will filter the items and only trigger when there are changes in the filtered data set.
	     *
	     * @param event - The name of the event.
	     * @param params - Parameters of the event.
	     * @param senderId - Id supplied by the sender.
	     */

	  }, {
	    key: "_onEvent",
	    value: function _onEvent(event, params, senderId) {
	      if (!params || !params.items || !this._data) {
	        return;
	      }

	      var ids = params.items;
	      var addedIds = [];
	      var updatedIds = [];
	      var removedIds = [];
	      var oldItems = [];
	      var updatedItems = [];
	      var removedItems = [];

	      switch (event) {
	        case "add":
	          // filter the ids of the added items
	          for (var i = 0, len = ids.length; i < len; i++) {
	            var id = ids[i];
	            var item = this.get(id);

	            if (item) {
	              this._ids.add(id);

	              addedIds.push(id);
	            }
	          }

	          break;

	        case "update":
	          // determine the event from the views viewpoint: an updated
	          // item can be added, updated, or removed from this view.
	          for (var _i12 = 0, _len13 = ids.length; _i12 < _len13; _i12++) {
	            var _id8 = ids[_i12];

	            var _item2 = this.get(_id8);

	            if (_item2) {
	              if (this._ids.has(_id8)) {
	                updatedIds.push(_id8);
	                updatedItems.push(params.data[_i12]);
	                oldItems.push(params.oldData[_i12]);
	              } else {
	                this._ids.add(_id8);

	                addedIds.push(_id8);
	              }
	            } else {
	              if (this._ids.has(_id8)) {
	                this._ids.delete(_id8);

	                removedIds.push(_id8);
	                removedItems.push(params.oldData[_i12]);
	              }
	            }
	          }

	          break;

	        case "remove":
	          // filter the ids of the removed items
	          for (var _i13 = 0, _len14 = ids.length; _i13 < _len14; _i13++) {
	            var _id9 = ids[_i13];

	            if (this._ids.has(_id9)) {
	              this._ids.delete(_id9);

	              removedIds.push(_id9);
	              removedItems.push(params.oldData[_i13]);
	            }
	          }

	          break;
	      }

	      this.length += addedIds.length - removedIds.length;

	      if (addedIds.length) {
	        this._trigger("add", {
	          items: addedIds
	        }, senderId);
	      }

	      if (updatedIds.length) {
	        this._trigger("update", {
	          items: updatedIds,
	          oldData: oldItems,
	          data: updatedItems
	        }, senderId);
	      }

	      if (removedIds.length) {
	        this._trigger("remove", {
	          items: removedIds,
	          oldData: removedItems
	        }, senderId);
	      }
	    }
	  }]);

	  return DataView;
	}(DataSetPart);

	var index$2 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		DataSet: DataSet,
		DataStream: DataStream,
		DataView: DataView,
		Queue: Queue,
		createNewDataPipeFrom: createNewDataPipeFrom
	});

	var nativeGetOwnPropertyNames$2 = objectGetOwnPropertyNamesExternal.f;
	var FAILS_ON_PRIMITIVES$3 = fails(function () {
	  return !Object.getOwnPropertyNames(1);
	}); // `Object.getOwnPropertyNames` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertynames

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$3
	}, {
	  getOwnPropertyNames: nativeGetOwnPropertyNames$2
	});

	var Object$2 = path.Object;

	var getOwnPropertyNames = function getOwnPropertyNames(it) {
	  return Object$2.getOwnPropertyNames(it);
	};

	var getOwnPropertyNames$1 = getOwnPropertyNames;

	var getOwnPropertyNames$2 = getOwnPropertyNames$1;

	var trim$4 = stringTrim.trim;
	var $parseFloat = global_1.parseFloat;
	var FORCED$6 = 1 / $parseFloat(whitespaces + '-0') !== -Infinity; // `parseFloat` method
	// https://tc39.github.io/ecma262/#sec-parsefloat-string

	var numberParseFloat = FORCED$6 ? function parseFloat(string) {
	  var trimmedString = trim$4(String(string));
	  var result = $parseFloat(trimmedString);
	  return result === 0 && trimmedString.charAt(0) == '-' ? -0 : result;
	} : $parseFloat;

	// https://tc39.github.io/ecma262/#sec-parsefloat-string

	_export({
	  global: true,
	  forced: parseFloat != numberParseFloat
	}, {
	  parseFloat: numberParseFloat
	});

	var _parseFloat = path.parseFloat;

	var _parseFloat$1 = _parseFloat;

	var _parseFloat$2 = _parseFloat$1;

	/**
	 * Helper functions for components
	 * @class
	 */

	var ComponentUtil = /*#__PURE__*/function () {
	  function ComponentUtil() {
	    classCallCheck(this, ComponentUtil);
	  }

	  createClass(ComponentUtil, null, [{
	    key: "choosify",

	    /**
	     * Determine values to use for (sub)options of 'chosen'.
	     *
	     * This option is either a boolean or an object whose values should be examined further.
	     * The relevant structures are:
	     *
	     * - chosen: <boolean value>
	     * - chosen: { subOption: <boolean or function> }
	     *
	     * Where subOption is 'node', 'edge' or 'label'.
	     *
	     * The intention of this method appears to be to set a specific priority to the options;
	     * Since most properties are either bridged or merged into the local options objects, there
	     * is not much point in handling them separately.
	     * TODO: examine if 'most' in previous sentence can be replaced with 'all'. In that case, we
	     *       should be able to get rid of this method.
	     *
	     * @param {string}  subOption  option within object 'chosen' to consider; either 'node', 'edge' or 'label'
	     * @param {Object}  pile       array of options objects to consider
	     * 
	     * @return {boolean|function}  value for passed subOption of 'chosen' to use
	     */
	    value: function choosify(subOption, pile) {
	      // allowed values for subOption
	      var allowed = ['node', 'edge', 'label'];
	      var value = true;
	      var chosen = topMost(pile, 'chosen');

	      if (typeof chosen === 'boolean') {
	        value = chosen;
	      } else if (_typeof_1(chosen) === 'object') {
	        if (indexOf$3(allowed).call(allowed, subOption) === -1) {
	          throw new Error('choosify: subOption \'' + subOption + '\' should be one of ' + "'" + allowed.join("', '") + "'");
	        }

	        var chosenEdge = topMost(pile, ['chosen', subOption]);

	        if (typeof chosenEdge === 'boolean' || typeof chosenEdge === 'function') {
	          value = chosenEdge;
	        }
	      }

	      return value;
	    }
	    /**
	     * Check if the point falls within the given rectangle.
	     *
	     * @param {rect} rect
	     * @param {point} point
	     * @param {rotationPoint} [rotationPoint] if specified, the rotation that applies to the rectangle.
	     * @returns {boolean}  true if point within rectangle, false otherwise
	     * @static
	     */

	  }, {
	    key: "pointInRect",
	    value: function pointInRect(rect, point, rotationPoint) {
	      if (rect.width <= 0 || rect.height <= 0) {
	        return false; // early out
	      }

	      if (rotationPoint !== undefined) {
	        // Rotate the point the same amount as the rectangle
	        var tmp = {
	          x: point.x - rotationPoint.x,
	          y: point.y - rotationPoint.y
	        };

	        if (rotationPoint.angle !== 0) {
	          // In order to get the coordinates the same, you need to 
	          // rotate in the reverse direction
	          var angle = -rotationPoint.angle;
	          var tmp2 = {
	            x: Math.cos(angle) * tmp.x - Math.sin(angle) * tmp.y,
	            y: Math.sin(angle) * tmp.x + Math.cos(angle) * tmp.y
	          };
	          point = tmp2;
	        } else {
	          point = tmp;
	        } // Note that if a rotation is specified, the rectangle coordinates
	        // are **not* the full canvas coordinates. They are relative to the
	        // rotationPoint. Hence, the point coordinates need not be translated
	        // back in this case.

	      }

	      var right = rect.x + rect.width;
	      var bottom = rect.y + rect.width;
	      return rect.left < point.x && right > point.x && rect.top < point.y && bottom > point.y;
	    }
	    /**
	     * Check if given value is acceptable as a label text.
	     *
	     * @param {*} text value to check; can be anything at this point
	     * @returns {boolean} true if valid label value, false otherwise
	     */

	  }, {
	    key: "isValidLabel",
	    value: function isValidLabel(text) {
	      // Note that this is quite strict: types that *might* be converted to string are disallowed
	      return typeof text === 'string' && text !== '';
	    }
	    /**
	     * Returns x, y of self reference circle based on provided angle
	     *
	     * @param {Object} ctx
	     * @param {number} angle 
	     * @param {number} radius 
	     * @return {Object} node
	     * @returns {Object} x and y coordinates
	     */

	  }, {
	    key: "getSelfRefCoordinates",
	    value: function getSelfRefCoordinates(ctx, angle, radius, node) {
	      var x = node.x;
	      var y = node.y;

	      if (typeof node.distanceToBorder === "function") {
	        //calculating opposite and adjacent
	        //distaneToBorder becomes Hypotenuse. 
	        //Formulas sin(a) = Opposite / Hypotenuse and cos(a) = Adjacent / Hypotenuse
	        var toBorderDist = node.distanceToBorder(ctx, angle);
	        var yFromNodeCenter = Math.sin(angle) * toBorderDist;
	        var xFromNodeCenter = Math.cos(angle) * toBorderDist; //xFromNodeCenter is basically x and if xFromNodeCenter equals to the distance to border then it means
	        //that y does not need calculation because it is equal node.height / 2 or node.y
	        //same thing with yFromNodeCenter and if yFromNodeCenter equals to the distance to border then it means
	        //that x is equal node.width / 2 or node.x

	        if (xFromNodeCenter === toBorderDist) {
	          x += toBorderDist;
	          y = node.y;
	        } else if (yFromNodeCenter === toBorderDist) {
	          x = node.x;
	          y -= toBorderDist;
	        } else {
	          x += xFromNodeCenter;
	          y -= yFromNodeCenter;
	        }
	      } else if (node.shape.width > node.shape.height) {
	        x = node.x + node.shape.width * 0.5;
	        y = node.y - radius;
	      } else {
	        x = node.x + radius;
	        y = node.y - node.shape.height * 0.5;
	      }

	      return {
	        x: x,
	        y: y
	      };
	    }
	  }]);

	  return ComponentUtil;
	}();

	/**
	 * Callback to determine text dimensions, using the parent label settings.
	 * @callback MeasureText
	 * @param {text} text
	 * @param {text} mod
	 * @return {Object} { width, values} width in pixels and font attributes
	 */

	/**
	 * Helper class for Label which collects results of splitting labels into lines and blocks.
	 *
	 * @private
	 */
	var LabelAccumulator = /*#__PURE__*/function () {
	  /**
	   * @param {MeasureText} measureText
	   */
	  function LabelAccumulator(measureText) {
	    classCallCheck(this, LabelAccumulator);

	    this.measureText = measureText;
	    this.current = 0;
	    this.width = 0;
	    this.height = 0;
	    this.lines = [];
	  }
	  /**
	   * Append given text to the given line.
	   *
	   * @param {number}  l    index of line to add to
	   * @param {string}  text string to append to line
	   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
	   * @private
	   */


	  createClass(LabelAccumulator, [{
	    key: "_add",
	    value: function _add(l, text) {
	      var mod = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'normal';

	      if (this.lines[l] === undefined) {
	        this.lines[l] = {
	          width: 0,
	          height: 0,
	          blocks: []
	        };
	      } // We still need to set a block for undefined and empty texts, hence return at this point
	      // This is necessary because we don't know at this point if we're at the
	      // start of an empty line or not.
	      // To compensate, empty blocks are removed in `finalize()`.
	      //
	      // Empty strings should still have a height


	      var tmpText = text;
	      if (text === undefined || text === "") tmpText = " "; // Determine width and get the font properties

	      var result = this.measureText(tmpText, mod);

	      var block = assign$2({}, values$5(result));

	      block.text = text;
	      block.width = result.width;
	      block.mod = mod;

	      if (text === undefined || text === "") {
	        block.width = 0;
	      }

	      this.lines[l].blocks.push(block); // Update the line width. We need this for determining if a string goes over max width

	      this.lines[l].width += block.width;
	    }
	    /**
	     * Returns the width in pixels of the current line.
	     *
	     * @returns {number}
	     */

	  }, {
	    key: "curWidth",
	    value: function curWidth() {
	      var line = this.lines[this.current];
	      if (line === undefined) return 0;
	      return line.width;
	    }
	    /**
	     * Add text in block to current line
	     *
	     * @param {string} text
	     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
	     */

	  }, {
	    key: "append",
	    value: function append(text) {
	      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'normal';

	      this._add(this.current, text, mod);
	    }
	    /**
	     * Add text in block to current line and start a new line
	     *
	     * @param {string} text
	     * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod='normal']
	     */

	  }, {
	    key: "newLine",
	    value: function newLine(text) {
	      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'normal';

	      this._add(this.current, text, mod);

	      this.current++;
	    }
	    /**
	     * Determine and set the heights of all the lines currently contained in this instance
	     *
	     * Note that width has already been set.
	     * 
	     * @private
	     */

	  }, {
	    key: "determineLineHeights",
	    value: function determineLineHeights() {
	      for (var k = 0; k < this.lines.length; k++) {
	        var line = this.lines[k]; // Looking for max height of blocks in line

	        var height = 0;

	        if (line.blocks !== undefined) {
	          // Can happen if text contains e.g. '\n '
	          for (var l = 0; l < line.blocks.length; l++) {
	            var block = line.blocks[l];

	            if (height < block.height) {
	              height = block.height;
	            }
	          }
	        }

	        line.height = height;
	      }
	    }
	    /**
	     * Determine the full size of the label text, as determined by current lines and blocks
	     * 
	     * @private
	     */

	  }, {
	    key: "determineLabelSize",
	    value: function determineLabelSize() {
	      var width = 0;
	      var height = 0;

	      for (var k = 0; k < this.lines.length; k++) {
	        var line = this.lines[k];

	        if (line.width > width) {
	          width = line.width;
	        }

	        height += line.height;
	      }

	      this.width = width;
	      this.height = height;
	    }
	    /**
	     * Remove all empty blocks and empty lines we don't need
	     * 
	     * This must be done after the width/height determination,
	     * so that these are set properly for processing here.
	     *
	     * @returns {Array<Line>} Lines with empty blocks (and some empty lines) removed
	     * @private
	     */

	  }, {
	    key: "removeEmptyBlocks",
	    value: function removeEmptyBlocks() {
	      var tmpLines = [];

	      for (var k = 0; k < this.lines.length; k++) {
	        var line = this.lines[k]; // Note: an empty line in between text has width zero but is still relevant to layout.
	        // So we can't use width for testing empty line here

	        if (line.blocks.length === 0) continue; // Discard final empty line always

	        if (k === this.lines.length - 1) {
	          if (line.width === 0) continue;
	        }

	        var tmpLine = {};

	        assign$2(tmpLine, line);

	        tmpLine.blocks = [];
	        var firstEmptyBlock = void 0;
	        var tmpBlocks = [];

	        for (var l = 0; l < line.blocks.length; l++) {
	          var block = line.blocks[l];

	          if (block.width !== 0) {
	            tmpBlocks.push(block);
	          } else {
	            if (firstEmptyBlock === undefined) {
	              firstEmptyBlock = block;
	            }
	          }
	        } // Ensure that there is *some* text present


	        if (tmpBlocks.length === 0 && firstEmptyBlock !== undefined) {
	          tmpBlocks.push(firstEmptyBlock);
	        }

	        tmpLine.blocks = tmpBlocks;
	        tmpLines.push(tmpLine);
	      }

	      return tmpLines;
	    }
	    /**
	     * Set the sizes for all lines and the whole thing.
	     *
	     * @returns {{width: (number|*), height: (number|*), lines: Array}}
	     */

	  }, {
	    key: "finalize",
	    value: function finalize() {
	      //console.log(JSON.stringify(this.lines, null, 2));
	      this.determineLineHeights();
	      this.determineLabelSize();
	      var tmpLines = this.removeEmptyBlocks(); // Return a simple hash object for further processing.

	      return {
	        width: this.width,
	        height: this.height,
	        lines: tmpLines
	      };
	    }
	  }]);

	  return LabelAccumulator;
	}();

	var tagPattern = {
	  // HTML
	  '<b>': /<b>/,
	  '<i>': /<i>/,
	  '<code>': /<code>/,
	  '</b>': /<\/b>/,
	  '</i>': /<\/i>/,
	  '</code>': /<\/code>/,
	  // Markdown
	  '*': /\*/,
	  // bold
	  '_': /\_/,
	  // ital
	  '`': /`/,
	  // mono
	  'afterBold': /[^\*]/,
	  'afterItal': /[^_]/,
	  'afterMono': /[^`]/
	};
	/**
	 * Internal helper class for parsing the markup tags for HTML and Markdown.
	 *
	 * NOTE: Sequences of tabs and spaces are reduced to single space.
	 *       Scan usage of `this.spacing` within method
	 */

	var MarkupAccumulator = /*#__PURE__*/function () {
	  /**
	   * Create an instance
	   *
	   * @param {string} text  text to parse for markup
	   */
	  function MarkupAccumulator(text) {
	    classCallCheck(this, MarkupAccumulator);

	    this.text = text;
	    this.bold = false;
	    this.ital = false;
	    this.mono = false;
	    this.spacing = false;
	    this.position = 0;
	    this.buffer = "";
	    this.modStack = [];
	    this.blocks = [];
	  }
	  /**
	   * Return the mod label currently on the top of the stack
	   *
	   * @returns {string}  label of topmost mod 
	   * @private
	   */


	  createClass(MarkupAccumulator, [{
	    key: "mod",
	    value: function mod() {
	      return this.modStack.length === 0 ? 'normal' : this.modStack[0];
	    }
	    /**
	     * Return the mod label currently active
	     * 
	     * @returns {string}  label of active mod 
	     * @private
	     */

	  }, {
	    key: "modName",
	    value: function modName() {
	      if (this.modStack.length === 0) return 'normal';else if (this.modStack[0] === 'mono') return 'mono';else {
	        if (this.bold && this.ital) {
	          return 'boldital';
	        } else if (this.bold) {
	          return 'bold';
	        } else if (this.ital) {
	          return 'ital';
	        }
	      }
	    }
	    /**
	     * @private
	     */

	  }, {
	    key: "emitBlock",
	    value: function emitBlock() {
	      if (this.spacing) {
	        this.add(" ");
	        this.spacing = false;
	      }

	      if (this.buffer.length > 0) {
	        this.blocks.push({
	          text: this.buffer,
	          mod: this.modName()
	        });
	        this.buffer = "";
	      }
	    }
	    /**
	     * Output text to buffer
	     *
	     * @param {string} text  text to add
	     * @private
	     */

	  }, {
	    key: "add",
	    value: function add(text) {
	      if (text === " ") {
	        this.spacing = true;
	      }

	      if (this.spacing) {
	        this.buffer += " ";
	        this.spacing = false;
	      }

	      if (text != " ") {
	        this.buffer += text;
	      }
	    }
	    /**
	     * Handle parsing of whitespace
	     *
	     * @param {string} ch  the character to check
	     * @returns {boolean} true if the character was processed as whitespace, false otherwise
	     */

	  }, {
	    key: "parseWS",
	    value: function parseWS(ch) {
	      if (/[ \t]/.test(ch)) {
	        if (!this.mono) {
	          this.spacing = true;
	        } else {
	          this.add(ch);
	        }

	        return true;
	      }

	      return false;
	    }
	    /**
	     * @param {string} tagName  label for block type to set
	     * @private
	     */

	  }, {
	    key: "setTag",
	    value: function setTag(tagName) {
	      this.emitBlock();
	      this[tagName] = true;
	      this.modStack.unshift(tagName);
	    }
	    /**
	     * @param {string} tagName  label for block type to unset
	     * @private
	     */

	  }, {
	    key: "unsetTag",
	    value: function unsetTag(tagName) {
	      this.emitBlock();
	      this[tagName] = false;
	      this.modStack.shift();
	    }
	    /**
	     * @param {string} tagName label for block type we are currently processing
	     * @param {string|RegExp} tag string to match in text
	     * @returns {boolean} true if the tag was processed, false otherwise
	     */

	  }, {
	    key: "parseStartTag",
	    value: function parseStartTag(tagName, tag) {
	      // Note: if 'mono' passed as tagName, there is a double check here. This is OK
	      if (!this.mono && !this[tagName] && this.match(tag)) {
	        this.setTag(tagName);
	        return true;
	      }

	      return false;
	    }
	    /**
	     * @param {string|RegExp} tag
	     * @param {number} [advance=true] if set, advance current position in text
	     * @returns {boolean} true if match at given position, false otherwise
	     * @private
	     */

	  }, {
	    key: "match",
	    value: function match(tag) {
	      var advance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	      var _this$prepareRegExp = this.prepareRegExp(tag),
	          _this$prepareRegExp2 = slicedToArray(_this$prepareRegExp, 2),
	          regExp = _this$prepareRegExp2[0],
	          length = _this$prepareRegExp2[1];

	      var matched = regExp.test(this.text.substr(this.position, length));

	      if (matched && advance) {
	        this.position += length - 1;
	      }

	      return matched;
	    }
	    /**
	     * @param {string} tagName label for block type we are currently processing
	     * @param {string|RegExp} tag string to match in text
	     * @param {RegExp} [nextTag] regular expression to match for characters *following* the current tag 
	     * @returns {boolean} true if the tag was processed, false otherwise
	     */

	  }, {
	    key: "parseEndTag",
	    value: function parseEndTag(tagName, tag, nextTag) {
	      var checkTag = this.mod() === tagName;

	      if (tagName === 'mono') {
	        // special handling for 'mono'
	        checkTag = checkTag && this.mono;
	      } else {
	        checkTag = checkTag && !this.mono;
	      }

	      if (checkTag && this.match(tag)) {
	        if (nextTag !== undefined) {
	          // Purpose of the following match is to prevent a direct unset/set of a given tag
	          // E.g. '*bold **still bold*' => '*bold still bold*'
	          if (this.position === this.text.length - 1 || this.match(nextTag, false)) {
	            this.unsetTag(tagName);
	          }
	        } else {
	          this.unsetTag(tagName);
	        }

	        return true;
	      }

	      return false;
	    }
	    /**
	     * @param {string|RegExp} tag  string to match in text
	     * @param {value} value  string to replace tag with, if found at current position
	     * @returns {boolean} true if the tag was processed, false otherwise
	     */

	  }, {
	    key: "replace",
	    value: function replace(tag, value) {
	      if (this.match(tag)) {
	        this.add(value);
	        this.position += length - 1;
	        return true;
	      }

	      return false;
	    }
	    /**
	     * Create a regular expression for the tag if it isn't already one.
	     *
	     * The return value is an array `[RegExp, number]`, with exactly two value, where:
	     *  - RegExp is the regular expression to use
	     *  - number is the lenth of the input string to match
	     *
	     * @param {string|RegExp} tag  string to match in text
	     * @returns {Array}  regular expression to use and length of input string to match
	     * @private
	     */

	  }, {
	    key: "prepareRegExp",
	    value: function prepareRegExp(tag) {
	      var length;
	      var regExp;

	      if (tag instanceof RegExp) {
	        regExp = tag;
	        length = 1; // ASSUMPTION: regexp only tests one character
	      } else {
	        // use prepared regexp if present
	        var prepared = tagPattern[tag];

	        if (prepared !== undefined) {
	          regExp = prepared;
	        } else {
	          regExp = new RegExp(tag);
	        }

	        length = tag.length;
	      }

	      return [regExp, length];
	    }
	  }]);

	  return MarkupAccumulator;
	}();
	/**
	 * Helper class for Label which explodes the label text into lines and blocks within lines
	 *
	 * @private
	 */


	var LabelSplitter = /*#__PURE__*/function () {
	  /**
	   * @param {CanvasRenderingContext2D} ctx Canvas rendering context
	   * @param {Label} parent reference to the Label instance using current instance
	   * @param {boolean} selected 
	   * @param {boolean} hover
	   */
	  function LabelSplitter(ctx, parent, selected, hover) {
	    var _this = this;

	    classCallCheck(this, LabelSplitter);

	    this.ctx = ctx;
	    this.parent = parent;
	    this.selected = selected;
	    this.hover = hover;
	    /**
	     * Callback to determine text width; passed to LabelAccumulator instance
	     *
	     * @param  {String} text string to determine width of
	     * @param  {String} mod  font type to use for this text
	     * @return {Object} { width, values} width in pixels and font attributes
	     */

	    var textWidth = function textWidth(text, mod) {
	      if (text === undefined) return 0; // TODO: This can be done more efficiently with caching
	      // This will set the ctx.font correctly, depending on selected/hover and mod - so that ctx.measureText() will be accurate.

	      var values = _this.parent.getFormattingValues(ctx, selected, hover, mod);

	      var width = 0;

	      if (text !== '') {
	        var measure = _this.ctx.measureText(text);

	        width = measure.width;
	      }

	      return {
	        width: width,
	        values: values
	      };
	    };

	    this.lines = new LabelAccumulator(textWidth);
	  }
	  /**
	   * Split passed text of a label into lines and blocks.
	   *
	   * # NOTE
	   *
	   * The handling of spacing is option dependent:
	   *
	   * - if `font.multi : false`, all spaces are retained
	   * - if `font.multi : true`, every sequence of spaces is compressed to a single space
	   *
	   * This might not be the best way to do it, but this is as it has been working till now.
	   * In order not to break existing functionality, for the time being this behaviour will
	   * be retained in any code changes. 
	   *
	   * @param {string} text  text to split
	   * @returns {Array<line>}
	   */


	  createClass(LabelSplitter, [{
	    key: "process",
	    value: function process(text) {
	      if (!ComponentUtil.isValidLabel(text)) {
	        return this.lines.finalize();
	      }

	      var font = this.parent.fontOptions; // Normalize the end-of-line's to a single representation - order important

	      text = text.replace(/\r\n/g, '\n'); // Dos EOL's

	      text = text.replace(/\r/g, '\n'); // Mac EOL's
	      // Note that at this point, there can be no \r's in the text.
	      // This is used later on splitStringIntoLines() to split multifont texts.

	      var nlLines = String(text).split('\n');
	      var lineCount = nlLines.length;

	      if (font.multi) {
	        // Multi-font case: styling tags active
	        for (var i = 0; i < lineCount; i++) {
	          var blocks = this.splitBlocks(nlLines[i], font.multi); // Post: Sequences of tabs and spaces are reduced to single space

	          if (blocks === undefined) continue;

	          if (blocks.length === 0) {
	            this.lines.newLine("");
	            continue;
	          }

	          if (font.maxWdt > 0) {
	            // widthConstraint.maximum defined
	            //console.log('Running widthConstraint multi, max: ' + this.fontOptions.maxWdt);
	            for (var j = 0; j < blocks.length; j++) {
	              var mod = blocks[j].mod;
	              var _text = blocks[j].text;
	              this.splitStringIntoLines(_text, mod, true);
	            }
	          } else {
	            // widthConstraint.maximum NOT defined
	            for (var _j = 0; _j < blocks.length; _j++) {
	              var _mod = blocks[_j].mod;
	              var _text2 = blocks[_j].text;
	              this.lines.append(_text2, _mod);
	            }
	          }

	          this.lines.newLine();
	        }
	      } else {
	        // Single-font case
	        if (font.maxWdt > 0) {
	          // widthConstraint.maximum defined
	          // console.log('Running widthConstraint normal, max: ' + this.fontOptions.maxWdt);
	          for (var _i = 0; _i < lineCount; _i++) {
	            this.splitStringIntoLines(nlLines[_i]);
	          }
	        } else {
	          // widthConstraint.maximum NOT defined
	          for (var _i2 = 0; _i2 < lineCount; _i2++) {
	            this.lines.newLine(nlLines[_i2]);
	          }
	        }
	      }

	      return this.lines.finalize();
	    }
	    /**
	     * normalize the markup system
	     *
	     * @param {boolean|'md'|'markdown'|'html'} markupSystem
	     * @returns {string}
	     */

	  }, {
	    key: "decodeMarkupSystem",
	    value: function decodeMarkupSystem(markupSystem) {
	      var system = 'none';

	      if (markupSystem === 'markdown' || markupSystem === 'md') {
	        system = 'markdown';
	      } else if (markupSystem === true || markupSystem === 'html') {
	        system = 'html';
	      }

	      return system;
	    }
	    /**
	     *
	     * @param {string} text
	     * @returns {Array}
	     */

	  }, {
	    key: "splitHtmlBlocks",
	    value: function splitHtmlBlocks(text) {
	      var s = new MarkupAccumulator(text);

	      var parseEntities = function parseEntities(ch) {
	        if (/&/.test(ch)) {
	          var parsed = s.replace(s.text, '&lt;', '<') || s.replace(s.text, '&amp;', '&');

	          if (!parsed) {
	            s.add("&");
	          }

	          return true;
	        }

	        return false;
	      };

	      while (s.position < s.text.length) {
	        var ch = s.text.charAt(s.position);
	        var parsed = s.parseWS(ch) || /</.test(ch) && (s.parseStartTag('bold', '<b>') || s.parseStartTag('ital', '<i>') || s.parseStartTag('mono', '<code>') || s.parseEndTag('bold', '</b>') || s.parseEndTag('ital', '</i>') || s.parseEndTag('mono', '</code>')) || parseEntities(ch);

	        if (!parsed) {
	          s.add(ch);
	        }

	        s.position++;
	      }

	      s.emitBlock();
	      return s.blocks;
	    }
	    /**
	     *
	     * @param {string} text
	     * @returns {Array}
	     */

	  }, {
	    key: "splitMarkdownBlocks",
	    value: function splitMarkdownBlocks(text) {
	      var _this2 = this;

	      var s = new MarkupAccumulator(text);
	      var beginable = true;

	      var parseOverride = function parseOverride(ch) {
	        if (/\\/.test(ch)) {
	          if (s.position < _this2.text.length + 1) {
	            s.position++;
	            ch = _this2.text.charAt(s.position);

	            if (/ \t/.test(ch)) {
	              s.spacing = true;
	            } else {
	              s.add(ch);
	              beginable = false;
	            }
	          }

	          return true;
	        }

	        return false;
	      };

	      while (s.position < s.text.length) {
	        var ch = s.text.charAt(s.position);
	        var parsed = s.parseWS(ch) || parseOverride(ch) || (beginable || s.spacing) && (s.parseStartTag('bold', '*') || s.parseStartTag('ital', '_') || s.parseStartTag('mono', '`')) || s.parseEndTag('bold', '*', 'afterBold') || s.parseEndTag('ital', '_', 'afterItal') || s.parseEndTag('mono', '`', 'afterMono');

	        if (!parsed) {
	          s.add(ch);
	          beginable = false;
	        }

	        s.position++;
	      }

	      s.emitBlock();
	      return s.blocks;
	    }
	    /**
	     * Explodes a piece of text into single-font blocks using a given markup
	     *
	     * @param {string} text
	     * @param {boolean|'md'|'markdown'|'html'} markupSystem
	     * @returns {Array.<{text: string, mod: string}>}
	     * @private
	     */

	  }, {
	    key: "splitBlocks",
	    value: function splitBlocks(text, markupSystem) {
	      var system = this.decodeMarkupSystem(markupSystem);

	      if (system === 'none') {
	        return [{
	          text: text,
	          mod: 'normal'
	        }];
	      } else if (system === 'markdown') {
	        return this.splitMarkdownBlocks(text);
	      } else if (system === 'html') {
	        return this.splitHtmlBlocks(text);
	      }
	    }
	    /**
	     * @param {string} text
	     * @returns {boolean} true if text length over the current max with
	     * @private
	     */

	  }, {
	    key: "overMaxWidth",
	    value: function overMaxWidth(text) {
	      var width = this.ctx.measureText(text).width;
	      return this.lines.curWidth() + width > this.parent.fontOptions.maxWdt;
	    }
	    /**
	     * Determine the longest part of the sentence which still fits in the 
	     * current max width.
	     * 
	     * @param {Array} words  Array of strings signifying a text lines
	     * @return {number}      index of first item in string making string go over max
	     * @private
	     */

	  }, {
	    key: "getLongestFit",
	    value: function getLongestFit(words) {
	      var text = '';
	      var w = 0;

	      while (w < words.length) {
	        var pre = text === '' ? '' : ' ';
	        var newText = text + pre + words[w];
	        if (this.overMaxWidth(newText)) break;
	        text = newText;
	        w++;
	      }

	      return w;
	    }
	    /**
	     * Determine the longest part of the string which still fits in the
	     * current max width.
	     * 
	     * @param {Array} words Array of strings signifying a text lines
	     * @return {number} index of first item in string making string go over max
	     */

	  }, {
	    key: "getLongestFitWord",
	    value: function getLongestFitWord(words) {
	      var w = 0;

	      while (w < words.length) {
	        if (this.overMaxWidth(slice$5(words).call(words, 0, w))) break;
	        w++;
	      }

	      return w;
	    }
	    /**
	     * Split the passed text into lines, according to width constraint (if any).
	     * 
	     * The method assumes that the input string is a single line, i.e. without lines break.
	     *
	     * This method retains spaces, if still present (case `font.multi: false`).
	     * A space which falls on an internal line break, will be replaced by a newline.
	     * There is no special handling of tabs; these go along with the flow.
	     * 
	     * @param {string} str
	     * @param {string} [mod='normal']
	     * @param {boolean} [appendLast=false]
	     * @private
	     */

	  }, {
	    key: "splitStringIntoLines",
	    value: function splitStringIntoLines(str) {
	      var mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'normal';
	      var appendLast = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      // Set the canvas context font, based upon the current selected/hover state
	      // and the provided mod, so the text measurement performed by getLongestFit
	      // will be accurate - and not just use the font of whoever last used the canvas.
	      this.parent.getFormattingValues(this.ctx, this.selected, this.hover, mod); // Still-present spaces are relevant, retain them

	      str = str.replace(/^( +)/g, '$1\r');
	      str = str.replace(/([^\r][^ ]*)( +)/g, '$1\r$2\r');
	      var words = str.split('\r');

	      while (words.length > 0) {
	        var w = this.getLongestFit(words);

	        if (w === 0) {
	          // Special case: the first word is already larger than the max width.
	          var word = words[0]; // Break the word to the largest part that fits the line

	          var x = this.getLongestFitWord(word);
	          this.lines.newLine(slice$5(word).call(word, 0, x), mod); // Adjust the word, so that the rest will be done next iteration

	          words[0] = slice$5(word).call(word, x);
	        } else {
	          // skip any space that is replaced by a newline
	          var newW = w;

	          if (words[w - 1] === ' ') {
	            w--;
	          } else if (words[newW] === ' ') {
	            newW++;
	          }

	          var text = slice$5(words).call(words, 0, w).join("");

	          if (w == words.length && appendLast) {
	            this.lines.append(text, mod);
	          } else {
	            this.lines.newLine(text, mod);
	          } // Adjust the word, so that the rest will be done next iteration


	          words = slice$5(words).call(words, newW);
	        }
	      }
	    }
	  }]);

	  return LabelSplitter;
	}();

	/**
	 * List of special styles for multi-fonts
	 * @private
	 */

	var multiFontStyle = ['bold', 'ital', 'boldital', 'mono'];
	/**
	 * A Label to be used for Nodes or Edges.
	 */

	var Label = /*#__PURE__*/function () {
	  /**
	   * @param {Object} body
	   * @param {Object} options
	   * @param {boolean} [edgelabel=false]
	   */
	  function Label(body, options) {
	    var edgelabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	    classCallCheck(this, Label);

	    this.body = body;
	    this.pointToSelf = false;
	    this.baseSize = undefined;
	    this.fontOptions = {}; // instance variable containing the *instance-local* font options

	    this.setOptions(options);
	    this.size = {
	      top: 0,
	      left: 0,
	      width: 0,
	      height: 0,
	      yLine: 0
	    };
	    this.isEdgeLabel = edgelabel;
	  }
	  /**
	   * @param {Object} options the options of the parent Node-instance
	   */


	  createClass(Label, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.elementOptions = options; // Reference to the options of the parent Node-instance 

	      this.initFontOptions(options.font);

	      if (ComponentUtil.isValidLabel(options.label)) {
	        this.labelDirty = true;
	      } else {
	        // Bad label! Change the option value to prevent bad stuff happening
	        options.label = undefined;
	      }

	      if (options.font !== undefined && options.font !== null) {
	        // font options can be deleted at various levels
	        if (typeof options.font === 'string') {
	          this.baseSize = this.fontOptions.size;
	        } else if (_typeof_1(options.font) === 'object') {
	          var size = options.font.size;

	          if (size !== undefined) {
	            this.baseSize = size;
	          }
	        }
	      }
	    }
	    /**
	     * Init the font Options structure.
	     *
	     * Member fontOptions serves as an accumulator for the current font options.
	     * As such, it needs to be completely separated from the node options.
	     *
	     * @param {Object} newFontOptions the new font options to process
	     * @private
	     */

	  }, {
	    key: "initFontOptions",
	    value: function initFontOptions(newFontOptions) {
	      var _this = this;

	      // Prepare the multi-font option objects.
	      // These will be filled in propagateFonts(), if required
	      forEach$3(multiFontStyle, function (style) {
	        _this.fontOptions[style] = {};
	      }); // Handle shorthand option, if present

	      if (Label.parseFontString(this.fontOptions, newFontOptions)) {
	        this.fontOptions.vadjust = 0;
	        return;
	      } // Copy over the non-multifont options, if specified


	      forEach$3(newFontOptions, function (prop, n) {
	        if (prop !== undefined && prop !== null && _typeof_1(prop) !== 'object') {
	          _this.fontOptions[n] = prop;
	        }
	      });
	    }
	    /**
	     * If in-variable is a string, parse it as a font specifier.
	     *
	     * Note that following is not done here and have to be done after the call:
	     * - Not all font options are set (vadjust, mod)
	     *
	     * @param {Object} outOptions  out-parameter, object in which to store the parse results (if any)
	     * @param {Object} inOptions  font options to parse
	     * @return {boolean} true if font parsed as string, false otherwise
	     * @static
	     */

	  }, {
	    key: "constrain",

	    /**
	     * Set the width and height constraints based on 'nearest' value
	     *
	     * @param {Array} pile array of option objects to consider
	     * @returns {object} the actual constraint values to use
	     * @private
	     */
	    value: function constrain(pile) {
	      // NOTE: constrainWidth and  constrainHeight never set!
	      // NOTE: for edge labels, only 'maxWdt' set
	      // Node labels can set all the fields
	      var fontOptions = {
	        constrainWidth: false,
	        maxWdt: -1,
	        minWdt: -1,
	        constrainHeight: false,
	        minHgt: -1,
	        valign: 'middle'
	      };
	      var widthConstraint = topMost(pile, 'widthConstraint');

	      if (typeof widthConstraint === 'number') {
	        fontOptions.maxWdt = Number(widthConstraint);
	        fontOptions.minWdt = Number(widthConstraint);
	      } else if (_typeof_1(widthConstraint) === 'object') {
	        var widthConstraintMaximum = topMost(pile, ['widthConstraint', 'maximum']);

	        if (typeof widthConstraintMaximum === 'number') {
	          fontOptions.maxWdt = Number(widthConstraintMaximum);
	        }

	        var widthConstraintMinimum = topMost(pile, ['widthConstraint', 'minimum']);

	        if (typeof widthConstraintMinimum === 'number') {
	          fontOptions.minWdt = Number(widthConstraintMinimum);
	        }
	      }

	      var heightConstraint = topMost(pile, 'heightConstraint');

	      if (typeof heightConstraint === 'number') {
	        fontOptions.minHgt = Number(heightConstraint);
	      } else if (_typeof_1(heightConstraint) === 'object') {
	        var heightConstraintMinimum = topMost(pile, ['heightConstraint', 'minimum']);

	        if (typeof heightConstraintMinimum === 'number') {
	          fontOptions.minHgt = Number(heightConstraintMinimum);
	        }

	        var heightConstraintValign = topMost(pile, ['heightConstraint', 'valign']);

	        if (typeof heightConstraintValign === 'string') {
	          if (heightConstraintValign === 'top' || heightConstraintValign === 'bottom') {
	            fontOptions.valign = heightConstraintValign;
	          }
	        }
	      }

	      return fontOptions;
	    }
	    /**
	     * Set options and update internal state
	     *
	     * @param {Object} options  options to set
	     * @param {Array}  pile     array of option objects to consider for option 'chosen'
	     */

	  }, {
	    key: "update",
	    value: function update(options, pile) {
	      this.setOptions(options, true);
	      this.propagateFonts(pile);
	      deepExtend(this.fontOptions, this.constrain(pile));
	      this.fontOptions.chooser = ComponentUtil.choosify('label', pile);
	    }
	    /**
	     * When margins are set in an element, adjust sizes is called to remove them
	     * from the width/height constraints. This must be done prior to label sizing.
	     *
	     * @param {{top: number, right: number, bottom: number, left: number}} margins
	     */

	  }, {
	    key: "adjustSizes",
	    value: function adjustSizes(margins) {
	      var widthBias = margins ? margins.right + margins.left : 0;

	      if (this.fontOptions.constrainWidth) {
	        this.fontOptions.maxWdt -= widthBias;
	        this.fontOptions.minWdt -= widthBias;
	      }

	      var heightBias = margins ? margins.top + margins.bottom : 0;

	      if (this.fontOptions.constrainHeight) {
	        this.fontOptions.minHgt -= heightBias;
	      }
	    } /////////////////////////////////////////////////////////
	    // Methods for handling options piles
	    // Eventually, these will be moved to a separate class
	    /////////////////////////////////////////////////////////

	    /**
	     * Add the font members of the passed list of option objects to the pile.
	     *
	     * @param {Pile} dstPile  pile of option objects add to 
	     * @param {Pile} srcPile  pile of option objects to take font options from
	     * @private
	     */

	  }, {
	    key: "addFontOptionsToPile",
	    value: function addFontOptionsToPile(dstPile, srcPile) {
	      for (var i = 0; i < srcPile.length; ++i) {
	        this.addFontToPile(dstPile, srcPile[i]);
	      }
	    }
	    /**
	     * Add given font option object to the list of objects (the 'pile') to consider for determining
	     * multi-font option values.
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @param {object} options  instance to add to pile
	     * @private
	     */

	  }, {
	    key: "addFontToPile",
	    value: function addFontToPile(pile, options) {
	      if (options === undefined) return;
	      if (options.font === undefined || options.font === null) return;
	      var item = options.font;
	      pile.push(item);
	    }
	    /**
	     * Collect all own-property values from the font pile that aren't multi-font option objectss.
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @returns {object} object with all current own basic font properties
	     * @private
	     */

	  }, {
	    key: "getBasicOptions",
	    value: function getBasicOptions(pile) {
	      var ret = {}; // Scans the whole pile to get all options present

	      for (var n = 0; n < pile.length; ++n) {
	        var fontOptions = pile[n]; // Convert shorthand if necessary

	        var tmpShorthand = {};

	        if (Label.parseFontString(tmpShorthand, fontOptions)) {
	          fontOptions = tmpShorthand;
	        }

	        forEach$3(fontOptions, function (opt, name) {
	          if (opt === undefined) return; // multi-font option need not be present 

	          if (ret.hasOwnProperty(name)) return; // Keep first value we encounter

	          if (indexOf$3(multiFontStyle).call(multiFontStyle, name) !== -1) {
	            // Skip multi-font properties but we do need the structure
	            ret[name] = {};
	          } else {
	            ret[name] = opt;
	          }
	        });
	      }

	      return ret;
	    }
	    /**
	     * Return the value for given option for the given multi-font.
	     *
	     * All available option objects are trawled in the set order to construct the option values.
	     *
	     * ---------------------------------------------------------------------
	     * ## Traversal of pile for multi-fonts
	     *
	     * The determination of multi-font option values is a special case, because any values not
	     * present in the multi-font options should by definition be taken from the main font options,
	     * i.e. from the current 'parent' object of the multi-font option.
	     *
	     * ### Search order for multi-fonts
	     *
	     * 'bold' used as example:
	     *
	     *   - search in option group 'bold' in local properties
	     *   - search in main font option group in local properties
	     *
	     * ---------------------------------------------------------------------
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @param {MultiFontStyle} multiName sub path for the multi-font
	     * @param {string} option  the option to search for, for the given multi-font
	     * @returns {string|number} the value for the given option
	     * @private
	     */

	  }, {
	    key: "getFontOption",
	    value: function getFontOption(pile, multiName, option) {
	      var multiFont; // Search multi font in local properties

	      for (var n = 0; n < pile.length; ++n) {
	        var fontOptions = pile[n];

	        if (fontOptions.hasOwnProperty(multiName)) {
	          multiFont = fontOptions[multiName];
	          if (multiFont === undefined || multiFont === null) continue; // Convert shorthand if necessary
	          // TODO: inefficient to do this conversion every time; find a better way.

	          var tmpShorthand = {};

	          if (Label.parseFontString(tmpShorthand, multiFont)) {
	            multiFont = tmpShorthand;
	          }

	          if (multiFont.hasOwnProperty(option)) {
	            return multiFont[option];
	          }
	        }
	      } // Option is not mentioned in the multi font options; take it from the parent font options.
	      // These have already been converted with getBasicOptions(), so use the converted values.


	      if (this.fontOptions.hasOwnProperty(option)) {
	        return this.fontOptions[option];
	      } // A value **must** be found; you should never get here.


	      throw new Error("Did not find value for multi-font for property: '" + option + "'");
	    }
	    /**
	     * Return all options values for the given multi-font.
	     *
	     * All available option objects are trawled in the set order to construct the option values.
	     *
	     * @param {Pile} pile  pile of option objects to use
	     * @param {MultiFontStyle} multiName sub path for the mod-font
	     * @returns {MultiFontOptions}
	     * @private
	     */

	  }, {
	    key: "getFontOptions",
	    value: function getFontOptions(pile, multiName) {
	      var result = {};
	      var optionNames = ['color', 'size', 'face', 'mod', 'vadjust']; // List of allowed options per multi-font

	      for (var i = 0; i < optionNames.length; ++i) {
	        var mod = optionNames[i];
	        result[mod] = this.getFontOption(pile, multiName, mod);
	      }

	      return result;
	    } /////////////////////////////////////////////////////////
	    // End methods for handling options piles
	    /////////////////////////////////////////////////////////

	    /**
	     * Collapse the font options for the multi-font to single objects, from
	     * the chain of option objects passed (the 'pile').
	     *
	     * @param {Pile} pile  sequence of option objects to consider.
	     *                     First item in list assumed to be the newly set options.
	     */

	  }, {
	    key: "propagateFonts",
	    value: function propagateFonts(pile) {
	      var _this2 = this;

	      var fontPile = []; // sequence of font objects to consider, order important
	      // Note that this.elementOptions is not used here.

	      this.addFontOptionsToPile(fontPile, pile);
	      this.fontOptions = this.getBasicOptions(fontPile); // We set multifont values even if multi === false, for consistency (things break otherwise)

	      var _loop = function _loop(i) {
	        var mod = multiFontStyle[i];
	        var modOptions = _this2.fontOptions[mod];

	        var tmpMultiFontOptions = _this2.getFontOptions(fontPile, mod); // Copy over found values


	        forEach$3(tmpMultiFontOptions, function (option, n) {
	          modOptions[n] = option;
	        });
	        modOptions.size = Number(modOptions.size);
	        modOptions.vadjust = Number(modOptions.vadjust);
	      };

	      for (var i = 0; i < multiFontStyle.length; ++i) {
	        _loop(i);
	      }
	    }
	    /**
	     * Main function. This is called from anything that wants to draw a label.
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x
	     * @param {number} y
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {string} [baseline='middle']
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover) {
	      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'middle';
	      // if no label, return
	      if (this.elementOptions.label === undefined) return; // check if we have to render the label

	      var viewFontSize = this.fontOptions.size * this.body.view.scale;
	      if (this.elementOptions.label && viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) return; // This ensures that there will not be HUGE letters on screen
	      // by setting an upper limit on the visible text size (regardless of zoomLevel)

	      if (viewFontSize >= this.elementOptions.scaling.label.maxVisible) {
	        viewFontSize = Number(this.elementOptions.scaling.label.maxVisible) / this.body.view.scale;
	      } // update the size cache if required


	      this.calculateLabelSize(ctx, selected, hover, x, y, baseline);

	      this._drawBackground(ctx);

	      this._drawText(ctx, x, this.size.yLine, baseline, viewFontSize);
	    }
	    /**
	     * Draws the label background
	     * @param {CanvasRenderingContext2D} ctx
	     * @private
	     */

	  }, {
	    key: "_drawBackground",
	    value: function _drawBackground(ctx) {
	      if (this.fontOptions.background !== undefined && this.fontOptions.background !== "none") {
	        ctx.fillStyle = this.fontOptions.background;
	        var size = this.getSize();
	        ctx.fillRect(size.left, size.top, size.width, size.height);
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x
	     * @param {number} y
	     * @param {string} [baseline='middle']
	     * @param {number} viewFontSize 
	     * @private
	     */

	  }, {
	    key: "_drawText",
	    value: function _drawText(ctx, x, y) {
	      var baseline = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'middle';
	      var viewFontSize = arguments.length > 4 ? arguments[4] : undefined;

	      var _this$_setAlignment = this._setAlignment(ctx, x, y, baseline);

	      var _this$_setAlignment2 = slicedToArray(_this$_setAlignment, 2);

	      x = _this$_setAlignment2[0];
	      y = _this$_setAlignment2[1];
	      ctx.textAlign = 'left';
	      x = x - this.size.width / 2; // Shift label 1/2-distance to the left

	      if (this.fontOptions.valign && this.size.height > this.size.labelHeight) {
	        if (this.fontOptions.valign === 'top') {
	          y -= (this.size.height - this.size.labelHeight) / 2;
	        }

	        if (this.fontOptions.valign === 'bottom') {
	          y += (this.size.height - this.size.labelHeight) / 2;
	        }
	      } // draw the text


	      for (var i = 0; i < this.lineCount; i++) {
	        var line = this.lines[i];

	        if (line && line.blocks) {
	          var width = 0;

	          if (this.isEdgeLabel || this.fontOptions.align === 'center') {
	            width += (this.size.width - line.width) / 2;
	          } else if (this.fontOptions.align === 'right') {
	            width += this.size.width - line.width;
	          }

	          for (var j = 0; j < line.blocks.length; j++) {
	            var block = line.blocks[j];
	            ctx.font = block.font;

	            var _this$_getColor = this._getColor(block.color, viewFontSize, block.strokeColor),
	                _this$_getColor2 = slicedToArray(_this$_getColor, 2),
	                fontColor = _this$_getColor2[0],
	                strokeColor = _this$_getColor2[1];

	            if (block.strokeWidth > 0) {
	              ctx.lineWidth = block.strokeWidth;
	              ctx.strokeStyle = strokeColor;
	              ctx.lineJoin = 'round';
	            }

	            ctx.fillStyle = fontColor;

	            if (block.strokeWidth > 0) {
	              ctx.strokeText(block.text, x + width, y + block.vadjust);
	            }

	            ctx.fillText(block.text, x + width, y + block.vadjust);
	            width += block.width;
	          }

	          y += line.height;
	        }
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x
	     * @param {number} y
	     * @param {string} baseline
	     * @returns {Array.<number>}
	     * @private
	     */

	  }, {
	    key: "_setAlignment",
	    value: function _setAlignment(ctx, x, y, baseline) {
	      // check for label alignment (for edges)
	      // TODO: make alignment for nodes
	      if (this.isEdgeLabel && this.fontOptions.align !== 'horizontal' && this.pointToSelf === false) {
	        x = 0;
	        y = 0;
	        var lineMargin = 2;

	        if (this.fontOptions.align === 'top') {
	          ctx.textBaseline = 'alphabetic';
	          y -= 2 * lineMargin; // distance from edge, required because we use alphabetic. Alphabetic has less difference between browsers
	        } else if (this.fontOptions.align === 'bottom') {
	          ctx.textBaseline = 'hanging';
	          y += 2 * lineMargin; // distance from edge, required because we use hanging. Hanging has less difference between browsers
	        } else {
	          ctx.textBaseline = 'middle';
	        }
	      } else {
	        ctx.textBaseline = baseline;
	      }

	      return [x, y];
	    }
	    /**
	     * fade in when relative scale is between threshold and threshold - 1.
	     * If the relative scale would be smaller than threshold -1 the draw function would have returned before coming here.
	     *
	     * @param {string} color  The font color to use
	     * @param {number} viewFontSize
	     * @param {string} initialStrokeColor
	     * @returns {Array.<string>} An array containing the font color and stroke color
	     * @private
	     */

	  }, {
	    key: "_getColor",
	    value: function _getColor(color, viewFontSize, initialStrokeColor) {
	      var fontColor = color || '#000000';
	      var strokeColor = initialStrokeColor || '#ffffff';

	      if (viewFontSize <= this.elementOptions.scaling.label.drawThreshold) {
	        var opacity = Math.max(0, Math.min(1, 1 - (this.elementOptions.scaling.label.drawThreshold - viewFontSize)));
	        fontColor = overrideOpacity(fontColor, opacity);
	        strokeColor = overrideOpacity(strokeColor, opacity);
	      }

	      return [fontColor, strokeColor];
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @returns {{width: number, height: number}}
	     */

	  }, {
	    key: "getTextSize",
	    value: function getTextSize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	      this._processLabel(ctx, selected, hover);

	      return {
	        width: this.size.width,
	        height: this.size.height,
	        lineCount: this.lineCount
	      };
	    }
	    /**
	     * Get the current dimensions of the label
	     *
	     * @return {rect}
	     */

	  }, {
	    key: "getSize",
	    value: function getSize() {
	      var lineMargin = 2;
	      var x = this.size.left; // default values which might be overridden below

	      var y = this.size.top - 0.5 * lineMargin; // idem

	      if (this.isEdgeLabel) {
	        var x2 = -this.size.width * 0.5;

	        switch (this.fontOptions.align) {
	          case 'middle':
	            x = x2;
	            y = -this.size.height * 0.5;
	            break;

	          case 'top':
	            x = x2;
	            y = -(this.size.height + lineMargin);
	            break;

	          case 'bottom':
	            x = x2;
	            y = lineMargin;
	            break;
	        }
	      }

	      var ret = {
	        left: x,
	        top: y,
	        width: this.size.width,
	        height: this.size.height
	      };
	      return ret;
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {number} [x=0]
	     * @param {number} [y=0]
	     * @param {'middle'|'hanging'} [baseline='middle']
	     */

	  }, {
	    key: "calculateLabelSize",
	    value: function calculateLabelSize(ctx, selected, hover) {
	      var x = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
	      var y = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
	      var baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'middle';

	      this._processLabel(ctx, selected, hover);

	      this.size.left = x - this.size.width * 0.5;
	      this.size.top = y - this.size.height * 0.5;
	      this.size.yLine = y + (1 - this.lineCount) * 0.5 * this.fontOptions.size;

	      if (baseline === "hanging") {
	        this.size.top += 0.5 * this.fontOptions.size;
	        this.size.top += 4; // distance from node, required because we use hanging. Hanging has less difference between browsers

	        this.size.yLine += 4; // distance from node
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {string} mod
	     * @returns {{color, size, face, mod, vadjust, strokeWidth: *, strokeColor: (*|string|allOptions.edges.font.strokeColor|{string}|allOptions.nodes.font.strokeColor|Array)}}
	     */

	  }, {
	    key: "getFormattingValues",
	    value: function getFormattingValues(ctx, selected, hover, mod) {
	      var getValue = function getValue(fontOptions, mod, option) {
	        if (mod === "normal") {
	          if (option === 'mod') return "";
	          return fontOptions[option];
	        }

	        if (fontOptions[mod][option] !== undefined) {
	          // Grumbl leaving out test on undefined equals false for "" 
	          return fontOptions[mod][option];
	        } else {
	          // Take from parent font option
	          return fontOptions[option];
	        }
	      };

	      var values = {
	        color: getValue(this.fontOptions, mod, 'color'),
	        size: getValue(this.fontOptions, mod, 'size'),
	        face: getValue(this.fontOptions, mod, 'face'),
	        mod: getValue(this.fontOptions, mod, 'mod'),
	        vadjust: getValue(this.fontOptions, mod, 'vadjust'),
	        strokeWidth: this.fontOptions.strokeWidth,
	        strokeColor: this.fontOptions.strokeColor
	      };

	      if (selected || hover) {
	        if (mod === "normal" && this.fontOptions.chooser === true && this.elementOptions.labelHighlightBold) {
	          values.mod = 'bold';
	        } else {
	          if (typeof this.fontOptions.chooser === 'function') {
	            this.fontOptions.chooser(values, this.elementOptions.id, selected, hover);
	          }
	        }
	      }

	      var fontString = "";

	      if (values.mod !== undefined && values.mod !== "") {
	        // safeguard for undefined - this happened
	        fontString += values.mod + " ";
	      }

	      fontString += values.size + "px " + values.face;
	      ctx.font = fontString.replace(/"/g, "");
	      values.font = ctx.font;
	      values.height = values.size;
	      return values;
	    }
	    /**
	     *
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @returns {boolean}
	     */

	  }, {
	    key: "differentState",
	    value: function differentState(selected, hover) {
	      return selected !== this.selectedState || hover !== this.hoverState;
	    }
	    /**
	     * This explodes the passed text into lines and determines the width, height and number of lines.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {string} inText  the text to explode
	     * @returns {{width, height, lines}|*}
	     * @private
	     */

	  }, {
	    key: "_processLabelText",
	    value: function _processLabelText(ctx, selected, hover, inText) {
	      var splitter = new LabelSplitter(ctx, this, selected, hover);
	      return splitter.process(inText);
	    }
	    /**
	     * This explodes the label string into lines and sets the width, height and number of lines.
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @private
	     */

	  }, {
	    key: "_processLabel",
	    value: function _processLabel(ctx, selected, hover) {
	      if (this.labelDirty === false && !this.differentState(selected, hover)) return;

	      var state = this._processLabelText(ctx, selected, hover, this.elementOptions.label);

	      if (this.fontOptions.minWdt > 0 && state.width < this.fontOptions.minWdt) {
	        state.width = this.fontOptions.minWdt;
	      }

	      this.size.labelHeight = state.height;

	      if (this.fontOptions.minHgt > 0 && state.height < this.fontOptions.minHgt) {
	        state.height = this.fontOptions.minHgt;
	      }

	      this.lines = state.lines;
	      this.lineCount = state.lines.length;
	      this.size.width = state.width;
	      this.size.height = state.height;
	      this.selectedState = selected;
	      this.hoverState = hover;
	      this.labelDirty = false;
	    }
	    /**
	     * Check if this label is visible
	     *
	     * @return {boolean} true if this label will be show, false otherwise
	     */

	  }, {
	    key: "visible",
	    value: function visible() {
	      if (this.size.width === 0 || this.size.height === 0 || this.elementOptions.label === undefined) {
	        return false; // nothing to display
	      }

	      var viewFontSize = this.fontOptions.size * this.body.view.scale;

	      if (viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) {
	        return false; // Too small or too far away to show
	      }

	      return true;
	    }
	  }], [{
	    key: "parseFontString",
	    value: function parseFontString(outOptions, inOptions) {
	      if (!inOptions || typeof inOptions !== 'string') return false;
	      var newOptionsArray = inOptions.split(" ");
	      outOptions.size = +newOptionsArray[0].replace("px", '');
	      outOptions.face = newOptionsArray[1];
	      outOptions.color = newOptionsArray[2];
	      return true;
	    }
	  }]);

	  return Label;
	}();

	// https://tc39.github.io/ecma262/#sec-array.prototype.fill


	var arrayFill = function fill(value
	/* , start = 0, end = @length */
	) {
	  var O = toObject(this);
	  var length = toLength(O.length);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);

	  while (endPos > index) O[index++] = value;

	  return O;
	};

	// https://tc39.github.io/ecma262/#sec-array.prototype.fill

	_export({
	  target: 'Array',
	  proto: true
	}, {
	  fill: arrayFill
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	var fill = entryVirtual('Array').fill;

	var ArrayPrototype$g = Array.prototype;

	var fill_1 = function (it) {
	  var own = it.fill;
	  return it === ArrayPrototype$g || it instanceof Array && own === ArrayPrototype$g.fill ? fill : own;
	};

	var fill$1 = fill_1;

	var fill$2 = fill$1;

	/**
	 * The Base class for all Nodes.
	 */
	var NodeBase = /*#__PURE__*/function () {
	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function NodeBase(options, body, labelModule) {
	    classCallCheck(this, NodeBase);

	    this.body = body;
	    this.labelModule = labelModule;
	    this.setOptions(options);
	    this.top = undefined;
	    this.left = undefined;
	    this.height = undefined;
	    this.width = undefined;
	    this.radius = undefined;
	    this.margin = undefined;
	    this.refreshNeeded = true;
	    this.boundingBox = {
	      top: 0,
	      left: 0,
	      right: 0,
	      bottom: 0
	    };
	  }
	  /**
	   *
	   * @param {Object} options
	   */


	  createClass(NodeBase, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	    }
	    /**
	     *
	     * @param {Label} labelModule
	     * @private
	     */

	  }, {
	    key: "_setMargins",
	    value: function _setMargins(labelModule) {
	      this.margin = {};

	      if (this.options.margin) {
	        if (_typeof_1(this.options.margin) == 'object') {
	          this.margin.top = this.options.margin.top;
	          this.margin.right = this.options.margin.right;
	          this.margin.bottom = this.options.margin.bottom;
	          this.margin.left = this.options.margin.left;
	        } else {
	          this.margin.top = this.options.margin;
	          this.margin.right = this.options.margin;
	          this.margin.bottom = this.options.margin;
	          this.margin.left = this.options.margin;
	        }
	      }

	      labelModule.adjustSizes(this.margin);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     * @private
	     */

	  }, {
	    key: "_distanceToBorder",
	    value: function _distanceToBorder(ctx, angle) {
	      var borderWidth = this.options.borderWidth;

	      if (ctx) {
	        this.resize(ctx);
	      }

	      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "enableShadow",
	    value: function enableShadow(ctx, values) {
	      if (values.shadow) {
	        ctx.shadowColor = values.shadowColor;
	        ctx.shadowBlur = values.shadowSize;
	        ctx.shadowOffsetX = values.shadowX;
	        ctx.shadowOffsetY = values.shadowY;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "disableShadow",
	    value: function disableShadow(ctx, values) {
	      if (values.shadow) {
	        ctx.shadowColor = 'rgba(0,0,0,0)';
	        ctx.shadowBlur = 0;
	        ctx.shadowOffsetX = 0;
	        ctx.shadowOffsetY = 0;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "enableBorderDashes",
	    value: function enableBorderDashes(ctx, values) {
	      if (values.borderDashes !== false) {
	        if (ctx.setLineDash !== undefined) {
	          var dashes = values.borderDashes;

	          if (dashes === true) {
	            dashes = [5, 15];
	          }

	          ctx.setLineDash(dashes);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
	          this.options.shapeProperties.borderDashes = false;
	          values.borderDashes = false;
	        }
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "disableBorderDashes",
	    value: function disableBorderDashes(ctx, values) {
	      if (values.borderDashes !== false) {
	        if (ctx.setLineDash !== undefined) {
	          ctx.setLineDash([0]);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
	          this.options.shapeProperties.borderDashes = false;
	          values.borderDashes = false;
	        }
	      }
	    }
	    /**
	     * Determine if the shape of a node needs to be recalculated.
	     *
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @returns {boolean}
	     * @protected
	     */

	  }, {
	    key: "needsRefresh",
	    value: function needsRefresh(selected, hover) {
	      if (this.refreshNeeded === true) {
	        // This is probably not the best location to reset this member.
	        // However, in the current logic, it is the most convenient one.
	        this.refreshNeeded = false;
	        return true;
	      }

	      return this.width === undefined || this.labelModule.differentState(selected, hover);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "initContextForDraw",
	    value: function initContextForDraw(ctx, values) {
	      var borderWidth = values.borderWidth / this.body.view.scale;
	      ctx.lineWidth = Math.min(this.width, borderWidth);
	      ctx.strokeStyle = values.borderColor;
	      ctx.fillStyle = values.color;
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "performStroke",
	    value: function performStroke(ctx, values) {
	      var borderWidth = values.borderWidth / this.body.view.scale; //draw dashed border if enabled, save and restore is required for firefox not to crash on unix.

	      ctx.save(); // if borders are zero width, they will be drawn with width 1 by default. This prevents that

	      if (borderWidth > 0) {
	        this.enableBorderDashes(ctx, values); //draw the border

	        ctx.stroke(); //disable dashed border for other elements

	        this.disableBorderDashes(ctx, values);
	      }

	      ctx.restore();
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "performFill",
	    value: function performFill(ctx, values) {
	      ctx.save();
	      ctx.fillStyle = values.color; // draw shadow if enabled

	      this.enableShadow(ctx, values); // draw the background

	      fill$2(ctx).call(ctx); // disable shadows for other elements.


	      this.disableShadow(ctx, values);
	      ctx.restore();
	      this.performStroke(ctx, values);
	    }
	    /**
	     *
	     * @param {number} margin
	     * @private
	     */

	  }, {
	    key: "_addBoundingBoxMargin",
	    value: function _addBoundingBoxMargin(margin) {
	      this.boundingBox.left -= margin;
	      this.boundingBox.top -= margin;
	      this.boundingBox.bottom += margin;
	      this.boundingBox.right += margin;
	    }
	    /**
	     * Actual implementation of this method call.
	     *
	     * Doing it like this makes it easier to override
	     * in the child classes.
	     *
	     * @param {number} x width
	     * @param {number} y height
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @private
	     */

	  }, {
	    key: "_updateBoundingBox",
	    value: function _updateBoundingBox(x, y, ctx, selected, hover) {
	      if (ctx !== undefined) {
	        this.resize(ctx, selected, hover);
	      }

	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.boundingBox.left = this.left;
	      this.boundingBox.top = this.top;
	      this.boundingBox.bottom = this.top + this.height;
	      this.boundingBox.right = this.left + this.width;
	    }
	    /**
	     * Default implementation of this method call.
	     * This acts as a stub which can be overridden.
	     *
	     * @param {number} x width
	     * @param {number} y height
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y, ctx, selected, hover) {
	      this._updateBoundingBox(x, y, ctx, selected, hover);
	    }
	    /**
	     * Determine the dimensions to use for nodes with an internal label
	     *
	     * Currently, these are: Circle, Ellipse, Database, Box
	     * The other nodes have external labels, and will not call this method
	     *
	     * If there is no label, decent default values are supplied.
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} [selected]
	     * @param {boolean} [hover]
	     * @returns {{width:number, height:number}}
	     */

	  }, {
	    key: "getDimensionsFromLabel",
	    value: function getDimensionsFromLabel(ctx, selected, hover) {
	      // NOTE: previously 'textSize' was not put in 'this' for Ellipse
	      // TODO: examine the consequences.
	      this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
	      var width = this.textSize.width;
	      var height = this.textSize.height;
	      var DEFAULT_SIZE = 14;

	      if (width === 0) {
	        // This happens when there is no label text set
	        width = DEFAULT_SIZE; // use a decent default

	        height = DEFAULT_SIZE; // if width zero, then height also always zero
	      }

	      return {
	        width: width,
	        height: height
	      };
	    }
	  }]);

	  return NodeBase;
	}();

	function _createSuper$1(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$1() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Box Node/Cluster shape.
	 *
	 * @extends NodeBase
	 */

	var Box = /*#__PURE__*/function (_NodeBase) {
	  inherits(Box, _NodeBase);

	  var _super = _createSuper$1(Box);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Box(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, Box);

	    _this = _super.call(this, options, body, labelModule);

	    _this._setMargins(labelModule);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */


	  createClass(Box, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        this.width = dimensions.width + this.margin.right + this.margin.left;
	        this.height = dimensions.height + this.margin.top + this.margin.bottom;
	        this.radius = this.width / 2;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.initContextForDraw(ctx, values);
	      drawRoundRect(ctx, this.left, this.top, this.width, this.height, values.borderRadius);
	      this.performFill(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
	    }
	    /**
	     *
	     * @param {number} x width
	     * @param {number} y height
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {boolean} selected
	     * @param {boolean} hover
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y, ctx, selected, hover) {
	      this._updateBoundingBox(x, y, ctx, selected, hover);

	      var borderRadius = this.options.shapeProperties.borderRadius; // only effective for box

	      this._addBoundingBoxMargin(borderRadius);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      if (ctx) {
	        this.resize(ctx);
	      }

	      var borderWidth = this.options.borderWidth;
	      return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
	    }
	  }]);

	  return Box;
	}(NodeBase);

	function _createSuper$2(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$2() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * NOTE: This is a bad base class
	 *
	 * Child classes are:
	 *
	 *   Image       - uses *only* image methods
	 *   Circle      - uses *only* _drawRawCircle
	 *   CircleImage - uses all
	 *
	 * TODO: Refactor, move _drawRawCircle to different module, derive Circle from NodeBase
	 *       Rename this to ImageBase
	 *       Consolidate common code in Image and CircleImage to base class
	 *
	 * @extends NodeBase
	 */

	var CircleImageBase = /*#__PURE__*/function (_NodeBase) {
	  inherits(CircleImageBase, _NodeBase);

	  var _super = _createSuper$2(CircleImageBase);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function CircleImageBase(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, CircleImageBase);

	    _this = _super.call(this, options, body, labelModule);
	    _this.labelOffset = 0;
	    _this.selected = false;
	    return _this;
	  }
	  /**
	   *
	   * @param {Object} options
	   * @param {Object} [imageObj]
	   * @param {Object} [imageObjAlt]
	   */


	  createClass(CircleImageBase, [{
	    key: "setOptions",
	    value: function setOptions(options, imageObj, imageObjAlt) {
	      this.options = options;

	      if (!(imageObj === undefined && imageObjAlt === undefined)) {
	        this.setImages(imageObj, imageObjAlt);
	      }
	    }
	    /**
	     * Set the images for this node.
	     *
	     * The images can be updated after the initial setting of options;
	     * therefore, this method needs to be reentrant. 
	     *
	     * For correct working in error cases, it is necessary to properly set
	     * field 'nodes.brokenImage' in the options.
	     *
	     * @param {Image} imageObj  required; main image to show for this node
	     * @param {Image|undefined} imageObjAlt optional; image to show when node is selected
	     */

	  }, {
	    key: "setImages",
	    value: function setImages(imageObj, imageObjAlt) {
	      if (imageObjAlt && this.selected) {
	        this.imageObj = imageObjAlt;
	        this.imageObjAlt = imageObj;
	      } else {
	        this.imageObj = imageObj;
	        this.imageObjAlt = imageObjAlt;
	      }
	    }
	    /**
	     * Set selection and switch between the base and the selected image.
	     *
	     * Do the switch only if imageObjAlt exists.
	     *
	     * @param {boolean} selected value of new selected state for current node
	     */

	  }, {
	    key: "switchImages",
	    value: function switchImages(selected) {
	      var selection_changed = selected && !this.selected || !selected && this.selected;
	      this.selected = selected; // Remember new selection

	      if (this.imageObjAlt !== undefined && selection_changed) {
	        var imageTmp = this.imageObj;
	        this.imageObj = this.imageObjAlt;
	        this.imageObjAlt = imageTmp;
	      }
	    }
	    /**
	     * Returns Image Padding from node options
	     *
	     * @returns {{top: number,left: number,bottom: number,right: number}} image padding inside this shape
	     * @private
	     */

	  }, {
	    key: "_getImagePadding",
	    value: function _getImagePadding() {
	      var imgPadding = {
	        top: 0,
	        right: 0,
	        bottom: 0,
	        left: 0
	      };

	      if (this.options.imagePadding) {
	        var optImgPadding = this.options.imagePadding;

	        if (_typeof_1(optImgPadding) == 'object') {
	          imgPadding.top = optImgPadding.top;
	          imgPadding.right = optImgPadding.right;
	          imgPadding.bottom = optImgPadding.bottom;
	          imgPadding.left = optImgPadding.left;
	        } else {
	          imgPadding.top = optImgPadding;
	          imgPadding.right = optImgPadding;
	          imgPadding.bottom = optImgPadding;
	          imgPadding.left = optImgPadding;
	        }
	      }

	      return imgPadding;
	    }
	    /**
	     * Adjust the node dimensions for a loaded image.
	     *
	     * Pre: this.imageObj is valid
	     */

	  }, {
	    key: "_resizeImage",
	    value: function _resizeImage() {
	      var width, height;

	      if (this.options.shapeProperties.useImageSize === false) {
	        // Use the size property
	        var ratio_width = 1;
	        var ratio_height = 1; // Only calculate the proper ratio if both width and height not zero

	        if (this.imageObj.width && this.imageObj.height) {
	          if (this.imageObj.width > this.imageObj.height) {
	            ratio_width = this.imageObj.width / this.imageObj.height;
	          } else {
	            ratio_height = this.imageObj.height / this.imageObj.width;
	          }
	        }

	        width = this.options.size * 2 * ratio_width;
	        height = this.options.size * 2 * ratio_height;
	      } else {
	        // Use the image size with image padding
	        var imgPadding = this._getImagePadding();

	        width = this.imageObj.width + imgPadding.left + imgPadding.right;
	        height = this.imageObj.height + imgPadding.top + imgPadding.bottom;
	      }

	      this.width = width;
	      this.height = height;
	      this.radius = 0.5 * this.width;
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {ArrowOptions} values
	     * @private
	     */

	  }, {
	    key: "_drawRawCircle",
	    value: function _drawRawCircle(ctx, x, y, values) {
	      this.initContextForDraw(ctx, values);
	      drawCircle(ctx, x, y, values.size);
	      this.performFill(ctx, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {ArrowOptions} values
	     * @private
	     */

	  }, {
	    key: "_drawImageAtPosition",
	    value: function _drawImageAtPosition(ctx, values) {
	      if (this.imageObj.width != 0) {
	        // draw the image
	        ctx.globalAlpha = values.opacity !== undefined ? values.opacity : 1; // draw shadow if enabled

	        this.enableShadow(ctx, values);
	        var factor = 1;

	        if (this.options.shapeProperties.interpolation === true) {
	          factor = this.imageObj.width / this.width / this.body.view.scale;
	        }

	        var imgPadding = this._getImagePadding();

	        var imgPosLeft = this.left + imgPadding.left;
	        var imgPosTop = this.top + imgPadding.top;
	        var imgWidth = this.width - imgPadding.left - imgPadding.right;
	        var imgHeight = this.height - imgPadding.top - imgPadding.bottom;
	        this.imageObj.drawImageAtPosition(ctx, factor, imgPosLeft, imgPosTop, imgWidth, imgHeight); // disable shadows for other elements.

	        this.disableShadow(ctx, values);
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @private
	     */

	  }, {
	    key: "_drawImageLabel",
	    value: function _drawImageLabel(ctx, x, y, selected, hover) {
	      var yLabel;
	      var offset = 0;

	      if (this.height !== undefined) {
	        offset = this.height * 0.5;
	        var labelDimensions = this.labelModule.getTextSize(ctx, selected, hover);

	        if (labelDimensions.lineCount >= 1) {
	          offset += labelDimensions.height / 2;
	        }
	      }

	      yLabel = y + offset;

	      if (this.options.label) {
	        this.labelOffset = offset;
	      }

	      this.labelModule.draw(ctx, x, yLabel, selected, hover, 'hanging');
	    }
	  }]);

	  return CircleImageBase;
	}(NodeBase);

	function _createSuper$3(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$3(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$3() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Circle Node/Cluster shape.
	 *
	 * @extends CircleImageBase
	 */

	var Circle = /*#__PURE__*/function (_CircleImageBase) {
	  inherits(Circle, _CircleImageBase);

	  var _super = _createSuper$3(Circle);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Circle(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, Circle);

	    _this = _super.call(this, options, body, labelModule);

	    _this._setMargins(labelModule);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */


	  createClass(Circle, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        var diameter = Math.max(dimensions.width + this.margin.right + this.margin.left, dimensions.height + this.margin.top + this.margin.bottom);
	        this.options.size = diameter / 2; // NOTE: this size field only set here, not in Ellipse, Database, Box

	        this.width = diameter;
	        this.height = diameter;
	        this.radius = this.width / 2;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;

	      this._drawRawCircle(ctx, x, y, values);

	      this.updateBoundingBox(x, y);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, y, selected, hover);
	    }
	    /**
	     *
	     * @param {number} x width
	     * @param {number} y height
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.size;
	      this.boundingBox.left = x - this.options.size;
	      this.boundingBox.right = x + this.options.size;
	      this.boundingBox.bottom = y + this.options.size;
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle - Unused
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      // eslint-disable-line no-unused-vars
	      if (ctx) {
	        this.resize(ctx);
	      }

	      return this.width * 0.5;
	    }
	  }]);

	  return Circle;
	}(CircleImageBase);

	function _createSuper$4(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$4(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$4() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A CircularImage Node/Cluster shape.
	 *
	 * @extends CircleImageBase
	 */

	var CircularImage = /*#__PURE__*/function (_CircleImageBase) {
	  inherits(CircularImage, _CircleImageBase);

	  var _super = _createSuper$4(CircularImage);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   * @param {Image} imageObj
	   * @param {Image} imageObjAlt
	   */
	  function CircularImage(options, body, labelModule, imageObj, imageObjAlt) {
	    var _this;

	    classCallCheck(this, CircularImage);

	    _this = _super.call(this, options, body, labelModule);

	    _this.setImages(imageObj, imageObjAlt);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */


	  createClass(CircularImage, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;

	      if (imageAbsent) {
	        var diameter = this.options.size * 2;
	        this.width = diameter;
	        this.height = diameter;
	        this.radius = 0.5 * this.width;
	        return;
	      } // At this point, an image is present, i.e. this.imageObj is valid.


	      if (this.needsRefresh(selected, hover)) {
	        this._resizeImage();
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.switchImages(selected);
	      this.resize();
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2; // draw the background circle. IMPORTANT: the stroke in this method is used by the clip method below.

	      this._drawRawCircle(ctx, x, y, values); // now we draw in the circle, we save so we can revert the clip operation after drawing.


	      ctx.save(); // clip is used to use the stroke in drawRawCircle as an area that we can draw in.

	      ctx.clip(); // draw the image

	      this._drawImageAtPosition(ctx, values); // restore so we can again draw on the full canvas


	      ctx.restore();

	      this._drawImageLabel(ctx, x, y, selected, hover);

	      this.updateBoundingBox(x, y);
	    } // TODO: compare with Circle.updateBoundingBox(), consolidate? More stuff is happening here

	    /**
	     *
	     * @param {number} x width
	     * @param {number} y height
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.size;
	      this.boundingBox.left = x - this.options.size;
	      this.boundingBox.right = x + this.options.size;
	      this.boundingBox.bottom = y + this.options.size; // TODO: compare with Image.updateBoundingBox(), consolidate?

	      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle - Unused
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      // eslint-disable-line no-unused-vars
	      if (ctx) {
	        this.resize(ctx);
	      }

	      return this.width * 0.5;
	    }
	  }]);

	  return CircularImage;
	}(CircleImageBase);

	function _createSuper$5(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$5(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$5() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Database Node/Cluster shape.
	 *
	 * @extends NodeBase
	 */

	var Database = /*#__PURE__*/function (_NodeBase) {
	  inherits(Database, _NodeBase);

	  var _super = _createSuper$5(Database);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Database(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, Database);

	    _this = _super.call(this, options, body, labelModule);

	    _this._setMargins(labelModule);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} selected
	   * @param {boolean} hover
	   */


	  createClass(Database, [{
	    key: "resize",
	    value: function resize(ctx, selected, hover) {
	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        var size = dimensions.width + this.margin.right + this.margin.left;
	        this.width = size;
	        this.height = size;
	        this.radius = this.width / 2;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.initContextForDraw(ctx, values);
	      drawDatabase(ctx, x - this.width / 2, y - this.height / 2, this.width, this.height);
	      this.performFill(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Database;
	}(NodeBase);

	function _createSuper$6(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$6(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$6() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * Base class for constructing Node/Cluster Shapes.
	 *
	 * @extends NodeBase
	 */

	var ShapeBase = /*#__PURE__*/function (_NodeBase) {
	  inherits(ShapeBase, _NodeBase);

	  var _super = _createSuper$6(ShapeBase);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function ShapeBase(options, body, labelModule) {
	    classCallCheck(this, ShapeBase);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   * @param {Object} [values={size: this.options.size}]
	   */


	  createClass(ShapeBase, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      var values = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
	        size: this.options.size
	      };

	      if (this.needsRefresh(selected, hover)) {
	        this.labelModule.getTextSize(ctx, selected, hover);
	        var size = 2 * values.size;
	        this.width = size;
	        this.height = size;
	        this.radius = 0.5 * this.width;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {string} shape
	     * @param {number} sizeMultiplier - Unused! TODO: Remove next major release
	     * @param {number} x
	     * @param {number} y
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     * @private
	     */

	  }, {
	    key: "_drawShape",
	    value: function _drawShape(ctx, shape, sizeMultiplier, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover, values);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;
	      this.initContextForDraw(ctx, values);
	      getShape(shape)(ctx, x, y, values.size);
	      this.performFill(ctx, values);

	      if (this.options.icon !== undefined) {
	        if (this.options.icon.code !== undefined) {
	          ctx.font = (selected ? "bold " : "") + this.height / 2 + "px " + (this.options.icon.face || 'FontAwesome');
	          ctx.fillStyle = this.options.icon.color || "black";
	          ctx.textAlign = "center";
	          ctx.textBaseline = "middle";
	          ctx.fillText(this.options.icon.code, x, y);
	        }
	      }

	      if (this.options.label !== undefined) {
	        // Need to call following here in order to ensure value for `this.labelModule.size.height`
	        this.labelModule.calculateLabelSize(ctx, selected, hover, x, y, 'hanging');
	        var yLabel = y + 0.5 * this.height + 0.5 * this.labelModule.size.height;
	        this.labelModule.draw(ctx, x, yLabel, selected, hover, 'hanging');
	      }

	      this.updateBoundingBox(x, y);
	    }
	    /**
	     *
	     * @param {number} x
	     * @param {number} y
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.size;
	      this.boundingBox.left = x - this.options.size;
	      this.boundingBox.right = x + this.options.size;
	      this.boundingBox.bottom = y + this.options.size;

	      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
	        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height);
	      }
	    }
	  }]);

	  return ShapeBase;
	}(NodeBase);

	function _createSuper$7(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$7(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$7() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Diamond Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var Diamond = /*#__PURE__*/function (_ShapeBase) {
	  inherits(Diamond, _ShapeBase);

	  var _super = _createSuper$7(Diamond);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Diamond(options, body, labelModule) {
	    classCallCheck(this, Diamond);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(Diamond, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'diamond', 4, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Diamond;
	}(ShapeBase);

	function _createSuper$8(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$8(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$8() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Dot Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var Dot = /*#__PURE__*/function (_ShapeBase) {
	  inherits(Dot, _ShapeBase);

	  var _super = _createSuper$8(Dot);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Dot(options, body, labelModule) {
	    classCallCheck(this, Dot);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(Dot, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'circle', 2, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      // eslint-disable-line no-unused-vars
	      if (ctx) {
	        this.resize(ctx);
	      }

	      return this.options.size;
	    }
	  }]);

	  return Dot;
	}(ShapeBase);

	function _createSuper$9(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$9(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$9() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * Am Ellipse Node/Cluster shape.
	 *
	 * @extends NodeBase
	 */

	var Ellipse = /*#__PURE__*/function (_NodeBase) {
	  inherits(Ellipse, _NodeBase);

	  var _super = _createSuper$9(Ellipse);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Ellipse(options, body, labelModule) {
	    classCallCheck(this, Ellipse);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */


	  createClass(Ellipse, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;

	      if (this.needsRefresh(selected, hover)) {
	        var dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
	        this.height = dimensions.height * 2;
	        this.width = dimensions.width + dimensions.height;
	        this.radius = 0.5 * this.width;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width * 0.5;
	      this.top = y - this.height * 0.5;
	      this.initContextForDraw(ctx, values);
	      drawEllipse(ctx, this.left, this.top, this.width, this.height);
	      this.performFill(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	      this.labelModule.draw(ctx, x, y, selected, hover);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      if (ctx) {
	        this.resize(ctx);
	      }

	      var a = this.width * 0.5;
	      var b = this.height * 0.5;
	      var w = Math.sin(angle) * a;
	      var h = Math.cos(angle) * b;
	      return a * b / Math.sqrt(w * w + h * h);
	    }
	  }]);

	  return Ellipse;
	}(NodeBase);

	function _createSuper$a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$a(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$a() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * An icon replacement for the default Node shape.
	 *
	 * @extends NodeBase
	 */

	var Icon = /*#__PURE__*/function (_NodeBase) {
	  inherits(Icon, _NodeBase);

	  var _super = _createSuper$a(Icon);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Icon(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, Icon);

	    _this = _super.call(this, options, body, labelModule);

	    _this._setMargins(labelModule);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx - Unused.
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */


	  createClass(Icon, [{
	    key: "resize",
	    value: function resize(ctx, selected, hover) {
	      if (this.needsRefresh(selected, hover)) {
	        this.iconSize = {
	          width: Number(this.options.icon.size),
	          height: Number(this.options.icon.size)
	        };
	        this.width = this.iconSize.width + this.margin.right + this.margin.left;
	        this.height = this.iconSize.height + this.margin.top + this.margin.bottom;
	        this.radius = 0.5 * this.width;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.options.icon.size = this.options.icon.size || 50;
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;

	      this._icon(ctx, x, y, selected, hover, values);

	      if (this.options.label !== undefined) {
	        var iconTextSpacing = 5;
	        this.labelModule.draw(ctx, this.left + this.iconSize.width / 2 + this.margin.left, y + this.height / 2 + iconTextSpacing, selected);
	      }

	      this.updateBoundingBox(x, y);
	    }
	    /**
	     *
	     * @param {number} x
	     * @param {number} y
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.boundingBox.top = y - this.options.icon.size * 0.5;
	      this.boundingBox.left = x - this.options.icon.size * 0.5;
	      this.boundingBox.right = x + this.options.icon.size * 0.5;
	      this.boundingBox.bottom = y + this.options.icon.size * 0.5;

	      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
	        var iconTextSpacing = 5;
	        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height + iconTextSpacing);
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover - Unused
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "_icon",
	    value: function _icon(ctx, x, y, selected, hover, values) {
	      var iconSize = Number(this.options.icon.size);

	      if (this.options.icon.code !== undefined) {
	        ctx.font = [this.options.icon.weight != null ? this.options.icon.weight : selected ? "bold" : "", // If the weight is forced (for example to make Font Awesome 5 work
	        // properly) substitute slightly bigger size for bold font face.
	        (this.options.icon.weight != null && selected ? 5 : 0) + iconSize + "px", this.options.icon.face].join(" "); // draw icon

	        ctx.fillStyle = this.options.icon.color || "black";
	        ctx.textAlign = "center";
	        ctx.textBaseline = "middle"; // draw shadow if enabled

	        this.enableShadow(ctx, values);
	        ctx.fillText(this.options.icon.code, x, y); // disable shadows for other elements.

	        this.disableShadow(ctx, values);
	      } else {
	        console.error('When using the icon shape, you need to define the code in the icon options object. This can be done per node or globally.');
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Icon;
	}(NodeBase);

	function _createSuper$b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$b(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$b() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * An image-based replacement for the default Node shape.
	 *
	 * @extends CircleImageBase
	 */

	var Image$1 = /*#__PURE__*/function (_CircleImageBase) {
	  inherits(Image, _CircleImageBase);

	  var _super = _createSuper$b(Image);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   * @param {Image} imageObj
	   * @param {Image} imageObjAlt
	   */
	  function Image(options, body, labelModule, imageObj, imageObjAlt) {
	    var _this;

	    classCallCheck(this, Image);

	    _this = _super.call(this, options, body, labelModule);

	    _this.setImages(imageObj, imageObjAlt);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx - Unused.
	   * @param {boolean} [selected]
	   * @param {boolean} [hover]
	   */


	  createClass(Image, [{
	    key: "resize",
	    value: function resize(ctx) {
	      var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
	      var hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
	      var imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;

	      if (imageAbsent) {
	        var side = this.options.size * 2;
	        this.width = side;
	        this.height = side;
	        return;
	      }

	      if (this.needsRefresh(selected, hover)) {
	        this._resizeImage();
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      ctx.save();
	      this.switchImages(selected);
	      this.resize();
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2;

	      if (this.options.shapeProperties.useBorderWithImage === true) {
	        var neutralborderWidth = this.options.borderWidth;
	        var selectionLineWidth = this.options.borderWidthSelected || 2 * this.options.borderWidth;
	        var borderWidth = (selected ? selectionLineWidth : neutralborderWidth) / this.body.view.scale;
	        ctx.lineWidth = Math.min(this.width, borderWidth);
	        ctx.beginPath();
	        var strokeStyle = selected ? this.options.color.highlight.border : hover ? this.options.color.hover.border : this.options.color.border;
	        var fillStyle = selected ? this.options.color.highlight.background : hover ? this.options.color.hover.background : this.options.color.background;

	        if (values.opacity !== undefined) {
	          strokeStyle = overrideOpacity(strokeStyle, values.opacity);
	          fillStyle = overrideOpacity(fillStyle, values.opacity);
	        } // setup the line properties.


	        ctx.strokeStyle = strokeStyle; // set a fillstyle

	        ctx.fillStyle = fillStyle; // draw a rectangle to form the border around. This rectangle is filled so the opacity of a picture (in future vis releases?) can be used to tint the image

	        ctx.rect(this.left - 0.5 * ctx.lineWidth, this.top - 0.5 * ctx.lineWidth, this.width + ctx.lineWidth, this.height + ctx.lineWidth);

	        fill$2(ctx).call(ctx);

	        this.performStroke(ctx, values);
	        ctx.closePath();
	      }

	      this._drawImageAtPosition(ctx, values);

	      this._drawImageLabel(ctx, x, y, selected, hover);

	      this.updateBoundingBox(x, y);
	      ctx.restore();
	    }
	    /**
	     *
	     * @param {number} x
	     * @param {number} y
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(x, y) {
	      this.resize();

	      this._updateBoundingBox(x, y);

	      if (this.options.label !== undefined && this.labelModule.size.width > 0) {
	        this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
	        this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
	        this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Image;
	}(CircleImageBase);

	function _createSuper$c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$c(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$c() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Square Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var Square = /*#__PURE__*/function (_ShapeBase) {
	  inherits(Square, _ShapeBase);

	  var _super = _createSuper$c(Square);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Square(options, body, labelModule) {
	    classCallCheck(this, Square);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(Square, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'square', 2, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Square;
	}(ShapeBase);

	function _createSuper$d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$d(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$d() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Hexagon Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var Hexagon = /*#__PURE__*/function (_ShapeBase) {
	  inherits(Hexagon, _ShapeBase);

	  var _super = _createSuper$d(Hexagon);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Hexagon(options, body, labelModule) {
	    classCallCheck(this, Hexagon);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(Hexagon, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'hexagon', 4, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Hexagon;
	}(ShapeBase);

	function _createSuper$e(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$e(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$e() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Star Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var Star = /*#__PURE__*/function (_ShapeBase) {
	  inherits(Star, _ShapeBase);

	  var _super = _createSuper$e(Star);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Star(options, body, labelModule) {
	    classCallCheck(this, Star);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x width
	   * @param {number} y height
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(Star, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'star', 4, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Star;
	}(ShapeBase);

	function _createSuper$f(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$f(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$f() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A text-based replacement for the default Node shape.
	 *
	 * @extends NodeBase
	 */

	var Text = /*#__PURE__*/function (_NodeBase) {
	  inherits(Text, _NodeBase);

	  var _super = _createSuper$f(Text);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Text(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, Text);

	    _this = _super.call(this, options, body, labelModule);

	    _this._setMargins(labelModule);

	    return _this;
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {boolean} selected
	   * @param {boolean} hover
	   */


	  createClass(Text, [{
	    key: "resize",
	    value: function resize(ctx, selected, hover) {
	      if (this.needsRefresh(selected, hover)) {
	        this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
	        this.width = this.textSize.width + this.margin.right + this.margin.left;
	        this.height = this.textSize.height + this.margin.top + this.margin.bottom;
	        this.radius = 0.5 * this.width;
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} x width
	     * @param {number} y height
	     * @param {boolean} selected
	     * @param {boolean} hover
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this.resize(ctx, selected, hover);
	      this.left = x - this.width / 2;
	      this.top = y - this.height / 2; // draw shadow if enabled

	      this.enableShadow(ctx, values);
	      this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover); // disable shadows for other elements.

	      this.disableShadow(ctx, values);
	      this.updateBoundingBox(x, y, ctx, selected, hover);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Text;
	}(NodeBase);

	function _createSuper$g(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$g(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$g() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Triangle Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var Triangle = /*#__PURE__*/function (_ShapeBase) {
	  inherits(Triangle, _ShapeBase);

	  var _super = _createSuper$g(Triangle);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function Triangle(options, body, labelModule) {
	    classCallCheck(this, Triangle);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x
	   * @param {number} y
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(Triangle, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'triangle', 3, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return Triangle;
	}(ShapeBase);

	function _createSuper$h(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$h(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$h() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A downward facing Triangle Node/Cluster shape.
	 *
	 * @extends ShapeBase
	 */

	var TriangleDown = /*#__PURE__*/function (_ShapeBase) {
	  inherits(TriangleDown, _ShapeBase);

	  var _super = _createSuper$h(TriangleDown);

	  /**
	   * @param {Object} options
	   * @param {Object} body
	   * @param {Label} labelModule
	   */
	  function TriangleDown(options, body, labelModule) {
	    classCallCheck(this, TriangleDown);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   *
	   * @param {CanvasRenderingContext2D} ctx
	   * @param {number} x
	   * @param {number} y
	   * @param {boolean} selected
	   * @param {boolean} hover
	   * @param {ArrowOptions} values
	   */


	  createClass(TriangleDown, [{
	    key: "draw",
	    value: function draw(ctx, x, y, selected, hover, values) {
	      this._drawShape(ctx, 'triangleDown', 3, x, y, selected, hover, values);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {number} angle
	     * @returns {number}
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this._distanceToBorder(ctx, angle);
	    }
	  }]);

	  return TriangleDown;
	}(ShapeBase);

	var errorFound = false;
	var allOptions;
	var printStyle = 'background: #FFeeee; color: #dd0000';
	/**
	 *  Used to validate options.
	 */

	var Validator = /*#__PURE__*/function () {
	  /**
	   * @ignore
	   */
	  function Validator() {
	    classCallCheck(this, Validator);
	  }
	  /**
	   * Main function to be called
	   * @param {Object} options
	   * @param {Object} referenceOptions
	   * @param {Object} subObject
	   * @returns {boolean}
	   * @static
	   */


	  createClass(Validator, null, [{
	    key: "validate",
	    value: function validate(options, referenceOptions, subObject) {
	      errorFound = false;
	      allOptions = referenceOptions;
	      var usedOptions = referenceOptions;

	      if (subObject !== undefined) {
	        usedOptions = referenceOptions[subObject];
	      }

	      Validator.parse(options, usedOptions, []);
	      return errorFound;
	    }
	    /**
	     * Will traverse an object recursively and check every value
	     * @param {Object} options
	     * @param {Object} referenceOptions
	     * @param {array} path    | where to look for the actual option
	     * @static
	     */

	  }, {
	    key: "parse",
	    value: function parse(options, referenceOptions, path) {
	      for (var option in options) {
	        if (options.hasOwnProperty(option)) {
	          Validator.check(option, options, referenceOptions, path);
	        }
	      }
	    }
	    /**
	     * Check every value. If the value is an object, call the parse function on that object.
	     * @param {string} option
	     * @param {Object} options
	     * @param {Object} referenceOptions
	     * @param {array} path    | where to look for the actual option
	     * @static
	     */

	  }, {
	    key: "check",
	    value: function check(option, options, referenceOptions, path) {
	      if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
	        Validator.getSuggestion(option, referenceOptions, path);
	        return;
	      }

	      var referenceOption = option;
	      var is_object = true;

	      if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
	        // NOTE: This only triggers if the __any__ is in the top level of the options object.
	        //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
	        // TODO: Examine if needed, remove if possible
	        // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
	        referenceOption = '__any__'; // if the any-subgroup is not a predefined object in the configurator,
	        // we do not look deeper into the object.

	        is_object = Validator.getType(options[option]) === 'object';
	      }

	      var refOptionObj = referenceOptions[referenceOption];

	      if (is_object && refOptionObj.__type__ !== undefined) {
	        refOptionObj = refOptionObj.__type__;
	      }

	      Validator.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
	    }
	    /**
	     *
	     * @param {string}  option           | the option property
	     * @param {Object}  options          | The supplied options object
	     * @param {Object}  referenceOptions | The reference options containing all options and their allowed formats
	     * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
	     * @param {string}  refOptionObj     | This is the type object from the reference options
	     * @param {Array}   path             | where in the object is the option
	     * @static
	     */

	  }, {
	    key: "checkFields",
	    value: function checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
	      var log = function log(message) {
	        console.log('%c' + message + Validator.printLocation(path, option), printStyle);
	      };

	      var optionType = Validator.getType(options[option]);
	      var refOptionType = refOptionObj[optionType];

	      if (refOptionType !== undefined) {
	        // if the type is correct, we check if it is supposed to be one of a few select values
	        if (Validator.getType(refOptionType) === 'array' && indexOf$3(refOptionType).call(refOptionType, options[option]) === -1) {
	          log('Invalid option detected in "' + option + '".' + ' Allowed values are:' + Validator.print(refOptionType) + ' not "' + options[option] + '". ');
	          errorFound = true;
	        } else if (optionType === 'object' && referenceOption !== "__any__") {
	          path = copyAndExtendArray(path, option);
	          Validator.parse(options[option], referenceOptions[referenceOption], path);
	        }
	      } else if (refOptionObj['any'] === undefined) {
	        // type of the field is incorrect and the field cannot be any
	        log('Invalid type received for "' + option + '". Expected: ' + Validator.print(keys$3(refOptionObj)) + '. Received [' + optionType + '] "' + options[option] + '"');
	        errorFound = true;
	      }
	    }
	    /**
	     *
	     * @param {Object|boolean|number|string|Array.<number>|Date|Node|Moment|undefined|null} object
	     * @returns {string}
	     * @static
	     */

	  }, {
	    key: "getType",
	    value: function getType(object) {
	      var type = _typeof_1(object);

	      if (type === 'object') {
	        if (object === null) {
	          return 'null';
	        }

	        if (object instanceof Boolean) {
	          return 'boolean';
	        }

	        if (object instanceof Number) {
	          return 'number';
	        }

	        if (object instanceof String) {
	          return 'string';
	        }

	        if (isArray$5(object)) {
	          return 'array';
	        }

	        if (object instanceof Date) {
	          return 'date';
	        }

	        if (object.nodeType !== undefined) {
	          return 'dom';
	        }

	        if (object._isAMomentObject === true) {
	          return 'moment';
	        }

	        return 'object';
	      } else if (type === 'number') {
	        return 'number';
	      } else if (type === 'boolean') {
	        return 'boolean';
	      } else if (type === 'string') {
	        return 'string';
	      } else if (type === undefined) {
	        return 'undefined';
	      }

	      return type;
	    }
	    /**
	     * @param {string} option
	     * @param {Object} options
	     * @param {Array.<string>} path
	     * @static
	     */

	  }, {
	    key: "getSuggestion",
	    value: function getSuggestion(option, options, path) {
	      var localSearch = Validator.findInOptions(option, options, path, false);
	      var globalSearch = Validator.findInOptions(option, allOptions, [], true);
	      var localSearchThreshold = 8;
	      var globalSearchThreshold = 4;
	      var msg;

	      if (localSearch.indexMatch !== undefined) {
	        msg = ' in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
	      } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
	        msg = ' in ' + Validator.printLocation(localSearch.path, option, '') + 'Perhaps it was misplaced? Matching option found at: ' + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, '');
	      } else if (localSearch.distance <= localSearchThreshold) {
	        msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option);
	      } else {
	        msg = '. Did you mean one of these: ' + Validator.print(keys$3(options)) + Validator.printLocation(path, option);
	      }

	      console.log('%cUnknown option detected: "' + option + '"' + msg, printStyle);
	      errorFound = true;
	    }
	    /**
	     * traverse the options in search for a match.
	     * @param {string} option
	     * @param {Object} options
	     * @param {Array} path    | where to look for the actual option
	     * @param {boolean} [recursive=false]
	     * @returns {{closestMatch: string, path: Array, distance: number}}
	     * @static
	     */

	  }, {
	    key: "findInOptions",
	    value: function findInOptions(option, options, path) {
	      var recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
	      var min = 1e9;
	      var closestMatch = '';
	      var closestMatchPath = [];
	      var lowerCaseOption = option.toLowerCase();
	      var indexMatch = undefined;

	      for (var op in options) {
	        // eslint-disable-line guard-for-in
	        var distance = void 0;

	        if (options[op].__type__ !== undefined && recursive === true) {
	          var result = Validator.findInOptions(option, options[op], copyAndExtendArray(path, op));

	          if (min > result.distance) {
	            closestMatch = result.closestMatch;
	            closestMatchPath = result.path;
	            min = result.distance;
	            indexMatch = result.indexMatch;
	          }
	        } else {
	          var _context;

	          if (indexOf$3(_context = op.toLowerCase()).call(_context, lowerCaseOption) !== -1) {
	            indexMatch = op;
	          }

	          distance = Validator.levenshteinDistance(option, op);

	          if (min > distance) {
	            closestMatch = op;
	            closestMatchPath = copyArray(path);
	            min = distance;
	          }
	        }
	      }

	      return {
	        closestMatch: closestMatch,
	        path: closestMatchPath,
	        distance: min,
	        indexMatch: indexMatch
	      };
	    }
	    /**
	     * @param {Array.<string>} path
	     * @param {Object} option
	     * @param {string} prefix
	     * @returns {String}
	     * @static
	     */

	  }, {
	    key: "printLocation",
	    value: function printLocation(path, option) {
	      var prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Problem value found at: \n';
	      var str = '\n\n' + prefix + 'options = {\n';

	      for (var i = 0; i < path.length; i++) {
	        for (var j = 0; j < i + 1; j++) {
	          str += '  ';
	        }

	        str += path[i] + ': {\n';
	      }

	      for (var _j = 0; _j < path.length + 1; _j++) {
	        str += '  ';
	      }

	      str += option + '\n';

	      for (var _i = 0; _i < path.length + 1; _i++) {
	        for (var _j2 = 0; _j2 < path.length - _i; _j2++) {
	          str += '  ';
	        }

	        str += '}\n';
	      }

	      return str + '\n\n';
	    }
	    /**
	     * @param {Object} options
	     * @returns {String}
	     * @static
	     */

	  }, {
	    key: "print",
	    value: function print(options) {
	      return stringify$2(options).replace(/(\")|(\[)|(\])|(,"__type__")/g, "").replace(/(\,)/g, ', ');
	    }
	    /**
	     *  Compute the edit distance between the two given strings
	     * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
	     *
	     * Copyright (c) 2011 Andrei Mackenzie
	     *
	     * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
	     *
	     * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
	     *
	     * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	     *
	     * @param {string} a
	     * @param {string} b
	     * @returns {Array.<Array.<number>>}}
	     * @static
	     */

	  }, {
	    key: "levenshteinDistance",
	    value: function levenshteinDistance(a, b) {
	      if (a.length === 0) return b.length;
	      if (b.length === 0) return a.length;
	      var matrix = []; // increment along the first column of each row

	      var i;

	      for (i = 0; i <= b.length; i++) {
	        matrix[i] = [i];
	      } // increment each column in the first row


	      var j;

	      for (j = 0; j <= a.length; j++) {
	        matrix[0][j] = j;
	      } // Fill in the rest of the matrix


	      for (i = 1; i <= b.length; i++) {
	        for (j = 1; j <= a.length; j++) {
	          if (b.charAt(i - 1) == a.charAt(j - 1)) {
	            matrix[i][j] = matrix[i - 1][j - 1];
	          } else {
	            matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, // substitution
	            Math.min(matrix[i][j - 1] + 1, // insertion
	            matrix[i - 1][j] + 1)); // deletion
	          }
	        }
	      }

	      return matrix[b.length][a.length];
	    }
	  }]);

	  return Validator;
	}();

	function ownKeys$3(object, enumerableOnly) { var keys = keys$3(object); if (getOwnPropertySymbols$2) { var symbols = getOwnPropertySymbols$2(object); if (enumerableOnly) symbols = filter$2(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$3(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context5; forEach$2(_context5 = ownKeys$3(Object(source), true)).call(_context5, function (key) { defineProperty$6(target, key, source[key]); }); } else if (getOwnPropertyDescriptors$2) { defineProperties$1(target, getOwnPropertyDescriptors$2(source)); } else { var _context6; forEach$2(_context6 = ownKeys$3(Object(source))).call(_context6, function (key) { defineProperty$3(target, key, getOwnPropertyDescriptor$3(source, key)); }); } } return target; }
	/**
	 * A node. A node can be connected to other nodes via one or multiple edges.
	 */

	var Node = /*#__PURE__*/function () {
	  /**
	   *
	   * @param {object} options An object containing options for the node. All
	   *                            options are optional, except for the id.
	   *                              {number} id     Id of the node. Required
	   *                              {string} label  Text label for the node
	   *                              {number} x      Horizontal position of the node
	   *                              {number} y      Vertical position of the node
	   *                              {string} shape  Node shape
	   *                              {string} image  An image url
	   *                              {string} title  A title text, can be HTML
	   *                              {anytype} group A group name or number
	   *
	   * @param {Object} body               Shared state of current network instance
	   * @param {Network.Images} imagelist  A list with images. Only needed when the node has an image
	   * @param {Groups} grouplist          A list with groups. Needed for retrieving group options
	   * @param {Object} globalOptions      Current global node options; these serve as defaults for the node instance
	   * @param {Object} defaultOptions     Global default options for nodes; note that this is also the prototype
	   *                                    for parameter `globalOptions`.
	   */
	  function Node(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
	    classCallCheck(this, Node);

	    this.options = bridgeObject(globalOptions);
	    this.globalOptions = globalOptions;
	    this.defaultOptions = defaultOptions;
	    this.body = body;
	    this.edges = []; // all edges connected to this node
	    // set defaults for the options

	    this.id = undefined;
	    this.imagelist = imagelist;
	    this.grouplist = grouplist; // state options

	    this.x = undefined;
	    this.y = undefined;
	    this.baseSize = this.options.size;
	    this.baseFontSize = this.options.font.size;
	    this.predefinedPosition = false; // used to check if initial fit should just take the range or approximate

	    this.selected = false;
	    this.hover = false;
	    this.labelModule = new Label(this.body, this.options, false
	    /* Not edge label */
	    );
	    this.setOptions(options);
	  }
	  /**
	   * Attach a edge to the node
	   * @param {Edge} edge
	   */


	  createClass(Node, [{
	    key: "attachEdge",
	    value: function attachEdge(edge) {
	      var _context;

	      if (indexOf$3(_context = this.edges).call(_context, edge) === -1) {
	        this.edges.push(edge);
	      }
	    }
	    /**
	     * Detach a edge from the node
	     *
	     * @param {Edge} edge
	     */

	  }, {
	    key: "detachEdge",
	    value: function detachEdge(edge) {
	      var _context2;

	      var index = indexOf$3(_context2 = this.edges).call(_context2, edge);

	      if (index != -1) {
	        var _context3;

	        splice$2(_context3 = this.edges).call(_context3, index, 1);
	      }
	    }
	    /**
	     * Set or overwrite options for the node
	     *
	     * @param {Object} options an object with options
	     * @returns {null|boolean}
	     */

	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      var currentShape = this.options.shape;

	      if (!options) {
	        return; // Note that the return value will be 'undefined'! This is OK.
	      } // Save the color for later.
	      // This is necessary in order to prevent local color from being overwritten by group color.
	      // TODO: To prevent such workarounds the way options are handled should be rewritten from scratch.
	      // This is not the only problem with current options handling.


	      if (typeof options.color !== 'undefined') {
	        this._localColor = options.color;
	      } // basic options


	      if (options.id !== undefined) {
	        this.id = options.id;
	      }

	      if (this.id === undefined) {
	        throw new Error("Node must have an id");
	      }

	      Node.checkMass(options, this.id); // set these options locally
	      // clear x and y positions

	      if (options.x !== undefined) {
	        if (options.x === null) {
	          this.x = undefined;
	          this.predefinedPosition = false;
	        } else {
	          this.x = _parseInt$2(options.x);
	          this.predefinedPosition = true;
	        }
	      }

	      if (options.y !== undefined) {
	        if (options.y === null) {
	          this.y = undefined;
	          this.predefinedPosition = false;
	        } else {
	          this.y = _parseInt$2(options.y);
	          this.predefinedPosition = true;
	        }
	      }

	      if (options.size !== undefined) {
	        this.baseSize = options.size;
	      }

	      if (options.value !== undefined) {
	        options.value = _parseFloat$2(options.value);
	      } // this transforms all shorthands into fully defined options


	      Node.parseOptions(this.options, options, true, this.globalOptions, this.grouplist);
	      var pile = [options, this.options, this.defaultOptions];
	      this.chooser = ComponentUtil.choosify('node', pile);

	      this._load_images();

	      this.updateLabelModule(options); // Need to set local opacity after `this.updateLabelModule(options);` because `this.updateLabelModule(options);` overrites local opacity with group opacity

	      if (options.opacity !== undefined && Node.checkOpacity(options.opacity)) {
	        this.options.opacity = options.opacity;
	      }

	      this.updateShape(currentShape);
	      return options.hidden !== undefined || options.physics !== undefined;
	    }
	    /**
	     * Load the images from the options, for the nodes that need them.
	     *
	     * Images are always loaded, even if they are not used in the current shape.
	     * The user may switch to an image shape later on.
	     *
	     * @private
	     */

	  }, {
	    key: "_load_images",
	    value: function _load_images() {
	      if (this.options.shape === 'circularImage' || this.options.shape === 'image') {
	        if (this.options.image === undefined) {
	          throw new Error("Option image must be defined for node type '" + this.options.shape + "'");
	        }
	      }

	      if (this.options.image === undefined) {
	        return;
	      }

	      if (this.imagelist === undefined) {
	        throw new Error("Internal Error: No images provided");
	      }

	      if (typeof this.options.image === 'string') {
	        this.imageObj = this.imagelist.load(this.options.image, this.options.brokenImage, this.id);
	      } else {
	        if (this.options.image.unselected === undefined) {
	          throw new Error("No unselected image provided");
	        }

	        this.imageObj = this.imagelist.load(this.options.image.unselected, this.options.brokenImage, this.id);

	        if (this.options.image.selected !== undefined) {
	          this.imageObjAlt = this.imagelist.load(this.options.image.selected, this.options.brokenImage, this.id);
	        } else {
	          this.imageObjAlt = undefined;
	        }
	      }
	    }
	    /**
	     * Check that opacity is only between 0 and 1
	     * 
	     * @param {Number} opacity 
	     * @returns {boolean}
	     */

	  }, {
	    key: "getFormattingValues",

	    /**
	     *
	     * @returns {{color: *, borderWidth: *, borderColor: *, size: *, borderDashes: (boolean|Array|allOptions.nodes.shapeProperties.borderDashes|{boolean, array}), borderRadius: (number|allOptions.nodes.shapeProperties.borderRadius|{number}|Array), shadow: *, shadowColor: *, shadowSize: *, shadowX: *, shadowY: *}}
	     */
	    value: function getFormattingValues() {
	      var values = {
	        color: this.options.color.background,
	        opacity: this.options.opacity,
	        borderWidth: this.options.borderWidth,
	        borderColor: this.options.color.border,
	        size: this.options.size,
	        borderDashes: this.options.shapeProperties.borderDashes,
	        borderRadius: this.options.shapeProperties.borderRadius,
	        shadow: this.options.shadow.enabled,
	        shadowColor: this.options.shadow.color,
	        shadowSize: this.options.shadow.size,
	        shadowX: this.options.shadow.x,
	        shadowY: this.options.shadow.y
	      };

	      if (this.selected || this.hover) {
	        if (this.chooser === true) {
	          if (this.selected) {
	            values.borderWidth *= 2;
	            values.color = this.options.color.highlight.background;
	            values.borderColor = this.options.color.highlight.border;
	            values.shadow = this.options.shadow.enabled;
	          } else if (this.hover) {
	            values.color = this.options.color.hover.background;
	            values.borderColor = this.options.color.hover.border;
	            values.shadow = this.options.shadow.enabled;
	          }
	        } else if (typeof this.chooser === 'function') {
	          this.chooser(values, this.options.id, this.selected, this.hover);

	          if (values.shadow === false) {
	            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
	              values.shadow = true;
	            }
	          }
	        }
	      } else {
	        values.shadow = this.options.shadow.enabled;
	      }

	      if (this.options.opacity !== undefined) {
	        var opacity = this.options.opacity;
	        values.borderColor = overrideOpacity(values.borderColor, opacity);
	        values.color = overrideOpacity(values.color, opacity);
	        values.shadowColor = overrideOpacity(values.shadowColor, opacity);
	      }

	      return values;
	    }
	    /**
	     *
	     * @param {Object} options
	     */

	  }, {
	    key: "updateLabelModule",
	    value: function updateLabelModule(options) {
	      if (this.options.label === undefined || this.options.label === null) {
	        this.options.label = '';
	      }

	      Node.updateGroupOptions(this.options, _objectSpread$2(_objectSpread$2({}, options), {}, {
	        color: options && options.color || this._localColor || undefined
	      }), this.grouplist); //
	      // Note:The prototype chain for this.options is:
	      //
	      // this.options ->    NodesHandler.options    -> NodesHandler.defaultOptions
	      //                 (also: this.globalOptions)
	      //
	      // Note that the prototypes are mentioned explicitly in the pile list below;
	      // WE DON'T WANT THE ORDER OF THE PROTOTYPES!!!! At least, not for font handling of labels.
	      // This is a good indication that the prototype usage of options is deficient.
	      //

	      var currentGroup = this.grouplist.get(this.options.group, false);
	      var pile = [options, // new options
	      this.options, // current node options, see comment above for prototype
	      currentGroup, // group options, if any
	      this.globalOptions, // Currently set global node options
	      this.defaultOptions // Default global node options
	      ];
	      this.labelModule.update(this.options, pile);

	      if (this.labelModule.baseSize !== undefined) {
	        this.baseFontSize = this.labelModule.baseSize;
	      }
	    }
	    /**
	     *
	     * @param {string} currentShape
	     */

	  }, {
	    key: "updateShape",
	    value: function updateShape(currentShape) {
	      if (currentShape === this.options.shape && this.shape) {
	        this.shape.setOptions(this.options, this.imageObj, this.imageObjAlt);
	      } else {
	        // choose draw method depending on the shape
	        switch (this.options.shape) {
	          case 'box':
	            this.shape = new Box(this.options, this.body, this.labelModule);
	            break;

	          case 'circle':
	            this.shape = new Circle(this.options, this.body, this.labelModule);
	            break;

	          case 'circularImage':
	            this.shape = new CircularImage(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
	            break;

	          case 'database':
	            this.shape = new Database(this.options, this.body, this.labelModule);
	            break;

	          case 'diamond':
	            this.shape = new Diamond(this.options, this.body, this.labelModule);
	            break;

	          case 'dot':
	            this.shape = new Dot(this.options, this.body, this.labelModule);
	            break;

	          case 'ellipse':
	            this.shape = new Ellipse(this.options, this.body, this.labelModule);
	            break;

	          case 'icon':
	            this.shape = new Icon(this.options, this.body, this.labelModule);
	            break;

	          case 'image':
	            this.shape = new Image$1(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
	            break;

	          case 'square':
	            this.shape = new Square(this.options, this.body, this.labelModule);
	            break;

	          case 'hexagon':
	            this.shape = new Hexagon(this.options, this.body, this.labelModule);
	            break;

	          case 'star':
	            this.shape = new Star(this.options, this.body, this.labelModule);
	            break;

	          case 'text':
	            this.shape = new Text(this.options, this.body, this.labelModule);
	            break;

	          case 'triangle':
	            this.shape = new Triangle(this.options, this.body, this.labelModule);
	            break;

	          case 'triangleDown':
	            this.shape = new TriangleDown(this.options, this.body, this.labelModule);
	            break;

	          default:
	            this.shape = new Ellipse(this.options, this.body, this.labelModule);
	            break;
	        }
	      }

	      this.needsRefresh();
	    }
	    /**
	     * select this node
	     */

	  }, {
	    key: "select",
	    value: function select() {
	      this.selected = true;
	      this.needsRefresh();
	    }
	    /**
	     * unselect this node
	     */

	  }, {
	    key: "unselect",
	    value: function unselect() {
	      this.selected = false;
	      this.needsRefresh();
	    }
	    /**
	     * Reset the calculated size of the node, forces it to recalculate its size
	     */

	  }, {
	    key: "needsRefresh",
	    value: function needsRefresh() {
	      this.shape.refreshNeeded = true;
	    }
	    /**
	     * get the title of this node.
	     * @return {string} title    The title of the node, or undefined when no title
	     *                           has been set.
	     */

	  }, {
	    key: "getTitle",
	    value: function getTitle() {
	      return this.options.title;
	    }
	    /**
	     * Calculate the distance to the border of the Node
	     * @param {CanvasRenderingContext2D}   ctx
	     * @param {number} angle        Angle in radians
	     * @returns {number} distance   Distance to the border in pixels
	     */

	  }, {
	    key: "distanceToBorder",
	    value: function distanceToBorder(ctx, angle) {
	      return this.shape.distanceToBorder(ctx, angle);
	    }
	    /**
	     * Check if this node has a fixed x and y position
	     * @return {boolean}      true if fixed, false if not
	     */

	  }, {
	    key: "isFixed",
	    value: function isFixed() {
	      return this.options.fixed.x && this.options.fixed.y;
	    }
	    /**
	     * check if this node is selecte
	     * @return {boolean} selected   True if node is selected, else false
	     */

	  }, {
	    key: "isSelected",
	    value: function isSelected() {
	      return this.selected;
	    }
	    /**
	     * Retrieve the value of the node. Can be undefined
	     * @return {number} value
	     */

	  }, {
	    key: "getValue",
	    value: function getValue() {
	      return this.options.value;
	    }
	    /**
	     * Get the current dimensions of the label
	     *
	     * @return {rect}
	     */

	  }, {
	    key: "getLabelSize",
	    value: function getLabelSize() {
	      return this.labelModule.size();
	    }
	    /**
	     * Adjust the value range of the node. The node will adjust it's size
	     * based on its value.
	     * @param {number} min
	     * @param {number} max
	     * @param {number} total
	     */

	  }, {
	    key: "setValueRange",
	    value: function setValueRange(min, max, total) {
	      if (this.options.value !== undefined) {
	        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
	        var sizeDiff = this.options.scaling.max - this.options.scaling.min;

	        if (this.options.scaling.label.enabled === true) {
	          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
	          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
	        }

	        this.options.size = this.options.scaling.min + scale * sizeDiff;
	      } else {
	        this.options.size = this.baseSize;
	        this.options.font.size = this.baseFontSize;
	      }

	      this.updateLabelModule();
	    }
	    /**
	     * Draw this node in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     * @param {CanvasRenderingContext2D}   ctx
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx) {
	      var values = this.getFormattingValues();
	      this.shape.draw(ctx, this.x, this.y, this.selected, this.hover, values);
	    }
	    /**
	     * Update the bounding box of the shape
	     * @param {CanvasRenderingContext2D}   ctx
	     */

	  }, {
	    key: "updateBoundingBox",
	    value: function updateBoundingBox(ctx) {
	      this.shape.updateBoundingBox(this.x, this.y, ctx);
	    }
	    /**
	     * Recalculate the size of this node in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     * @param {CanvasRenderingContext2D}   ctx
	     */

	  }, {
	    key: "resize",
	    value: function resize(ctx) {
	      var values = this.getFormattingValues();
	      this.shape.resize(ctx, this.selected, this.hover, values);
	    }
	    /**
	     * Determine all visual elements of this node instance, in which the given
	     * point falls within the bounding shape.
	     *
	     * @param {point} point
	     * @returns {Array.<nodeClickItem|nodeLabelClickItem>} list with the items which are on the point
	     */

	  }, {
	    key: "getItemsOnPoint",
	    value: function getItemsOnPoint(point) {
	      var ret = [];

	      if (this.labelModule.visible()) {
	        if (ComponentUtil.pointInRect(this.labelModule.getSize(), point)) {
	          ret.push({
	            nodeId: this.id,
	            labelId: 0
	          });
	        }
	      }

	      if (ComponentUtil.pointInRect(this.shape.boundingBox, point)) {
	        ret.push({
	          nodeId: this.id
	        });
	      }

	      return ret;
	    }
	    /**
	     * Check if this object is overlapping with the provided object
	     * @param {Object} obj   an object with parameters left, top, right, bottom
	     * @return {boolean}     True if location is located on node
	     */

	  }, {
	    key: "isOverlappingWith",
	    value: function isOverlappingWith(obj) {
	      return this.shape.left < obj.right && this.shape.left + this.shape.width > obj.left && this.shape.top < obj.bottom && this.shape.top + this.shape.height > obj.top;
	    }
	    /**
	     * Check if this object is overlapping with the provided object
	     * @param {Object} obj   an object with parameters left, top, right, bottom
	     * @return {boolean}     True if location is located on node
	     */

	  }, {
	    key: "isBoundingBoxOverlappingWith",
	    value: function isBoundingBoxOverlappingWith(obj) {
	      return this.shape.boundingBox.left < obj.right && this.shape.boundingBox.right > obj.left && this.shape.boundingBox.top < obj.bottom && this.shape.boundingBox.bottom > obj.top;
	    }
	    /**
	    * Check valid values for mass
	    *
	    * The mass may not be negative or zero. If it is, reset to 1
	    *
	    * @param {object} options
	    * @param {Node.id} id
	     * @static
	    */

	  }], [{
	    key: "checkOpacity",
	    value: function checkOpacity(opacity) {
	      return 0 <= opacity && opacity <= 1;
	    }
	    /**
	     * Copy group option values into the node options.
	     *
	     * The group options override the global node options, so the copy of group options
	     *  must happen *after* the global node options have been set.
	     *
	     * This method must also be called also if the global node options have changed and the group options did not.
	     *
	     * @param {Object} parentOptions
	     * @param {Object} newOptions  new values for the options, currently only passed in for check
	     * @param {Object} groupList
	     */

	  }, {
	    key: "updateGroupOptions",
	    value: function updateGroupOptions(parentOptions, newOptions, groupList) {
	      var _context4;

	      if (groupList === undefined) return; // No groups, nothing to do

	      var group = parentOptions.group; // paranoia: the selected group is already merged into node options, check.

	      if (newOptions !== undefined && newOptions.group !== undefined && group !== newOptions.group) {
	        throw new Error("updateGroupOptions: group values in options don't match.");
	      }

	      var hasGroup = typeof group === 'number' || typeof group === 'string' && group != '';
	      if (!hasGroup) return; // current node has no group, no need to merge

	      var groupObj = groupList.get(group);

	      if (groupObj.opacity !== undefined && newOptions.opacity === undefined) {
	        if (!Node.checkOpacity(groupObj.opacity)) {
	          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + groupObj.opacity);
	          groupObj.opacity = undefined;
	        }
	      } // Skip any new option to avoid them being overridden by the group options.


	      var skipProperties = filter$2(_context4 = getOwnPropertyNames$2(newOptions)).call(_context4, function (p) {
	        return newOptions[p] != null;
	      }); // Always skip merging group font options into parent; these are required to be distinct for labels


	      skipProperties.push('font');
	      selectiveNotDeepExtend(skipProperties, parentOptions, groupObj); // the color object needs to be completely defined.
	      // Since groups can partially overwrite the colors, we parse it again, just in case.

	      parentOptions.color = parseColor(parentOptions.color);
	    }
	    /**
	     * This process all possible shorthands in the new options and makes sure that the parentOptions are fully defined.
	     * Static so it can also be used by the handler.
	     *
	     * @param {Object} parentOptions
	     * @param {Object} newOptions
	     * @param {boolean} [allowDeletion=false]
	     * @param {Object} [globalOptions={}]
	     * @param {Object} [groupList]
	     * @static
	     */

	  }, {
	    key: "parseOptions",
	    value: function parseOptions(parentOptions, newOptions) {
	      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	      var groupList = arguments.length > 4 ? arguments[4] : undefined;
	      var fields = ['color', 'fixed', 'shadow'];
	      selectiveNotDeepExtend(fields, parentOptions, newOptions, allowDeletion);
	      Node.checkMass(newOptions);

	      if (parentOptions.opacity !== undefined) {
	        if (!Node.checkOpacity(parentOptions.opacity)) {
	          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + parentOptions.opacity);
	          parentOptions.opacity = undefined;
	        }
	      }

	      if (newOptions.opacity !== undefined) {
	        if (!Node.checkOpacity(newOptions.opacity)) {
	          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + newOptions.opacity);
	          newOptions.opacity = undefined;
	        }
	      } // merge the shadow options into the parent.


	      mergeOptions(parentOptions, newOptions, 'shadow', globalOptions); // individual shape newOptions

	      if (newOptions.color !== undefined && newOptions.color !== null) {
	        var parsedColor = parseColor(newOptions.color);
	        fillIfDefined(parentOptions.color, parsedColor);
	      } else if (allowDeletion === true && newOptions.color === null) {
	        parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
	      } // handle the fixed options


	      if (newOptions.fixed !== undefined && newOptions.fixed !== null) {
	        if (typeof newOptions.fixed === 'boolean') {
	          parentOptions.fixed.x = newOptions.fixed;
	          parentOptions.fixed.y = newOptions.fixed;
	        } else {
	          if (newOptions.fixed.x !== undefined && typeof newOptions.fixed.x === 'boolean') {
	            parentOptions.fixed.x = newOptions.fixed.x;
	          }

	          if (newOptions.fixed.y !== undefined && typeof newOptions.fixed.y === 'boolean') {
	            parentOptions.fixed.y = newOptions.fixed.y;
	          }
	        }
	      }

	      if (allowDeletion === true && newOptions.font === null) {
	        parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
	      }

	      Node.updateGroupOptions(parentOptions, newOptions, groupList); // handle the scaling options, specifically the label part

	      if (newOptions.scaling !== undefined) {
	        mergeOptions(parentOptions.scaling, newOptions.scaling, 'label', globalOptions.scaling);
	      }
	    }
	  }, {
	    key: "checkMass",
	    value: function checkMass(options, id) {
	      if (options.mass !== undefined && options.mass <= 0) {
	        var strId = '';

	        if (id !== undefined) {
	          strId = ' in node id: ' + id;
	        }

	        console.log('%cNegative or zero mass disallowed' + strId + ', setting mass to 1.', printStyle);
	        options.mass = 1;
	      }
	    }
	  }]);

	  return Node;
	}();

	function _createForOfIteratorHelper$2(o) { if (typeof symbol$2 === "undefined" || getIteratorMethod$1(o) == null) { if (isArray$5(o) || (o = _unsupportedIterableToArray$3(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = getIterator$1(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

	function _unsupportedIterableToArray$3(o, minLen) { var _context4; if (!o) return; if (typeof o === "string") return _arrayLikeToArray$3(o, minLen); var n = slice$5(_context4 = Object.prototype.toString.call(o)).call(_context4, 8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return from_1$2(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$3(o, minLen); }

	function _arrayLikeToArray$3(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }
	/**
	 * Handler for Nodes
	 */

	var NodesHandler = /*#__PURE__*/function () {
	  /**
	   * @param {Object} body
	   * @param {Images} images
	   * @param {Array.<Group>} groups
	   * @param {LayoutEngine} layoutEngine
	   */
	  function NodesHandler(body, images, groups, layoutEngine) {
	    var _context,
	        _this = this;

	    classCallCheck(this, NodesHandler);

	    this.body = body;
	    this.images = images;
	    this.groups = groups;
	    this.layoutEngine = layoutEngine; // create the node API in the body container

	    this.body.functions.createNode = bind$2(_context = this.create).call(_context, this);
	    this.nodesListeners = {
	      add: function add(event, params) {
	        _this.add(params.items);
	      },
	      update: function update(event, params) {
	        _this.update(params.items, params.data, params.oldData);
	      },
	      remove: function remove(event, params) {
	        _this.remove(params.items);
	      }
	    };
	    this.defaultOptions = {
	      borderWidth: 1,
	      borderWidthSelected: 2,
	      brokenImage: undefined,
	      color: {
	        border: '#2B7CE9',
	        background: '#97C2FC',
	        highlight: {
	          border: '#2B7CE9',
	          background: '#D2E5FF'
	        },
	        hover: {
	          border: '#2B7CE9',
	          background: '#D2E5FF'
	        }
	      },
	      opacity: undefined,
	      // number between 0 and 1
	      fixed: {
	        x: false,
	        y: false
	      },
	      font: {
	        color: '#343434',
	        size: 14,
	        // px
	        face: 'arial',
	        background: 'none',
	        strokeWidth: 0,
	        // px
	        strokeColor: '#ffffff',
	        align: 'center',
	        vadjust: 0,
	        multi: false,
	        bold: {
	          mod: 'bold'
	        },
	        boldital: {
	          mod: 'bold italic'
	        },
	        ital: {
	          mod: 'italic'
	        },
	        mono: {
	          mod: '',
	          size: 15,
	          // px
	          face: 'monospace',
	          vadjust: 2
	        }
	      },
	      group: undefined,
	      hidden: false,
	      icon: {
	        face: 'FontAwesome',
	        //'FontAwesome',
	        code: undefined,
	        //'\uf007',
	        size: 50,
	        //50,
	        color: '#2B7CE9' //'#aa00ff'

	      },
	      image: undefined,
	      // --> URL
	      imagePadding: {
	        // only for image shape
	        top: 0,
	        right: 0,
	        bottom: 0,
	        left: 0
	      },
	      label: undefined,
	      labelHighlightBold: true,
	      level: undefined,
	      margin: {
	        top: 5,
	        right: 5,
	        bottom: 5,
	        left: 5
	      },
	      mass: 1,
	      physics: true,
	      scaling: {
	        min: 10,
	        max: 30,
	        label: {
	          enabled: false,
	          min: 14,
	          max: 30,
	          maxVisible: 30,
	          drawThreshold: 5
	        },
	        customScalingFunction: function customScalingFunction(min, max, total, value) {
	          if (max === min) {
	            return 0.5;
	          } else {
	            var scale = 1 / (max - min);
	            return Math.max(0, (value - min) * scale);
	          }
	        }
	      },
	      shadow: {
	        enabled: false,
	        color: 'rgba(0,0,0,0.5)',
	        size: 10,
	        x: 5,
	        y: 5
	      },
	      shape: 'ellipse',
	      shapeProperties: {
	        borderDashes: false,
	        // only for borders
	        borderRadius: 6,
	        // only for box shape
	        interpolation: true,
	        // only for image and circularImage shapes
	        useImageSize: false,
	        // only for image and circularImage shapes
	        useBorderWithImage: false // only for image shape

	      },
	      size: 25,
	      title: undefined,
	      value: undefined,
	      x: undefined,
	      y: undefined
	    }; // Protect from idiocy

	    if (this.defaultOptions.mass <= 0) {
	      throw 'Internal error: mass in defaultOptions of NodesHandler may not be zero or negative';
	    }

	    this.options = bridgeObject(this.defaultOptions);
	    this.bindEventListeners();
	  }
	  /**
	   * Binds event listeners
	   */


	  createClass(NodesHandler, [{
	    key: "bindEventListeners",
	    value: function bindEventListeners() {
	      var _context2,
	          _context3,
	          _this2 = this;

	      // refresh the nodes. Used when reverting from hierarchical layout
	      this.body.emitter.on('refreshNodes', bind$2(_context2 = this.refresh).call(_context2, this));
	      this.body.emitter.on('refresh', bind$2(_context3 = this.refresh).call(_context3, this));
	      this.body.emitter.on('destroy', function () {
	        forEach$3(_this2.nodesListeners, function (callback, event) {
	          if (_this2.body.data.nodes) _this2.body.data.nodes.off(event, callback);
	        });
	        delete _this2.body.functions.createNode;
	        delete _this2.nodesListeners.add;
	        delete _this2.nodesListeners.update;
	        delete _this2.nodesListeners.remove;
	        delete _this2.nodesListeners;
	      });
	    }
	    /**
	     *
	     * @param {Object} options
	     */

	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        Node.parseOptions(this.options, options); // Need to set opacity here because Node.parseOptions is also used for groups,
	        // if you set opacity in Node.parseOptions it overwrites group opacity.

	        if (options.opacity !== undefined) {
	          if (isNan$2(options.opacity) || !_isFinite$2(options.opacity) || options.opacity < 0 || options.opacity > 1) {
	            console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + options.opacity);
	          } else {
	            this.options.opacity = options.opacity;
	          }
	        } // update the shape in all nodes


	        if (options.shape !== undefined) {
	          for (var nodeId in this.body.nodes) {
	            if (this.body.nodes.hasOwnProperty(nodeId)) {
	              this.body.nodes[nodeId].updateShape();
	            }
	          }
	        } // Update the labels of nodes if any relevant options changed.


	        if (typeof options.font !== "undefined" || typeof options.widthConstraint !== "undefined" || typeof options.heightConstraint !== "undefined") {
	          for (var _i = 0, _Object$keys = keys$3(this.body.nodes); _i < _Object$keys.length; _i++) {
	            var _nodeId = _Object$keys[_i];

	            this.body.nodes[_nodeId].updateLabelModule();

	            this.body.nodes[_nodeId].needsRefresh();
	          }
	        } // update the shape size in all nodes


	        if (options.size !== undefined) {
	          for (var _nodeId2 in this.body.nodes) {
	            if (this.body.nodes.hasOwnProperty(_nodeId2)) {
	              this.body.nodes[_nodeId2].needsRefresh();
	            }
	          }
	        } // update the state of the variables if needed


	        if (options.hidden !== undefined || options.physics !== undefined) {
	          this.body.emitter.emit('_dataChanged');
	        }
	      }
	    }
	    /**
	     * Set a data set with nodes for the network
	     * @param {Array | DataSet | DataView} nodes         The data containing the nodes.
	     * @param {boolean} [doNotEmit=false]
	     * @private
	     */

	  }, {
	    key: "setData",
	    value: function setData(nodes) {
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var oldNodesData = this.body.data.nodes;

	      if (nodes instanceof DataSet || nodes instanceof DataView) {
	        this.body.data.nodes = nodes;
	      } else if (isArray$5(nodes)) {
	        this.body.data.nodes = new DataSet();
	        this.body.data.nodes.add(nodes);
	      } else if (!nodes) {
	        this.body.data.nodes = new DataSet();
	      } else {
	        throw new TypeError('Array or DataSet expected');
	      }

	      if (oldNodesData) {
	        // unsubscribe from old dataset
	        forEach$3(this.nodesListeners, function (callback, event) {
	          oldNodesData.off(event, callback);
	        });
	      } // remove drawn nodes


	      this.body.nodes = {};

	      if (this.body.data.nodes) {
	        // subscribe to new dataset
	        var me = this;
	        forEach$3(this.nodesListeners, function (callback, event) {
	          me.body.data.nodes.on(event, callback);
	        }); // draw all new nodes

	        var ids = this.body.data.nodes.getIds();
	        this.add(ids, true);
	      }

	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }
	    /**
	     * Add nodes
	     * @param {number[] | string[]} ids
	     * @param {boolean} [doNotEmit=false]
	     * @private
	     */

	  }, {
	    key: "add",
	    value: function add(ids) {
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var id;
	      var newNodes = [];

	      for (var i = 0; i < ids.length; i++) {
	        id = ids[i];
	        var properties = this.body.data.nodes.get(id);
	        var node = this.create(properties);
	        newNodes.push(node);
	        this.body.nodes[id] = node; // note: this may replace an existing node
	      }

	      this.layoutEngine.positionInitially(newNodes);

	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }
	    /**
	     * Update existing nodes, or create them when not yet existing
	     * @param {number[] | string[]} ids id's of changed nodes
	     * @param {Array} changedData array with changed data
	     * @param {Array|undefined} oldData optional; array with previous data
	     * @private
	     */

	  }, {
	    key: "update",
	    value: function update(ids, changedData, oldData) {
	      var nodes = this.body.nodes;
	      var dataChanged = false;

	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        var node = nodes[id];
	        var data = changedData[i];

	        if (node !== undefined) {
	          // update node
	          if (node.setOptions(data)) {
	            dataChanged = true;
	          }
	        } else {
	          dataChanged = true; // create node

	          node = this.create(data);
	          nodes[id] = node;
	        }
	      }

	      if (!dataChanged && oldData !== undefined) {
	        // Check for any changes which should trigger a layout recalculation
	        // For now, this is just 'level' for hierarchical layout
	        // Assumption: old and new data arranged in same order; at time of writing, this holds.
	        dataChanged = some$2(changedData).call(changedData, function (newValue, index) {
	          var oldValue = oldData[index];
	          return oldValue && oldValue.level !== newValue.level;
	        });
	      }

	      if (dataChanged === true) {
	        this.body.emitter.emit("_dataChanged");
	      } else {
	        this.body.emitter.emit("_dataUpdated");
	      }
	    }
	    /**
	     * Remove existing nodes. If nodes do not exist, the method will just ignore it.
	     * @param {number[] | string[]} ids
	     * @private
	     */

	  }, {
	    key: "remove",
	    value: function remove(ids) {
	      var nodes = this.body.nodes;

	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        delete nodes[id];
	      }

	      this.body.emitter.emit("_dataChanged");
	    }
	    /**
	     * create a node
	     * @param {Object} properties
	     * @param {class} [constructorClass=Node.default]
	     * @returns {*}
	     */

	  }, {
	    key: "create",
	    value: function create(properties) {
	      var constructorClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Node;
	      return new constructorClass(properties, this.body, this.images, this.groups, this.options, this.defaultOptions);
	    }
	    /**
	     *
	     * @param {boolean} [clearPositions=false]
	     */

	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var _this3 = this;

	      var clearPositions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
	      forEach$3(this.body.nodes, function (node, nodeId) {
	        var data = _this3.body.data.nodes.get(nodeId);

	        if (data !== undefined) {
	          if (clearPositions === true) {
	            node.setOptions({
	              x: null,
	              y: null
	            });
	          }

	          node.setOptions({
	            fixed: false
	          });
	          node.setOptions(data);
	        }
	      });
	    }
	    /**
	     * Returns the positions of the nodes.
	     * @param {Array.<Node.id>|String} [ids]  --> optional, can be array of nodeIds, can be string
	     * @returns {{}}
	     */

	  }, {
	    key: "getPositions",
	    value: function getPositions(ids) {
	      var dataArray = {};

	      if (ids !== undefined) {
	        if (isArray$5(ids) === true) {
	          for (var i = 0; i < ids.length; i++) {
	            if (this.body.nodes[ids[i]] !== undefined) {
	              var node = this.body.nodes[ids[i]];
	              dataArray[ids[i]] = {
	                x: Math.round(node.x),
	                y: Math.round(node.y)
	              };
	            }
	          }
	        } else {
	          if (this.body.nodes[ids] !== undefined) {
	            var _node = this.body.nodes[ids];
	            dataArray[ids] = {
	              x: Math.round(_node.x),
	              y: Math.round(_node.y)
	            };
	          }
	        }
	      } else {
	        for (var _i2 = 0; _i2 < this.body.nodeIndices.length; _i2++) {
	          var _node2 = this.body.nodes[this.body.nodeIndices[_i2]];
	          dataArray[this.body.nodeIndices[_i2]] = {
	            x: Math.round(_node2.x),
	            y: Math.round(_node2.y)
	          };
	        }
	      }

	      return dataArray;
	    }
	    /**
	     * Retrieves the x y position of a specific id.
	     * @param {string} id The id to retrieve.
	     * @throws {TypeError} If no id is included.
	     * @throws {ReferenceError} If an invalid id is provided.
	     */

	  }, {
	    key: "getPosition",
	    value: function getPosition(id) {
	      if (id == undefined) {
	        throw new TypeError("No id was specified for getPosition method.");
	      } else if (this.body.nodes[id] == undefined) {
	        throw new ReferenceError("NodeId provided for getPosition does not exist. Provided: ".concat(id));
	      } else {
	        return {
	          x: Math.round(this.body.nodes[id].x),
	          y: Math.round(this.body.nodes[id].y)
	        };
	      }
	    }
	    /**
	     * Load the XY positions of the nodes into the dataset.
	     */

	  }, {
	    key: "storePositions",
	    value: function storePositions() {
	      // todo: add support for clusters and hierarchical.
	      var dataArray = [];
	      var dataset = this.body.data.nodes.getDataSet();

	      var _iterator = _createForOfIteratorHelper$2(dataset.get()),
	          _step;

	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var dsNode = _step.value;
	          var id = dsNode.id;
	          var bodyNode = this.body.nodes[id];
	          var x = Math.round(bodyNode.x);
	          var y = Math.round(bodyNode.y);

	          if (dsNode.x !== x || dsNode.y !== y) {
	            dataArray.push({
	              id: id,
	              x: x,
	              y: y
	            });
	          }
	        }
	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }

	      dataset.update(dataArray);
	    }
	    /**
	     * get the bounding box of a node.
	     * @param {Node.id} nodeId
	     * @returns {j|*}
	     */

	  }, {
	    key: "getBoundingBox",
	    value: function getBoundingBox(nodeId) {
	      if (this.body.nodes[nodeId] !== undefined) {
	        return this.body.nodes[nodeId].shape.boundingBox;
	      }
	    }
	    /**
	     * Get the Ids of nodes connected to this node.
	     * @param {Node.id} nodeId
	     * @param {'to'|'from'|undefined} direction values 'from' and 'to' select respectively parent and child nodes only.
	     *                                          Any other value returns both parent and child nodes.
	     * @returns {Array}
	     */

	  }, {
	    key: "getConnectedNodes",
	    value: function getConnectedNodes(nodeId, direction) {
	      var nodeList = [];

	      if (this.body.nodes[nodeId] !== undefined) {
	        var node = this.body.nodes[nodeId];
	        var nodeObj = {}; // used to quickly check if node already exists

	        for (var i = 0; i < node.edges.length; i++) {
	          var edge = node.edges[i];

	          if (direction !== 'to' && edge.toId == node.id) {
	            // these are double equals since ids can be numeric or string
	            if (nodeObj[edge.fromId] === undefined) {
	              nodeList.push(edge.fromId);
	              nodeObj[edge.fromId] = true;
	            }
	          } else if (direction !== 'from' && edge.fromId == node.id) {
	            // these are double equals since ids can be numeric or string
	            if (nodeObj[edge.toId] === undefined) {
	              nodeList.push(edge.toId);
	              nodeObj[edge.toId] = true;
	            }
	          }
	        }
	      }

	      return nodeList;
	    }
	    /**
	     * Get the ids of the edges connected to this node.
	     * @param {Node.id} nodeId
	     * @returns {*}
	     */

	  }, {
	    key: "getConnectedEdges",
	    value: function getConnectedEdges(nodeId) {
	      var edgeList = [];

	      if (this.body.nodes[nodeId] !== undefined) {
	        var node = this.body.nodes[nodeId];

	        for (var i = 0; i < node.edges.length; i++) {
	          edgeList.push(node.edges[i].id);
	        }
	      } else {
	        console.log("NodeId provided for getConnectedEdges does not exist. Provided: ", nodeId);
	      }

	      return edgeList;
	    }
	    /**
	     * Move a node.
	     *
	     * @param {Node.id} nodeId
	     * @param {number} x
	     * @param {number} y
	     */

	  }, {
	    key: "moveNode",
	    value: function moveNode(nodeId, x, y) {
	      var _this4 = this;

	      if (this.body.nodes[nodeId] !== undefined) {
	        this.body.nodes[nodeId].x = Number(x);
	        this.body.nodes[nodeId].y = Number(y);

	        setTimeout$2(function () {
	          _this4.body.emitter.emit("startSimulation");
	        }, 0);
	      } else {
	        console.log("Node id supplied to moveNode does not exist. Provided: ", nodeId);
	      }
	    }
	  }]);

	  return NodesHandler;
	}();

	var getOwnPropertyDescriptor$4 = getOwnPropertyDescriptor_1;

	var getOwnPropertyDescriptor$5 = getOwnPropertyDescriptor$4;

	// https://tc39.github.io/ecma262/#sec-reflect.get

	function get$1(target, propertyKey
	/* , receiver */
	) {
	  var receiver = arguments.length < 3 ? target : arguments[2];
	  var descriptor, prototype;
	  if (anObject(target) === receiver) return target[propertyKey];
	  if (descriptor = objectGetOwnPropertyDescriptor.f(target, propertyKey)) return has(descriptor, 'value') ? descriptor.value : descriptor.get === undefined ? undefined : descriptor.get.call(receiver);
	  if (isObject(prototype = objectGetPrototypeOf(target))) return get$1(prototype, propertyKey, receiver);
	}

	_export({
	  target: 'Reflect',
	  stat: true
	}, {
	  get: get$1
	});

	var get$2 = path.Reflect.get;

	var get$3 = get$2;

	var get$4 = get$3;

	function _superPropBase(object, property) {
	  while (!Object.prototype.hasOwnProperty.call(object, property)) {
	    object = getPrototypeOf$5(object);
	    if (object === null) break;
	  }

	  return object;
	}

	var superPropBase = _superPropBase;

	var get$5 = createCommonjsModule(function (module) {
	  function _get(target, property, receiver) {
	    if (typeof Reflect !== "undefined" && get$4) {
	      module.exports = _get = get$4;
	    } else {
	      module.exports = _get = function _get(target, property, receiver) {
	        var base = superPropBase(target, property);
	        if (!base) return;

	        var desc = getOwnPropertyDescriptor$5(base, property);

	        if (desc.get) {
	          return desc.get.call(receiver);
	        }

	        return desc.value;
	      };
	    }

	    return _get(target, property, receiver || target);
	  }

	  module.exports = _get;
	});

	var $hypot = Math.hypot;
	var abs$1 = Math.abs;
	var sqrt = Math.sqrt; // Chrome 77 bug
	// https://bugs.chromium.org/p/v8/issues/detail?id=9546

	var BUGGY = !!$hypot && $hypot(Infinity, NaN) !== Infinity; // `Math.hypot` method
	// https://tc39.github.io/ecma262/#sec-math.hypot

	_export({
	  target: 'Math',
	  stat: true,
	  forced: BUGGY
	}, {
	  hypot: function hypot(value1, value2) {
	    // eslint-disable-line no-unused-vars
	    var sum = 0;
	    var i = 0;
	    var aLen = arguments.length;
	    var larg = 0;
	    var arg, div;

	    while (i < aLen) {
	      arg = abs$1(arguments[i++]);

	      if (larg < arg) {
	        div = larg / arg;
	        sum = sum * div * div + 1;
	        larg = arg;
	      } else if (arg > 0) {
	        div = arg / larg;
	        sum += div * div;
	      } else sum += arg;
	    }

	    return larg === Infinity ? Infinity : larg * sqrt(sum);
	  }
	});

	var hypot = path.Math.hypot;

	var hypot$1 = hypot;

	var hypot$2 = hypot$1;

	function _createSuper$i(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$i(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$i() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * Common methods for endpoints
	 *
	 * @class
	 */

	var EndPoint = /*#__PURE__*/function () {
	  function EndPoint() {
	    classCallCheck(this, EndPoint);
	  }

	  createClass(EndPoint, null, [{
	    key: "transform",

	    /**
	     * Apply transformation on points for display.
	     *
	     * The following is done:
	     * - rotate by the specified angle
	     * - multiply the (normalized) coordinates by the passed length
	     * - offset by the target coordinates
	     *
	     * @param points - The point(s) to be transformed.
	     * @param arrowData - The data determining the result of the transformation.
	     */
	    value: function transform(points, arrowData) {
	      if (!isArray$5(points)) {
	        points = [points];
	      }

	      var x = arrowData.point.x;
	      var y = arrowData.point.y;
	      var angle = arrowData.angle;
	      var length = arrowData.length;

	      for (var i = 0; i < points.length; ++i) {
	        var p = points[i];
	        var xt = p.x * Math.cos(angle) - p.y * Math.sin(angle);
	        var yt = p.x * Math.sin(angle) + p.y * Math.cos(angle);
	        p.x = x + length * xt;
	        p.y = y + length * yt;
	      }
	    }
	    /**
	     * Draw a closed path using the given real coordinates.
	     *
	     * @param ctx - The path will be rendered into this context.
	     * @param points - The points of the path.
	     */

	  }, {
	    key: "drawPath",
	    value: function drawPath(ctx, points) {
	      ctx.beginPath();
	      ctx.moveTo(points[0].x, points[0].y);

	      for (var i = 1; i < points.length; ++i) {
	        ctx.lineTo(points[i].x, points[i].y);
	      }

	      ctx.closePath();
	    }
	  }]);

	  return EndPoint;
	}();
	/**
	 * Drawing methods for the arrow endpoint.
	 */


	var Image$2 = /*#__PURE__*/function (_EndPoint) {
	  inherits(Image, _EndPoint);

	  var _super = _createSuper$i(Image);

	  function Image() {
	    classCallCheck(this, Image);

	    return _super.apply(this, arguments);
	  }

	  createClass(Image, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns False as there is no way to fill an image.
	     */
	    value: function draw(ctx, arrowData) {
	      if (arrowData.image) {
	        ctx.save();
	        ctx.translate(arrowData.point.x, arrowData.point.y);
	        ctx.rotate(Math.PI / 2 + arrowData.angle);
	        var width = arrowData.imageWidth != null ? arrowData.imageWidth : arrowData.image.width;
	        var height = arrowData.imageHeight != null ? arrowData.imageHeight : arrowData.image.height;
	        arrowData.image.drawImageAtPosition(ctx, 1, // scale
	        -width / 2, // x
	        0, // y
	        width, height);
	        ctx.restore();
	      }

	      return false;
	    }
	  }]);

	  return Image;
	}(EndPoint);
	/**
	 * Drawing methods for the arrow endpoint.
	 */


	var Arrow = /*#__PURE__*/function (_EndPoint2) {
	  inherits(Arrow, _EndPoint2);

	  var _super2 = _createSuper$i(Arrow);

	  function Arrow() {
	    classCallCheck(this, Arrow);

	    return _super2.apply(this, arguments);
	  }

	  createClass(Arrow, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: 0,
	        y: 0
	      }, {
	        x: -1,
	        y: 0.3
	      }, {
	        x: -0.9,
	        y: 0
	      }, {
	        x: -1,
	        y: -0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Arrow;
	}(EndPoint);
	/**
	 * Drawing methods for the crow endpoint.
	 */


	var Crow = /*#__PURE__*/function () {
	  function Crow() {
	    classCallCheck(this, Crow);
	  }

	  createClass(Crow, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: -1,
	        y: 0
	      }, {
	        x: 0,
	        y: 0.3
	      }, {
	        x: -0.4,
	        y: 0
	      }, {
	        x: 0,
	        y: -0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Crow;
	}();
	/**
	 * Drawing methods for the curve endpoint.
	 */


	var Curve = /*#__PURE__*/function () {
	  function Curve() {
	    classCallCheck(this, Curve);
	  }

	  createClass(Curve, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var point = {
	        x: -0.4,
	        y: 0
	      };
	      EndPoint.transform(point, arrowData); // Update endpoint style for drawing transparent arc.

	      ctx.strokeStyle = ctx.fillStyle;
	      ctx.fillStyle = "rgba(0, 0, 0, 0)"; // Define curve endpoint as semicircle.

	      var pi = Math.PI;
	      var startAngle = arrowData.angle - pi / 2;
	      var endAngle = arrowData.angle + pi / 2;
	      ctx.beginPath();
	      ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
	      ctx.stroke();
	      return true;
	    }
	  }]);

	  return Curve;
	}();
	/**
	 * Drawing methods for the inverted curve endpoint.
	 */


	var InvertedCurve = /*#__PURE__*/function () {
	  function InvertedCurve() {
	    classCallCheck(this, InvertedCurve);
	  }

	  createClass(InvertedCurve, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var point = {
	        x: -0.3,
	        y: 0
	      };
	      EndPoint.transform(point, arrowData); // Update endpoint style for drawing transparent arc.

	      ctx.strokeStyle = ctx.fillStyle;
	      ctx.fillStyle = "rgba(0, 0, 0, 0)"; // Define inverted curve endpoint as semicircle.

	      var pi = Math.PI;
	      var startAngle = arrowData.angle + pi / 2;
	      var endAngle = arrowData.angle + 3 * pi / 2;
	      ctx.beginPath();
	      ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
	      ctx.stroke();
	      return true;
	    }
	  }]);

	  return InvertedCurve;
	}();
	/**
	 * Drawing methods for the trinagle endpoint.
	 */


	var Triangle$1 = /*#__PURE__*/function () {
	  function Triangle() {
	    classCallCheck(this, Triangle);
	  }

	  createClass(Triangle, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: 0.02,
	        y: 0
	      }, {
	        x: -1,
	        y: 0.3
	      }, {
	        x: -1,
	        y: -0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Triangle;
	}();
	/**
	 * Drawing methods for the inverted trinagle endpoint.
	 */


	var InvertedTriangle = /*#__PURE__*/function () {
	  function InvertedTriangle() {
	    classCallCheck(this, InvertedTriangle);
	  }

	  createClass(InvertedTriangle, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: 0,
	        y: 0.3
	      }, {
	        x: 0,
	        y: -0.3
	      }, {
	        x: -1,
	        y: 0
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return InvertedTriangle;
	}();
	/**
	 * Drawing methods for the circle endpoint.
	 */


	var Circle$1 = /*#__PURE__*/function () {
	  function Circle() {
	    classCallCheck(this, Circle);
	  }

	  createClass(Circle, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      var point = {
	        x: -0.4,
	        y: 0
	      };
	      EndPoint.transform(point, arrowData);
	      drawCircle(ctx, point.x, point.y, arrowData.length * 0.4);
	      return true;
	    }
	  }]);

	  return Circle;
	}();
	/**
	 * Drawing methods for the bar endpoint.
	 */


	var Bar = /*#__PURE__*/function () {
	  function Bar() {
	    classCallCheck(this, Bar);
	  }

	  createClass(Bar, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      /*
	      var points = [
	        {x:0, y:0.5},
	        {x:0, y:-0.5}
	      ];
	           EndPoint.transform(points, arrowData);
	      ctx.beginPath();
	      ctx.moveTo(points[0].x, points[0].y);
	      ctx.lineTo(points[1].x, points[1].y);
	      ctx.stroke();
	      */
	      var points = [{
	        x: 0,
	        y: 0.5
	      }, {
	        x: 0,
	        y: -0.5
	      }, {
	        x: -0.15,
	        y: -0.5
	      }, {
	        x: -0.15,
	        y: 0.5
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Bar;
	}();
	/**
	 * Drawing methods for the box endpoint.
	 */


	var Box$1 = /*#__PURE__*/function () {
	  function Box() {
	    classCallCheck(this, Box);
	  }

	  createClass(Box, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      var points = [{
	        x: 0,
	        y: 0.3
	      }, {
	        x: 0,
	        y: -0.3
	      }, {
	        x: -0.6,
	        y: -0.3
	      }, {
	        x: -0.6,
	        y: 0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Box;
	}();
	/**
	 * Drawing methods for the diamond endpoint.
	 */


	var Diamond$1 = /*#__PURE__*/function () {
	  function Diamond() {
	    classCallCheck(this, Diamond);
	  }

	  createClass(Diamond, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      var points = [{
	        x: 0,
	        y: 0
	      }, {
	        x: -0.5,
	        y: -0.3
	      }, {
	        x: -1,
	        y: 0
	      }, {
	        x: -0.5,
	        y: 0.3
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Diamond;
	}();
	/**
	 * Drawing methods for the vee endpoint.
	 */


	var Vee = /*#__PURE__*/function () {
	  function Vee() {
	    classCallCheck(this, Vee);
	  }

	  createClass(Vee, null, [{
	    key: "draw",

	    /**
	     * Draw this shape at the end of a line.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True because ctx.fill() can be used to fill the arrow.
	     */
	    value: function draw(ctx, arrowData) {
	      // Normalized points of closed path, in the order that they should be drawn.
	      // (0, 0) is the attachment point, and the point around which should be rotated
	      var points = [{
	        x: -1,
	        y: 0.3
	      }, {
	        x: -0.5,
	        y: 0
	      }, {
	        x: -1,
	        y: -0.3
	      }, {
	        x: 0,
	        y: 0
	      }];
	      EndPoint.transform(points, arrowData);
	      EndPoint.drawPath(ctx, points);
	      return true;
	    }
	  }]);

	  return Vee;
	}();
	/**
	 * Drawing methods for the endpoints.
	 */


	var EndPoints = /*#__PURE__*/function () {
	  function EndPoints() {
	    classCallCheck(this, EndPoints);
	  }

	  createClass(EndPoints, null, [{
	    key: "draw",

	    /**
	     * Draw an endpoint.
	     *
	     * @param ctx - The shape will be rendered into this context.
	     * @param arrowData - The data determining the shape.
	     *
	     * @returns True if ctx.fill() can be used to fill the arrow, false otherwise.
	     */
	    value: function draw(ctx, arrowData) {
	      var type;

	      if (arrowData.type) {
	        type = arrowData.type.toLowerCase();
	      }

	      switch (type) {
	        case "image":
	          return Image$2.draw(ctx, arrowData);

	        case "circle":
	          return Circle$1.draw(ctx, arrowData);

	        case "box":
	          return Box$1.draw(ctx, arrowData);

	        case "crow":
	          return Crow.draw(ctx, arrowData);

	        case "curve":
	          return Curve.draw(ctx, arrowData);

	        case "diamond":
	          return Diamond$1.draw(ctx, arrowData);

	        case "inv_curve":
	          return InvertedCurve.draw(ctx, arrowData);

	        case "triangle":
	          return Triangle$1.draw(ctx, arrowData);

	        case "inv_triangle":
	          return InvertedTriangle.draw(ctx, arrowData);

	        case "bar":
	          return Bar.draw(ctx, arrowData);

	        case "vee":
	          return Vee.draw(ctx, arrowData);

	        case "arrow": // fall-through

	        default:
	          return Arrow.draw(ctx, arrowData);
	      }
	    }
	  }]);

	  return EndPoints;
	}();

	function ownKeys$4(object, enumerableOnly) { var keys = keys$3(object); if (getOwnPropertySymbols$2) { var symbols = getOwnPropertySymbols$2(object); if (enumerableOnly) symbols = filter$2(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$3(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$3(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context2; forEach$2(_context2 = ownKeys$4(Object(source), true)).call(_context2, function (key) { defineProperty$6(target, key, source[key]); }); } else if (getOwnPropertyDescriptors$2) { defineProperties$1(target, getOwnPropertyDescriptors$2(source)); } else { var _context3; forEach$2(_context3 = ownKeys$4(Object(source))).call(_context3, function (key) { defineProperty$3(target, key, getOwnPropertyDescriptor$3(source, key)); }); } } return target; }
	/**
	 * The Base Class for all edges.
	 */

	var EdgeBase = /*#__PURE__*/function () {
	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param _body - The body of the network.
	   * @param _labelModule - Label module.
	   */
	  function EdgeBase(options, _body, _labelModule) {
	    classCallCheck(this, EdgeBase);

	    this._body = _body;
	    this._labelModule = _labelModule;
	    this.color = {};
	    this.colorDirty = true;
	    this.hoverWidth = 1.5;
	    this.selectionWidth = 2;
	    this.setOptions(options);
	    this.fromPoint = this.from;
	    this.toPoint = this.to;
	  }
	  /** @inheritdoc */


	  createClass(EdgeBase, [{
	    key: "connect",
	    value: function connect() {
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];
	    }
	    /** @inheritdoc */

	  }, {
	    key: "cleanup",
	    value: function cleanup() {
	      return false;
	    }
	    /**
	     * Set new edge options.
	     *
	     * @param options - The new edge options object.
	     */

	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];
	      this.id = this.options.id;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "drawLine",
	    value: function drawLine(ctx, values, _selected, _hover) {
	      var viaNode = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : this.getViaNode();
	      // set style
	      ctx.strokeStyle = this.getColor(ctx, values);
	      ctx.lineWidth = values.width;

	      if (values.dashes !== false) {
	        this._drawDashedLine(ctx, values, viaNode);
	      } else {
	        this._drawLine(ctx, values, viaNode);
	      }
	    }
	    /**
	     * Draw a line with given style between two nodes through supplied node(s).
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param viaNode - Additional control point(s) for the edge.
	     * @param fromPoint - TODO: Seems ignored, remove?
	     * @param toPoint - TODO: Seems ignored, remove?
	     */

	  }, {
	    key: "_drawLine",
	    value: function _drawLine(ctx, values, viaNode, fromPoint, toPoint) {
	      if (this.from != this.to) {
	        // draw line
	        this._line(ctx, values, viaNode, fromPoint, toPoint);
	      } else {
	        var _this$_getCircleData = this._getCircleData(ctx),
	            _this$_getCircleData2 = slicedToArray(_this$_getCircleData, 3),
	            x = _this$_getCircleData2[0],
	            y = _this$_getCircleData2[1],
	            radius = _this$_getCircleData2[2];

	        this._circle(ctx, values, x, y, radius);
	      }
	    }
	    /**
	     * Draw a dashed line with given style between two nodes through supplied node(s).
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param viaNode - Additional control point(s) for the edge.
	     * @param _fromPoint - Ignored (TODO: remove in the future).
	     * @param _toPoint - Ignored (TODO: remove in the future).
	     */

	  }, {
	    key: "_drawDashedLine",
	    value: function _drawDashedLine(ctx, values, viaNode, _fromPoint, _toPoint) {
	      ctx.lineCap = "round";
	      var pattern = isArray$5(values.dashes) ? values.dashes : [5, 5]; // only firefox and chrome support this method, else we use the legacy one.

	      if (ctx.setLineDash !== undefined) {
	        ctx.save(); // set dash settings for chrome or firefox

	        ctx.setLineDash(pattern);
	        ctx.lineDashOffset = 0; // draw the line

	        if (this.from != this.to) {
	          // draw line
	          this._line(ctx, values, viaNode);
	        } else {
	          var _this$_getCircleData3 = this._getCircleData(ctx),
	              _this$_getCircleData4 = slicedToArray(_this$_getCircleData3, 3),
	              x = _this$_getCircleData4[0],
	              y = _this$_getCircleData4[1],
	              radius = _this$_getCircleData4[2];

	          this._circle(ctx, values, x, y, radius);
	        } // restore the dash settings.


	        ctx.setLineDash([0]);
	        ctx.lineDashOffset = 0;
	        ctx.restore();
	      } else {
	        // unsupporting smooth lines
	        if (this.from != this.to) {
	          // draw line
	          drawDashedLine(ctx, this.from.x, this.from.y, this.to.x, this.to.y, pattern);
	        } else {
	          var _this$_getCircleData5 = this._getCircleData(ctx),
	              _this$_getCircleData6 = slicedToArray(_this$_getCircleData5, 3),
	              _x = _this$_getCircleData6[0],
	              _y = _this$_getCircleData6[1],
	              _radius = _this$_getCircleData6[2];

	          this._circle(ctx, values, _x, _y, _radius);
	        } // draw shadow if enabled


	        this.enableShadow(ctx, values);
	        ctx.stroke(); // disable shadows for other elements.

	        this.disableShadow(ctx, values);
	      }
	    }
	    /**
	     * Find the intersection between the border of the node and the edge.
	     *
	     * @param node - The node (either from or to node of the edge).
	     * @param ctx - The context that will be used for rendering.
	     * @param options - Additional options.
	     *
	     * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
	     */

	  }, {
	    key: "findBorderPosition",
	    value: function findBorderPosition(node, ctx, options) {
	      if (this.from != this.to) {
	        return this._findBorderPosition(node, ctx, options);
	      } else {
	        return this._findBorderPositionCircle(node, ctx, options);
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "findBorderPositions",
	    value: function findBorderPositions(ctx) {
	      if (this.from != this.to) {
	        return {
	          from: this._findBorderPosition(this.from, ctx),
	          to: this._findBorderPosition(this.to, ctx)
	        };
	      } else {
	        var _context;

	        var _this$_getCircleData$ = slice$5(_context = this._getCircleData(ctx)).call(_context, 0, 2),
	            _this$_getCircleData$2 = slicedToArray(_this$_getCircleData$, 2),
	            x = _this$_getCircleData$2[0],
	            y = _this$_getCircleData$2[1];

	        return {
	          from: this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: 0.25,
	            high: 0.6,
	            direction: -1
	          }),
	          to: this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: 0.6,
	            high: 0.8,
	            direction: 1
	          })
	        };
	      }
	    }
	    /**
	     * Compute the center point and radius of an edge connected to the same node at both ends.
	     *
	     * @param ctx - The context that will be used for rendering.
	     *
	     * @returns `[x, y, radius]`
	     */

	  }, {
	    key: "_getCircleData",
	    value: function _getCircleData(ctx) {
	      var radius = this.options.selfReference.size;

	      if (ctx !== undefined) {
	        if (this.from.shape.width === undefined) {
	          this.from.shape.resize(ctx);
	        }
	      } // get circle coordinates


	      var coordinates = ComponentUtil.getSelfRefCoordinates(ctx, this.options.selfReference.angle, radius, this.from);
	      return [coordinates.x, coordinates.y, radius];
	    }
	    /**
	     * Get a point on a circle.
	     *
	     * @param x - Center of the circle on the x axis.
	     * @param y - Center of the circle on the y axis.
	     * @param radius - Radius of the circle.
	     * @param position - Value between 0 (line start) and 1 (line end).
	     *
	     * @returns Cartesian coordinates of requested point on the circle.
	     */

	  }, {
	    key: "_pointOnCircle",
	    value: function _pointOnCircle(x, y, radius, position) {
	      var angle = position * 2 * Math.PI;
	      return {
	        x: x + radius * Math.cos(angle),
	        y: y - radius * Math.sin(angle)
	      };
	    }
	    /**
	     * Find the intersection between the border of the node and the edge.
	     *
	     * @remarks
	     * This function uses binary search to look for the point where the circle crosses the border of the node.
	     *
	     * @param nearNode - The node (either from or to node of the edge).
	     * @param ctx - The context that will be used for rendering.
	     * @param options - Additional options.
	     *
	     * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
	     */

	  }, {
	    key: "_findBorderPositionCircle",
	    value: function _findBorderPositionCircle(nearNode, ctx, options) {
	      var x = options.x;
	      var y = options.y;
	      var low = options.low;
	      var high = options.high;
	      var direction = options.direction;
	      var maxIterations = 10;
	      var radius = this.options.selfReference.size;
	      var threshold = 0.05;
	      var pos;
	      var middle = (low + high) * 0.5;
	      var iteration = 0;

	      do {
	        middle = (low + high) * 0.5;
	        pos = this._pointOnCircle(x, y, radius, middle);
	        var angle = Math.atan2(nearNode.y - pos.y, nearNode.x - pos.x);
	        var distanceToBorder = nearNode.distanceToBorder(ctx, angle);
	        var distanceToPoint = Math.sqrt(Math.pow(pos.x - nearNode.x, 2) + Math.pow(pos.y - nearNode.y, 2));
	        var difference = distanceToBorder - distanceToPoint;

	        if (Math.abs(difference) < threshold) {
	          break; // found
	        } else if (difference > 0) {
	          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
	          if (direction > 0) {
	            low = middle;
	          } else {
	            high = middle;
	          }
	        } else {
	          if (direction > 0) {
	            high = middle;
	          } else {
	            low = middle;
	          }
	        }

	        ++iteration;
	      } while (low <= high && iteration < maxIterations);

	      return _objectSpread$3(_objectSpread$3({}, pos), {}, {
	        t: middle
	      });
	    }
	    /**
	     * Get the line width of the edge. Depends on width and whether one of the connected nodes is selected.
	     *
	     * @param selected - Determines wheter the line is selected.
	     * @param hover - Determines wheter the line is being hovered, only applies if selected is false.
	     *
	     * @returns The width of the line.
	     */

	  }, {
	    key: "getLineWidth",
	    value: function getLineWidth(selected, hover) {
	      if (selected === true) {
	        return Math.max(this.selectionWidth, 0.3 / this._body.view.scale);
	      } else if (hover === true) {
	        return Math.max(this.hoverWidth, 0.3 / this._body.view.scale);
	      } else {
	        return Math.max(this.options.width, 0.3 / this._body.view.scale);
	      }
	    }
	    /**
	     * Compute the color or gradient for given edge.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param _selected - Ignored (TODO: remove in the future).
	     * @param _hover - Ignored (TODO: remove in the future).
	     *
	     * @returns Color string if single color is inherited or gradient if two.
	     */

	  }, {
	    key: "getColor",
	    value: function getColor(ctx, values) {
	      if (values.inheritsColor !== false) {
	        // when this is a loop edge, just use the 'from' method
	        if (values.inheritsColor === "both" && this.from.id !== this.to.id) {
	          var grd = ctx.createLinearGradient(this.from.x, this.from.y, this.to.x, this.to.y);
	          var fromColor = this.from.options.color.highlight.border;
	          var toColor = this.to.options.color.highlight.border;

	          if (this.from.selected === false && this.to.selected === false) {
	            fromColor = overrideOpacity(this.from.options.color.border, values.opacity);
	            toColor = overrideOpacity(this.to.options.color.border, values.opacity);
	          } else if (this.from.selected === true && this.to.selected === false) {
	            toColor = this.to.options.color.border;
	          } else if (this.from.selected === false && this.to.selected === true) {
	            fromColor = this.from.options.color.border;
	          }

	          grd.addColorStop(0, fromColor);
	          grd.addColorStop(1, toColor); // -------------------- this returns -------------------- //

	          return grd;
	        }

	        if (values.inheritsColor === "to") {
	          return overrideOpacity(this.to.options.color.border, values.opacity);
	        } else {
	          // "from"
	          return overrideOpacity(this.from.options.color.border, values.opacity);
	        }
	      } else {
	        return overrideOpacity(values.color, values.opacity);
	      }
	    }
	    /**
	     * Draw a line from a node to itself, a circle.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values like color, opacity or shadow.
	     * @param x - Center of the circle on the x axis.
	     * @param y - Center of the circle on the y axis.
	     * @param radius - Radius of the circle.
	     */

	  }, {
	    key: "_circle",
	    value: function _circle(ctx, values, x, y, radius) {
	      // draw shadow if enabled
	      this.enableShadow(ctx, values); //full circle

	      var angleFrom = 0;
	      var angleTo = Math.PI * 2;

	      if (!this.options.selfReference.renderBehindTheNode) {
	        //render only parts which are not overlaping with parent node
	        //need to find x,y of from point and x,y to point
	        //calculating radians
	        var low = this.options.selfReference.angle;
	        var high = this.options.selfReference.angle + Math.PI;

	        var pointTFrom = this._findBorderPositionCircle(this.from, ctx, {
	          x: x,
	          y: y,
	          low: low,
	          high: high,
	          direction: -1
	        });

	        var pointTTo = this._findBorderPositionCircle(this.from, ctx, {
	          x: x,
	          y: y,
	          low: low,
	          high: high,
	          direction: 1
	        });

	        angleFrom = Math.atan2(pointTFrom.y - y, pointTFrom.x - x);
	        angleTo = Math.atan2(pointTTo.y - y, pointTTo.x - x);
	      } // draw a circle


	      ctx.beginPath();
	      ctx.arc(x, y, radius, angleFrom, angleTo, false);
	      ctx.stroke(); // disable shadows for other elements.

	      this.disableShadow(ctx, values);
	    }
	    /**
	     * @inheritdoc
	     *
	     * @remarks
	     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
	     */

	  }, {
	    key: "getDistanceToEdge",
	    value: function getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      if (this.from != this.to) {
	        return this._getDistanceToEdge(x1, y1, x2, y2, x3, y3);
	      } else {
	        var _this$_getCircleData7 = this._getCircleData(undefined),
	            _this$_getCircleData8 = slicedToArray(_this$_getCircleData7, 3),
	            x = _this$_getCircleData8[0],
	            y = _this$_getCircleData8[1],
	            radius = _this$_getCircleData8[2];

	        var dx = x - x3;
	        var dy = y - y3;
	        return Math.abs(Math.sqrt(dx * dx + dy * dy) - radius);
	      }
	    }
	    /**
	     * Calculate the distance between a point (x3, y3) and a line segment from (x1, y1) to (x2, y2).
	     *
	     * @param x1 - First end of the line segment on the x axis.
	     * @param y1 - First end of the line segment on the y axis.
	     * @param x2 - Second end of the line segment on the x axis.
	     * @param y2 - Second end of the line segment on the y axis.
	     * @param x3 - Position of the point on the x axis.
	     * @param y3 - Position of the point on the y axis.
	     *
	     * @returns The distance between the line segment and the point.
	     */

	  }, {
	    key: "_getDistanceToLine",
	    value: function _getDistanceToLine(x1, y1, x2, y2, x3, y3) {
	      var px = x2 - x1;
	      var py = y2 - y1;
	      var something = px * px + py * py;
	      var u = ((x3 - x1) * px + (y3 - y1) * py) / something;

	      if (u > 1) {
	        u = 1;
	      } else if (u < 0) {
	        u = 0;
	      }

	      var x = x1 + u * px;
	      var y = y1 + u * py;
	      var dx = x - x3;
	      var dy = y - y3; //# Note: If the actual distance does not matter,
	      //# if you only want to compare what this function
	      //# returns to other results of this function, you
	      //# can just return the squared distance instead
	      //# (i.e. remove the sqrt) to gain a little performance

	      return Math.sqrt(dx * dx + dy * dy);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getArrowData",
	    value: function getArrowData(ctx, position, viaNode, _selected, _hover, values) {
	      // set lets
	      var angle;
	      var arrowPoint;
	      var node1;
	      var node2;
	      var reversed;
	      var scaleFactor;
	      var type;
	      var lineWidth = values.width;

	      if (position === "from") {
	        node1 = this.from;
	        node2 = this.to;
	        reversed = values.fromArrowScale < 0;
	        scaleFactor = Math.abs(values.fromArrowScale);
	        type = values.fromArrowType;
	      } else if (position === "to") {
	        node1 = this.to;
	        node2 = this.from;
	        reversed = values.toArrowScale < 0;
	        scaleFactor = Math.abs(values.toArrowScale);
	        type = values.toArrowType;
	      } else {
	        node1 = this.to;
	        node2 = this.from;
	        reversed = values.middleArrowScale < 0;
	        scaleFactor = Math.abs(values.middleArrowScale);
	        type = values.middleArrowType;
	      }

	      var length = 15 * scaleFactor + 3 * lineWidth; // 3* lineWidth is the width of the edge.
	      // if not connected to itself

	      if (node1 != node2) {
	        var approximateEdgeLength = hypot$2(node1.x - node2.x, node1.y - node2.y);

	        var relativeLength = length / approximateEdgeLength;

	        if (position !== "middle") {
	          // draw arrow head
	          if (this.options.smooth.enabled === true) {
	            var pointT = this._findBorderPosition(node1, ctx, {
	              via: viaNode
	            });

	            var guidePos = this.getPoint(pointT.t + relativeLength * (position === "from" ? 1 : -1), viaNode);
	            angle = Math.atan2(pointT.y - guidePos.y, pointT.x - guidePos.x);
	            arrowPoint = pointT;
	          } else {
	            angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
	            arrowPoint = this._findBorderPosition(node1, ctx);
	          }
	        } else {
	          // Negative half length reverses arrow direction.
	          var halfLength = (reversed ? -relativeLength : relativeLength) / 2;
	          var guidePos1 = this.getPoint(0.5 + halfLength, viaNode);
	          var guidePos2 = this.getPoint(0.5 - halfLength, viaNode);
	          angle = Math.atan2(guidePos1.y - guidePos2.y, guidePos1.x - guidePos2.x);
	          arrowPoint = this.getPoint(0.5, viaNode);
	        }
	      } else {
	        // draw circle
	        var _this$_getCircleData9 = this._getCircleData(ctx),
	            _this$_getCircleData10 = slicedToArray(_this$_getCircleData9, 3),
	            x = _this$_getCircleData10[0],
	            y = _this$_getCircleData10[1],
	            radius = _this$_getCircleData10[2];

	        if (position === "from") {
	          var low = this.options.selfReference.angle;
	          var high = this.options.selfReference.angle + Math.PI;

	          var _pointT = this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: low,
	            high: high,
	            direction: -1
	          });

	          angle = _pointT.t * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
	          arrowPoint = _pointT;
	        } else if (position === "to") {
	          var _low = this.options.selfReference.angle;

	          var _high = this.options.selfReference.angle + Math.PI;

	          var _pointT2 = this._findBorderPositionCircle(this.from, ctx, {
	            x: x,
	            y: y,
	            low: _low,
	            high: _high,
	            direction: 1
	          });

	          angle = _pointT2.t * -2 * Math.PI + 1.5 * Math.PI - 1.1 * Math.PI;
	          arrowPoint = _pointT2;
	        } else {
	          var pos = this.options.selfReference.angle / (2 * Math.PI);
	          arrowPoint = this._pointOnCircle(x, y, radius, pos);
	          angle = pos * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
	        }
	      }

	      var xi = arrowPoint.x - length * 0.9 * Math.cos(angle);
	      var yi = arrowPoint.y - length * 0.9 * Math.sin(angle);
	      var arrowCore = {
	        x: xi,
	        y: yi
	      };
	      return {
	        point: arrowPoint,
	        core: arrowCore,
	        angle: angle,
	        length: length,
	        type: type
	      };
	    }
	    /** @inheritdoc */

	  }, {
	    key: "drawArrowHead",
	    value: function drawArrowHead(ctx, values, _selected, _hover, arrowData) {
	      // set style
	      ctx.strokeStyle = this.getColor(ctx, values);
	      ctx.fillStyle = ctx.strokeStyle;
	      ctx.lineWidth = values.width;
	      var canFill = EndPoints.draw(ctx, arrowData);

	      if (canFill) {
	        // draw shadow if enabled
	        this.enableShadow(ctx, values);

	        fill$2(ctx).call(ctx); // disable shadows for other elements.


	        this.disableShadow(ctx, values);
	      }
	    }
	    /**
	     * Set the shadow formatting values in the context if enabled, do nothing otherwise.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values for the shadow.
	     */

	  }, {
	    key: "enableShadow",
	    value: function enableShadow(ctx, values) {
	      if (values.shadow === true) {
	        ctx.shadowColor = values.shadowColor;
	        ctx.shadowBlur = values.shadowSize;
	        ctx.shadowOffsetX = values.shadowX;
	        ctx.shadowOffsetY = values.shadowY;
	      }
	    }
	    /**
	     * Reset the shadow formatting values in the context if enabled, do nothing otherwise.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values for the shadow.
	     */

	  }, {
	    key: "disableShadow",
	    value: function disableShadow(ctx, values) {
	      if (values.shadow === true) {
	        ctx.shadowColor = "rgba(0,0,0,0)";
	        ctx.shadowBlur = 0;
	        ctx.shadowOffsetX = 0;
	        ctx.shadowOffsetY = 0;
	      }
	    }
	    /**
	     * Render the background according to the formatting values.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Formatting values for the background.
	     */

	  }, {
	    key: "drawBackground",
	    value: function drawBackground(ctx, values) {
	      if (values.background !== false) {
	        // save original line attrs
	        var origCtxAttr = {
	          strokeStyle: ctx.strokeStyle,
	          lineWidth: ctx.lineWidth,
	          dashes: ctx.dashes
	        };
	        ctx.strokeStyle = values.backgroundColor;
	        ctx.lineWidth = values.backgroundSize;
	        this.setStrokeDashed(ctx, values.backgroundDashes);
	        ctx.stroke(); // restore original line attrs

	        ctx.strokeStyle = origCtxAttr.strokeStyle;
	        ctx.lineWidth = origCtxAttr.lineWidth;
	        ctx.dashes = origCtxAttr.dashes;
	        this.setStrokeDashed(ctx, values.dashes);
	      }
	    }
	    /**
	     * Set the line dash pattern if supported. Logs a warning to the console if it isn't supported.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param dashes - The pattern [line, space, line…], true for default dashed line or false for normal line.
	     */

	  }, {
	    key: "setStrokeDashed",
	    value: function setStrokeDashed(ctx, dashes) {
	      if (dashes !== false) {
	        if (ctx.setLineDash !== undefined) {
	          var pattern = isArray$5(dashes) ? dashes : [5, 5];
	          ctx.setLineDash(pattern);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
	        }
	      } else {
	        if (ctx.setLineDash !== undefined) {
	          ctx.setLineDash([]);
	        } else {
	          console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
	        }
	      }
	    }
	  }]);

	  return EdgeBase;
	}();

	function ownKeys$5(object, enumerableOnly) { var keys = keys$3(object); if (getOwnPropertySymbols$2) { var symbols = getOwnPropertySymbols$2(object); if (enumerableOnly) symbols = filter$2(symbols).call(symbols, function (sym) { return getOwnPropertyDescriptor$3(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

	function _objectSpread$4(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { var _context; forEach$2(_context = ownKeys$5(Object(source), true)).call(_context, function (key) { defineProperty$6(target, key, source[key]); }); } else if (getOwnPropertyDescriptors$2) { defineProperties$1(target, getOwnPropertyDescriptors$2(source)); } else { var _context2; forEach$2(_context2 = ownKeys$5(Object(source))).call(_context2, function (key) { defineProperty$3(target, key, getOwnPropertyDescriptor$3(source, key)); }); } } return target; }

	function _createSuper$j(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$j(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$j() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * The Base Class for all Bezier edges.
	 * Bezier curves are used to model smooth gradual curves in paths between nodes.
	 */

	var BezierEdgeBase = /*#__PURE__*/function (_EdgeBase) {
	  inherits(BezierEdgeBase, _EdgeBase);

	  var _super = _createSuper$j(BezierEdgeBase);

	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function BezierEdgeBase(options, body, labelModule) {
	    classCallCheck(this, BezierEdgeBase);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   * Find the intersection between the border of the node and the edge.
	   *
	   * @remarks
	   * This function uses binary search to look for the point where the bezier curve crosses the border of the node.
	   *
	   * @param nearNode - The node (either from or to node of the edge).
	   * @param ctx - The context that will be used for rendering.
	   * @param viaNode - Additional node(s) the edge passes through.
	   *
	   * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
	   */


	  createClass(BezierEdgeBase, [{
	    key: "_findBorderPositionBezier",
	    value: function _findBorderPositionBezier(nearNode, ctx) {
	      var viaNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this._getViaCoordinates();
	      var maxIterations = 10;
	      var threshold = 0.2;
	      var from = false;
	      var high = 1;
	      var low = 0;
	      var node = this.to;
	      var pos;
	      var middle;

	      if (nearNode.id === this.from.id) {
	        node = this.from;
	        from = true;
	      }

	      var iteration = 0;

	      do {
	        middle = (low + high) * 0.5;
	        pos = this.getPoint(middle, viaNode);
	        var angle = Math.atan2(node.y - pos.y, node.x - pos.x);
	        var distanceToBorder = node.distanceToBorder(ctx, angle);
	        var distanceToPoint = Math.sqrt(Math.pow(pos.x - node.x, 2) + Math.pow(pos.y - node.y, 2));
	        var difference = distanceToBorder - distanceToPoint;

	        if (Math.abs(difference) < threshold) {
	          break; // found
	        } else if (difference < 0) {
	          // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
	          if (from === false) {
	            low = middle;
	          } else {
	            high = middle;
	          }
	        } else {
	          if (from === false) {
	            high = middle;
	          } else {
	            low = middle;
	          }
	        }

	        ++iteration;
	      } while (low <= high && iteration < maxIterations);

	      return _objectSpread$4(_objectSpread$4({}, pos), {}, {
	        t: middle
	      });
	    }
	    /**
	     * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
	     *
	     * @remarks
	     * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
	     *
	     * @param x1 - First end of the line segment on the x axis.
	     * @param y1 - First end of the line segment on the y axis.
	     * @param x2 - Second end of the line segment on the x axis.
	     * @param y2 - Second end of the line segment on the y axis.
	     * @param x3 - Position of the point on the x axis.
	     * @param y3 - Position of the point on the y axis.
	     * @param via - The control point for the edge.
	     *
	     * @returns The distance between the line segment and the point.
	     */

	  }, {
	    key: "_getDistanceToBezierEdge",
	    value: function _getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via) {
	      // x3,y3 is the point
	      var minDistance = 1e9;
	      var distance;
	      var i, t, x, y;
	      var lastX = x1;
	      var lastY = y1;

	      for (i = 1; i < 10; i++) {
	        t = 0.1 * i;
	        x = Math.pow(1 - t, 2) * x1 + 2 * t * (1 - t) * via.x + Math.pow(t, 2) * x2;
	        y = Math.pow(1 - t, 2) * y1 + 2 * t * (1 - t) * via.y + Math.pow(t, 2) * y2;

	        if (i > 0) {
	          distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
	          minDistance = distance < minDistance ? distance : minDistance;
	        }

	        lastX = x;
	        lastY = y;
	      }

	      return minDistance;
	    }
	    /**
	     * Render a bezier curve between two nodes.
	     *
	     * @remarks
	     * The method accepts zero, one or two control points.
	     * Passing zero control points just draws a straight line.
	     *
	     * @param ctx - The context that will be used for rendering.
	     * @param values - Style options for edge drawing.
	     * @param viaNode1 - First control point for curve drawing.
	     * @param viaNode2 - Second control point for curve drawing.
	     */

	  }, {
	    key: "_bezierCurve",
	    value: function _bezierCurve(ctx, values, viaNode1, viaNode2) {
	      ctx.beginPath();
	      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);

	      if (viaNode1 != null && viaNode1.x != null) {
	        if (viaNode2 != null && viaNode2.x != null) {
	          ctx.bezierCurveTo(viaNode1.x, viaNode1.y, viaNode2.x, viaNode2.y, this.toPoint.x, this.toPoint.y);
	        } else {
	          ctx.quadraticCurveTo(viaNode1.x, viaNode1.y, this.toPoint.x, this.toPoint.y);
	        }
	      } else {
	        // fallback to normal straight edge
	        ctx.lineTo(this.toPoint.x, this.toPoint.y);
	      } // draw a background


	      this.drawBackground(ctx, values); // draw shadow if enabled

	      this.enableShadow(ctx, values);
	      ctx.stroke();
	      this.disableShadow(ctx, values);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this._getViaCoordinates();
	    }
	  }]);

	  return BezierEdgeBase;
	}(EdgeBase);

	function _createSuper$k(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$k(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$k() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Dynamic Bezier Edge. Bezier curves are used to model smooth gradual
	 * curves in paths between nodes. The Dynamic piece refers to how the curve
	 * reacts to physics changes.
	 *
	 * @extends BezierEdgeBase
	 */

	var BezierEdgeDynamic = /*#__PURE__*/function (_BezierEdgeBase) {
	  inherits(BezierEdgeDynamic, _BezierEdgeBase);

	  var _super = _createSuper$k(BezierEdgeDynamic);

	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function BezierEdgeDynamic(options, body, labelModule) {
	    var _this;

	    classCallCheck(this, BezierEdgeDynamic);

	    //this.via = undefined; // Here for completeness but not allowed to defined before super() is invoked.
	    _this = _super.call(this, options, body, labelModule); // --> this calls the setOptions below

	    _this.via = _this.via; // constructor → super → super → setOptions → setupSupportNode

	    _this._boundFunction = function () {
	      _this.positionBezierNode();
	    };

	    _this._body.emitter.on("_repositionBezierNodes", _this._boundFunction);

	    return _this;
	  }
	  /** @inheritdoc */


	  createClass(BezierEdgeDynamic, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      get$5(getPrototypeOf$5(BezierEdgeDynamic.prototype), "setOptions", this).call(this, options); // check if the physics has changed.


	      var physicsChange = false;

	      if (this.options.physics !== options.physics) {
	        physicsChange = true;
	      } // set the options and the to and from nodes


	      this.options = options;
	      this.id = this.options.id;
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to]; // setup the support node and connect

	      this.setupSupportNode();
	      this.connect(); // when we change the physics state of the edge, we reposition the support node.

	      if (physicsChange === true) {
	        this.via.setOptions({
	          physics: this.options.physics
	        });
	        this.positionBezierNode();
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "connect",
	    value: function connect() {
	      this.from = this._body.nodes[this.options.from];
	      this.to = this._body.nodes[this.options.to];

	      if (this.from === undefined || this.to === undefined || this.options.physics === false) {
	        this.via.setOptions({
	          physics: false
	        });
	      } else {
	        // fix weird behaviour where a self referencing node has physics enabled
	        if (this.from.id === this.to.id) {
	          this.via.setOptions({
	            physics: false
	          });
	        } else {
	          this.via.setOptions({
	            physics: true
	          });
	        }
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "cleanup",
	    value: function cleanup() {
	      this._body.emitter.off("_repositionBezierNodes", this._boundFunction);

	      if (this.via !== undefined) {
	        delete this._body.nodes[this.via.id];
	        this.via = undefined;
	        return true;
	      }

	      return false;
	    }
	    /**
	     * Create and add a support node if not already present.
	     *
	     * @remarks
	     * Bezier curves require an anchor point to calculate the smooth flow.
	     * These points are nodes.
	     * These nodes are invisible but are used for the force calculation.
	     *
	     * The changed data is not called, if needed, it is returned by the main edge constructor.
	     */

	  }, {
	    key: "setupSupportNode",
	    value: function setupSupportNode() {
	      if (this.via === undefined) {
	        var nodeId = "edgeId:" + this.id;

	        var node = this._body.functions.createNode({
	          id: nodeId,
	          shape: "circle",
	          physics: true,
	          hidden: true
	        });

	        this._body.nodes[nodeId] = node;
	        this.via = node;
	        this.via.parentEdgeId = this.id;
	        this.positionBezierNode();
	      }
	    }
	    /**
	     * Position bezier node.
	     */

	  }, {
	    key: "positionBezierNode",
	    value: function positionBezierNode() {
	      if (this.via !== undefined && this.from !== undefined && this.to !== undefined) {
	        this.via.x = 0.5 * (this.from.x + this.to.x);
	        this.via.y = 0.5 * (this.from.y + this.to.y);
	      } else if (this.via !== undefined) {
	        this.via.x = 0;
	        this.via.y = 0;
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_line",
	    value: function _line(ctx, values, viaNode) {
	      this._bezierCurve(ctx, values, viaNode);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_getViaCoordinates",
	    value: function _getViaCoordinates() {
	      return this.via;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this.via;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.via;

	      if (this.from === this.to) {
	        var _this$_getCircleData = this._getCircleData(),
	            _this$_getCircleData2 = slicedToArray(_this$_getCircleData, 3),
	            cx = _this$_getCircleData2[0],
	            cy = _this$_getCircleData2[1],
	            cr = _this$_getCircleData2[2];

	        var a = 2 * Math.PI * (1 - position);
	        return {
	          x: cx + cr * Math.sin(a),
	          y: cy + cr - cr * (1 - Math.cos(a))
	        };
	      } else {
	        return {
	          x: Math.pow(1 - position, 2) * this.fromPoint.x + 2 * position * (1 - position) * viaNode.x + Math.pow(position, 2) * this.toPoint.x,
	          y: Math.pow(1 - position, 2) * this.fromPoint.y + 2 * position * (1 - position) * viaNode.y + Math.pow(position, 2) * this.toPoint.y
	        };
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      return this._findBorderPositionBezier(nearNode, ctx, this.via);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      // x3,y3 is the point
	      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, this.via);
	    }
	  }]);

	  return BezierEdgeDynamic;
	}(BezierEdgeBase);

	function _createSuper$l(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$l(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$l() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Static Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
	 */

	var BezierEdgeStatic = /*#__PURE__*/function (_BezierEdgeBase) {
	  inherits(BezierEdgeStatic, _BezierEdgeBase);

	  var _super = _createSuper$l(BezierEdgeStatic);

	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function BezierEdgeStatic(options, body, labelModule) {
	    classCallCheck(this, BezierEdgeStatic);

	    return _super.call(this, options, body, labelModule);
	  }
	  /** @inheritdoc */


	  createClass(BezierEdgeStatic, [{
	    key: "_line",
	    value: function _line(ctx, values, viaNode) {
	      this._bezierCurve(ctx, values, viaNode);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this._getViaCoordinates();
	    }
	    /**
	     * Compute the coordinates of the via node.
	     *
	     * @remarks
	     * We do not use the to and fromPoints here to make the via nodes the same as edges without arrows.
	     *
	     * @returns Cartesian coordinates of the via node.
	     */

	  }, {
	    key: "_getViaCoordinates",
	    value: function _getViaCoordinates() {
	      // Assumption: x/y coordinates in from/to always defined
	      var factor = this.options.smooth.roundness;
	      var type = this.options.smooth.type;
	      var dx = Math.abs(this.from.x - this.to.x);
	      var dy = Math.abs(this.from.y - this.to.y);

	      if (type === "discrete" || type === "diagonalCross") {
	        var stepX;
	        var stepY;

	        if (dx <= dy) {
	          stepX = stepY = factor * dy;
	        } else {
	          stepX = stepY = factor * dx;
	        }

	        if (this.from.x > this.to.x) {
	          stepX = -stepX;
	        }

	        if (this.from.y >= this.to.y) {
	          stepY = -stepY;
	        }

	        var xVia = this.from.x + stepX;
	        var yVia = this.from.y + stepY;

	        if (type === "discrete") {
	          if (dx <= dy) {
	            xVia = dx < factor * dy ? this.from.x : xVia;
	          } else {
	            yVia = dy < factor * dx ? this.from.y : yVia;
	          }
	        }

	        return {
	          x: xVia,
	          y: yVia
	        };
	      } else if (type === "straightCross") {
	        var _stepX = (1 - factor) * dx;

	        var _stepY = (1 - factor) * dy;

	        if (dx <= dy) {
	          // up - down
	          _stepX = 0;

	          if (this.from.y < this.to.y) {
	            _stepY = -_stepY;
	          }
	        } else {
	          // left - right
	          if (this.from.x < this.to.x) {
	            _stepX = -_stepX;
	          }

	          _stepY = 0;
	        }

	        return {
	          x: this.to.x + _stepX,
	          y: this.to.y + _stepY
	        };
	      } else if (type === "horizontal") {
	        var _stepX2 = (1 - factor) * dx;

	        if (this.from.x < this.to.x) {
	          _stepX2 = -_stepX2;
	        }

	        return {
	          x: this.to.x + _stepX2,
	          y: this.from.y
	        };
	      } else if (type === "vertical") {
	        var _stepY2 = (1 - factor) * dy;

	        if (this.from.y < this.to.y) {
	          _stepY2 = -_stepY2;
	        }

	        return {
	          x: this.from.x,
	          y: this.to.y + _stepY2
	        };
	      } else if (type === "curvedCW") {
	        dx = this.to.x - this.from.x;
	        dy = this.from.y - this.to.y;
	        var radius = Math.sqrt(dx * dx + dy * dy);
	        var pi = Math.PI;
	        var originalAngle = Math.atan2(dy, dx);
	        var myAngle = (originalAngle + (factor * 0.5 + 0.5) * pi) % (2 * pi);
	        return {
	          x: this.from.x + (factor * 0.5 + 0.5) * radius * Math.sin(myAngle),
	          y: this.from.y + (factor * 0.5 + 0.5) * radius * Math.cos(myAngle)
	        };
	      } else if (type === "curvedCCW") {
	        dx = this.to.x - this.from.x;
	        dy = this.from.y - this.to.y;

	        var _radius = Math.sqrt(dx * dx + dy * dy);

	        var _pi = Math.PI;

	        var _originalAngle = Math.atan2(dy, dx);

	        var _myAngle = (_originalAngle + (-factor * 0.5 + 0.5) * _pi) % (2 * _pi);

	        return {
	          x: this.from.x + (factor * 0.5 + 0.5) * _radius * Math.sin(_myAngle),
	          y: this.from.y + (factor * 0.5 + 0.5) * _radius * Math.cos(_myAngle)
	        };
	      } else {
	        // continuous
	        var _stepX3;

	        var _stepY3;

	        if (dx <= dy) {
	          _stepX3 = _stepY3 = factor * dy;
	        } else {
	          _stepX3 = _stepY3 = factor * dx;
	        }

	        if (this.from.x > this.to.x) {
	          _stepX3 = -_stepX3;
	        }

	        if (this.from.y >= this.to.y) {
	          _stepY3 = -_stepY3;
	        }

	        var _xVia = this.from.x + _stepX3;

	        var _yVia = this.from.y + _stepY3;

	        if (dx <= dy) {
	          if (this.from.x <= this.to.x) {
	            _xVia = this.to.x < _xVia ? this.to.x : _xVia;
	          } else {
	            _xVia = this.to.x > _xVia ? this.to.x : _xVia;
	          }
	        } else {
	          if (this.from.y >= this.to.y) {
	            _yVia = this.to.y > _yVia ? this.to.y : _yVia;
	          } else {
	            _yVia = this.to.y < _yVia ? this.to.y : _yVia;
	          }
	        }

	        return {
	          x: _xVia,
	          y: _yVia
	        };
	      }
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	      return this._findBorderPositionBezier(nearNode, ctx, options.via);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      var viaNode = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates();
	      // x3,y3 is the point
	      return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, viaNode);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      var viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates();
	      var t = position;
	      var x = Math.pow(1 - t, 2) * this.fromPoint.x + 2 * t * (1 - t) * viaNode.x + Math.pow(t, 2) * this.toPoint.x;
	      var y = Math.pow(1 - t, 2) * this.fromPoint.y + 2 * t * (1 - t) * viaNode.y + Math.pow(t, 2) * this.toPoint.y;
	      return {
	        x: x,
	        y: y
	      };
	    }
	  }]);

	  return BezierEdgeStatic;
	}(BezierEdgeBase);

	function _createSuper$m(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$m(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$m() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Base Class for all Cubic Bezier Edges. Bezier curves are used to model
	 * smooth gradual curves in paths between nodes.
	 *
	 * @extends BezierEdgeBase
	 */

	var CubicBezierEdgeBase = /*#__PURE__*/function (_BezierEdgeBase) {
	  inherits(CubicBezierEdgeBase, _BezierEdgeBase);

	  var _super = _createSuper$m(CubicBezierEdgeBase);

	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function CubicBezierEdgeBase(options, body, labelModule) {
	    classCallCheck(this, CubicBezierEdgeBase);

	    return _super.call(this, options, body, labelModule);
	  }
	  /**
	   * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
	   *
	   * @remarks
	   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
	   * https://en.wikipedia.org/wiki/B%C3%A9zier_curve
	   *
	   * @param x1 - First end of the line segment on the x axis.
	   * @param y1 - First end of the line segment on the y axis.
	   * @param x2 - Second end of the line segment on the x axis.
	   * @param y2 - Second end of the line segment on the y axis.
	   * @param x3 - Position of the point on the x axis.
	   * @param y3 - Position of the point on the y axis.
	   * @param via1 - The first point this edge passes through.
	   * @param via2 - The second point this edge passes through.
	   *
	   * @returns The distance between the line segment and the point.
	   */


	  createClass(CubicBezierEdgeBase, [{
	    key: "_getDistanceToBezierEdge2",
	    value: function _getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2) {
	      // x3,y3 is the point
	      var minDistance = 1e9;
	      var lastX = x1;
	      var lastY = y1;
	      var vec = [0, 0, 0, 0];

	      for (var i = 1; i < 10; i++) {
	        var t = 0.1 * i;
	        vec[0] = Math.pow(1 - t, 3);
	        vec[1] = 3 * t * Math.pow(1 - t, 2);
	        vec[2] = 3 * Math.pow(t, 2) * (1 - t);
	        vec[3] = Math.pow(t, 3);
	        var x = vec[0] * x1 + vec[1] * via1.x + vec[2] * via2.x + vec[3] * x2;
	        var y = vec[0] * y1 + vec[1] * via1.y + vec[2] * via2.y + vec[3] * y2;

	        if (i > 0) {
	          var distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);

	          minDistance = distance < minDistance ? distance : minDistance;
	        }

	        lastX = x;
	        lastY = y;
	      }

	      return minDistance;
	    }
	  }]);

	  return CubicBezierEdgeBase;
	}(BezierEdgeBase);

	function _createSuper$n(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$n(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$n() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Cubic Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
	 */

	var CubicBezierEdge = /*#__PURE__*/function (_CubicBezierEdgeBase) {
	  inherits(CubicBezierEdge, _CubicBezierEdgeBase);

	  var _super = _createSuper$n(CubicBezierEdge);

	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function CubicBezierEdge(options, body, labelModule) {
	    classCallCheck(this, CubicBezierEdge);

	    return _super.call(this, options, body, labelModule);
	  }
	  /** @inheritdoc */


	  createClass(CubicBezierEdge, [{
	    key: "_line",
	    value: function _line(ctx, values, viaNodes) {
	      // get the coordinates of the support points.
	      var via1 = viaNodes[0];
	      var via2 = viaNodes[1];

	      this._bezierCurve(ctx, values, via1, via2);
	    }
	    /**
	     * Compute the additional points the edge passes through.
	     *
	     * @returns Cartesian coordinates of the points the edge passes through.
	     */

	  }, {
	    key: "_getViaCoordinates",
	    value: function _getViaCoordinates() {
	      var dx = this.from.x - this.to.x;
	      var dy = this.from.y - this.to.y;
	      var x1;
	      var y1;
	      var x2;
	      var y2;
	      var roundness = this.options.smooth.roundness; // horizontal if x > y or if direction is forced or if direction is horizontal

	      if ((Math.abs(dx) > Math.abs(dy) || this.options.smooth.forceDirection === true || this.options.smooth.forceDirection === "horizontal") && this.options.smooth.forceDirection !== "vertical") {
	        y1 = this.from.y;
	        y2 = this.to.y;
	        x1 = this.from.x - roundness * dx;
	        x2 = this.to.x + roundness * dx;
	      } else {
	        y1 = this.from.y - roundness * dy;
	        y2 = this.to.y + roundness * dy;
	        x1 = this.from.x;
	        x2 = this.to.x;
	      }

	      return [{
	        x: x1,
	        y: y1
	      }, {
	        x: x2,
	        y: y2
	      }];
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return this._getViaCoordinates();
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      return this._findBorderPositionBezier(nearNode, ctx);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      var _ref = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates(),
	          _ref2 = slicedToArray(_ref, 2),
	          via1 = _ref2[0],
	          via2 = _ref2[1];

	      // x3,y3 is the point
	      return this._getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates(),
	          _ref4 = slicedToArray(_ref3, 2),
	          via1 = _ref4[0],
	          via2 = _ref4[1];

	      var t = position;
	      var vec = [Math.pow(1 - t, 3), 3 * t * Math.pow(1 - t, 2), 3 * Math.pow(t, 2) * (1 - t), Math.pow(t, 3)];
	      var x = vec[0] * this.fromPoint.x + vec[1] * via1.x + vec[2] * via2.x + vec[3] * this.toPoint.x;
	      var y = vec[0] * this.fromPoint.y + vec[1] * via1.y + vec[2] * via2.y + vec[3] * this.toPoint.y;
	      return {
	        x: x,
	        y: y
	      };
	    }
	  }]);

	  return CubicBezierEdge;
	}(CubicBezierEdgeBase);

	function _createSuper$o(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$o(); return function () { var Super = getPrototypeOf$5(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf$5(this).constructor; result = construct$3(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn(this, result); }; }

	function _isNativeReflectConstruct$o() { if (typeof Reflect === "undefined" || !construct$3) return false; if (construct$3.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(construct$3(Date, [], function () {})); return true; } catch (e) { return false; } }
	/**
	 * A Straight Edge.
	 */

	var StraightEdge = /*#__PURE__*/function (_EdgeBase) {
	  inherits(StraightEdge, _EdgeBase);

	  var _super = _createSuper$o(StraightEdge);

	  /**
	   * Create a new instance.
	   *
	   * @param options - The options object of given edge.
	   * @param body - The body of the network.
	   * @param labelModule - Label module.
	   */
	  function StraightEdge(options, body, labelModule) {
	    classCallCheck(this, StraightEdge);

	    return _super.call(this, options, body, labelModule);
	  }
	  /** @inheritdoc */


	  createClass(StraightEdge, [{
	    key: "_line",
	    value: function _line(ctx, values) {
	      // draw a straight line
	      ctx.beginPath();
	      ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
	      ctx.lineTo(this.toPoint.x, this.toPoint.y); // draw shadow if enabled

	      this.enableShadow(ctx, values);
	      ctx.stroke();
	      this.disableShadow(ctx, values);
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getViaNode",
	    value: function getViaNode() {
	      return undefined;
	    }
	    /** @inheritdoc */

	  }, {
	    key: "getPoint",
	    value: function getPoint(position) {
	      return {
	        x: (1 - position) * this.fromPoint.x + position * this.toPoint.x,
	        y: (1 - position) * this.fromPoint.y + position * this.toPoint.y
	      };
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_findBorderPosition",
	    value: function _findBorderPosition(nearNode, ctx) {
	      var node1 = this.to;
	      var node2 = this.from;

	      if (nearNode.id === this.from.id) {
	        node1 = this.from;
	        node2 = this.to;
	      }

	      var angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
	      var dx = node1.x - node2.x;
	      var dy = node1.y - node2.y;
	      var edgeSegmentLength = Math.sqrt(dx * dx + dy * dy);
	      var toBorderDist = nearNode.distanceToBorder(ctx, angle);
	      var toBorderPoint = (edgeSegmentLength - toBorderDist) / edgeSegmentLength;
	      return {
	        x: (1 - toBorderPoint) * node2.x + toBorderPoint * node1.x,
	        y: (1 - toBorderPoint) * node2.y + toBorderPoint * node1.y,
	        t: 0
	      };
	    }
	    /** @inheritdoc */

	  }, {
	    key: "_getDistanceToEdge",
	    value: function _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
	      // x3,y3 is the point
	      return this._getDistanceToLine(x1, y1, x2, y2, x3, y3);
	    }
	  }]);

	  return StraightEdge;
	}(EdgeBase);

	/**
	 * An edge connects two nodes and has a specific direction.
	 */

	var Edge = /*#__PURE__*/function () {
	  /**
	   * @param {Object} options        values specific to this edge, must contain at least 'from' and 'to'
	   * @param {Object} body           shared state from Network instance
	   * @param {Network.Images} imagelist  A list with images. Only needed when the edge has image arrows.
	   * @param {Object} globalOptions  options from the EdgesHandler instance
	   * @param {Object} defaultOptions default options from the EdgeHandler instance. Value and reference are constant
	   */
	  function Edge(options, body, imagelist, globalOptions, defaultOptions) {
	    classCallCheck(this, Edge);

	    if (body === undefined) {
	      throw new Error("No body provided");
	    } // Since globalOptions is constant in values as well as reference,
	    // Following needs to be done only once.


	    this.options = bridgeObject(globalOptions);
	    this.globalOptions = globalOptions;
	    this.defaultOptions = defaultOptions;
	    this.body = body;
	    this.imagelist = imagelist; // initialize variables

	    this.id = undefined;
	    this.fromId = undefined;
	    this.toId = undefined;
	    this.selected = false;
	    this.hover = false;
	    this.labelDirty = true;
	    this.baseWidth = this.options.width;
	    this.baseFontSize = this.options.font.size;
	    this.from = undefined; // a node

	    this.to = undefined; // a node

	    this.edgeType = undefined;
	    this.connected = false;
	    this.labelModule = new Label(this.body, this.options, true
	    /* It's an edge label */
	    );
	    this.setOptions(options);
	  }
	  /**
	   * Set or overwrite options for the edge
	   * @param {Object} options  an object with options
	   * @returns {undefined|boolean} undefined if no options, true if layout affecting data changed, false otherwise.
	   */


	  createClass(Edge, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (!options) {
	        return;
	      } // Following options if changed affect the layout.


	      var affectsLayout = typeof options.physics !== "undefined" && this.options.physics !== options.physics || typeof options.hidden !== "undefined" && (this.options.hidden || false) !== (options.hidden || false) || typeof options.from !== "undefined" && this.options.from !== options.from || typeof options.to !== "undefined" && this.options.to !== options.to;
	      Edge.parseOptions(this.options, options, true, this.globalOptions);

	      if (options.id !== undefined) {
	        this.id = options.id;
	      }

	      if (options.from !== undefined) {
	        this.fromId = options.from;
	      }

	      if (options.to !== undefined) {
	        this.toId = options.to;
	      }

	      if (options.title !== undefined) {
	        this.title = options.title;
	      }

	      if (options.value !== undefined) {
	        options.value = _parseFloat$2(options.value);
	      }

	      var pile = [options, this.options, this.defaultOptions];
	      this.chooser = ComponentUtil.choosify('edge', pile); // update label Module

	      this.updateLabelModule(options); // Update edge type, this if changed affects the layout.

	      affectsLayout = this.updateEdgeType() || affectsLayout; // if anything has been updates, reset the selection width and the hover width

	      this._setInteractionWidths(); // A node is connected when it has a from and to node that both exist in the network.body.nodes.


	      this.connect();
	      return affectsLayout;
	    }
	    /**
	     *
	     * @param {Object} parentOptions
	     * @param {Object} newOptions
	     * @param {boolean} [allowDeletion=false]
	     * @param {Object} [globalOptions={}]
	     * @param {boolean} [copyFromGlobals=false]
	     */

	  }, {
	    key: "getFormattingValues",

	    /**
	     *
	     * @returns {ArrowOptions}
	     */
	    value: function getFormattingValues() {
	      var toArrow = this.options.arrows.to === true || this.options.arrows.to.enabled === true;
	      var fromArrow = this.options.arrows.from === true || this.options.arrows.from.enabled === true;
	      var middleArrow = this.options.arrows.middle === true || this.options.arrows.middle.enabled === true;
	      var inheritsColor = this.options.color.inherit;
	      var values = {
	        toArrow: toArrow,
	        toArrowScale: this.options.arrows.to.scaleFactor,
	        toArrowType: this.options.arrows.to.type,
	        toArrowSrc: this.options.arrows.to.src,
	        toArrowImageWidth: this.options.arrows.to.imageWidth,
	        toArrowImageHeight: this.options.arrows.to.imageHeight,
	        middleArrow: middleArrow,
	        middleArrowScale: this.options.arrows.middle.scaleFactor,
	        middleArrowType: this.options.arrows.middle.type,
	        middleArrowSrc: this.options.arrows.middle.src,
	        middleArrowImageWidth: this.options.arrows.middle.imageWidth,
	        middleArrowImageHeight: this.options.arrows.middle.imageHeight,
	        fromArrow: fromArrow,
	        fromArrowScale: this.options.arrows.from.scaleFactor,
	        fromArrowType: this.options.arrows.from.type,
	        fromArrowSrc: this.options.arrows.from.src,
	        fromArrowImageWidth: this.options.arrows.from.imageWidth,
	        fromArrowImageHeight: this.options.arrows.from.imageHeight,
	        arrowStrikethrough: this.options.arrowStrikethrough,
	        color: inheritsColor ? undefined : this.options.color.color,
	        inheritsColor: inheritsColor,
	        opacity: this.options.color.opacity,
	        hidden: this.options.hidden,
	        length: this.options.length,
	        shadow: this.options.shadow.enabled,
	        shadowColor: this.options.shadow.color,
	        shadowSize: this.options.shadow.size,
	        shadowX: this.options.shadow.x,
	        shadowY: this.options.shadow.y,
	        dashes: this.options.dashes,
	        width: this.options.width,
	        background: this.options.background.enabled,
	        backgroundColor: this.options.background.color,
	        backgroundSize: this.options.background.size,
	        backgroundDashes: this.options.background.dashes
	      };

	      if (this.selected || this.hover) {
	        if (this.chooser === true) {
	          if (this.selected) {
	            var selectedWidth = this.options.selectionWidth;

	            if (typeof selectedWidth === 'function') {
	              values.width = selectedWidth(values.width);
	            } else if (typeof selectedWidth === 'number') {
	              values.width += selectedWidth;
	            }

	            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
	            values.color = this.options.color.highlight;
	            values.shadow = this.options.shadow.enabled;
	          } else if (this.hover) {
	            var hoverWidth = this.options.hoverWidth;

	            if (typeof hoverWidth === 'function') {
	              values.width = hoverWidth(values.width);
	            } else if (typeof hoverWidth === 'number') {
	              values.width += hoverWidth;
	            }

	            values.width = Math.max(values.width, 0.3 / this.body.view.scale);
	            values.color = this.options.color.hover;
	            values.shadow = this.options.shadow.enabled;
	          }
	        } else if (typeof this.chooser === 'function') {
	          this.chooser(values, this.options.id, this.selected, this.hover);

	          if (values.color !== undefined) {
	            values.inheritsColor = false;
	          }

	          if (values.shadow === false) {
	            if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
	              values.shadow = true;
	            }
	          }
	        }
	      } else {
	        values.shadow = this.options.shadow.enabled;
	        values.width = Math.max(values.width, 0.3 / this.body.view.scale);
	      }

	      return values;
	    }
	    /**
	     * update the options in the label module
	     *
	     * @param {Object} options
	     */

	  }, {
	    key: "updateLabelModule",
	    value: function updateLabelModule(options) {
	      var pile = [options, this.options, this.globalOptions, // Currently set global edge options
	      this.defaultOptions];
	      this.labelModule.update(this.options, pile);

	      if (this.labelModule.baseSize !== undefined) {
	        this.baseFontSize = this.labelModule.baseSize;
	      }
	    }
	    /**
	     * update the edge type, set the options
	     * @returns {boolean}
	     */

	  }, {
	    key: "updateEdgeType",
	    value: function updateEdgeType() {
	      var smooth = this.options.smooth;
	      var dataChanged = false;
	      var changeInType = true;

	      if (this.edgeType !== undefined) {
	        if (this.edgeType instanceof BezierEdgeDynamic && smooth.enabled === true && smooth.type === 'dynamic' || this.edgeType instanceof CubicBezierEdge && smooth.enabled === true && smooth.type === 'cubicBezier' || this.edgeType instanceof BezierEdgeStatic && smooth.enabled === true && smooth.type !== 'dynamic' && smooth.type !== 'cubicBezier' || this.edgeType instanceof StraightEdge && smooth.type.enabled === false) {
	          changeInType = false;
	        }

	        if (changeInType === true) {
	          dataChanged = this.cleanup();
	        }
	      }

	      if (changeInType === true) {
	        if (smooth.enabled === true) {
	          if (smooth.type === 'dynamic') {
	            dataChanged = true;
	            this.edgeType = new BezierEdgeDynamic(this.options, this.body, this.labelModule);
	          } else if (smooth.type === 'cubicBezier') {
	            this.edgeType = new CubicBezierEdge(this.options, this.body, this.labelModule);
	          } else {
	            this.edgeType = new BezierEdgeStatic(this.options, this.body, this.labelModule);
	          }
	        } else {
	          this.edgeType = new StraightEdge(this.options, this.body, this.labelModule);
	        }
	      } else {
	        // if nothing changes, we just set the options.
	        this.edgeType.setOptions(this.options);
	      }

	      return dataChanged;
	    }
	    /**
	     * Connect an edge to its nodes
	     */

	  }, {
	    key: "connect",
	    value: function connect() {
	      this.disconnect();
	      this.from = this.body.nodes[this.fromId] || undefined;
	      this.to = this.body.nodes[this.toId] || undefined;
	      this.connected = this.from !== undefined && this.to !== undefined;

	      if (this.connected === true) {
	        this.from.attachEdge(this);
	        this.to.attachEdge(this);
	      } else {
	        if (this.from) {
	          this.from.detachEdge(this);
	        }

	        if (this.to) {
	          this.to.detachEdge(this);
	        }
	      }

	      this.edgeType.connect();
	    }
	    /**
	     * Disconnect an edge from its nodes
	     */

	  }, {
	    key: "disconnect",
	    value: function disconnect() {
	      if (this.from) {
	        this.from.detachEdge(this);
	        this.from = undefined;
	      }

	      if (this.to) {
	        this.to.detachEdge(this);
	        this.to = undefined;
	      }

	      this.connected = false;
	    }
	    /**
	     * get the title of this edge.
	     * @return {string} title    The title of the edge, or undefined when no title
	     *                           has been set.
	     */

	  }, {
	    key: "getTitle",
	    value: function getTitle() {
	      return this.title;
	    }
	    /**
	     * check if this node is selecte
	     * @return {boolean} selected   True if node is selected, else false
	     */

	  }, {
	    key: "isSelected",
	    value: function isSelected() {
	      return this.selected;
	    }
	    /**
	     * Retrieve the value of the edge. Can be undefined
	     * @return {number} value
	     */

	  }, {
	    key: "getValue",
	    value: function getValue() {
	      return this.options.value;
	    }
	    /**
	     * Adjust the value range of the edge. The edge will adjust it's width
	     * based on its value.
	     * @param {number} min
	     * @param {number} max
	     * @param {number} total
	     */

	  }, {
	    key: "setValueRange",
	    value: function setValueRange(min, max, total) {
	      if (this.options.value !== undefined) {
	        var scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
	        var widthDiff = this.options.scaling.max - this.options.scaling.min;

	        if (this.options.scaling.label.enabled === true) {
	          var fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
	          this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
	        }

	        this.options.width = this.options.scaling.min + scale * widthDiff;
	      } else {
	        this.options.width = this.baseWidth;
	        this.options.font.size = this.baseFontSize;
	      }

	      this._setInteractionWidths();

	      this.updateLabelModule();
	    }
	    /**
	     *
	     * @private
	     */

	  }, {
	    key: "_setInteractionWidths",
	    value: function _setInteractionWidths() {
	      if (typeof this.options.hoverWidth === 'function') {
	        this.edgeType.hoverWidth = this.options.hoverWidth(this.options.width);
	      } else {
	        this.edgeType.hoverWidth = this.options.hoverWidth + this.options.width;
	      }

	      if (typeof this.options.selectionWidth === 'function') {
	        this.edgeType.selectionWidth = this.options.selectionWidth(this.options.width);
	      } else {
	        this.edgeType.selectionWidth = this.options.selectionWidth + this.options.width;
	      }
	    }
	    /**
	     * Redraw a edge
	     * Draw this edge in the given canvas
	     * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
	     * @param {CanvasRenderingContext2D}   ctx
	     */

	  }, {
	    key: "draw",
	    value: function draw(ctx) {
	      var values = this.getFormattingValues();

	      if (values.hidden) {
	        return;
	      } // get the via node from the edge type


	      var viaNode = this.edgeType.getViaNode();
	      var arrowData = {}; // restore edge targets to defaults

	      this.edgeType.fromPoint = this.edgeType.from;
	      this.edgeType.toPoint = this.edgeType.to; // from and to arrows give a different end point for edges. we set them here

	      if (values.fromArrow) {
	        arrowData.from = this.edgeType.getArrowData(ctx, "from", viaNode, this.selected, this.hover, values);
	        if (values.arrowStrikethrough === false) this.edgeType.fromPoint = arrowData.from.core;

	        if (values.fromArrowSrc) {
	          arrowData.from.image = this.imagelist.load(values.fromArrowSrc);
	        }

	        if (values.fromArrowImageWidth) {
	          arrowData.from.imageWidth = values.fromArrowImageWidth;
	        }

	        if (values.fromArrowImageHeight) {
	          arrowData.from.imageHeight = values.fromArrowImageHeight;
	        }
	      }

	      if (values.toArrow) {
	        arrowData.to = this.edgeType.getArrowData(ctx, "to", viaNode, this.selected, this.hover, values);
	        if (values.arrowStrikethrough === false) this.edgeType.toPoint = arrowData.to.core;

	        if (values.toArrowSrc) {
	          arrowData.to.image = this.imagelist.load(values.toArrowSrc);
	        }

	        if (values.toArrowImageWidth) {
	          arrowData.to.imageWidth = values.toArrowImageWidth;
	        }

	        if (values.toArrowImageHeight) {
	          arrowData.to.imageHeight = values.toArrowImageHeight;
	        }
	      } // the middle arrow depends on the line, which can depend on the to and from arrows so we do this one lastly.


	      if (values.middleArrow) {
	        arrowData.middle = this.edgeType.getArrowData(ctx, "middle", viaNode, this.selected, this.hover, values);

	        if (values.middleArrowSrc) {
	          arrowData.middle.image = this.imagelist.load(values.middleArrowSrc);
	        }

	        if (values.middleArrowImageWidth) {
	          arrowData.middle.imageWidth = values.middleArrowImageWidth;
	        }

	        if (values.middleArrowImageHeight) {
	          arrowData.middle.imageHeight = values.middleArrowImageHeight;
	        }
	      } // draw everything


	      this.edgeType.drawLine(ctx, values, this.selected, this.hover, viaNode);
	      this.drawArrows(ctx, arrowData, values);
	      this.drawLabel(ctx, viaNode);
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {Object} arrowData
	     * @param {ArrowOptions} values
	     */

	  }, {
	    key: "drawArrows",
	    value: function drawArrows(ctx, arrowData, values) {
	      if (values.fromArrow) {
	        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.from);
	      }

	      if (values.middleArrow) {
	        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.middle);
	      }

	      if (values.toArrow) {
	        this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.to);
	      }
	    }
	    /**
	     *
	     * @param {CanvasRenderingContext2D} ctx
	     * @param {Node} viaNode
	     */

	  }, {
	    key: "drawLabel",
	    value: function drawLabel(ctx, viaNode) {
	      if (this.options.label !== undefined) {
	        // set style
	        var node1 = this.from;
	        var node2 = this.to;

	        if (this.labelModule.differentState(this.selected, this.hover)) {
	          this.labelModule.getTextSize(ctx, this.selected, this.hover);
	        }

	        if (node1.id != node2.id) {
	          this.labelModule.pointToSelf = false;
	          var point = this.edgeType.getPoint(0.5, viaNode);
	          ctx.save();

	          var rotationPoint = this._getRotation(ctx);

	          if (rotationPoint.angle != 0) {
	            ctx.translate(rotationPoint.x, rotationPoint.y);
	            ctx.rotate(rotationPoint.angle);
	          } // draw the label


	          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
	          /*
	                  // Useful debug code: draw a border around the label
	                  // This should **not** be enabled in production!
	                  var size = this.labelModule.getSize();; // ;; intentional so lint catches it
	                  ctx.strokeStyle = "#ff0000";
	                  ctx.strokeRect(size.left, size.top, size.width, size.height);
	                  // End  debug code
	          */

	          ctx.restore();
	        } else {
	          // Ignore the orientations.
	          this.labelModule.pointToSelf = true; // get circle coordinates

	          var coordinates = ComponentUtil.getSelfRefCoordinates(ctx, this.options.selfReference.angle, this.options.selfReference.size, node1);
	          point = this._pointOnCircle(coordinates.x, coordinates.y, this.options.selfReference.size, this.options.selfReference.angle);
	          this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
	        }
	      }
	    }
	    /**
	     * Determine all visual elements of this edge instance, in which the given
	     * point falls within the bounding shape.
	     *
	     * @param {point} point
	     * @returns {Array.<edgeClickItem|edgeLabelClickItem>} list with the items which are on the point
	     */

	  }, {
	    key: "getItemsOnPoint",
	    value: function getItemsOnPoint(point) {
	      var ret = [];

	      if (this.labelModule.visible()) {
	        var rotationPoint = this._getRotation();

	        if (ComponentUtil.pointInRect(this.labelModule.getSize(), point, rotationPoint)) {
	          ret.push({
	            edgeId: this.id,
	            labelId: 0
	          });
	        }
	      }

	      var obj = {
	        left: point.x,
	        top: point.y
	      };

	      if (this.isOverlappingWith(obj)) {
	        ret.push({
	          edgeId: this.id
	        });
	      }

	      return ret;
	    }
	    /**
	     * Check if this object is overlapping with the provided object
	     * @param {Object} obj   an object with parameters left, top
	     * @return {boolean}     True if location is located on the edge
	     */

	  }, {
	    key: "isOverlappingWith",
	    value: function isOverlappingWith(obj) {
	      if (this.connected) {
	        var distMax = 10;
	        var xFrom = this.from.x;
	        var yFrom = this.from.y;
	        var xTo = this.to.x;
	        var yTo = this.to.y;
	        var xObj = obj.left;
	        var yObj = obj.top;
	        var dist = this.edgeType.getDistanceToEdge(xFrom, yFrom, xTo, yTo, xObj, yObj);
	        return dist < distMax;
	      } else {
	        return false;
	      }
	    }
	    /** 
	     * Determine the rotation point, if any.
	     *
	     * @param {CanvasRenderingContext2D} [ctx] if passed, do a recalculation of the label size
	     * @returns {rotationPoint} the point to rotate around and the angle in radians to rotate
	     * @private
	     */

	  }, {
	    key: "_getRotation",
	    value: function _getRotation(ctx) {
	      var viaNode = this.edgeType.getViaNode();
	      var point = this.edgeType.getPoint(0.5, viaNode);

	      if (ctx !== undefined) {
	        this.labelModule.calculateLabelSize(ctx, this.selected, this.hover, point.x, point.y);
	      }

	      var ret = {
	        x: point.x,
	        y: this.labelModule.size.yLine,
	        angle: 0
	      };

	      if (!this.labelModule.visible()) {
	        return ret; // Don't even bother doing the atan2, there's nothing to draw
	      }

	      if (this.options.font.align === "horizontal") {
	        return ret; // No need to calculate angle
	      }

	      var dy = this.from.y - this.to.y;
	      var dx = this.from.x - this.to.x;
	      var angle = Math.atan2(dy, dx); // radians
	      // rotate so that label is readable

	      if (angle < -1 && dx < 0 || angle > 0 && dx < 0) {
	        angle += Math.PI;
	      }

	      ret.angle = angle;
	      return ret;
	    }
	    /**
	     * Get a point on a circle
	     * @param {number} x
	     * @param {number} y
	     * @param {number} radius
	     * @param {number} angle 
	     * @return {Object} point
	     * @private
	     */

	  }, {
	    key: "_pointOnCircle",
	    value: function _pointOnCircle(x, y, radius, angle) {
	      return {
	        x: x + radius * Math.cos(angle),
	        y: y - radius * Math.sin(angle)
	      };
	    }
	    /**
	     * Sets selected state to true
	     */

	  }, {
	    key: "select",
	    value: function select() {
	      this.selected = true;
	    }
	    /**
	     * Sets selected state to false
	     */

	  }, {
	    key: "unselect",
	    value: function unselect() {
	      this.selected = false;
	    }
	    /**
	     * cleans all required things on delete
	     * @returns {*}
	     */

	  }, {
	    key: "cleanup",
	    value: function cleanup() {
	      return this.edgeType.cleanup();
	    }
	    /**
	     * Remove edge from the list and perform necessary cleanup.
	     */

	  }, {
	    key: "remove",
	    value: function remove() {
	      this.cleanup();
	      this.disconnect();
	      delete this.body.edges[this.id];
	    }
	    /**
	     * Check if both connecting nodes exist
	     * @returns {boolean}
	     */

	  }, {
	    key: "endPointsValid",
	    value: function endPointsValid() {
	      return this.body.nodes[this.fromId] !== undefined && this.body.nodes[this.toId] !== undefined;
	    }
	  }], [{
	    key: "parseOptions",
	    value: function parseOptions(parentOptions, newOptions) {
	      var allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	      var globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
	      var copyFromGlobals = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
	      var fields = ['arrowStrikethrough', 'id', 'from', 'hidden', 'hoverWidth', 'labelHighlightBold', 'length', 'line', 'opacity', 'physics', 'scaling', 'selectionWidth', 'selfReferenceSize', 'selfReference', 'to', 'title', 'value', 'width', 'font', 'chosen', 'widthConstraint']; // only deep extend the items in the field array. These do not have shorthand.

	      selectiveDeepExtend(fields, parentOptions, newOptions, allowDeletion); // Only copy label if it's a legal value.

	      if (ComponentUtil.isValidLabel(newOptions.label)) {
	        parentOptions.label = newOptions.label;
	      } else if (!ComponentUtil.isValidLabel(parentOptions.label)) {
	        parentOptions.label = undefined;
	      }

	      mergeOptions(parentOptions, newOptions, 'smooth', globalOptions);
	      mergeOptions(parentOptions, newOptions, 'shadow', globalOptions);
	      mergeOptions(parentOptions, newOptions, 'background', globalOptions);

	      if (newOptions.dashes !== undefined && newOptions.dashes !== null) {
	        parentOptions.dashes = newOptions.dashes;
	      } else if (allowDeletion === true && newOptions.dashes === null) {
	        parentOptions.dashes = create$2(globalOptions.dashes); // this sets the pointer of the option back to the global option.
	      } // set the scaling newOptions


	      if (newOptions.scaling !== undefined && newOptions.scaling !== null) {
	        if (newOptions.scaling.min !== undefined) {
	          parentOptions.scaling.min = newOptions.scaling.min;
	        }

	        if (newOptions.scaling.max !== undefined) {
	          parentOptions.scaling.max = newOptions.scaling.max;
	        }

	        mergeOptions(parentOptions.scaling, newOptions.scaling, 'label', globalOptions.scaling);
	      } else if (allowDeletion === true && newOptions.scaling === null) {
	        parentOptions.scaling = create$2(globalOptions.scaling); // this sets the pointer of the option back to the global option.
	      } // handle multiple input cases for arrows


	      if (newOptions.arrows !== undefined && newOptions.arrows !== null) {
	        if (typeof newOptions.arrows === 'string') {
	          var arrows = newOptions.arrows.toLowerCase();
	          parentOptions.arrows.to.enabled = indexOf$3(arrows).call(arrows, "to") != -1;
	          parentOptions.arrows.middle.enabled = indexOf$3(arrows).call(arrows, "middle") != -1;
	          parentOptions.arrows.from.enabled = indexOf$3(arrows).call(arrows, "from") != -1;
	        } else if (_typeof_1(newOptions.arrows) === 'object') {
	          mergeOptions(parentOptions.arrows, newOptions.arrows, 'to', globalOptions.arrows);
	          mergeOptions(parentOptions.arrows, newOptions.arrows, 'middle', globalOptions.arrows);
	          mergeOptions(parentOptions.arrows, newOptions.arrows, 'from', globalOptions.arrows);
	        } else {
	          throw new Error("The arrow newOptions can only be an object or a string. Refer to the documentation. You used:" + stringify$2(newOptions.arrows));
	        }
	      } else if (allowDeletion === true && newOptions.arrows === null) {
	        parentOptions.arrows = create$2(globalOptions.arrows); // this sets the pointer of the option back to the global option.
	      } // handle multiple input cases for color


	      if (newOptions.color !== undefined && newOptions.color !== null) {
	        var fromColor = isString(newOptions.color) ? {
	          color: newOptions.color,
	          highlight: newOptions.color,
	          hover: newOptions.color,
	          inherit: false,
	          opacity: 1
	        } : newOptions.color;
	        var toColor = parentOptions.color; // If passed, fill in values from default options - required in the case of no prototype bridging

	        if (copyFromGlobals) {
	          deepExtend(toColor, globalOptions.color, false, allowDeletion);
	        } else {
	          // Clear local properties - need to do it like this in order to retain prototype bridges
	          for (var i in toColor) {
	            if (toColor.hasOwnProperty(i)) {
	              delete toColor[i];
	            }
	          }
	        }

	        if (isString(toColor)) {
	          toColor.color = toColor;
	          toColor.highlight = toColor;
	          toColor.hover = toColor;
	          toColor.inherit = false;

	          if (fromColor.opacity === undefined) {
	            toColor.opacity = 1.0; // set default
	          }
	        } else {
	          var colorsDefined = false;

	          if (fromColor.color !== undefined) {
	            toColor.color = fromColor.color;
	            colorsDefined = true;
	          }

	          if (fromColor.highlight !== undefined) {
	            toColor.highlight = fromColor.highlight;
	            colorsDefined = true;
	          }

	          if (fromColor.hover !== undefined) {
	            toColor.hover = fromColor.hover;
	            colorsDefined = true;
	          }

	          if (fromColor.inherit !== undefined) {
	            toColor.inherit = fromColor.inherit;
	          }

	          if (fromColor.opacity !== undefined) {
	            toColor.opacity = Math.min(1, Math.max(0, fromColor.opacity));
	          }

	          if (colorsDefined === true) {
	            toColor.inherit = false;
	          } else {
	            if (toColor.inherit === undefined) {
	              toColor.inherit = 'from'; // Set default
	            }
	          }
	        }
	      } else if (allowDeletion === true && newOptions.color === null) {
	        parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
	      }

	      if (allowDeletion === true && newOptions.font === null) {
	        parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
	      }

	      if (newOptions.hasOwnProperty("selfReferenceSize")) {
	        console.log('The selfReferenceSize property has been deprecated. Please use selfReference property instead. The selfReference can be set like thise selfReference:{size:30, angle:Math.PI / 4}');
	        parentOptions.selfReference.size = newOptions.selfReferenceSize;
	      }
	    }
	  }]);

	  return Edge;
	}();

	/**
	 * Handler for Edges
	 */

	var EdgesHandler = /*#__PURE__*/function () {
	  /**
	   * @param {Object} body
	   * @param {Array.<Image>} images
	   * @param {Array.<Group>} groups
	   */
	  function EdgesHandler(body, images, groups) {
	    var _context,
	        _this = this;

	    classCallCheck(this, EdgesHandler);

	    this.body = body;
	    this.images = images;
	    this.groups = groups; // create the edge API in the body container

	    this.body.functions.createEdge = bind$2(_context = this.create).call(_context, this);
	    this.edgesListeners = {
	      add: function add(event, params) {
	        _this.add(params.items);
	      },
	      update: function update(event, params) {
	        _this.update(params.items);
	      },
	      remove: function remove(event, params) {
	        _this.remove(params.items);
	      }
	    };
	    this.options = {};
	    this.defaultOptions = {
	      arrows: {
	        to: {
	          enabled: false,
	          scaleFactor: 1,
	          type: 'arrow'
	        },
	        // boolean / {arrowScaleFactor:1} / {enabled: false, arrowScaleFactor:1}
	        middle: {
	          enabled: false,
	          scaleFactor: 1,
	          type: 'arrow'
	        },
	        from: {
	          enabled: false,
	          scaleFactor: 1,
	          type: 'arrow'
	        }
	      },
	      arrowStrikethrough: true,
	      color: {
	        color: '#848484',
	        highlight: '#848484',
	        hover: '#848484',
	        inherit: 'from',
	        opacity: 1.0
	      },
	      dashes: false,
	      font: {
	        color: '#343434',
	        size: 14,
	        // px
	        face: 'arial',
	        background: 'none',
	        strokeWidth: 2,
	        // px
	        strokeColor: '#ffffff',
	        align: 'horizontal',
	        multi: false,
	        vadjust: 0,
	        bold: {
	          mod: 'bold'
	        },
	        boldital: {
	          mod: 'bold italic'
	        },
	        ital: {
	          mod: 'italic'
	        },
	        mono: {
	          mod: '',
	          size: 15,
	          // px
	          face: 'courier new',
	          vadjust: 2
	        }
	      },
	      hidden: false,
	      hoverWidth: 1.5,
	      label: undefined,
	      labelHighlightBold: true,
	      length: undefined,
	      physics: true,
	      scaling: {
	        min: 1,
	        max: 15,
	        label: {
	          enabled: true,
	          min: 14,
	          max: 30,
	          maxVisible: 30,
	          drawThreshold: 5
	        },
	        customScalingFunction: function customScalingFunction(min, max, total, value) {
	          if (max === min) {
	            return 0.5;
	          } else {
	            var scale = 1 / (max - min);
	            return Math.max(0, (value - min) * scale);
	          }
	        }
	      },
	      selectionWidth: 1.5,
	      selfReference: {
	        size: 20,
	        angle: Math.PI / 4,
	        renderBehindTheNode: true
	      },
	      shadow: {
	        enabled: false,
	        color: 'rgba(0,0,0,0.5)',
	        size: 10,
	        x: 5,
	        y: 5
	      },
	      background: {
	        enabled: false,
	        color: 'rgba(111,111,111,1)',
	        size: 10,
	        dashes: false
	      },
	      smooth: {
	        enabled: true,
	        type: "dynamic",
	        forceDirection: 'none',
	        roundness: 0.5
	      },
	      title: undefined,
	      width: 1,
	      value: undefined
	    };
	    deepExtend(this.options, this.defaultOptions);
	    this.bindEventListeners();
	  }
	  /**
	   * Binds event listeners
	   */


	  createClass(EdgesHandler, [{
	    key: "bindEventListeners",
	    value: function bindEventListeners() {
	      var _this2 = this,
	          _context2,
	          _context3;

	      // this allows external modules to force all dynamic curves to turn static.
	      this.body.emitter.on("_forceDisableDynamicCurves", function (type) {
	        var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

	        if (type === 'dynamic') {
	          type = 'continuous';
	        }

	        var dataChanged = false;

	        for (var edgeId in _this2.body.edges) {
	          if (_this2.body.edges.hasOwnProperty(edgeId)) {
	            var edge = _this2.body.edges[edgeId];

	            var edgeData = _this2.body.data.edges.get(edgeId); // only forcibly remove the smooth curve if the data has been set of the edge has the smooth curves defined.
	            // this is because a change in the global would not affect these curves.


	            if (edgeData != null) {
	              var smoothOptions = edgeData.smooth;

	              if (smoothOptions !== undefined) {
	                if (smoothOptions.enabled === true && smoothOptions.type === 'dynamic') {
	                  if (type === undefined) {
	                    edge.setOptions({
	                      smooth: false
	                    });
	                  } else {
	                    edge.setOptions({
	                      smooth: {
	                        type: type
	                      }
	                    });
	                  }

	                  dataChanged = true;
	                }
	              }
	            }
	          }
	        }

	        if (emit === true && dataChanged === true) {
	          _this2.body.emitter.emit("_dataChanged");
	        }
	      }); // this is called when options of EXISTING nodes or edges have changed.
	      //
	      // NOTE: Not true, called when options have NOT changed, for both existing as well as new nodes.
	      //       See update() for logic.
	      // TODO: Verify and examine the consequences of this. It might still trigger when
	      //       non-option fields have changed, but then reconnecting edges is still useless.
	      //       Alternatively, it might also be called when edges are removed.
	      //

	      this.body.emitter.on("_dataUpdated", function () {
	        _this2.reconnectEdges();
	      }); // refresh the edges. Used when reverting from hierarchical layout

	      this.body.emitter.on("refreshEdges", bind$2(_context2 = this.refresh).call(_context2, this));
	      this.body.emitter.on("refresh", bind$2(_context3 = this.refresh).call(_context3, this));
	      this.body.emitter.on("destroy", function () {
	        forEach$3(_this2.edgesListeners, function (callback, event) {
	          if (_this2.body.data.edges) _this2.body.data.edges.off(event, callback);
	        });
	        delete _this2.body.functions.createEdge;
	        delete _this2.edgesListeners.add;
	        delete _this2.edgesListeners.update;
	        delete _this2.edgesListeners.remove;
	        delete _this2.edgesListeners;
	      });
	    }
	    /**
	     *
	     * @param {Object} options
	     */

	  }, {
	    key: "setOptions",
	    value: function setOptions(options) {
	      if (options !== undefined) {
	        // use the parser from the Edge class to fill in all shorthand notations
	        Edge.parseOptions(this.options, options, true, this.defaultOptions, true); // update smooth settings in all edges

	        var dataChanged = false;

	        if (options.smooth !== undefined) {
	          for (var edgeId in this.body.edges) {
	            if (this.body.edges.hasOwnProperty(edgeId)) {
	              dataChanged = this.body.edges[edgeId].updateEdgeType() || dataChanged;
	            }
	          }
	        } // update fonts in all edges


	        if (options.font !== undefined) {
	          for (var _edgeId in this.body.edges) {
	            if (this.body.edges.hasOwnProperty(_edgeId)) {
	              this.body.edges[_edgeId].updateLabelModule();
	            }
	          }
	        } // update the state of the variables if needed


	        if (options.hidden !== undefined || options.physics !== undefined || dataChanged === true) {
	          this.body.emitter.emit('_dataChanged');
	        }
	      }
	    }
	    /**
	     * Load edges by reading the data table
	     * @param {Array | DataSet | DataView} edges    The data containing the edges.
	     * @param {boolean} [doNotEmit=false]
	     * @private
	     */

	  }, {
	    key: "setData",
	    value: function setData(edges) {
	      var _this3 = this;

	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var oldEdgesData = this.body.data.edges;

	      if (edges instanceof DataSet || edges instanceof DataView) {
	        this.body.data.edges = edges;
	      } else if (isArray$5(edges)) {
	        this.body.data.edges = new DataSet();
	        this.body.data.edges.add(edges);
	      } else if (!edges) {
	        this.body.data.edges = new DataSet();
	      } else {
	        throw new TypeError('Array or DataSet expected');
	      } // TODO: is this null or undefined or false?


	      if (oldEdgesData) {
	        // unsubscribe from old dataset
	        forEach$3(this.edgesListeners, function (callback, event) {
	          oldEdgesData.off(event, callback);
	        });
	      } // remove drawn edges


	      this.body.edges = {}; // TODO: is this null or undefined or false?

	      if (this.body.data.edges) {
	        // subscribe to new dataset
	        forEach$3(this.edgesListeners, function (callback, event) {
	          _this3.body.data.edges.on(event, callback);
	        }); // draw all new nodes

	        var ids = this.body.data.edges.getIds();
	        this.add(ids, true);
	      }

	      this.body.emitter.emit('_adjustEdgesForHierarchicalLayout');

	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }
	    /**
	     * Add edges
	     * @param {number[] | string[]} ids
	     * @param {boolean} [doNotEmit=false]
	     * @private
	     */

	  }, {
	    key: "add",
	    value: function add(ids) {
	      var doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	      var edges = this.body.edges;
	      var edgesData = this.body.data.edges;

	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        var oldEdge = edges[id];

	        if (oldEdge) {
	          oldEdge.disconnect();
	        }

	        var data = edgesData.get(id, {
	          "showInternalIds": true
	        });
	        edges[id] = this.create(data);
	      }

	      this.body.emitter.emit('_adjustEdgesForHierarchicalLayout');

	      if (doNotEmit === false) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }
	    /**
	     * Update existing edges, or create them when not yet existing
	     * @param {number[] | string[]} ids
	     * @private
	     */

	  }, {
	    key: "update",
	    value: function update(ids) {
	      var edges = this.body.edges;
	      var edgesData = this.body.data.edges;
	      var dataChanged = false;

	      for (var i = 0; i < ids.length; i++) {
	        var id = ids[i];
	        var data = edgesData.get(id);
	        var edge = edges[id];

	        if (edge !== undefined) {
	          // update edge
	          edge.disconnect();
	          dataChanged = edge.setOptions(data) || dataChanged; // if a support node is added, data can be changed.

	          edge.connect();
	        } else {
	          // create edge
	          this.body.edges[id] = this.create(data);
	          dataChanged = true;
	        }
	      }

	      if (dataChanged === true) {
	        this.body.emitter.emit('_adjustEdgesForHierarchicalLayout');
	        this.body.emitter.emit("_dataChanged");
	      } else {
	        this.body.emitter.emit("_dataUpdated");
	      }
	    }
	    /**
	     * Remove existing edges. Non existing ids will be ignored
	     * @param {number[] | string[]} ids
	     * @param {boolean} [emit=true]
	     * @private
	     */

	  }, {
	    key: "remove",
	    value: function remove(ids) {
	      var emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	      if (ids.length === 0) return; // early out

	      var edges = this.body.edges;
	      forEach$3(ids, function (id) {
	        var edge = edges[id];

	        if (edge !== undefined) {
	          edge.remove();
	        }
	      });

	      if (emit) {
	        this.body.emitter.emit("_dataChanged");
	      }
	    }
	    /**
	     * Refreshes Edge Handler
	     */

	  }, {
	    key: "refresh",
	    value: function refresh() {
	      var _this4 = this;

	      forEach$3(this.body.edges, function (edge, edgeId) {
	        var data = _this4.body.data.edges.get(edgeId);

	        if (data !== undefined) {
	          edge.setOptions(data);
	        }
	      });
	    }
	    /**
	     *
	     * @param {Object} properties
	     * @returns {Edge}
	     */

	  }, {
	    key: "create",
	    value: function create(properties) {
	      return new Edge(properties, this.body, this.images, this.options, this.defaultOptions);
	    }
	    /**
	     * Reconnect all edges
	     * @private
	     */

	  }, {
	    key: "reconnectEdges",
	    value: function reconnectEdges() {
	      var id;
	      var nodes = this.body.nodes;
	      var edges = this.body.edges;

	      for (id in nodes) {
	        if (nodes.hasOwnProperty(id)) {
	          nodes[id].edges = [];
	        }
	      }

	      for (id in edges) {
	        if (edges.hasOwnProperty(id)) {
	          var edge = edges[id];
	          edge.from = null;
	          edge.to = null;
	          edge.connect();
	        }
	      }
	    }
	    /**
	     *
	     * @param {Edge.id} edgeId
	     * @returns {Array}
	     */

	  }, {
	    key: "getConnectedNodes",
	    value: function getConnectedNodes(edgeId) {
	      var nodeList = [];

	      if (this.body.edges[edgeId] !== undefined) {
	        var edge = this.body.edges[edgeId];

	        if (edge.fromId !== undefined) {
	          nodeList.push(edge.fromId);
	        }

	        if (edge.toId !== undefined) {
	          nodeList.push(edge.toId);
	        }
	      }

	      return nodeList;
	    }
	    /**
	     * There is no direct relation between the nodes and the edges DataSet,
	     * so the right place to do call this is in the handler for event `_dataUpdated`.
	     */

	  }, {
	    key: "_updateState",
	    value: function _updateState() {
	      this._addMissingEdges();

	      this._removeInvalidEdges();
	    }
	    /**
	     * Scan for missing nodes and remove corresponding edges, if any.
	     * @private
	     */

	  }, {
	    key: "_removeInvalidEdges",
	    value: function _removeInvalidEdges() {
	      var _this5 = this;

	      var edgesToDelete = [];
	      forEach$3(this.body.edges, function (edge, id) {
	        var toNode = _this5.body.nodes[edge.toId];
	        var fromNode = _this5.body.nodes[edge.fromId]; // Skip clustering edges here, let the Clustering module handle those

	        if (toNode !== undefined && toNode.isCluster === true || fromNode !== undefined && fromNode.isCluster === true) {
	          return;
	        }

	        if (toNode === undefined || fromNode === undefined) {
	          edgesToDelete.push(id);
	        }
	      });
	      this.remove(edgesToDelete, false);
	    }
	    /**
	     * add all edges from dataset that are not in the cached state
	     * @private
	     */

	  }, {
	    key: "_addMissingEdges",
	    value: function _addMissingEdges() {
	      var edgesData = this.body.data.edges;

	      if (edgesData === undefined || edgesData === null) {
	        return; // No edges DataSet yet; can happen on startup 
	      }

	      var edges = this.body.edges;
	      var addIds = [];

	      forEach$2(edgesData).call(edgesData, function (edgeData, edgeId) {
	        var edge = edges[edgeId];

	        if (edge === undefined) {
	          addIds.push(edgeId);
	        }
	      });

	      this.add(addIds, true);
	    }
	  }]);

	  return EdgesHandler;
	}();

	/**
	 * Barnes Hut Solver
	 */

	var BarnesHutSolver = /*#__PURE__*/function () {
	  /**
	   * @param {Object} body
	   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
	   * @param {Object} options
	   */
	  function BarnesHutSolver(body, physicsBody, options) {
	    classCallCheck(this, BarnesHutSolver);

	    this.body = body;
	    this.physicsBody = physicsBody;
	    this.barnesHutTree;
	    this.setOptions(options);
	    this._rng = Alea("BARNES HUT SOLVER"); // debug: show grid
	    // this.body.emitter.on("afterDrawing", (ctx) => {this._debug(ctx,'#ff0000')})
	  }
	  /**
	   *
	   * @param {Object} options
	   */


	  createClass(BarnesHutSolver, [{
	    key: "setOptions",
	    value: function setOptions(options) {
	      this.options = options;
	      this.thetaInversed = 1 / this.options.theta; // if 1 then min distance = 0.5, if 0.5 then min distance = 0.5 + 0.5*node.shape.radius

	      this.overlapAvoidanceFactor = 1 - Math.max(0, Math.min(1, this.options.avoidOverlap));
	    }
	    /**
	     * This function calculates the forces the nodes apply on each other based on a gravitational model.
	     * The Barnes Hut method is used to speed up this N-body simulation.
	     *
	     * @private
	     */

	  }, {
	    key: "solve",
	    value: function solve() {
	      if (this.options.gravitationalConstant !== 0 && this.physicsBody.physicsNodeIndices.length > 0) {
	        var node;
	        var nodes = this.body.nodes;
	        var nodeIndices = this.physicsBody.physicsNodeIndices;
	        var nodeCount = nodeIndices.length; // create the tree

	        var barnesHutTree = this._formBarnesHutTree(nodes, nodeIndices); // for debugging


	        this.barnesHutTree = barnesHutTree; // place the nodes one by one recursively

	        for (var i = 0; i < nodeCount; i++) {
	          node = nodes[nodeIndices[i]];

	          if (node.options.mass > 0) {
	            // starting with root is irrelevant, it never passes the BarnesHutSolver condition
	            this._getForceContributions(barnesHutTree.root, node);
	          }
	        }
	      }
	    }
	    /**
	     * @param {Object} parentBranch
	     * @param {Node} node
	     * @private
	     */

	  }, {
	    key: "_getForceContributions",
	    value: function _getForceContributions(parentBranch, node) {
	      this._getForceContribution(parentBranch.children.NW, node);

	      this._getForceContribution(parentBranch.children.NE, node);

	      this._getForceContribution(parentBranch.children.SW, node);

	      this._getForceContribution(parentBranch.children.SE, node);
	    }
	    /**
	     * This function traverses the barnesHutTree. It checks when it can approximate distant nodes with their center of mass.
	     * If a region contains a single node, we check if it is not itself, then we apply the force.
	     *
	     * @param {Object} parentBranch
	     * @param {Node} node
	     * @private
	     */

	  }, {
	    key: "_getForceContribution",
	    value: function _getForceContribution(parentBranch, node) {
	      // we get no force contribution from an empty region
	      if (parentBranch.childrenCount > 0) {
	        var dx, dy, distance; // get the distance from the center of mass to the node.

	        dx = parentBranch.centerOfMass.x - node.x;
	        dy = parentBranch.centerOfMass.y - node.y;
	        distance = Math.sqrt(dx * dx + dy * dy); // BarnesHutSolver condition
	        // original condition : s/d < theta = passed  ===  d/s > 1/theta = passed
	        // calcSize = 1/s --> d * 1/s > 1/theta = passed

	        if (distance * parentBranch.calcSize > this.thetaInversed) {
	          this._calculateForces(distance, dx, dy, node, parentBranch);
	        } else {
	          // Did not pass the condition, go into children if available
	          if (parentBranch.childrenCount === 4) {
	            this._getForceContributions(parentBranch, node);
	          } else {
	            // parentBranch must have only one node, if it was empty we wouldnt be here
	            if (parentBranch.children.data.id != node.id) {
	              // if it is not self
	              this._calculateForces(distance, dx, dy, node, parentBranch);
	            }
	          }
	        }
	      }
	    }
	    /**
	     * Calculate the forces based on the distance.
	     *
	     * @param {number} distance
	     * @param {number} dx
	     * @param {number} dy
	     * @param {Node} node
	     * @param {Object} parentBranch
	     * @private
	     */

	  }, {
	    key: "_calculateForces",
	    value: function _calculateForces(distance, dx, dy, node, parentBranch) {
	      if (distance === 0) {
	        distance = 0.1;
	        dx = distance;
	      }

	      if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
	        distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
	      } // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
	      // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce


	      var gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass / Math.pow(distance, 3);
	      var fx = dx * gravityForce;
	      var fy = dy * gravityForce;
	      this.physicsBody.forces[node.id].x += fx;
	      this.physicsBody.forces[node.id].y += fy;
	    }
	    /**
	     * This function constructs the barnesHut tree recursively. It creates the root, splits it and starts placing the nodes.
	     *
	     * @param {Array.<Node>} nodes
	     * @param {Array.<number>} nodeIndices
	     * @returns {{root: {centerOfMass: {x: number, y: number}, mass: number, range: {minX: number, maxX: number, minY: number, maxY: number}, size: number, calcSize: number, children: {data: null}, maxWidth: number, level: number, childrenCount: number}}} BarnesHutTree
	     * @private
	     */

	  }, {
	    key: "_formBarnesHutTree",
	    value: function _formBarnesHutTree(nodes, nodeIndices) {
	      var node;
	      var nodeCount = nodeIndices.length;
	      var minX = nodes[nodeIndices[0]].x;
	      var minY = nodes[nodeIndices[0]].y;
	      var maxX = nodes[nodeIndices[0]].x;
	      var maxY = nodes[nodeIndices[0]].y; // get the range of the nodes

	      for (var i = 1; i < nodeCount; i++) {
	        var _node = nodes[nodeIndices[i]];
	        var x = _node.x;
	        var y = _node.y;

	        if (_node.options.mass > 0) {
	          if (x < minX) {
	            minX = x;
	          }

	          if (x > maxX) {
	            maxX = x;
	          }

	          if (y < minY) {
	            minY = y;
	          }

	          if (y > maxY) {
	            maxY = y;
	          }
	        }
	      } // make the range a square


	      var sizeDiff = Math.abs(maxX - minX) - Math.abs(maxY - minY); // difference between X and Y

	      if (sizeDiff > 0) {
	        minY -= 0.5 * sizeDiff;
	        maxY += 0.5 * sizeDiff;
	      } // xSize > ySize
	      else {
	          minX += 0.5 * sizeDiff;
	          maxX -= 0.5 * sizeDiff;
	        } // xSize < ySize


	      var minimumTreeSize = 1e-5;
	      var rootSize = Math.max(minimumTreeSize, Math.abs(maxX - minX));
	      var halfRootSize = 0.5 * rootSize;
	      var centerX = 0.5 * (minX + maxX),
	          centerY = 0.5 * (minY + maxY); // construct the barnesHutTree

	      var barnesHutTree = {
	        root: {
	          centerOfMass: {
	            x: 0,
	            y: 0
	          },
	          mass: 0,
	          range: {
	            minX: centerX - halfRootSize,
	            maxX: centerX + halfRootSize,
	            minY: centerY - halfRootSize,
	            maxY: centerY + halfRootSize
	          },
	          size: rootSize,
	          calcSize: 1 / rootSize,
	          children: {
	            data: null
	          },
	          maxWidth: 0,
	          level: 0,
	          childrenCount: 4
	        }
	      };

	      this._splitBranch(barnesHutTree.root); // place the nodes one by one recursively


	      for (var _i = 0; _i < nodeCount; _i++) {
	        node = nodes[nodeIndices[_i]];

	        if (node.options.mass > 0) {
	          this._placeInTree(barnesHutTree.root, node);
	        }
	      } // make global


	      return barnesHutTree;
	    }
	    /**
	     * this updates the mass of a branch. this is increased by adding a node.
	     *
	     * @param {Object} parentBranch
	     * @param {Node} node
	     * @private
	     */

	  }, {
	    key: "_updateBranchMass",
	    value: function _updateBranchMass(parentBranch, node) {
	      var centerOfMass = parentBranch.centerOfMass;
	      var totalMass = parentBranch.mass + node.options.mass;
	      var totalMassInv = 1 / totalMass;
	      centerOfMass.x = centerOfMass.x * parentBranch.mass + node.x * node.options.mass;
	      centerOfMass.x *= totalMassInv;
	      centerOfMass.y = centerOfMass.y * parentBranch.mass + node.y * node.options.mass;
	      centerOfMass.y *= totalMassInv;
	      parentBranch.mass = totalMass;
	      var biggestSize = Math.max(Math.max(node.height, node.radius), node.width);
	      parentBranch.maxWidth = parentBranch.maxWidth < biggestSize ? biggestSize : parentBranch.maxWidth;
	    }
	    /**
	     * determine in which branch the node will be placed.
	     *
	     * @param {Object} parentBranch
	     * @param {Node} node
	     * @param {boolean} skipMassUpdate
	     * @private
	     */

	  }, {
	    key: "_placeInTree",
	    value: function _placeInTree(parentBranch, node, skipMassUpdate) {
	      if (skipMassUpdate != true || skipMassUpdate === undefined) {
	        // update the mass of the branch.
	        this._updateBranchMass(parentBranch, node);
	      }

	      var range = parentBranch.children.NW.range;
	      var region;

	      if (range.maxX > node.x) {
	        // in NW or SW
	        if (range.maxY > node.y) {
	          region = "NW";
	        } else {
	          region = "SW";
	        }
	      } else {
	        // in NE or SE
	        if (range.maxY > node.y) {
	          region = "NE";
	        } else {
	          region = "SE";
	        }
	      }

	      this._placeInRegion(parentBranch, node, region);
	    }
	    /**
	     * actually place the node in a region (or branch)
	     *
	     * @param {Object} parentBranch
	     * @param {Node} node
	     * @param {'NW'| 'NE' | 'SW' | 'SE'} region
	     * @private
	     */

	  }, {
	    key: "_placeInRegion",
	    value: function _placeInRegion(parentBranch, node, region) {
	      var children = parentBranch.children[region];

	      switch (children.childrenCount) {
	        case 0:
	          // place node here
	          children.children.data = node;
	          children.childrenCount = 1;

	          this._updateBranchMass(children, node);

	          break;

	        case 1:
	          // convert into children
	          // if there are two nodes exactly overlapping (on init, on opening of cluster etc.)
	          // we move one node a little bit and we do not put it in the tree.
	          if (children.children.data.x === node.x && children.children.data.y === node.y) {
	            node.x += this._rng();
	            node.y += this._rng();
	          } else {
	            this._splitBranch(children);

	            this._placeInTree(children, node);
	          }

	          break;

	        case 4:
	          // place in branch
	          this._placeInTree(children, node);

	          break;
	      }
	    }
	    /**
	     * this function splits a branch into 4 sub branches. If the branch contained a node, we place it in the s