/**
 * The namespace for platform related utilities.
 */
export declare namespace Platform {
    /**
     * A flag indicating whether the platform is Mac.
     */
    const IS_MAC: boolean;
    /**
     * A flag indicating whether the platform is Windows.
     */
    const IS_WIN: boolean;
    /**
     * A flag indicating whether the browser is IE.
     */
    const IS_IE: boolean;
    /**
     * A flag indicating whether the browser is Edge.
     */
    const IS_EDGE: boolean;
    /**
     * Test whether the `accel` key is pressed.
     *
     * @param event - The keyboard or mouse event of interest.
     *
     * @returns Whether the `accel` key is pressed.
     *
     * #### Notes
     * On Mac the `accel` key is the command key. On all other
     * platforms the `accel` key is the control key.
     */
    function accelKey(event: KeyboardEvent | MouseEvent): boolean;
}
