"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
const default_1 = require("./default");
/**
 * The namespace for ISession statics.
 */
var TerminalSession;
(function (TerminalSession) {
    /**
     * Test whether the terminal service is available.
     */
    function isAvailable() {
        return default_1.DefaultTerminalSession.isAvailable();
    }
    TerminalSession.isAvailable = isAvailable;
    /**
     * Start a new terminal session.
     *
     * @param options - The session options to use.
     *
     * @returns A promise that resolves with the session instance.
     */
    function startNew(options) {
        return default_1.DefaultTerminalSession.startNew(options);
    }
    TerminalSession.startNew = startNew;
    /*
     * Connect to a running session.
     *
     * @param name - The name of the target session.
     *
     * @param options - The session options to use.
     *
     * @returns A promise that resolves with the new session instance.
     *
     * #### Notes
     * If the session was already started via `startNew`, the existing
     * session object is used as the fulfillment value.
     *
     * Otherwise, if `options` are given, we resolve the promise after
     * confirming that the session exists on the server.
     *
     * If the session does not exist on the server, the promise is rejected.
     */
    function connectTo(name, options) {
        return default_1.DefaultTerminalSession.connectTo(name, options);
    }
    TerminalSession.connectTo = connectTo;
    /**
     * List the running terminal sessions.
     *
     * @param settings - The server settings to use.
     *
     * @returns A promise that resolves with the list of running session models.
     */
    function listRunning(settings) {
        return default_1.DefaultTerminalSession.listRunning(settings);
    }
    TerminalSession.listRunning = listRunning;
    /**
     * Shut down a terminal session by name.
     *
     * @param name - The name of the target session.
     *
     * @param settings - The server settings to use.
     *
     * @returns A promise that resolves when the session is shut down.
     */
    function shutdown(name, settings) {
        return default_1.DefaultTerminalSession.shutdown(name, settings);
    }
    TerminalSession.shutdown = shutdown;
    /**
     * Shut down all terminal sessions.
     *
     * @returns A promise that resolves when all of the sessions are shut down.
     */
    function shutdownAll(settings) {
        return default_1.DefaultTerminalSession.shutdownAll(settings);
    }
    TerminalSession.shutdownAll = shutdownAll;
})(TerminalSession = exports.TerminalSession || (exports.TerminalSession = {}));
//# sourceMappingURL=terminal.js.map