# Table of contents

* [Product overview](README.md)
* [Getting started](getting-started.md)
* [Sending data to Launchable](sending-data-to-launchable/README.md)
  * [Choosing a value for \<BUILD NAME>](sending-data-to-launchable/choosing-a-value-for-build-name.md)
  * [Converting test reports to JUnit format](sending-data-to-launchable/converting-test-reports-to-junit-format.md)
  * [Ensuring \`record tests\` always runs](sending-data-to-launchable/ensuring-record-tests-always-runs.md)
  * [Managing complex test session layouts](sending-data-to-launchable/managing-complex-test-session-layouts.md)
  * [Recording builds from multiple repositories](sending-data-to-launchable/recording-builds-from-multiple-repositories.md)
  * [Using 'flavors' to run the best tests for an environment](sending-data-to-launchable/use-flavors-to-run-the-best-tests-for-an-environment.md)
  * [Using the CLI with a public repository](sending-data-to-launchable/using-the-cli-with-a-public-repository.md)

## Features

* [Predictive Test Selection](features/predictive-test-selection/README.md)
  * [Planning your subset implementation](features/predictive-test-selection/planning-your-subset-implementation.md)
  * [Training a predictive model with your data](features/predictive-test-selection/training-a-predictive-model-with-your-data.md)
  * [Requesting and running a subset of tests](features/predictive-test-selection/requesting-and-running-a-subset-of-tests/README.md)
    * [Replacing static parallel suites with a dynamic parallel subset](features/predictive-test-selection/requesting-and-running-a-subset-of-tests/replacing-static-parallel-suites-with-a-dynamic-parallel-subset.md)
    * [Zero Input Subsetting](features/predictive-test-selection/requesting-and-running-a-subset-of-tests/zero-input-subsetting.md)
  * [Choosing a subset optimization target](features/predictive-test-selection/choosing-a-subset-optimization-target.md)
  * [Observing subset behavior](features/predictive-test-selection/observing-subset-behavior/README.md)
    * ["Training wheels" mode with the --rest option](features/predictive-test-selection/observing-subset-behavior/training-wheels-mode-with-the-rest-option.md)
  * [Running subsets in your pipeline](features/predictive-test-selection/running-subsets-in-your-pipeline.md)
  * [How Launchable selects tests](features/predictive-test-selection/how-launchable-selects-tests.md)
  * [FAQ](features/predictive-test-selection/faq.md)
* [Test Insights](features/insights/README.md)
  * [Trends](features/insights/trends.md)
  * [Flaky Tests](features/insights/flaky-tests.md)
* [Test results and reports](features/test-results-and-reports.md)
* [Test notifications via Slack](features/test-notifications-via-slack.md)

## Concepts

* [Object model](concepts/object-model.md)
* [Organization](concepts/organization.md)
* [Workspace](concepts/workspace.md)
* [Build](concepts/build.md)
* [Test session](concepts/test-session.md)
* [Subset](concepts/subset.md)
* [Insight](concepts/insight.md)

## Resources

* [CLI reference](resources/cli-reference.md)
* [Integrations](resources/integrations/README.md)
  * [Android Debug Bridge (adb)](resources/integrations/adb.md)
  * [Ant](resources/integrations/ant.md)
  * [Bazel](resources/integrations/bazel.md)
  * [Behave](resources/integrations/behave.md)
  * [CTest](resources/integrations/ctest.md)
  * [cucumber](resources/integrations/cucumber.md)
  * [Cypress](resources/integrations/cypress.md)
  * [\`file\` profile for unsupported test runners](resources/integrations/using-the-generic-file-based-runner-integration.md)
  * [GoogleTest](resources/integrations/googletest.md)
  * [Go Test](resources/integrations/go-test.md)
  * [Gradle](resources/integrations/gradle.md)
  * [Jest](resources/integrations/jest.md)
  * [Maven](resources/integrations/maven.md)
  * [minitest](resources/integrations/minitest.md)
  * [nose](resources/integrations/nose.md)
  * [NUnit](resources/integrations/nunit.md)
  * [pytest](resources/integrations/pytest.md)
  * [\`raw\` profile for custom test runners](resources/integrations/raw.md)
  * [Robot](resources/integrations/robot.md)
  * [RSpec](resources/integrations/rspec.md)
* [Supported languages](resources/supported-languages/README.md)
  * [C++](resources/supported-languages/c-plus-plus.md)
  * [.NET](resources/supported-languages/dotnet.md)
  * [Go](resources/supported-languages/go.md)
  * [Java](resources/supported-languages/java.md)
  * [JavaScript](resources/supported-languages/javascript.md)
  * [Python](resources/supported-languages/python.md)
  * [Ruby](resources/supported-languages/ruby.md)
* [Supported test frameworks](resources/supported-test-frameworks/README.md)
  * [Appium](resources/supported-test-frameworks/appium.md)
  * [Cucumber](resources/supported-test-frameworks/cucumber.md)
  * [JUnit](resources/supported-test-frameworks/junit.md)
  * [GoogleTest](resources/supported-test-frameworks/googletest.md)
  * [Jest](resources/supported-test-frameworks/jest.md)
  * [minitest](resources/supported-test-frameworks/minitest.md)
  * [nose](resources/supported-test-frameworks/nose.md)
  * [NUnit](resources/supported-test-frameworks/nunit.md)
  * [Robot](resources/supported-test-frameworks/robot.md)
  * [RSpec](resources/supported-test-frameworks/rspec.md)
  * [Selenium](resources/supported-test-frameworks/selenium.md)
  * [TestNG](resources/supported-test-frameworks/testng.md)
* [Troubleshooting](resources/troubleshooting.md)
* [Launchable product rollout](resources/launchable-product-rollout.md)

## Policies

* [Data privacy and protection](policies/data-privacy-and-protection/README.md)
  * [Data examples](policies/data-privacy-and-protection/data-examples.md)
* [Security policies](policies/security-policies.md)
