#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['fastapi',
 'fastapi.dependencies',
 'fastapi.middleware',
 'fastapi.openapi',
 'fastapi.security']

package_data = \
{'': ['*']}

install_requires = \
['starlette ==0.14.2',
 'pydantic >=1.6.2,!=1.7,!=1.7.1,!=1.7.2,!=1.7.3,!=1.8,!=1.8.1,<2.0.0']

extras_require = \
{'all': ['requests >=2.24.0,<3.0.0',
         'aiofiles >=0.5.0,<0.8.0',
         'jinja2 >=2.11.2,<3.0.0',
         'python-multipart >=0.0.5,<0.0.6',
         'itsdangerous >=1.1.0,<2.0.0',
         'pyyaml >=5.3.1,<6.0.0',
         'graphene >=2.1.8,<3.0.0',
         'ujson >=4.0.1,<5.0.0',
         'orjson >=3.2.1,<4.0.0',
         'email_validator >=1.1.1,<2.0.0',
         'uvicorn[standard] >=0.12.0,<0.16.0'],
 "all:python_version < '3.7'": ['async_exit_stack >=1.0.1,<2.0.0',
                                'async_generator >=1.10,<2.0.0'],
 'dev': ['python-jose[cryptography] >=3.3.0,<4.0.0',
         'passlib[bcrypt] >=1.7.2,<2.0.0',
         'autoflake >=1.4.0,<2.0.0',
         'flake8 >=3.8.3,<4.0.0',
         'uvicorn[standard] >=0.12.0,<0.16.0',
         'graphene >=2.1.8,<3.0.0'],
 'doc': ['mkdocs >=1.1.2,<2.0.0',
         'mkdocs-material >=7.1.9,<8.0.0',
         'mdx-include >=1.4.1,<2.0.0',
         'mkdocs-markdownextradata-plugin >=0.1.7,<0.3.0',
         'typer-cli >=0.0.12,<0.0.13',
         'pyyaml >=5.3.1,<6.0.0'],
 'test': ['pytest >=6.2.4,<7.0.0',
          'pytest-cov >=2.12.0,<4.0.0',
          'pytest-asyncio >=0.14.0,<0.16.0',
          'mypy ==0.910',
          'flake8 >=3.8.3,<4.0.0',
          'black ==21.9b0',
          'isort >=5.0.6,<6.0.0',
          'requests >=2.24.0,<3.0.0',
          'httpx >=0.14.0,<0.19.0',
          'email_validator >=1.1.1,<2.0.0',
          'sqlalchemy >=1.3.18,<1.5.0',
          'peewee >=3.13.3,<4.0.0',
          'databases[sqlite] >=0.3.2,<0.6.0',
          'orjson >=3.2.1,<4.0.0',
          'ujson >=4.0.1,<5.0.0',
          'python-multipart >=0.0.5,<0.0.6',
          'aiofiles >=0.5.0,<0.8.0',
          'flask >=1.1.2,<2.0.0',
          'types-ujson ==0.1.1',
          'types-orjson ==3.6.0'],
 "test:python_version < '3.7'": ['async_exit_stack >=1.0.1,<2.0.0',
                                 'async_generator >=1.10,<2.0.0'],
 "test:python_version<'3.7'": ['types-dataclasses ==0.1.7']}

setup(name='fastapi',
      version='0.68.2',
      description='FastAPI framework, high performance, easy to learn, fast to code, ready for production',
      author='Sebastián Ramírez',
      author_email='tiangolo@gmail.com',
      url='https://github.com/tiangolo/fastapi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6.1',
     )
