# -*- coding: utf-8 -*-
"""
Test suite for the community-developed Python SDK for interacting with Lacework APIs.
"""

import pytest

from laceworksdk.api.v2.vulnerability_exceptions import VulnerabilityExceptionsAPI
from tests.api.test_crud_endpoint import CrudEndpoint


# Tests

@pytest.fixture(scope="module")
def api_object(api):
    return api.vulnerability_exceptions


@pytest.fixture(scope="module")
def api_object_create_body(random_text):
    return {
        "exception_name": f"Test Container Exception {random_text}",
        "exception_reason": "Accepted Risk",
        "exception_type": "Container",
        "vulnerability_criteria": {
            "severity": ["Info", "Low"],
            "fixable": [0]
        },
        "props": {
            "description": f"Test Container Exception Description {random_text}"
        }
    }


@pytest.fixture(scope="module")
def api_object_update_body(random_text):
    return {
        "exception_name": f"Test Container Exception {random_text} (Updated)",
        "vulnerability_criteria": {
            "severity": ["Medium"]
        },
        "props": {
            "description": f"Test Container Exception Description {random_text} (Updated)"
        }
    }


class TestVulnerabilityExceptions(CrudEndpoint):

    OBJECT_ID_NAME = "exceptionGuid"
    OBJECT_TYPE = VulnerabilityExceptionsAPI

    def test_api_get_by_guid(self, api_object):
        self._get_object_classifier_test(api_object, "guid", self.OBJECT_ID_NAME)
