# -*- coding: utf-8 -*-
"""
Lacework VulnerabilityExceptions API wrapper.
"""

from laceworksdk.api.crud_endpoint import CrudEndpoint


class VulnerabilityExceptionsAPI(CrudEndpoint):

    def __init__(self, session):
        """
        Initializes the VulnerabilityExceptionsAPI object.

        :param session: An instance of the HttpSession class

        :return VulnerabilityExceptionsAPI object.
        """

        super().__init__(session, "VulnerabilityExceptions")

    def create(self,
               exception_name,
               exception_reason,
               exception_type,
               props,
               vulnerability_criteria,
               resource_scope=None,
               expiry_time=None,
               state=True,
               **request_params):
        """
        A method to create a new VulnerabilityExceptions object.

        :param exception_name: A string representing the name of the exception.
        :param exception_reason: A string representing the exception reason.
            ("False Positive", "Accepted Risk", "Compensating Controls", "Fix Pending", "Other")
        :param exception_type: A string representing the exception type.
            ("Container", "Host")
        :param props: An object containing properties of the exception.
            obj:
                :param description: A string representing the exception description.
                :param createdBy: A string representing the creator of the exception.
                :param updatedBy: A string representing the updator of the exception.
        :param vulnerability_criteria: An object containing criteria for excepted vulnerabilities.
            obj:
                :param cve: A list of strings representing CVEs.
                :param package: A list of objects representing packages.
                :param severity: A list of strings representing severities.
                    ("Info", "Low", "Medium", "High", "Critical")
                :param fixable: A list of numbers representing the fixability status.
        :param resource_scope: An object containing the scope of resources for which to apply the exception.
            obj:
                :param imageId: A list of strings representing image IDs.
                :param imageTag: A list of strings representing image tags.
                :param registry: A list of strings representing container registries.
                :param repository: A list of strings representing container repositories.
                :param namespace: A list of strings representing package namespaces.
        :param expiry_time: A string representing the expiration time for the exception.
        :param state: A boolean representing the state of the exception.
        :param request_params: Additional request parameters.
            (provides support for parameters that may be added in the future)

        :return response json
        """

        return super().create(
            exception_name=exception_name,
            exception_reason=exception_reason,
            exception_type=exception_type,
            props=props,
            vulnerability_criteria=vulnerability_criteria,
            resource_scope=resource_scope,
            expiry_time=expiry_time,
            state=int(bool(state)),
            **request_params
        )

    def get(self,
            guid=None):
        """
        A method to get VulnerabilityExceptions objects.

        :param guid: A string representing the object GUID.

        :return response json
        """

        return super().get(id=guid)

    def get_by_guid(self,
                    guid):
        """
        A method to get a VulnerabilityExceptions object by GUID.

        :param guid: A string representing the object GUID.

        :return response json
        """

        return self.get(guid=guid)

    def update(self,
               guid,
               exception_name=None,
               exception_reason=None,
               props=None,
               vulnerability_criteria=None,
               resource_scope=None,
               expiry_time=None,
               state=None,
               **request_params):
        """
        A method to update a VulnerabilityExceptions object.

        :param guid: A string representing the object GUID.
        :param exception_name: A string representing the name of the exception.
        :param exception_reason: A string representing the exception reason.
            ("False Positive", "Accepted Risk", "Compensating Controls", "Fix Pending", "Other")
        :param exception_type: A string representing the exception type.
            ("Container", "Host")
        :param props: An object containing properties of the exception.
            obj:
                :param description: A string representing the exception description.
                :param createdBy: A string representing the creator of the exception.
                :param updatedBy: A string representing the updator of the exception.
        :param vulnerability_criteria: An object containing criteria for excepted vulnerabilities.
            obj:
                :param cve: A list of strings representing CVEs.
                :param package: A list of objects representing packages.
                :param severity: A list of strings representing severities.
                    ("Info", "Low", "Medium", "High", "Critical")
                :param fixable: A list of numbers representing the fixability status.
        :param resource_scope: An object containing the scope of resources for which to apply the exception.
            obj:
                :param imageId: A list of strings representing image IDs.
                :param imageTag: A list of strings representing image tags.
                :param registry: A list of strings representing container registries.
                :param repository: A list of strings representing container repositories.
                :param namespace: A list of strings representing package namespaces.
        :param expiry_time: A string representing the expiration time for the exception.
        :param state: A boolean representing the state of the exception.
        :param request_params: Additional request parameters.
            (provides support for parameters that may be added in the future)

        :return response json
        """

        if state is not None:
            state = int(bool(state))

        return super().update(
            id=guid,
            exception_name=exception_name,
            exception_reason=exception_reason,
            props=props,
            vulnerability_criteria=vulnerability_criteria,
            resource_scope=resource_scope,
            expiry_time=expiry_time,
            state=state,
            **request_params
        )

    def delete(self,
               guid):
        """
        A method to delete a VulnerabilityExceptions object.

        :param guid: A string representing the object GUID.

        :return response json
        """

        return super().delete(id=guid)
